(ns reveal.cursor
  (:refer-clojure :exclude [min max]))

(defn before? [a b]
  (neg? (compare a b)))

(defn row [cursor]
  (nth cursor 0))

(defn col [cursor]
  (nth cursor 1))

(defn min [a b]
  (if (before? a b) a b))

(defn max [a b]
  (if (before? a b) b a))

(defn- scan-cursor [cursor lines row-direction col-direction]
  (when (pos? (count lines))
    (loop [[row col] cursor]
      (let [next-col (col-direction col)]
        (if (<= 0 next-col (dec (count (get lines row))))
          [row next-col]
          (let [next-row (row-direction row)]
            (when (<= 0 next-row (dec (count lines)))
              (recur [next-row (condp = col-direction
                                 inc -1
                                 dec (count (lines next-row)))]))))))))

(defn scan [cursor lines row-direction col-direction pred]
  (loop [cursor cursor]
    (when-let [next-cursor (scan-cursor cursor lines row-direction col-direction)]
      (if (pred (get-in lines next-cursor))
        next-cursor
        (recur next-cursor)))))