(ns reveal.css
  (:require [reveal.url :as url])
  (:import [java.net URLStreamHandler URLConnection URL]
           [java.io ByteArrayInputStream]
           [clojure.lang IFn]))

(set! *warn-on-reflection* true)

(defn- hydrate [m x]
  (cond
    (map? x) (reduce-kv #(assoc %1 %2 (hydrate m %3)) x x)
    (vector? x) (recur m (get-in m x))
    :else x))

(defn- write [^StringBuilder acc path m]
  (doseq [[k v] m
          :when (string? k)
          :let [path (str path k)]]
    (.append acc path)
    (.append acc " {\n")
    (doseq [[sub-k sub-v] v
            :when (keyword? sub-k)]
      (.append acc "  ")
      (.append acc (name sub-k))
      (.append acc ": ")
      (.append acc (if (keyword? sub-v) (name sub-v) sub-v))
      (.append acc ";\n"))
    (.append acc "}\n")
    (write acc path v)))

(defrecord Css []
  IFn
  (invoke [this]
    (let [acc (StringBuilder.)]
      (write acc "" this)
      (.toString acc)))
  (invoke [this x]
    (hydrate this x)))

(defn make [m]
  (map->Css (hydrate m m)))

(defn url
  ([sym]
   (str "reveal-css:?" (str sym)))
  ([sym css]
   (str "reveal-css:?" (str sym) "#" (hash css))))

(defmethod url/make-handler "reveal-css" [_]
  (proxy [URLStreamHandler] []
    (openConnection [^URL url]
      (proxy [URLConnection] [url]
        (connect [])
        (getInputStream []
          (let [^String css ((requiring-resolve (symbol (.getQuery url))))]
            (ByteArrayInputStream. (.getBytes css "UTF-8"))))))))
