/*
 * Decompiled with CFR 0.152.
 */
package com.github.vivekkothari;

import com.github.vivekkothari.EnvironmentVariableLookup;
import java.io.InputStream;
import java.util.Scanner;
import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.yaml.snakeyaml.Yaml;

public class YamlParser {
    public static <T> T load(String yaml, Class<T> type) {
        Yaml yml = new Yaml();
        return (T)yml.loadAs(yaml, type);
    }

    public static <T> T load(InputStream is, Class<T> type) {
        Yaml yml = new Yaml();
        return (T)yml.loadAs(is, type);
    }

    public static <T> T loadWithEnvironmentResolution(InputStream is, Class<T> type) {
        return YamlParser.loadWithEnvironmentResolution(YamlParser.convertStreamToString(is), type);
    }

    public static <T> T loadWithEnvironmentResolution(String yaml, Class<T> type) {
        return YamlParser.loadWithEnvironmentResolution(yaml, type, new EnvironmentVariableLookup());
    }

    private static String convertStreamToString(InputStream is) {
        try (Scanner s = new Scanner(is).useDelimiter("\\A");){
            String string = s.hasNext() ? s.next() : "";
            return string;
        }
    }

    public static <T> T loadWithEnvironmentResolution(String yaml, Class<T> type, StrLookup lookup) {
        Yaml yml = new Yaml();
        StrSubstitutor substitutor = new StrSubstitutor(lookup);
        String replacedConfig = substitutor.replace(yaml);
        return (T)yml.loadAs(replacedConfig, type);
    }
}

