/* Generated By:JavaCC: Do not edit this line. PDDL21parser.java */
package javaff.parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javaff.data.DomainRequirements;
import javaff.data.Fact;
import javaff.data.GroundFact;
import javaff.data.Literal;
import javaff.data.Parameter;
import javaff.data.Requirement;
import javaff.data.Type;
import javaff.data.UngroundFact;
import javaff.data.UngroundProblem;
import javaff.data.adl.ConditionalEffect;
import javaff.data.adl.Exists;
import javaff.data.adl.ForAll;
import javaff.data.adl.Imply;
import javaff.data.adl.Or;
import javaff.data.metric.BinaryComparator;
import javaff.data.metric.BinaryFunction;
import javaff.data.metric.Function;
import javaff.data.metric.FunctionSymbol;
import javaff.data.metric.Metric;
import javaff.data.metric.MetricSymbolStore;
import javaff.data.metric.MetricType;
import javaff.data.metric.NamedFunction;
import javaff.data.metric.NumberFunction;
import javaff.data.metric.ResourceOperator;
import javaff.data.metric.TotalTimeFunction;
import javaff.data.strips.And;
import javaff.data.strips.Constant;
import javaff.data.strips.EitherType;
import javaff.data.strips.Equals;
import javaff.data.strips.Not;
import javaff.data.strips.NullFact;
import javaff.data.strips.OperatorName;
import javaff.data.strips.PDDLObject;
import javaff.data.strips.Predicate;
import javaff.data.strips.PredicateSymbol;
import javaff.data.strips.Proposition;
import javaff.data.strips.SimpleType;
import javaff.data.strips.SingleLiteral;
import javaff.data.strips.TrueCondition;
import javaff.data.strips.UngroundInstantAction;
import javaff.data.strips.Variable;
import javaff.data.temporal.DurationConstraint;
import javaff.data.temporal.SimpleDurationConstraint;
import javaff.data.temporal.TimedInitialLiteral;
import javaff.data.temporal.UngroundDurativeAction;

public class PDDL21parser implements PDDL21parserConstants
{
	public static UngroundProblem UP = new UngroundProblem();

	/**
	 * Destroy {@link PDDL21parser.UP}
	 */
	public static void reset()
	{
		UP = new UngroundProblem();
	}

	public static UngroundProblem parseFiles(File pDomainFile, File pProblemFile)
	{
		reset();
		boolean probsuc = false;
		boolean suc = parseDomainFile(pDomainFile);
		if (suc)
			probsuc = parseProblemFile(pProblemFile);
		if (probsuc)
		{
			// ADL quantifiers (Exists and ForAll) need to have their quantified
			// variables set up after the
			// problem file has been parsed. The problem file cannot be swapped
			// to be parsed first because
			// constants present in the domain file are needed for grounding the
			// initial and goal states.
			// this method is the lesser of two evils.
			UP.buildTypeSets(); // required for quantifier grounding //TODO find
								// a better place to do this.

			UP.setupQuantifiers();
			return UP;
		}
		else
			return null;
	}

	private static boolean parseDomainFile(File pFile)
	{
		boolean req = false;
		try
		{
			FileReader tFileReader = new FileReader(pFile);
			PDDL21parser parser = new PDDL21parser(tFileReader);
			req = parser.parseDomain();
			tFileReader.close();
		}
		catch (FileNotFoundException e)
		{
			System.out.println("File " + pFile + " has not been found");
			req = false;
		}
		catch (IOException e)
		{
			System.out.println("Unknown IOException caught");
			System.out.println(e.getMessage());
			req = false;
		}
		catch (ParseException e)
		{
			System.out.println("Error whilst parsing file " + pFile);
			System.out.println(e.getMessage());
			req = false;
		}
		if (req)
			System.out.println("Parsed Domain file " + pFile + " successfully");
		else
			System.out.println("Parsing of Domain file " + pFile + " failed");
		return req;
	}

	private static boolean parseProblemFile(File pFile)
	{
		boolean probsuc = true;
		try
		{
			FileReader tFileReader = new FileReader(pFile);
			PDDL21parser parser = new PDDL21parser(tFileReader);
			parser.parseProblem();
			tFileReader.close();
		}
		catch (FileNotFoundException e)
		{
			System.out.println("File " + pFile + " has not been found");
			probsuc = false;
		}
		catch (IOException e)
		{
			System.out.println("Unknown IOException caught");
			System.out.println(e.getMessage());
			probsuc = false;
		}
		catch (ParseException e)
		{
			System.out.println("Error whilst parsing file " + pFile);
			System.out.println(e.getMessage());
			probsuc = false;
		}
		if (probsuc)
			System.out
					.println("Parsed Problem file " + pFile + " successfully");
		else
			System.out.println("Parsing Problem file " + pFile + " failed");
		return probsuc;
	}

	private class TypedList
	{
		public List objects = new ArrayList();
		public Map types = new Hashtable(); // Maps strings onto Types

		public void add(String s)
		{
			objects.add(s);
			types.put(s, SimpleType.rootType);
		}

		public void add(String s, Type t)
		{
			objects.add(s);
			types.put(s, t);
		}
	}

	// ******************************************************************************
	// * *
	// * Parse the Domain File *
	// * *
	// ******************************************************************************
	final public boolean parseDomain() throws ParseException
	{
		Token t;
		boolean req = true;
		jj_consume_token(OPEN);
		jj_consume_token(DEFINE);
		jj_consume_token(OPEN);
		jj_consume_token(DOMAIN);
		t = jj_consume_token(NAME);
		jj_consume_token(CLOSE);
		UP.DomainName = t.toString().toLowerCase();
		if (jj_2_1(20))
		{
			req = parseRequireDef();
		}
		else
		{
			;
		}
		if (!req)
		{
			if (true)
				return false;
		}
		if (jj_2_2(20))
		{
			parseTypeDef();
		}
		else
		{
			;
		}
		if (jj_2_3(20))
		{
			parseConstantsDef();
		}
		else
		{
			;
		}
		if (jj_2_4(20))
		{
			parsePredicatesDef();
		}
		else
		{
			;
		}
		if (jj_2_5(20))
		{
			parseFunctionsDef();
		}
		else
		{
			;
		}
		label_1: while (true)
		{
			if (jj_2_6(20))
			{
				;
			}
			else
			{
				break label_1;
			}
			parseStructureDef();
		}
		jj_consume_token(CLOSE);
		jj_consume_token(0);
		{
			if (true)
				return true;
		}
		throw new Error("Missing return statement in function");
	}

	// ***************************************************
	// * Parse the requirement definitions
	// ***************************************************
	final public boolean parseRequireDef() throws ParseException
	{
		Token t;
		UP.requirements = new DomainRequirements();
		jj_consume_token(OPEN);
		jj_consume_token(REQUIREMENTS);
		label_2: while (true)
		{
			if (jj_2_7(20))
			{
				;
			}
			else
			{
				break label_2;
			}
			if (jj_2_8(20))
			{
				t = jj_consume_token(REQUIREMENT_LABELS);
				String req = t.toString();

				// I freely admit this is not my finest coding hour...
				if (req.equals(":typing"))
					UP.requirements.addRequirement(Requirement.Typing);
				else if (req.equals(":fluents"))
					UP.requirements.addRequirement(Requirement.Fluents);
				else if (req.equals(":durative-actions"))
					UP.requirements
							.addRequirement(Requirement.DurativeActions);
				else if (req.equals(":duration-inequalities"))
					UP.requirements
							.addRequirement(Requirement.DurationInequalities);
				else if (req.equals(":numeric-fluents"))
					UP.requirements.addRequirement(Requirement.NumericFluents);
				else if (req.equals(":action-costs"))
					UP.requirements.addRequirement(Requirement.ActionCosts);
				else if (req.equals(":adl"))
					UP.requirements.addRequirement(Requirement.ADL);
				else if (req.equals(":negative-preconditions"))
					UP.requirements
							.addRequirement(Requirement.NegativePreconditions);
				else if (req.equals(":disjunctive-preconditions"))
					UP.requirements
							.addRequirement(Requirement.DisjunctivePreconditions);
				else if (req.equals(":existential-preconditions"))
					UP.requirements
							.addRequirement(Requirement.ExistentialPreconditions);
				else if (req.equals(":universal-preconditions"))
					UP.requirements
							.addRequirement(Requirement.UniversalPreconditions);
				else if (req.equals(":quantified-preconditions"))
					UP.requirements
							.addRequirement(Requirement.QuantifiedPreconditions);
				else if (req.equals(":conditional-effects"))
					UP.requirements
							.addRequirement(Requirement.ConditionalEffects);
				else if (req.equals(":timed-initial-literals"))
					UP.requirements
							.addRequirement(Requirement.TimedInitialLiterals);
				else if (req.equals(":domain-axioms"))
					UP.requirements.addRequirement(Requirement.DomainAxioms);
				else if (req.equals(":constraints"))
					UP.requirements.addRequirement(Requirement.Constraints);
				else if (req.equals(":preferences"))
					UP.requirements.addRequirement(Requirement.Preferences);
				else if (req.equals(":derived-predicates"))
					UP.requirements
							.addRequirement(Requirement.DerivedPredicates);
				else if (req.equals(":strips"))
					UP.requirements.addRequirement(Requirement.Strips);
				else if (req.equals(":equality"))
					UP.requirements.addRequirement(Requirement.Equality);
			}
			else if (jj_2_9(20))
			{
				t = jj_consume_token(NON_HANDLED_LABELS);
				System.out.println("Unsupported requirement tag: "
						+ t.toString().toLowerCase());
				{
					if (true)
						return false;
				}
			}
			else if (jj_2_10(20))
			{
				t = jj_consume_token(PDDL_1_7_LABELS);
				System.out.println("PDDL 1.7 tags not supported: "
						+ t.toString().toLowerCase());
				{
					if (true)
						return false;
				}
			}
			else
			{
				jj_consume_token(-1);
				throw new ParseException();
			}
		}
		jj_consume_token(CLOSE);
		{
			if (true)
				return true;
		}
		throw new Error("Missing return statement in function");
	}

	// ***************************************************
	// * Parse the type definitions
	// ***************************************************
	final public void parseTypeDef() throws ParseException
	{
		Type t;
		Set types;
		jj_consume_token(OPEN);
		jj_consume_token(TYPES);
		label_3: while (true)
		{
			if (jj_2_11(20))
			{
				;
			}
			else
			{
				break label_3;
			}
			types = new HashSet();
			label_4: while (true)
			{
				t = parsePrimitiveType();
				types.add(t);
				UP.TypeGraph.addType(t);
				if (jj_2_12(20))
				{
					;
				}
				else
				{
					break label_4;
				}
			}
			jj_consume_token(TYPE_IDENT);
			t = parseType();
			Iterator tit = types.iterator();
			while (tit.hasNext())
			{
				SimpleType type = (SimpleType) tit.next();
				type.setSuperType(t);
				UP.TypeGraph.addType(type, t);
			}
		}
		label_5: while (true)
		{
			if (jj_2_13(20))
			{
				;
			}
			else
			{
				break label_5;
			}
			t = parsePrimitiveType();
			UP.TypeGraph.addType(t);
		}
		jj_consume_token(CLOSE);
	}

	final public Type parseType() throws ParseException
	{
		Type t;
		if (jj_2_14(20))
		{
			t = parsePrimitiveType();
		}
		else if (jj_2_15(20))
		{
			t = parseEitherType();
		}
		else
		{
			jj_consume_token(-1);
			throw new ParseException();
		}
		{
			if (true)
				return t;
		}
		throw new Error("Missing return statement in function");
	}

	final public SimpleType parsePrimitiveType() throws ParseException
	{
		Token t;
		t = jj_consume_token(NAME);
		String typeStr = t.toString().toLowerCase();
		SimpleType type = (SimpleType) UP.typeMap.get(typeStr);
		if (type == null)
		{
			type = new SimpleType(typeStr);
			UP.types.add(type);
			UP.typeMap.put(typeStr, type);
		}
		{
			if (true)
				return type;
		}
		throw new Error("Missing return statement in function");
	}

	final public EitherType parseEitherType() throws ParseException
	{
		EitherType et = new EitherType();
		SimpleType st;
		jj_consume_token(OPEN);
		jj_consume_token(EITHER);
		label_6: while (true)
		{
			st = parsePrimitiveType();
			et.addType(st);
			if (jj_2_16(20))
			{
				;
			}
			else
			{
				break label_6;
			}
		}
		jj_consume_token(CLOSE);
		{
			if (true)
				return et;
		}
		throw new Error("Missing return statement in function");
	}

	// ***************************************************
	// * Parse a TypedList
	// ***************************************************
	final public TypedList parseTypedList() throws ParseException
	{
		List strings = new ArrayList();
		Type type;
		Token t;
		TypedList rList = new TypedList();
		TypedList tList;
		type = new SimpleType("object"); // may be no explicit type declaration,
											// so assume its just any type --
											// will get overwritten if there is
											// a type

		if (jj_2_24(20))
		{
			label_7: while (true)
			{
				if (jj_2_17(20))
				{
					t = jj_consume_token(NAME);
				}
				else if (jj_2_18(20))
				{
					t = jj_consume_token(VAR);
				}
				else
				{
					jj_consume_token(-1);
					throw new ParseException();
				}
				strings.add(t.toString().toLowerCase());
				if (jj_2_19(20))
				{
					;
				}
				else
				{
					break label_7;
				}
			}
			if (jj_2_20(20))
			{
				jj_consume_token(TYPE_IDENT);
				type = parseType();
			}
			else
			{
				;
			}
			Iterator tit = strings.iterator();
			while (tit.hasNext())
			{
				String string = (String) tit.next();
				rList.add(string, type);
			}
			tList = parseTypedList();
			rList.objects.addAll(tList.objects);
			rList.types.putAll(tList.types);
		}
		else
		{
			label_8: while (true)
			{
				if (jj_2_21(20))
				{
					;
				}
				else
				{
					break label_8;
				}
				if (jj_2_22(20))
				{
					t = jj_consume_token(NAME);
				}
				else if (jj_2_23(20))
				{
					t = jj_consume_token(VAR);
				}
				else
				{
					jj_consume_token(-1);
					throw new ParseException();
				}
				rList.add(t.toString().toLowerCase());
			}
		}
		{
			if (true)
				return rList;
		}
		throw new Error("Missing return statement in function");
	}

	// ***************************************************
	// * Parse the constants
	// ***************************************************
	final public void parseConstantsDef() throws ParseException
	{
		TypedList tl;
		jj_consume_token(OPEN);
		jj_consume_token(CONSTANTS);
		tl = parseTypedList();
		jj_consume_token(CLOSE);
		Iterator it = tl.objects.iterator();
		while (it.hasNext())
		{
			String str = (String) it.next();
			// PDDLObject c = new PDDLObject(str);
			Constant c = new Constant(str);
			c.setType((Type) tl.types.get(str));
			UP.constants.add(c);
			UP.constantMap.put(str, c);
		}
	}

	// ***************************************************
	// * Parse the predicates
	// ***************************************************
	final public void parsePredicatesDef() throws ParseException
	{
		jj_consume_token(OPEN);
		jj_consume_token(PREDICATES);
		label_9: while (true)
		{
			parsePredicate();
			if (jj_2_25(20))
			{
				;
			}
			else
			{
				break label_9;
			}
		}
		jj_consume_token(CLOSE);
	}

	final public void parsePredicate() throws ParseException
	{
		PredicateSymbol ps;
		TypedList tl;
		jj_consume_token(OPEN);
		ps = parsePredicateSymbol();
		tl = parseTypedList();
		Iterator it = tl.objects.iterator();
		while (it.hasNext())
		{
			String str = (String) it.next();
			Variable v = new Variable(str);
			v.setType((Type) tl.types.get(str));
			ps.addVar(v);
		}
		UP.predSymbols.add(ps);
		jj_consume_token(CLOSE);
	}

	final public PredicateSymbol parsePredicateSymbol() throws ParseException
	{
		Token t;
		t = jj_consume_token(NAME);
		PredicateSymbol ps = (PredicateSymbol) UP.predSymbolMap.get(t
				.toString().toLowerCase());
		if (ps == null)
		{
			ps = new PredicateSymbol(t.toString().toLowerCase());
			UP.predSymbolMap.put(t.toString().toLowerCase(), ps);
		}
		{
			if (true)
				return ps;
		}
		throw new Error("Missing return statement in function");
	}

	// ***************************************************
	// * Parse a STRIPS action
	// ***************************************************
	final public void parseStructureDef() throws ParseException
	{
		if (jj_2_26(20))
		{
			parseActionDef();
		}
		else if (jj_2_27(20))
		{
			parseDurActionDef();
		}
		else
		{
			jj_consume_token(-1);
			throw new ParseException();
		}
	}

	final public void parseActionDef() throws ParseException
	{
		UngroundInstantAction a = new UngroundInstantAction();
		TypedList tl = null;
		Map varMap = new Hashtable();
		jj_consume_token(OPEN);
		jj_consume_token(ACTION);
		a.name = parseOperatorName();
		jj_consume_token(PARAMETERS);
		if (jj_2_28(20))
		{
			jj_consume_token(OPEN);
			tl = parseTypedList();
			jj_consume_token(CLOSE);
		}
		else if (jj_2_29(20))
		{
			jj_consume_token(OPEN);
			jj_consume_token(CLOSE);
		}
		else
		{
			jj_consume_token(-1);
			throw new ParseException();
		}
		UP.actions.add(a);

		if (tl != null)
		{
			Iterator it = tl.objects.iterator();
			while (it.hasNext())
			{
				String str = (String) it.next();
				Variable v = new Variable(str);
				v.setType((Type) tl.types.get(str));
				a.params.add(v);
				varMap.put(str, v);
			}
		}
		parseActionDefBody(a, varMap);
		jj_consume_token(CLOSE);
	}

	final public OperatorName parseOperatorName() throws ParseException
	{
		Token t;
		t = jj_consume_token(NAME);
		{
			if (true)
				return new OperatorName(t.toString().toLowerCase());
		}
		throw new Error("Missing return statement in function");
	}

	final public void parseActionDefBody(UngroundInstantAction a, Map varMap)
			throws ParseException
	{
		Fact c = TrueCondition.getInstance();
		Fact e = TrueCondition.getInstance();
		if (jj_2_30(20))
		{
			jj_consume_token(PRECONDITION);
			c = parseGD(varMap, false);
			a.condition = (UngroundFact) c;
		}
		else
		{
			;
		}
		if (jj_2_31(20))
		{
			jj_consume_token(EFFECT);
			e = parseEffect(varMap);
			a.effect = (UngroundFact) e;
		}
		else
		{
			;
		}
	}

	// **********************************
	// * Parse Goal Definition
	// **********************************

	// Map m is the variableMap
	// boolean ground is whether it is ground or not (i.e. in an action or in
	// the initial state)
	final public Fact parseGD(Map m, boolean ground) throws ParseException
	{
		Literal p; // may be single or compound... should really fix one day to
					// be in separate methods
		SingleLiteral s;
		Fact c, a, b;
		TypedList vars;
		Variable v;
		And and;
		Or or;
		ForAll forall;
		Exists exists;
		Imply imply;
		Equals equals;
		if (jj_2_34(20))
		{
			jj_consume_token(OPEN);
			jj_consume_token(CLOSE);
			{
				if (true)
					return TrueCondition.getInstance();
			}
		}
		else if (jj_2_35(20))
		{
			jj_consume_token(OPEN);
			jj_consume_token(AND);
			and = new And();
			label_10: while (true)
			{
				if (jj_2_32(20))
				{
					;
				}
				else
				{
					break label_10;
				}
				c = parseGD(m, ground);
				and.add(c);
			}
			jj_consume_token(CLOSE);
			{
				if (true)
					return and;
			}
		}
		else if (jj_2_36(20))
		{
			jj_consume_token(OPEN);
			jj_consume_token(OR);
			or = new Or();
			label_11: while (true)
			{
				if (jj_2_33(20))
				{
					;
				}
				else
				{
					break label_11;
				}
				c = parseGD(m, ground);
				or.add(c);
			}
			jj_consume_token(CLOSE);
			{
				if (true)
					return or;
			}
		}
		else if (jj_2_37(20))
		{
			jj_consume_token(OPEN);
			jj_consume_token(NOT);
			c = parseGD(m, ground);
			jj_consume_token(CLOSE);
			{
				if (true)
					return new Not(c);
			}
		}
		else if (jj_2_38(20))
		{
			jj_consume_token(OPEN);
			jj_consume_token(FOR_ALL);
			forall = parseForAll(m, ground);
			jj_consume_token(CLOSE);
			{
				if (true)
					return forall;
			}
		}
		else if (jj_2_39(20))
		{
			jj_consume_token(OPEN);
			jj_consume_token(EXISTS);
			exists = parseExists(m, ground);
			jj_consume_token(CLOSE);
			{
				if (true)
					return exists;
			}
		}
		else if (jj_2_40(20))
		{
			jj_consume_token(OPEN);
			jj_consume_token(IMPLY);
			imply = parseImply(m, ground);
			jj_consume_token(CLOSE);
			{
				if (true)
					return imply;
			}
		}
		else if (jj_2_41(20))
		{
			jj_consume_token(OPEN);
			jj_consume_token(EQUALS);
			equals = parseEquals(m, ground);
			jj_consume_token(CLOSE);
			{
				if (true)
					return equals;
			}
		}
		else if (jj_2_42(20))
		{
			s = parseAtomicFormula(m, ground);
			{
				if (true)
					return s;
			}
		}
		else if (jj_2_43(20))
		{
			c = parseFComp(m);
			{
				if (true)
					return c;
			}
		}
		else
		{
			jj_consume_token(-1);
			throw new ParseException();
		}
		throw new Error("Missing return statement in function");
	}

	final public Equals parseEquals(Map m, boolean ground)
			throws ParseException
	{
		Equals equals;
		Fact a, b;
		TypedList tl;
		tl = parseTypedList();
		equals = new Equals();
		Iterator it = tl.objects.iterator();
		while (it.hasNext())
		{
			String str = (String) it.next();
			Parameter o = null;
			if (m != null)
				o = (Parameter) m.get(str);
			if (o == null)
				o = (Parameter) UP.constantMap.get(str);
			if (o == null)
				o = (Parameter) UP.objectMap.get(str);

			equals.addParameter(o);
		}

		{
			if (true)
				return equals;
		}
		throw new Error("Missing return statement in function");
	}

	final public Imply parseImply(Map m, boolean ground) throws ParseException
	{
		Imply imply;
		Fact a, b;
		// <OPEN> <IMPLY>
		a = parseGD(m, ground);
		b = parseGD(m, ground);
		imply = new Imply(a, b);
		{
			if (true)
				return imply;
		}
		throw new Error("Missing return statement in function");
	}

	final public ForAll parseForAll(Map m, boolean ground)
			throws ParseException
	{
		ForAll forall;
		TypedList vars;
		Variable v;
		Fact c;
		String s;
		jj_consume_token(OPEN);
		// <FOR_ALL> <OPEN>
		vars = parseTypedList();
		Iterator it = vars.objects.iterator();
		if (vars.objects.size() > 1)
		{
			{
				if (true)
					throw new IllegalArgumentException(
							"Too many FORALL quantifiers");
			}
		}
		else
		{
			String str = (String) it.next();
			v = new Variable(str);
			v.setType((Type) vars.types.get(str));

			m.put(str, v); // need to add extra, non parameter-variables here or
							// grounding wont work
		}
		jj_consume_token(CLOSE);
		c = parseGD(m, ground);
		forall = new ForAll(v, c, UP.typeSets.get(v.getType()));
		{
			if (true)
				return forall;
		}
		throw new Error("Missing return statement in function");
	}

	final public Exists parseExists(Map m, boolean ground)
			throws ParseException
	{
		Exists exists;
		TypedList vars;
		Variable v;
		Fact c;
		String s;
		jj_consume_token(OPEN);
		vars = parseTypedList();
		Iterator it = vars.objects.iterator();
		if (vars.objects.size() > 1)
		{
			{
				if (true)
					throw new IllegalArgumentException(
							"Too many EXISTS quantifiers");
			}
		}
		else
		{
			String str = (String) it.next();
			v = new Variable(str);
			v.setType((Type) vars.types.get(str));

			m.put(str, v); // need to add extra, non parameter-variables here or
							// grounding wont work
		}
		jj_consume_token(CLOSE);
		c = parseGD(m, ground);
		exists = new Exists(v, c, UP.typeSets.get(v.getType()));
		{
			if (true)
				return exists;
		}
		throw new Error("Missing return statement in function");
	}

	final public SingleLiteral parseAtomicFormula(Map m, boolean ground)
			throws ParseException
	{
		PredicateSymbol p;
		TypedList tl;
		jj_consume_token(OPEN);
		p = parsePredicateSymbol();
		tl = parseTypedList();
		jj_consume_token(CLOSE);
		SingleLiteral lit;
		if (ground)
			lit = new Proposition(p);
		else
			lit = new Predicate(p);
		Iterator it = tl.objects.iterator();

		while (it.hasNext())
		{
			String str = (String) it.next();
			Parameter o = null;
			if (m != null)
				o = (Parameter) m.get(str);
			if (o == null)
				o = (Parameter) UP.constantMap.get(str);
			if (o == null)
				o = (Parameter) UP.objectMap.get(str);

			// hack... but I can't remember why I did it...
			if (lit instanceof Proposition)
				((Proposition) lit).addParameter(o);
			else
				((Predicate) lit).addParameter(o);
		}
		{
			if (true)
				return lit;
		}
		throw new Error("Missing return statement in function");
	}

	// **********************************
	// * Parse Fact
	// **********************************
	final public Fact parseEffect(Map m) throws ParseException
	{
		Fact c;
		And and;
		if (jj_2_45(20))
		{
			jj_consume_token(OPEN);
			jj_consume_token(CLOSE);
			{
				if (true)
					return new NullFact();
			}
		}
		else if (jj_2_46(20))
		{
			c = parseCEffect(m);
			{
				if (true)
					return c;
			}
		}
		else if (jj_2_47(20))
		{
			jj_consume_token(OPEN);
			jj_consume_token(AND);
			and = new And();
			label_12: while (true)
			{
				if (jj_2_44(20))
				{
					;
				}
				else
				{
					break label_12;
				}
				c = parseCEffect(m);
				and.add(c);
			}
			jj_consume_token(CLOSE);
			{
				if (true)
					return and;
			}
		}
		else
		{
			jj_consume_token(-1);
			throw new ParseException();
		}
		throw new Error("Missing return statement in function");
	}

	final public Fact parseCEffect(Map m) throws ParseException
	{
		Fact condition = TrueCondition.getInstance();
		Fact effect = TrueCondition.getInstance();
		if (jj_2_48(20))
		{
			jj_consume_token(OPEN);
			jj_consume_token(FOR_ALL);
			condition = parseForAll(m, false);
			effect = parseEffect(m);
			jj_consume_token(CLOSE);
		}
		else if (jj_2_49(20))
		{
			jj_consume_token(OPEN);
			jj_consume_token(WHEN);
			condition = parseGD(m, false);
			effect = parseConditionalEffect(m);
			jj_consume_token(CLOSE);
		}
		else if (jj_2_50(20))
		{
			effect = parsePEffect(m);
			{
				if (true)
					return effect;
			}
			{
				if (true)
					return new ConditionalEffect(condition, effect);
			}
		}
		else
		{
			jj_consume_token(-1);
			throw new ParseException();
		}
		throw new Error("Missing return statement in function");
	}

	final public Fact parseConditionalEffect(Map m) throws ParseException
	{
		And and;
		Fact effect = TrueCondition.getInstance();
		if (jj_2_52(20))
		{
			jj_consume_token(OPEN);
			jj_consume_token(AND);
			and = new And();
			label_13: while (true)
			{
				if (jj_2_51(20))
				{
					;
				}
				else
				{
					break label_13;
				}
				effect = parsePEffect(m);
			}
			and.add(effect);
		}
		else if (jj_2_53(20))
		{
			effect = parsePEffect(m);
			{
				if (true)
					return effect;
			}
		}
		else
		{
			jj_consume_token(-1);
			throw new ParseException();
		}
		throw new Error("Missing return statement in function");
	}

	final public Fact parsePEffect(Map m) throws ParseException
	{
		SingleLiteral p;
		ResourceOperator ro;
		if (jj_2_54(20))
		{
			p = parseAtomicFormula(m, false);
			{
				if (true)
					return p;
			}
		}
		else if (jj_2_55(20))
		{
			jj_consume_token(OPEN);
			jj_consume_token(NOT);
			p = parseAtomicFormula(m, false);
			jj_consume_token(CLOSE);
			{
				if (true)
					return new Not(p);
			}
		}
		else if (jj_2_56(20))
		{
			ro = parseResourceOperator(m);
			{
				if (true)
					return ro;
			}
		}
		else
		{
			jj_consume_token(-1);
			throw new ParseException();
		}
		throw new Error("Missing return statement in function");
	}

	// ***************************************************
	// * Parse Metrics
	// ***************************************************

	// **********************************
	// * Parse Function Definitions
	// **********************************
	final public void parseFunctionsDef() throws ParseException
	{
		TypedList tl;
		jj_consume_token(OPEN);
		jj_consume_token(FUNCTIONS);
		label_14: while (true)
		{
			parseFunctionSkeleton();
			if (jj_2_57(20))
			{
				;
			}
			else
			{
				break label_14;
			}
		}
		jj_consume_token(CLOSE);
	}

	final public void parseFunctionSkeleton() throws ParseException
	{
		FunctionSymbol fs;
		TypedList tl;
		jj_consume_token(OPEN);
		fs = parseFunctionSymbol();
		tl = parseTypedList();
		Iterator it = tl.objects.iterator();
		while (it.hasNext())
		{
			String str = (String) it.next();
			Variable v = new Variable(str);
			v.setType((Type) tl.types.get(str));
			fs.addVar(v);
		}
		UP.funcSymbols.add(fs);
		jj_consume_token(CLOSE);
		if (jj_2_58(20))
		{
			jj_consume_token(TYPE_IDENT);
			jj_consume_token(NUMBER_TYPE);
		}
		else
		{
			;
		}
	}

	final public FunctionSymbol parseFunctionSymbol() throws ParseException
	{
		Token t;
		t = jj_consume_token(NAME);
		FunctionSymbol fs = (FunctionSymbol) UP.funcSymbolMap.get(t.toString()
				.toLowerCase());
		if (fs == null)
		{
			fs = new FunctionSymbol(t.toString().toLowerCase());
			UP.funcSymbolMap.put(t.toString().toLowerCase(), fs);
		}
		{
			if (true)
				return fs;
		}
		throw new Error("Missing return statement in function");
	}

	// **********************************
	// * Parse Function Comparators
	// **********************************
	final public BinaryComparator parseFComp(Map varMap) throws ParseException
	{
		Token t1;
		Function f1, f2;
		jj_consume_token(OPEN);
		t1 = jj_consume_token(BINARY_COMP);
		f1 = parseFExp(varMap);
		f2 = parseFExp(varMap);
		jj_consume_token(CLOSE);
		BinaryComparator bc = new BinaryComparator(t1.toString().toLowerCase(),
				f1, f2);
		{
			if (true)
				return bc;
		}
		throw new Error("Missing return statement in function");
	}

	final public Function parseFExp(Map varMap) throws ParseException
	{
		Token t1;
		Function f1, f2;
		if (jj_2_59(20))
		{
			t1 = jj_consume_token(NUMBER);
			{
				if (true)
					return new NumberFunction(Double.parseDouble(t1.toString()
							.toLowerCase()));
			}
		}
		else if (jj_2_60(20))
		{
			jj_consume_token(OPEN);
			t1 = jj_consume_token(BINARY_OP);
			f1 = parseFExp(varMap);
			f2 = parseFExp(varMap);
			jj_consume_token(CLOSE);
			BinaryFunction bf = new BinaryFunction(t1.toString().toLowerCase(),
					f1, f2);
			{
				if (true)
					return bf;
			}
		}
		else if (jj_2_61(20))
		{
			jj_consume_token(OPEN);
			t1 = jj_consume_token(TYPE_IDENT);
			f1 = parseFExp(varMap);
			f2 = parseFExp(varMap);
			jj_consume_token(CLOSE);
			BinaryFunction bf = new BinaryFunction(t1.toString().toLowerCase(),
					f1, f2);
			{
				if (true)
					return bf;
			}
		}
		else if (jj_2_62(20))
		{
			jj_consume_token(OPEN);
			t1 = jj_consume_token(TYPE_IDENT);
			f1 = parseFExp(varMap);
			jj_consume_token(CLOSE);
			BinaryFunction bf = new BinaryFunction(t1.toString().toLowerCase(),
					new NumberFunction(0), f1);
			{
				if (true)
					return bf;
			}
		}
		else if (jj_2_63(20))
		{
			f1 = parseFHead(varMap);
			{
				if (true)
					return f1;
			}
		}
		else
		{
			jj_consume_token(-1);
			throw new ParseException();
		}
		throw new Error("Missing return statement in function");
	}

	final public NamedFunction parseFHead(Map varMap) throws ParseException
	{
		FunctionSymbol f;
		TypedList tl;
		if (jj_2_66(20))
		{
			jj_consume_token(OPEN);
			f = parseFunctionSymbol();
			tl = parseTypedList();
			jj_consume_token(CLOSE);
			NamedFunction nf = new NamedFunction(f);
			Iterator it = tl.objects.iterator();
			while (it.hasNext())
			{
				String str = (String) it.next();
				Parameter o = null;
				if (varMap != null)
					o = (Parameter) varMap.get(str);
				if (o == null)
					o = (Parameter) UP.constantMap.get(str);
				if (o == null)
					o = (Parameter) UP.objectMap.get(str);
				nf.addParameter(o);
			}
			{
				if (true)
					return nf;
			}
		}
		else if (jj_2_67(20))
		{
			if (jj_2_64(20))
			{
				jj_consume_token(OPEN);
			}
			else
			{
				;
			}
			jj_consume_token(TOTAL_TIME);
			if (jj_2_65(20))
			{
				jj_consume_token(CLOSE);
			}
			else
			{
				;
			}
			{
				if (true)
					return TotalTimeFunction.getInstance();
			}
		}
		else if (jj_2_68(20))
		{
			f = parseFunctionSymbol();
			NamedFunction nf = new NamedFunction(f);
			{
				if (true)
					return nf;
			}
		}
		else
		{
			jj_consume_token(-1);
			throw new ParseException();
		}
		throw new Error("Missing return statement in function");
	}

	// **********************************
	// * Parse Resource Operators
	// **********************************
	final public ResourceOperator parseResourceOperator(Map varMap)
			throws ParseException
	{
		Token t1;
		NamedFunction f1;
		Function f2;
		jj_consume_token(OPEN);
		t1 = jj_consume_token(ASSIGN_OP);
		f1 = parseFHead(varMap);
		f2 = parseFExp(varMap);
		jj_consume_token(CLOSE);
		{
			if (true)
				return new ResourceOperator(t1.toString().toLowerCase(), f1, f2);
		}
		throw new Error("Missing return statement in function");
	}

	// ***************************************************
	// * Parse Temporal
	// ***************************************************

	// **********************************
	// * Parse Durative Action
	// **********************************
	final public void parseDurActionDef() throws ParseException
	{
		UngroundDurativeAction a = new UngroundDurativeAction();
		TypedList tl;
		Map varMap = new Hashtable();
		jj_consume_token(OPEN);
		jj_consume_token(DURATIVE_ACTION);
		a.name = parseOperatorName();
		jj_consume_token(PARAMETERS);
		jj_consume_token(OPEN);
		tl = parseTypedList();
		jj_consume_token(CLOSE);
		UP.actions.add(a);
		Iterator it = tl.objects.iterator();
		while (it.hasNext())
		{
			String str = (String) it.next();
			Variable v = new Variable(str);
			v.setType((Type) tl.types.get(str));
			a.params.add(v);
			varMap.put(str, v);
		}
		parseDurativeActionDefBody(a, varMap);
		a.makeInstants();
		jj_consume_token(CLOSE);
	}

	final public void parseDurativeActionDefBody(UngroundDurativeAction da,
			Map varMap) throws ParseException
	{
		DurationConstraint dc;
		jj_consume_token(DURATION);
		dc = parseDurationConstraint(da, varMap);
		da.durationConstraint = dc;
		if (jj_2_69(20))
		{
			jj_consume_token(CONDITION);
			parseDAGD(da, varMap);
		}
		else
		{
			;
		}
		if (jj_2_70(20))
		{
			jj_consume_token(EFFECT);
			parseDAEffect(da, varMap);
		}
		else
		{
			;
		}
	}

	// **********************************
	// * Parse Durative Action Conditions
	// **********************************
	final public void parseDAGD(UngroundDurativeAction da, Map varMap)
			throws ParseException
	{
		if (jj_2_72(20))
		{
			parseTimedGD(da, varMap);
		}
		else if (jj_2_73(20))
		{
			jj_consume_token(OPEN);
			jj_consume_token(AND);
			label_15: while (true)
			{
				parseTimedGD(da, varMap);
				if (jj_2_71(20))
				{
					;
				}
				else
				{
					break label_15;
				}
			}
			jj_consume_token(CLOSE);
		}
		else
		{
			jj_consume_token(-1);
			throw new ParseException();
		}
	}

	final public void parseTimedGD(UngroundDurativeAction da, Map varMap)
			throws ParseException
	{
		Fact c;
		if (jj_2_74(20))
		{
			jj_consume_token(OPEN);
			jj_consume_token(AT_START);
			c = parseGD(varMap, false);
			jj_consume_token(CLOSE);
			((And) da.startCondition).add(c);
		}
		else if (jj_2_75(20))
		{
			jj_consume_token(OPEN);
			jj_consume_token(AT_END);
			c = parseGD(varMap, false);
			jj_consume_token(CLOSE);
			((And) da.endCondition).add(c);
		}
		else if (jj_2_76(20))
		{
			jj_consume_token(OPEN);
			jj_consume_token(OVER_ALL);
			c = parseGD(varMap, false);
			jj_consume_token(CLOSE);
			((And) da.invariant).add(c);
		}
		else
		{
			jj_consume_token(-1);
			throw new ParseException();
		}
	}

	// **********************************
	// * Parse Duration
	// **********************************
	final public DurationConstraint parseDurationConstraint(
			UngroundDurativeAction da, Map varMap) throws ParseException
	{
		SimpleDurationConstraint sdc;
		DurationConstraint dc;
		if (jj_2_78(20))
		{
			jj_consume_token(OPEN);
			jj_consume_token(AND);
			dc = new DurationConstraint();
			label_16: while (true)
			{
				sdc = parseSimpleDurationConstraint(da, varMap);
				dc.add(sdc);
				if (jj_2_77(20))
				{
					;
				}
				else
				{
					break label_16;
				}
			}
			jj_consume_token(CLOSE);
			{
				if (true)
					return dc;
			}
		}
		else if (jj_2_79(20))
		{
			sdc = parseSimpleDurationConstraint(da, varMap);
			{
				if (true)
					return sdc;
			}
		}
		else
		{
			jj_consume_token(-1);
			throw new ParseException();
		}
		throw new Error("Missing return statement in function");
	}

	final public SimpleDurationConstraint parseSimpleDurationConstraint(
			UngroundDurativeAction da, Map varMap) throws ParseException
	{
		int t;
		Function f;
		jj_consume_token(OPEN);
		t = parseDOp();
		jj_consume_token(DUR_VAR);
		f = parseFExp(varMap);
		jj_consume_token(CLOSE);
		SimpleDurationConstraint s = new SimpleDurationConstraint(da.duration,
				f, t);
		{
			if (true)
				return s;
		}
		throw new Error("Missing return statement in function");
	}

	final public int parseDOp() throws ParseException
	{
		Token t;
		if (jj_2_80(20))
		{
			t = jj_consume_token(BINARY_COMP);
		}
		else if (jj_2_81(20))
		{
			t = jj_consume_token(EQUALS);
		}
		else
		{
			jj_consume_token(-1);
			throw new ParseException();
		}
		int i = MetricSymbolStore.getType(t.toString().toLowerCase());
		if (i == MetricSymbolStore.LESS_THAN)
			i = MetricSymbolStore.LESS_THAN_EQUAL;
		else if (i == MetricSymbolStore.GREATER_THAN)
			i = MetricSymbolStore.GREATER_THAN_EQUAL;
		{
			if (true)
				return i;
		}
		throw new Error("Missing return statement in function");
	}

	// **********************************
	// * Parse Durative Action Effects
	// **********************************
	final public void parseDAEffect(UngroundDurativeAction da, Map varMap)
			throws ParseException
	{
		if (jj_2_83(20))
		{
			parseTimedEffect(da, varMap);
		}
		else if (jj_2_84(20))
		{
			jj_consume_token(OPEN);
			jj_consume_token(AND);
			label_17: while (true)
			{
				if (jj_2_82(20))
				{
					;
				}
				else
				{
					break label_17;
				}
				parseDAEffect(da, varMap);
			}
			jj_consume_token(CLOSE);
		}
		else
		{
			jj_consume_token(-1);
			throw new ParseException();
		}
	}

	final public void parseTimedEffect(UngroundDurativeAction da, Map varMap)
			throws ParseException
	{
		Fact e;
		if (jj_2_85(20))
		{
			jj_consume_token(OPEN);
			jj_consume_token(AT_START);
			e = parseEffect(varMap);
			jj_consume_token(CLOSE);
			((And) da.startEffect).add(e);
		}
		else if (jj_2_86(20))
		{
			jj_consume_token(OPEN);
			jj_consume_token(AT_START);
			e = parseFAssignDA(da, varMap);
			jj_consume_token(CLOSE);
			((And) da.startEffect).add(e);
		}
		else if (jj_2_87(20))
		{
			jj_consume_token(OPEN);
			jj_consume_token(AT_END);
			e = parseEffect(varMap);
			jj_consume_token(CLOSE);
			((And) da.endEffect).add(e);
		}
		else if (jj_2_88(20))
		{
			jj_consume_token(OPEN);
			jj_consume_token(AT_END);
			e = parseFAssignDA(da, varMap);
			jj_consume_token(CLOSE);
			((And) da.endEffect).add(e);
		}
		else
		{
			jj_consume_token(-1);
			throw new ParseException();
		}
	}

	final public ResourceOperator parseFAssignDA(UngroundDurativeAction da,
			Map varMap) throws ParseException
	{
		Token t1;
		NamedFunction f1;
		Function f2;
		jj_consume_token(OPEN);
		t1 = jj_consume_token(ASSIGN_OP);
		f1 = parseFHead(varMap);
		f2 = parseFExpDA(da, varMap);
		jj_consume_token(CLOSE);
		{
			if (true)
				return new ResourceOperator(t1.toString().toLowerCase(), f1, f2);
		}
		throw new Error("Missing return statement in function");
	}

	final public Function parseFExpDA(UngroundDurativeAction da, Map varMap)
			throws ParseException
	{
		Token t1;
		Function f1, f2;
		if (jj_2_89(20))
		{
			t1 = jj_consume_token(NUMBER);
			{
				if (true)
					return new NumberFunction(Double.parseDouble(t1.toString()
							.toLowerCase()));
			}
		}
		else if (jj_2_90(20))
		{
			jj_consume_token(OPEN);
			t1 = jj_consume_token(BINARY_OP);
			f1 = parseFExpDA(da, varMap);
			f2 = parseFExpDA(da, varMap);
			jj_consume_token(CLOSE);
			BinaryFunction bf = new BinaryFunction(t1.toString().toLowerCase(),
					f1, f2);
			{
				if (true)
					return bf;
			}
		}
		else if (jj_2_91(20))
		{
			jj_consume_token(OPEN);
			t1 = jj_consume_token(TYPE_IDENT);
			f1 = parseFExpDA(da, varMap);
			f2 = parseFExpDA(da, varMap);
			jj_consume_token(CLOSE);
			BinaryFunction bf = new BinaryFunction(t1.toString().toLowerCase(),
					f1, f2);
			{
				if (true)
					return bf;
			}
		}
		else if (jj_2_92(20))
		{
			jj_consume_token(OPEN);
			t1 = jj_consume_token(TYPE_IDENT);
			f1 = parseFExpDA(da, varMap);
			jj_consume_token(CLOSE);
			BinaryFunction bf = new BinaryFunction(t1.toString().toLowerCase(),
					new NumberFunction(0), f1);
			{
				if (true)
					return bf;
			}
		}
		else if (jj_2_93(20))
		{
			jj_consume_token(DUR_VAR);
			{
				if (true)
					return da.duration;
			}
		}
		else if (jj_2_94(20))
		{
			f1 = parseFExp(varMap);
			{
				if (true)
					return f1;
			}
		}
		else
		{
			jj_consume_token(-1);
			throw new ParseException();
		}
		throw new Error("Missing return statement in function");
	}

	// ******************************************************************************
	// * *
	// * Parse the Problem File *
	// * *
	// ******************************************************************************
	final public boolean parseProblem() throws ParseException
	{
		Token t, t2;
		jj_consume_token(OPEN);
		jj_consume_token(DEFINE);
		jj_consume_token(OPEN);
		jj_consume_token(PROBLEM);
		t = jj_consume_token(NAME);
		jj_consume_token(CLOSE);
		jj_consume_token(OPEN);
		jj_consume_token(DOMAIN_LABEL);
		t2 = jj_consume_token(NAME);
		jj_consume_token(CLOSE);
		UP.ProblemName = t.toString().toLowerCase();
		UP.ProblemDomainName = t2.toString().toLowerCase();
		if (!UP.DomainName.toLowerCase().equals(t2.toString().toLowerCase()))
			System.out
					.println("Warning Domain Name and Problem Name do not match");
		if (jj_2_95(20))
		{
			parseRequireDef();
		}
		else
		{
			;
		}
		if (jj_2_96(20))
		{
			parseObjectDeclaration();
		}
		else
		{
			;
		}
		parseInit();
		if (jj_2_97(20))
		{
			parseGoal();
		}
		else
		{
			;
		}
		if (UP.goal == null)
			UP.goal = new And();
		if (jj_2_98(20))
		{
			parseMetric();
		}
		else
		{
			;
		}
		jj_consume_token(CLOSE);
		jj_consume_token(0);
		{
			if (true)
				return true;
		}
		throw new Error("Missing return statement in function");
	}

	// ***************************************************
	// * Parse the objects
	// ***************************************************
	final public void parseObjectDeclaration() throws ParseException
	{
		TypedList tl;
		jj_consume_token(OPEN);
		jj_consume_token(OBJECTS);
		tl = parseTypedList();
		jj_consume_token(CLOSE);
		Iterator it = tl.objects.iterator();
		while (it.hasNext())
		{
			String str = (String) it.next();
			Type type = (Type) tl.types.get(str);
			PDDLObject o = new PDDLObject(str, type);

			// problems arise if there is an object which has the same name as a
			// constant -- actions
			// and facts may not have the same type information for the "same"
			// literal. In this situation
			// constants take precedence as they may be have already been parsed
			// in the Domain file (as
			// a parameter in an action schema). The object is ignored,
			// regardless of whether the types
			// are different. This is clearly not perfect, but I have been
			// trying to find out the source
			// of a grounding bug for several hours now- and I don't care about
			// design anymore.
			if (UP.constantMap.containsKey(str))
			{
				// these 3 lines will remove the CONSTANT instead -- but there
				// is no check to see
				// if the constant is already being used inside an action schema
				// Constant duplicate = UP.constantMap.remove(str);
				// UP.constants.remove(duplicate);
				// UP.typeSets.get(type).remove(duplicate);

				o = UP.constantMap.get(str);
			}

			UP.objects.add(o);
			UP.objectMap.put(str, o);

			if (UP.typeSets.containsKey(type) == false)
				UP.typeSets.put(type, new HashSet());

			UP.typeSets.get(type).add(o);
		}
	}

	// ***************************************************
	// * Parse the Initial State
	// ***************************************************
	final public void parseInit() throws ParseException
	{
		jj_consume_token(OPEN);
		jj_consume_token(INIT);
		label_18: while (true)
		{
			parseInitEl();
			if (jj_2_99(20))
			{
				;
			}
			else
			{
				break label_18;
			}
		}
		jj_consume_token(CLOSE);
	}

	final public void parseInitEl() throws ParseException
	{
		Literal l;
		TimedInitialLiteral til;
		Token t1;
		NamedFunction nf;
		Fact f;
		if (jj_2_100(20))
		{
			til = parseTIL();
			UP.tils.add(til);
		}
		else if (jj_2_101(20))
		{
			jj_consume_token(OPEN);
			jj_consume_token(EQUALS);
			nf = parseFHead(null);
			t1 = jj_consume_token(NUMBER);
			jj_consume_token(CLOSE);
			UP.funcValues.put(
					nf,
					new BigDecimal(Double.parseDouble(t1.toString()
							.toLowerCase())));
		}
		else if (jj_2_102(20))
		{
			f = parseLiteralName();
			UP.initial.add(f);
		}
		else
		{
			jj_consume_token(-1);
			throw new ParseException();
		}
	}

	final public TimedInitialLiteral parseTIL() throws ParseException
	{
		TimedInitialLiteral til;
		Token timeTok, numTok;
		BigDecimal time, number;
		Fact fact;
		jj_consume_token(OPEN);
		jj_consume_token(NAME);
		timeTok = jj_consume_token(NUMBER);
		fact = parseLiteralName();
		jj_consume_token(CLOSE);
		time = new BigDecimal(Double.parseDouble(timeTok.toString()));

		til = new TimedInitialLiteral((Literal) fact, time);
		{
			if (true)
				return til;
		}
		throw new Error("Missing return statement in function");
	}

	final public Fact parseLiteralName() throws ParseException
	{
		Fact pp;
		if (jj_2_103(20))
		{
			pp = parseAtomicFormula(UP.objectMap, true);
			{
				if (true)
					return pp;
			}
		}
		else if (jj_2_104(20))
		{
			jj_consume_token(OPEN);
			jj_consume_token(NOT);
			pp = parseAtomicFormula(UP.objectMap, true);
			jj_consume_token(CLOSE);
			{
				if (true)
					return new Not(pp);
			}
		}
		else
		{
			jj_consume_token(-1);
			throw new ParseException();
		}
		throw new Error("Missing return statement in function");
	}

	// **********************************
	// * Parse Goal
	// **********************************
	final public void parseGoal() throws ParseException
	{
		Fact e;
		jj_consume_token(OPEN);
		jj_consume_token(GOAL);
		e = parseGD(UP.objectMap, true);
		jj_consume_token(CLOSE);
		UP.goal = (GroundFact) e;
	}

	// **********************************
	// * Parse Metric
	// **********************************
	final public void parseMetric() throws ParseException
	{
		MetricType type;
		Function f1;
		jj_consume_token(OPEN);
		jj_consume_token(METRIC);
		type = parseOptimization();
		f1 = parseFExp(UP.objectMap);
		jj_consume_token(CLOSE);
		UP.metric = new Metric(type, f1);
	}

	final public MetricType parseOptimization() throws ParseException
	{
		Token t1;
		t1 = jj_consume_token(OPTIMIZATION);
		if (t1.toString().toLowerCase().equals("minimize"))
		{
			if (true)
				return MetricType.Minimize;
		}
		else if (t1.toString().toLowerCase().equals("maximize"))
		{
			if (true)
				return MetricType.Maximize;
		}
		else
		{
			if (true)
				throw new ParseException(
						"Unrecognised optimisation metric -- must be \u005c"maximize\u005c" or \u005c"minimize\u005c".");
		}
		throw new Error("Missing return statement in function");
	}

	private boolean jj_2_1(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_1();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(0, xla);
		}
	}

	private boolean jj_2_2(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_2();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(1, xla);
		}
	}

	private boolean jj_2_3(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_3();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(2, xla);
		}
	}

	private boolean jj_2_4(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_4();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(3, xla);
		}
	}

	private boolean jj_2_5(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_5();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(4, xla);
		}
	}

	private boolean jj_2_6(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_6();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(5, xla);
		}
	}

	private boolean jj_2_7(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_7();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(6, xla);
		}
	}

	private boolean jj_2_8(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_8();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(7, xla);
		}
	}

	private boolean jj_2_9(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_9();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(8, xla);
		}
	}

	private boolean jj_2_10(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_10();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(9, xla);
		}
	}

	private boolean jj_2_11(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_11();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(10, xla);
		}
	}

	private boolean jj_2_12(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_12();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(11, xla);
		}
	}

	private boolean jj_2_13(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_13();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(12, xla);
		}
	}

	private boolean jj_2_14(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_14();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(13, xla);
		}
	}

	private boolean jj_2_15(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_15();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(14, xla);
		}
	}

	private boolean jj_2_16(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_16();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(15, xla);
		}
	}

	private boolean jj_2_17(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_17();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(16, xla);
		}
	}

	private boolean jj_2_18(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_18();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(17, xla);
		}
	}

	private boolean jj_2_19(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_19();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(18, xla);
		}
	}

	private boolean jj_2_20(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_20();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(19, xla);
		}
	}

	private boolean jj_2_21(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_21();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(20, xla);
		}
	}

	private boolean jj_2_22(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_22();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(21, xla);
		}
	}

	private boolean jj_2_23(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_23();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(22, xla);
		}
	}

	private boolean jj_2_24(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_24();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(23, xla);
		}
	}

	private boolean jj_2_25(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_25();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(24, xla);
		}
	}

	private boolean jj_2_26(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_26();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(25, xla);
		}
	}

	private boolean jj_2_27(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_27();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(26, xla);
		}
	}

	private boolean jj_2_28(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_28();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(27, xla);
		}
	}

	private boolean jj_2_29(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_29();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(28, xla);
		}
	}

	private boolean jj_2_30(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_30();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(29, xla);
		}
	}

	private boolean jj_2_31(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_31();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(30, xla);
		}
	}

	private boolean jj_2_32(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_32();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(31, xla);
		}
	}

	private boolean jj_2_33(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_33();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(32, xla);
		}
	}

	private boolean jj_2_34(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_34();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(33, xla);
		}
	}

	private boolean jj_2_35(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_35();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(34, xla);
		}
	}

	private boolean jj_2_36(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_36();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(35, xla);
		}
	}

	private boolean jj_2_37(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_37();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(36, xla);
		}
	}

	private boolean jj_2_38(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_38();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(37, xla);
		}
	}

	private boolean jj_2_39(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_39();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(38, xla);
		}
	}

	private boolean jj_2_40(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_40();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(39, xla);
		}
	}

	private boolean jj_2_41(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_41();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(40, xla);
		}
	}

	private boolean jj_2_42(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_42();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(41, xla);
		}
	}

	private boolean jj_2_43(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_43();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(42, xla);
		}
	}

	private boolean jj_2_44(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_44();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(43, xla);
		}
	}

	private boolean jj_2_45(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_45();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(44, xla);
		}
	}

	private boolean jj_2_46(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_46();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(45, xla);
		}
	}

	private boolean jj_2_47(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_47();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(46, xla);
		}
	}

	private boolean jj_2_48(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_48();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(47, xla);
		}
	}

	private boolean jj_2_49(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_49();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(48, xla);
		}
	}

	private boolean jj_2_50(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_50();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(49, xla);
		}
	}

	private boolean jj_2_51(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_51();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(50, xla);
		}
	}

	private boolean jj_2_52(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_52();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(51, xla);
		}
	}

	private boolean jj_2_53(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_53();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(52, xla);
		}
	}

	private boolean jj_2_54(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_54();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(53, xla);
		}
	}

	private boolean jj_2_55(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_55();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(54, xla);
		}
	}

	private boolean jj_2_56(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_56();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(55, xla);
		}
	}

	private boolean jj_2_57(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_57();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(56, xla);
		}
	}

	private boolean jj_2_58(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_58();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(57, xla);
		}
	}

	private boolean jj_2_59(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_59();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(58, xla);
		}
	}

	private boolean jj_2_60(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_60();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(59, xla);
		}
	}

	private boolean jj_2_61(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_61();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(60, xla);
		}
	}

	private boolean jj_2_62(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_62();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(61, xla);
		}
	}

	private boolean jj_2_63(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_63();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(62, xla);
		}
	}

	private boolean jj_2_64(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_64();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(63, xla);
		}
	}

	private boolean jj_2_65(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_65();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(64, xla);
		}
	}

	private boolean jj_2_66(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_66();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(65, xla);
		}
	}

	private boolean jj_2_67(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_67();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(66, xla);
		}
	}

	private boolean jj_2_68(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_68();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(67, xla);
		}
	}

	private boolean jj_2_69(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_69();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(68, xla);
		}
	}

	private boolean jj_2_70(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_70();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(69, xla);
		}
	}

	private boolean jj_2_71(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_71();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(70, xla);
		}
	}

	private boolean jj_2_72(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_72();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(71, xla);
		}
	}

	private boolean jj_2_73(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_73();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(72, xla);
		}
	}

	private boolean jj_2_74(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_74();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(73, xla);
		}
	}

	private boolean jj_2_75(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_75();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(74, xla);
		}
	}

	private boolean jj_2_76(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_76();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(75, xla);
		}
	}

	private boolean jj_2_77(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_77();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(76, xla);
		}
	}

	private boolean jj_2_78(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_78();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(77, xla);
		}
	}

	private boolean jj_2_79(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_79();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(78, xla);
		}
	}

	private boolean jj_2_80(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_80();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(79, xla);
		}
	}

	private boolean jj_2_81(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_81();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(80, xla);
		}
	}

	private boolean jj_2_82(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_82();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(81, xla);
		}
	}

	private boolean jj_2_83(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_83();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(82, xla);
		}
	}

	private boolean jj_2_84(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_84();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(83, xla);
		}
	}

	private boolean jj_2_85(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_85();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(84, xla);
		}
	}

	private boolean jj_2_86(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_86();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(85, xla);
		}
	}

	private boolean jj_2_87(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_87();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(86, xla);
		}
	}

	private boolean jj_2_88(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_88();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(87, xla);
		}
	}

	private boolean jj_2_89(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_89();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(88, xla);
		}
	}

	private boolean jj_2_90(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_90();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(89, xla);
		}
	}

	private boolean jj_2_91(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_91();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(90, xla);
		}
	}

	private boolean jj_2_92(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_92();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(91, xla);
		}
	}

	private boolean jj_2_93(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_93();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(92, xla);
		}
	}

	private boolean jj_2_94(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_94();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(93, xla);
		}
	}

	private boolean jj_2_95(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_95();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(94, xla);
		}
	}

	private boolean jj_2_96(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_96();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(95, xla);
		}
	}

	private boolean jj_2_97(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_97();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(96, xla);
		}
	}

	private boolean jj_2_98(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_98();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(97, xla);
		}
	}

	private boolean jj_2_99(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_99();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(98, xla);
		}
	}

	private boolean jj_2_100(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_100();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(99, xla);
		}
	}

	private boolean jj_2_101(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_101();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(100, xla);
		}
	}

	private boolean jj_2_102(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_102();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(101, xla);
		}
	}

	private boolean jj_2_103(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_103();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(102, xla);
		}
	}

	private boolean jj_2_104(int xla)
	{
		jj_la = xla;
		jj_lastpos = jj_scanpos = token;
		try
		{
			return !jj_3_104();
		}
		catch (LookaheadSuccess ls)
		{
			return true;
		}
		finally
		{
			jj_save(103, xla);
		}
	}

	private boolean jj_3_82()
	{
		if (jj_3R_49())
			return true;
		return false;
	}

	private boolean jj_3_88()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(AT_END))
			return true;
		if (jj_3R_53())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_87()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(AT_END))
			return true;
		if (jj_3R_33())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_13()
	{
		if (jj_3R_26())
			return true;
		return false;
	}

	private boolean jj_3_86()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(AT_START))
			return true;
		if (jj_3R_53())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_85()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(AT_START))
			return true;
		if (jj_3R_33())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3R_52()
	{
		Token xsp;
		xsp = jj_scanpos;
		if (jj_3_85())
		{
			jj_scanpos = xsp;
			if (jj_3_86())
			{
				jj_scanpos = xsp;
				if (jj_3_87())
				{
					jj_scanpos = xsp;
					if (jj_3_88())
						return true;
				}
			}
		}
		return false;
	}

	private boolean jj_3_81()
	{
		if (jj_scan_token(EQUALS))
			return true;
		return false;
	}

	private boolean jj_3_84()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(AND))
			return true;
		Token xsp;
		while (true)
		{
			xsp = jj_scanpos;
			if (jj_3_82())
			{
				jj_scanpos = xsp;
				break;
			}
		}
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_77()
	{
		if (jj_3R_51())
			return true;
		return false;
	}

	private boolean jj_3_83()
	{
		if (jj_3R_52())
			return true;
		return false;
	}

	private boolean jj_3R_49()
	{
		Token xsp;
		xsp = jj_scanpos;
		if (jj_3_83())
		{
			jj_scanpos = xsp;
			if (jj_3_84())
				return true;
		}
		return false;
	}

	private boolean jj_3_12()
	{
		if (jj_3R_26())
			return true;
		return false;
	}

	private boolean jj_3_11()
	{
		Token xsp;
		if (jj_3_12())
			return true;
		while (true)
		{
			xsp = jj_scanpos;
			if (jj_3_12())
			{
				jj_scanpos = xsp;
				break;
			}
		}
		if (jj_scan_token(TYPE_IDENT))
			return true;
		if (jj_3R_25())
			return true;
		return false;
	}

	private boolean jj_3R_35()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_3R_28())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		if (jj_3R_32())
			return true;
		return false;
	}

	private boolean jj_3R_20()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(TYPES))
			return true;
		Token xsp;
		while (true)
		{
			xsp = jj_scanpos;
			if (jj_3_11())
			{
				jj_scanpos = xsp;
				break;
			}
		}
		while (true)
		{
			xsp = jj_scanpos;
			if (jj_3_13())
			{
				jj_scanpos = xsp;
				break;
			}
		}
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_80()
	{
		if (jj_scan_token(BINARY_COMP))
			return true;
		return false;
	}

	private boolean jj_3R_66()
	{
		Token xsp;
		xsp = jj_scanpos;
		if (jj_3_80())
		{
			jj_scanpos = xsp;
			if (jj_3_81())
				return true;
		}
		return false;
	}

	private boolean jj_3_10()
	{
		if (jj_scan_token(PDDL_1_7_LABELS))
			return true;
		return false;
	}

	private boolean jj_3_9()
	{
		if (jj_scan_token(NON_HANDLED_LABELS))
			return true;
		return false;
	}

	private boolean jj_3R_51()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_3R_66())
			return true;
		if (jj_scan_token(DUR_VAR))
			return true;
		if (jj_3R_45())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_79()
	{
		if (jj_3R_51())
			return true;
		return false;
	}

	private boolean jj_3R_36()
	{
		if (jj_3R_32())
			return true;
		if (jj_3R_32())
			return true;
		return false;
	}

	private boolean jj_3R_68()
	{
		Token xsp;
		xsp = jj_scanpos;
		if (jj_3_78())
		{
			jj_scanpos = xsp;
			if (jj_3_79())
				return true;
		}
		return false;
	}

	private boolean jj_3R_34()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_3R_28())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		if (jj_3R_32())
			return true;
		return false;
	}

	private boolean jj_3_78()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(AND))
			return true;
		Token xsp;
		if (jj_3_77())
			return true;
		while (true)
		{
			xsp = jj_scanpos;
			if (jj_3_77())
			{
				jj_scanpos = xsp;
				break;
			}
		}
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_71()
	{
		if (jj_3R_50())
			return true;
		return false;
	}

	private boolean jj_3_76()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(OVER_ALL))
			return true;
		if (jj_3R_32())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_75()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(AT_END))
			return true;
		if (jj_3R_32())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_74()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(AT_START))
			return true;
		if (jj_3R_32())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3R_50()
	{
		Token xsp;
		xsp = jj_scanpos;
		if (jj_3_74())
		{
			jj_scanpos = xsp;
			if (jj_3_75())
			{
				jj_scanpos = xsp;
				if (jj_3_76())
					return true;
			}
		}
		return false;
	}

	private boolean jj_3_73()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(AND))
			return true;
		Token xsp;
		if (jj_3_71())
			return true;
		while (true)
		{
			xsp = jj_scanpos;
			if (jj_3_71())
			{
				jj_scanpos = xsp;
				break;
			}
		}
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_72()
	{
		if (jj_3R_50())
			return true;
		return false;
	}

	private boolean jj_3R_48()
	{
		Token xsp;
		xsp = jj_scanpos;
		if (jj_3_72())
		{
			jj_scanpos = xsp;
			if (jj_3_73())
				return true;
		}
		return false;
	}

	private boolean jj_3_32()
	{
		if (jj_3R_32())
			return true;
		return false;
	}

	private boolean jj_3_29()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_33()
	{
		if (jj_3R_32())
			return true;
		return false;
	}

	private boolean jj_3_7()
	{
		Token xsp;
		xsp = jj_scanpos;
		if (jj_3_8())
		{
			jj_scanpos = xsp;
			if (jj_3_9())
			{
				jj_scanpos = xsp;
				if (jj_3_10())
					return true;
			}
		}
		return false;
	}

	private boolean jj_3_8()
	{
		if (jj_scan_token(REQUIREMENT_LABELS))
			return true;
		return false;
	}

	private boolean jj_3_70()
	{
		if (jj_scan_token(EFFECT))
			return true;
		if (jj_3R_49())
			return true;
		return false;
	}

	private boolean jj_3_69()
	{
		if (jj_scan_token(CONDITION))
			return true;
		if (jj_3R_48())
			return true;
		return false;
	}

	private boolean jj_3R_65()
	{
		if (jj_scan_token(DURATION))
			return true;
		if (jj_3R_68())
			return true;
		Token xsp;
		xsp = jj_scanpos;
		if (jj_3_69())
			jj_scanpos = xsp;
		xsp = jj_scanpos;
		if (jj_3_70())
			jj_scanpos = xsp;
		return false;
	}

	private boolean jj_3R_37()
	{
		if (jj_3R_28())
			return true;
		return false;
	}

	private boolean jj_3R_19()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(REQUIREMENTS))
			return true;
		Token xsp;
		while (true)
		{
			xsp = jj_scanpos;
			if (jj_3_7())
			{
				jj_scanpos = xsp;
				break;
			}
		}
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_43()
	{
		if (jj_3R_39())
			return true;
		return false;
	}

	private boolean jj_3_42()
	{
		if (jj_3R_38())
			return true;
		return false;
	}

	private boolean jj_3_40()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(IMPLY))
			return true;
		if (jj_3R_36())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_39()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(EXISTS))
			return true;
		if (jj_3R_35())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_38()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(FOR_ALL))
			return true;
		if (jj_3R_34())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_41()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(EQUALS))
			return true;
		if (jj_3R_37())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_37()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(NOT))
			return true;
		if (jj_3R_32())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_6()
	{
		if (jj_3R_24())
			return true;
		return false;
	}

	private boolean jj_3_36()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(OR))
			return true;
		Token xsp;
		while (true)
		{
			xsp = jj_scanpos;
			if (jj_3_33())
			{
				jj_scanpos = xsp;
				break;
			}
		}
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_5()
	{
		if (jj_3R_23())
			return true;
		return false;
	}

	private boolean jj_3_35()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(AND))
			return true;
		Token xsp;
		while (true)
		{
			xsp = jj_scanpos;
			if (jj_3_32())
			{
				jj_scanpos = xsp;
				break;
			}
		}
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_4()
	{
		if (jj_3R_22())
			return true;
		return false;
	}

	private boolean jj_3_34()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3R_32()
	{
		Token xsp;
		xsp = jj_scanpos;
		if (jj_3_34())
		{
			jj_scanpos = xsp;
			if (jj_3_35())
			{
				jj_scanpos = xsp;
				if (jj_3_36())
				{
					jj_scanpos = xsp;
					if (jj_3_37())
					{
						jj_scanpos = xsp;
						if (jj_3_38())
						{
							jj_scanpos = xsp;
							if (jj_3_39())
							{
								jj_scanpos = xsp;
								if (jj_3_40())
								{
									jj_scanpos = xsp;
									if (jj_3_41())
									{
										jj_scanpos = xsp;
										if (jj_3_42())
										{
											jj_scanpos = xsp;
											if (jj_3_43())
												return true;
										}
									}
								}
							}
						}
					}
				}
			}
		}
		return false;
	}

	private boolean jj_3_3()
	{
		if (jj_3R_21())
			return true;
		return false;
	}

	private boolean jj_3_2()
	{
		if (jj_3R_20())
			return true;
		return false;
	}

	private boolean jj_3_1()
	{
		if (jj_3R_19())
			return true;
		return false;
	}

	private boolean jj_3R_31()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(DURATIVE_ACTION))
			return true;
		if (jj_3R_63())
			return true;
		if (jj_scan_token(PARAMETERS))
			return true;
		if (jj_scan_token(OPEN))
			return true;
		if (jj_3R_28())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		if (jj_3R_65())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_28()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_3R_28())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_65()
	{
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3R_67()
	{
		if (jj_scan_token(OPTIMIZATION))
			return true;
		return false;
	}

	private boolean jj_3R_43()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(ASSIGN_OP))
			return true;
		if (jj_3R_46())
			return true;
		if (jj_3R_45())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_31()
	{
		if (jj_scan_token(EFFECT))
			return true;
		if (jj_3R_33())
			return true;
		return false;
	}

	private boolean jj_3_30()
	{
		if (jj_scan_token(PRECONDITION))
			return true;
		if (jj_3R_32())
			return true;
		return false;
	}

	private boolean jj_3R_64()
	{
		Token xsp;
		xsp = jj_scanpos;
		if (jj_3_30())
			jj_scanpos = xsp;
		xsp = jj_scanpos;
		if (jj_3_31())
			jj_scanpos = xsp;
		return false;
	}

	private boolean jj_3R_57()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(METRIC))
			return true;
		if (jj_3R_67())
			return true;
		if (jj_3R_45())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3R_63()
	{
		if (jj_scan_token(NAME))
			return true;
		return false;
	}

	private boolean jj_3_64()
	{
		if (jj_scan_token(OPEN))
			return true;
		return false;
	}

	private boolean jj_3_68()
	{
		if (jj_3R_47())
			return true;
		return false;
	}

	private boolean jj_3_67()
	{
		Token xsp;
		xsp = jj_scanpos;
		if (jj_3_64())
			jj_scanpos = xsp;
		if (jj_scan_token(TOTAL_TIME))
			return true;
		xsp = jj_scanpos;
		if (jj_3_65())
			jj_scanpos = xsp;
		return false;
	}

	private boolean jj_3R_56()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(GOAL))
			return true;
		if (jj_3R_32())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_66()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_3R_47())
			return true;
		if (jj_3R_28())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3R_46()
	{
		Token xsp;
		xsp = jj_scanpos;
		if (jj_3_66())
		{
			jj_scanpos = xsp;
			if (jj_3_67())
			{
				jj_scanpos = xsp;
				if (jj_3_68())
					return true;
			}
		}
		return false;
	}

	private boolean jj_3_104()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(NOT))
			return true;
		if (jj_3R_38())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3R_30()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(ACTION))
			return true;
		if (jj_3R_63())
			return true;
		if (jj_scan_token(PARAMETERS))
			return true;
		Token xsp;
		xsp = jj_scanpos;
		if (jj_3_28())
		{
			jj_scanpos = xsp;
			if (jj_3_29())
				return true;
		}
		if (jj_3R_64())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_63()
	{
		if (jj_3R_46())
			return true;
		return false;
	}

	private boolean jj_3R_60()
	{
		Token xsp;
		xsp = jj_scanpos;
		if (jj_3_103())
		{
			jj_scanpos = xsp;
			if (jj_3_104())
				return true;
		}
		return false;
	}

	private boolean jj_3_103()
	{
		if (jj_3R_38())
			return true;
		return false;
	}

	private boolean jj_3_62()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(TYPE_IDENT))
			return true;
		if (jj_3R_45())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_27()
	{
		if (jj_3R_31())
			return true;
		return false;
	}

	private boolean jj_3_26()
	{
		if (jj_3R_30())
			return true;
		return false;
	}

	private boolean jj_3R_24()
	{
		Token xsp;
		xsp = jj_scanpos;
		if (jj_3_26())
		{
			jj_scanpos = xsp;
			if (jj_3_27())
				return true;
		}
		return false;
	}

	private boolean jj_3_61()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(TYPE_IDENT))
			return true;
		if (jj_3R_45())
			return true;
		if (jj_3R_45())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_60()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(BINARY_OP))
			return true;
		if (jj_3R_45())
			return true;
		if (jj_3R_45())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_59()
	{
		if (jj_scan_token(NUMBER))
			return true;
		return false;
	}

	private boolean jj_3R_45()
	{
		Token xsp;
		xsp = jj_scanpos;
		if (jj_3_59())
		{
			jj_scanpos = xsp;
			if (jj_3_60())
			{
				jj_scanpos = xsp;
				if (jj_3_61())
				{
					jj_scanpos = xsp;
					if (jj_3_62())
					{
						jj_scanpos = xsp;
						if (jj_3_63())
							return true;
					}
				}
			}
		}
		return false;
	}

	private boolean jj_3R_59()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(NAME))
			return true;
		if (jj_scan_token(NUMBER))
			return true;
		if (jj_3R_60())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3R_62()
	{
		if (jj_scan_token(NAME))
			return true;
		return false;
	}

	private boolean jj_3R_39()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(BINARY_COMP))
			return true;
		if (jj_3R_45())
			return true;
		if (jj_3R_45())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_25()
	{
		if (jj_3R_29())
			return true;
		return false;
	}

	private boolean jj_3_102()
	{
		if (jj_3R_60())
			return true;
		return false;
	}

	private boolean jj_3_101()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(EQUALS))
			return true;
		if (jj_3R_46())
			return true;
		if (jj_scan_token(NUMBER))
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3R_58()
	{
		Token xsp;
		xsp = jj_scanpos;
		if (jj_3_100())
		{
			jj_scanpos = xsp;
			if (jj_3_101())
			{
				jj_scanpos = xsp;
				if (jj_3_102())
					return true;
			}
		}
		return false;
	}

	private boolean jj_3_100()
	{
		if (jj_3R_59())
			return true;
		return false;
	}

	private boolean jj_3_99()
	{
		if (jj_3R_58())
			return true;
		return false;
	}

	private boolean jj_3R_29()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_3R_62())
			return true;
		if (jj_3R_28())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_58()
	{
		if (jj_scan_token(TYPE_IDENT))
			return true;
		if (jj_scan_token(NUMBER_TYPE))
			return true;
		return false;
	}

	private boolean jj_3R_47()
	{
		if (jj_scan_token(NAME))
			return true;
		return false;
	}

	private boolean jj_3R_22()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(PREDICATES))
			return true;
		Token xsp;
		if (jj_3_25())
			return true;
		while (true)
		{
			xsp = jj_scanpos;
			if (jj_3_25())
			{
				jj_scanpos = xsp;
				break;
			}
		}
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_57()
	{
		if (jj_3R_44())
			return true;
		return false;
	}

	private boolean jj_3_51()
	{
		if (jj_3R_42())
			return true;
		return false;
	}

	private boolean jj_3R_21()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(CONSTANTS))
			return true;
		if (jj_3R_28())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3R_44()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_3R_47())
			return true;
		if (jj_3R_28())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		Token xsp;
		xsp = jj_scanpos;
		if (jj_3_58())
			jj_scanpos = xsp;
		return false;
	}

	private boolean jj_3R_23()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(FUNCTIONS))
			return true;
		Token xsp;
		if (jj_3_57())
			return true;
		while (true)
		{
			xsp = jj_scanpos;
			if (jj_3_57())
			{
				jj_scanpos = xsp;
				break;
			}
		}
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_23()
	{
		if (jj_scan_token(VAR))
			return true;
		return false;
	}

	private boolean jj_3_56()
	{
		if (jj_3R_43())
			return true;
		return false;
	}

	private boolean jj_3_22()
	{
		if (jj_scan_token(NAME))
			return true;
		return false;
	}

	private boolean jj_3_55()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(NOT))
			return true;
		if (jj_3R_38())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_54()
	{
		if (jj_3R_38())
			return true;
		return false;
	}

	private boolean jj_3R_42()
	{
		Token xsp;
		xsp = jj_scanpos;
		if (jj_3_54())
		{
			jj_scanpos = xsp;
			if (jj_3_55())
			{
				jj_scanpos = xsp;
				if (jj_3_56())
					return true;
			}
		}
		return false;
	}

	private boolean jj_3_21()
	{
		Token xsp;
		xsp = jj_scanpos;
		if (jj_3_22())
		{
			jj_scanpos = xsp;
			if (jj_3_23())
				return true;
		}
		return false;
	}

	private boolean jj_3_44()
	{
		if (jj_3R_40())
			return true;
		return false;
	}

	private boolean jj_3R_61()
	{
		Token xsp;
		while (true)
		{
			xsp = jj_scanpos;
			if (jj_3_21())
			{
				jj_scanpos = xsp;
				break;
			}
		}
		return false;
	}

	private boolean jj_3_53()
	{
		if (jj_3R_42())
			return true;
		return false;
	}

	private boolean jj_3_52()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(AND))
			return true;
		Token xsp;
		while (true)
		{
			xsp = jj_scanpos;
			if (jj_3_51())
			{
				jj_scanpos = xsp;
				break;
			}
		}
		return false;
	}

	private boolean jj_3R_41()
	{
		Token xsp;
		xsp = jj_scanpos;
		if (jj_3_52())
		{
			jj_scanpos = xsp;
			if (jj_3_53())
				return true;
		}
		return false;
	}

	private boolean jj_3R_55()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(OBJECTS))
			return true;
		if (jj_3R_28())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_98()
	{
		if (jj_3R_57())
			return true;
		return false;
	}

	private boolean jj_3_20()
	{
		if (jj_scan_token(TYPE_IDENT))
			return true;
		if (jj_3R_25())
			return true;
		return false;
	}

	private boolean jj_3_50()
	{
		if (jj_3R_42())
			return true;
		return false;
	}

	private boolean jj_3_18()
	{
		if (jj_scan_token(VAR))
			return true;
		return false;
	}

	private boolean jj_3_49()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(WHEN))
			return true;
		if (jj_3R_32())
			return true;
		if (jj_3R_41())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_48()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(FOR_ALL))
			return true;
		if (jj_3R_34())
			return true;
		if (jj_3R_33())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3R_40()
	{
		Token xsp;
		xsp = jj_scanpos;
		if (jj_3_48())
		{
			jj_scanpos = xsp;
			if (jj_3_49())
			{
				jj_scanpos = xsp;
				if (jj_3_50())
					return true;
			}
		}
		return false;
	}

	private boolean jj_3_17()
	{
		if (jj_scan_token(NAME))
			return true;
		return false;
	}

	private boolean jj_3_97()
	{
		if (jj_3R_56())
			return true;
		return false;
	}

	private boolean jj_3_19()
	{
		Token xsp;
		xsp = jj_scanpos;
		if (jj_3_17())
		{
			jj_scanpos = xsp;
			if (jj_3_18())
				return true;
		}
		return false;
	}

	private boolean jj_3_96()
	{
		if (jj_3R_55())
			return true;
		return false;
	}

	private boolean jj_3_95()
	{
		if (jj_3R_19())
			return true;
		return false;
	}

	private boolean jj_3_16()
	{
		if (jj_3R_26())
			return true;
		return false;
	}

	private boolean jj_3_47()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(AND))
			return true;
		Token xsp;
		while (true)
		{
			xsp = jj_scanpos;
			if (jj_3_44())
			{
				jj_scanpos = xsp;
				break;
			}
		}
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_24()
	{
		Token xsp;
		if (jj_3_19())
			return true;
		while (true)
		{
			xsp = jj_scanpos;
			if (jj_3_19())
			{
				jj_scanpos = xsp;
				break;
			}
		}
		xsp = jj_scanpos;
		if (jj_3_20())
			jj_scanpos = xsp;
		if (jj_3R_28())
			return true;
		return false;
	}

	private boolean jj_3_46()
	{
		if (jj_3R_40())
			return true;
		return false;
	}

	private boolean jj_3_45()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3R_33()
	{
		Token xsp;
		xsp = jj_scanpos;
		if (jj_3_45())
		{
			jj_scanpos = xsp;
			if (jj_3_46())
			{
				jj_scanpos = xsp;
				if (jj_3_47())
					return true;
			}
		}
		return false;
	}

	private boolean jj_3R_28()
	{
		Token xsp;
		xsp = jj_scanpos;
		if (jj_3_24())
		{
			jj_scanpos = xsp;
			if (jj_3R_61())
				return true;
		}
		return false;
	}

	private boolean jj_3R_27()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(EITHER))
			return true;
		Token xsp;
		if (jj_3_16())
			return true;
		while (true)
		{
			xsp = jj_scanpos;
			if (jj_3_16())
			{
				jj_scanpos = xsp;
				break;
			}
		}
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_94()
	{
		if (jj_3R_45())
			return true;
		return false;
	}

	private boolean jj_3_93()
	{
		if (jj_scan_token(DUR_VAR))
			return true;
		return false;
	}

	private boolean jj_3_92()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(TYPE_IDENT))
			return true;
		if (jj_3R_54())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_91()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(TYPE_IDENT))
			return true;
		if (jj_3R_54())
			return true;
		if (jj_3R_54())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_90()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(BINARY_OP))
			return true;
		if (jj_3R_54())
			return true;
		if (jj_3R_54())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_89()
	{
		if (jj_scan_token(NUMBER))
			return true;
		return false;
	}

	private boolean jj_3R_54()
	{
		Token xsp;
		xsp = jj_scanpos;
		if (jj_3_89())
		{
			jj_scanpos = xsp;
			if (jj_3_90())
			{
				jj_scanpos = xsp;
				if (jj_3_91())
				{
					jj_scanpos = xsp;
					if (jj_3_92())
					{
						jj_scanpos = xsp;
						if (jj_3_93())
						{
							jj_scanpos = xsp;
							if (jj_3_94())
								return true;
						}
					}
				}
			}
		}
		return false;
	}

	private boolean jj_3R_26()
	{
		if (jj_scan_token(NAME))
			return true;
		return false;
	}

	private boolean jj_3R_38()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_3R_62())
			return true;
		if (jj_3R_28())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3_15()
	{
		if (jj_3R_27())
			return true;
		return false;
	}

	private boolean jj_3_14()
	{
		if (jj_3R_26())
			return true;
		return false;
	}

	private boolean jj_3R_53()
	{
		if (jj_scan_token(OPEN))
			return true;
		if (jj_scan_token(ASSIGN_OP))
			return true;
		if (jj_3R_46())
			return true;
		if (jj_3R_54())
			return true;
		if (jj_scan_token(CLOSE))
			return true;
		return false;
	}

	private boolean jj_3R_25()
	{
		Token xsp;
		xsp = jj_scanpos;
		if (jj_3_14())
		{
			jj_scanpos = xsp;
			if (jj_3_15())
				return true;
		}
		return false;
	}

	/** Generated Token Manager. */
	public PDDL21parserTokenManager token_source;
	SimpleCharStream jj_input_stream;
	/** Current token. */
	public Token token;
	/** Next token. */
	public Token jj_nt;
	private int jj_ntk;
	private Token jj_scanpos, jj_lastpos;
	private int jj_la;
	private int jj_gen;
	final private int[] jj_la1 = new int[0];
	static private int[] jj_la1_0;
	static private int[] jj_la1_1;
	static
	{
		jj_la1_init_0();
		jj_la1_init_1();
	}

	private static void jj_la1_init_0()
	{
		jj_la1_0 = new int[] {};
	}

	private static void jj_la1_init_1()
	{
		jj_la1_1 = new int[] {};
	}

	final private JJCalls[] jj_2_rtns = new JJCalls[104];
	private boolean jj_rescan = false;
	private int jj_gc = 0;

	/** Constructor with InputStream. */
	public PDDL21parser(java.io.InputStream stream)
	{
		this(stream, null);
	}

	/** Constructor with InputStream and supplied encoding */
	public PDDL21parser(java.io.InputStream stream, String encoding)
	{
		try
		{
			jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
		}
		catch (java.io.UnsupportedEncodingException e)
		{
			throw new RuntimeException(e);
		}
		token_source = new PDDL21parserTokenManager(jj_input_stream);
		token = new Token();
		jj_ntk = -1;
		jj_gen = 0;
		for (int i = 0; i < 0; i++)
			jj_la1[i] = -1;
		for (int i = 0; i < jj_2_rtns.length; i++)
			jj_2_rtns[i] = new JJCalls();
	}

	/** Reinitialise. */
	public void ReInit(java.io.InputStream stream)
	{
		ReInit(stream, null);
	}

	/** Reinitialise. */
	public void ReInit(java.io.InputStream stream, String encoding)
	{
		try
		{
			jj_input_stream.ReInit(stream, encoding, 1, 1);
		}
		catch (java.io.UnsupportedEncodingException e)
		{
			throw new RuntimeException(e);
		}
		token_source.ReInit(jj_input_stream);
		token = new Token();
		jj_ntk = -1;
		jj_gen = 0;
		for (int i = 0; i < 0; i++)
			jj_la1[i] = -1;
		for (int i = 0; i < jj_2_rtns.length; i++)
			jj_2_rtns[i] = new JJCalls();
	}

	/** Constructor. */
	public PDDL21parser(java.io.Reader stream)
	{
		jj_input_stream = new SimpleCharStream(stream, 1, 1);
		token_source = new PDDL21parserTokenManager(jj_input_stream);
		token = new Token();
		jj_ntk = -1;
		jj_gen = 0;
		for (int i = 0; i < 0; i++)
			jj_la1[i] = -1;
		for (int i = 0; i < jj_2_rtns.length; i++)
			jj_2_rtns[i] = new JJCalls();
	}

	/** Reinitialise. */
	public void ReInit(java.io.Reader stream)
	{
		jj_input_stream.ReInit(stream, 1, 1);
		token_source.ReInit(jj_input_stream);
		token = new Token();
		jj_ntk = -1;
		jj_gen = 0;
		for (int i = 0; i < 0; i++)
			jj_la1[i] = -1;
		for (int i = 0; i < jj_2_rtns.length; i++)
			jj_2_rtns[i] = new JJCalls();
	}

	/** Constructor with generated Token Manager. */
	public PDDL21parser(PDDL21parserTokenManager tm)
	{
		token_source = tm;
		token = new Token();
		jj_ntk = -1;
		jj_gen = 0;
		for (int i = 0; i < 0; i++)
			jj_la1[i] = -1;
		for (int i = 0; i < jj_2_rtns.length; i++)
			jj_2_rtns[i] = new JJCalls();
	}

	/** Reinitialise. */
	public void ReInit(PDDL21parserTokenManager tm)
	{
		token_source = tm;
		token = new Token();
		jj_ntk = -1;
		jj_gen = 0;
		for (int i = 0; i < 0; i++)
			jj_la1[i] = -1;
		for (int i = 0; i < jj_2_rtns.length; i++)
			jj_2_rtns[i] = new JJCalls();
	}

	private Token jj_consume_token(int kind) throws ParseException
	{
		Token oldToken;
		if ((oldToken = token).next != null)
			token = token.next;
		else
			token = token.next = token_source.getNextToken();
		jj_ntk = -1;
		if (token.kind == kind)
		{
			jj_gen++;
			if (++jj_gc > 100)
			{
				jj_gc = 0;
				for (int i = 0; i < jj_2_rtns.length; i++)
				{
					JJCalls c = jj_2_rtns[i];
					while (c != null)
					{
						if (c.gen < jj_gen)
							c.first = null;
						c = c.next;
					}
				}
			}
			return token;
		}
		token = oldToken;
		jj_kind = kind;
		throw generateParseException();
	}

	static private final class LookaheadSuccess extends java.lang.Error
	{
	}

	final private LookaheadSuccess jj_ls = new LookaheadSuccess();

	private boolean jj_scan_token(int kind)
	{
		if (jj_scanpos == jj_lastpos)
		{
			jj_la--;
			if (jj_scanpos.next == null)
			{
				jj_lastpos = jj_scanpos = jj_scanpos.next = token_source
						.getNextToken();
			}
			else
			{
				jj_lastpos = jj_scanpos = jj_scanpos.next;
			}
		}
		else
		{
			jj_scanpos = jj_scanpos.next;
		}
		if (jj_rescan)
		{
			int i = 0;
			Token tok = token;
			while (tok != null && tok != jj_scanpos)
			{
				i++;
				tok = tok.next;
			}
			if (tok != null)
				jj_add_error_token(kind, i);
		}
		if (jj_scanpos.kind != kind)
			return true;
		if (jj_la == 0 && jj_scanpos == jj_lastpos)
			throw jj_ls;
		return false;
	}

	/** Get the next Token. */
	final public Token getNextToken()
	{
		if (token.next != null)
			token = token.next;
		else
			token = token.next = token_source.getNextToken();
		jj_ntk = -1;
		jj_gen++;
		return token;
	}

	/** Get the specific Token. */
	final public Token getToken(int index)
	{
		Token t = token;
		for (int i = 0; i < index; i++)
		{
			if (t.next != null)
				t = t.next;
			else
				t = t.next = token_source.getNextToken();
		}
		return t;
	}

	private int jj_ntk()
	{
		if ((jj_nt = token.next) == null)
			return (jj_ntk = (token.next = token_source.getNextToken()).kind);
		else
			return (jj_ntk = jj_nt.kind);
	}

	private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
	private int[] jj_expentry;
	private int jj_kind = -1;
	private int[] jj_lasttokens = new int[100];
	private int jj_endpos;

	private void jj_add_error_token(int kind, int pos)
	{
		if (pos >= 100)
			return;
		if (pos == jj_endpos + 1)
		{
			jj_lasttokens[jj_endpos++] = kind;
		}
		else if (jj_endpos != 0)
		{
			jj_expentry = new int[jj_endpos];
			for (int i = 0; i < jj_endpos; i++)
			{
				jj_expentry[i] = jj_lasttokens[i];
			}
			jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries
					.iterator(); it.hasNext();)
			{
				int[] oldentry = (int[]) (it.next());
				if (oldentry.length == jj_expentry.length)
				{
					for (int i = 0; i < jj_expentry.length; i++)
					{
						if (oldentry[i] != jj_expentry[i])
						{
							continue jj_entries_loop;
						}
					}
					jj_expentries.add(jj_expentry);
					break jj_entries_loop;
				}
			}
			if (pos != 0)
				jj_lasttokens[(jj_endpos = pos) - 1] = kind;
		}
	}

	/** Generate ParseException. */
	public ParseException generateParseException()
	{
		jj_expentries.clear();
		boolean[] la1tokens = new boolean[63];
		if (jj_kind >= 0)
		{
			la1tokens[jj_kind] = true;
			jj_kind = -1;
		}
		for (int i = 0; i < 0; i++)
		{
			if (jj_la1[i] == jj_gen)
			{
				for (int j = 0; j < 32; j++)
				{
					if ((jj_la1_0[i] & (1 << j)) != 0)
					{
						la1tokens[j] = true;
					}
					if ((jj_la1_1[i] & (1 << j)) != 0)
					{
						la1tokens[32 + j] = true;
					}
				}
			}
		}
		for (int i = 0; i < 63; i++)
		{
			if (la1tokens[i])
			{
				jj_expentry = new int[1];
				jj_expentry[0] = i;
				jj_expentries.add(jj_expentry);
			}
		}
		jj_endpos = 0;
		jj_rescan_token();
		jj_add_error_token(0, 0);
		int[][] exptokseq = new int[jj_expentries.size()][];
		for (int i = 0; i < jj_expentries.size(); i++)
		{
			exptokseq[i] = jj_expentries.get(i);
		}
		return new ParseException(token, exptokseq, tokenImage);
	}

	/** Enable tracing. */
	final public void enable_tracing()
	{
	}

	/** Disable tracing. */
	final public void disable_tracing()
	{
	}

	private void jj_rescan_token()
	{
		jj_rescan = true;
		for (int i = 0; i < 104; i++)
		{
			try
			{
				JJCalls p = jj_2_rtns[i];
				do
				{
					if (p.gen > jj_gen)
					{
						jj_la = p.arg;
						jj_lastpos = jj_scanpos = p.first;
						switch (i)
						{
						case 0:
							jj_3_1();
							break;
						case 1:
							jj_3_2();
							break;
						case 2:
							jj_3_3();
							break;
						case 3:
							jj_3_4();
							break;
						case 4:
							jj_3_5();
							break;
						case 5:
							jj_3_6();
							break;
						case 6:
							jj_3_7();
							break;
						case 7:
							jj_3_8();
							break;
						case 8:
							jj_3_9();
							break;
						case 9:
							jj_3_10();
							break;
						case 10:
							jj_3_11();
							break;
						case 11:
							jj_3_12();
							break;
						case 12:
							jj_3_13();
							break;
						case 13:
							jj_3_14();
							break;
						case 14:
							jj_3_15();
							break;
						case 15:
							jj_3_16();
							break;
						case 16:
							jj_3_17();
							break;
						case 17:
							jj_3_18();
							break;
						case 18:
							jj_3_19();
							break;
						case 19:
							jj_3_20();
							break;
						case 20:
							jj_3_21();
							break;
						case 21:
							jj_3_22();
							break;
						case 22:
							jj_3_23();
							break;
						case 23:
							jj_3_24();
							break;
						case 24:
							jj_3_25();
							break;
						case 25:
							jj_3_26();
							break;
						case 26:
							jj_3_27();
							break;
						case 27:
							jj_3_28();
							break;
						case 28:
							jj_3_29();
							break;
						case 29:
							jj_3_30();
							break;
						case 30:
							jj_3_31();
							break;
						case 31:
							jj_3_32();
							break;
						case 32:
							jj_3_33();
							break;
						case 33:
							jj_3_34();
							break;
						case 34:
							jj_3_35();
							break;
						case 35:
							jj_3_36();
							break;
						case 36:
							jj_3_37();
							break;
						case 37:
							jj_3_38();
							break;
						case 38:
							jj_3_39();
							break;
						case 39:
							jj_3_40();
							break;
						case 40:
							jj_3_41();
							break;
						case 41:
							jj_3_42();
							break;
						case 42:
							jj_3_43();
							break;
						case 43:
							jj_3_44();
							break;
						case 44:
							jj_3_45();
							break;
						case 45:
							jj_3_46();
							break;
						case 46:
							jj_3_47();
							break;
						case 47:
							jj_3_48();
							break;
						case 48:
							jj_3_49();
							break;
						case 49:
							jj_3_50();
							break;
						case 50:
							jj_3_51();
							break;
						case 51:
							jj_3_52();
							break;
						case 52:
							jj_3_53();
							break;
						case 53:
							jj_3_54();
							break;
						case 54:
							jj_3_55();
							break;
						case 55:
							jj_3_56();
							break;
						case 56:
							jj_3_57();
							break;
						case 57:
							jj_3_58();
							break;
						case 58:
							jj_3_59();
							break;
						case 59:
							jj_3_60();
							break;
						case 60:
							jj_3_61();
							break;
						case 61:
							jj_3_62();
							break;
						case 62:
							jj_3_63();
							break;
						case 63:
							jj_3_64();
							break;
						case 64:
							jj_3_65();
							break;
						case 65:
							jj_3_66();
							break;
						case 66:
							jj_3_67();
							break;
						case 67:
							jj_3_68();
							break;
						case 68:
							jj_3_69();
							break;
						case 69:
							jj_3_70();
							break;
						case 70:
							jj_3_71();
							break;
						case 71:
							jj_3_72();
							break;
						case 72:
							jj_3_73();
							break;
						case 73:
							jj_3_74();
							break;
						case 74:
							jj_3_75();
							break;
						case 75:
							jj_3_76();
							break;
						case 76:
							jj_3_77();
							break;
						case 77:
							jj_3_78();
							break;
						case 78:
							jj_3_79();
							break;
						case 79:
							jj_3_80();
							break;
						case 80:
							jj_3_81();
							break;
						case 81:
							jj_3_82();
							break;
						case 82:
							jj_3_83();
							break;
						case 83:
							jj_3_84();
							break;
						case 84:
							jj_3_85();
							break;
						case 85:
							jj_3_86();
							break;
						case 86:
							jj_3_87();
							break;
						case 87:
							jj_3_88();
							break;
						case 88:
							jj_3_89();
							break;
						case 89:
							jj_3_90();
							break;
						case 90:
							jj_3_91();
							break;
						case 91:
							jj_3_92();
							break;
						case 92:
							jj_3_93();
							break;
						case 93:
							jj_3_94();
							break;
						case 94:
							jj_3_95();
							break;
						case 95:
							jj_3_96();
							break;
						case 96:
							jj_3_97();
							break;
						case 97:
							jj_3_98();
							break;
						case 98:
							jj_3_99();
							break;
						case 99:
							jj_3_100();
							break;
						case 100:
							jj_3_101();
							break;
						case 101:
							jj_3_102();
							break;
						case 102:
							jj_3_103();
							break;
						case 103:
							jj_3_104();
							break;
						}
					}
					p = p.next;
				}
				while (p != null);
			}
			catch (LookaheadSuccess ls)
			{
			}
		}
		jj_rescan = false;
	}

	private void jj_save(int index, int xla)
	{
		JJCalls p = jj_2_rtns[index];
		while (p.gen > jj_gen)
		{
			if (p.next == null)
			{
				p = p.next = new JJCalls();
				break;
			}
			p = p.next;
		}
		p.gen = jj_gen + xla - jj_la;
		p.first = token;
		p.arg = xla;
	}

	static final class JJCalls
	{
		int gen;
		Token first;
		int arg;
		JJCalls next;
	}

}
