(ns clj-bson.core
  (:use somnium.congomongo.coerce)
  (:import [org.bson BasicBSONEncoder LazyBSONDecoder]))

(defn encode
  "Returns the encoded bytes.

  map 
    The map to encode.
  returns
    The bytes"
  [map]
  (let [encoder (BasicBSONEncoder.)]
    (.encode encoder (coerce map [:clojure :mongo]))))

(defn decode
  "Decodes the bytes into a clojure object.

  b - The bytes to decode.

  return
    The clojure map."
  [^bytes b]
  (let [decoder (LazyBSONDecoder. )]
    (coerce (.readObject decoder b) [:mongo :clojure])))
