goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = true;

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_39444 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (shadow.dom._to_dom[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null,this$));
} else {
var m__5349__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_39444(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_39445 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (shadow.dom._to_svg[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null,this$));
} else {
var m__5349__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_39445(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__39165 = coll;
var G__39166 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__39165,G__39166) : shadow.dom.lazy_native_coll_seq.call(null,G__39165,G__39166));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__5002__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__39173 = arguments.length;
switch (G__39173) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__39175 = arguments.length;
switch (G__39175) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__39177 = arguments.length;
switch (G__39177) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__39182 = arguments.length;
switch (G__39182) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__39185 = arguments.length;
switch (G__39185) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__39199 = arguments.length;
switch (G__39199) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__5002__auto__ = (!((typeof document !== 'undefined')));
if(or__5002__auto__){
return or__5002__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e39206){if((e39206 instanceof Object)){
var e = e39206;
return console.log("didnt support attachEvent",el,e);
} else {
throw e39206;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__5002__auto__ = (!((typeof document !== 'undefined')));
if(or__5002__auto__){
return or__5002__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__39207 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__39208 = null;
var count__39209 = (0);
var i__39210 = (0);
while(true){
if((i__39210 < count__39209)){
var el = chunk__39208.cljs$core$IIndexed$_nth$arity$2(null,i__39210);
var handler_39452__$1 = ((function (seq__39207,chunk__39208,count__39209,i__39210,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__39207,chunk__39208,count__39209,i__39210,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_39452__$1);


var G__39453 = seq__39207;
var G__39454 = chunk__39208;
var G__39455 = count__39209;
var G__39456 = (i__39210 + (1));
seq__39207 = G__39453;
chunk__39208 = G__39454;
count__39209 = G__39455;
i__39210 = G__39456;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__39207);
if(temp__5823__auto__){
var seq__39207__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__39207__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__39207__$1);
var G__39457 = cljs.core.chunk_rest(seq__39207__$1);
var G__39458 = c__5525__auto__;
var G__39459 = cljs.core.count(c__5525__auto__);
var G__39460 = (0);
seq__39207 = G__39457;
chunk__39208 = G__39458;
count__39209 = G__39459;
i__39210 = G__39460;
continue;
} else {
var el = cljs.core.first(seq__39207__$1);
var handler_39461__$1 = ((function (seq__39207,chunk__39208,count__39209,i__39210,el,seq__39207__$1,temp__5823__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__39207,chunk__39208,count__39209,i__39210,el,seq__39207__$1,temp__5823__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_39461__$1);


var G__39462 = cljs.core.next(seq__39207__$1);
var G__39463 = null;
var G__39464 = (0);
var G__39465 = (0);
seq__39207 = G__39462;
chunk__39208 = G__39463;
count__39209 = G__39464;
i__39210 = G__39465;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__39212 = arguments.length;
switch (G__39212) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__39213 = cljs.core.seq(events);
var chunk__39214 = null;
var count__39215 = (0);
var i__39216 = (0);
while(true){
if((i__39216 < count__39215)){
var vec__39223 = chunk__39214.cljs$core$IIndexed$_nth$arity$2(null,i__39216);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39223,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39223,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__39467 = seq__39213;
var G__39468 = chunk__39214;
var G__39469 = count__39215;
var G__39470 = (i__39216 + (1));
seq__39213 = G__39467;
chunk__39214 = G__39468;
count__39215 = G__39469;
i__39216 = G__39470;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__39213);
if(temp__5823__auto__){
var seq__39213__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__39213__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__39213__$1);
var G__39471 = cljs.core.chunk_rest(seq__39213__$1);
var G__39472 = c__5525__auto__;
var G__39473 = cljs.core.count(c__5525__auto__);
var G__39474 = (0);
seq__39213 = G__39471;
chunk__39214 = G__39472;
count__39215 = G__39473;
i__39216 = G__39474;
continue;
} else {
var vec__39226 = cljs.core.first(seq__39213__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39226,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39226,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__39475 = cljs.core.next(seq__39213__$1);
var G__39476 = null;
var G__39477 = (0);
var G__39478 = (0);
seq__39213 = G__39475;
chunk__39214 = G__39476;
count__39215 = G__39477;
i__39216 = G__39478;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__39229 = cljs.core.seq(styles);
var chunk__39230 = null;
var count__39231 = (0);
var i__39232 = (0);
while(true){
if((i__39232 < count__39231)){
var vec__39239 = chunk__39230.cljs$core$IIndexed$_nth$arity$2(null,i__39232);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39239,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39239,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__39479 = seq__39229;
var G__39480 = chunk__39230;
var G__39481 = count__39231;
var G__39482 = (i__39232 + (1));
seq__39229 = G__39479;
chunk__39230 = G__39480;
count__39231 = G__39481;
i__39232 = G__39482;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__39229);
if(temp__5823__auto__){
var seq__39229__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__39229__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__39229__$1);
var G__39483 = cljs.core.chunk_rest(seq__39229__$1);
var G__39484 = c__5525__auto__;
var G__39485 = cljs.core.count(c__5525__auto__);
var G__39486 = (0);
seq__39229 = G__39483;
chunk__39230 = G__39484;
count__39231 = G__39485;
i__39232 = G__39486;
continue;
} else {
var vec__39242 = cljs.core.first(seq__39229__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39242,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39242,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__39487 = cljs.core.next(seq__39229__$1);
var G__39488 = null;
var G__39489 = (0);
var G__39490 = (0);
seq__39229 = G__39487;
chunk__39230 = G__39488;
count__39231 = G__39489;
i__39232 = G__39490;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__39245_39491 = key;
var G__39245_39492__$1 = (((G__39245_39491 instanceof cljs.core.Keyword))?G__39245_39491.fqn:null);
switch (G__39245_39492__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_39494 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__5002__auto__ = goog.string.startsWith(ks_39494,"data-");
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return goog.string.startsWith(ks_39494,"aria-");
}
})())){
el.setAttribute(ks_39494,value);
} else {
(el[ks_39494] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__39246){
var map__39247 = p__39246;
var map__39247__$1 = cljs.core.__destructure_map(map__39247);
var props = map__39247__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39247__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__39248 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39248,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39248,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39248,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__39251 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__39251,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__39251;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__39253 = arguments.length;
switch (G__39253) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5823__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5823__auto__)){
var n = temp__5823__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5823__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5823__auto__)){
var n = temp__5823__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__39254){
var vec__39255 = p__39254;
var seq__39256 = cljs.core.seq(vec__39255);
var first__39257 = cljs.core.first(seq__39256);
var seq__39256__$1 = cljs.core.next(seq__39256);
var nn = first__39257;
var first__39257__$1 = cljs.core.first(seq__39256__$1);
var seq__39256__$2 = cljs.core.next(seq__39256__$1);
var np = first__39257__$1;
var nc = seq__39256__$2;
var node = vec__39255;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__39258 = nn;
var G__39259 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__39258,G__39259) : create_fn.call(null,G__39258,G__39259));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__39260 = nn;
var G__39261 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__39260,G__39261) : create_fn.call(null,G__39260,G__39261));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__39262 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39262,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39262,(1),null);
var seq__39265_39496 = cljs.core.seq(node_children);
var chunk__39266_39497 = null;
var count__39267_39498 = (0);
var i__39268_39499 = (0);
while(true){
if((i__39268_39499 < count__39267_39498)){
var child_struct_39500 = chunk__39266_39497.cljs$core$IIndexed$_nth$arity$2(null,i__39268_39499);
var children_39501 = shadow.dom.dom_node(child_struct_39500);
if(cljs.core.seq_QMARK_(children_39501)){
var seq__39281_39502 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_39501));
var chunk__39283_39503 = null;
var count__39284_39504 = (0);
var i__39285_39505 = (0);
while(true){
if((i__39285_39505 < count__39284_39504)){
var child_39506 = chunk__39283_39503.cljs$core$IIndexed$_nth$arity$2(null,i__39285_39505);
if(cljs.core.truth_(child_39506)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_39506);


var G__39507 = seq__39281_39502;
var G__39508 = chunk__39283_39503;
var G__39509 = count__39284_39504;
var G__39510 = (i__39285_39505 + (1));
seq__39281_39502 = G__39507;
chunk__39283_39503 = G__39508;
count__39284_39504 = G__39509;
i__39285_39505 = G__39510;
continue;
} else {
var G__39511 = seq__39281_39502;
var G__39512 = chunk__39283_39503;
var G__39513 = count__39284_39504;
var G__39514 = (i__39285_39505 + (1));
seq__39281_39502 = G__39511;
chunk__39283_39503 = G__39512;
count__39284_39504 = G__39513;
i__39285_39505 = G__39514;
continue;
}
} else {
var temp__5823__auto___39515 = cljs.core.seq(seq__39281_39502);
if(temp__5823__auto___39515){
var seq__39281_39516__$1 = temp__5823__auto___39515;
if(cljs.core.chunked_seq_QMARK_(seq__39281_39516__$1)){
var c__5525__auto___39517 = cljs.core.chunk_first(seq__39281_39516__$1);
var G__39518 = cljs.core.chunk_rest(seq__39281_39516__$1);
var G__39519 = c__5525__auto___39517;
var G__39520 = cljs.core.count(c__5525__auto___39517);
var G__39521 = (0);
seq__39281_39502 = G__39518;
chunk__39283_39503 = G__39519;
count__39284_39504 = G__39520;
i__39285_39505 = G__39521;
continue;
} else {
var child_39522 = cljs.core.first(seq__39281_39516__$1);
if(cljs.core.truth_(child_39522)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_39522);


var G__39523 = cljs.core.next(seq__39281_39516__$1);
var G__39524 = null;
var G__39525 = (0);
var G__39526 = (0);
seq__39281_39502 = G__39523;
chunk__39283_39503 = G__39524;
count__39284_39504 = G__39525;
i__39285_39505 = G__39526;
continue;
} else {
var G__39527 = cljs.core.next(seq__39281_39516__$1);
var G__39528 = null;
var G__39529 = (0);
var G__39530 = (0);
seq__39281_39502 = G__39527;
chunk__39283_39503 = G__39528;
count__39284_39504 = G__39529;
i__39285_39505 = G__39530;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_39501);
}


var G__39531 = seq__39265_39496;
var G__39532 = chunk__39266_39497;
var G__39533 = count__39267_39498;
var G__39534 = (i__39268_39499 + (1));
seq__39265_39496 = G__39531;
chunk__39266_39497 = G__39532;
count__39267_39498 = G__39533;
i__39268_39499 = G__39534;
continue;
} else {
var temp__5823__auto___39535 = cljs.core.seq(seq__39265_39496);
if(temp__5823__auto___39535){
var seq__39265_39536__$1 = temp__5823__auto___39535;
if(cljs.core.chunked_seq_QMARK_(seq__39265_39536__$1)){
var c__5525__auto___39537 = cljs.core.chunk_first(seq__39265_39536__$1);
var G__39538 = cljs.core.chunk_rest(seq__39265_39536__$1);
var G__39539 = c__5525__auto___39537;
var G__39540 = cljs.core.count(c__5525__auto___39537);
var G__39541 = (0);
seq__39265_39496 = G__39538;
chunk__39266_39497 = G__39539;
count__39267_39498 = G__39540;
i__39268_39499 = G__39541;
continue;
} else {
var child_struct_39542 = cljs.core.first(seq__39265_39536__$1);
var children_39543 = shadow.dom.dom_node(child_struct_39542);
if(cljs.core.seq_QMARK_(children_39543)){
var seq__39287_39544 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_39543));
var chunk__39289_39545 = null;
var count__39290_39546 = (0);
var i__39291_39547 = (0);
while(true){
if((i__39291_39547 < count__39290_39546)){
var child_39548 = chunk__39289_39545.cljs$core$IIndexed$_nth$arity$2(null,i__39291_39547);
if(cljs.core.truth_(child_39548)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_39548);


var G__39549 = seq__39287_39544;
var G__39550 = chunk__39289_39545;
var G__39551 = count__39290_39546;
var G__39552 = (i__39291_39547 + (1));
seq__39287_39544 = G__39549;
chunk__39289_39545 = G__39550;
count__39290_39546 = G__39551;
i__39291_39547 = G__39552;
continue;
} else {
var G__39553 = seq__39287_39544;
var G__39554 = chunk__39289_39545;
var G__39555 = count__39290_39546;
var G__39556 = (i__39291_39547 + (1));
seq__39287_39544 = G__39553;
chunk__39289_39545 = G__39554;
count__39290_39546 = G__39555;
i__39291_39547 = G__39556;
continue;
}
} else {
var temp__5823__auto___39557__$1 = cljs.core.seq(seq__39287_39544);
if(temp__5823__auto___39557__$1){
var seq__39287_39558__$1 = temp__5823__auto___39557__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39287_39558__$1)){
var c__5525__auto___39559 = cljs.core.chunk_first(seq__39287_39558__$1);
var G__39560 = cljs.core.chunk_rest(seq__39287_39558__$1);
var G__39561 = c__5525__auto___39559;
var G__39562 = cljs.core.count(c__5525__auto___39559);
var G__39563 = (0);
seq__39287_39544 = G__39560;
chunk__39289_39545 = G__39561;
count__39290_39546 = G__39562;
i__39291_39547 = G__39563;
continue;
} else {
var child_39564 = cljs.core.first(seq__39287_39558__$1);
if(cljs.core.truth_(child_39564)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_39564);


var G__39565 = cljs.core.next(seq__39287_39558__$1);
var G__39566 = null;
var G__39567 = (0);
var G__39568 = (0);
seq__39287_39544 = G__39565;
chunk__39289_39545 = G__39566;
count__39290_39546 = G__39567;
i__39291_39547 = G__39568;
continue;
} else {
var G__39569 = cljs.core.next(seq__39287_39558__$1);
var G__39570 = null;
var G__39571 = (0);
var G__39572 = (0);
seq__39287_39544 = G__39569;
chunk__39289_39545 = G__39570;
count__39290_39546 = G__39571;
i__39291_39547 = G__39572;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_39543);
}


var G__39573 = cljs.core.next(seq__39265_39536__$1);
var G__39574 = null;
var G__39575 = (0);
var G__39576 = (0);
seq__39265_39496 = G__39573;
chunk__39266_39497 = G__39574;
count__39267_39498 = G__39575;
i__39268_39499 = G__39576;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__39294 = cljs.core.seq(node);
var chunk__39295 = null;
var count__39296 = (0);
var i__39297 = (0);
while(true){
if((i__39297 < count__39296)){
var n = chunk__39295.cljs$core$IIndexed$_nth$arity$2(null,i__39297);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__39577 = seq__39294;
var G__39578 = chunk__39295;
var G__39579 = count__39296;
var G__39580 = (i__39297 + (1));
seq__39294 = G__39577;
chunk__39295 = G__39578;
count__39296 = G__39579;
i__39297 = G__39580;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__39294);
if(temp__5823__auto__){
var seq__39294__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__39294__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__39294__$1);
var G__39581 = cljs.core.chunk_rest(seq__39294__$1);
var G__39582 = c__5525__auto__;
var G__39583 = cljs.core.count(c__5525__auto__);
var G__39584 = (0);
seq__39294 = G__39581;
chunk__39295 = G__39582;
count__39296 = G__39583;
i__39297 = G__39584;
continue;
} else {
var n = cljs.core.first(seq__39294__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__39585 = cljs.core.next(seq__39294__$1);
var G__39586 = null;
var G__39587 = (0);
var G__39588 = (0);
seq__39294 = G__39585;
chunk__39295 = G__39586;
count__39296 = G__39587;
i__39297 = G__39588;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__39299 = arguments.length;
switch (G__39299) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__39301 = arguments.length;
switch (G__39301) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__39303 = arguments.length;
switch (G__39303) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__5002__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__5732__auto__ = [];
var len__5726__auto___39592 = arguments.length;
var i__5727__auto___39593 = (0);
while(true){
if((i__5727__auto___39593 < len__5726__auto___39592)){
args__5732__auto__.push((arguments[i__5727__auto___39593]));

var G__39594 = (i__5727__auto___39593 + (1));
i__5727__auto___39593 = G__39594;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((0) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__5733__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__39305_39595 = cljs.core.seq(nodes);
var chunk__39306_39596 = null;
var count__39307_39597 = (0);
var i__39308_39598 = (0);
while(true){
if((i__39308_39598 < count__39307_39597)){
var node_39599 = chunk__39306_39596.cljs$core$IIndexed$_nth$arity$2(null,i__39308_39598);
fragment.appendChild(shadow.dom._to_dom(node_39599));


var G__39600 = seq__39305_39595;
var G__39601 = chunk__39306_39596;
var G__39602 = count__39307_39597;
var G__39603 = (i__39308_39598 + (1));
seq__39305_39595 = G__39600;
chunk__39306_39596 = G__39601;
count__39307_39597 = G__39602;
i__39308_39598 = G__39603;
continue;
} else {
var temp__5823__auto___39604 = cljs.core.seq(seq__39305_39595);
if(temp__5823__auto___39604){
var seq__39305_39605__$1 = temp__5823__auto___39604;
if(cljs.core.chunked_seq_QMARK_(seq__39305_39605__$1)){
var c__5525__auto___39606 = cljs.core.chunk_first(seq__39305_39605__$1);
var G__39607 = cljs.core.chunk_rest(seq__39305_39605__$1);
var G__39608 = c__5525__auto___39606;
var G__39609 = cljs.core.count(c__5525__auto___39606);
var G__39610 = (0);
seq__39305_39595 = G__39607;
chunk__39306_39596 = G__39608;
count__39307_39597 = G__39609;
i__39308_39598 = G__39610;
continue;
} else {
var node_39611 = cljs.core.first(seq__39305_39605__$1);
fragment.appendChild(shadow.dom._to_dom(node_39611));


var G__39612 = cljs.core.next(seq__39305_39605__$1);
var G__39613 = null;
var G__39614 = (0);
var G__39615 = (0);
seq__39305_39595 = G__39612;
chunk__39306_39596 = G__39613;
count__39307_39597 = G__39614;
i__39308_39598 = G__39615;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq39304){
var self__5712__auto__ = this;
return self__5712__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39304));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__39309_39616 = cljs.core.seq(scripts);
var chunk__39310_39617 = null;
var count__39311_39618 = (0);
var i__39312_39619 = (0);
while(true){
if((i__39312_39619 < count__39311_39618)){
var vec__39319_39620 = chunk__39310_39617.cljs$core$IIndexed$_nth$arity$2(null,i__39312_39619);
var script_tag_39621 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39319_39620,(0),null);
var script_body_39622 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39319_39620,(1),null);
eval(script_body_39622);


var G__39623 = seq__39309_39616;
var G__39624 = chunk__39310_39617;
var G__39625 = count__39311_39618;
var G__39626 = (i__39312_39619 + (1));
seq__39309_39616 = G__39623;
chunk__39310_39617 = G__39624;
count__39311_39618 = G__39625;
i__39312_39619 = G__39626;
continue;
} else {
var temp__5823__auto___39627 = cljs.core.seq(seq__39309_39616);
if(temp__5823__auto___39627){
var seq__39309_39628__$1 = temp__5823__auto___39627;
if(cljs.core.chunked_seq_QMARK_(seq__39309_39628__$1)){
var c__5525__auto___39629 = cljs.core.chunk_first(seq__39309_39628__$1);
var G__39630 = cljs.core.chunk_rest(seq__39309_39628__$1);
var G__39631 = c__5525__auto___39629;
var G__39632 = cljs.core.count(c__5525__auto___39629);
var G__39633 = (0);
seq__39309_39616 = G__39630;
chunk__39310_39617 = G__39631;
count__39311_39618 = G__39632;
i__39312_39619 = G__39633;
continue;
} else {
var vec__39322_39634 = cljs.core.first(seq__39309_39628__$1);
var script_tag_39635 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39322_39634,(0),null);
var script_body_39636 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39322_39634,(1),null);
eval(script_body_39636);


var G__39637 = cljs.core.next(seq__39309_39628__$1);
var G__39638 = null;
var G__39639 = (0);
var G__39640 = (0);
seq__39309_39616 = G__39637;
chunk__39310_39617 = G__39638;
count__39311_39618 = G__39639;
i__39312_39619 = G__39640;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__39325){
var vec__39326 = p__39325;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39326,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39326,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__39330 = arguments.length;
switch (G__39330) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__39331 = cljs.core.seq(style_keys);
var chunk__39332 = null;
var count__39333 = (0);
var i__39334 = (0);
while(true){
if((i__39334 < count__39333)){
var it = chunk__39332.cljs$core$IIndexed$_nth$arity$2(null,i__39334);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__39642 = seq__39331;
var G__39643 = chunk__39332;
var G__39644 = count__39333;
var G__39645 = (i__39334 + (1));
seq__39331 = G__39642;
chunk__39332 = G__39643;
count__39333 = G__39644;
i__39334 = G__39645;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__39331);
if(temp__5823__auto__){
var seq__39331__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__39331__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__39331__$1);
var G__39646 = cljs.core.chunk_rest(seq__39331__$1);
var G__39647 = c__5525__auto__;
var G__39648 = cljs.core.count(c__5525__auto__);
var G__39649 = (0);
seq__39331 = G__39646;
chunk__39332 = G__39647;
count__39333 = G__39648;
i__39334 = G__39649;
continue;
} else {
var it = cljs.core.first(seq__39331__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__39650 = cljs.core.next(seq__39331__$1);
var G__39651 = null;
var G__39652 = (0);
var G__39653 = (0);
seq__39331 = G__39650;
chunk__39332 = G__39651;
count__39333 = G__39652;
i__39334 = G__39653;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5300__auto__,k__5301__auto__){
var self__ = this;
var this__5300__auto____$1 = this;
return this__5300__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5301__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5302__auto__,k39336,else__5303__auto__){
var self__ = this;
var this__5302__auto____$1 = this;
var G__39340 = k39336;
var G__39340__$1 = (((G__39340 instanceof cljs.core.Keyword))?G__39340.fqn:null);
switch (G__39340__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k39336,else__5303__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5320__auto__,f__5321__auto__,init__5322__auto__){
var self__ = this;
var this__5320__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5323__auto__,p__39341){
var vec__39342 = p__39341;
var k__5324__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39342,(0),null);
var v__5325__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39342,(1),null);
return (f__5321__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5321__auto__.cljs$core$IFn$_invoke$arity$3(ret__5323__auto__,k__5324__auto__,v__5325__auto__) : f__5321__auto__.call(null,ret__5323__auto__,k__5324__auto__,v__5325__auto__));
}),init__5322__auto__,this__5320__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5315__auto__,writer__5316__auto__,opts__5317__auto__){
var self__ = this;
var this__5315__auto____$1 = this;
var pr_pair__5318__auto__ = (function (keyval__5319__auto__){
return cljs.core.pr_sequential_writer(writer__5316__auto__,cljs.core.pr_writer,""," ","",opts__5317__auto__,keyval__5319__auto__);
});
return cljs.core.pr_sequential_writer(writer__5316__auto__,pr_pair__5318__auto__,"#shadow.dom.Coordinate{",", ","}",opts__5317__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__39335){
var self__ = this;
var G__39335__$1 = this;
return (new cljs.core.RecordIter((0),G__39335__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5298__auto__){
var self__ = this;
var this__5298__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5295__auto__){
var self__ = this;
var this__5295__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5304__auto__){
var self__ = this;
var this__5304__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5296__auto__){
var self__ = this;
var this__5296__auto____$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = (function (coll__5297__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__5297__auto__));
})(this__5296__auto____$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this39337,other39338){
var self__ = this;
var this39337__$1 = this;
return (((!((other39338 == null)))) && ((((this39337__$1.constructor === other39338.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39337__$1.x,other39338.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39337__$1.y,other39338.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39337__$1.__extmap,other39338.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5310__auto__,k__5311__auto__){
var self__ = this;
var this__5310__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__5311__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5310__auto____$1),self__.__meta),k__5311__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5311__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5307__auto__,k39336){
var self__ = this;
var this__5307__auto____$1 = this;
var G__39345 = k39336;
var G__39345__$1 = (((G__39345 instanceof cljs.core.Keyword))?G__39345.fqn:null);
switch (G__39345__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k39336);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5308__auto__,k__5309__auto__,G__39335){
var self__ = this;
var this__5308__auto____$1 = this;
var pred__39346 = cljs.core.keyword_identical_QMARK_;
var expr__39347 = k__5309__auto__;
if(cljs.core.truth_((pred__39346.cljs$core$IFn$_invoke$arity$2 ? pred__39346.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__39347) : pred__39346.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__39347)))){
return (new shadow.dom.Coordinate(G__39335,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__39346.cljs$core$IFn$_invoke$arity$2 ? pred__39346.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__39347) : pred__39346.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__39347)))){
return (new shadow.dom.Coordinate(self__.x,G__39335,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5309__auto__,G__39335),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5313__auto__){
var self__ = this;
var this__5313__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5299__auto__,G__39335){
var self__ = this;
var this__5299__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__39335,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5305__auto__,entry__5306__auto__){
var self__ = this;
var this__5305__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5306__auto__)){
return this__5305__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5306__auto__,(0)),cljs.core._nth(entry__5306__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5305__auto____$1,entry__5306__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__5346__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__5346__auto__,writer__5347__auto__){
return cljs.core._write(writer__5347__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__39339){
var extmap__5342__auto__ = (function (){var G__39349 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__39339,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__39339)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__39349);
} else {
return G__39349;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__39339),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__39339),null,cljs.core.not_empty(extmap__5342__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5300__auto__,k__5301__auto__){
var self__ = this;
var this__5300__auto____$1 = this;
return this__5300__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5301__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5302__auto__,k39351,else__5303__auto__){
var self__ = this;
var this__5302__auto____$1 = this;
var G__39355 = k39351;
var G__39355__$1 = (((G__39355 instanceof cljs.core.Keyword))?G__39355.fqn:null);
switch (G__39355__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k39351,else__5303__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5320__auto__,f__5321__auto__,init__5322__auto__){
var self__ = this;
var this__5320__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5323__auto__,p__39356){
var vec__39357 = p__39356;
var k__5324__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39357,(0),null);
var v__5325__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39357,(1),null);
return (f__5321__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5321__auto__.cljs$core$IFn$_invoke$arity$3(ret__5323__auto__,k__5324__auto__,v__5325__auto__) : f__5321__auto__.call(null,ret__5323__auto__,k__5324__auto__,v__5325__auto__));
}),init__5322__auto__,this__5320__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5315__auto__,writer__5316__auto__,opts__5317__auto__){
var self__ = this;
var this__5315__auto____$1 = this;
var pr_pair__5318__auto__ = (function (keyval__5319__auto__){
return cljs.core.pr_sequential_writer(writer__5316__auto__,cljs.core.pr_writer,""," ","",opts__5317__auto__,keyval__5319__auto__);
});
return cljs.core.pr_sequential_writer(writer__5316__auto__,pr_pair__5318__auto__,"#shadow.dom.Size{",", ","}",opts__5317__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__39350){
var self__ = this;
var G__39350__$1 = this;
return (new cljs.core.RecordIter((0),G__39350__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5298__auto__){
var self__ = this;
var this__5298__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5295__auto__){
var self__ = this;
var this__5295__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5304__auto__){
var self__ = this;
var this__5304__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5296__auto__){
var self__ = this;
var this__5296__auto____$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = (function (coll__5297__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__5297__auto__));
})(this__5296__auto____$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this39352,other39353){
var self__ = this;
var this39352__$1 = this;
return (((!((other39353 == null)))) && ((((this39352__$1.constructor === other39353.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39352__$1.w,other39353.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39352__$1.h,other39353.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39352__$1.__extmap,other39353.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5310__auto__,k__5311__auto__){
var self__ = this;
var this__5310__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__5311__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5310__auto____$1),self__.__meta),k__5311__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5311__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5307__auto__,k39351){
var self__ = this;
var this__5307__auto____$1 = this;
var G__39360 = k39351;
var G__39360__$1 = (((G__39360 instanceof cljs.core.Keyword))?G__39360.fqn:null);
switch (G__39360__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k39351);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5308__auto__,k__5309__auto__,G__39350){
var self__ = this;
var this__5308__auto____$1 = this;
var pred__39361 = cljs.core.keyword_identical_QMARK_;
var expr__39362 = k__5309__auto__;
if(cljs.core.truth_((pred__39361.cljs$core$IFn$_invoke$arity$2 ? pred__39361.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__39362) : pred__39361.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__39362)))){
return (new shadow.dom.Size(G__39350,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__39361.cljs$core$IFn$_invoke$arity$2 ? pred__39361.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__39362) : pred__39361.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__39362)))){
return (new shadow.dom.Size(self__.w,G__39350,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5309__auto__,G__39350),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5313__auto__){
var self__ = this;
var this__5313__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5299__auto__,G__39350){
var self__ = this;
var this__5299__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__39350,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5305__auto__,entry__5306__auto__){
var self__ = this;
var this__5305__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5306__auto__)){
return this__5305__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5306__auto__,(0)),cljs.core._nth(entry__5306__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5305__auto____$1,entry__5306__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__5346__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__5346__auto__,writer__5347__auto__){
return cljs.core._write(writer__5347__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__39354){
var extmap__5342__auto__ = (function (){var G__39364 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__39354,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__39354)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__39364);
} else {
return G__39364;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__39354),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__39354),null,cljs.core.not_empty(extmap__5342__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__5590__auto__ = opts;
var l__5591__auto__ = a__5590__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__5591__auto__)){
var G__39658 = (i + (1));
var G__39659 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__39658;
ret = G__39659;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__39369){
var vec__39370 = p__39369;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39370,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39370,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__39374 = arguments.length;
switch (G__39374) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5821__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5821__auto__)){
var child = temp__5821__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__39661 = ps;
var G__39662 = (i + (1));
el__$1 = G__39661;
i = G__39662;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__39377 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39377,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39377,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39377,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__39381_39663 = cljs.core.seq(props);
var chunk__39382_39664 = null;
var count__39383_39665 = (0);
var i__39384_39666 = (0);
while(true){
if((i__39384_39666 < count__39383_39665)){
var vec__39395_39667 = chunk__39382_39664.cljs$core$IIndexed$_nth$arity$2(null,i__39384_39666);
var k_39668 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39395_39667,(0),null);
var v_39669 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39395_39667,(1),null);
el.setAttributeNS((function (){var temp__5823__auto__ = cljs.core.namespace(k_39668);
if(cljs.core.truth_(temp__5823__auto__)){
var ns = temp__5823__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_39668),v_39669);


var G__39670 = seq__39381_39663;
var G__39671 = chunk__39382_39664;
var G__39672 = count__39383_39665;
var G__39673 = (i__39384_39666 + (1));
seq__39381_39663 = G__39670;
chunk__39382_39664 = G__39671;
count__39383_39665 = G__39672;
i__39384_39666 = G__39673;
continue;
} else {
var temp__5823__auto___39674 = cljs.core.seq(seq__39381_39663);
if(temp__5823__auto___39674){
var seq__39381_39675__$1 = temp__5823__auto___39674;
if(cljs.core.chunked_seq_QMARK_(seq__39381_39675__$1)){
var c__5525__auto___39676 = cljs.core.chunk_first(seq__39381_39675__$1);
var G__39677 = cljs.core.chunk_rest(seq__39381_39675__$1);
var G__39678 = c__5525__auto___39676;
var G__39679 = cljs.core.count(c__5525__auto___39676);
var G__39680 = (0);
seq__39381_39663 = G__39677;
chunk__39382_39664 = G__39678;
count__39383_39665 = G__39679;
i__39384_39666 = G__39680;
continue;
} else {
var vec__39400_39681 = cljs.core.first(seq__39381_39675__$1);
var k_39682 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39400_39681,(0),null);
var v_39683 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39400_39681,(1),null);
el.setAttributeNS((function (){var temp__5823__auto____$1 = cljs.core.namespace(k_39682);
if(cljs.core.truth_(temp__5823__auto____$1)){
var ns = temp__5823__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_39682),v_39683);


var G__39684 = cljs.core.next(seq__39381_39675__$1);
var G__39685 = null;
var G__39686 = (0);
var G__39687 = (0);
seq__39381_39663 = G__39684;
chunk__39382_39664 = G__39685;
count__39383_39665 = G__39686;
i__39384_39666 = G__39687;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__39408 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39408,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39408,(1),null);
var seq__39411_39688 = cljs.core.seq(node_children);
var chunk__39413_39689 = null;
var count__39414_39690 = (0);
var i__39415_39691 = (0);
while(true){
if((i__39415_39691 < count__39414_39690)){
var child_struct_39692 = chunk__39413_39689.cljs$core$IIndexed$_nth$arity$2(null,i__39415_39691);
if((!((child_struct_39692 == null)))){
if(typeof child_struct_39692 === 'string'){
var text_39693 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_39693),child_struct_39692].join(''));
} else {
var children_39694 = shadow.dom.svg_node(child_struct_39692);
if(cljs.core.seq_QMARK_(children_39694)){
var seq__39430_39695 = cljs.core.seq(children_39694);
var chunk__39432_39696 = null;
var count__39433_39697 = (0);
var i__39434_39698 = (0);
while(true){
if((i__39434_39698 < count__39433_39697)){
var child_39699 = chunk__39432_39696.cljs$core$IIndexed$_nth$arity$2(null,i__39434_39698);
if(cljs.core.truth_(child_39699)){
node.appendChild(child_39699);


var G__39700 = seq__39430_39695;
var G__39701 = chunk__39432_39696;
var G__39702 = count__39433_39697;
var G__39703 = (i__39434_39698 + (1));
seq__39430_39695 = G__39700;
chunk__39432_39696 = G__39701;
count__39433_39697 = G__39702;
i__39434_39698 = G__39703;
continue;
} else {
var G__39704 = seq__39430_39695;
var G__39705 = chunk__39432_39696;
var G__39706 = count__39433_39697;
var G__39707 = (i__39434_39698 + (1));
seq__39430_39695 = G__39704;
chunk__39432_39696 = G__39705;
count__39433_39697 = G__39706;
i__39434_39698 = G__39707;
continue;
}
} else {
var temp__5823__auto___39708 = cljs.core.seq(seq__39430_39695);
if(temp__5823__auto___39708){
var seq__39430_39709__$1 = temp__5823__auto___39708;
if(cljs.core.chunked_seq_QMARK_(seq__39430_39709__$1)){
var c__5525__auto___39710 = cljs.core.chunk_first(seq__39430_39709__$1);
var G__39711 = cljs.core.chunk_rest(seq__39430_39709__$1);
var G__39712 = c__5525__auto___39710;
var G__39713 = cljs.core.count(c__5525__auto___39710);
var G__39714 = (0);
seq__39430_39695 = G__39711;
chunk__39432_39696 = G__39712;
count__39433_39697 = G__39713;
i__39434_39698 = G__39714;
continue;
} else {
var child_39715 = cljs.core.first(seq__39430_39709__$1);
if(cljs.core.truth_(child_39715)){
node.appendChild(child_39715);


var G__39716 = cljs.core.next(seq__39430_39709__$1);
var G__39717 = null;
var G__39718 = (0);
var G__39719 = (0);
seq__39430_39695 = G__39716;
chunk__39432_39696 = G__39717;
count__39433_39697 = G__39718;
i__39434_39698 = G__39719;
continue;
} else {
var G__39720 = cljs.core.next(seq__39430_39709__$1);
var G__39721 = null;
var G__39722 = (0);
var G__39723 = (0);
seq__39430_39695 = G__39720;
chunk__39432_39696 = G__39721;
count__39433_39697 = G__39722;
i__39434_39698 = G__39723;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_39694);
}
}


var G__39724 = seq__39411_39688;
var G__39725 = chunk__39413_39689;
var G__39726 = count__39414_39690;
var G__39727 = (i__39415_39691 + (1));
seq__39411_39688 = G__39724;
chunk__39413_39689 = G__39725;
count__39414_39690 = G__39726;
i__39415_39691 = G__39727;
continue;
} else {
var G__39728 = seq__39411_39688;
var G__39729 = chunk__39413_39689;
var G__39730 = count__39414_39690;
var G__39731 = (i__39415_39691 + (1));
seq__39411_39688 = G__39728;
chunk__39413_39689 = G__39729;
count__39414_39690 = G__39730;
i__39415_39691 = G__39731;
continue;
}
} else {
var temp__5823__auto___39732 = cljs.core.seq(seq__39411_39688);
if(temp__5823__auto___39732){
var seq__39411_39733__$1 = temp__5823__auto___39732;
if(cljs.core.chunked_seq_QMARK_(seq__39411_39733__$1)){
var c__5525__auto___39734 = cljs.core.chunk_first(seq__39411_39733__$1);
var G__39735 = cljs.core.chunk_rest(seq__39411_39733__$1);
var G__39736 = c__5525__auto___39734;
var G__39737 = cljs.core.count(c__5525__auto___39734);
var G__39738 = (0);
seq__39411_39688 = G__39735;
chunk__39413_39689 = G__39736;
count__39414_39690 = G__39737;
i__39415_39691 = G__39738;
continue;
} else {
var child_struct_39739 = cljs.core.first(seq__39411_39733__$1);
if((!((child_struct_39739 == null)))){
if(typeof child_struct_39739 === 'string'){
var text_39740 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_39740),child_struct_39739].join(''));
} else {
var children_39741 = shadow.dom.svg_node(child_struct_39739);
if(cljs.core.seq_QMARK_(children_39741)){
var seq__39436_39742 = cljs.core.seq(children_39741);
var chunk__39438_39743 = null;
var count__39439_39744 = (0);
var i__39440_39745 = (0);
while(true){
if((i__39440_39745 < count__39439_39744)){
var child_39746 = chunk__39438_39743.cljs$core$IIndexed$_nth$arity$2(null,i__39440_39745);
if(cljs.core.truth_(child_39746)){
node.appendChild(child_39746);


var G__39747 = seq__39436_39742;
var G__39748 = chunk__39438_39743;
var G__39749 = count__39439_39744;
var G__39750 = (i__39440_39745 + (1));
seq__39436_39742 = G__39747;
chunk__39438_39743 = G__39748;
count__39439_39744 = G__39749;
i__39440_39745 = G__39750;
continue;
} else {
var G__39751 = seq__39436_39742;
var G__39752 = chunk__39438_39743;
var G__39753 = count__39439_39744;
var G__39754 = (i__39440_39745 + (1));
seq__39436_39742 = G__39751;
chunk__39438_39743 = G__39752;
count__39439_39744 = G__39753;
i__39440_39745 = G__39754;
continue;
}
} else {
var temp__5823__auto___39755__$1 = cljs.core.seq(seq__39436_39742);
if(temp__5823__auto___39755__$1){
var seq__39436_39756__$1 = temp__5823__auto___39755__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39436_39756__$1)){
var c__5525__auto___39757 = cljs.core.chunk_first(seq__39436_39756__$1);
var G__39758 = cljs.core.chunk_rest(seq__39436_39756__$1);
var G__39759 = c__5525__auto___39757;
var G__39760 = cljs.core.count(c__5525__auto___39757);
var G__39761 = (0);
seq__39436_39742 = G__39758;
chunk__39438_39743 = G__39759;
count__39439_39744 = G__39760;
i__39440_39745 = G__39761;
continue;
} else {
var child_39762 = cljs.core.first(seq__39436_39756__$1);
if(cljs.core.truth_(child_39762)){
node.appendChild(child_39762);


var G__39763 = cljs.core.next(seq__39436_39756__$1);
var G__39764 = null;
var G__39765 = (0);
var G__39766 = (0);
seq__39436_39742 = G__39763;
chunk__39438_39743 = G__39764;
count__39439_39744 = G__39765;
i__39440_39745 = G__39766;
continue;
} else {
var G__39767 = cljs.core.next(seq__39436_39756__$1);
var G__39768 = null;
var G__39769 = (0);
var G__39770 = (0);
seq__39436_39742 = G__39767;
chunk__39438_39743 = G__39768;
count__39439_39744 = G__39769;
i__39440_39745 = G__39770;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_39741);
}
}


var G__39771 = cljs.core.next(seq__39411_39733__$1);
var G__39772 = null;
var G__39773 = (0);
var G__39774 = (0);
seq__39411_39688 = G__39771;
chunk__39413_39689 = G__39772;
count__39414_39690 = G__39773;
i__39415_39691 = G__39774;
continue;
} else {
var G__39775 = cljs.core.next(seq__39411_39733__$1);
var G__39776 = null;
var G__39777 = (0);
var G__39778 = (0);
seq__39411_39688 = G__39775;
chunk__39413_39689 = G__39776;
count__39414_39690 = G__39777;
i__39415_39691 = G__39778;
continue;
}
}
} else {
}
}
break;
}

return node;
});
(shadow.dom.SVGElement["string"] = true);

(shadow.dom._to_svg["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

(shadow.dom.SVGElement["null"] = true);

(shadow.dom._to_svg["null"] = (function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__5732__auto__ = [];
var len__5726__auto___39779 = arguments.length;
var i__5727__auto___39780 = (0);
while(true){
if((i__5727__auto___39780 < len__5726__auto___39779)){
args__5732__auto__.push((arguments[i__5727__auto___39780]));

var G__39781 = (i__5727__auto___39780 + (1));
i__5727__auto___39780 = G__39781;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq39442){
var G__39443 = cljs.core.first(seq39442);
var seq39442__$1 = cljs.core.next(seq39442);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__39443,seq39442__$1);
}));


//# sourceMappingURL=shadow.dom.js.map
