goog.provide('missionary.impl.GroupBy');





/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IDeref}
*/
missionary.impl.GroupBy.Process = (function (keyfn,notifier,terminator,key,value,input,table,load,live,busy,done){
this.keyfn = keyfn;
this.notifier = notifier;
this.terminator = terminator;
this.key = key;
this.value = value;
this.input = input;
this.table = table;
this.load = load;
this.live = live;
this.busy = busy;
this.done = done;
this.cljs$lang$protocol_mask$partition0$ = 32769;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(missionary.impl.GroupBy.Process.prototype.call = (function (unused__18889__auto__){
var self__ = this;
var self__ = this;
var G__47329 = (arguments.length - (1));
switch (G__47329) {
case (0):
return self__.cljs$core$IFn$_invoke$arity$0();

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(missionary.impl.GroupBy.Process.prototype.apply = (function (self__,args47328){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args47328)));
}));

(missionary.impl.GroupBy.Process.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var p = this;
(missionary.impl.GroupBy.kill.cljs$core$IFn$_invoke$arity$1 ? missionary.impl.GroupBy.kill.cljs$core$IFn$_invoke$arity$1(p) : missionary.impl.GroupBy.kill.call(null,p));

return null;
}));

(missionary.impl.GroupBy.Process.prototype.cljs$core$IFn$_invoke$arity$2 = (function (n,t){
var self__ = this;
var p = this;
return (missionary.impl.GroupBy.group.cljs$core$IFn$_invoke$arity$3 ? missionary.impl.GroupBy.group.cljs$core$IFn$_invoke$arity$3(p,n,t) : missionary.impl.GroupBy.group.call(null,p,n,t));
}));

(missionary.impl.GroupBy.Process.prototype.cljs$core$IDeref$_deref$arity$1 = (function (p){
var self__ = this;
var p__$1 = this;
return (missionary.impl.GroupBy.sample.cljs$core$IFn$_invoke$arity$1 ? missionary.impl.GroupBy.sample.cljs$core$IFn$_invoke$arity$1(p__$1) : missionary.impl.GroupBy.sample.call(null,p__$1));
}));

(missionary.impl.GroupBy.Process.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"keyfn","keyfn",-1874375437,null),new cljs.core.Symbol(null,"notifier","notifier",1670358652,null),new cljs.core.Symbol(null,"terminator","terminator",-1051388676,null),new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"value","value",1946509744,null),new cljs.core.Symbol(null,"input","input",-2097503808,null),new cljs.core.Symbol(null,"table","table",1075588491,null),cljs.core.with_meta(new cljs.core.Symbol(null,"load","load",321890343,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"number","number",-1084057331,null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"live","live",30383488,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"busy","busy",1312244726,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"done","done",750687339,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null)], null))], null);
}));

(missionary.impl.GroupBy.Process.cljs$lang$type = true);

(missionary.impl.GroupBy.Process.cljs$lang$ctorStr = "missionary.impl.GroupBy/Process");

(missionary.impl.GroupBy.Process.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"missionary.impl.GroupBy/Process");
}));

/**
 * Positional factory function for missionary.impl.GroupBy/Process.
 */
missionary.impl.GroupBy.__GT_Process = (function missionary$impl$GroupBy$__GT_Process(keyfn,notifier,terminator,key,value,input,table,load,live,busy,done){
return (new missionary.impl.GroupBy.Process(keyfn,notifier,terminator,key,value,input,table,load,live,busy,done));
});


/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IDeref}
*/
missionary.impl.GroupBy.Group = (function (process,key,notifier,terminator){
this.process = process;
this.key = key;
this.notifier = notifier;
this.terminator = terminator;
this.cljs$lang$protocol_mask$partition0$ = 32769;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(missionary.impl.GroupBy.Group.prototype.call = (function (unused__18889__auto__){
var self__ = this;
var self__ = this;
var G__47342 = (arguments.length - (1));
switch (G__47342) {
case (0):
return self__.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(missionary.impl.GroupBy.Group.prototype.apply = (function (self__,args47341){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args47341)));
}));

(missionary.impl.GroupBy.Group.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var g = this;
(missionary.impl.GroupBy.cancel.cljs$core$IFn$_invoke$arity$1 ? missionary.impl.GroupBy.cancel.cljs$core$IFn$_invoke$arity$1(g) : missionary.impl.GroupBy.cancel.call(null,g));

return null;
}));

(missionary.impl.GroupBy.Group.prototype.cljs$core$IDeref$_deref$arity$1 = (function (g){
var self__ = this;
var g__$1 = this;
return (missionary.impl.GroupBy.consume.cljs$core$IFn$_invoke$arity$1 ? missionary.impl.GroupBy.consume.cljs$core$IFn$_invoke$arity$1(g__$1) : missionary.impl.GroupBy.consume.call(null,g__$1));
}));

(missionary.impl.GroupBy.Group.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"process","process",-1011242831,null),new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"notifier","notifier",1670358652,null),new cljs.core.Symbol(null,"terminator","terminator",-1051388676,null)], null);
}));

(missionary.impl.GroupBy.Group.cljs$lang$type = true);

(missionary.impl.GroupBy.Group.cljs$lang$ctorStr = "missionary.impl.GroupBy/Group");

(missionary.impl.GroupBy.Group.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"missionary.impl.GroupBy/Group");
}));

/**
 * Positional factory function for missionary.impl.GroupBy/Group.
 */
missionary.impl.GroupBy.__GT_Group = (function missionary$impl$GroupBy$__GT_Group(process,key,notifier,terminator){
return (new missionary.impl.GroupBy.Group(process,key,notifier,terminator));
});

missionary.impl.GroupBy.kill = (function missionary$impl$GroupBy$kill(p){
if(cljs.core.truth_(p.live)){
(p.live = false);

var fexpr__47349 = p.input;
return (fexpr__47349.cljs$core$IFn$_invoke$arity$0 ? fexpr__47349.cljs$core$IFn$_invoke$arity$0() : fexpr__47349.call(null));
} else {
return null;
}
});
missionary.impl.GroupBy.step = (function missionary$impl$GroupBy$step(i,m){
return ((i + (1)) & m);
});
missionary.impl.GroupBy.group = (function missionary$impl$GroupBy$group(p,n,t){
var k = p.key;
var g = missionary.impl.GroupBy.__GT_Group(p,k,n,t);
var table = p.table;
if((k === p)){
} else {
(p.key = p);

var s_47383 = table.length;
var m_47384 = (s_47383 - (1));
var i_47385 = (cljs.core.hash(k) & m_47384);
while(true){
var G__47356_47386 = (table[i_47385]);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,G__47356_47386)){
(table[i_47385] = g);
} else {
var G__47387 = missionary.impl.GroupBy.step(i_47385,m_47384);
i_47385 = G__47387;
continue;

}
break;
}

var ss_47388 = (s_47383 << (1));
if((ss_47388 <= ((3) * (p.load = (p.load + (1)))))){
var mm_47389 = (ss_47388 - (1));
var larger_47390 = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(ss_47388);
(p.table = larger_47390);

var n__5593__auto___47391 = s_47383;
var i_47392 = (0);
while(true){
if((i_47392 < n__5593__auto___47391)){
var temp__5827__auto___47393 = (table[i_47392]);
if((temp__5827__auto___47393 == null)){
} else {
var h_47394 = temp__5827__auto___47393;
var j_47395 = (cljs.core.hash(h_47394.key) & mm_47389);
while(true){
var G__47357_47396 = (larger_47390[j_47395]);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,G__47357_47396)){
(larger_47390[j_47395] = h_47394);
} else {
var G__47397 = missionary.impl.GroupBy.step(j_47395,mm_47389);
j_47395 = G__47397;
continue;

}
break;
}
}

var G__47398 = (i_47392 + (1));
i_47392 = G__47398;
continue;
} else {
}
break;
}
} else {
}
}

(n.cljs$core$IFn$_invoke$arity$0 ? n.cljs$core$IFn$_invoke$arity$0() : n.call(null));

return g;
});
missionary.impl.GroupBy.cancel = (function missionary$impl$GroupBy$cancel(g){
var p = g.process;
var k = g.key;
if(cljs.core.truth_(p.live)){
if((k === p)){
return null;
} else {
(g.key = p);

var table = p.table;
var m = (table.length - (1));
var i = (function (){var i = (cljs.core.hash(k) & m);
while(true){
if((g === (table[i]))){
return i;
} else {
var G__47399 = missionary.impl.GroupBy.step(i,m);
i = G__47399;
continue;
}
break;
}
})();
(table[i] = null);

(p.load = (p.load - (1)));

var i_47400__$1 = missionary.impl.GroupBy.step(i,m);
while(true){
var temp__5827__auto___47401 = (table[i_47400__$1]);
if((temp__5827__auto___47401 == null)){
} else {
var h_47402 = temp__5827__auto___47401;
var j_47403 = (cljs.core.hash(h_47402.key) & m);
if((i_47400__$1 === j_47403)){
} else {
(table[i_47400__$1] = null);

var j_47404__$1 = j_47403;
while(true){
if(((table[j_47404__$1]) == null)){
(table[j_47404__$1] = h_47402);
} else {
var G__47405 = missionary.impl.GroupBy.step(j_47404__$1,m);
j_47404__$1 = G__47405;
continue;
}
break;
}
}

var G__47406 = missionary.impl.GroupBy.step(i_47400__$1,m);
i_47400__$1 = G__47406;
continue;
}
break;
}

var fexpr__47362 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,p.key))?p.notifier:g.notifier);
return (fexpr__47362.cljs$core$IFn$_invoke$arity$0 ? fexpr__47362.cljs$core$IFn$_invoke$arity$0() : fexpr__47362.call(null));
}
} else {
return null;
}
});
missionary.impl.GroupBy.transfer = (function missionary$impl$GroupBy$transfer(p){
while(true){
if(cljs.core.truth_((p.busy = cljs.core.not(p.busy)))){
if(cljs.core.truth_(p.done)){
(p.live = false);

var temp__5827__auto___47409 = p.table;
if((temp__5827__auto___47409 == null)){
} else {
var table_47410 = temp__5827__auto___47409;
(p.table = null);

var n__5593__auto___47411 = table_47410.length;
var i_47412 = (0);
while(true){
if((i_47412 < n__5593__auto___47411)){
var temp__5827__auto___47414__$1 = (table_47410[i_47412]);
if((temp__5827__auto___47414__$1 == null)){
} else {
var g_47416 = temp__5827__auto___47414__$1;
var fexpr__47367_47417 = g_47416.terminator;
(fexpr__47367_47417.cljs$core$IFn$_invoke$arity$0 ? fexpr__47367_47417.cljs$core$IFn$_invoke$arity$0() : fexpr__47367_47417.call(null));
}

var G__47418 = (i_47412 + (1));
i_47412 = G__47418;
continue;
} else {
}
break;
}
}

var fexpr__47368 = p.terminator;
return (fexpr__47368.cljs$core$IFn$_invoke$arity$0 ? fexpr__47368.cljs$core$IFn$_invoke$arity$0() : fexpr__47368.call(null));
} else {
if((p === p.value)){
var table = p.table;
try{var k = (p.key = (function (){var G__47373 = (p.value = cljs.core.deref(p.input));
var fexpr__47372 = p.keyfn;
return (fexpr__47372.cljs$core$IFn$_invoke$arity$1 ? fexpr__47372.cljs$core$IFn$_invoke$arity$1(G__47373) : fexpr__47372.call(null,G__47373));
})());
var m = (table.length - (1));
var i = (cljs.core.hash(k) & m);
while(true){
var temp__5825__auto__ = (table[i]);
if((temp__5825__auto__ == null)){
var fexpr__47374 = p.notifier;
return (fexpr__47374.cljs$core$IFn$_invoke$arity$0 ? fexpr__47374.cljs$core$IFn$_invoke$arity$0() : fexpr__47374.call(null));
} else {
var h = temp__5825__auto__;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,h.key)){
var fexpr__47375 = h.notifier;
return (fexpr__47375.cljs$core$IFn$_invoke$arity$0 ? fexpr__47375.cljs$core$IFn$_invoke$arity$0() : fexpr__47375.call(null));
} else {
var G__47422 = missionary.impl.GroupBy.step(i,m);
i = G__47422;
continue;
}
}
break;
}
}catch (e47369){var e = e47369;
(p.value = e);

(p.table = null);

missionary.impl.GroupBy.kill(p);

var n__5593__auto___47423 = table.length;
var i_47424 = (0);
while(true){
if((i_47424 < n__5593__auto___47423)){
var temp__5827__auto___47425 = (table[i_47424]);
if((temp__5827__auto___47425 == null)){
} else {
var g_47426 = temp__5827__auto___47425;
var fexpr__47370_47427 = g_47426.terminator;
(fexpr__47370_47427.cljs$core$IFn$_invoke$arity$0 ? fexpr__47370_47427.cljs$core$IFn$_invoke$arity$0() : fexpr__47370_47427.call(null));
}

var G__47428 = (i_47424 + (1));
i_47424 = G__47428;
continue;
} else {
}
break;
}

var fexpr__47371 = p.notifier;
return (fexpr__47371.cljs$core$IFn$_invoke$arity$0 ? fexpr__47371.cljs$core$IFn$_invoke$arity$0() : fexpr__47371.call(null));
}} else {
try{cljs.core.deref(p.input);
}catch (e47376){var __47429 = e47376;
}
continue;
}
}
} else {
return null;
}
break;
}
});
missionary.impl.GroupBy.sample = (function missionary$impl$GroupBy$sample(p){
var k = p.key;
if((k === p)){
missionary.impl.GroupBy.transfer(p);

throw p.value;
} else {
return cljs.core.__GT_MapEntry(k,p,null);
}
});
missionary.impl.GroupBy.consume = (function missionary$impl$GroupBy$consume(g){
var p = g.process;
if((p === g.key)){
var fexpr__47378_47430 = g.terminator;
(fexpr__47378_47430.cljs$core$IFn$_invoke$arity$0 ? fexpr__47378_47430.cljs$core$IFn$_invoke$arity$0() : fexpr__47378_47430.call(null));

throw (new missionary.Cancelled("Group consumer cancelled."));
} else {
var x = p.value;
(p.value = p);

(p.key = p);

missionary.impl.GroupBy.transfer(p);

return x;
}
});
missionary.impl.GroupBy.run = (function missionary$impl$GroupBy$run(k,f,n,t){
var p = missionary.impl.GroupBy.__GT_Process(k,n,t,null,null,null,cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((8)),(0),true,true,false);
(p.key = p);

(p.value = p);

(p.input = (function (){var G__47379 = (function (){
return missionary.impl.GroupBy.transfer(p);
});
var G__47380 = (function (){
(p.done = true);

return missionary.impl.GroupBy.transfer(p);
});
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__47379,G__47380) : f.call(null,G__47379,G__47380));
})());

missionary.impl.GroupBy.transfer(p);

return p;
});

//# sourceMappingURL=missionary.impl.GroupBy.js.map
