goog.provide('hyperfiddle.electric_client');
/**
 * @define {string}
 */
hyperfiddle.electric_client.ELECTRIC_USER_VERSION = goog.define("hyperfiddle.electric_client.ELECTRIC_USER_VERSION","hyperfiddle_electric_client__dirty");
hyperfiddle.electric_client.server_url = (function hyperfiddle$electric_client$server_url(){
var url = (new URL(window.location));
var proto = url.protocol;
(url.protocol = (function (){var G__50751 = proto;
switch (G__50751) {
case "http:":
return "ws:";

break;
case "https:":
return "wss:";

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unexpected protocol",proto);

}
})());

url.searchParams.set("ELECTRIC_USER_VERSION",hyperfiddle.electric_client.ELECTRIC_USER_VERSION);

(url.hash = "");

return url.toString();
});
hyperfiddle.electric_client._STAR_ws_server_url_STAR_ = hyperfiddle.electric_client.server_url();
hyperfiddle.electric_client.remove_listeners = (function hyperfiddle$electric_client$remove_listeners(ws){
(ws.onopen = null);

return (ws.onclose = null);
});
hyperfiddle.electric_client.connect = (function hyperfiddle$electric_client$connect(url){
return (function (s,f){
try{var ws = (new WebSocket(url));
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (_){
hyperfiddle.electric_client.remove_listeners(ws);

return (s.cljs$core$IFn$_invoke$arity$1 ? s.cljs$core$IFn$_invoke$arity$1(ws) : s.call(null,ws));
}));

(ws.onclose = (function (_){
hyperfiddle.electric_client.remove_listeners(ws);

return (s.cljs$core$IFn$_invoke$arity$1 ? s.cljs$core$IFn$_invoke$arity$1(null) : s.call(null,null));
}));

return (function (){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(WebSocket.CONNECTING,ws.readyState)){
return ws.close();
} else {
return null;
}
});
}catch (e50752){var e = e50752;
(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(e) : f.call(null,e));

return (function (){
return cljs.core.List.EMPTY;
});
}});
});
hyperfiddle.electric_client.wait_for_flush = (function hyperfiddle$electric_client$wait_for_flush(ws){
return cljs.core.partial.cljs$core$IFn$_invoke$arity$2((function (){var cr50753_block_0 = (function hyperfiddle$electric_client$wait_for_flush_$_cr50753_block_0(cr50753_state){
try{(cr50753_state[(0)] = cr50753_block_1);

return cr50753_state;
}catch (e50762){var cr50753_exception = e50762;
(cr50753_state[(0)] = null);

throw cr50753_exception;
}});
var cr50753_block_1 = (function hyperfiddle$electric_client$wait_for_flush_$_cr50753_block_1(cr50753_state){
try{var cr50753_place_0 = (4096);
var cr50753_place_1 = ws;
var cr50753_place_2 = cr50753_place_1.bufferedAmount;
var cr50753_place_3 = (cr50753_place_0 < cr50753_place_2);
var cr50753_place_4 = null;
if(cr50753_place_3){
(cr50753_state[(0)] = cr50753_block_3);

return cr50753_state;
} else {
(cr50753_state[(0)] = cr50753_block_2);

(cr50753_state[(1)] = cr50753_place_4);

return cr50753_state;
}
}catch (e50763){var cr50753_exception = e50763;
(cr50753_state[(0)] = null);

throw cr50753_exception;
}});
var cr50753_block_2 = (function hyperfiddle$electric_client$wait_for_flush_$_cr50753_block_2(cr50753_state){
try{var cr50753_place_5 = null;
(cr50753_state[(0)] = cr50753_block_5);

(cr50753_state[(1)] = cr50753_place_5);

return cr50753_state;
}catch (e50764){var cr50753_exception = e50764;
(cr50753_state[(0)] = null);

(cr50753_state[(1)] = null);

throw cr50753_exception;
}});
var cr50753_block_3 = (function hyperfiddle$electric_client$wait_for_flush_$_cr50753_block_3(cr50753_state){
try{var cr50753_place_6 = missionary.core.sleep;
var cr50753_place_7 = (50);
var cr50753_place_8 = (function (){var G__50767 = cr50753_place_7;
var fexpr__50766 = cr50753_place_6;
return (fexpr__50766.cljs$core$IFn$_invoke$arity$1 ? fexpr__50766.cljs$core$IFn$_invoke$arity$1(G__50767) : fexpr__50766.call(null,G__50767));
})();
(cr50753_state[(0)] = cr50753_block_4);

return missionary.core.park(cr50753_place_8);
}catch (e50765){var cr50753_exception = e50765;
(cr50753_state[(0)] = null);

throw cr50753_exception;
}});
var cr50753_block_4 = (function hyperfiddle$electric_client$wait_for_flush_$_cr50753_block_4(cr50753_state){
try{var cr50753_place_9 = missionary.core.unpark();
(cr50753_state[(0)] = cr50753_block_1);

return cr50753_state;
}catch (e50768){var cr50753_exception = e50768;
(cr50753_state[(0)] = null);

throw cr50753_exception;
}});
var cr50753_block_5 = (function hyperfiddle$electric_client$wait_for_flush_$_cr50753_block_5(cr50753_state){
try{var cr50753_place_4 = (cr50753_state[(1)]);
(cr50753_state[(0)] = null);

(cr50753_state[(1)] = null);

return cr50753_place_4;
}catch (e50769){var cr50753_exception = e50769;
(cr50753_state[(0)] = null);

(cr50753_state[(1)] = null);

throw cr50753_exception;
}});
return cloroutine.impl.coroutine((function (){var G__50770 = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((2));
(G__50770[(0)] = cr50753_block_0);

return G__50770;
})());
})(),missionary.core.sp_run);
});
hyperfiddle.electric_client.wait_for_close = (function hyperfiddle$electric_client$wait_for_close(ws){
return (function (s,f){
(ws.onclose = (function (e){
(ws.onclose = null);

var G__50771 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"code","code",1586293142),e.code,new cljs.core.Keyword(null,"reason","reason",-2070751759),e.reason], null);
return (s.cljs$core$IFn$_invoke$arity$1 ? s.cljs$core$IFn$_invoke$arity$1(G__50771) : s.call(null,G__50771));
}));

return (function (){
if((ws.onclose == null)){
return null;
} else {
(ws.onclose = null);

var G__50772 = (new missionary.Cancelled());
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__50772) : f.call(null,G__50772));
}
});
});
});
hyperfiddle.electric_client.payload = (function hyperfiddle$electric_client$payload(x){
return x.data;
});
hyperfiddle.electric_client.send_BANG_ = (function hyperfiddle$electric_client$send_BANG_(ws,msg){
var G__50773 = ws;
G__50773.send(msg);

return G__50773;
});
hyperfiddle.electric_client.send_all = (function hyperfiddle$electric_client$send_all(ws,msgs){
return missionary.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,null,cljs.core.partial.cljs$core$IFn$_invoke$arity$2((function (){var cr50774_block_0 = (function hyperfiddle$electric_client$send_all_$_cr50774_block_0(cr50774_state){
try{var cr50774_place_0 = hyperfiddle.electric_client.wait_for_flush;
var cr50774_place_1 = hyperfiddle.electric_client.send_BANG_;
var cr50774_place_2 = ws;
var cr50774_place_3 = hyperfiddle.electric.impl.io.encode;
var cr50774_place_4 = (1);
var cr50774_place_5 = msgs;
(cr50774_state[(0)] = cr50774_block_1);

(cr50774_state[(3)] = cr50774_place_0);

(cr50774_state[(1)] = cr50774_place_1);

(cr50774_state[(4)] = cr50774_place_2);

(cr50774_state[(2)] = cr50774_place_3);

return missionary.core.fork(cr50774_place_4,cr50774_place_5);
}catch (e50785){var cr50774_exception = e50785;
(cr50774_state[(0)] = null);

throw cr50774_exception;
}});
var cr50774_block_1 = (function hyperfiddle$electric_client$send_all_$_cr50774_block_1(cr50774_state){
try{var cr50774_place_1 = (cr50774_state[(1)]);
var cr50774_place_3 = (cr50774_state[(2)]);
var cr50774_place_0 = (cr50774_state[(3)]);
var cr50774_place_2 = (cr50774_state[(4)]);
var cr50774_place_6 = missionary.core.unpark();
var cr50774_place_7 = (function (){var G__50788 = cr50774_place_6;
var fexpr__50787 = cr50774_place_3;
return (fexpr__50787.cljs$core$IFn$_invoke$arity$1 ? fexpr__50787.cljs$core$IFn$_invoke$arity$1(G__50788) : fexpr__50787.call(null,G__50788));
})();
var cr50774_place_8 = (function (){var G__50790 = cr50774_place_2;
var G__50791 = cr50774_place_7;
var fexpr__50789 = cr50774_place_1;
return (fexpr__50789.cljs$core$IFn$_invoke$arity$2 ? fexpr__50789.cljs$core$IFn$_invoke$arity$2(G__50790,G__50791) : fexpr__50789.call(null,G__50790,G__50791));
})();
var cr50774_place_9 = (function (){var G__50793 = cr50774_place_8;
var fexpr__50792 = cr50774_place_0;
return (fexpr__50792.cljs$core$IFn$_invoke$arity$1 ? fexpr__50792.cljs$core$IFn$_invoke$arity$1(G__50793) : fexpr__50792.call(null,G__50793));
})();
(cr50774_state[(0)] = cr50774_block_2);

(cr50774_state[(1)] = null);

(cr50774_state[(2)] = null);

(cr50774_state[(3)] = null);

(cr50774_state[(4)] = null);

return missionary.core.park(cr50774_place_9);
}catch (e50786){var cr50774_exception = e50786;
(cr50774_state[(0)] = null);

(cr50774_state[(1)] = null);

(cr50774_state[(2)] = null);

(cr50774_state[(3)] = null);

(cr50774_state[(4)] = null);

throw cr50774_exception;
}});
var cr50774_block_2 = (function hyperfiddle$electric_client$send_all_$_cr50774_block_2(cr50774_state){
try{var cr50774_place_10 = missionary.core.unpark();
(cr50774_state[(0)] = null);

return cr50774_place_10;
}catch (e50794){var cr50774_exception = e50794;
(cr50774_state[(0)] = null);

throw cr50774_exception;
}});
return cloroutine.impl.coroutine((function (){var G__50795 = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((5));
(G__50795[(0)] = cr50774_block_0);

return G__50795;
})());
})(),missionary.core.ap_run));
});
hyperfiddle.electric_client.handle_hf_heartbeat = (function hyperfiddle$electric_client$handle_hf_heartbeat(ws,cb){
return (function (msg){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(msg,"HEARTBEAT")){
return hyperfiddle.electric_client.send_BANG_(ws,"HEARTBEAT");
} else {
var G__50796 = hyperfiddle.electric.impl.io.decode(msg);
return (cb.cljs$core$IFn$_invoke$arity$1 ? cb.cljs$core$IFn$_invoke$arity$1(G__50796) : cb.call(null,G__50796));
}
});
});
/**
 * 
 * server : the server part of the program
 * cb : the callback for incoming messages.
 * msgs : the discrete flow of messages to send, spawned when websocket is connected, cancelled on websocket close.
 * Returns a task producing nil or failing if the websocket was closed before end of reduction. 
 */
hyperfiddle.electric_client.connector = (function hyperfiddle$electric_client$connector(cb,msgs){
return cljs.core.partial.cljs$core$IFn$_invoke$arity$2((function (){var cr50797_block_4 = (function hyperfiddle$electric_client$connector_$_cr50797_block_4(cr50797_state){
try{var cr50797_place_29 = missionary.core.unpark();
(cr50797_state[(0)] = cr50797_block_6);

(cr50797_state[(2)] = cr50797_place_29);

return cr50797_state;
}catch (e50832){var cr50797_exception = e50832;
(cr50797_state[(0)] = cr50797_block_5);

(cr50797_state[(2)] = cr50797_exception);

return cr50797_state;
}});
var cr50797_block_11 = (function hyperfiddle$electric_client$connector_$_cr50797_block_11(cr50797_state){
try{var cr50797_place_47 = cljs.core.with_meta(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),cljs.core.IMap], null));
(cr50797_state[(0)] = cr50797_block_12);

(cr50797_state[(1)] = cr50797_place_47);

return cr50797_state;
}catch (e50833){var cr50797_exception = e50833;
(cr50797_state[(0)] = null);

(cr50797_state[(1)] = null);

throw cr50797_exception;
}});
var cr50797_block_2 = (function hyperfiddle$electric_client$connector_$_cr50797_block_2(cr50797_state){
try{var cr50797_place_3 = (cr50797_state[(2)]);
var cr50797_place_8 = cr50797_place_3;
var cr50797_place_9 = null;
var cr50797_place_10 = false;
(cr50797_state[(0)] = cr50797_block_3);

(cr50797_state[(2)] = null);

(cr50797_state[(4)] = cr50797_place_8);

(cr50797_state[(2)] = cr50797_place_9);

(cr50797_state[(3)] = cr50797_place_10);

return cr50797_state;
}catch (e50834){var cr50797_exception = e50834;
(cr50797_state[(0)] = null);

(cr50797_state[(1)] = null);

(cr50797_state[(2)] = null);

throw cr50797_exception;
}});
var cr50797_block_6 = (function hyperfiddle$electric_client$connector_$_cr50797_block_6(cr50797_state){
try{var cr50797_place_8 = (cr50797_state[(4)]);
var cr50797_place_32 = cljs.core._EQ_;
var cr50797_place_33 = WebSocket;
var cr50797_place_34 = cr50797_place_33.CLOSED;
var cr50797_place_35 = cr50797_place_8;
var cr50797_place_36 = cr50797_place_35.readyState;
var cr50797_place_37 = (function (){var G__50837 = cr50797_place_34;
var G__50838 = cr50797_place_36;
var fexpr__50836 = cr50797_place_32;
return (fexpr__50836.cljs$core$IFn$_invoke$arity$2 ? fexpr__50836.cljs$core$IFn$_invoke$arity$2(G__50837,G__50838) : fexpr__50836.call(null,G__50837,G__50838));
})();
var cr50797_place_38 = null;
if(cljs.core.truth_(cr50797_place_37)){
(cr50797_state[(0)] = cr50797_block_9);

(cr50797_state[(4)] = null);

(cr50797_state[(5)] = cr50797_place_38);

return cr50797_state;
} else {
(cr50797_state[(0)] = cr50797_block_7);

(cr50797_state[(5)] = cr50797_place_38);

return cr50797_state;
}
}catch (e50835){var cr50797_exception = e50835;
(cr50797_state[(0)] = null);

(cr50797_state[(1)] = null);

(cr50797_state[(2)] = null);

(cr50797_state[(3)] = null);

(cr50797_state[(4)] = null);

throw cr50797_exception;
}});
var cr50797_block_7 = (function hyperfiddle$electric_client$connector_$_cr50797_block_7(cr50797_state){
try{var cr50797_place_8 = (cr50797_state[(4)]);
var cr50797_place_39 = cr50797_place_8;
var cr50797_place_40 = cr50797_place_39.close();
var cr50797_place_41 = missionary.core.compel;
var cr50797_place_42 = hyperfiddle.electric_client.wait_for_close;
var cr50797_place_43 = (function (){var G__50841 = cr50797_place_42;
var fexpr__50840 = cr50797_place_41;
return (fexpr__50840.cljs$core$IFn$_invoke$arity$1 ? fexpr__50840.cljs$core$IFn$_invoke$arity$1(G__50841) : fexpr__50840.call(null,G__50841));
})();
(cr50797_state[(0)] = cr50797_block_8);

(cr50797_state[(4)] = null);

return missionary.core.park(cr50797_place_43);
}catch (e50839){var cr50797_exception = e50839;
(cr50797_state[(0)] = null);

(cr50797_state[(1)] = null);

(cr50797_state[(5)] = null);

(cr50797_state[(2)] = null);

(cr50797_state[(3)] = null);

(cr50797_state[(4)] = null);

throw cr50797_exception;
}});
var cr50797_block_1 = (function hyperfiddle$electric_client$connector_$_cr50797_block_1(cr50797_state){
try{var cr50797_place_3 = missionary.core.unpark();
var cr50797_place_4 = cr50797_place_3;
var cr50797_place_5 = null;
var cr50797_place_6 = (cr50797_place_4 == cr50797_place_5);
var cr50797_place_7 = null;
if(cr50797_place_6){
(cr50797_state[(0)] = cr50797_block_11);

(cr50797_state[(1)] = cr50797_place_7);

return cr50797_state;
} else {
(cr50797_state[(0)] = cr50797_block_2);

(cr50797_state[(2)] = cr50797_place_3);

(cr50797_state[(1)] = cr50797_place_7);

return cr50797_state;
}
}catch (e50842){var cr50797_exception = e50842;
(cr50797_state[(0)] = null);

throw cr50797_exception;
}});
var cr50797_block_0 = (function hyperfiddle$electric_client$connector_$_cr50797_block_0(cr50797_state){
try{var cr50797_place_0 = hyperfiddle.electric_client.connect;
var cr50797_place_1 = hyperfiddle.electric_client._STAR_ws_server_url_STAR_;
var cr50797_place_2 = (function (){var G__50845 = cr50797_place_1;
var fexpr__50844 = cr50797_place_0;
return (fexpr__50844.cljs$core$IFn$_invoke$arity$1 ? fexpr__50844.cljs$core$IFn$_invoke$arity$1(G__50845) : fexpr__50844.call(null,G__50845));
})();
(cr50797_state[(0)] = cr50797_block_1);

return missionary.core.park(cr50797_place_2);
}catch (e50843){var cr50797_exception = e50843;
(cr50797_state[(0)] = null);

throw cr50797_exception;
}});
var cr50797_block_8 = (function hyperfiddle$electric_client$connector_$_cr50797_block_8(cr50797_state){
try{var cr50797_place_44 = missionary.core.unpark();
(cr50797_state[(0)] = cr50797_block_10);

(cr50797_state[(5)] = cr50797_place_44);

return cr50797_state;
}catch (e50846){var cr50797_exception = e50846;
(cr50797_state[(0)] = null);

(cr50797_state[(1)] = null);

(cr50797_state[(5)] = null);

(cr50797_state[(2)] = null);

(cr50797_state[(3)] = null);

throw cr50797_exception;
}});
var cr50797_block_10 = (function hyperfiddle$electric_client$connector_$_cr50797_block_10(cr50797_state){
try{var cr50797_place_38 = (cr50797_state[(5)]);
var cr50797_place_9 = (cr50797_state[(2)]);
var cr50797_place_10 = (cr50797_state[(3)]);
var cr50797_place_46 = (cljs.core.truth_(cr50797_place_10)?(function(){throw cr50797_place_9})():cr50797_place_9);
(cr50797_state[(0)] = cr50797_block_12);

(cr50797_state[(5)] = null);

(cr50797_state[(2)] = null);

(cr50797_state[(3)] = null);

(cr50797_state[(1)] = cr50797_place_46);

return cr50797_state;
}catch (e50847){var cr50797_exception = e50847;
(cr50797_state[(0)] = null);

(cr50797_state[(1)] = null);

(cr50797_state[(5)] = null);

(cr50797_state[(2)] = null);

(cr50797_state[(3)] = null);

throw cr50797_exception;
}});
var cr50797_block_5 = (function hyperfiddle$electric_client$connector_$_cr50797_block_5(cr50797_state){
try{var cr50797_place_9 = (cr50797_state[(2)]);
var cr50797_place_30 = cr50797_place_9;
var cr50797_place_31 = (function(){throw cr50797_place_30})();
(cr50797_state[(0)] = null);

(cr50797_state[(1)] = null);

(cr50797_state[(2)] = null);

(cr50797_state[(3)] = null);

(cr50797_state[(4)] = null);

return null;
}catch (e50848){var cr50797_exception = e50848;
(cr50797_state[(0)] = cr50797_block_6);

(cr50797_state[(3)] = true);

(cr50797_state[(2)] = cr50797_exception);

return cr50797_state;
}});
var cr50797_block_9 = (function hyperfiddle$electric_client$connector_$_cr50797_block_9(cr50797_state){
try{var cr50797_place_45 = null;
(cr50797_state[(0)] = cr50797_block_10);

(cr50797_state[(5)] = cr50797_place_45);

return cr50797_state;
}catch (e50849){var cr50797_exception = e50849;
(cr50797_state[(0)] = null);

(cr50797_state[(1)] = null);

(cr50797_state[(5)] = null);

(cr50797_state[(2)] = null);

(cr50797_state[(3)] = null);

throw cr50797_exception;
}});
var cr50797_block_12 = (function hyperfiddle$electric_client$connector_$_cr50797_block_12(cr50797_state){
try{var cr50797_place_7 = (cr50797_state[(1)]);
(cr50797_state[(0)] = null);

(cr50797_state[(1)] = null);

return cr50797_place_7;
}catch (e50850){var cr50797_exception = e50850;
(cr50797_state[(0)] = null);

(cr50797_state[(1)] = null);

throw cr50797_exception;
}});
var cr50797_block_3 = (function hyperfiddle$electric_client$connector_$_cr50797_block_3(cr50797_state){
try{var cr50797_place_8 = (cr50797_state[(4)]);
var cr50797_place_11 = cr50797_place_8;
var cr50797_place_12 = cljs.core.comp;
var cr50797_place_13 = hyperfiddle.electric_client.handle_hf_heartbeat;
var cr50797_place_14 = cr50797_place_8;
var cr50797_place_15 = cb;
var cr50797_place_16 = (function (){var G__50853 = cr50797_place_14;
var G__50854 = cr50797_place_15;
var fexpr__50852 = cr50797_place_13;
return (fexpr__50852.cljs$core$IFn$_invoke$arity$2 ? fexpr__50852.cljs$core$IFn$_invoke$arity$2(G__50853,G__50854) : fexpr__50852.call(null,G__50853,G__50854));
})();
var cr50797_place_17 = hyperfiddle.electric_client.payload;
var cr50797_place_18 = (function (){var G__50856 = cr50797_place_16;
var G__50857 = cr50797_place_17;
var fexpr__50855 = cr50797_place_12;
return (fexpr__50855.cljs$core$IFn$_invoke$arity$2 ? fexpr__50855.cljs$core$IFn$_invoke$arity$2(G__50856,G__50857) : fexpr__50855.call(null,G__50856,G__50857));
})();
var cr50797_place_19 = (cr50797_place_11.onmessage = cr50797_place_18);
var cr50797_place_20 = missionary.core.race;
var cr50797_place_21 = hyperfiddle.electric_client.send_all;
var cr50797_place_22 = cr50797_place_8;
var cr50797_place_23 = msgs;
var cr50797_place_24 = (function (){var G__50859 = cr50797_place_22;
var G__50860 = cr50797_place_23;
var fexpr__50858 = cr50797_place_21;
return (fexpr__50858.cljs$core$IFn$_invoke$arity$2 ? fexpr__50858.cljs$core$IFn$_invoke$arity$2(G__50859,G__50860) : fexpr__50858.call(null,G__50859,G__50860));
})();
var cr50797_place_25 = hyperfiddle.electric_client.wait_for_close;
var cr50797_place_26 = cr50797_place_8;
var cr50797_place_27 = (function (){var G__50862 = cr50797_place_26;
var fexpr__50861 = cr50797_place_25;
return (fexpr__50861.cljs$core$IFn$_invoke$arity$1 ? fexpr__50861.cljs$core$IFn$_invoke$arity$1(G__50862) : fexpr__50861.call(null,G__50862));
})();
var cr50797_place_28 = (function (){var G__50864 = cr50797_place_24;
var G__50865 = cr50797_place_27;
var fexpr__50863 = cr50797_place_20;
return (fexpr__50863.cljs$core$IFn$_invoke$arity$2 ? fexpr__50863.cljs$core$IFn$_invoke$arity$2(G__50864,G__50865) : fexpr__50863.call(null,G__50864,G__50865));
})();
(cr50797_state[(0)] = cr50797_block_4);

return missionary.core.park(cr50797_place_28);
}catch (e50851){var cr50797_exception = e50851;
(cr50797_state[(0)] = cr50797_block_5);

(cr50797_state[(2)] = cr50797_exception);

return cr50797_state;
}});
return cloroutine.impl.coroutine((function (){var G__50866 = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((6));
(G__50866[(0)] = cr50797_block_0);

return G__50866;
})());
})(),missionary.core.sp_run);
});
hyperfiddle.electric_client.fib_iter = (function hyperfiddle$electric_client$fib_iter(p__50867){
var vec__50868 = p__50867;
var a = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50868,(0),null);
var b = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50868,(1),null);
var G__50871 = b;
switch (G__50871) {
case (0):
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(1)], null);

break;
default:
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [b,(a + b)], null);

}
});
hyperfiddle.electric_client.fib = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.iterate(hyperfiddle.electric_client.fib_iter,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(1)], null)));
hyperfiddle.electric_client.retry_delays = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,(100)),hyperfiddle.electric_client.fib);
hyperfiddle.electric_client.boot_with_retry = (function hyperfiddle$electric_client$boot_with_retry(client,conn){
return cljs.core.partial.cljs$core$IFn$_invoke$arity$2((function (){var cr50872_block_2 = (function hyperfiddle$electric_client$boot_with_retry_$_cr50872_block_2(cr50872_state){
try{var cr50872_place_4 = (cr50872_state[(3)]);
var cr50872_place_14 = (function (x){
var fexpr__50964 = (cr50872_place_4[(0)]);
var G__51176 = x;
var fexpr__51175 = fexpr__50964;
return (fexpr__51175.cljs$core$IFn$_invoke$arity$1 ? fexpr__51175.cljs$core$IFn$_invoke$arity$1(G__51176) : fexpr__51175.call(null,G__51176));
});
var cr50872_place_15 = cljs.core.partial;
var cr50872_place_32 = (function (cr50965_state){
try{var cr50965_place_42 = (cr50965_state[(1)]);
(cr50965_state[(0)] = cr50872_place_17);

(cr50965_state[(1)] = null);

(cr50965_state[(3)] = cr50965_place_42);

return cr50965_state;
}catch (e51213){var e51039 = e51213;
var cr50965_exception = e51039;
(cr50965_state[(0)] = null);

(cr50965_state[(1)] = null);

(cr50965_state[(3)] = null);

(cr50965_state[(2)] = null);

throw cr50965_exception;
}});
var cr50872_place_19 = (function (cr50965_state){
try{var cr50965_place_0 = console;
var cr50965_place_1 = "Connected.";
var cr50965_place_2 = cr50965_place_0.log(cr50965_place_1);
var cr50965_place_3 = missionary.core.rdv;
var cr50965_place_4 = (function (){var fexpr__51010 = cr50965_place_3;
var fexpr__51215 = fexpr__51010;
return (fexpr__51215.cljs$core$IFn$_invoke$arity$0 ? fexpr__51215.cljs$core$IFn$_invoke$arity$0() : fexpr__51215.call(null));
})();
var cr50965_place_5 = (2);
var cr50965_place_6 = missionary.core.seed;
var cr50965_place_7 = cljs.core.range;
var cr50965_place_8 = (2);
var cr50965_place_9 = (function (){var G__51012 = cr50965_place_8;
var fexpr__51011 = cr50965_place_7;
var G__51217 = G__51012;
var fexpr__51216 = fexpr__51011;
return (fexpr__51216.cljs$core$IFn$_invoke$arity$1 ? fexpr__51216.cljs$core$IFn$_invoke$arity$1(G__51217) : fexpr__51216.call(null,G__51217));
})();
var cr50965_place_10 = (function (){var G__51014 = cr50965_place_9;
var fexpr__51013 = cr50965_place_6;
var G__51219 = G__51014;
var fexpr__51218 = fexpr__51013;
return (fexpr__51218.cljs$core$IFn$_invoke$arity$1 ? fexpr__51218.cljs$core$IFn$_invoke$arity$1(G__51219) : fexpr__51218.call(null,G__51219));
})();
(cr50965_state[(0)] = cr50872_place_27);

(cr50965_state[(1)] = cr50965_place_4);

return missionary.core.fork(cr50965_place_5,cr50965_place_10);
}catch (e51214){var e51009 = e51214;
var cr50965_exception = e51009;
(cr50965_state[(0)] = null);

throw cr50965_exception;
}});
var cr50872_place_28 = (function (cr50965_state){
try{var cr50965_place_40 = missionary.core.unpark();
var cr50965_place_41 = cr50965_place_40;
var cr50965_place_42 = null;
var G__51031 = cr50965_place_41;
var G__51221 = G__51031;
switch (G__51221) {
case (0):
(cr50965_state[(0)] = cr50872_place_33);

(cr50965_state[(1)] = null);

(cr50965_state[(1)] = cr50965_place_42);

return cr50965_state;

break;
case (1):
(cr50965_state[(0)] = cr50872_place_22);

(cr50965_state[(3)] = null);

(cr50965_state[(4)] = null);

return cr50965_state;

break;
default:
(cr50965_state[(0)] = cr50872_place_25);

(cr50965_state[(3)] = null);

(cr50965_state[(1)] = null);

(cr50965_state[(4)] = null);

(cr50965_state[(2)] = null);

(cr50965_state[(1)] = cr50965_place_40);

return cr50965_state;

}
}catch (e51220){var e51030 = e51220;
var cr50965_exception = e51030;
(cr50965_state[(0)] = null);

(cr50965_state[(3)] = null);

(cr50965_state[(1)] = null);

(cr50965_state[(4)] = null);

(cr50965_state[(2)] = null);

throw cr50965_exception;
}});
var cr50872_place_21 = (function (cr50965_state){
try{var cr50965_place_4 = (cr50965_state[(1)]);
var cr50965_place_14 = cr50965_place_4;
var cr50965_place_15 = hyperfiddle.electric.impl.runtime.subject_at;
var cr50965_place_16 = cr50872_place_4;
var cr50965_place_17 = (0);
var cr50965_place_18 = (function (){var G__51018 = cr50965_place_16;
var G__51019 = cr50965_place_17;
var fexpr__51017 = cr50965_place_15;
var G__51224 = G__51018;
var G__51225 = G__51019;
var fexpr__51223 = fexpr__51017;
return (fexpr__51223.cljs$core$IFn$_invoke$arity$2 ? fexpr__51223.cljs$core$IFn$_invoke$arity$2(G__51224,G__51225) : fexpr__51223.call(null,G__51224,G__51225));
})();
var cr50965_place_19 = client;
var cr50965_place_20 = cr50965_place_14;
var cr50965_place_21 = cr50965_place_18;
var cr50965_place_22 = (function (){var G__51021 = cr50965_place_20;
var G__51022 = cr50965_place_21;
var fexpr__51020 = cr50965_place_19;
var G__51227 = G__51021;
var G__51228 = G__51022;
var fexpr__51226 = fexpr__51020;
return (fexpr__51226.cljs$core$IFn$_invoke$arity$2 ? fexpr__51226.cljs$core$IFn$_invoke$arity$2(G__51227,G__51228) : fexpr__51226.call(null,G__51227,G__51228));
})();
(cr50965_state[(0)] = cr50872_place_29);

(cr50965_state[(1)] = null);

return missionary.core.park(cr50965_place_22);
}catch (e51222){var e51016 = e51222;
var cr50965_exception = e51016;
(cr50965_state[(0)] = null);

(cr50965_state[(1)] = null);

(cr50965_state[(2)] = null);

throw cr50965_exception;
}});
var cr50872_place_17 = (function (cr50965_state){
try{var cr50965_place_32 = (cr50965_state[(3)]);
(cr50965_state[(0)] = cr50872_place_30);

(cr50965_state[(3)] = null);

(cr50965_state[(2)] = cr50965_place_32);

return cr50965_state;
}catch (e51229){var e51007 = e51229;
var cr50965_exception = e51007;
(cr50965_state[(0)] = null);

(cr50965_state[(3)] = null);

(cr50965_state[(2)] = null);

throw cr50965_exception;
}});
var cr50872_place_23 = (function (cr50965_state){
try{var cr50965_place_28 = missionary.core.unpark();
var cr50965_place_29 = cr50965_place_28;
var cr50965_place_30 = null;
var cr50965_place_31 = (cr50965_place_29 == cr50965_place_30);
var cr50965_place_32 = null;
if(cr50965_place_31){
(cr50965_state[(0)] = cr50872_place_34);

(cr50965_state[(1)] = null);

(cr50965_state[(3)] = cr50965_place_32);

return cr50965_state;
} else {
(cr50965_state[(0)] = cr50872_place_31);

(cr50965_state[(4)] = cr50965_place_28);

(cr50965_state[(3)] = cr50965_place_32);

return cr50965_state;
}
}catch (e51230){var e51024 = e51230;
var cr50965_exception = e51024;
(cr50965_state[(0)] = null);

(cr50965_state[(1)] = null);

(cr50965_state[(2)] = null);

throw cr50965_exception;
}});
var cr50872_place_30 = (function (cr50965_state){
try{var cr50965_place_13 = (cr50965_state[(2)]);
(cr50965_state[(0)] = null);

(cr50965_state[(2)] = null);

return cr50965_place_13;
}catch (e51231){var e51033 = e51231;
var cr50965_exception = e51033;
(cr50965_state[(0)] = null);

(cr50965_state[(2)] = null);

throw cr50965_exception;
}});
var cr50872_place_18 = (function (cr50965_state){
try{var cr50965_place_26 = missionary.core.unpark();
(cr50965_state[(0)] = cr50872_place_30);

(cr50965_state[(2)] = cr50965_place_26);

return cr50965_state;
}catch (e51232){var e51008 = e51232;
var cr50965_exception = e51008;
(cr50965_state[(0)] = null);

(cr50965_state[(2)] = null);

throw cr50965_exception;
}});
var cr50872_place_33 = (function (cr50965_state){
try{var cr50965_place_33 = (cr50965_state[(4)]);
var cr50965_place_43 = cr50965_place_33;
(cr50965_state[(0)] = cr50872_place_32);

(cr50965_state[(4)] = null);

(cr50965_state[(1)] = cr50965_place_43);

return cr50965_state;
}catch (e51233){var e51040 = e51233;
var cr50965_exception = e51040;
(cr50965_state[(0)] = null);

(cr50965_state[(1)] = null);

(cr50965_state[(3)] = null);

(cr50965_state[(4)] = null);

(cr50965_state[(2)] = null);

throw cr50965_exception;
}});
var cr50872_place_24 = (function (cr50965_state){
try{(cr50965_state[(0)] = cr50872_place_26);

return cr50965_state;
}catch (e51234){var e51025 = e51234;
var cr50965_exception = e51025;
(cr50965_state[(0)] = null);

(cr50965_state[(1)] = null);

(cr50965_state[(2)] = null);

throw cr50965_exception;
}});
var cr50872_place_25 = (function (cr50965_state){
try{var cr50965_place_40 = (cr50965_state[(1)]);
var cr50965_place_44 = "No matching clause: ";
var cr50965_place_45 = cr50965_place_40;
var cr50965_place_46 = [cr50965_place_44,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cr50965_place_45)].join('');
var cr50965_place_47 = (new Error(cr50965_place_46));
var cr50965_place_48 = (function(){throw cr50965_place_47})();
(cr50965_state[(0)] = null);

(cr50965_state[(1)] = null);

return null;
}catch (e51235){var e51026 = e51235;
var cr50965_exception = e51026;
(cr50965_state[(0)] = null);

(cr50965_state[(1)] = null);

throw cr50965_exception;
}});
var cr50872_place_27 = (function (cr50965_state){
try{var cr50965_place_11 = missionary.core.unpark();
var cr50965_place_12 = cr50965_place_11;
var cr50965_place_13 = null;
var G__51029 = cr50965_place_12;
var G__51237 = G__51029;
switch (G__51237) {
case (0):
(cr50965_state[(0)] = cr50872_place_21);

(cr50965_state[(2)] = cr50965_place_13);

return cr50965_state;

break;
case (1):
(cr50965_state[(0)] = cr50872_place_24);

(cr50965_state[(2)] = cr50965_place_13);

return cr50965_state;

break;
default:
(cr50965_state[(0)] = cr50872_place_16);

(cr50965_state[(1)] = null);

(cr50965_state[(1)] = cr50965_place_11);

return cr50965_state;

}
}catch (e51236){var e51028 = e51236;
var cr50965_exception = e51028;
(cr50965_state[(0)] = null);

(cr50965_state[(1)] = null);

throw cr50965_exception;
}});
var cr50872_place_31 = (function (cr50965_state){
try{var cr50965_place_28 = (cr50965_state[(4)]);
var cr50965_place_33 = cr50965_place_28;
var cr50965_place_34 = (1);
var cr50965_place_35 = missionary.core.seed;
var cr50965_place_36 = cljs.core.range;
var cr50965_place_37 = (2);
var cr50965_place_38 = (function (){var G__51036 = cr50965_place_37;
var fexpr__51035 = cr50965_place_36;
var G__51240 = G__51036;
var fexpr__51239 = fexpr__51035;
return (fexpr__51239.cljs$core$IFn$_invoke$arity$1 ? fexpr__51239.cljs$core$IFn$_invoke$arity$1(G__51240) : fexpr__51239.call(null,G__51240));
})();
var cr50965_place_39 = (function (){var G__51038 = cr50965_place_38;
var fexpr__51037 = cr50965_place_35;
var G__51242 = G__51038;
var fexpr__51241 = fexpr__51037;
return (fexpr__51241.cljs$core$IFn$_invoke$arity$1 ? fexpr__51241.cljs$core$IFn$_invoke$arity$1(G__51242) : fexpr__51241.call(null,G__51242));
})();
(cr50965_state[(0)] = cr50872_place_28);

(cr50965_state[(4)] = null);

(cr50965_state[(4)] = cr50965_place_33);

return missionary.core.fork(cr50965_place_34,cr50965_place_39);
}catch (e51238){var e51034 = e51238;
var cr50965_exception = e51034;
(cr50965_state[(0)] = null);

(cr50965_state[(3)] = null);

(cr50965_state[(1)] = null);

(cr50965_state[(4)] = null);

(cr50965_state[(2)] = null);

throw cr50965_exception;
}});
var cr50872_place_29 = (function (cr50965_state){
try{var cr50965_place_23 = missionary.core.unpark();
var cr50965_place_24 = (1);
var cr50965_place_25 = missionary.core.none;
(cr50965_state[(0)] = cr50872_place_18);

return missionary.core.fork(cr50965_place_24,cr50965_place_25);
}catch (e51243){var e51032 = e51243;
var cr50965_exception = e51032;
(cr50965_state[(0)] = null);

(cr50965_state[(2)] = null);

throw cr50965_exception;
}});
var cr50872_place_20 = (function (cr50965_state){
try{var cr50965_place_51 = missionary.core.unpark();
(cr50965_state[(0)] = cr50872_place_17);

(cr50965_state[(3)] = cr50965_place_51);

return cr50965_state;
}catch (e51244){var e51015 = e51244;
var cr50965_exception = e51015;
(cr50965_state[(0)] = null);

(cr50965_state[(3)] = null);

(cr50965_state[(2)] = null);

throw cr50965_exception;
}});
var cr50872_place_16 = (function (cr50965_state){
try{var cr50965_place_11 = (cr50965_state[(1)]);
var cr50965_place_52 = "No matching clause: ";
var cr50965_place_53 = cr50965_place_11;
var cr50965_place_54 = [cr50965_place_52,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cr50965_place_53)].join('');
var cr50965_place_55 = (new Error(cr50965_place_54));
var cr50965_place_56 = (function(){throw cr50965_place_55})();
(cr50965_state[(0)] = null);

(cr50965_state[(1)] = null);

return null;
}catch (e51245){var e51006 = e51245;
var cr50965_exception = e51006;
(cr50965_state[(0)] = null);

(cr50965_state[(1)] = null);

throw cr50965_exception;
}});
var cr50872_place_26 = (function (cr50965_state){
try{var cr50965_place_4 = (cr50965_state[(1)]);
var cr50965_place_27 = cr50965_place_4;
(cr50965_state[(0)] = cr50872_place_23);

return missionary.core.park(cr50965_place_27);
}catch (e51246){var e51027 = e51246;
var cr50965_exception = e51027;
(cr50965_state[(0)] = null);

(cr50965_state[(1)] = null);

(cr50965_state[(2)] = null);

throw cr50965_exception;
}});
var cr50872_place_22 = (function (cr50965_state){
try{(cr50965_state[(0)] = cr50872_place_26);

return cr50965_state;
}catch (e51247){var e51023 = e51247;
var cr50965_exception = e51023;
(cr50965_state[(0)] = null);

(cr50965_state[(1)] = null);

(cr50965_state[(2)] = null);

throw cr50965_exception;
}});
var cr50872_place_34 = (function (cr50965_state){
try{var cr50965_place_49 = (1);
var cr50965_place_50 = missionary.core.none;
(cr50965_state[(0)] = cr50872_place_20);

return missionary.core.fork(cr50965_place_49,cr50965_place_50);
}catch (e51248){var e51041 = e51248;
var cr50965_exception = e51041;
(cr50965_state[(0)] = null);

(cr50965_state[(3)] = null);

(cr50965_state[(2)] = null);

throw cr50965_exception;
}});
var cr50872_place_35 = cloroutine.impl.coroutine;
var cr50872_place_36 = cljs.core.object_array;
var cr50872_place_37 = (5);
var cr50872_place_38 = (function (){var G__51250 = cr50872_place_37;
var fexpr__51249 = cr50872_place_36;
return (fexpr__51249.cljs$core$IFn$_invoke$arity$1 ? fexpr__51249.cljs$core$IFn$_invoke$arity$1(G__51250) : fexpr__51249.call(null,G__51250));
})();
var cr50872_place_39 = cr50872_place_38;
var cr50872_place_40 = (0);
var cr50872_place_41 = cr50872_place_19;
var cr50872_place_42 = (cr50872_place_39[cr50872_place_40] = cr50872_place_41);
var cr50872_place_43 = cr50872_place_38;
var cr50872_place_44 = (function (){var G__51252 = cr50872_place_43;
var fexpr__51251 = cr50872_place_35;
return (fexpr__51251.cljs$core$IFn$_invoke$arity$1 ? fexpr__51251.cljs$core$IFn$_invoke$arity$1(G__51252) : fexpr__51251.call(null,G__51252));
})();
var cr50872_place_45 = missionary.core.ap_run;
var cr50872_place_46 = (function (){var G__51254 = cr50872_place_44;
var G__51255 = cr50872_place_45;
var fexpr__51253 = cr50872_place_15;
return (fexpr__51253.cljs$core$IFn$_invoke$arity$2 ? fexpr__51253.cljs$core$IFn$_invoke$arity$2(G__51254,G__51255) : fexpr__51253.call(null,G__51254,G__51255));
})();
var cr50872_place_47 = conn;
var cr50872_place_48 = cr50872_place_14;
var cr50872_place_49 = cr50872_place_46;
var cr50872_place_50 = (function (){var G__51257 = cr50872_place_48;
var G__51258 = cr50872_place_49;
var fexpr__51256 = cr50872_place_47;
return (fexpr__51256.cljs$core$IFn$_invoke$arity$2 ? fexpr__51256.cljs$core$IFn$_invoke$arity$2(G__51257,G__51258) : fexpr__51256.call(null,G__51257,G__51258));
})();
(cr50872_state[(0)] = cr50872_block_3);

(cr50872_state[(3)] = null);

return missionary.core.park(cr50872_place_50);
}catch (e51174){var cr50872_exception = e51174;
(cr50872_state[(0)] = cr50872_block_4);

(cr50872_state[(3)] = null);

(cr50872_state[(5)] = cr50872_exception);

return cr50872_state;
}});
var cr50872_block_10 = (function hyperfiddle$electric_client$boot_with_retry_$_cr50872_block_10(cr50872_state){
try{var cr50872_place_86 = console;
var cr50872_place_87 = "Server timed out, considering this client inactive.";
var cr50872_place_88 = cr50872_place_86.log(cr50872_place_87);
var cr50872_place_89 = cljs.core.seq;
var cr50872_place_90 = hyperfiddle.electric_client.retry_delays;
var cr50872_place_91 = (function (){var G__51261 = cr50872_place_90;
var fexpr__51260 = cr50872_place_89;
return (fexpr__51260.cljs$core$IFn$_invoke$arity$1 ? fexpr__51260.cljs$core$IFn$_invoke$arity$1(G__51261) : fexpr__51260.call(null,G__51261));
})();
(cr50872_state[(0)] = cr50872_block_12);

(cr50872_state[(4)] = cr50872_place_91);

return cr50872_state;
}catch (e51259){var cr50872_exception = e51259;
(cr50872_state[(0)] = null);

(cr50872_state[(4)] = null);

(cr50872_state[(5)] = null);

(cr50872_state[(1)] = null);

(cr50872_state[(3)] = null);

(cr50872_state[(2)] = null);

throw cr50872_exception;
}});
var cr50872_block_11 = (function hyperfiddle$electric_client$boot_with_retry_$_cr50872_block_11(cr50872_state){
try{var cr50872_place_69 = (cr50872_state[(1)]);
var cr50872_place_61 = (cr50872_state[(6)]);
var cr50872_place_92 = cljs.core.ex_info;
var cr50872_place_93 = "Remote error - ";
var cr50872_place_94 = cr50872_place_69;
var cr50872_place_95 = " ";
var cr50872_place_96 = new cljs.core.Keyword(null,"reason","reason",-2070751759);
var cr50872_place_97 = cr50872_place_61;
var cr50872_place_98 = cr50872_place_96.cljs$core$IFn$_invoke$arity$1(cr50872_place_97);
var cr50872_place_99 = [cr50872_place_93,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cr50872_place_94),cr50872_place_95,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cr50872_place_98)].join('');
var cr50872_place_100 = cljs.core.with_meta(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),cljs.core.IMap], null));
var cr50872_place_101 = (function (){var G__51264 = cr50872_place_99;
var G__51265 = cr50872_place_100;
var fexpr__51263 = cr50872_place_92;
return (fexpr__51263.cljs$core$IFn$_invoke$arity$2 ? fexpr__51263.cljs$core$IFn$_invoke$arity$2(G__51264,G__51265) : fexpr__51263.call(null,G__51264,G__51265));
})();
var cr50872_place_102 = (function(){throw cr50872_place_101})();
(cr50872_state[(0)] = null);

(cr50872_state[(1)] = null);

(cr50872_state[(6)] = null);

return null;
}catch (e51262){var cr50872_exception = e51262;
(cr50872_state[(0)] = null);

(cr50872_state[(1)] = null);

(cr50872_state[(6)] = null);

throw cr50872_exception;
}});
var cr50872_block_3 = (function hyperfiddle$electric_client$boot_with_retry_$_cr50872_block_3(cr50872_state){
try{var cr50872_place_51 = missionary.core.unpark();
(cr50872_state[(0)] = cr50872_block_5);

(cr50872_state[(5)] = cr50872_place_51);

return cr50872_state;
}catch (e51266){var cr50872_exception = e51266;
(cr50872_state[(0)] = cr50872_block_4);

(cr50872_state[(5)] = cr50872_exception);

return cr50872_state;
}});
var cr50872_block_4 = (function hyperfiddle$electric_client$boot_with_retry_$_cr50872_block_4(cr50872_state){
try{var cr50872_place_12 = (cr50872_state[(5)]);
var cr50872_place_52 = cr50872_place_12;
var cr50872_place_53 = (function(){throw cr50872_place_52})();
(cr50872_state[(0)] = null);

(cr50872_state[(4)] = null);

(cr50872_state[(5)] = null);

(cr50872_state[(1)] = null);

(cr50872_state[(6)] = null);

(cr50872_state[(2)] = null);

return null;
}catch (e51267){var cr50872_exception = e51267;
(cr50872_state[(0)] = cr50872_block_5);

(cr50872_state[(6)] = true);

(cr50872_state[(5)] = cr50872_exception);

return cr50872_state;
}});
var cr50872_block_19 = (function hyperfiddle$electric_client$boot_with_retry_$_cr50872_block_19(cr50872_state){
try{var cr50872_place_137 = null;
(cr50872_state[(0)] = cr50872_block_20);

(cr50872_state[(1)] = cr50872_place_137);

return cr50872_state;
}catch (e51268){var cr50872_exception = e51268;
(cr50872_state[(0)] = null);

(cr50872_state[(1)] = null);

throw cr50872_exception;
}});
var cr50872_block_15 = (function hyperfiddle$electric_client$boot_with_retry_$_cr50872_block_15(cr50872_state){
try{var cr50872_place_107 = null;
(cr50872_state[(0)] = cr50872_block_16);

(cr50872_state[(3)] = cr50872_place_107);

return cr50872_state;
}catch (e51269){var cr50872_exception = e51269;
(cr50872_state[(0)] = null);

(cr50872_state[(1)] = null);

(cr50872_state[(3)] = null);

(cr50872_state[(2)] = null);

throw cr50872_exception;
}});
var cr50872_block_8 = (function hyperfiddle$electric_client$boot_with_retry_$_cr50872_block_8(cr50872_state){
try{var cr50872_place_73 = console;
var cr50872_place_74 = "Connection lost.";
var cr50872_place_75 = cr50872_place_73.log(cr50872_place_74);
var cr50872_place_76 = cljs.core.seq;
var cr50872_place_77 = hyperfiddle.electric_client.retry_delays;
var cr50872_place_78 = (function (){var G__51272 = cr50872_place_77;
var fexpr__51271 = cr50872_place_76;
return (fexpr__51271.cljs$core$IFn$_invoke$arity$1 ? fexpr__51271.cljs$core$IFn$_invoke$arity$1(G__51272) : fexpr__51271.call(null,G__51272));
})();
(cr50872_state[(0)] = cr50872_block_12);

(cr50872_state[(4)] = cr50872_place_78);

return cr50872_state;
}catch (e51270){var cr50872_exception = e51270;
(cr50872_state[(0)] = null);

(cr50872_state[(4)] = null);

(cr50872_state[(5)] = null);

(cr50872_state[(1)] = null);

(cr50872_state[(3)] = null);

(cr50872_state[(2)] = null);

throw cr50872_exception;
}});
var cr50872_block_9 = (function hyperfiddle$electric_client$boot_with_retry_$_cr50872_block_9(cr50872_state){
try{var cr50872_place_79 = cljs.core.ex_info;
var cr50872_place_80 = "Stale client";
var cr50872_place_81 = new cljs.core.Keyword("hyperfiddle.electric","type","hyperfiddle.electric/type",1565804079);
var cr50872_place_82 = new cljs.core.Keyword("hyperfiddle.electric-client","stale-client","hyperfiddle.electric-client/stale-client",-343425405);
var cr50872_place_83 = cljs.core.with_meta(cljs.core.PersistentArrayMap.createAsIfByAssoc([cr50872_place_81,cr50872_place_82]),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),cljs.core.IMap], null));
var cr50872_place_84 = (function (){var G__51275 = cr50872_place_80;
var G__51276 = cr50872_place_83;
var fexpr__51274 = cr50872_place_79;
return (fexpr__51274.cljs$core$IFn$_invoke$arity$2 ? fexpr__51274.cljs$core$IFn$_invoke$arity$2(G__51275,G__51276) : fexpr__51274.call(null,G__51275,G__51276));
})();
var cr50872_place_85 = (function(){throw cr50872_place_84})();
(cr50872_state[(0)] = null);

return null;
}catch (e51273){var cr50872_exception = e51273;
(cr50872_state[(0)] = null);

throw cr50872_exception;
}});
var cr50872_block_13 = (function hyperfiddle$electric_client$boot_with_retry_$_cr50872_block_13(cr50872_state){
try{var cr50872_place_1 = (cr50872_state[(1)]);
var cr50872_place_103 = console;
var cr50872_place_104 = "Failed to connect.";
var cr50872_place_105 = cr50872_place_103.log(cr50872_place_104);
var cr50872_place_106 = cr50872_place_1;
(cr50872_state[(0)] = cr50872_block_14);

(cr50872_state[(5)] = cr50872_place_106);

return cr50872_state;
}catch (e51277){var cr50872_exception = e51277;
(cr50872_state[(0)] = null);

(cr50872_state[(5)] = null);

(cr50872_state[(1)] = null);

(cr50872_state[(3)] = null);

(cr50872_state[(2)] = null);

throw cr50872_exception;
}});
var cr50872_block_7 = (function hyperfiddle$electric_client$boot_with_retry_$_cr50872_block_7(cr50872_state){
try{var cr50872_place_64 = (cr50872_state[(4)]);
var cr50872_place_69 = cr50872_place_64;
var cr50872_place_70 = cr50872_place_69;
var cr50872_place_71 = cr50872_place_70;
var cr50872_place_72 = null;
var G__51279 = cr50872_place_71;
switch (G__51279) {
case (1005):
case (1006):
(cr50872_state[(0)] = cr50872_block_8);

(cr50872_state[(4)] = null);

(cr50872_state[(6)] = null);

(cr50872_state[(4)] = cr50872_place_72);

return cr50872_state;

break;
case (1008):
(cr50872_state[(0)] = cr50872_block_9);

(cr50872_state[(4)] = null);

(cr50872_state[(5)] = null);

(cr50872_state[(1)] = null);

(cr50872_state[(3)] = null);

(cr50872_state[(2)] = null);

(cr50872_state[(6)] = null);

return cr50872_state;

break;
case (1013):
(cr50872_state[(0)] = cr50872_block_10);

(cr50872_state[(4)] = null);

(cr50872_state[(6)] = null);

(cr50872_state[(4)] = cr50872_place_72);

return cr50872_state;

break;
default:
(cr50872_state[(0)] = cr50872_block_11);

(cr50872_state[(4)] = null);

(cr50872_state[(5)] = null);

(cr50872_state[(1)] = null);

(cr50872_state[(3)] = null);

(cr50872_state[(2)] = null);

(cr50872_state[(1)] = cr50872_place_69);

return cr50872_state;

}
}catch (e51278){var cr50872_exception = e51278;
(cr50872_state[(0)] = null);

(cr50872_state[(4)] = null);

(cr50872_state[(5)] = null);

(cr50872_state[(1)] = null);

(cr50872_state[(3)] = null);

(cr50872_state[(2)] = null);

(cr50872_state[(6)] = null);

throw cr50872_exception;
}});
var cr50872_block_6 = (function hyperfiddle$electric_client$boot_with_retry_$_cr50872_block_6(cr50872_state){
try{var cr50872_place_56 = (cr50872_state[(4)]);
var cr50872_place_61 = cr50872_place_56;
var cr50872_place_62 = new cljs.core.Keyword(null,"code","code",1586293142);
var cr50872_place_63 = cr50872_place_61;
var cr50872_place_64 = cr50872_place_62.cljs$core$IFn$_invoke$arity$1(cr50872_place_63);
var cr50872_place_65 = cr50872_place_64;
var cr50872_place_66 = null;
var cr50872_place_67 = (cr50872_place_65 == cr50872_place_66);
var cr50872_place_68 = null;
if(cr50872_place_67){
(cr50872_state[(0)] = cr50872_block_13);

(cr50872_state[(4)] = null);

(cr50872_state[(5)] = cr50872_place_68);

return cr50872_state;
} else {
(cr50872_state[(0)] = cr50872_block_7);

(cr50872_state[(4)] = null);

(cr50872_state[(6)] = cr50872_place_61);

(cr50872_state[(4)] = cr50872_place_64);

(cr50872_state[(5)] = cr50872_place_68);

return cr50872_state;
}
}catch (e51280){var cr50872_exception = e51280;
(cr50872_state[(0)] = null);

(cr50872_state[(1)] = null);

(cr50872_state[(3)] = null);

(cr50872_state[(2)] = null);

(cr50872_state[(4)] = null);

throw cr50872_exception;
}});
var cr50872_block_0 = (function hyperfiddle$electric_client$boot_with_retry_$_cr50872_block_0(cr50872_state){
try{var cr50872_place_0 = hyperfiddle.electric_client._STAR_ws_server_url_STAR_;
var cr50872_place_1 = hyperfiddle.electric_client.retry_delays;
(cr50872_state[(0)] = cr50872_block_1);

(cr50872_state[(2)] = cr50872_place_0);

(cr50872_state[(1)] = cr50872_place_1);

return cr50872_state;
}catch (e51281){var cr50872_exception = e51281;
(cr50872_state[(0)] = null);

throw cr50872_exception;
}});
var cr50872_block_18 = (function hyperfiddle$electric_client$boot_with_retry_$_cr50872_block_18(cr50872_state){
try{var cr50872_place_136 = missionary.core.unpark();
(cr50872_state[(0)] = cr50872_block_1);

(cr50872_state[(1)] = cr50872_place_136);

return cr50872_state;
}catch (e51282){var cr50872_exception = e51282;
(cr50872_state[(0)] = null);

(cr50872_state[(1)] = null);

(cr50872_state[(2)] = null);

throw cr50872_exception;
}});
var cr50872_block_1 = (function hyperfiddle$electric_client$boot_with_retry_$_cr50872_block_1(cr50872_state){
try{var cr50872_place_0 = (cr50872_state[(2)]);
var cr50872_place_2 = cljs.core.object_array;
var cr50872_place_3 = (1);
var cr50872_place_4 = (function (){var G__51285 = cr50872_place_3;
var fexpr__51284 = cr50872_place_2;
return (fexpr__51284.cljs$core$IFn$_invoke$arity$1 ? fexpr__51284.cljs$core$IFn$_invoke$arity$1(G__51285) : fexpr__51284.call(null,G__51285));
})();
var cr50872_place_5 = console;
var cr50872_place_6 = "Connecting...";
var cr50872_place_7 = cr50872_place_5.log(cr50872_place_6);
var cr50872_place_8 = hyperfiddle.electric_client._STAR_ws_server_url_STAR_;
var cr50872_place_9 = cr50872_place_0;
var cr50872_place_10 = cr50872_place_9;
var cr50872_place_11 = (hyperfiddle.electric_client._STAR_ws_server_url_STAR_ = cr50872_place_10);
var cr50872_place_12 = null;
var cr50872_place_13 = false;
(cr50872_state[(0)] = cr50872_block_2);

(cr50872_state[(3)] = cr50872_place_4);

(cr50872_state[(4)] = cr50872_place_8);

(cr50872_state[(5)] = cr50872_place_12);

(cr50872_state[(6)] = cr50872_place_13);

return cr50872_state;
}catch (e51283){var cr50872_exception = e51283;
(cr50872_state[(0)] = null);

(cr50872_state[(1)] = null);

(cr50872_state[(2)] = null);

throw cr50872_exception;
}});
var cr50872_block_17 = (function hyperfiddle$electric_client$boot_with_retry_$_cr50872_block_17(cr50872_state){
try{var cr50872_place_60 = (cr50872_state[(3)]);
var cr50872_place_112 = cr50872_place_60;
var cr50872_place_113 = cljs.core.seq;
var cr50872_place_114 = cr50872_place_112;
var cr50872_place_115 = (function (){var G__51288 = cr50872_place_114;
var fexpr__51287 = cr50872_place_113;
return (fexpr__51287.cljs$core$IFn$_invoke$arity$1 ? fexpr__51287.cljs$core$IFn$_invoke$arity$1(G__51288) : fexpr__51287.call(null,G__51288));
})();
var cr50872_place_116 = cljs.core.first;
var cr50872_place_117 = cr50872_place_115;
var cr50872_place_118 = (function (){var G__51290 = cr50872_place_117;
var fexpr__51289 = cr50872_place_116;
return (fexpr__51289.cljs$core$IFn$_invoke$arity$1 ? fexpr__51289.cljs$core$IFn$_invoke$arity$1(G__51290) : fexpr__51289.call(null,G__51290));
})();
var cr50872_place_119 = cljs.core.next;
var cr50872_place_120 = cr50872_place_115;
var cr50872_place_121 = (function (){var G__51292 = cr50872_place_120;
var fexpr__51291 = cr50872_place_119;
return (fexpr__51291.cljs$core$IFn$_invoke$arity$1 ? fexpr__51291.cljs$core$IFn$_invoke$arity$1(G__51292) : fexpr__51291.call(null,G__51292));
})();
var cr50872_place_122 = cr50872_place_118;
var cr50872_place_123 = cr50872_place_121;
var cr50872_place_124 = console;
var cr50872_place_125 = "Next attempt in ";
var cr50872_place_126 = cr50872_place_122;
var cr50872_place_127 = (1000);
var cr50872_place_128 = (cr50872_place_126 / cr50872_place_127);
var cr50872_place_129 = " seconds.";
var cr50872_place_130 = [cr50872_place_125,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cr50872_place_128),cr50872_place_129].join('');
var cr50872_place_131 = cr50872_place_124.log(cr50872_place_130);
var cr50872_place_132 = missionary.core.sleep;
var cr50872_place_133 = cr50872_place_122;
var cr50872_place_134 = cr50872_place_123;
var cr50872_place_135 = (function (){var G__51294 = cr50872_place_133;
var G__51295 = cr50872_place_134;
var fexpr__51293 = cr50872_place_132;
return (fexpr__51293.cljs$core$IFn$_invoke$arity$2 ? fexpr__51293.cljs$core$IFn$_invoke$arity$2(G__51294,G__51295) : fexpr__51293.call(null,G__51294,G__51295));
})();
(cr50872_state[(0)] = cr50872_block_18);

(cr50872_state[(3)] = null);

return missionary.core.park(cr50872_place_135);
}catch (e51286){var cr50872_exception = e51286;
(cr50872_state[(0)] = null);

(cr50872_state[(1)] = null);

(cr50872_state[(3)] = null);

(cr50872_state[(2)] = null);

throw cr50872_exception;
}});
var cr50872_block_12 = (function hyperfiddle$electric_client$boot_with_retry_$_cr50872_block_12(cr50872_state){
try{var cr50872_place_72 = (cr50872_state[(4)]);
(cr50872_state[(0)] = cr50872_block_14);

(cr50872_state[(4)] = null);

(cr50872_state[(5)] = cr50872_place_72);

return cr50872_state;
}catch (e51296){var cr50872_exception = e51296;
(cr50872_state[(0)] = null);

(cr50872_state[(4)] = null);

(cr50872_state[(5)] = null);

(cr50872_state[(1)] = null);

(cr50872_state[(3)] = null);

(cr50872_state[(2)] = null);

throw cr50872_exception;
}});
var cr50872_block_16 = (function hyperfiddle$electric_client$boot_with_retry_$_cr50872_block_16(cr50872_state){
try{var cr50872_place_60 = (cr50872_state[(3)]);
var cr50872_place_108 = cr50872_place_60;
var cr50872_place_109 = null;
var cr50872_place_110 = (cr50872_place_108 == cr50872_place_109);
var cr50872_place_111 = null;
if(cr50872_place_110){
(cr50872_state[(0)] = cr50872_block_19);

(cr50872_state[(1)] = null);

(cr50872_state[(3)] = null);

(cr50872_state[(2)] = null);

(cr50872_state[(1)] = cr50872_place_111);

return cr50872_state;
} else {
(cr50872_state[(0)] = cr50872_block_17);

return cr50872_state;
}
}catch (e51297){var cr50872_exception = e51297;
(cr50872_state[(0)] = null);

(cr50872_state[(1)] = null);

(cr50872_state[(3)] = null);

(cr50872_state[(2)] = null);

throw cr50872_exception;
}});
var cr50872_block_14 = (function hyperfiddle$electric_client$boot_with_retry_$_cr50872_block_14(cr50872_state){
try{var cr50872_place_68 = (cr50872_state[(5)]);
(cr50872_state[(0)] = cr50872_block_16);

(cr50872_state[(5)] = null);

(cr50872_state[(3)] = cr50872_place_68);

return cr50872_state;
}catch (e51298){var cr50872_exception = e51298;
(cr50872_state[(0)] = null);

(cr50872_state[(5)] = null);

(cr50872_state[(1)] = null);

(cr50872_state[(3)] = null);

(cr50872_state[(2)] = null);

throw cr50872_exception;
}});
var cr50872_block_20 = (function hyperfiddle$electric_client$boot_with_retry_$_cr50872_block_20(cr50872_state){
try{var cr50872_place_111 = (cr50872_state[(1)]);
(cr50872_state[(0)] = null);

(cr50872_state[(1)] = null);

return cr50872_place_111;
}catch (e51299){var cr50872_exception = e51299;
(cr50872_state[(0)] = null);

(cr50872_state[(1)] = null);

throw cr50872_exception;
}});
var cr50872_block_5 = (function hyperfiddle$electric_client$boot_with_retry_$_cr50872_block_5(cr50872_state){
try{var cr50872_place_8 = (cr50872_state[(4)]);
var cr50872_place_12 = (cr50872_state[(5)]);
var cr50872_place_13 = (cr50872_state[(6)]);
var cr50872_place_54 = cr50872_place_8;
var cr50872_place_55 = (hyperfiddle.electric_client._STAR_ws_server_url_STAR_ = cr50872_place_54);
var cr50872_place_56 = (cljs.core.truth_(cr50872_place_13)?(function(){throw cr50872_place_12})():cr50872_place_12);
var cr50872_place_57 = cr50872_place_56;
var cr50872_place_58 = null;
var cr50872_place_59 = (cr50872_place_57 == cr50872_place_58);
var cr50872_place_60 = null;
if(cr50872_place_59){
(cr50872_state[(0)] = cr50872_block_15);

(cr50872_state[(4)] = null);

(cr50872_state[(5)] = null);

(cr50872_state[(6)] = null);

(cr50872_state[(3)] = cr50872_place_60);

return cr50872_state;
} else {
(cr50872_state[(0)] = cr50872_block_6);

(cr50872_state[(4)] = null);

(cr50872_state[(5)] = null);

(cr50872_state[(6)] = null);

(cr50872_state[(4)] = cr50872_place_56);

(cr50872_state[(3)] = cr50872_place_60);

return cr50872_state;
}
}catch (e51300){var cr50872_exception = e51300;
(cr50872_state[(0)] = null);

(cr50872_state[(4)] = null);

(cr50872_state[(5)] = null);

(cr50872_state[(1)] = null);

(cr50872_state[(6)] = null);

(cr50872_state[(2)] = null);

throw cr50872_exception;
}});
return cloroutine.impl.coroutine((function (){var G__51301 = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((7));
(G__51301[(0)] = cr50872_block_0);

return G__51301;
})());
})(),missionary.core.sp_run);
});
hyperfiddle.electric_client.reload_when_stale = (function hyperfiddle$electric_client$reload_when_stale(task){
return (function (s,f){
var G__51302 = s;
var G__51303 = (function (error){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("hyperfiddle.electric-client","stale-client","hyperfiddle.electric-client/stale-client",-343425405),new cljs.core.Keyword("hyperfiddle.electric","type","hyperfiddle.electric/type",1565804079).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data(error)))){
console.log("Server and client version mismatch. Refreshing page.");

window.location.reload();
} else {
}

return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(error) : f.call(null,error));
});
return (task.cljs$core$IFn$_invoke$arity$2 ? task.cljs$core$IFn$_invoke$arity$2(G__51302,G__51303) : task.call(null,G__51302,G__51303));
});
});

//# sourceMappingURL=hyperfiddle.electric_client.js.map
