goog.provide('hyperfiddle.electric.impl.io');
(com.cognitect.transit.types.UUID.prototype.cljs$core$IUUID$ = cljs.core.PROTOCOL_SENTINEL);
hyperfiddle.electric.impl.io.default_write_handler = cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3((function (x){
hyperfiddle.electric.impl.io._last_unserializable_for_repl = x;

console.log("Unserializable reference transfer:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));

return "_";
}),(function (x){
return null;
}),(function (_){
return "";
}));
/**
 * Builds a minimal, cljc map/bounded-queue cache.
 *   One slot per key (map).
 *   Reaching `size` pops oldest value (bounded-queue).
 */
hyperfiddle.electric.impl.io.__GT_cache = (function hyperfiddle$electric$impl$io$__GT_cache(size){
var G__50505 = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(((size * (2)) + (1)));
var arr50506_50734 = G__50505;
(arr50506_50734[(size * (2))] = cljs.core.identity((0)));

return G__50505;
});
hyperfiddle.electric.impl.io.cache_add = (function hyperfiddle$electric$impl$io$cache_add(cache,k,v){
if(cljs.core.truth_((function (){var i = (0);
while(true){
if((i < (cljs.core.count(cache) - (1)))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,hyperfiddle.electric.impl.array_fields.get(cache,i))){
var arr50508_50735 = cache;
(arr50508_50735[(i + (1))] = cljs.core.identity(v));

return true;
} else {
var G__50736 = (i + (2));
i = G__50736;
continue;
}
} else {
return null;
}
break;
}
})())){
return null;
} else {
var widx = hyperfiddle.electric.impl.array_fields.getswap(cache,(cljs.core.count(cache) - (1)),(function (p1__50507_SHARP_){
return cljs.core.mod((p1__50507_SHARP_ + (2)),(cljs.core.count(cache) - (1)));
}));
var arr50509 = cache;
(arr50509[widx] = cljs.core.identity(k));

return (arr50509[(widx + (1))] = cljs.core.identity(v));
}
});
hyperfiddle.electric.impl.io.cache_get = (function hyperfiddle$electric$impl$io$cache_get(cache,k){
var i = (0);
while(true){
if((i < (cljs.core.count(cache) - (1)))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,hyperfiddle.electric.impl.array_fields.get(cache,i))){
return hyperfiddle.electric.impl.array_fields.get(cache,(i + (1)));
} else {
var G__50737 = (i + (2));
i = G__50737;
continue;
}
} else {
return null;
}
break;
}
});
hyperfiddle.electric.impl.io.cache__GT_map = (function hyperfiddle$electric$impl$io$cache__GT_map(cache){
var i = (0);
var ac = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < (cljs.core.count(cache) - (1)))){
var G__50738 = (i + (2));
var G__50739 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(ac,hyperfiddle.electric.impl.array_fields.get(cache,i),hyperfiddle.electric.impl.array_fields.get(cache,(i + (1))));
i = G__50738;
ac = G__50739;
continue;
} else {
return cljs.core.persistent_BANG_(ac);
}
break;
}
});
hyperfiddle.electric.impl.io._BANG_ex_cache = hyperfiddle.electric.impl.io.__GT_cache((16));
hyperfiddle.electric.impl.io.save_original_ex_BANG_ = (function hyperfiddle$electric$impl$io$save_original_ex_BANG_(fi){
var id = hyperfiddle.electric.debug.ex_id(fi);
var temp__5827__auto___50740 = cljs.core.ex_cause(fi);
if((temp__5827__auto___50740 == null)){
} else {
var cause_50741 = temp__5827__auto___50740;
if((cause_50741 instanceof hyperfiddle.electric.FailureInfo)){
} else {
hyperfiddle.electric.impl.io.cache_add(hyperfiddle.electric.impl.io._BANG_ex_cache,id,cause_50741);
}
}

return id;
});
hyperfiddle.electric.impl.io.get_original_ex = (function hyperfiddle$electric$impl$io$get_original_ex(id){
return hyperfiddle.electric.impl.io.cache_get(hyperfiddle.electric.impl.io._BANG_ex_cache,id);
});
hyperfiddle.electric.impl.io._STAR_write_handlers_STAR_ = null;
hyperfiddle.electric.impl.io.failure_writer = cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2((function (_){
return "failure";
}),(function (x){
var err = x.error;
if((err instanceof missionary.Cancelled)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"cancelled","cancelled",488726224)], null);
} else {
if((err instanceof hyperfiddle.electric.Pending)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pending","pending",-220036727)], null);
} else {
if((err instanceof hyperfiddle.electric.Remote)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"remote","remote",-1593576576),hyperfiddle.electric.debug.serializable(cljs.core.ex_data(err))], null);
} else {
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"exception","exception",-335277064),cljs.core.ex_message(err),hyperfiddle.electric.debug.serializable(cljs.core.ex_data(err)),hyperfiddle.electric.impl.io.save_original_ex_BANG_(err)], null);

}
}
}
}));
hyperfiddle.electric.impl.io.write_opts = (function hyperfiddle$electric$impl$io$write_opts(){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"handlers","handlers",79528781),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([hyperfiddle.electric.impl.io._STAR_write_handlers_STAR_,cljs.core.PersistentArrayMap.createAsIfByAssoc([hyperfiddle.electric.Failure,hyperfiddle.electric.impl.io.failure_writer,new cljs.core.Keyword(null,"default","default",-1987822328),hyperfiddle.electric.impl.io.default_write_handler])], 0)),new cljs.core.Keyword(null,"default-handler","default-handler",-1028159207),hyperfiddle.electric.impl.io.default_write_handler], null);
});
hyperfiddle.electric.impl.io._STAR_read_handlers_STAR_ = null;
hyperfiddle.electric.impl.io.failure_reader = cognitect.transit.read_handler((function (p__50510){
var vec__50511 = p__50510;
var seq__50512 = cljs.core.seq(vec__50511);
var first__50513 = cljs.core.first(seq__50512);
var seq__50512__$1 = cljs.core.next(seq__50512);
var tag = first__50513;
var args = seq__50512__$1;
var G__50514 = tag;
var G__50514__$1 = (((G__50514 instanceof cljs.core.Keyword))?G__50514.fqn:null);
switch (G__50514__$1) {
case "exception":
var vec__50515 = args;
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50515,(0),null);
var data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50515,(1),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50515,(2),null);
return (new hyperfiddle.electric.Failure(hyperfiddle.electric.debug.ex_info_STAR_.cljs$core$IFn$_invoke$arity$4(message,data,id,null)));

break;
case "remote":
var vec__50518 = args;
var data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50518,(0),null);
return (new hyperfiddle.electric.Failure(hyperfiddle.electric.debug.ex_info_STAR_.cljs$core$IFn$_invoke$arity$2("Remote error",(function (){var or__5002__auto__ = data;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})())));

break;
case "pending":
return (new hyperfiddle.electric.Failure((new hyperfiddle.electric.Pending())));

break;
case "cancelled":
return (new hyperfiddle.electric.Failure((new missionary.Cancelled())));

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__50514__$1)].join('')));

}
}));
hyperfiddle.electric.impl.io.read_opts = (function hyperfiddle$electric$impl$io$read_opts(){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"handlers","handlers",79528781),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([hyperfiddle.electric.impl.io._STAR_read_handlers_STAR_,new cljs.core.PersistentArrayMap(null, 1, ["failure",hyperfiddle.electric.impl.io.failure_reader], null)], 0))], null);
});
hyperfiddle.electric.impl.io.set_ints = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.reduce_kv,(function (r,i,n){
var offset = (i << (2));
var G__50521 = r;
G__50521.setInt32(offset,n);

return G__50521;
}));
/**
 * Encode a control frame to a binary segment.
 */
hyperfiddle.electric.impl.io.encode_numbers = (function hyperfiddle$electric$impl$io$encode_numbers(xs){
var required = (cljs.core.count(xs) << (2));
var G__50522 = (new ArrayBuffer(required));
hyperfiddle.electric.impl.io.set_ints((new DataView(G__50522)),xs);

return G__50522;
});

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
hyperfiddle.electric.impl.io.t_hyperfiddle$electric$impl$io50523 = (function (b,meta50524){
this.b = b;
this.meta50524 = meta50524;
this.cljs$lang$protocol_mask$partition0$ = 917504;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(hyperfiddle.electric.impl.io.t_hyperfiddle$electric$impl$io50523.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_50525,meta50524__$1){
var self__ = this;
var _50525__$1 = this;
return (new hyperfiddle.electric.impl.io.t_hyperfiddle$electric$impl$io50523(self__.b,meta50524__$1));
}));

(hyperfiddle.electric.impl.io.t_hyperfiddle$electric$impl$io50523.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_50525){
var self__ = this;
var _50525__$1 = this;
return self__.meta50524;
}));

(hyperfiddle.electric.impl.io.t_hyperfiddle$electric$impl$io50523.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (_,rf,r){
var self__ = this;
var ___$1 = this;
var l = self__.b.byteLength;
var v = (new DataView(self__.b));
var r__$1 = r;
var i = (0);
while(true){
if((i < l)){
var G__50743 = (function (){var G__50526 = r__$1;
var G__50527 = v.getInt32(i);
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__50526,G__50527) : rf.call(null,G__50526,G__50527));
})();
var G__50744 = (i + (4));
r__$1 = G__50743;
i = G__50744;
continue;
} else {
return r__$1;
}
break;
}
}));

(hyperfiddle.electric.impl.io.t_hyperfiddle$electric$impl$io50523.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"b","b",-1172211299,null),new cljs.core.Symbol(null,"meta50524","meta50524",-1365476221,null)], null);
}));

(hyperfiddle.electric.impl.io.t_hyperfiddle$electric$impl$io50523.cljs$lang$type = true);

(hyperfiddle.electric.impl.io.t_hyperfiddle$electric$impl$io50523.cljs$lang$ctorStr = "hyperfiddle.electric.impl.io/t_hyperfiddle$electric$impl$io50523");

(hyperfiddle.electric.impl.io.t_hyperfiddle$electric$impl$io50523.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"hyperfiddle.electric.impl.io/t_hyperfiddle$electric$impl$io50523");
}));

/**
 * Positional factory function for hyperfiddle.electric.impl.io/t_hyperfiddle$electric$impl$io50523.
 */
hyperfiddle.electric.impl.io.__GT_t_hyperfiddle$electric$impl$io50523 = (function hyperfiddle$electric$impl$io$__GT_t_hyperfiddle$electric$impl$io50523(b,meta50524){
return (new hyperfiddle.electric.impl.io.t_hyperfiddle$electric$impl$io50523(b,meta50524));
});


/**
 * Decode a control frame from a binary segment.
 */
hyperfiddle.electric.impl.io.decode_numbers = (function hyperfiddle$electric$impl$io$decode_numbers(b){
return cljs.core.vec((new hyperfiddle.electric.impl.io.t_hyperfiddle$electric$impl$io50523(b,cljs.core.PersistentArrayMap.EMPTY)));
});
var _BANG_cache_50745 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),hyperfiddle.electric.impl.io._STAR_write_handlers_STAR_,new cljs.core.Keyword(null,"writer","writer",-277568236),null], null));
hyperfiddle.electric.impl.io.transit_writer = (function hyperfiddle$electric$impl$io$transit_writer(){
return new cljs.core.Keyword(null,"writer","writer",-277568236).cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(_BANG_cache_50745,(function (p__50528){
var map__50529 = p__50528;
var map__50529__$1 = cljs.core.__destructure_map(map__50529);
var cache = map__50529__$1;
var write_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50529__$1,new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911));
var writer = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50529__$1,new cljs.core.Keyword(null,"writer","writer",-277568236));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(write_handlers,hyperfiddle.electric.impl.io._STAR_write_handlers_STAR_)){
if(cljs.core.truth_(writer)){
return cache;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cache,new cljs.core.Keyword(null,"writer","writer",-277568236),cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"json","json",1279968570),hyperfiddle.electric.impl.io.write_opts()));
}
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),hyperfiddle.electric.impl.io._STAR_write_handlers_STAR_,new cljs.core.Keyword(null,"writer","writer",-277568236),cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"json","json",1279968570),hyperfiddle.electric.impl.io.write_opts())], null);
}
})));
});
/**
 * Encode a data frame to transit json
 */
hyperfiddle.electric.impl.io.encode = (function hyperfiddle$electric$impl$io$encode(x){
return cognitect.transit.write(hyperfiddle.electric.impl.io.transit_writer(),x);
});
var _BANG_cache_50746 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),hyperfiddle.electric.impl.io._STAR_read_handlers_STAR_,new cljs.core.Keyword(null,"reader","reader",169660853),null], null));
hyperfiddle.electric.impl.io.transit_reader = (function hyperfiddle$electric$impl$io$transit_reader(){
return new cljs.core.Keyword(null,"reader","reader",169660853).cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(_BANG_cache_50746,(function (p__50530){
var map__50531 = p__50530;
var map__50531__$1 = cljs.core.__destructure_map(map__50531);
var cache = map__50531__$1;
var read_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50531__$1,new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315));
var reader = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50531__$1,new cljs.core.Keyword(null,"reader","reader",169660853));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(read_handlers,hyperfiddle.electric.impl.io._STAR_read_handlers_STAR_)){
if(cljs.core.truth_(reader)){
return cache;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cache,new cljs.core.Keyword(null,"reader","reader",169660853),cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"json","json",1279968570),hyperfiddle.electric.impl.io.read_opts()));
}
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),hyperfiddle.electric.impl.io._STAR_read_handlers_STAR_,new cljs.core.Keyword(null,"reader","reader",169660853),cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"json","json",1279968570),hyperfiddle.electric.impl.io.read_opts())], null);
}
})));
});
/**
 * Decode a data frame from transit json
 */
hyperfiddle.electric.impl.io.decode = (function hyperfiddle$electric$impl$io$decode(s){
return cognitect.transit.read(hyperfiddle.electric.impl.io.transit_reader(),s);
});
hyperfiddle.electric.impl.io.decode_str = (function hyperfiddle$electric$impl$io$decode_str(x){
try{var G__50533 = hyperfiddle.electric.impl.io.decode(x);
console.debug("\uD83D\uDD3D",G__50533);

return G__50533;
}catch (e50532){var t = e50532;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3("Failed to decode",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),x], null),t);
}});
hyperfiddle.electric.impl.io.chunk_size = ((65536) >> (2));
hyperfiddle.electric.impl.io.message_reader = (function hyperfiddle$electric$impl$io$message_reader(_QMARK_read){

return cljs.core.partial.cljs$core$IFn$_invoke$arity$2((function (){var cr50534_block_4 = (function hyperfiddle$electric$impl$io$message_reader_$_cr50534_block_4(cr50534_state){
try{var cr50534_place_14 = (cr50534_state[(1)]);
var cr50534_place_11 = (cr50534_state[(6)]);
var cr50534_place_15 = hyperfiddle.electric.impl.io.decode_numbers;
var cr50534_place_16 = cr50534_place_11;
var cr50534_place_17 = (function (){var G__50572 = cr50534_place_16;
var fexpr__50571 = cr50534_place_15;
return (fexpr__50571.cljs$core$IFn$_invoke$arity$1 ? fexpr__50571.cljs$core$IFn$_invoke$arity$1(G__50572) : fexpr__50571.call(null,G__50572));
})();
var cr50534_place_18 = cljs.core.reduce;
var cr50534_place_19 = cljs.core.conj_BANG_;
var cr50534_place_20 = cr50534_place_14;
var cr50534_place_21 = cr50534_place_17;
var cr50534_place_22 = (function (){var G__50574 = cr50534_place_19;
var G__50575 = cr50534_place_20;
var G__50576 = cr50534_place_21;
var fexpr__50573 = cr50534_place_18;
return (fexpr__50573.cljs$core$IFn$_invoke$arity$3 ? fexpr__50573.cljs$core$IFn$_invoke$arity$3(G__50574,G__50575,G__50576) : fexpr__50573.call(null,G__50574,G__50575,G__50576));
})();
var cr50534_place_23 = cljs.core.count;
var cr50534_place_24 = cr50534_place_17;
var cr50534_place_25 = (function (){var G__50578 = cr50534_place_24;
var fexpr__50577 = cr50534_place_23;
return (fexpr__50577.cljs$core$IFn$_invoke$arity$1 ? fexpr__50577.cljs$core$IFn$_invoke$arity$1(G__50578) : fexpr__50577.call(null,G__50578));
})();
var cr50534_place_26 = hyperfiddle.electric.impl.io.chunk_size;
var cr50534_place_27 = (cr50534_place_25 < cr50534_place_26);
var cr50534_place_28 = null;
if(cr50534_place_27){
(cr50534_state[(0)] = cr50534_block_7);

(cr50534_state[(1)] = null);

(cr50534_state[(6)] = null);

(cr50534_state[(7)] = cr50534_place_22);

(cr50534_state[(1)] = cr50534_place_28);

return cr50534_state;
} else {
(cr50534_state[(0)] = cr50534_block_5);

(cr50534_state[(7)] = cr50534_place_22);

return cr50534_state;
}
}catch (e50570){var cr50534_exception = e50570;
(cr50534_state[(0)] = null);

(cr50534_state[(1)] = null);

(cr50534_state[(2)] = null);

(cr50534_state[(4)] = null);

(cr50534_state[(5)] = null);

(cr50534_state[(6)] = null);

(cr50534_state[(3)] = null);

throw cr50534_exception;
}});
var cr50534_block_0 = (function hyperfiddle$electric$impl$io$message_reader_$_cr50534_block_0(cr50534_state){
try{var cr50534_place_0 = cljs.core.transient$;
var cr50534_place_1 = cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),cljs.core.IVector], null));
var cr50534_place_2 = (function (){var G__50581 = cr50534_place_1;
var fexpr__50580 = cr50534_place_0;
return (fexpr__50580.cljs$core$IFn$_invoke$arity$1 ? fexpr__50580.cljs$core$IFn$_invoke$arity$1(G__50581) : fexpr__50580.call(null,G__50581));
})();
(cr50534_state[(0)] = cr50534_block_1);

(cr50534_state[(1)] = cr50534_place_2);

return cr50534_state;
}catch (e50579){var cr50534_exception = e50579;
(cr50534_state[(0)] = null);

throw cr50534_exception;
}});
var cr50534_block_7 = (function hyperfiddle$electric$impl$io$message_reader_$_cr50534_block_7(cr50534_state){
try{var cr50534_place_22 = (cr50534_state[(7)]);
var cr50534_place_32 = cljs.core.persistent_BANG_;
var cr50534_place_33 = cr50534_place_22;
var cr50534_place_34 = (function (){var G__50584 = cr50534_place_33;
var fexpr__50583 = cr50534_place_32;
return (fexpr__50583.cljs$core$IFn$_invoke$arity$1 ? fexpr__50583.cljs$core$IFn$_invoke$arity$1(G__50584) : fexpr__50583.call(null,G__50584));
})();
(cr50534_state[(0)] = cr50534_block_8);

(cr50534_state[(7)] = null);

(cr50534_state[(1)] = cr50534_place_34);

return cr50534_state;
}catch (e50582){var cr50534_exception = e50582;
(cr50534_state[(0)] = null);

(cr50534_state[(7)] = null);

(cr50534_state[(1)] = null);

(cr50534_state[(2)] = null);

(cr50534_state[(4)] = null);

(cr50534_state[(5)] = null);

(cr50534_state[(3)] = null);

throw cr50534_exception;
}});
var cr50534_block_3 = (function hyperfiddle$electric$impl$io$message_reader_$_cr50534_block_3(cr50534_state){
try{var cr50534_place_4 = (cr50534_state[(2)]);
var cr50534_place_2 = (cr50534_state[(1)]);
var cr50534_place_8 = cljs.core.persistent_BANG_;
var cr50534_place_9 = cljs.core.conj_BANG_;
var cr50534_place_10 = cr50534_place_2;
var cr50534_place_11 = cr50534_place_4;
var cr50534_place_12 = cljs.core.transient$;
var cr50534_place_13 = cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),cljs.core.IVector], null));
var cr50534_place_14 = (function (){var G__50587 = cr50534_place_13;
var fexpr__50586 = cr50534_place_12;
return (fexpr__50586.cljs$core$IFn$_invoke$arity$1 ? fexpr__50586.cljs$core$IFn$_invoke$arity$1(G__50587) : fexpr__50586.call(null,G__50587));
})();
(cr50534_state[(0)] = cr50534_block_4);

(cr50534_state[(2)] = null);

(cr50534_state[(1)] = null);

(cr50534_state[(4)] = cr50534_place_8);

(cr50534_state[(5)] = cr50534_place_9);

(cr50534_state[(2)] = cr50534_place_10);

(cr50534_state[(6)] = cr50534_place_11);

(cr50534_state[(1)] = cr50534_place_14);

return cr50534_state;
}catch (e50585){var cr50534_exception = e50585;
(cr50534_state[(0)] = null);

(cr50534_state[(2)] = null);

(cr50534_state[(1)] = null);

(cr50534_state[(3)] = null);

throw cr50534_exception;
}});
var cr50534_block_6 = (function hyperfiddle$electric$impl$io$message_reader_$_cr50534_block_6(cr50534_state){
try{var cr50534_place_22 = (cr50534_state[(7)]);
var cr50534_place_30 = missionary.core.unpark();
var cr50534_place_31 = cr50534_place_22;
(cr50534_state[(0)] = cr50534_block_4);

(cr50534_state[(7)] = null);

(cr50534_state[(6)] = cr50534_place_30);

(cr50534_state[(1)] = cr50534_place_31);

return cr50534_state;
}catch (e50588){var cr50534_exception = e50588;
(cr50534_state[(0)] = null);

(cr50534_state[(7)] = null);

(cr50534_state[(1)] = null);

(cr50534_state[(2)] = null);

(cr50534_state[(4)] = null);

(cr50534_state[(5)] = null);

(cr50534_state[(6)] = null);

(cr50534_state[(3)] = null);

throw cr50534_exception;
}});
var cr50534_block_8 = (function hyperfiddle$electric$impl$io$message_reader_$_cr50534_block_8(cr50534_state){
try{var cr50534_place_28 = (cr50534_state[(1)]);
var cr50534_place_10 = (cr50534_state[(2)]);
var cr50534_place_8 = (cr50534_state[(4)]);
var cr50534_place_9 = (cr50534_state[(5)]);
var cr50534_place_35 = (function (){var G__50591 = cr50534_place_10;
var G__50592 = cr50534_place_28;
var fexpr__50590 = cr50534_place_9;
return (fexpr__50590.cljs$core$IFn$_invoke$arity$2 ? fexpr__50590.cljs$core$IFn$_invoke$arity$2(G__50591,G__50592) : fexpr__50590.call(null,G__50591,G__50592));
})();
var cr50534_place_36 = (function (){var G__50594 = cr50534_place_35;
var fexpr__50593 = cr50534_place_8;
return (fexpr__50593.cljs$core$IFn$_invoke$arity$1 ? fexpr__50593.cljs$core$IFn$_invoke$arity$1(G__50594) : fexpr__50593.call(null,G__50594));
})();
(cr50534_state[(0)] = cr50534_block_10);

(cr50534_state[(1)] = null);

(cr50534_state[(2)] = null);

(cr50534_state[(4)] = null);

(cr50534_state[(5)] = null);

(cr50534_state[(3)] = cr50534_place_36);

return cr50534_state;
}catch (e50589){var cr50534_exception = e50589;
(cr50534_state[(0)] = null);

(cr50534_state[(1)] = null);

(cr50534_state[(2)] = null);

(cr50534_state[(4)] = null);

(cr50534_state[(5)] = null);

(cr50534_state[(3)] = null);

throw cr50534_exception;
}});
var cr50534_block_1 = (function hyperfiddle$electric$impl$io$message_reader_$_cr50534_block_1(cr50534_state){
try{var cr50534_place_3 = _QMARK_read;
(cr50534_state[(0)] = cr50534_block_2);

return missionary.core.park(cr50534_place_3);
}catch (e50595){var cr50534_exception = e50595;
(cr50534_state[(0)] = null);

(cr50534_state[(1)] = null);

throw cr50534_exception;
}});
var cr50534_block_5 = (function hyperfiddle$electric$impl$io$message_reader_$_cr50534_block_5(cr50534_state){
try{var cr50534_place_29 = _QMARK_read;
(cr50534_state[(0)] = cr50534_block_6);

return missionary.core.park(cr50534_place_29);
}catch (e50596){var cr50534_exception = e50596;
(cr50534_state[(0)] = null);

(cr50534_state[(7)] = null);

(cr50534_state[(1)] = null);

(cr50534_state[(2)] = null);

(cr50534_state[(4)] = null);

(cr50534_state[(5)] = null);

(cr50534_state[(6)] = null);

(cr50534_state[(3)] = null);

throw cr50534_exception;
}});
var cr50534_block_10 = (function hyperfiddle$electric$impl$io$message_reader_$_cr50534_block_10(cr50534_state){
try{var cr50534_place_7 = (cr50534_state[(3)]);
(cr50534_state[(0)] = null);

(cr50534_state[(3)] = null);

return cr50534_place_7;
}catch (e50597){var cr50534_exception = e50597;
(cr50534_state[(0)] = null);

(cr50534_state[(3)] = null);

throw cr50534_exception;
}});
var cr50534_block_9 = (function hyperfiddle$electric$impl$io$message_reader_$_cr50534_block_9(cr50534_state){
try{var cr50534_place_4 = (cr50534_state[(2)]);
var cr50534_place_2 = (cr50534_state[(1)]);
var cr50534_place_37 = cljs.core.conj_BANG_;
var cr50534_place_38 = cr50534_place_2;
var cr50534_place_39 = hyperfiddle.electric.impl.io.decode_str;
var cr50534_place_40 = cr50534_place_4;
var cr50534_place_41 = (function (){var G__50600 = cr50534_place_40;
var fexpr__50599 = cr50534_place_39;
return (fexpr__50599.cljs$core$IFn$_invoke$arity$1 ? fexpr__50599.cljs$core$IFn$_invoke$arity$1(G__50600) : fexpr__50599.call(null,G__50600));
})();
var cr50534_place_42 = (function (){var G__50602 = cr50534_place_38;
var G__50603 = cr50534_place_41;
var fexpr__50601 = cr50534_place_37;
return (fexpr__50601.cljs$core$IFn$_invoke$arity$2 ? fexpr__50601.cljs$core$IFn$_invoke$arity$2(G__50602,G__50603) : fexpr__50601.call(null,G__50602,G__50603));
})();
(cr50534_state[(0)] = cr50534_block_1);

(cr50534_state[(2)] = null);

(cr50534_state[(1)] = cr50534_place_42);

return cr50534_state;
}catch (e50598){var cr50534_exception = e50598;
(cr50534_state[(0)] = null);

(cr50534_state[(2)] = null);

(cr50534_state[(1)] = null);

throw cr50534_exception;
}});
var cr50534_block_2 = (function hyperfiddle$electric$impl$io$message_reader_$_cr50534_block_2(cr50534_state){
try{var cr50534_place_4 = missionary.core.unpark();
var cr50534_place_5 = cr50534_place_4;
var cr50534_place_6 = typeof cr50534_place_5 === 'string';
var cr50534_place_7 = null;
if(cr50534_place_6){
(cr50534_state[(0)] = cr50534_block_9);

(cr50534_state[(2)] = cr50534_place_4);

return cr50534_state;
} else {
(cr50534_state[(0)] = cr50534_block_3);

(cr50534_state[(2)] = cr50534_place_4);

(cr50534_state[(3)] = cr50534_place_7);

return cr50534_state;
}
}catch (e50604){var cr50534_exception = e50604;
(cr50534_state[(0)] = null);

(cr50534_state[(1)] = null);

throw cr50534_exception;
}});
return cloroutine.impl.coroutine((function (){var G__50605 = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((8));
(G__50605[(0)] = cr50534_block_0);

return G__50605;
})());
})(),missionary.core.sp_run);
});
/**
 * Returns a function taking an Electric message and returning a task writing it as individual frames using provided
 * function. Might cut a message into chunks if its size would exceed the server payload limit.
 * An empty message (0b) is written to notify the end of frame.
 */
hyperfiddle.electric.impl.io.message_writer = (function hyperfiddle$electric$impl$io$message_writer(write){
return (function (p1__50606_SHARP_){
return cljs.core.partial.cljs$core$IFn$_invoke$arity$2((function (){var cr50607_block_11 = (function hyperfiddle$electric$impl$io$message_writer_$_cr50607_block_11(cr50607_state){
try{var cr50607_place_48 = (cr50607_state[(2)]);
var cr50607_place_62 = hyperfiddle.electric.impl.io.encode_numbers;
var cr50607_place_63 = cljs.core.subvec;
var cr50607_place_64 = cr50607_place_48;
var cr50607_place_65 = (0);
var cr50607_place_66 = hyperfiddle.electric.impl.io.chunk_size;
var cr50607_place_67 = (function (){var G__50674 = cr50607_place_64;
var G__50675 = cr50607_place_65;
var G__50676 = cr50607_place_66;
var fexpr__50673 = cr50607_place_63;
return (fexpr__50673.cljs$core$IFn$_invoke$arity$3 ? fexpr__50673.cljs$core$IFn$_invoke$arity$3(G__50674,G__50675,G__50676) : fexpr__50673.call(null,G__50674,G__50675,G__50676));
})();
var cr50607_place_68 = (function (){var G__50678 = cr50607_place_67;
var fexpr__50677 = cr50607_place_62;
return (fexpr__50677.cljs$core$IFn$_invoke$arity$1 ? fexpr__50677.cljs$core$IFn$_invoke$arity$1(G__50678) : fexpr__50677.call(null,G__50678));
})();
var cr50607_place_69 = write;
var cr50607_place_70 = cr50607_place_68;
var cr50607_place_71 = (function (){var G__50680 = cr50607_place_70;
var fexpr__50679 = cr50607_place_69;
return (fexpr__50679.cljs$core$IFn$_invoke$arity$1 ? fexpr__50679.cljs$core$IFn$_invoke$arity$1(G__50680) : fexpr__50679.call(null,G__50680));
})();
(cr50607_state[(0)] = cr50607_block_12);

return missionary.core.park(cr50607_place_71);
}catch (e50672){var cr50607_exception = e50672;
(cr50607_state[(0)] = null);

(cr50607_state[(1)] = null);

(cr50607_state[(2)] = null);

throw cr50607_exception;
}});
var cr50607_block_1 = (function hyperfiddle$electric$impl$io$message_writer_$_cr50607_block_1(cr50607_state){
try{var cr50607_place_4 = (cr50607_state[(1)]);
var cr50607_place_5 = cr50607_place_4;
var cr50607_place_6 = cr50607_place_5;
var cr50607_place_7 = null;
var cr50607_place_8 = (cr50607_place_6 == cr50607_place_7);
var cr50607_place_9 = null;
if(cr50607_place_8){
(cr50607_state[(0)] = cr50607_block_7);

(cr50607_state[(1)] = null);

(cr50607_state[(1)] = cr50607_place_9);

return cr50607_state;
} else {
(cr50607_state[(0)] = cr50607_block_2);

(cr50607_state[(2)] = cr50607_place_5);

return cr50607_state;
}
}catch (e50681){var cr50607_exception = e50681;
(cr50607_state[(0)] = null);

(cr50607_state[(1)] = null);

throw cr50607_exception;
}});
var cr50607_block_14 = (function hyperfiddle$electric$impl$io$message_writer_$_cr50607_block_14(cr50607_state){
try{var cr50607_place_9 = (cr50607_state[(1)]);
(cr50607_state[(0)] = null);

(cr50607_state[(1)] = null);

return cr50607_place_9;
}catch (e50682){var cr50607_exception = e50682;
(cr50607_state[(0)] = null);

(cr50607_state[(1)] = null);

throw cr50607_exception;
}});
var cr50607_block_4 = (function hyperfiddle$electric$impl$io$message_writer_$_cr50607_block_4(cr50607_state){
try{var cr50607_place_20 = (cr50607_state[(2)]);
var cr50607_place_26 = (cr50607_state[(5)]);
var cr50607_place_31 = cr50607_place_26;
var cr50607_place_32 = cljs.core.ex_info;
var cr50607_place_33 = "Failed to encode";
var cr50607_place_34 = new cljs.core.Keyword(null,"value","value",305978217);
var cr50607_place_35 = cr50607_place_20;
var cr50607_place_36 = cljs.core.with_meta(cljs.core.PersistentArrayMap.createAsIfByAssoc([cr50607_place_34,cr50607_place_35]),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),cljs.core.IMap], null));
var cr50607_place_37 = cr50607_place_31;
var cr50607_place_38 = (function (){var G__50685 = cr50607_place_33;
var G__50686 = cr50607_place_36;
var G__50687 = cr50607_place_37;
var fexpr__50684 = cr50607_place_32;
return (fexpr__50684.cljs$core$IFn$_invoke$arity$3 ? fexpr__50684.cljs$core$IFn$_invoke$arity$3(G__50685,G__50686,G__50687) : fexpr__50684.call(null,G__50685,G__50686,G__50687));
})();
var cr50607_place_39 = (function(){throw cr50607_place_38})();
(cr50607_state[(0)] = null);

(cr50607_state[(1)] = null);

(cr50607_state[(2)] = null);

(cr50607_state[(3)] = null);

(cr50607_state[(4)] = null);

(cr50607_state[(5)] = null);

return null;
}catch (e50683){var cr50607_exception = e50683;
(cr50607_state[(0)] = cr50607_block_5);

(cr50607_state[(2)] = null);

(cr50607_state[(4)] = true);

(cr50607_state[(5)] = cr50607_exception);

return cr50607_state;
}});
var cr50607_block_2 = (function hyperfiddle$electric$impl$io$message_writer_$_cr50607_block_2(cr50607_state){
try{var cr50607_place_5 = (cr50607_state[(2)]);
var cr50607_place_10 = cr50607_place_5;
var cr50607_place_11 = cljs.core.seq;
var cr50607_place_12 = cr50607_place_10;
var cr50607_place_13 = (function (){var G__50690 = cr50607_place_12;
var fexpr__50689 = cr50607_place_11;
return (fexpr__50689.cljs$core$IFn$_invoke$arity$1 ? fexpr__50689.cljs$core$IFn$_invoke$arity$1(G__50690) : fexpr__50689.call(null,G__50690));
})();
var cr50607_place_14 = cljs.core.first;
var cr50607_place_15 = cr50607_place_13;
var cr50607_place_16 = (function (){var G__50692 = cr50607_place_15;
var fexpr__50691 = cr50607_place_14;
return (fexpr__50691.cljs$core$IFn$_invoke$arity$1 ? fexpr__50691.cljs$core$IFn$_invoke$arity$1(G__50692) : fexpr__50691.call(null,G__50692));
})();
var cr50607_place_17 = cljs.core.next;
var cr50607_place_18 = cr50607_place_13;
var cr50607_place_19 = (function (){var G__50694 = cr50607_place_18;
var fexpr__50693 = cr50607_place_17;
return (fexpr__50693.cljs$core$IFn$_invoke$arity$1 ? fexpr__50693.cljs$core$IFn$_invoke$arity$1(G__50694) : fexpr__50693.call(null,G__50694));
})();
var cr50607_place_20 = cr50607_place_16;
var cr50607_place_21 = cr50607_place_19;
var cr50607_place_22 = console.debug;
var cr50607_place_23 = "\uD83D\uDD3C";
var cr50607_place_24 = cr50607_place_20;
var cr50607_place_25 = (function (){var G__50696 = cr50607_place_23;
var G__50697 = cr50607_place_24;
var fexpr__50695 = cr50607_place_22;
return (fexpr__50695.cljs$core$IFn$_invoke$arity$2 ? fexpr__50695.cljs$core$IFn$_invoke$arity$2(G__50696,G__50697) : fexpr__50695.call(null,G__50696,G__50697));
})();
var cr50607_place_26 = null;
var cr50607_place_27 = false;
(cr50607_state[(0)] = cr50607_block_3);

(cr50607_state[(2)] = null);

(cr50607_state[(2)] = cr50607_place_20);

(cr50607_state[(3)] = cr50607_place_21);

(cr50607_state[(4)] = cr50607_place_27);

(cr50607_state[(5)] = cr50607_place_26);

return cr50607_state;
}catch (e50688){var cr50607_exception = e50688;
(cr50607_state[(0)] = null);

(cr50607_state[(1)] = null);

(cr50607_state[(2)] = null);

throw cr50607_exception;
}});
var cr50607_block_10 = (function hyperfiddle$electric$impl$io$message_writer_$_cr50607_block_10(cr50607_state){
try{var cr50607_place_61 = missionary.core.unpark();
(cr50607_state[(0)] = cr50607_block_13);

(cr50607_state[(3)] = cr50607_place_61);

return cr50607_state;
}catch (e50698){var cr50607_exception = e50698;
(cr50607_state[(0)] = null);

(cr50607_state[(1)] = null);

(cr50607_state[(3)] = null);

throw cr50607_exception;
}});
var cr50607_block_12 = (function hyperfiddle$electric$impl$io$message_writer_$_cr50607_block_12(cr50607_state){
try{var cr50607_place_48 = (cr50607_state[(2)]);
var cr50607_place_72 = missionary.core.unpark();
var cr50607_place_73 = cljs.core.subvec;
var cr50607_place_74 = cr50607_place_48;
var cr50607_place_75 = hyperfiddle.electric.impl.io.chunk_size;
var cr50607_place_76 = (function (){var G__50701 = cr50607_place_74;
var G__50702 = cr50607_place_75;
var fexpr__50700 = cr50607_place_73;
return (fexpr__50700.cljs$core$IFn$_invoke$arity$2 ? fexpr__50700.cljs$core$IFn$_invoke$arity$2(G__50701,G__50702) : fexpr__50700.call(null,G__50701,G__50702));
})();
(cr50607_state[(0)] = cr50607_block_8);

(cr50607_state[(2)] = cr50607_place_76);

return cr50607_state;
}catch (e50699){var cr50607_exception = e50699;
(cr50607_state[(0)] = null);

(cr50607_state[(1)] = null);

(cr50607_state[(2)] = null);

throw cr50607_exception;
}});
var cr50607_block_5 = (function hyperfiddle$electric$impl$io$message_writer_$_cr50607_block_5(cr50607_state){
try{var cr50607_place_27 = (cr50607_state[(4)]);
var cr50607_place_26 = (cr50607_state[(5)]);
var cr50607_place_40 = (cljs.core.truth_(cr50607_place_27)?(function(){throw cr50607_place_26})():cr50607_place_26);
var cr50607_place_41 = write;
var cr50607_place_42 = cr50607_place_40;
var cr50607_place_43 = (function (){var G__50705 = cr50607_place_42;
var fexpr__50704 = cr50607_place_41;
return (fexpr__50704.cljs$core$IFn$_invoke$arity$1 ? fexpr__50704.cljs$core$IFn$_invoke$arity$1(G__50705) : fexpr__50704.call(null,G__50705));
})();
(cr50607_state[(0)] = cr50607_block_6);

(cr50607_state[(4)] = null);

(cr50607_state[(5)] = null);

return missionary.core.park(cr50607_place_43);
}catch (e50703){var cr50607_exception = e50703;
(cr50607_state[(0)] = null);

(cr50607_state[(1)] = null);

(cr50607_state[(3)] = null);

(cr50607_state[(4)] = null);

(cr50607_state[(5)] = null);

throw cr50607_exception;
}});
var cr50607_block_0 = (function hyperfiddle$electric$impl$io$message_writer_$_cr50607_block_0(cr50607_state){
try{var cr50607_place_0 = cljs.core.seq;
var cr50607_place_1 = cljs.core.pop;
var cr50607_place_2 = p1__50606_SHARP_;
var cr50607_place_3 = (function (){var G__50708 = cr50607_place_2;
var fexpr__50707 = cr50607_place_1;
return (fexpr__50707.cljs$core$IFn$_invoke$arity$1 ? fexpr__50707.cljs$core$IFn$_invoke$arity$1(G__50708) : fexpr__50707.call(null,G__50708));
})();
var cr50607_place_4 = (function (){var G__50710 = cr50607_place_3;
var fexpr__50709 = cr50607_place_0;
return (fexpr__50709.cljs$core$IFn$_invoke$arity$1 ? fexpr__50709.cljs$core$IFn$_invoke$arity$1(G__50710) : fexpr__50709.call(null,G__50710));
})();
(cr50607_state[(0)] = cr50607_block_1);

(cr50607_state[(1)] = cr50607_place_4);

return cr50607_state;
}catch (e50706){var cr50607_exception = e50706;
(cr50607_state[(0)] = null);

throw cr50607_exception;
}});
var cr50607_block_6 = (function hyperfiddle$electric$impl$io$message_writer_$_cr50607_block_6(cr50607_state){
try{var cr50607_place_21 = (cr50607_state[(3)]);
var cr50607_place_44 = missionary.core.unpark();
var cr50607_place_45 = cr50607_place_21;
(cr50607_state[(0)] = cr50607_block_1);

(cr50607_state[(3)] = null);

(cr50607_state[(1)] = cr50607_place_45);

return cr50607_state;
}catch (e50711){var cr50607_exception = e50711;
(cr50607_state[(0)] = null);

(cr50607_state[(1)] = null);

(cr50607_state[(3)] = null);

throw cr50607_exception;
}});
var cr50607_block_8 = (function hyperfiddle$electric$impl$io$message_writer_$_cr50607_block_8(cr50607_state){
try{var cr50607_place_48 = (cr50607_state[(2)]);
var cr50607_place_49 = cljs.core.count;
var cr50607_place_50 = cr50607_place_48;
var cr50607_place_51 = (function (){var G__50714 = cr50607_place_50;
var fexpr__50713 = cr50607_place_49;
return (fexpr__50713.cljs$core$IFn$_invoke$arity$1 ? fexpr__50713.cljs$core$IFn$_invoke$arity$1(G__50714) : fexpr__50713.call(null,G__50714));
})();
var cr50607_place_52 = hyperfiddle.electric.impl.io.chunk_size;
var cr50607_place_53 = (cr50607_place_51 >= cr50607_place_52);
var cr50607_place_54 = null;
if(cr50607_place_53){
(cr50607_state[(0)] = cr50607_block_11);

return cr50607_state;
} else {
(cr50607_state[(0)] = cr50607_block_9);

(cr50607_state[(3)] = cr50607_place_54);

return cr50607_state;
}
}catch (e50712){var cr50607_exception = e50712;
(cr50607_state[(0)] = null);

(cr50607_state[(1)] = null);

(cr50607_state[(2)] = null);

throw cr50607_exception;
}});
var cr50607_block_7 = (function hyperfiddle$electric$impl$io$message_writer_$_cr50607_block_7(cr50607_state){
try{var cr50607_place_46 = cljs.core.peek;
var cr50607_place_47 = p1__50606_SHARP_;
var cr50607_place_48 = (function (){var G__50717 = cr50607_place_47;
var fexpr__50716 = cr50607_place_46;
return (fexpr__50716.cljs$core$IFn$_invoke$arity$1 ? fexpr__50716.cljs$core$IFn$_invoke$arity$1(G__50717) : fexpr__50716.call(null,G__50717));
})();
(cr50607_state[(0)] = cr50607_block_8);

(cr50607_state[(2)] = cr50607_place_48);

return cr50607_state;
}catch (e50715){var cr50607_exception = e50715;
(cr50607_state[(0)] = null);

(cr50607_state[(1)] = null);

throw cr50607_exception;
}});
var cr50607_block_13 = (function hyperfiddle$electric$impl$io$message_writer_$_cr50607_block_13(cr50607_state){
try{var cr50607_place_54 = (cr50607_state[(3)]);
(cr50607_state[(0)] = cr50607_block_14);

(cr50607_state[(3)] = null);

(cr50607_state[(1)] = cr50607_place_54);

return cr50607_state;
}catch (e50718){var cr50607_exception = e50718;
(cr50607_state[(0)] = null);

(cr50607_state[(1)] = null);

(cr50607_state[(3)] = null);

throw cr50607_exception;
}});
var cr50607_block_3 = (function hyperfiddle$electric$impl$io$message_writer_$_cr50607_block_3(cr50607_state){
try{var cr50607_place_20 = (cr50607_state[(2)]);
var cr50607_place_28 = hyperfiddle.electric.impl.io.encode;
var cr50607_place_29 = cr50607_place_20;
var cr50607_place_30 = (function (){var G__50721 = cr50607_place_29;
var fexpr__50720 = cr50607_place_28;
return (fexpr__50720.cljs$core$IFn$_invoke$arity$1 ? fexpr__50720.cljs$core$IFn$_invoke$arity$1(G__50721) : fexpr__50720.call(null,G__50721));
})();
(cr50607_state[(0)] = cr50607_block_5);

(cr50607_state[(2)] = null);

(cr50607_state[(5)] = cr50607_place_30);

return cr50607_state;
}catch (e50719){var cr50607_exception = e50719;
(cr50607_state[(0)] = cr50607_block_4);

(cr50607_state[(5)] = cr50607_exception);

return cr50607_state;
}});
var cr50607_block_9 = (function hyperfiddle$electric$impl$io$message_writer_$_cr50607_block_9(cr50607_state){
try{var cr50607_place_48 = (cr50607_state[(2)]);
var cr50607_place_55 = hyperfiddle.electric.impl.io.encode_numbers;
var cr50607_place_56 = cr50607_place_48;
var cr50607_place_57 = (function (){var G__50724 = cr50607_place_56;
var fexpr__50723 = cr50607_place_55;
return (fexpr__50723.cljs$core$IFn$_invoke$arity$1 ? fexpr__50723.cljs$core$IFn$_invoke$arity$1(G__50724) : fexpr__50723.call(null,G__50724));
})();
var cr50607_place_58 = write;
var cr50607_place_59 = cr50607_place_57;
var cr50607_place_60 = (function (){var G__50726 = cr50607_place_59;
var fexpr__50725 = cr50607_place_58;
return (fexpr__50725.cljs$core$IFn$_invoke$arity$1 ? fexpr__50725.cljs$core$IFn$_invoke$arity$1(G__50726) : fexpr__50725.call(null,G__50726));
})();
(cr50607_state[(0)] = cr50607_block_10);

(cr50607_state[(2)] = null);

return missionary.core.park(cr50607_place_60);
}catch (e50722){var cr50607_exception = e50722;
(cr50607_state[(0)] = null);

(cr50607_state[(1)] = null);

(cr50607_state[(2)] = null);

(cr50607_state[(3)] = null);

throw cr50607_exception;
}});
return cloroutine.impl.coroutine((function (){var G__50727 = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((6));
(G__50727[(0)] = cr50607_block_0);

return G__50727;
})());
})(),missionary.core.sp_run);
});
});
/**
 * A transducer partitioning a sequence of network messages into Electric events.
 */
hyperfiddle.electric.impl.io.decoder = (function hyperfiddle$electric$impl$io$decoder(rf){
var data = (function (){var G__50728 = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((2));
(G__50728[(0)] = cljs.core.PersistentVector.EMPTY);

(G__50728[(1)] = cljs.core.PersistentVector.EMPTY);

return G__50728;
})();
return (function() {
var G__50747 = null;
var G__50747__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__50747__1 = (function (r){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentVector.EMPTY,(data[(0)]),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(data[(1)])], 0))){
} else {
throw (new Error("Assert failed: (= [] (aget data 0) (aget data 1))"));
}

return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(r) : rf.call(null,r));
});
var G__50747__2 = (function (r,x){
if(typeof x === 'string'){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,(data[(1)]))){
} else {
throw (new Error("Assert failed: (= [] (aget data 1))"));
}

(data[(0)] = cljs.core.conj.cljs$core$IFn$_invoke$arity$2((data[(0)]),hyperfiddle.electric.impl.io.decode_str(x)));

return r;
} else {
var xs = hyperfiddle.electric.impl.io.decode_numbers(x);
(data[(1)] = cljs.core.into.cljs$core$IFn$_invoke$arity$2((data[(1)]),xs));

if((cljs.core.count(xs) < hyperfiddle.electric.impl.io.chunk_size)){
var x__$1 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2((data[(0)]),(data[(1)]));
(data[(0)] = cljs.core.PersistentVector.EMPTY);

(data[(1)] = cljs.core.PersistentVector.EMPTY);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(r,x__$1) : rf.call(null,r,x__$1));
} else {
return r;
}
}
});
G__50747 = function(r,x){
switch(arguments.length){
case 0:
return G__50747__0.call(this);
case 1:
return G__50747__1.call(this,r);
case 2:
return G__50747__2.call(this,r,x);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__50747.cljs$core$IFn$_invoke$arity$0 = G__50747__0;
G__50747.cljs$core$IFn$_invoke$arity$1 = G__50747__1;
G__50747.cljs$core$IFn$_invoke$arity$2 = G__50747__2;
return G__50747;
})()
});
/**
 * A transducer expanding Electric events to a sequence of network messages.
 */
hyperfiddle.electric.impl.io.encoder = (function hyperfiddle$electric$impl$io$encoder(rf){
return (function() {
var G__50748 = null;
var G__50748__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__50748__1 = (function (r){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(r) : rf.call(null,r));
});
var G__50748__2 = (function (r,x){
var r__$1 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(rf,r,cljs.core.eduction.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.map.cljs$core$IFn$_invoke$arity$1(hyperfiddle.electric.impl.io.encode),cljs.core.pop(x)], 0)));
var r__$2 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(rf,r__$1,cljs.core.eduction.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.partition_all.cljs$core$IFn$_invoke$arity$1(hyperfiddle.electric.impl.io.chunk_size),cljs.core.map.cljs$core$IFn$_invoke$arity$1(hyperfiddle.electric.impl.io.encode_numbers),cljs.core.peek(x)], 0)));
var G__50729 = cljs.core.mod(cljs.core.count(cljs.core.peek(x)),hyperfiddle.electric.impl.io.chunk_size);
switch (G__50729) {
case (0):
var G__50730 = r__$2;
var G__50731 = hyperfiddle.electric.impl.io.encode_numbers(cljs.core.PersistentVector.EMPTY);
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__50730,G__50731) : rf.call(null,G__50730,G__50731));

break;
default:
return r__$2;

}
});
G__50748 = function(r,x){
switch(arguments.length){
case 0:
return G__50748__0.call(this);
case 1:
return G__50748__1.call(this,r);
case 2:
return G__50748__2.call(this,r,x);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__50748.cljs$core$IFn$_invoke$arity$0 = G__50748__0;
G__50748.cljs$core$IFn$_invoke$arity$1 = G__50748__1;
G__50748.cljs$core$IFn$_invoke$arity$2 = G__50748__2;
return G__50748;
})()
});
hyperfiddle.electric.impl.io.foreach = (function hyperfiddle$electric$impl$io$foreach(var_args){
var G__50733 = arguments.length;
switch (G__50733) {
case 1:
return hyperfiddle.electric.impl.io.foreach.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hyperfiddle.electric.impl.io.foreach.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(hyperfiddle.electric.impl.io.foreach.cljs$core$IFn$_invoke$arity$1 = (function (r){
return r;
}));

(hyperfiddle.electric.impl.io.foreach.cljs$core$IFn$_invoke$arity$2 = (function (r,x){
(r.cljs$core$IFn$_invoke$arity$1 ? r.cljs$core$IFn$_invoke$arity$1(x) : r.call(null,x));

return r;
}));

(hyperfiddle.electric.impl.io.foreach.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=hyperfiddle.electric.impl.io.js.map
