goog.provide('cljs.core.async');
goog.scope(function(){
  cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async41446 = (function (f,blockable,meta41447){
this.f = f;
this.blockable = blockable;
this.meta41447 = meta41447;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async41446.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_41448,meta41447__$1){
var self__ = this;
var _41448__$1 = this;
return (new cljs.core.async.t_cljs$core$async41446(self__.f,self__.blockable,meta41447__$1));
}));

(cljs.core.async.t_cljs$core$async41446.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_41448){
var self__ = this;
var _41448__$1 = this;
return self__.meta41447;
}));

(cljs.core.async.t_cljs$core$async41446.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async41446.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async41446.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async41446.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async41446.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta41447","meta41447",1873083097,null)], null);
}));

(cljs.core.async.t_cljs$core$async41446.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async41446.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async41446");

(cljs.core.async.t_cljs$core$async41446.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async41446");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async41446.
 */
cljs.core.async.__GT_t_cljs$core$async41446 = (function cljs$core$async$__GT_t_cljs$core$async41446(f,blockable,meta41447){
return (new cljs.core.async.t_cljs$core$async41446(f,blockable,meta41447));
});


cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__41445 = arguments.length;
switch (G__41445) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
return (new cljs.core.async.t_cljs$core$async41446(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__41451 = arguments.length;
switch (G__41451) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed, then return the value (or nil) forever. See chan for the
 *   semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__41453 = arguments.length;
switch (G__41453) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__41459 = arguments.length;
switch (G__41459) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_43151 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_43151) : fn1.call(null,val_43151));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_43151) : fn1.call(null,val_43151));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__41461 = arguments.length;
switch (G__41461) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5821__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5821__auto__)){
var ret = temp__5821__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5821__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5821__auto__)){
var retb = temp__5821__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5593__auto___43155 = n;
var x_43156 = (0);
while(true){
if((x_43156 < n__5593__auto___43155)){
(a[x_43156] = x_43156);

var G__43157 = (x_43156 + (1));
x_43156 = G__43157;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle(a);

return a;
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async41463 = (function (flag,meta41464){
this.flag = flag;
this.meta41464 = meta41464;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async41463.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_41465,meta41464__$1){
var self__ = this;
var _41465__$1 = this;
return (new cljs.core.async.t_cljs$core$async41463(self__.flag,meta41464__$1));
}));

(cljs.core.async.t_cljs$core$async41463.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_41465){
var self__ = this;
var _41465__$1 = this;
return self__.meta41464;
}));

(cljs.core.async.t_cljs$core$async41463.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async41463.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async41463.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async41463.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async41463.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta41464","meta41464",-932868252,null)], null);
}));

(cljs.core.async.t_cljs$core$async41463.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async41463.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async41463");

(cljs.core.async.t_cljs$core$async41463.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async41463");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async41463.
 */
cljs.core.async.__GT_t_cljs$core$async41463 = (function cljs$core$async$__GT_t_cljs$core$async41463(flag,meta41464){
return (new cljs.core.async.t_cljs$core$async41463(flag,meta41464));
});


cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
return (new cljs.core.async.t_cljs$core$async41463(flag,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async41467 = (function (flag,cb,meta41468){
this.flag = flag;
this.cb = cb;
this.meta41468 = meta41468;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async41467.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_41469,meta41468__$1){
var self__ = this;
var _41469__$1 = this;
return (new cljs.core.async.t_cljs$core$async41467(self__.flag,self__.cb,meta41468__$1));
}));

(cljs.core.async.t_cljs$core$async41467.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_41469){
var self__ = this;
var _41469__$1 = this;
return self__.meta41468;
}));

(cljs.core.async.t_cljs$core$async41467.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async41467.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async41467.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async41467.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async41467.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta41468","meta41468",304802647,null)], null);
}));

(cljs.core.async.t_cljs$core$async41467.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async41467.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async41467");

(cljs.core.async.t_cljs$core$async41467.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async41467");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async41467.
 */
cljs.core.async.__GT_t_cljs$core$async41467 = (function cljs$core$async$__GT_t_cljs$core$async41467(flag,cb,meta41468){
return (new cljs.core.async.t_cljs$core$async41467(flag,cb,meta41468));
});


cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
return (new cljs.core.async.t_cljs$core$async41467(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var ports__$1 = cljs.core.vec(ports);
var n = cljs.core.count(ports__$1);
var _ = (function (){var i = (0);
while(true){
if((i < n)){
var port_43159 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports__$1,i);
if(cljs.core.vector_QMARK_(port_43159)){
if((!(((port_43159.cljs$core$IFn$_invoke$arity$1 ? port_43159.cljs$core$IFn$_invoke$arity$1((1)) : port_43159.call(null,(1))) == null)))){
} else {
throw (new Error(["Assert failed: ","can't put nil on channel","\n","(some? (port 1))"].join('')));
}
} else {
}

var G__43160 = (i + (1));
i = G__43160;
continue;
} else {
return null;
}
break;
}
})();
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports__$1,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,ports__$1,n,_,idxs,priority){
return (function (p1__41470_SHARP_){
var G__41476 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__41470_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__41476) : fret.call(null,G__41476));
});})(i,val,idx,port,wport,flag,ports__$1,n,_,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,ports__$1,n,_,idxs,priority){
return (function (p1__41471_SHARP_){
var G__41477 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__41471_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__41477) : fret.call(null,G__41477));
});})(i,idx,port,wport,flag,ports__$1,n,_,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__5002__auto__ = wport;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return port;
}
})()], null));
} else {
var G__43162 = (i + (1));
i = G__43162;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5002__auto__ = ret;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5823__auto__ = (function (){var and__5000__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__5000__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__5000__auto__;
}
})();
if(cljs.core.truth_(temp__5823__auto__)){
var got = temp__5823__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5732__auto__ = [];
var len__5726__auto___43163 = arguments.length;
var i__5727__auto___43164 = (0);
while(true){
if((i__5727__auto___43164 < len__5726__auto___43163)){
args__5732__auto__.push((arguments[i__5727__auto___43164]));

var G__43165 = (i__5727__auto___43164 + (1));
i__5727__auto___43164 = G__43165;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__41480){
var map__41481 = p__41480;
var map__41481__$1 = cljs.core.__destructure_map(map__41481);
var opts = map__41481__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq41478){
var G__41479 = cljs.core.first(seq41478);
var seq41478__$1 = cljs.core.next(seq41478);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__41479,seq41478__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__41483 = arguments.length;
switch (G__41483) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__41387__auto___43168 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41388__auto__ = (function (){var switch__41283__auto__ = (function (state_41515){
var state_val_41516 = (state_41515[(1)]);
if((state_val_41516 === (7))){
var inst_41511 = (state_41515[(2)]);
var state_41515__$1 = state_41515;
var statearr_41517_43169 = state_41515__$1;
(statearr_41517_43169[(2)] = inst_41511);

(statearr_41517_43169[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41516 === (1))){
var state_41515__$1 = state_41515;
var statearr_41518_43170 = state_41515__$1;
(statearr_41518_43170[(2)] = null);

(statearr_41518_43170[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41516 === (4))){
var inst_41494 = (state_41515[(7)]);
var inst_41494__$1 = (state_41515[(2)]);
var inst_41495 = (inst_41494__$1 == null);
var state_41515__$1 = (function (){var statearr_41519 = state_41515;
(statearr_41519[(7)] = inst_41494__$1);

return statearr_41519;
})();
if(cljs.core.truth_(inst_41495)){
var statearr_41520_43171 = state_41515__$1;
(statearr_41520_43171[(1)] = (5));

} else {
var statearr_41521_43172 = state_41515__$1;
(statearr_41521_43172[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41516 === (13))){
var state_41515__$1 = state_41515;
var statearr_41522_43173 = state_41515__$1;
(statearr_41522_43173[(2)] = null);

(statearr_41522_43173[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41516 === (6))){
var inst_41494 = (state_41515[(7)]);
var state_41515__$1 = state_41515;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_41515__$1,(11),to,inst_41494);
} else {
if((state_val_41516 === (3))){
var inst_41513 = (state_41515[(2)]);
var state_41515__$1 = state_41515;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41515__$1,inst_41513);
} else {
if((state_val_41516 === (12))){
var state_41515__$1 = state_41515;
var statearr_41525_43175 = state_41515__$1;
(statearr_41525_43175[(2)] = null);

(statearr_41525_43175[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41516 === (2))){
var state_41515__$1 = state_41515;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41515__$1,(4),from);
} else {
if((state_val_41516 === (11))){
var inst_41504 = (state_41515[(2)]);
var state_41515__$1 = state_41515;
if(cljs.core.truth_(inst_41504)){
var statearr_41526_43176 = state_41515__$1;
(statearr_41526_43176[(1)] = (12));

} else {
var statearr_41527_43177 = state_41515__$1;
(statearr_41527_43177[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41516 === (9))){
var state_41515__$1 = state_41515;
var statearr_41528_43178 = state_41515__$1;
(statearr_41528_43178[(2)] = null);

(statearr_41528_43178[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41516 === (5))){
var state_41515__$1 = state_41515;
if(cljs.core.truth_(close_QMARK_)){
var statearr_41529_43179 = state_41515__$1;
(statearr_41529_43179[(1)] = (8));

} else {
var statearr_41530_43180 = state_41515__$1;
(statearr_41530_43180[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41516 === (14))){
var inst_41509 = (state_41515[(2)]);
var state_41515__$1 = state_41515;
var statearr_41531_43181 = state_41515__$1;
(statearr_41531_43181[(2)] = inst_41509);

(statearr_41531_43181[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41516 === (10))){
var inst_41501 = (state_41515[(2)]);
var state_41515__$1 = state_41515;
var statearr_41533_43182 = state_41515__$1;
(statearr_41533_43182[(2)] = inst_41501);

(statearr_41533_43182[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41516 === (8))){
var inst_41498 = cljs.core.async.close_BANG_(to);
var state_41515__$1 = state_41515;
var statearr_41535_43183 = state_41515__$1;
(statearr_41535_43183[(2)] = inst_41498);

(statearr_41535_43183[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41284__auto__ = null;
var cljs$core$async$state_machine__41284__auto____0 = (function (){
var statearr_41540 = [null,null,null,null,null,null,null,null];
(statearr_41540[(0)] = cljs$core$async$state_machine__41284__auto__);

(statearr_41540[(1)] = (1));

return statearr_41540;
});
var cljs$core$async$state_machine__41284__auto____1 = (function (state_41515){
while(true){
var ret_value__41285__auto__ = (function (){try{while(true){
var result__41286__auto__ = switch__41283__auto__(state_41515);
if(cljs.core.keyword_identical_QMARK_(result__41286__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41286__auto__;
}
break;
}
}catch (e41544){var ex__41287__auto__ = e41544;
var statearr_41545_43185 = state_41515;
(statearr_41545_43185[(2)] = ex__41287__auto__);


if(cljs.core.seq((state_41515[(4)]))){
var statearr_41546_43186 = state_41515;
(statearr_41546_43186[(1)] = cljs.core.first((state_41515[(4)])));

} else {
throw ex__41287__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41285__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43187 = state_41515;
state_41515 = G__43187;
continue;
} else {
return ret_value__41285__auto__;
}
break;
}
});
cljs$core$async$state_machine__41284__auto__ = function(state_41515){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41284__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41284__auto____1.call(this,state_41515);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41284__auto____0;
cljs$core$async$state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41284__auto____1;
return cljs$core$async$state_machine__41284__auto__;
})()
})();
var state__41389__auto__ = (function (){var statearr_41550 = f__41388__auto__();
(statearr_41550[(6)] = c__41387__auto___43168);

return statearr_41550;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41389__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process__$1 = (function (p__41557){
var vec__41558 = p__41557;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41558,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41558,(1),null);
var job = vec__41558;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__41387__auto___43188 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41388__auto__ = (function (){var switch__41283__auto__ = (function (state_41565){
var state_val_41566 = (state_41565[(1)]);
if((state_val_41566 === (1))){
var state_41565__$1 = state_41565;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_41565__$1,(2),res,v);
} else {
if((state_val_41566 === (2))){
var inst_41562 = (state_41565[(2)]);
var inst_41563 = cljs.core.async.close_BANG_(res);
var state_41565__$1 = (function (){var statearr_41567 = state_41565;
(statearr_41567[(7)] = inst_41562);

return statearr_41567;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_41565__$1,inst_41563);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41284__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41284__auto____0 = (function (){
var statearr_41568 = [null,null,null,null,null,null,null,null];
(statearr_41568[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41284__auto__);

(statearr_41568[(1)] = (1));

return statearr_41568;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41284__auto____1 = (function (state_41565){
while(true){
var ret_value__41285__auto__ = (function (){try{while(true){
var result__41286__auto__ = switch__41283__auto__(state_41565);
if(cljs.core.keyword_identical_QMARK_(result__41286__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41286__auto__;
}
break;
}
}catch (e41570){var ex__41287__auto__ = e41570;
var statearr_41572_43190 = state_41565;
(statearr_41572_43190[(2)] = ex__41287__auto__);


if(cljs.core.seq((state_41565[(4)]))){
var statearr_41573_43191 = state_41565;
(statearr_41573_43191[(1)] = cljs.core.first((state_41565[(4)])));

} else {
throw ex__41287__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41285__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43192 = state_41565;
state_41565 = G__43192;
continue;
} else {
return ret_value__41285__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41284__auto__ = function(state_41565){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41284__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41284__auto____1.call(this,state_41565);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41284__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41284__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41284__auto__;
})()
})();
var state__41389__auto__ = (function (){var statearr_41574 = f__41388__auto__();
(statearr_41574[(6)] = c__41387__auto___43188);

return statearr_41574;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41389__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__41575){
var vec__41576 = p__41575;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41576,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41576,(1),null);
var job = vec__41576;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__5593__auto___43193 = n;
var __43194 = (0);
while(true){
if((__43194 < n__5593__auto___43193)){
var G__41582_43195 = type;
var G__41582_43196__$1 = (((G__41582_43195 instanceof cljs.core.Keyword))?G__41582_43195.fqn:null);
switch (G__41582_43196__$1) {
case "compute":
var c__41387__auto___43198 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__43194,c__41387__auto___43198,G__41582_43195,G__41582_43196__$1,n__5593__auto___43193,jobs,results,process__$1,async){
return (function (){
var f__41388__auto__ = (function (){var switch__41283__auto__ = ((function (__43194,c__41387__auto___43198,G__41582_43195,G__41582_43196__$1,n__5593__auto___43193,jobs,results,process__$1,async){
return (function (state_41595){
var state_val_41596 = (state_41595[(1)]);
if((state_val_41596 === (1))){
var state_41595__$1 = state_41595;
var statearr_41597_43199 = state_41595__$1;
(statearr_41597_43199[(2)] = null);

(statearr_41597_43199[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41596 === (2))){
var state_41595__$1 = state_41595;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41595__$1,(4),jobs);
} else {
if((state_val_41596 === (3))){
var inst_41593 = (state_41595[(2)]);
var state_41595__$1 = state_41595;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41595__$1,inst_41593);
} else {
if((state_val_41596 === (4))){
var inst_41585 = (state_41595[(2)]);
var inst_41586 = process__$1(inst_41585);
var state_41595__$1 = state_41595;
if(cljs.core.truth_(inst_41586)){
var statearr_41598_43201 = state_41595__$1;
(statearr_41598_43201[(1)] = (5));

} else {
var statearr_41599_43202 = state_41595__$1;
(statearr_41599_43202[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41596 === (5))){
var state_41595__$1 = state_41595;
var statearr_41600_43203 = state_41595__$1;
(statearr_41600_43203[(2)] = null);

(statearr_41600_43203[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41596 === (6))){
var state_41595__$1 = state_41595;
var statearr_41601_43204 = state_41595__$1;
(statearr_41601_43204[(2)] = null);

(statearr_41601_43204[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41596 === (7))){
var inst_41591 = (state_41595[(2)]);
var state_41595__$1 = state_41595;
var statearr_41602_43205 = state_41595__$1;
(statearr_41602_43205[(2)] = inst_41591);

(statearr_41602_43205[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__43194,c__41387__auto___43198,G__41582_43195,G__41582_43196__$1,n__5593__auto___43193,jobs,results,process__$1,async))
;
return ((function (__43194,switch__41283__auto__,c__41387__auto___43198,G__41582_43195,G__41582_43196__$1,n__5593__auto___43193,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41284__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41284__auto____0 = (function (){
var statearr_41603 = [null,null,null,null,null,null,null];
(statearr_41603[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41284__auto__);

(statearr_41603[(1)] = (1));

return statearr_41603;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41284__auto____1 = (function (state_41595){
while(true){
var ret_value__41285__auto__ = (function (){try{while(true){
var result__41286__auto__ = switch__41283__auto__(state_41595);
if(cljs.core.keyword_identical_QMARK_(result__41286__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41286__auto__;
}
break;
}
}catch (e41604){var ex__41287__auto__ = e41604;
var statearr_41605_43206 = state_41595;
(statearr_41605_43206[(2)] = ex__41287__auto__);


if(cljs.core.seq((state_41595[(4)]))){
var statearr_41606_43207 = state_41595;
(statearr_41606_43207[(1)] = cljs.core.first((state_41595[(4)])));

} else {
throw ex__41287__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41285__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43208 = state_41595;
state_41595 = G__43208;
continue;
} else {
return ret_value__41285__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41284__auto__ = function(state_41595){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41284__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41284__auto____1.call(this,state_41595);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41284__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41284__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41284__auto__;
})()
;})(__43194,switch__41283__auto__,c__41387__auto___43198,G__41582_43195,G__41582_43196__$1,n__5593__auto___43193,jobs,results,process__$1,async))
})();
var state__41389__auto__ = (function (){var statearr_41607 = f__41388__auto__();
(statearr_41607[(6)] = c__41387__auto___43198);

return statearr_41607;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41389__auto__);
});})(__43194,c__41387__auto___43198,G__41582_43195,G__41582_43196__$1,n__5593__auto___43193,jobs,results,process__$1,async))
);


break;
case "async":
var c__41387__auto___43209 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__43194,c__41387__auto___43209,G__41582_43195,G__41582_43196__$1,n__5593__auto___43193,jobs,results,process__$1,async){
return (function (){
var f__41388__auto__ = (function (){var switch__41283__auto__ = ((function (__43194,c__41387__auto___43209,G__41582_43195,G__41582_43196__$1,n__5593__auto___43193,jobs,results,process__$1,async){
return (function (state_41620){
var state_val_41621 = (state_41620[(1)]);
if((state_val_41621 === (1))){
var state_41620__$1 = state_41620;
var statearr_41622_43210 = state_41620__$1;
(statearr_41622_43210[(2)] = null);

(statearr_41622_43210[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41621 === (2))){
var state_41620__$1 = state_41620;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41620__$1,(4),jobs);
} else {
if((state_val_41621 === (3))){
var inst_41618 = (state_41620[(2)]);
var state_41620__$1 = state_41620;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41620__$1,inst_41618);
} else {
if((state_val_41621 === (4))){
var inst_41610 = (state_41620[(2)]);
var inst_41611 = async(inst_41610);
var state_41620__$1 = state_41620;
if(cljs.core.truth_(inst_41611)){
var statearr_41623_43212 = state_41620__$1;
(statearr_41623_43212[(1)] = (5));

} else {
var statearr_41624_43213 = state_41620__$1;
(statearr_41624_43213[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41621 === (5))){
var state_41620__$1 = state_41620;
var statearr_41625_43214 = state_41620__$1;
(statearr_41625_43214[(2)] = null);

(statearr_41625_43214[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41621 === (6))){
var state_41620__$1 = state_41620;
var statearr_41626_43215 = state_41620__$1;
(statearr_41626_43215[(2)] = null);

(statearr_41626_43215[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41621 === (7))){
var inst_41616 = (state_41620[(2)]);
var state_41620__$1 = state_41620;
var statearr_41627_43216 = state_41620__$1;
(statearr_41627_43216[(2)] = inst_41616);

(statearr_41627_43216[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__43194,c__41387__auto___43209,G__41582_43195,G__41582_43196__$1,n__5593__auto___43193,jobs,results,process__$1,async))
;
return ((function (__43194,switch__41283__auto__,c__41387__auto___43209,G__41582_43195,G__41582_43196__$1,n__5593__auto___43193,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41284__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41284__auto____0 = (function (){
var statearr_41628 = [null,null,null,null,null,null,null];
(statearr_41628[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41284__auto__);

(statearr_41628[(1)] = (1));

return statearr_41628;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41284__auto____1 = (function (state_41620){
while(true){
var ret_value__41285__auto__ = (function (){try{while(true){
var result__41286__auto__ = switch__41283__auto__(state_41620);
if(cljs.core.keyword_identical_QMARK_(result__41286__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41286__auto__;
}
break;
}
}catch (e41629){var ex__41287__auto__ = e41629;
var statearr_41630_43217 = state_41620;
(statearr_41630_43217[(2)] = ex__41287__auto__);


if(cljs.core.seq((state_41620[(4)]))){
var statearr_41631_43218 = state_41620;
(statearr_41631_43218[(1)] = cljs.core.first((state_41620[(4)])));

} else {
throw ex__41287__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41285__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43219 = state_41620;
state_41620 = G__43219;
continue;
} else {
return ret_value__41285__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41284__auto__ = function(state_41620){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41284__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41284__auto____1.call(this,state_41620);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41284__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41284__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41284__auto__;
})()
;})(__43194,switch__41283__auto__,c__41387__auto___43209,G__41582_43195,G__41582_43196__$1,n__5593__auto___43193,jobs,results,process__$1,async))
})();
var state__41389__auto__ = (function (){var statearr_41632 = f__41388__auto__();
(statearr_41632[(6)] = c__41387__auto___43209);

return statearr_41632;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41389__auto__);
});})(__43194,c__41387__auto___43209,G__41582_43195,G__41582_43196__$1,n__5593__auto___43193,jobs,results,process__$1,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__41582_43196__$1)].join('')));

}

var G__43220 = (__43194 + (1));
__43194 = G__43220;
continue;
} else {
}
break;
}

var c__41387__auto___43221 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41388__auto__ = (function (){var switch__41283__auto__ = (function (state_41654){
var state_val_41655 = (state_41654[(1)]);
if((state_val_41655 === (7))){
var inst_41650 = (state_41654[(2)]);
var state_41654__$1 = state_41654;
var statearr_41657_43222 = state_41654__$1;
(statearr_41657_43222[(2)] = inst_41650);

(statearr_41657_43222[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41655 === (1))){
var state_41654__$1 = state_41654;
var statearr_41658_43223 = state_41654__$1;
(statearr_41658_43223[(2)] = null);

(statearr_41658_43223[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41655 === (4))){
var inst_41635 = (state_41654[(7)]);
var inst_41635__$1 = (state_41654[(2)]);
var inst_41636 = (inst_41635__$1 == null);
var state_41654__$1 = (function (){var statearr_41659 = state_41654;
(statearr_41659[(7)] = inst_41635__$1);

return statearr_41659;
})();
if(cljs.core.truth_(inst_41636)){
var statearr_41660_43225 = state_41654__$1;
(statearr_41660_43225[(1)] = (5));

} else {
var statearr_41662_43226 = state_41654__$1;
(statearr_41662_43226[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41655 === (6))){
var inst_41635 = (state_41654[(7)]);
var inst_41640 = (state_41654[(8)]);
var inst_41640__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_41641 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41642 = [inst_41635,inst_41640__$1];
var inst_41643 = (new cljs.core.PersistentVector(null,2,(5),inst_41641,inst_41642,null));
var state_41654__$1 = (function (){var statearr_41664 = state_41654;
(statearr_41664[(8)] = inst_41640__$1);

return statearr_41664;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_41654__$1,(8),jobs,inst_41643);
} else {
if((state_val_41655 === (3))){
var inst_41652 = (state_41654[(2)]);
var state_41654__$1 = state_41654;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41654__$1,inst_41652);
} else {
if((state_val_41655 === (2))){
var state_41654__$1 = state_41654;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41654__$1,(4),from);
} else {
if((state_val_41655 === (9))){
var inst_41647 = (state_41654[(2)]);
var state_41654__$1 = (function (){var statearr_41665 = state_41654;
(statearr_41665[(9)] = inst_41647);

return statearr_41665;
})();
var statearr_41666_43227 = state_41654__$1;
(statearr_41666_43227[(2)] = null);

(statearr_41666_43227[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41655 === (5))){
var inst_41638 = cljs.core.async.close_BANG_(jobs);
var state_41654__$1 = state_41654;
var statearr_41667_43228 = state_41654__$1;
(statearr_41667_43228[(2)] = inst_41638);

(statearr_41667_43228[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41655 === (8))){
var inst_41640 = (state_41654[(8)]);
var inst_41645 = (state_41654[(2)]);
var state_41654__$1 = (function (){var statearr_41668 = state_41654;
(statearr_41668[(10)] = inst_41645);

return statearr_41668;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_41654__$1,(9),results,inst_41640);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41284__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41284__auto____0 = (function (){
var statearr_41670 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_41670[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41284__auto__);

(statearr_41670[(1)] = (1));

return statearr_41670;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41284__auto____1 = (function (state_41654){
while(true){
var ret_value__41285__auto__ = (function (){try{while(true){
var result__41286__auto__ = switch__41283__auto__(state_41654);
if(cljs.core.keyword_identical_QMARK_(result__41286__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41286__auto__;
}
break;
}
}catch (e41672){var ex__41287__auto__ = e41672;
var statearr_41673_43229 = state_41654;
(statearr_41673_43229[(2)] = ex__41287__auto__);


if(cljs.core.seq((state_41654[(4)]))){
var statearr_41678_43230 = state_41654;
(statearr_41678_43230[(1)] = cljs.core.first((state_41654[(4)])));

} else {
throw ex__41287__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41285__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43231 = state_41654;
state_41654 = G__43231;
continue;
} else {
return ret_value__41285__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41284__auto__ = function(state_41654){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41284__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41284__auto____1.call(this,state_41654);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41284__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41284__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41284__auto__;
})()
})();
var state__41389__auto__ = (function (){var statearr_41694 = f__41388__auto__();
(statearr_41694[(6)] = c__41387__auto___43221);

return statearr_41694;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41389__auto__);
}));


var c__41387__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41388__auto__ = (function (){var switch__41283__auto__ = (function (state_41741){
var state_val_41742 = (state_41741[(1)]);
if((state_val_41742 === (7))){
var inst_41736 = (state_41741[(2)]);
var state_41741__$1 = state_41741;
var statearr_41745_43232 = state_41741__$1;
(statearr_41745_43232[(2)] = inst_41736);

(statearr_41745_43232[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41742 === (20))){
var state_41741__$1 = state_41741;
var statearr_41746_43233 = state_41741__$1;
(statearr_41746_43233[(2)] = null);

(statearr_41746_43233[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41742 === (1))){
var state_41741__$1 = state_41741;
var statearr_41747_43234 = state_41741__$1;
(statearr_41747_43234[(2)] = null);

(statearr_41747_43234[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41742 === (4))){
var inst_41703 = (state_41741[(7)]);
var inst_41703__$1 = (state_41741[(2)]);
var inst_41704 = (inst_41703__$1 == null);
var state_41741__$1 = (function (){var statearr_41748 = state_41741;
(statearr_41748[(7)] = inst_41703__$1);

return statearr_41748;
})();
if(cljs.core.truth_(inst_41704)){
var statearr_41749_43236 = state_41741__$1;
(statearr_41749_43236[(1)] = (5));

} else {
var statearr_41750_43237 = state_41741__$1;
(statearr_41750_43237[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41742 === (15))){
var inst_41717 = (state_41741[(8)]);
var state_41741__$1 = state_41741;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_41741__$1,(18),to,inst_41717);
} else {
if((state_val_41742 === (21))){
var inst_41731 = (state_41741[(2)]);
var state_41741__$1 = state_41741;
var statearr_41756_43238 = state_41741__$1;
(statearr_41756_43238[(2)] = inst_41731);

(statearr_41756_43238[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41742 === (13))){
var inst_41733 = (state_41741[(2)]);
var state_41741__$1 = (function (){var statearr_41764 = state_41741;
(statearr_41764[(9)] = inst_41733);

return statearr_41764;
})();
var statearr_41770_43239 = state_41741__$1;
(statearr_41770_43239[(2)] = null);

(statearr_41770_43239[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41742 === (6))){
var inst_41703 = (state_41741[(7)]);
var state_41741__$1 = state_41741;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41741__$1,(11),inst_41703);
} else {
if((state_val_41742 === (17))){
var inst_41726 = (state_41741[(2)]);
var state_41741__$1 = state_41741;
if(cljs.core.truth_(inst_41726)){
var statearr_41775_43240 = state_41741__$1;
(statearr_41775_43240[(1)] = (19));

} else {
var statearr_41776_43241 = state_41741__$1;
(statearr_41776_43241[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41742 === (3))){
var inst_41738 = (state_41741[(2)]);
var state_41741__$1 = state_41741;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41741__$1,inst_41738);
} else {
if((state_val_41742 === (12))){
var inst_41713 = (state_41741[(10)]);
var state_41741__$1 = state_41741;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41741__$1,(14),inst_41713);
} else {
if((state_val_41742 === (2))){
var state_41741__$1 = state_41741;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41741__$1,(4),results);
} else {
if((state_val_41742 === (19))){
var state_41741__$1 = state_41741;
var statearr_41788_43242 = state_41741__$1;
(statearr_41788_43242[(2)] = null);

(statearr_41788_43242[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41742 === (11))){
var inst_41713 = (state_41741[(2)]);
var state_41741__$1 = (function (){var statearr_41799 = state_41741;
(statearr_41799[(10)] = inst_41713);

return statearr_41799;
})();
var statearr_41800_43243 = state_41741__$1;
(statearr_41800_43243[(2)] = null);

(statearr_41800_43243[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41742 === (9))){
var state_41741__$1 = state_41741;
var statearr_41801_43244 = state_41741__$1;
(statearr_41801_43244[(2)] = null);

(statearr_41801_43244[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41742 === (5))){
var state_41741__$1 = state_41741;
if(cljs.core.truth_(close_QMARK_)){
var statearr_41806_43245 = state_41741__$1;
(statearr_41806_43245[(1)] = (8));

} else {
var statearr_41812_43246 = state_41741__$1;
(statearr_41812_43246[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41742 === (14))){
var inst_41717 = (state_41741[(8)]);
var inst_41719 = (state_41741[(11)]);
var inst_41717__$1 = (state_41741[(2)]);
var inst_41718 = (inst_41717__$1 == null);
var inst_41719__$1 = cljs.core.not(inst_41718);
var state_41741__$1 = (function (){var statearr_41825 = state_41741;
(statearr_41825[(8)] = inst_41717__$1);

(statearr_41825[(11)] = inst_41719__$1);

return statearr_41825;
})();
if(inst_41719__$1){
var statearr_41826_43248 = state_41741__$1;
(statearr_41826_43248[(1)] = (15));

} else {
var statearr_41827_43249 = state_41741__$1;
(statearr_41827_43249[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41742 === (16))){
var inst_41719 = (state_41741[(11)]);
var state_41741__$1 = state_41741;
var statearr_41828_43250 = state_41741__$1;
(statearr_41828_43250[(2)] = inst_41719);

(statearr_41828_43250[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41742 === (10))){
var inst_41710 = (state_41741[(2)]);
var state_41741__$1 = state_41741;
var statearr_41829_43251 = state_41741__$1;
(statearr_41829_43251[(2)] = inst_41710);

(statearr_41829_43251[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41742 === (18))){
var inst_41722 = (state_41741[(2)]);
var state_41741__$1 = state_41741;
var statearr_41830_43252 = state_41741__$1;
(statearr_41830_43252[(2)] = inst_41722);

(statearr_41830_43252[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41742 === (8))){
var inst_41707 = cljs.core.async.close_BANG_(to);
var state_41741__$1 = state_41741;
var statearr_41831_43253 = state_41741__$1;
(statearr_41831_43253[(2)] = inst_41707);

(statearr_41831_43253[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41284__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41284__auto____0 = (function (){
var statearr_41833 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41833[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41284__auto__);

(statearr_41833[(1)] = (1));

return statearr_41833;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41284__auto____1 = (function (state_41741){
while(true){
var ret_value__41285__auto__ = (function (){try{while(true){
var result__41286__auto__ = switch__41283__auto__(state_41741);
if(cljs.core.keyword_identical_QMARK_(result__41286__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41286__auto__;
}
break;
}
}catch (e41834){var ex__41287__auto__ = e41834;
var statearr_41835_43254 = state_41741;
(statearr_41835_43254[(2)] = ex__41287__auto__);


if(cljs.core.seq((state_41741[(4)]))){
var statearr_41836_43255 = state_41741;
(statearr_41836_43255[(1)] = cljs.core.first((state_41741[(4)])));

} else {
throw ex__41287__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41285__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43256 = state_41741;
state_41741 = G__43256;
continue;
} else {
return ret_value__41285__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41284__auto__ = function(state_41741){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41284__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41284__auto____1.call(this,state_41741);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41284__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41284__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41284__auto__;
})()
})();
var state__41389__auto__ = (function (){var statearr_41837 = f__41388__auto__();
(statearr_41837[(6)] = c__41387__auto__);

return statearr_41837;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41389__auto__);
}));

return c__41387__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__41851 = arguments.length;
switch (G__41851) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__41854 = arguments.length;
switch (G__41854) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__41856 = arguments.length;
switch (G__41856) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__41387__auto___43261 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41388__auto__ = (function (){var switch__41283__auto__ = (function (state_41882){
var state_val_41883 = (state_41882[(1)]);
if((state_val_41883 === (7))){
var inst_41878 = (state_41882[(2)]);
var state_41882__$1 = state_41882;
var statearr_41884_43262 = state_41882__$1;
(statearr_41884_43262[(2)] = inst_41878);

(statearr_41884_43262[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41883 === (1))){
var state_41882__$1 = state_41882;
var statearr_41885_43263 = state_41882__$1;
(statearr_41885_43263[(2)] = null);

(statearr_41885_43263[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41883 === (4))){
var inst_41859 = (state_41882[(7)]);
var inst_41859__$1 = (state_41882[(2)]);
var inst_41860 = (inst_41859__$1 == null);
var state_41882__$1 = (function (){var statearr_41886 = state_41882;
(statearr_41886[(7)] = inst_41859__$1);

return statearr_41886;
})();
if(cljs.core.truth_(inst_41860)){
var statearr_41887_43265 = state_41882__$1;
(statearr_41887_43265[(1)] = (5));

} else {
var statearr_41888_43266 = state_41882__$1;
(statearr_41888_43266[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41883 === (13))){
var state_41882__$1 = state_41882;
var statearr_41889_43267 = state_41882__$1;
(statearr_41889_43267[(2)] = null);

(statearr_41889_43267[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41883 === (6))){
var inst_41859 = (state_41882[(7)]);
var inst_41865 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_41859) : p.call(null,inst_41859));
var state_41882__$1 = state_41882;
if(cljs.core.truth_(inst_41865)){
var statearr_41890_43268 = state_41882__$1;
(statearr_41890_43268[(1)] = (9));

} else {
var statearr_41891_43269 = state_41882__$1;
(statearr_41891_43269[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41883 === (3))){
var inst_41880 = (state_41882[(2)]);
var state_41882__$1 = state_41882;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41882__$1,inst_41880);
} else {
if((state_val_41883 === (12))){
var state_41882__$1 = state_41882;
var statearr_41892_43270 = state_41882__$1;
(statearr_41892_43270[(2)] = null);

(statearr_41892_43270[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41883 === (2))){
var state_41882__$1 = state_41882;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41882__$1,(4),ch);
} else {
if((state_val_41883 === (11))){
var inst_41859 = (state_41882[(7)]);
var inst_41869 = (state_41882[(2)]);
var state_41882__$1 = state_41882;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_41882__$1,(8),inst_41869,inst_41859);
} else {
if((state_val_41883 === (9))){
var state_41882__$1 = state_41882;
var statearr_41893_43271 = state_41882__$1;
(statearr_41893_43271[(2)] = tc);

(statearr_41893_43271[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41883 === (5))){
var inst_41862 = cljs.core.async.close_BANG_(tc);
var inst_41863 = cljs.core.async.close_BANG_(fc);
var state_41882__$1 = (function (){var statearr_41894 = state_41882;
(statearr_41894[(8)] = inst_41862);

return statearr_41894;
})();
var statearr_41895_43272 = state_41882__$1;
(statearr_41895_43272[(2)] = inst_41863);

(statearr_41895_43272[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41883 === (14))){
var inst_41876 = (state_41882[(2)]);
var state_41882__$1 = state_41882;
var statearr_41896_43273 = state_41882__$1;
(statearr_41896_43273[(2)] = inst_41876);

(statearr_41896_43273[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41883 === (10))){
var state_41882__$1 = state_41882;
var statearr_41897_43274 = state_41882__$1;
(statearr_41897_43274[(2)] = fc);

(statearr_41897_43274[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41883 === (8))){
var inst_41871 = (state_41882[(2)]);
var state_41882__$1 = state_41882;
if(cljs.core.truth_(inst_41871)){
var statearr_41898_43275 = state_41882__$1;
(statearr_41898_43275[(1)] = (12));

} else {
var statearr_41899_43276 = state_41882__$1;
(statearr_41899_43276[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41284__auto__ = null;
var cljs$core$async$state_machine__41284__auto____0 = (function (){
var statearr_41900 = [null,null,null,null,null,null,null,null,null];
(statearr_41900[(0)] = cljs$core$async$state_machine__41284__auto__);

(statearr_41900[(1)] = (1));

return statearr_41900;
});
var cljs$core$async$state_machine__41284__auto____1 = (function (state_41882){
while(true){
var ret_value__41285__auto__ = (function (){try{while(true){
var result__41286__auto__ = switch__41283__auto__(state_41882);
if(cljs.core.keyword_identical_QMARK_(result__41286__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41286__auto__;
}
break;
}
}catch (e41901){var ex__41287__auto__ = e41901;
var statearr_41902_43278 = state_41882;
(statearr_41902_43278[(2)] = ex__41287__auto__);


if(cljs.core.seq((state_41882[(4)]))){
var statearr_41903_43279 = state_41882;
(statearr_41903_43279[(1)] = cljs.core.first((state_41882[(4)])));

} else {
throw ex__41287__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41285__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43280 = state_41882;
state_41882 = G__43280;
continue;
} else {
return ret_value__41285__auto__;
}
break;
}
});
cljs$core$async$state_machine__41284__auto__ = function(state_41882){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41284__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41284__auto____1.call(this,state_41882);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41284__auto____0;
cljs$core$async$state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41284__auto____1;
return cljs$core$async$state_machine__41284__auto__;
})()
})();
var state__41389__auto__ = (function (){var statearr_41904 = f__41388__auto__();
(statearr_41904[(6)] = c__41387__auto___43261);

return statearr_41904;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41389__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__41387__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41388__auto__ = (function (){var switch__41283__auto__ = (function (state_41926){
var state_val_41927 = (state_41926[(1)]);
if((state_val_41927 === (7))){
var inst_41922 = (state_41926[(2)]);
var state_41926__$1 = state_41926;
var statearr_41928_43281 = state_41926__$1;
(statearr_41928_43281[(2)] = inst_41922);

(statearr_41928_43281[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41927 === (1))){
var inst_41905 = init;
var inst_41906 = inst_41905;
var state_41926__$1 = (function (){var statearr_41929 = state_41926;
(statearr_41929[(7)] = inst_41906);

return statearr_41929;
})();
var statearr_41930_43282 = state_41926__$1;
(statearr_41930_43282[(2)] = null);

(statearr_41930_43282[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41927 === (4))){
var inst_41909 = (state_41926[(8)]);
var inst_41909__$1 = (state_41926[(2)]);
var inst_41910 = (inst_41909__$1 == null);
var state_41926__$1 = (function (){var statearr_41931 = state_41926;
(statearr_41931[(8)] = inst_41909__$1);

return statearr_41931;
})();
if(cljs.core.truth_(inst_41910)){
var statearr_41932_43283 = state_41926__$1;
(statearr_41932_43283[(1)] = (5));

} else {
var statearr_41933_43284 = state_41926__$1;
(statearr_41933_43284[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41927 === (6))){
var inst_41906 = (state_41926[(7)]);
var inst_41909 = (state_41926[(8)]);
var inst_41913 = (state_41926[(9)]);
var inst_41913__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_41906,inst_41909) : f.call(null,inst_41906,inst_41909));
var inst_41914 = cljs.core.reduced_QMARK_(inst_41913__$1);
var state_41926__$1 = (function (){var statearr_41934 = state_41926;
(statearr_41934[(9)] = inst_41913__$1);

return statearr_41934;
})();
if(inst_41914){
var statearr_41935_43285 = state_41926__$1;
(statearr_41935_43285[(1)] = (8));

} else {
var statearr_41936_43286 = state_41926__$1;
(statearr_41936_43286[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41927 === (3))){
var inst_41924 = (state_41926[(2)]);
var state_41926__$1 = state_41926;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41926__$1,inst_41924);
} else {
if((state_val_41927 === (2))){
var state_41926__$1 = state_41926;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41926__$1,(4),ch);
} else {
if((state_val_41927 === (9))){
var inst_41913 = (state_41926[(9)]);
var inst_41906 = inst_41913;
var state_41926__$1 = (function (){var statearr_41937 = state_41926;
(statearr_41937[(7)] = inst_41906);

return statearr_41937;
})();
var statearr_41938_43288 = state_41926__$1;
(statearr_41938_43288[(2)] = null);

(statearr_41938_43288[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41927 === (5))){
var inst_41906 = (state_41926[(7)]);
var state_41926__$1 = state_41926;
var statearr_41939_43289 = state_41926__$1;
(statearr_41939_43289[(2)] = inst_41906);

(statearr_41939_43289[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41927 === (10))){
var inst_41920 = (state_41926[(2)]);
var state_41926__$1 = state_41926;
var statearr_41940_43290 = state_41926__$1;
(statearr_41940_43290[(2)] = inst_41920);

(statearr_41940_43290[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41927 === (8))){
var inst_41913 = (state_41926[(9)]);
var inst_41916 = cljs.core.deref(inst_41913);
var state_41926__$1 = state_41926;
var statearr_41941_43291 = state_41926__$1;
(statearr_41941_43291[(2)] = inst_41916);

(statearr_41941_43291[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__41284__auto__ = null;
var cljs$core$async$reduce_$_state_machine__41284__auto____0 = (function (){
var statearr_41942 = [null,null,null,null,null,null,null,null,null,null];
(statearr_41942[(0)] = cljs$core$async$reduce_$_state_machine__41284__auto__);

(statearr_41942[(1)] = (1));

return statearr_41942;
});
var cljs$core$async$reduce_$_state_machine__41284__auto____1 = (function (state_41926){
while(true){
var ret_value__41285__auto__ = (function (){try{while(true){
var result__41286__auto__ = switch__41283__auto__(state_41926);
if(cljs.core.keyword_identical_QMARK_(result__41286__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41286__auto__;
}
break;
}
}catch (e41943){var ex__41287__auto__ = e41943;
var statearr_41944_43294 = state_41926;
(statearr_41944_43294[(2)] = ex__41287__auto__);


if(cljs.core.seq((state_41926[(4)]))){
var statearr_41945_43295 = state_41926;
(statearr_41945_43295[(1)] = cljs.core.first((state_41926[(4)])));

} else {
throw ex__41287__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41285__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43296 = state_41926;
state_41926 = G__43296;
continue;
} else {
return ret_value__41285__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__41284__auto__ = function(state_41926){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__41284__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__41284__auto____1.call(this,state_41926);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__41284__auto____0;
cljs$core$async$reduce_$_state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__41284__auto____1;
return cljs$core$async$reduce_$_state_machine__41284__auto__;
})()
})();
var state__41389__auto__ = (function (){var statearr_41946 = f__41388__auto__();
(statearr_41946[(6)] = c__41387__auto__);

return statearr_41946;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41389__auto__);
}));

return c__41387__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__41387__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41388__auto__ = (function (){var switch__41283__auto__ = (function (state_41952){
var state_val_41953 = (state_41952[(1)]);
if((state_val_41953 === (1))){
var inst_41947 = cljs.core.async.reduce(f__$1,init,ch);
var state_41952__$1 = state_41952;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41952__$1,(2),inst_41947);
} else {
if((state_val_41953 === (2))){
var inst_41949 = (state_41952[(2)]);
var inst_41950 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_41949) : f__$1.call(null,inst_41949));
var state_41952__$1 = state_41952;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41952__$1,inst_41950);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__41284__auto__ = null;
var cljs$core$async$transduce_$_state_machine__41284__auto____0 = (function (){
var statearr_41954 = [null,null,null,null,null,null,null];
(statearr_41954[(0)] = cljs$core$async$transduce_$_state_machine__41284__auto__);

(statearr_41954[(1)] = (1));

return statearr_41954;
});
var cljs$core$async$transduce_$_state_machine__41284__auto____1 = (function (state_41952){
while(true){
var ret_value__41285__auto__ = (function (){try{while(true){
var result__41286__auto__ = switch__41283__auto__(state_41952);
if(cljs.core.keyword_identical_QMARK_(result__41286__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41286__auto__;
}
break;
}
}catch (e41955){var ex__41287__auto__ = e41955;
var statearr_41956_43298 = state_41952;
(statearr_41956_43298[(2)] = ex__41287__auto__);


if(cljs.core.seq((state_41952[(4)]))){
var statearr_41957_43299 = state_41952;
(statearr_41957_43299[(1)] = cljs.core.first((state_41952[(4)])));

} else {
throw ex__41287__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41285__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43300 = state_41952;
state_41952 = G__43300;
continue;
} else {
return ret_value__41285__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__41284__auto__ = function(state_41952){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__41284__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__41284__auto____1.call(this,state_41952);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__41284__auto____0;
cljs$core$async$transduce_$_state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__41284__auto____1;
return cljs$core$async$transduce_$_state_machine__41284__auto__;
})()
})();
var state__41389__auto__ = (function (){var statearr_41958 = f__41388__auto__();
(statearr_41958[(6)] = c__41387__auto__);

return statearr_41958;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41389__auto__);
}));

return c__41387__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__41960 = arguments.length;
switch (G__41960) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__41387__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41388__auto__ = (function (){var switch__41283__auto__ = (function (state_41985){
var state_val_41986 = (state_41985[(1)]);
if((state_val_41986 === (7))){
var inst_41967 = (state_41985[(2)]);
var state_41985__$1 = state_41985;
var statearr_41987_43302 = state_41985__$1;
(statearr_41987_43302[(2)] = inst_41967);

(statearr_41987_43302[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41986 === (1))){
var inst_41961 = cljs.core.seq(coll);
var inst_41962 = inst_41961;
var state_41985__$1 = (function (){var statearr_41988 = state_41985;
(statearr_41988[(7)] = inst_41962);

return statearr_41988;
})();
var statearr_41989_43303 = state_41985__$1;
(statearr_41989_43303[(2)] = null);

(statearr_41989_43303[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41986 === (4))){
var inst_41962 = (state_41985[(7)]);
var inst_41965 = cljs.core.first(inst_41962);
var state_41985__$1 = state_41985;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_41985__$1,(7),ch,inst_41965);
} else {
if((state_val_41986 === (13))){
var inst_41979 = (state_41985[(2)]);
var state_41985__$1 = state_41985;
var statearr_41990_43304 = state_41985__$1;
(statearr_41990_43304[(2)] = inst_41979);

(statearr_41990_43304[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41986 === (6))){
var inst_41970 = (state_41985[(2)]);
var state_41985__$1 = state_41985;
if(cljs.core.truth_(inst_41970)){
var statearr_41991_43305 = state_41985__$1;
(statearr_41991_43305[(1)] = (8));

} else {
var statearr_41992_43306 = state_41985__$1;
(statearr_41992_43306[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41986 === (3))){
var inst_41983 = (state_41985[(2)]);
var state_41985__$1 = state_41985;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41985__$1,inst_41983);
} else {
if((state_val_41986 === (12))){
var state_41985__$1 = state_41985;
var statearr_41993_43308 = state_41985__$1;
(statearr_41993_43308[(2)] = null);

(statearr_41993_43308[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41986 === (2))){
var inst_41962 = (state_41985[(7)]);
var state_41985__$1 = state_41985;
if(cljs.core.truth_(inst_41962)){
var statearr_41994_43309 = state_41985__$1;
(statearr_41994_43309[(1)] = (4));

} else {
var statearr_41995_43310 = state_41985__$1;
(statearr_41995_43310[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41986 === (11))){
var inst_41976 = cljs.core.async.close_BANG_(ch);
var state_41985__$1 = state_41985;
var statearr_41996_43311 = state_41985__$1;
(statearr_41996_43311[(2)] = inst_41976);

(statearr_41996_43311[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41986 === (9))){
var state_41985__$1 = state_41985;
if(cljs.core.truth_(close_QMARK_)){
var statearr_41997_43312 = state_41985__$1;
(statearr_41997_43312[(1)] = (11));

} else {
var statearr_41998_43313 = state_41985__$1;
(statearr_41998_43313[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41986 === (5))){
var inst_41962 = (state_41985[(7)]);
var state_41985__$1 = state_41985;
var statearr_41999_43315 = state_41985__$1;
(statearr_41999_43315[(2)] = inst_41962);

(statearr_41999_43315[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41986 === (10))){
var inst_41981 = (state_41985[(2)]);
var state_41985__$1 = state_41985;
var statearr_42000_43316 = state_41985__$1;
(statearr_42000_43316[(2)] = inst_41981);

(statearr_42000_43316[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41986 === (8))){
var inst_41962 = (state_41985[(7)]);
var inst_41972 = cljs.core.next(inst_41962);
var inst_41962__$1 = inst_41972;
var state_41985__$1 = (function (){var statearr_42001 = state_41985;
(statearr_42001[(7)] = inst_41962__$1);

return statearr_42001;
})();
var statearr_42002_43317 = state_41985__$1;
(statearr_42002_43317[(2)] = null);

(statearr_42002_43317[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41284__auto__ = null;
var cljs$core$async$state_machine__41284__auto____0 = (function (){
var statearr_42003 = [null,null,null,null,null,null,null,null];
(statearr_42003[(0)] = cljs$core$async$state_machine__41284__auto__);

(statearr_42003[(1)] = (1));

return statearr_42003;
});
var cljs$core$async$state_machine__41284__auto____1 = (function (state_41985){
while(true){
var ret_value__41285__auto__ = (function (){try{while(true){
var result__41286__auto__ = switch__41283__auto__(state_41985);
if(cljs.core.keyword_identical_QMARK_(result__41286__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41286__auto__;
}
break;
}
}catch (e42004){var ex__41287__auto__ = e42004;
var statearr_42005_43318 = state_41985;
(statearr_42005_43318[(2)] = ex__41287__auto__);


if(cljs.core.seq((state_41985[(4)]))){
var statearr_42006_43319 = state_41985;
(statearr_42006_43319[(1)] = cljs.core.first((state_41985[(4)])));

} else {
throw ex__41287__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41285__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43321 = state_41985;
state_41985 = G__43321;
continue;
} else {
return ret_value__41285__auto__;
}
break;
}
});
cljs$core$async$state_machine__41284__auto__ = function(state_41985){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41284__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41284__auto____1.call(this,state_41985);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41284__auto____0;
cljs$core$async$state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41284__auto____1;
return cljs$core$async$state_machine__41284__auto__;
})()
})();
var state__41389__auto__ = (function (){var statearr_42007 = f__41388__auto__();
(statearr_42007[(6)] = c__41387__auto__);

return statearr_42007;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41389__auto__);
}));

return c__41387__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__42009 = arguments.length;
switch (G__42009) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_43325 = (function (_){
var x__5350__auto__ = (((_ == null))?null:_);
var m__5351__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5351__auto__.call(null,_));
} else {
var m__5349__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5349__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_43325(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_43326 = (function (m,ch,close_QMARK_){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5351__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__5349__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5349__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_43326(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_43327 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null,m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_43327(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_43329 = (function (m){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5351__auto__.call(null,m));
} else {
var m__5349__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5349__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_43329(m);
}
});


/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42010 = (function (ch,cs,meta42011){
this.ch = ch;
this.cs = cs;
this.meta42011 = meta42011;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async42010.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42012,meta42011__$1){
var self__ = this;
var _42012__$1 = this;
return (new cljs.core.async.t_cljs$core$async42010(self__.ch,self__.cs,meta42011__$1));
}));

(cljs.core.async.t_cljs$core$async42010.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42012){
var self__ = this;
var _42012__$1 = this;
return self__.meta42011;
}));

(cljs.core.async.t_cljs$core$async42010.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42010.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async42010.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42010.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async42010.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async42010.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async42010.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta42011","meta42011",1673172523,null)], null);
}));

(cljs.core.async.t_cljs$core$async42010.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async42010.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42010");

(cljs.core.async.t_cljs$core$async42010.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async42010");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async42010.
 */
cljs.core.async.__GT_t_cljs$core$async42010 = (function cljs$core$async$__GT_t_cljs$core$async42010(ch,cs,meta42011){
return (new cljs.core.async.t_cljs$core$async42010(ch,cs,meta42011));
});


/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (new cljs.core.async.t_cljs$core$async42010(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__41387__auto___43334 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41388__auto__ = (function (){var switch__41283__auto__ = (function (state_42145){
var state_val_42146 = (state_42145[(1)]);
if((state_val_42146 === (7))){
var inst_42141 = (state_42145[(2)]);
var state_42145__$1 = state_42145;
var statearr_42147_43335 = state_42145__$1;
(statearr_42147_43335[(2)] = inst_42141);

(statearr_42147_43335[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (20))){
var inst_42046 = (state_42145[(7)]);
var inst_42058 = cljs.core.first(inst_42046);
var inst_42059 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42058,(0),null);
var inst_42060 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42058,(1),null);
var state_42145__$1 = (function (){var statearr_42148 = state_42145;
(statearr_42148[(8)] = inst_42059);

return statearr_42148;
})();
if(cljs.core.truth_(inst_42060)){
var statearr_42149_43336 = state_42145__$1;
(statearr_42149_43336[(1)] = (22));

} else {
var statearr_42150_43337 = state_42145__$1;
(statearr_42150_43337[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (27))){
var inst_42088 = (state_42145[(9)]);
var inst_42090 = (state_42145[(10)]);
var inst_42095 = (state_42145[(11)]);
var inst_42015 = (state_42145[(12)]);
var inst_42095__$1 = cljs.core._nth(inst_42088,inst_42090);
var inst_42096 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_42095__$1,inst_42015,done);
var state_42145__$1 = (function (){var statearr_42151 = state_42145;
(statearr_42151[(11)] = inst_42095__$1);

return statearr_42151;
})();
if(cljs.core.truth_(inst_42096)){
var statearr_42152_43339 = state_42145__$1;
(statearr_42152_43339[(1)] = (30));

} else {
var statearr_42153_43341 = state_42145__$1;
(statearr_42153_43341[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (1))){
var state_42145__$1 = state_42145;
var statearr_42154_43342 = state_42145__$1;
(statearr_42154_43342[(2)] = null);

(statearr_42154_43342[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (24))){
var inst_42046 = (state_42145[(7)]);
var inst_42065 = (state_42145[(2)]);
var inst_42066 = cljs.core.next(inst_42046);
var inst_42024 = inst_42066;
var inst_42025 = null;
var inst_42026 = (0);
var inst_42027 = (0);
var state_42145__$1 = (function (){var statearr_42155 = state_42145;
(statearr_42155[(13)] = inst_42065);

(statearr_42155[(14)] = inst_42024);

(statearr_42155[(15)] = inst_42025);

(statearr_42155[(16)] = inst_42026);

(statearr_42155[(17)] = inst_42027);

return statearr_42155;
})();
var statearr_42156_43343 = state_42145__$1;
(statearr_42156_43343[(2)] = null);

(statearr_42156_43343[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (39))){
var state_42145__$1 = state_42145;
var statearr_42160_43344 = state_42145__$1;
(statearr_42160_43344[(2)] = null);

(statearr_42160_43344[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (4))){
var inst_42015 = (state_42145[(12)]);
var inst_42015__$1 = (state_42145[(2)]);
var inst_42016 = (inst_42015__$1 == null);
var state_42145__$1 = (function (){var statearr_42161 = state_42145;
(statearr_42161[(12)] = inst_42015__$1);

return statearr_42161;
})();
if(cljs.core.truth_(inst_42016)){
var statearr_42162_43346 = state_42145__$1;
(statearr_42162_43346[(1)] = (5));

} else {
var statearr_42163_43348 = state_42145__$1;
(statearr_42163_43348[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (15))){
var inst_42027 = (state_42145[(17)]);
var inst_42024 = (state_42145[(14)]);
var inst_42025 = (state_42145[(15)]);
var inst_42026 = (state_42145[(16)]);
var inst_42042 = (state_42145[(2)]);
var inst_42043 = (inst_42027 + (1));
var tmp42157 = inst_42026;
var tmp42158 = inst_42025;
var tmp42159 = inst_42024;
var inst_42024__$1 = tmp42159;
var inst_42025__$1 = tmp42158;
var inst_42026__$1 = tmp42157;
var inst_42027__$1 = inst_42043;
var state_42145__$1 = (function (){var statearr_42164 = state_42145;
(statearr_42164[(18)] = inst_42042);

(statearr_42164[(14)] = inst_42024__$1);

(statearr_42164[(15)] = inst_42025__$1);

(statearr_42164[(16)] = inst_42026__$1);

(statearr_42164[(17)] = inst_42027__$1);

return statearr_42164;
})();
var statearr_42165_43349 = state_42145__$1;
(statearr_42165_43349[(2)] = null);

(statearr_42165_43349[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (21))){
var inst_42069 = (state_42145[(2)]);
var state_42145__$1 = state_42145;
var statearr_42169_43351 = state_42145__$1;
(statearr_42169_43351[(2)] = inst_42069);

(statearr_42169_43351[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (31))){
var inst_42095 = (state_42145[(11)]);
var inst_42099 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_42095);
var state_42145__$1 = state_42145;
var statearr_42170_43352 = state_42145__$1;
(statearr_42170_43352[(2)] = inst_42099);

(statearr_42170_43352[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (32))){
var inst_42090 = (state_42145[(10)]);
var inst_42087 = (state_42145[(19)]);
var inst_42088 = (state_42145[(9)]);
var inst_42089 = (state_42145[(20)]);
var inst_42101 = (state_42145[(2)]);
var inst_42102 = (inst_42090 + (1));
var tmp42166 = inst_42089;
var tmp42167 = inst_42088;
var tmp42168 = inst_42087;
var inst_42087__$1 = tmp42168;
var inst_42088__$1 = tmp42167;
var inst_42089__$1 = tmp42166;
var inst_42090__$1 = inst_42102;
var state_42145__$1 = (function (){var statearr_42171 = state_42145;
(statearr_42171[(21)] = inst_42101);

(statearr_42171[(19)] = inst_42087__$1);

(statearr_42171[(9)] = inst_42088__$1);

(statearr_42171[(20)] = inst_42089__$1);

(statearr_42171[(10)] = inst_42090__$1);

return statearr_42171;
})();
var statearr_42172_43356 = state_42145__$1;
(statearr_42172_43356[(2)] = null);

(statearr_42172_43356[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (40))){
var inst_42114 = (state_42145[(22)]);
var inst_42118 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_42114);
var state_42145__$1 = state_42145;
var statearr_42173_43357 = state_42145__$1;
(statearr_42173_43357[(2)] = inst_42118);

(statearr_42173_43357[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (33))){
var inst_42105 = (state_42145[(23)]);
var inst_42107 = cljs.core.chunked_seq_QMARK_(inst_42105);
var state_42145__$1 = state_42145;
if(inst_42107){
var statearr_42174_43358 = state_42145__$1;
(statearr_42174_43358[(1)] = (36));

} else {
var statearr_42175_43359 = state_42145__$1;
(statearr_42175_43359[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (13))){
var inst_42036 = (state_42145[(24)]);
var inst_42039 = cljs.core.async.close_BANG_(inst_42036);
var state_42145__$1 = state_42145;
var statearr_42176_43360 = state_42145__$1;
(statearr_42176_43360[(2)] = inst_42039);

(statearr_42176_43360[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (22))){
var inst_42059 = (state_42145[(8)]);
var inst_42062 = cljs.core.async.close_BANG_(inst_42059);
var state_42145__$1 = state_42145;
var statearr_42177_43361 = state_42145__$1;
(statearr_42177_43361[(2)] = inst_42062);

(statearr_42177_43361[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (36))){
var inst_42105 = (state_42145[(23)]);
var inst_42109 = cljs.core.chunk_first(inst_42105);
var inst_42110 = cljs.core.chunk_rest(inst_42105);
var inst_42111 = cljs.core.count(inst_42109);
var inst_42087 = inst_42110;
var inst_42088 = inst_42109;
var inst_42089 = inst_42111;
var inst_42090 = (0);
var state_42145__$1 = (function (){var statearr_42178 = state_42145;
(statearr_42178[(19)] = inst_42087);

(statearr_42178[(9)] = inst_42088);

(statearr_42178[(20)] = inst_42089);

(statearr_42178[(10)] = inst_42090);

return statearr_42178;
})();
var statearr_42179_43362 = state_42145__$1;
(statearr_42179_43362[(2)] = null);

(statearr_42179_43362[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (41))){
var inst_42105 = (state_42145[(23)]);
var inst_42120 = (state_42145[(2)]);
var inst_42121 = cljs.core.next(inst_42105);
var inst_42087 = inst_42121;
var inst_42088 = null;
var inst_42089 = (0);
var inst_42090 = (0);
var state_42145__$1 = (function (){var statearr_42180 = state_42145;
(statearr_42180[(25)] = inst_42120);

(statearr_42180[(19)] = inst_42087);

(statearr_42180[(9)] = inst_42088);

(statearr_42180[(20)] = inst_42089);

(statearr_42180[(10)] = inst_42090);

return statearr_42180;
})();
var statearr_42181_43363 = state_42145__$1;
(statearr_42181_43363[(2)] = null);

(statearr_42181_43363[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (43))){
var state_42145__$1 = state_42145;
var statearr_42182_43364 = state_42145__$1;
(statearr_42182_43364[(2)] = null);

(statearr_42182_43364[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (29))){
var inst_42129 = (state_42145[(2)]);
var state_42145__$1 = state_42145;
var statearr_42183_43365 = state_42145__$1;
(statearr_42183_43365[(2)] = inst_42129);

(statearr_42183_43365[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (44))){
var inst_42138 = (state_42145[(2)]);
var state_42145__$1 = (function (){var statearr_42184 = state_42145;
(statearr_42184[(26)] = inst_42138);

return statearr_42184;
})();
var statearr_42185_43366 = state_42145__$1;
(statearr_42185_43366[(2)] = null);

(statearr_42185_43366[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (6))){
var inst_42079 = (state_42145[(27)]);
var inst_42078 = cljs.core.deref(cs);
var inst_42079__$1 = cljs.core.keys(inst_42078);
var inst_42080 = cljs.core.count(inst_42079__$1);
var inst_42081 = cljs.core.reset_BANG_(dctr,inst_42080);
var inst_42086 = cljs.core.seq(inst_42079__$1);
var inst_42087 = inst_42086;
var inst_42088 = null;
var inst_42089 = (0);
var inst_42090 = (0);
var state_42145__$1 = (function (){var statearr_42186 = state_42145;
(statearr_42186[(27)] = inst_42079__$1);

(statearr_42186[(28)] = inst_42081);

(statearr_42186[(19)] = inst_42087);

(statearr_42186[(9)] = inst_42088);

(statearr_42186[(20)] = inst_42089);

(statearr_42186[(10)] = inst_42090);

return statearr_42186;
})();
var statearr_42187_43368 = state_42145__$1;
(statearr_42187_43368[(2)] = null);

(statearr_42187_43368[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (28))){
var inst_42087 = (state_42145[(19)]);
var inst_42105 = (state_42145[(23)]);
var inst_42105__$1 = cljs.core.seq(inst_42087);
var state_42145__$1 = (function (){var statearr_42188 = state_42145;
(statearr_42188[(23)] = inst_42105__$1);

return statearr_42188;
})();
if(inst_42105__$1){
var statearr_42189_43369 = state_42145__$1;
(statearr_42189_43369[(1)] = (33));

} else {
var statearr_42190_43370 = state_42145__$1;
(statearr_42190_43370[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (25))){
var inst_42090 = (state_42145[(10)]);
var inst_42089 = (state_42145[(20)]);
var inst_42092 = (inst_42090 < inst_42089);
var inst_42093 = inst_42092;
var state_42145__$1 = state_42145;
if(cljs.core.truth_(inst_42093)){
var statearr_42191_43374 = state_42145__$1;
(statearr_42191_43374[(1)] = (27));

} else {
var statearr_42192_43375 = state_42145__$1;
(statearr_42192_43375[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (34))){
var state_42145__$1 = state_42145;
var statearr_42193_43376 = state_42145__$1;
(statearr_42193_43376[(2)] = null);

(statearr_42193_43376[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (17))){
var state_42145__$1 = state_42145;
var statearr_42194_43377 = state_42145__$1;
(statearr_42194_43377[(2)] = null);

(statearr_42194_43377[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (3))){
var inst_42143 = (state_42145[(2)]);
var state_42145__$1 = state_42145;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42145__$1,inst_42143);
} else {
if((state_val_42146 === (12))){
var inst_42074 = (state_42145[(2)]);
var state_42145__$1 = state_42145;
var statearr_42195_43378 = state_42145__$1;
(statearr_42195_43378[(2)] = inst_42074);

(statearr_42195_43378[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (2))){
var state_42145__$1 = state_42145;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42145__$1,(4),ch);
} else {
if((state_val_42146 === (23))){
var state_42145__$1 = state_42145;
var statearr_42196_43379 = state_42145__$1;
(statearr_42196_43379[(2)] = null);

(statearr_42196_43379[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (35))){
var inst_42127 = (state_42145[(2)]);
var state_42145__$1 = state_42145;
var statearr_42197_43380 = state_42145__$1;
(statearr_42197_43380[(2)] = inst_42127);

(statearr_42197_43380[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (19))){
var inst_42046 = (state_42145[(7)]);
var inst_42050 = cljs.core.chunk_first(inst_42046);
var inst_42051 = cljs.core.chunk_rest(inst_42046);
var inst_42052 = cljs.core.count(inst_42050);
var inst_42024 = inst_42051;
var inst_42025 = inst_42050;
var inst_42026 = inst_42052;
var inst_42027 = (0);
var state_42145__$1 = (function (){var statearr_42198 = state_42145;
(statearr_42198[(14)] = inst_42024);

(statearr_42198[(15)] = inst_42025);

(statearr_42198[(16)] = inst_42026);

(statearr_42198[(17)] = inst_42027);

return statearr_42198;
})();
var statearr_42199_43381 = state_42145__$1;
(statearr_42199_43381[(2)] = null);

(statearr_42199_43381[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (11))){
var inst_42024 = (state_42145[(14)]);
var inst_42046 = (state_42145[(7)]);
var inst_42046__$1 = cljs.core.seq(inst_42024);
var state_42145__$1 = (function (){var statearr_42200 = state_42145;
(statearr_42200[(7)] = inst_42046__$1);

return statearr_42200;
})();
if(inst_42046__$1){
var statearr_42201_43386 = state_42145__$1;
(statearr_42201_43386[(1)] = (16));

} else {
var statearr_42202_43387 = state_42145__$1;
(statearr_42202_43387[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (9))){
var inst_42076 = (state_42145[(2)]);
var state_42145__$1 = state_42145;
var statearr_42203_43389 = state_42145__$1;
(statearr_42203_43389[(2)] = inst_42076);

(statearr_42203_43389[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (5))){
var inst_42022 = cljs.core.deref(cs);
var inst_42023 = cljs.core.seq(inst_42022);
var inst_42024 = inst_42023;
var inst_42025 = null;
var inst_42026 = (0);
var inst_42027 = (0);
var state_42145__$1 = (function (){var statearr_42204 = state_42145;
(statearr_42204[(14)] = inst_42024);

(statearr_42204[(15)] = inst_42025);

(statearr_42204[(16)] = inst_42026);

(statearr_42204[(17)] = inst_42027);

return statearr_42204;
})();
var statearr_42205_43390 = state_42145__$1;
(statearr_42205_43390[(2)] = null);

(statearr_42205_43390[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (14))){
var state_42145__$1 = state_42145;
var statearr_42206_43391 = state_42145__$1;
(statearr_42206_43391[(2)] = null);

(statearr_42206_43391[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (45))){
var inst_42135 = (state_42145[(2)]);
var state_42145__$1 = state_42145;
var statearr_42207_43392 = state_42145__$1;
(statearr_42207_43392[(2)] = inst_42135);

(statearr_42207_43392[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (26))){
var inst_42079 = (state_42145[(27)]);
var inst_42131 = (state_42145[(2)]);
var inst_42132 = cljs.core.seq(inst_42079);
var state_42145__$1 = (function (){var statearr_42208 = state_42145;
(statearr_42208[(29)] = inst_42131);

return statearr_42208;
})();
if(inst_42132){
var statearr_42209_43393 = state_42145__$1;
(statearr_42209_43393[(1)] = (42));

} else {
var statearr_42210_43394 = state_42145__$1;
(statearr_42210_43394[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (16))){
var inst_42046 = (state_42145[(7)]);
var inst_42048 = cljs.core.chunked_seq_QMARK_(inst_42046);
var state_42145__$1 = state_42145;
if(inst_42048){
var statearr_42211_43395 = state_42145__$1;
(statearr_42211_43395[(1)] = (19));

} else {
var statearr_42212_43396 = state_42145__$1;
(statearr_42212_43396[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (38))){
var inst_42124 = (state_42145[(2)]);
var state_42145__$1 = state_42145;
var statearr_42213_43397 = state_42145__$1;
(statearr_42213_43397[(2)] = inst_42124);

(statearr_42213_43397[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (30))){
var state_42145__$1 = state_42145;
var statearr_42214_43398 = state_42145__$1;
(statearr_42214_43398[(2)] = null);

(statearr_42214_43398[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (10))){
var inst_42025 = (state_42145[(15)]);
var inst_42027 = (state_42145[(17)]);
var inst_42035 = cljs.core._nth(inst_42025,inst_42027);
var inst_42036 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42035,(0),null);
var inst_42037 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42035,(1),null);
var state_42145__$1 = (function (){var statearr_42215 = state_42145;
(statearr_42215[(24)] = inst_42036);

return statearr_42215;
})();
if(cljs.core.truth_(inst_42037)){
var statearr_42216_43399 = state_42145__$1;
(statearr_42216_43399[(1)] = (13));

} else {
var statearr_42217_43400 = state_42145__$1;
(statearr_42217_43400[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (18))){
var inst_42072 = (state_42145[(2)]);
var state_42145__$1 = state_42145;
var statearr_42218_43401 = state_42145__$1;
(statearr_42218_43401[(2)] = inst_42072);

(statearr_42218_43401[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (42))){
var state_42145__$1 = state_42145;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42145__$1,(45),dchan);
} else {
if((state_val_42146 === (37))){
var inst_42105 = (state_42145[(23)]);
var inst_42114 = (state_42145[(22)]);
var inst_42015 = (state_42145[(12)]);
var inst_42114__$1 = cljs.core.first(inst_42105);
var inst_42115 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_42114__$1,inst_42015,done);
var state_42145__$1 = (function (){var statearr_42219 = state_42145;
(statearr_42219[(22)] = inst_42114__$1);

return statearr_42219;
})();
if(cljs.core.truth_(inst_42115)){
var statearr_42220_43403 = state_42145__$1;
(statearr_42220_43403[(1)] = (39));

} else {
var statearr_42221_43404 = state_42145__$1;
(statearr_42221_43404[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42146 === (8))){
var inst_42027 = (state_42145[(17)]);
var inst_42026 = (state_42145[(16)]);
var inst_42029 = (inst_42027 < inst_42026);
var inst_42030 = inst_42029;
var state_42145__$1 = state_42145;
if(cljs.core.truth_(inst_42030)){
var statearr_42222_43405 = state_42145__$1;
(statearr_42222_43405[(1)] = (10));

} else {
var statearr_42223_43406 = state_42145__$1;
(statearr_42223_43406[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__41284__auto__ = null;
var cljs$core$async$mult_$_state_machine__41284__auto____0 = (function (){
var statearr_42224 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42224[(0)] = cljs$core$async$mult_$_state_machine__41284__auto__);

(statearr_42224[(1)] = (1));

return statearr_42224;
});
var cljs$core$async$mult_$_state_machine__41284__auto____1 = (function (state_42145){
while(true){
var ret_value__41285__auto__ = (function (){try{while(true){
var result__41286__auto__ = switch__41283__auto__(state_42145);
if(cljs.core.keyword_identical_QMARK_(result__41286__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41286__auto__;
}
break;
}
}catch (e42225){var ex__41287__auto__ = e42225;
var statearr_42226_43411 = state_42145;
(statearr_42226_43411[(2)] = ex__41287__auto__);


if(cljs.core.seq((state_42145[(4)]))){
var statearr_42227_43412 = state_42145;
(statearr_42227_43412[(1)] = cljs.core.first((state_42145[(4)])));

} else {
throw ex__41287__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41285__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43413 = state_42145;
state_42145 = G__43413;
continue;
} else {
return ret_value__41285__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__41284__auto__ = function(state_42145){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__41284__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__41284__auto____1.call(this,state_42145);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__41284__auto____0;
cljs$core$async$mult_$_state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__41284__auto____1;
return cljs$core$async$mult_$_state_machine__41284__auto__;
})()
})();
var state__41389__auto__ = (function (){var statearr_42228 = f__41388__auto__();
(statearr_42228[(6)] = c__41387__auto___43334);

return statearr_42228;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41389__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__42232 = arguments.length;
switch (G__42232) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_43415 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null,m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_43415(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_43417 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null,m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_43417(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_43421 = (function (m){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5351__auto__.call(null,m));
} else {
var m__5349__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5349__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_43421(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_43422 = (function (m,state_map){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5351__auto__.call(null,m,state_map));
} else {
var m__5349__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5349__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_43422(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_43424 = (function (m,mode){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5351__auto__.call(null,m,mode));
} else {
var m__5349__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5349__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_43424(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5732__auto__ = [];
var len__5726__auto___43428 = arguments.length;
var i__5727__auto___43429 = (0);
while(true){
if((i__5727__auto___43429 < len__5726__auto___43428)){
args__5732__auto__.push((arguments[i__5727__auto___43429]));

var G__43430 = (i__5727__auto___43429 + (1));
i__5727__auto___43429 = G__43430;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((3) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5733__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__42259){
var map__42260 = p__42259;
var map__42260__$1 = cljs.core.__destructure_map(map__42260);
var opts = map__42260__$1;
var statearr_42263_43431 = state;
(statearr_42263_43431[(1)] = cont_block);


var temp__5823__auto__ = cljs.core.async.do_alts((function (val){
var statearr_42266_43432 = state;
(statearr_42266_43432[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5823__auto__)){
var cb = temp__5823__auto__;
var statearr_42268_43433 = state;
(statearr_42268_43433[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq42255){
var G__42256 = cljs.core.first(seq42255);
var seq42255__$1 = cljs.core.next(seq42255);
var G__42257 = cljs.core.first(seq42255__$1);
var seq42255__$2 = cljs.core.next(seq42255__$1);
var G__42258 = cljs.core.first(seq42255__$2);
var seq42255__$3 = cljs.core.next(seq42255__$2);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__42256,G__42257,G__42258,seq42255__$3);
}));


/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42275 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta42276){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta42276 = meta42276;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async42275.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42277,meta42276__$1){
var self__ = this;
var _42277__$1 = this;
return (new cljs.core.async.t_cljs$core$async42275(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta42276__$1));
}));

(cljs.core.async.t_cljs$core$async42275.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42277){
var self__ = this;
var _42277__$1 = this;
return self__.meta42276;
}));

(cljs.core.async.t_cljs$core$async42275.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42275.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async42275.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42275.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async42275.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async42275.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async42275.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async42275.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async42275.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta42276","meta42276",644966459,null)], null);
}));

(cljs.core.async.t_cljs$core$async42275.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async42275.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42275");

(cljs.core.async.t_cljs$core$async42275.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async42275");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async42275.
 */
cljs.core.async.__GT_t_cljs$core$async42275 = (function cljs$core$async$__GT_t_cljs$core$async42275(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta42276){
return (new cljs.core.async.t_cljs$core$async42275(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta42276));
});


/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (cljs.core.seq(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (new cljs.core.async.t_cljs$core$async42275(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
var c__41387__auto___43440 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41388__auto__ = (function (){var switch__41283__auto__ = (function (state_42360){
var state_val_42361 = (state_42360[(1)]);
if((state_val_42361 === (7))){
var inst_42316 = (state_42360[(2)]);
var state_42360__$1 = state_42360;
if(cljs.core.truth_(inst_42316)){
var statearr_42362_43441 = state_42360__$1;
(statearr_42362_43441[(1)] = (8));

} else {
var statearr_42363_43442 = state_42360__$1;
(statearr_42363_43442[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42361 === (20))){
var inst_42309 = (state_42360[(7)]);
var state_42360__$1 = state_42360;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42360__$1,(23),out,inst_42309);
} else {
if((state_val_42361 === (1))){
var inst_42290 = calc_state();
var inst_42291 = cljs.core.__destructure_map(inst_42290);
var inst_42292 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42291,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_42293 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42291,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_42294 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42291,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_42295 = inst_42290;
var state_42360__$1 = (function (){var statearr_42371 = state_42360;
(statearr_42371[(8)] = inst_42292);

(statearr_42371[(9)] = inst_42293);

(statearr_42371[(10)] = inst_42294);

(statearr_42371[(11)] = inst_42295);

return statearr_42371;
})();
var statearr_42372_43443 = state_42360__$1;
(statearr_42372_43443[(2)] = null);

(statearr_42372_43443[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42361 === (24))){
var inst_42298 = (state_42360[(12)]);
var inst_42295 = inst_42298;
var state_42360__$1 = (function (){var statearr_42373 = state_42360;
(statearr_42373[(11)] = inst_42295);

return statearr_42373;
})();
var statearr_42374_43444 = state_42360__$1;
(statearr_42374_43444[(2)] = null);

(statearr_42374_43444[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42361 === (4))){
var inst_42309 = (state_42360[(7)]);
var inst_42311 = (state_42360[(13)]);
var inst_42308 = (state_42360[(2)]);
var inst_42309__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42308,(0),null);
var inst_42310 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42308,(1),null);
var inst_42311__$1 = (inst_42309__$1 == null);
var state_42360__$1 = (function (){var statearr_42376 = state_42360;
(statearr_42376[(7)] = inst_42309__$1);

(statearr_42376[(14)] = inst_42310);

(statearr_42376[(13)] = inst_42311__$1);

return statearr_42376;
})();
if(cljs.core.truth_(inst_42311__$1)){
var statearr_42378_43445 = state_42360__$1;
(statearr_42378_43445[(1)] = (5));

} else {
var statearr_42379_43446 = state_42360__$1;
(statearr_42379_43446[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42361 === (15))){
var inst_42300 = (state_42360[(15)]);
var inst_42330 = (state_42360[(16)]);
var inst_42330__$1 = cljs.core.empty_QMARK_(inst_42300);
var state_42360__$1 = (function (){var statearr_42380 = state_42360;
(statearr_42380[(16)] = inst_42330__$1);

return statearr_42380;
})();
if(inst_42330__$1){
var statearr_42381_43451 = state_42360__$1;
(statearr_42381_43451[(1)] = (17));

} else {
var statearr_42382_43452 = state_42360__$1;
(statearr_42382_43452[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42361 === (21))){
var inst_42298 = (state_42360[(12)]);
var inst_42295 = inst_42298;
var state_42360__$1 = (function (){var statearr_42384 = state_42360;
(statearr_42384[(11)] = inst_42295);

return statearr_42384;
})();
var statearr_42385_43453 = state_42360__$1;
(statearr_42385_43453[(2)] = null);

(statearr_42385_43453[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42361 === (13))){
var inst_42323 = (state_42360[(2)]);
var inst_42324 = calc_state();
var inst_42295 = inst_42324;
var state_42360__$1 = (function (){var statearr_42386 = state_42360;
(statearr_42386[(17)] = inst_42323);

(statearr_42386[(11)] = inst_42295);

return statearr_42386;
})();
var statearr_42387_43455 = state_42360__$1;
(statearr_42387_43455[(2)] = null);

(statearr_42387_43455[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42361 === (22))){
var inst_42350 = (state_42360[(2)]);
var state_42360__$1 = state_42360;
var statearr_42388_43457 = state_42360__$1;
(statearr_42388_43457[(2)] = inst_42350);

(statearr_42388_43457[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42361 === (6))){
var inst_42310 = (state_42360[(14)]);
var inst_42314 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_42310,change);
var state_42360__$1 = state_42360;
var statearr_42389_43458 = state_42360__$1;
(statearr_42389_43458[(2)] = inst_42314);

(statearr_42389_43458[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42361 === (25))){
var state_42360__$1 = state_42360;
var statearr_42390_43459 = state_42360__$1;
(statearr_42390_43459[(2)] = null);

(statearr_42390_43459[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42361 === (17))){
var inst_42301 = (state_42360[(18)]);
var inst_42310 = (state_42360[(14)]);
var inst_42332 = (inst_42301.cljs$core$IFn$_invoke$arity$1 ? inst_42301.cljs$core$IFn$_invoke$arity$1(inst_42310) : inst_42301.call(null,inst_42310));
var inst_42333 = cljs.core.not(inst_42332);
var state_42360__$1 = state_42360;
var statearr_42391_43460 = state_42360__$1;
(statearr_42391_43460[(2)] = inst_42333);

(statearr_42391_43460[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42361 === (3))){
var inst_42354 = (state_42360[(2)]);
var state_42360__$1 = state_42360;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42360__$1,inst_42354);
} else {
if((state_val_42361 === (12))){
var state_42360__$1 = state_42360;
var statearr_42393_43461 = state_42360__$1;
(statearr_42393_43461[(2)] = null);

(statearr_42393_43461[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42361 === (2))){
var inst_42295 = (state_42360[(11)]);
var inst_42298 = (state_42360[(12)]);
var inst_42298__$1 = cljs.core.__destructure_map(inst_42295);
var inst_42300 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42298__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_42301 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42298__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_42303 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42298__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_42360__$1 = (function (){var statearr_42395 = state_42360;
(statearr_42395[(12)] = inst_42298__$1);

(statearr_42395[(15)] = inst_42300);

(statearr_42395[(18)] = inst_42301);

return statearr_42395;
})();
return cljs.core.async.ioc_alts_BANG_(state_42360__$1,(4),inst_42303);
} else {
if((state_val_42361 === (23))){
var inst_42341 = (state_42360[(2)]);
var state_42360__$1 = state_42360;
if(cljs.core.truth_(inst_42341)){
var statearr_42396_43462 = state_42360__$1;
(statearr_42396_43462[(1)] = (24));

} else {
var statearr_42397_43463 = state_42360__$1;
(statearr_42397_43463[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42361 === (19))){
var inst_42336 = (state_42360[(2)]);
var state_42360__$1 = state_42360;
var statearr_42398_43464 = state_42360__$1;
(statearr_42398_43464[(2)] = inst_42336);

(statearr_42398_43464[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42361 === (11))){
var inst_42310 = (state_42360[(14)]);
var inst_42320 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_42310);
var state_42360__$1 = state_42360;
var statearr_42402_43469 = state_42360__$1;
(statearr_42402_43469[(2)] = inst_42320);

(statearr_42402_43469[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42361 === (9))){
var inst_42300 = (state_42360[(15)]);
var inst_42310 = (state_42360[(14)]);
var inst_42327 = (state_42360[(19)]);
var inst_42327__$1 = (inst_42300.cljs$core$IFn$_invoke$arity$1 ? inst_42300.cljs$core$IFn$_invoke$arity$1(inst_42310) : inst_42300.call(null,inst_42310));
var state_42360__$1 = (function (){var statearr_42411 = state_42360;
(statearr_42411[(19)] = inst_42327__$1);

return statearr_42411;
})();
if(cljs.core.truth_(inst_42327__$1)){
var statearr_42416_43475 = state_42360__$1;
(statearr_42416_43475[(1)] = (14));

} else {
var statearr_42421_43476 = state_42360__$1;
(statearr_42421_43476[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42361 === (5))){
var inst_42311 = (state_42360[(13)]);
var state_42360__$1 = state_42360;
var statearr_42426_43477 = state_42360__$1;
(statearr_42426_43477[(2)] = inst_42311);

(statearr_42426_43477[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42361 === (14))){
var inst_42327 = (state_42360[(19)]);
var state_42360__$1 = state_42360;
var statearr_42427_43478 = state_42360__$1;
(statearr_42427_43478[(2)] = inst_42327);

(statearr_42427_43478[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42361 === (26))){
var inst_42346 = (state_42360[(2)]);
var state_42360__$1 = state_42360;
var statearr_42428_43479 = state_42360__$1;
(statearr_42428_43479[(2)] = inst_42346);

(statearr_42428_43479[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42361 === (16))){
var inst_42338 = (state_42360[(2)]);
var state_42360__$1 = state_42360;
if(cljs.core.truth_(inst_42338)){
var statearr_42429_43480 = state_42360__$1;
(statearr_42429_43480[(1)] = (20));

} else {
var statearr_42430_43481 = state_42360__$1;
(statearr_42430_43481[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42361 === (10))){
var inst_42352 = (state_42360[(2)]);
var state_42360__$1 = state_42360;
var statearr_42431_43482 = state_42360__$1;
(statearr_42431_43482[(2)] = inst_42352);

(statearr_42431_43482[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42361 === (18))){
var inst_42330 = (state_42360[(16)]);
var state_42360__$1 = state_42360;
var statearr_42432_43483 = state_42360__$1;
(statearr_42432_43483[(2)] = inst_42330);

(statearr_42432_43483[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42361 === (8))){
var inst_42309 = (state_42360[(7)]);
var inst_42318 = (inst_42309 == null);
var state_42360__$1 = state_42360;
if(cljs.core.truth_(inst_42318)){
var statearr_42433_43484 = state_42360__$1;
(statearr_42433_43484[(1)] = (11));

} else {
var statearr_42434_43485 = state_42360__$1;
(statearr_42434_43485[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__41284__auto__ = null;
var cljs$core$async$mix_$_state_machine__41284__auto____0 = (function (){
var statearr_42437 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42437[(0)] = cljs$core$async$mix_$_state_machine__41284__auto__);

(statearr_42437[(1)] = (1));

return statearr_42437;
});
var cljs$core$async$mix_$_state_machine__41284__auto____1 = (function (state_42360){
while(true){
var ret_value__41285__auto__ = (function (){try{while(true){
var result__41286__auto__ = switch__41283__auto__(state_42360);
if(cljs.core.keyword_identical_QMARK_(result__41286__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41286__auto__;
}
break;
}
}catch (e42438){var ex__41287__auto__ = e42438;
var statearr_42439_43486 = state_42360;
(statearr_42439_43486[(2)] = ex__41287__auto__);


if(cljs.core.seq((state_42360[(4)]))){
var statearr_42440_43490 = state_42360;
(statearr_42440_43490[(1)] = cljs.core.first((state_42360[(4)])));

} else {
throw ex__41287__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41285__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43491 = state_42360;
state_42360 = G__43491;
continue;
} else {
return ret_value__41285__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__41284__auto__ = function(state_42360){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__41284__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__41284__auto____1.call(this,state_42360);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__41284__auto____0;
cljs$core$async$mix_$_state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__41284__auto____1;
return cljs$core$async$mix_$_state_machine__41284__auto__;
})()
})();
var state__41389__auto__ = (function (){var statearr_42441 = f__41388__auto__();
(statearr_42441[(6)] = c__41387__auto___43440);

return statearr_42441;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41389__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_43492 = (function (p,v,ch,close_QMARK_){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5351__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__5349__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5349__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_43492(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_43493 = (function (p,v,ch){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5351__auto__.call(null,p,v,ch));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5349__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_43493(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_43497 = (function() {
var G__43498 = null;
var G__43498__1 = (function (p){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5351__auto__.call(null,p));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5349__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__43498__2 = (function (p,v){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5351__auto__.call(null,p,v));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5349__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__43498 = function(p,v){
switch(arguments.length){
case 1:
return G__43498__1.call(this,p);
case 2:
return G__43498__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__43498.cljs$core$IFn$_invoke$arity$1 = G__43498__1;
G__43498.cljs$core$IFn$_invoke$arity$2 = G__43498__2;
return G__43498;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__42463 = arguments.length;
switch (G__42463) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_43497(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_43497(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);



/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42467 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta42468){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta42468 = meta42468;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async42467.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42469,meta42468__$1){
var self__ = this;
var _42469__$1 = this;
return (new cljs.core.async.t_cljs$core$async42467(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta42468__$1));
}));

(cljs.core.async.t_cljs$core$async42467.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42469){
var self__ = this;
var _42469__$1 = this;
return self__.meta42468;
}));

(cljs.core.async.t_cljs$core$async42467.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42467.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async42467.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42467.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async42467.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5823__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5823__auto__)){
var m = temp__5823__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async42467.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async42467.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async42467.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta42468","meta42468",-438007804,null)], null);
}));

(cljs.core.async.t_cljs$core$async42467.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async42467.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42467");

(cljs.core.async.t_cljs$core$async42467.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async42467");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async42467.
 */
cljs.core.async.__GT_t_cljs$core$async42467 = (function cljs$core$async$__GT_t_cljs$core$async42467(ch,topic_fn,buf_fn,mults,ensure_mult,meta42468){
return (new cljs.core.async.t_cljs$core$async42467(ch,topic_fn,buf_fn,mults,ensure_mult,meta42468));
});


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__42466 = arguments.length;
switch (G__42466) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__5002__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__42464_SHARP_){
if(cljs.core.truth_((p1__42464_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__42464_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__42464_SHARP_.call(null,topic)))){
return p1__42464_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__42464_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (new cljs.core.async.t_cljs$core$async42467(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
var c__41387__auto___43506 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41388__auto__ = (function (){var switch__41283__auto__ = (function (state_42541){
var state_val_42542 = (state_42541[(1)]);
if((state_val_42542 === (7))){
var inst_42537 = (state_42541[(2)]);
var state_42541__$1 = state_42541;
var statearr_42543_43507 = state_42541__$1;
(statearr_42543_43507[(2)] = inst_42537);

(statearr_42543_43507[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42542 === (20))){
var state_42541__$1 = state_42541;
var statearr_42544_43508 = state_42541__$1;
(statearr_42544_43508[(2)] = null);

(statearr_42544_43508[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42542 === (1))){
var state_42541__$1 = state_42541;
var statearr_42545_43509 = state_42541__$1;
(statearr_42545_43509[(2)] = null);

(statearr_42545_43509[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42542 === (24))){
var inst_42520 = (state_42541[(7)]);
var inst_42529 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_42520);
var state_42541__$1 = state_42541;
var statearr_42546_43510 = state_42541__$1;
(statearr_42546_43510[(2)] = inst_42529);

(statearr_42546_43510[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42542 === (4))){
var inst_42472 = (state_42541[(8)]);
var inst_42472__$1 = (state_42541[(2)]);
var inst_42473 = (inst_42472__$1 == null);
var state_42541__$1 = (function (){var statearr_42547 = state_42541;
(statearr_42547[(8)] = inst_42472__$1);

return statearr_42547;
})();
if(cljs.core.truth_(inst_42473)){
var statearr_42548_43513 = state_42541__$1;
(statearr_42548_43513[(1)] = (5));

} else {
var statearr_42549_43515 = state_42541__$1;
(statearr_42549_43515[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42542 === (15))){
var inst_42514 = (state_42541[(2)]);
var state_42541__$1 = state_42541;
var statearr_42550_43520 = state_42541__$1;
(statearr_42550_43520[(2)] = inst_42514);

(statearr_42550_43520[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42542 === (21))){
var inst_42534 = (state_42541[(2)]);
var state_42541__$1 = (function (){var statearr_42551 = state_42541;
(statearr_42551[(9)] = inst_42534);

return statearr_42551;
})();
var statearr_42552_43521 = state_42541__$1;
(statearr_42552_43521[(2)] = null);

(statearr_42552_43521[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42542 === (13))){
var inst_42496 = (state_42541[(10)]);
var inst_42498 = cljs.core.chunked_seq_QMARK_(inst_42496);
var state_42541__$1 = state_42541;
if(inst_42498){
var statearr_42553_43522 = state_42541__$1;
(statearr_42553_43522[(1)] = (16));

} else {
var statearr_42554_43523 = state_42541__$1;
(statearr_42554_43523[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42542 === (22))){
var inst_42526 = (state_42541[(2)]);
var state_42541__$1 = state_42541;
if(cljs.core.truth_(inst_42526)){
var statearr_42555_43524 = state_42541__$1;
(statearr_42555_43524[(1)] = (23));

} else {
var statearr_42556_43525 = state_42541__$1;
(statearr_42556_43525[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42542 === (6))){
var inst_42472 = (state_42541[(8)]);
var inst_42520 = (state_42541[(7)]);
var inst_42522 = (state_42541[(11)]);
var inst_42520__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_42472) : topic_fn.call(null,inst_42472));
var inst_42521 = cljs.core.deref(mults);
var inst_42522__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42521,inst_42520__$1);
var state_42541__$1 = (function (){var statearr_42557 = state_42541;
(statearr_42557[(7)] = inst_42520__$1);

(statearr_42557[(11)] = inst_42522__$1);

return statearr_42557;
})();
if(cljs.core.truth_(inst_42522__$1)){
var statearr_42558_43529 = state_42541__$1;
(statearr_42558_43529[(1)] = (19));

} else {
var statearr_42559_43530 = state_42541__$1;
(statearr_42559_43530[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42542 === (25))){
var inst_42531 = (state_42541[(2)]);
var state_42541__$1 = state_42541;
var statearr_42560_43531 = state_42541__$1;
(statearr_42560_43531[(2)] = inst_42531);

(statearr_42560_43531[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42542 === (17))){
var inst_42496 = (state_42541[(10)]);
var inst_42505 = cljs.core.first(inst_42496);
var inst_42506 = cljs.core.async.muxch_STAR_(inst_42505);
var inst_42507 = cljs.core.async.close_BANG_(inst_42506);
var inst_42508 = cljs.core.next(inst_42496);
var inst_42482 = inst_42508;
var inst_42483 = null;
var inst_42484 = (0);
var inst_42485 = (0);
var state_42541__$1 = (function (){var statearr_42561 = state_42541;
(statearr_42561[(12)] = inst_42507);

(statearr_42561[(13)] = inst_42482);

(statearr_42561[(14)] = inst_42483);

(statearr_42561[(15)] = inst_42484);

(statearr_42561[(16)] = inst_42485);

return statearr_42561;
})();
var statearr_42562_43535 = state_42541__$1;
(statearr_42562_43535[(2)] = null);

(statearr_42562_43535[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42542 === (3))){
var inst_42539 = (state_42541[(2)]);
var state_42541__$1 = state_42541;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42541__$1,inst_42539);
} else {
if((state_val_42542 === (12))){
var inst_42516 = (state_42541[(2)]);
var state_42541__$1 = state_42541;
var statearr_42563_43536 = state_42541__$1;
(statearr_42563_43536[(2)] = inst_42516);

(statearr_42563_43536[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42542 === (2))){
var state_42541__$1 = state_42541;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42541__$1,(4),ch);
} else {
if((state_val_42542 === (23))){
var state_42541__$1 = state_42541;
var statearr_42564_43537 = state_42541__$1;
(statearr_42564_43537[(2)] = null);

(statearr_42564_43537[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42542 === (19))){
var inst_42522 = (state_42541[(11)]);
var inst_42472 = (state_42541[(8)]);
var inst_42524 = cljs.core.async.muxch_STAR_(inst_42522);
var state_42541__$1 = state_42541;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42541__$1,(22),inst_42524,inst_42472);
} else {
if((state_val_42542 === (11))){
var inst_42482 = (state_42541[(13)]);
var inst_42496 = (state_42541[(10)]);
var inst_42496__$1 = cljs.core.seq(inst_42482);
var state_42541__$1 = (function (){var statearr_42565 = state_42541;
(statearr_42565[(10)] = inst_42496__$1);

return statearr_42565;
})();
if(inst_42496__$1){
var statearr_42566_43538 = state_42541__$1;
(statearr_42566_43538[(1)] = (13));

} else {
var statearr_42567_43540 = state_42541__$1;
(statearr_42567_43540[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42542 === (9))){
var inst_42518 = (state_42541[(2)]);
var state_42541__$1 = state_42541;
var statearr_42568_43541 = state_42541__$1;
(statearr_42568_43541[(2)] = inst_42518);

(statearr_42568_43541[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42542 === (5))){
var inst_42479 = cljs.core.deref(mults);
var inst_42480 = cljs.core.vals(inst_42479);
var inst_42481 = cljs.core.seq(inst_42480);
var inst_42482 = inst_42481;
var inst_42483 = null;
var inst_42484 = (0);
var inst_42485 = (0);
var state_42541__$1 = (function (){var statearr_42569 = state_42541;
(statearr_42569[(13)] = inst_42482);

(statearr_42569[(14)] = inst_42483);

(statearr_42569[(15)] = inst_42484);

(statearr_42569[(16)] = inst_42485);

return statearr_42569;
})();
var statearr_42570_43545 = state_42541__$1;
(statearr_42570_43545[(2)] = null);

(statearr_42570_43545[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42542 === (14))){
var state_42541__$1 = state_42541;
var statearr_42574_43546 = state_42541__$1;
(statearr_42574_43546[(2)] = null);

(statearr_42574_43546[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42542 === (16))){
var inst_42496 = (state_42541[(10)]);
var inst_42500 = cljs.core.chunk_first(inst_42496);
var inst_42501 = cljs.core.chunk_rest(inst_42496);
var inst_42502 = cljs.core.count(inst_42500);
var inst_42482 = inst_42501;
var inst_42483 = inst_42500;
var inst_42484 = inst_42502;
var inst_42485 = (0);
var state_42541__$1 = (function (){var statearr_42575 = state_42541;
(statearr_42575[(13)] = inst_42482);

(statearr_42575[(14)] = inst_42483);

(statearr_42575[(15)] = inst_42484);

(statearr_42575[(16)] = inst_42485);

return statearr_42575;
})();
var statearr_42576_43548 = state_42541__$1;
(statearr_42576_43548[(2)] = null);

(statearr_42576_43548[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42542 === (10))){
var inst_42483 = (state_42541[(14)]);
var inst_42485 = (state_42541[(16)]);
var inst_42482 = (state_42541[(13)]);
var inst_42484 = (state_42541[(15)]);
var inst_42490 = cljs.core._nth(inst_42483,inst_42485);
var inst_42491 = cljs.core.async.muxch_STAR_(inst_42490);
var inst_42492 = cljs.core.async.close_BANG_(inst_42491);
var inst_42493 = (inst_42485 + (1));
var tmp42571 = inst_42482;
var tmp42572 = inst_42484;
var tmp42573 = inst_42483;
var inst_42482__$1 = tmp42571;
var inst_42483__$1 = tmp42573;
var inst_42484__$1 = tmp42572;
var inst_42485__$1 = inst_42493;
var state_42541__$1 = (function (){var statearr_42577 = state_42541;
(statearr_42577[(17)] = inst_42492);

(statearr_42577[(13)] = inst_42482__$1);

(statearr_42577[(14)] = inst_42483__$1);

(statearr_42577[(15)] = inst_42484__$1);

(statearr_42577[(16)] = inst_42485__$1);

return statearr_42577;
})();
var statearr_42578_43552 = state_42541__$1;
(statearr_42578_43552[(2)] = null);

(statearr_42578_43552[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42542 === (18))){
var inst_42511 = (state_42541[(2)]);
var state_42541__$1 = state_42541;
var statearr_42579_43553 = state_42541__$1;
(statearr_42579_43553[(2)] = inst_42511);

(statearr_42579_43553[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42542 === (8))){
var inst_42485 = (state_42541[(16)]);
var inst_42484 = (state_42541[(15)]);
var inst_42487 = (inst_42485 < inst_42484);
var inst_42488 = inst_42487;
var state_42541__$1 = state_42541;
if(cljs.core.truth_(inst_42488)){
var statearr_42580_43554 = state_42541__$1;
(statearr_42580_43554[(1)] = (10));

} else {
var statearr_42581_43556 = state_42541__$1;
(statearr_42581_43556[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41284__auto__ = null;
var cljs$core$async$state_machine__41284__auto____0 = (function (){
var statearr_42582 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42582[(0)] = cljs$core$async$state_machine__41284__auto__);

(statearr_42582[(1)] = (1));

return statearr_42582;
});
var cljs$core$async$state_machine__41284__auto____1 = (function (state_42541){
while(true){
var ret_value__41285__auto__ = (function (){try{while(true){
var result__41286__auto__ = switch__41283__auto__(state_42541);
if(cljs.core.keyword_identical_QMARK_(result__41286__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41286__auto__;
}
break;
}
}catch (e42583){var ex__41287__auto__ = e42583;
var statearr_42584_43561 = state_42541;
(statearr_42584_43561[(2)] = ex__41287__auto__);


if(cljs.core.seq((state_42541[(4)]))){
var statearr_42585_43563 = state_42541;
(statearr_42585_43563[(1)] = cljs.core.first((state_42541[(4)])));

} else {
throw ex__41287__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41285__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43564 = state_42541;
state_42541 = G__43564;
continue;
} else {
return ret_value__41285__auto__;
}
break;
}
});
cljs$core$async$state_machine__41284__auto__ = function(state_42541){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41284__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41284__auto____1.call(this,state_42541);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41284__auto____0;
cljs$core$async$state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41284__auto____1;
return cljs$core$async$state_machine__41284__auto__;
})()
})();
var state__41389__auto__ = (function (){var statearr_42586 = f__41388__auto__();
(statearr_42586[(6)] = c__41387__auto___43506);

return statearr_42586;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41389__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__42588 = arguments.length;
switch (G__42588) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__42590 = arguments.length;
switch (G__42590) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__42592 = arguments.length;
switch (G__42592) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__41387__auto___43578 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41388__auto__ = (function (){var switch__41283__auto__ = (function (state_42635){
var state_val_42636 = (state_42635[(1)]);
if((state_val_42636 === (7))){
var state_42635__$1 = state_42635;
var statearr_42637_43579 = state_42635__$1;
(statearr_42637_43579[(2)] = null);

(statearr_42637_43579[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42636 === (1))){
var state_42635__$1 = state_42635;
var statearr_42638_43581 = state_42635__$1;
(statearr_42638_43581[(2)] = null);

(statearr_42638_43581[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42636 === (4))){
var inst_42596 = (state_42635[(7)]);
var inst_42595 = (state_42635[(8)]);
var inst_42598 = (inst_42596 < inst_42595);
var state_42635__$1 = state_42635;
if(cljs.core.truth_(inst_42598)){
var statearr_42639_43584 = state_42635__$1;
(statearr_42639_43584[(1)] = (6));

} else {
var statearr_42640_43585 = state_42635__$1;
(statearr_42640_43585[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42636 === (15))){
var inst_42621 = (state_42635[(9)]);
var inst_42626 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_42621);
var state_42635__$1 = state_42635;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42635__$1,(17),out,inst_42626);
} else {
if((state_val_42636 === (13))){
var inst_42621 = (state_42635[(9)]);
var inst_42621__$1 = (state_42635[(2)]);
var inst_42622 = cljs.core.some(cljs.core.nil_QMARK_,inst_42621__$1);
var state_42635__$1 = (function (){var statearr_42642 = state_42635;
(statearr_42642[(9)] = inst_42621__$1);

return statearr_42642;
})();
if(cljs.core.truth_(inst_42622)){
var statearr_42643_43587 = state_42635__$1;
(statearr_42643_43587[(1)] = (14));

} else {
var statearr_42644_43588 = state_42635__$1;
(statearr_42644_43588[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42636 === (6))){
var state_42635__$1 = state_42635;
var statearr_42645_43589 = state_42635__$1;
(statearr_42645_43589[(2)] = null);

(statearr_42645_43589[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42636 === (17))){
var inst_42628 = (state_42635[(2)]);
var state_42635__$1 = (function (){var statearr_42648 = state_42635;
(statearr_42648[(10)] = inst_42628);

return statearr_42648;
})();
var statearr_42649_43592 = state_42635__$1;
(statearr_42649_43592[(2)] = null);

(statearr_42649_43592[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42636 === (3))){
var inst_42633 = (state_42635[(2)]);
var state_42635__$1 = state_42635;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42635__$1,inst_42633);
} else {
if((state_val_42636 === (12))){
var _ = (function (){var statearr_42650 = state_42635;
(statearr_42650[(4)] = cljs.core.rest((state_42635[(4)])));

return statearr_42650;
})();
var state_42635__$1 = state_42635;
var ex42647 = (state_42635__$1[(2)]);
var statearr_42651_43594 = state_42635__$1;
(statearr_42651_43594[(5)] = ex42647);


if((ex42647 instanceof Object)){
var statearr_42652_43596 = state_42635__$1;
(statearr_42652_43596[(1)] = (11));

(statearr_42652_43596[(5)] = null);

} else {
throw ex42647;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42636 === (2))){
var inst_42594 = cljs.core.reset_BANG_(dctr,cnt);
var inst_42595 = cnt;
var inst_42596 = (0);
var state_42635__$1 = (function (){var statearr_42653 = state_42635;
(statearr_42653[(11)] = inst_42594);

(statearr_42653[(8)] = inst_42595);

(statearr_42653[(7)] = inst_42596);

return statearr_42653;
})();
var statearr_42654_43599 = state_42635__$1;
(statearr_42654_43599[(2)] = null);

(statearr_42654_43599[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42636 === (11))){
var inst_42600 = (state_42635[(2)]);
var inst_42601 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_42635__$1 = (function (){var statearr_42655 = state_42635;
(statearr_42655[(12)] = inst_42600);

return statearr_42655;
})();
var statearr_42656_43601 = state_42635__$1;
(statearr_42656_43601[(2)] = inst_42601);

(statearr_42656_43601[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42636 === (9))){
var inst_42596 = (state_42635[(7)]);
var _ = (function (){var statearr_42657 = state_42635;
(statearr_42657[(4)] = cljs.core.cons((12),(state_42635[(4)])));

return statearr_42657;
})();
var inst_42607 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_42596) : chs__$1.call(null,inst_42596));
var inst_42608 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_42596) : done.call(null,inst_42596));
var inst_42609 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_42607,inst_42608);
var ___$1 = (function (){var statearr_42658 = state_42635;
(statearr_42658[(4)] = cljs.core.rest((state_42635[(4)])));

return statearr_42658;
})();
var state_42635__$1 = state_42635;
var statearr_42659_43608 = state_42635__$1;
(statearr_42659_43608[(2)] = inst_42609);

(statearr_42659_43608[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42636 === (5))){
var inst_42619 = (state_42635[(2)]);
var state_42635__$1 = (function (){var statearr_42660 = state_42635;
(statearr_42660[(13)] = inst_42619);

return statearr_42660;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42635__$1,(13),dchan);
} else {
if((state_val_42636 === (14))){
var inst_42624 = cljs.core.async.close_BANG_(out);
var state_42635__$1 = state_42635;
var statearr_42661_43610 = state_42635__$1;
(statearr_42661_43610[(2)] = inst_42624);

(statearr_42661_43610[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42636 === (16))){
var inst_42631 = (state_42635[(2)]);
var state_42635__$1 = state_42635;
var statearr_42662_43611 = state_42635__$1;
(statearr_42662_43611[(2)] = inst_42631);

(statearr_42662_43611[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42636 === (10))){
var inst_42596 = (state_42635[(7)]);
var inst_42612 = (state_42635[(2)]);
var inst_42613 = (inst_42596 + (1));
var inst_42596__$1 = inst_42613;
var state_42635__$1 = (function (){var statearr_42663 = state_42635;
(statearr_42663[(14)] = inst_42612);

(statearr_42663[(7)] = inst_42596__$1);

return statearr_42663;
})();
var statearr_42664_43614 = state_42635__$1;
(statearr_42664_43614[(2)] = null);

(statearr_42664_43614[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42636 === (8))){
var inst_42617 = (state_42635[(2)]);
var state_42635__$1 = state_42635;
var statearr_42665_43616 = state_42635__$1;
(statearr_42665_43616[(2)] = inst_42617);

(statearr_42665_43616[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41284__auto__ = null;
var cljs$core$async$state_machine__41284__auto____0 = (function (){
var statearr_42666 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42666[(0)] = cljs$core$async$state_machine__41284__auto__);

(statearr_42666[(1)] = (1));

return statearr_42666;
});
var cljs$core$async$state_machine__41284__auto____1 = (function (state_42635){
while(true){
var ret_value__41285__auto__ = (function (){try{while(true){
var result__41286__auto__ = switch__41283__auto__(state_42635);
if(cljs.core.keyword_identical_QMARK_(result__41286__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41286__auto__;
}
break;
}
}catch (e42667){var ex__41287__auto__ = e42667;
var statearr_42668_43618 = state_42635;
(statearr_42668_43618[(2)] = ex__41287__auto__);


if(cljs.core.seq((state_42635[(4)]))){
var statearr_42669_43621 = state_42635;
(statearr_42669_43621[(1)] = cljs.core.first((state_42635[(4)])));

} else {
throw ex__41287__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41285__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43623 = state_42635;
state_42635 = G__43623;
continue;
} else {
return ret_value__41285__auto__;
}
break;
}
});
cljs$core$async$state_machine__41284__auto__ = function(state_42635){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41284__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41284__auto____1.call(this,state_42635);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41284__auto____0;
cljs$core$async$state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41284__auto____1;
return cljs$core$async$state_machine__41284__auto__;
})()
})();
var state__41389__auto__ = (function (){var statearr_42670 = f__41388__auto__();
(statearr_42670[(6)] = c__41387__auto___43578);

return statearr_42670;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41389__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__42673 = arguments.length;
switch (G__42673) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__41387__auto___43629 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41388__auto__ = (function (){var switch__41283__auto__ = (function (state_42705){
var state_val_42706 = (state_42705[(1)]);
if((state_val_42706 === (7))){
var inst_42684 = (state_42705[(7)]);
var inst_42685 = (state_42705[(8)]);
var inst_42684__$1 = (state_42705[(2)]);
var inst_42685__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42684__$1,(0),null);
var inst_42686 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42684__$1,(1),null);
var inst_42687 = (inst_42685__$1 == null);
var state_42705__$1 = (function (){var statearr_42707 = state_42705;
(statearr_42707[(7)] = inst_42684__$1);

(statearr_42707[(8)] = inst_42685__$1);

(statearr_42707[(9)] = inst_42686);

return statearr_42707;
})();
if(cljs.core.truth_(inst_42687)){
var statearr_42708_43635 = state_42705__$1;
(statearr_42708_43635[(1)] = (8));

} else {
var statearr_42709_43636 = state_42705__$1;
(statearr_42709_43636[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42706 === (1))){
var inst_42674 = cljs.core.vec(chs);
var inst_42675 = inst_42674;
var state_42705__$1 = (function (){var statearr_42710 = state_42705;
(statearr_42710[(10)] = inst_42675);

return statearr_42710;
})();
var statearr_42711_43638 = state_42705__$1;
(statearr_42711_43638[(2)] = null);

(statearr_42711_43638[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42706 === (4))){
var inst_42675 = (state_42705[(10)]);
var state_42705__$1 = state_42705;
return cljs.core.async.ioc_alts_BANG_(state_42705__$1,(7),inst_42675);
} else {
if((state_val_42706 === (6))){
var inst_42701 = (state_42705[(2)]);
var state_42705__$1 = state_42705;
var statearr_42712_43641 = state_42705__$1;
(statearr_42712_43641[(2)] = inst_42701);

(statearr_42712_43641[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42706 === (3))){
var inst_42703 = (state_42705[(2)]);
var state_42705__$1 = state_42705;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42705__$1,inst_42703);
} else {
if((state_val_42706 === (2))){
var inst_42675 = (state_42705[(10)]);
var inst_42677 = cljs.core.count(inst_42675);
var inst_42678 = (inst_42677 > (0));
var state_42705__$1 = state_42705;
if(cljs.core.truth_(inst_42678)){
var statearr_42714_43644 = state_42705__$1;
(statearr_42714_43644[(1)] = (4));

} else {
var statearr_42715_43645 = state_42705__$1;
(statearr_42715_43645[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42706 === (11))){
var inst_42675 = (state_42705[(10)]);
var inst_42694 = (state_42705[(2)]);
var tmp42713 = inst_42675;
var inst_42675__$1 = tmp42713;
var state_42705__$1 = (function (){var statearr_42716 = state_42705;
(statearr_42716[(11)] = inst_42694);

(statearr_42716[(10)] = inst_42675__$1);

return statearr_42716;
})();
var statearr_42717_43647 = state_42705__$1;
(statearr_42717_43647[(2)] = null);

(statearr_42717_43647[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42706 === (9))){
var inst_42685 = (state_42705[(8)]);
var state_42705__$1 = state_42705;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42705__$1,(11),out,inst_42685);
} else {
if((state_val_42706 === (5))){
var inst_42699 = cljs.core.async.close_BANG_(out);
var state_42705__$1 = state_42705;
var statearr_42718_43651 = state_42705__$1;
(statearr_42718_43651[(2)] = inst_42699);

(statearr_42718_43651[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42706 === (10))){
var inst_42697 = (state_42705[(2)]);
var state_42705__$1 = state_42705;
var statearr_42719_43652 = state_42705__$1;
(statearr_42719_43652[(2)] = inst_42697);

(statearr_42719_43652[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42706 === (8))){
var inst_42675 = (state_42705[(10)]);
var inst_42684 = (state_42705[(7)]);
var inst_42685 = (state_42705[(8)]);
var inst_42686 = (state_42705[(9)]);
var inst_42689 = (function (){var cs = inst_42675;
var vec__42680 = inst_42684;
var v = inst_42685;
var c = inst_42686;
return (function (p1__42671_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__42671_SHARP_);
});
})();
var inst_42690 = cljs.core.filterv(inst_42689,inst_42675);
var inst_42675__$1 = inst_42690;
var state_42705__$1 = (function (){var statearr_42720 = state_42705;
(statearr_42720[(10)] = inst_42675__$1);

return statearr_42720;
})();
var statearr_42721_43657 = state_42705__$1;
(statearr_42721_43657[(2)] = null);

(statearr_42721_43657[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41284__auto__ = null;
var cljs$core$async$state_machine__41284__auto____0 = (function (){
var statearr_42722 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42722[(0)] = cljs$core$async$state_machine__41284__auto__);

(statearr_42722[(1)] = (1));

return statearr_42722;
});
var cljs$core$async$state_machine__41284__auto____1 = (function (state_42705){
while(true){
var ret_value__41285__auto__ = (function (){try{while(true){
var result__41286__auto__ = switch__41283__auto__(state_42705);
if(cljs.core.keyword_identical_QMARK_(result__41286__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41286__auto__;
}
break;
}
}catch (e42723){var ex__41287__auto__ = e42723;
var statearr_42724_43660 = state_42705;
(statearr_42724_43660[(2)] = ex__41287__auto__);


if(cljs.core.seq((state_42705[(4)]))){
var statearr_42725_43665 = state_42705;
(statearr_42725_43665[(1)] = cljs.core.first((state_42705[(4)])));

} else {
throw ex__41287__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41285__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43666 = state_42705;
state_42705 = G__43666;
continue;
} else {
return ret_value__41285__auto__;
}
break;
}
});
cljs$core$async$state_machine__41284__auto__ = function(state_42705){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41284__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41284__auto____1.call(this,state_42705);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41284__auto____0;
cljs$core$async$state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41284__auto____1;
return cljs$core$async$state_machine__41284__auto__;
})()
})();
var state__41389__auto__ = (function (){var statearr_42726 = f__41388__auto__();
(statearr_42726[(6)] = c__41387__auto___43629);

return statearr_42726;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41389__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__42728 = arguments.length;
switch (G__42728) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__41387__auto___43674 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41388__auto__ = (function (){var switch__41283__auto__ = (function (state_42752){
var state_val_42753 = (state_42752[(1)]);
if((state_val_42753 === (7))){
var inst_42734 = (state_42752[(7)]);
var inst_42734__$1 = (state_42752[(2)]);
var inst_42735 = (inst_42734__$1 == null);
var inst_42736 = cljs.core.not(inst_42735);
var state_42752__$1 = (function (){var statearr_42754 = state_42752;
(statearr_42754[(7)] = inst_42734__$1);

return statearr_42754;
})();
if(inst_42736){
var statearr_42755_43676 = state_42752__$1;
(statearr_42755_43676[(1)] = (8));

} else {
var statearr_42756_43678 = state_42752__$1;
(statearr_42756_43678[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42753 === (1))){
var inst_42729 = (0);
var state_42752__$1 = (function (){var statearr_42757 = state_42752;
(statearr_42757[(8)] = inst_42729);

return statearr_42757;
})();
var statearr_42758_43680 = state_42752__$1;
(statearr_42758_43680[(2)] = null);

(statearr_42758_43680[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42753 === (4))){
var state_42752__$1 = state_42752;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42752__$1,(7),ch);
} else {
if((state_val_42753 === (6))){
var inst_42747 = (state_42752[(2)]);
var state_42752__$1 = state_42752;
var statearr_42759_43683 = state_42752__$1;
(statearr_42759_43683[(2)] = inst_42747);

(statearr_42759_43683[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42753 === (3))){
var inst_42749 = (state_42752[(2)]);
var inst_42750 = cljs.core.async.close_BANG_(out);
var state_42752__$1 = (function (){var statearr_42760 = state_42752;
(statearr_42760[(9)] = inst_42749);

return statearr_42760;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_42752__$1,inst_42750);
} else {
if((state_val_42753 === (2))){
var inst_42729 = (state_42752[(8)]);
var inst_42731 = (inst_42729 < n);
var state_42752__$1 = state_42752;
if(cljs.core.truth_(inst_42731)){
var statearr_42761_43685 = state_42752__$1;
(statearr_42761_43685[(1)] = (4));

} else {
var statearr_42762_43688 = state_42752__$1;
(statearr_42762_43688[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42753 === (11))){
var inst_42729 = (state_42752[(8)]);
var inst_42739 = (state_42752[(2)]);
var inst_42740 = (inst_42729 + (1));
var inst_42729__$1 = inst_42740;
var state_42752__$1 = (function (){var statearr_42763 = state_42752;
(statearr_42763[(10)] = inst_42739);

(statearr_42763[(8)] = inst_42729__$1);

return statearr_42763;
})();
var statearr_42764_43690 = state_42752__$1;
(statearr_42764_43690[(2)] = null);

(statearr_42764_43690[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42753 === (9))){
var state_42752__$1 = state_42752;
var statearr_42765_43691 = state_42752__$1;
(statearr_42765_43691[(2)] = null);

(statearr_42765_43691[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42753 === (5))){
var state_42752__$1 = state_42752;
var statearr_42766_43693 = state_42752__$1;
(statearr_42766_43693[(2)] = null);

(statearr_42766_43693[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42753 === (10))){
var inst_42744 = (state_42752[(2)]);
var state_42752__$1 = state_42752;
var statearr_42767_43694 = state_42752__$1;
(statearr_42767_43694[(2)] = inst_42744);

(statearr_42767_43694[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42753 === (8))){
var inst_42734 = (state_42752[(7)]);
var state_42752__$1 = state_42752;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42752__$1,(11),out,inst_42734);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41284__auto__ = null;
var cljs$core$async$state_machine__41284__auto____0 = (function (){
var statearr_42768 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_42768[(0)] = cljs$core$async$state_machine__41284__auto__);

(statearr_42768[(1)] = (1));

return statearr_42768;
});
var cljs$core$async$state_machine__41284__auto____1 = (function (state_42752){
while(true){
var ret_value__41285__auto__ = (function (){try{while(true){
var result__41286__auto__ = switch__41283__auto__(state_42752);
if(cljs.core.keyword_identical_QMARK_(result__41286__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41286__auto__;
}
break;
}
}catch (e42769){var ex__41287__auto__ = e42769;
var statearr_42770_43698 = state_42752;
(statearr_42770_43698[(2)] = ex__41287__auto__);


if(cljs.core.seq((state_42752[(4)]))){
var statearr_42771_43699 = state_42752;
(statearr_42771_43699[(1)] = cljs.core.first((state_42752[(4)])));

} else {
throw ex__41287__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41285__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43701 = state_42752;
state_42752 = G__43701;
continue;
} else {
return ret_value__41285__auto__;
}
break;
}
});
cljs$core$async$state_machine__41284__auto__ = function(state_42752){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41284__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41284__auto____1.call(this,state_42752);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41284__auto____0;
cljs$core$async$state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41284__auto____1;
return cljs$core$async$state_machine__41284__auto__;
})()
})();
var state__41389__auto__ = (function (){var statearr_42772 = f__41388__auto__();
(statearr_42772[(6)] = c__41387__auto___43674);

return statearr_42772;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41389__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42777 = (function (f,ch,meta42775,_,fn1,meta42778){
this.f = f;
this.ch = ch;
this.meta42775 = meta42775;
this._ = _;
this.fn1 = fn1;
this.meta42778 = meta42778;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async42777.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42779,meta42778__$1){
var self__ = this;
var _42779__$1 = this;
return (new cljs.core.async.t_cljs$core$async42777(self__.f,self__.ch,self__.meta42775,self__._,self__.fn1,meta42778__$1));
}));

(cljs.core.async.t_cljs$core$async42777.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42779){
var self__ = this;
var _42779__$1 = this;
return self__.meta42778;
}));

(cljs.core.async.t_cljs$core$async42777.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42777.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async42777.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async42777.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__42773_SHARP_){
var G__42780 = (((p1__42773_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__42773_SHARP_) : self__.f.call(null,p1__42773_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__42780) : f1.call(null,G__42780));
});
}));

(cljs.core.async.t_cljs$core$async42777.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta42775","meta42775",-881340387,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async42774","cljs.core.async/t_cljs$core$async42774",-302212864,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta42778","meta42778",-180224788,null)], null);
}));

(cljs.core.async.t_cljs$core$async42777.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async42777.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42777");

(cljs.core.async.t_cljs$core$async42777.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async42777");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async42777.
 */
cljs.core.async.__GT_t_cljs$core$async42777 = (function cljs$core$async$__GT_t_cljs$core$async42777(f,ch,meta42775,_,fn1,meta42778){
return (new cljs.core.async.t_cljs$core$async42777(f,ch,meta42775,_,fn1,meta42778));
});



/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42774 = (function (f,ch,meta42775){
this.f = f;
this.ch = ch;
this.meta42775 = meta42775;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async42774.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42776,meta42775__$1){
var self__ = this;
var _42776__$1 = this;
return (new cljs.core.async.t_cljs$core$async42774(self__.f,self__.ch,meta42775__$1));
}));

(cljs.core.async.t_cljs$core$async42774.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42776){
var self__ = this;
var _42776__$1 = this;
return self__.meta42775;
}));

(cljs.core.async.t_cljs$core$async42774.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42774.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async42774.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async42774.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42774.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(new cljs.core.async.t_cljs$core$async42777(self__.f,self__.ch,self__.meta42775,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY)));
if(cljs.core.truth_((function (){var and__5000__auto__ = ret;
if(cljs.core.truth_(and__5000__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__5000__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__42781 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__42781) : self__.f.call(null,G__42781));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async42774.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42774.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async42774.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta42775","meta42775",-881340387,null)], null);
}));

(cljs.core.async.t_cljs$core$async42774.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async42774.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42774");

(cljs.core.async.t_cljs$core$async42774.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async42774");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async42774.
 */
cljs.core.async.__GT_t_cljs$core$async42774 = (function cljs$core$async$__GT_t_cljs$core$async42774(f,ch,meta42775){
return (new cljs.core.async.t_cljs$core$async42774(f,ch,meta42775));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
return (new cljs.core.async.t_cljs$core$async42774(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42782 = (function (f,ch,meta42783){
this.f = f;
this.ch = ch;
this.meta42783 = meta42783;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async42782.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42784,meta42783__$1){
var self__ = this;
var _42784__$1 = this;
return (new cljs.core.async.t_cljs$core$async42782(self__.f,self__.ch,meta42783__$1));
}));

(cljs.core.async.t_cljs$core$async42782.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42784){
var self__ = this;
var _42784__$1 = this;
return self__.meta42783;
}));

(cljs.core.async.t_cljs$core$async42782.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42782.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async42782.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42782.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async42782.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42782.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async42782.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta42783","meta42783",-936202978,null)], null);
}));

(cljs.core.async.t_cljs$core$async42782.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async42782.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42782");

(cljs.core.async.t_cljs$core$async42782.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async42782");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async42782.
 */
cljs.core.async.__GT_t_cljs$core$async42782 = (function cljs$core$async$__GT_t_cljs$core$async42782(f,ch,meta42783){
return (new cljs.core.async.t_cljs$core$async42782(f,ch,meta42783));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
return (new cljs.core.async.t_cljs$core$async42782(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42785 = (function (p,ch,meta42786){
this.p = p;
this.ch = ch;
this.meta42786 = meta42786;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async42785.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42787,meta42786__$1){
var self__ = this;
var _42787__$1 = this;
return (new cljs.core.async.t_cljs$core$async42785(self__.p,self__.ch,meta42786__$1));
}));

(cljs.core.async.t_cljs$core$async42785.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42787){
var self__ = this;
var _42787__$1 = this;
return self__.meta42786;
}));

(cljs.core.async.t_cljs$core$async42785.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42785.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async42785.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async42785.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42785.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async42785.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42785.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async42785.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta42786","meta42786",126813388,null)], null);
}));

(cljs.core.async.t_cljs$core$async42785.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async42785.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42785");

(cljs.core.async.t_cljs$core$async42785.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async42785");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async42785.
 */
cljs.core.async.__GT_t_cljs$core$async42785 = (function cljs$core$async$__GT_t_cljs$core$async42785(p,ch,meta42786){
return (new cljs.core.async.t_cljs$core$async42785(p,ch,meta42786));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
return (new cljs.core.async.t_cljs$core$async42785(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__42789 = arguments.length;
switch (G__42789) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__41387__auto___43732 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41388__auto__ = (function (){var switch__41283__auto__ = (function (state_42810){
var state_val_42811 = (state_42810[(1)]);
if((state_val_42811 === (7))){
var inst_42806 = (state_42810[(2)]);
var state_42810__$1 = state_42810;
var statearr_42812_43736 = state_42810__$1;
(statearr_42812_43736[(2)] = inst_42806);

(statearr_42812_43736[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42811 === (1))){
var state_42810__$1 = state_42810;
var statearr_42813_43738 = state_42810__$1;
(statearr_42813_43738[(2)] = null);

(statearr_42813_43738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42811 === (4))){
var inst_42792 = (state_42810[(7)]);
var inst_42792__$1 = (state_42810[(2)]);
var inst_42793 = (inst_42792__$1 == null);
var state_42810__$1 = (function (){var statearr_42814 = state_42810;
(statearr_42814[(7)] = inst_42792__$1);

return statearr_42814;
})();
if(cljs.core.truth_(inst_42793)){
var statearr_42815_43740 = state_42810__$1;
(statearr_42815_43740[(1)] = (5));

} else {
var statearr_42816_43741 = state_42810__$1;
(statearr_42816_43741[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42811 === (6))){
var inst_42792 = (state_42810[(7)]);
var inst_42797 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_42792) : p.call(null,inst_42792));
var state_42810__$1 = state_42810;
if(cljs.core.truth_(inst_42797)){
var statearr_42817_43742 = state_42810__$1;
(statearr_42817_43742[(1)] = (8));

} else {
var statearr_42818_43743 = state_42810__$1;
(statearr_42818_43743[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42811 === (3))){
var inst_42808 = (state_42810[(2)]);
var state_42810__$1 = state_42810;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42810__$1,inst_42808);
} else {
if((state_val_42811 === (2))){
var state_42810__$1 = state_42810;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42810__$1,(4),ch);
} else {
if((state_val_42811 === (11))){
var inst_42800 = (state_42810[(2)]);
var state_42810__$1 = state_42810;
var statearr_42820_43747 = state_42810__$1;
(statearr_42820_43747[(2)] = inst_42800);

(statearr_42820_43747[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42811 === (9))){
var state_42810__$1 = state_42810;
var statearr_42821_43748 = state_42810__$1;
(statearr_42821_43748[(2)] = null);

(statearr_42821_43748[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42811 === (5))){
var inst_42795 = cljs.core.async.close_BANG_(out);
var state_42810__$1 = state_42810;
var statearr_42822_43750 = state_42810__$1;
(statearr_42822_43750[(2)] = inst_42795);

(statearr_42822_43750[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42811 === (10))){
var inst_42803 = (state_42810[(2)]);
var state_42810__$1 = (function (){var statearr_42823 = state_42810;
(statearr_42823[(8)] = inst_42803);

return statearr_42823;
})();
var statearr_42824_43751 = state_42810__$1;
(statearr_42824_43751[(2)] = null);

(statearr_42824_43751[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42811 === (8))){
var inst_42792 = (state_42810[(7)]);
var state_42810__$1 = state_42810;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42810__$1,(11),out,inst_42792);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41284__auto__ = null;
var cljs$core$async$state_machine__41284__auto____0 = (function (){
var statearr_42825 = [null,null,null,null,null,null,null,null,null];
(statearr_42825[(0)] = cljs$core$async$state_machine__41284__auto__);

(statearr_42825[(1)] = (1));

return statearr_42825;
});
var cljs$core$async$state_machine__41284__auto____1 = (function (state_42810){
while(true){
var ret_value__41285__auto__ = (function (){try{while(true){
var result__41286__auto__ = switch__41283__auto__(state_42810);
if(cljs.core.keyword_identical_QMARK_(result__41286__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41286__auto__;
}
break;
}
}catch (e42826){var ex__41287__auto__ = e42826;
var statearr_42827_43755 = state_42810;
(statearr_42827_43755[(2)] = ex__41287__auto__);


if(cljs.core.seq((state_42810[(4)]))){
var statearr_42828_43757 = state_42810;
(statearr_42828_43757[(1)] = cljs.core.first((state_42810[(4)])));

} else {
throw ex__41287__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41285__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43758 = state_42810;
state_42810 = G__43758;
continue;
} else {
return ret_value__41285__auto__;
}
break;
}
});
cljs$core$async$state_machine__41284__auto__ = function(state_42810){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41284__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41284__auto____1.call(this,state_42810);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41284__auto____0;
cljs$core$async$state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41284__auto____1;
return cljs$core$async$state_machine__41284__auto__;
})()
})();
var state__41389__auto__ = (function (){var statearr_42829 = f__41388__auto__();
(statearr_42829[(6)] = c__41387__auto___43732);

return statearr_42829;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41389__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__42831 = arguments.length;
switch (G__42831) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__41387__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41388__auto__ = (function (){var switch__41283__auto__ = (function (state_42893){
var state_val_42894 = (state_42893[(1)]);
if((state_val_42894 === (7))){
var inst_42889 = (state_42893[(2)]);
var state_42893__$1 = state_42893;
var statearr_42895_43767 = state_42893__$1;
(statearr_42895_43767[(2)] = inst_42889);

(statearr_42895_43767[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42894 === (20))){
var inst_42859 = (state_42893[(7)]);
var inst_42870 = (state_42893[(2)]);
var inst_42871 = cljs.core.next(inst_42859);
var inst_42845 = inst_42871;
var inst_42846 = null;
var inst_42847 = (0);
var inst_42848 = (0);
var state_42893__$1 = (function (){var statearr_42896 = state_42893;
(statearr_42896[(8)] = inst_42870);

(statearr_42896[(9)] = inst_42845);

(statearr_42896[(10)] = inst_42846);

(statearr_42896[(11)] = inst_42847);

(statearr_42896[(12)] = inst_42848);

return statearr_42896;
})();
var statearr_42897_43769 = state_42893__$1;
(statearr_42897_43769[(2)] = null);

(statearr_42897_43769[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42894 === (1))){
var state_42893__$1 = state_42893;
var statearr_42898_43770 = state_42893__$1;
(statearr_42898_43770[(2)] = null);

(statearr_42898_43770[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42894 === (4))){
var inst_42834 = (state_42893[(13)]);
var inst_42834__$1 = (state_42893[(2)]);
var inst_42835 = (inst_42834__$1 == null);
var state_42893__$1 = (function (){var statearr_42899 = state_42893;
(statearr_42899[(13)] = inst_42834__$1);

return statearr_42899;
})();
if(cljs.core.truth_(inst_42835)){
var statearr_42900_43773 = state_42893__$1;
(statearr_42900_43773[(1)] = (5));

} else {
var statearr_42901_43775 = state_42893__$1;
(statearr_42901_43775[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42894 === (15))){
var state_42893__$1 = state_42893;
var statearr_42905_43776 = state_42893__$1;
(statearr_42905_43776[(2)] = null);

(statearr_42905_43776[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42894 === (21))){
var state_42893__$1 = state_42893;
var statearr_42906_43777 = state_42893__$1;
(statearr_42906_43777[(2)] = null);

(statearr_42906_43777[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42894 === (13))){
var inst_42848 = (state_42893[(12)]);
var inst_42845 = (state_42893[(9)]);
var inst_42846 = (state_42893[(10)]);
var inst_42847 = (state_42893[(11)]);
var inst_42855 = (state_42893[(2)]);
var inst_42856 = (inst_42848 + (1));
var tmp42902 = inst_42846;
var tmp42903 = inst_42845;
var tmp42904 = inst_42847;
var inst_42845__$1 = tmp42903;
var inst_42846__$1 = tmp42902;
var inst_42847__$1 = tmp42904;
var inst_42848__$1 = inst_42856;
var state_42893__$1 = (function (){var statearr_42907 = state_42893;
(statearr_42907[(14)] = inst_42855);

(statearr_42907[(9)] = inst_42845__$1);

(statearr_42907[(10)] = inst_42846__$1);

(statearr_42907[(11)] = inst_42847__$1);

(statearr_42907[(12)] = inst_42848__$1);

return statearr_42907;
})();
var statearr_42908_43781 = state_42893__$1;
(statearr_42908_43781[(2)] = null);

(statearr_42908_43781[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42894 === (22))){
var state_42893__$1 = state_42893;
var statearr_42909_43783 = state_42893__$1;
(statearr_42909_43783[(2)] = null);

(statearr_42909_43783[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42894 === (6))){
var inst_42834 = (state_42893[(13)]);
var inst_42843 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_42834) : f.call(null,inst_42834));
var inst_42844 = cljs.core.seq(inst_42843);
var inst_42845 = inst_42844;
var inst_42846 = null;
var inst_42847 = (0);
var inst_42848 = (0);
var state_42893__$1 = (function (){var statearr_42910 = state_42893;
(statearr_42910[(9)] = inst_42845);

(statearr_42910[(10)] = inst_42846);

(statearr_42910[(11)] = inst_42847);

(statearr_42910[(12)] = inst_42848);

return statearr_42910;
})();
var statearr_42911_43785 = state_42893__$1;
(statearr_42911_43785[(2)] = null);

(statearr_42911_43785[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42894 === (17))){
var inst_42859 = (state_42893[(7)]);
var inst_42863 = cljs.core.chunk_first(inst_42859);
var inst_42864 = cljs.core.chunk_rest(inst_42859);
var inst_42865 = cljs.core.count(inst_42863);
var inst_42845 = inst_42864;
var inst_42846 = inst_42863;
var inst_42847 = inst_42865;
var inst_42848 = (0);
var state_42893__$1 = (function (){var statearr_42913 = state_42893;
(statearr_42913[(9)] = inst_42845);

(statearr_42913[(10)] = inst_42846);

(statearr_42913[(11)] = inst_42847);

(statearr_42913[(12)] = inst_42848);

return statearr_42913;
})();
var statearr_42914_43789 = state_42893__$1;
(statearr_42914_43789[(2)] = null);

(statearr_42914_43789[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42894 === (3))){
var inst_42891 = (state_42893[(2)]);
var state_42893__$1 = state_42893;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42893__$1,inst_42891);
} else {
if((state_val_42894 === (12))){
var inst_42879 = (state_42893[(2)]);
var state_42893__$1 = state_42893;
var statearr_42915_43791 = state_42893__$1;
(statearr_42915_43791[(2)] = inst_42879);

(statearr_42915_43791[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42894 === (2))){
var state_42893__$1 = state_42893;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42893__$1,(4),in$);
} else {
if((state_val_42894 === (23))){
var inst_42887 = (state_42893[(2)]);
var state_42893__$1 = state_42893;
var statearr_42916_43792 = state_42893__$1;
(statearr_42916_43792[(2)] = inst_42887);

(statearr_42916_43792[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42894 === (19))){
var inst_42874 = (state_42893[(2)]);
var state_42893__$1 = state_42893;
var statearr_42917_43795 = state_42893__$1;
(statearr_42917_43795[(2)] = inst_42874);

(statearr_42917_43795[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42894 === (11))){
var inst_42845 = (state_42893[(9)]);
var inst_42859 = (state_42893[(7)]);
var inst_42859__$1 = cljs.core.seq(inst_42845);
var state_42893__$1 = (function (){var statearr_42918 = state_42893;
(statearr_42918[(7)] = inst_42859__$1);

return statearr_42918;
})();
if(inst_42859__$1){
var statearr_42919_43797 = state_42893__$1;
(statearr_42919_43797[(1)] = (14));

} else {
var statearr_42920_43798 = state_42893__$1;
(statearr_42920_43798[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42894 === (9))){
var inst_42881 = (state_42893[(2)]);
var inst_42882 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_42893__$1 = (function (){var statearr_42921 = state_42893;
(statearr_42921[(15)] = inst_42881);

return statearr_42921;
})();
if(cljs.core.truth_(inst_42882)){
var statearr_42922_43800 = state_42893__$1;
(statearr_42922_43800[(1)] = (21));

} else {
var statearr_42923_43801 = state_42893__$1;
(statearr_42923_43801[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42894 === (5))){
var inst_42837 = cljs.core.async.close_BANG_(out);
var state_42893__$1 = state_42893;
var statearr_42924_43803 = state_42893__$1;
(statearr_42924_43803[(2)] = inst_42837);

(statearr_42924_43803[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42894 === (14))){
var inst_42859 = (state_42893[(7)]);
var inst_42861 = cljs.core.chunked_seq_QMARK_(inst_42859);
var state_42893__$1 = state_42893;
if(inst_42861){
var statearr_42925_43806 = state_42893__$1;
(statearr_42925_43806[(1)] = (17));

} else {
var statearr_42926_43807 = state_42893__$1;
(statearr_42926_43807[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42894 === (16))){
var inst_42877 = (state_42893[(2)]);
var state_42893__$1 = state_42893;
var statearr_42927_43808 = state_42893__$1;
(statearr_42927_43808[(2)] = inst_42877);

(statearr_42927_43808[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42894 === (10))){
var inst_42846 = (state_42893[(10)]);
var inst_42848 = (state_42893[(12)]);
var inst_42853 = cljs.core._nth(inst_42846,inst_42848);
var state_42893__$1 = state_42893;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42893__$1,(13),out,inst_42853);
} else {
if((state_val_42894 === (18))){
var inst_42859 = (state_42893[(7)]);
var inst_42868 = cljs.core.first(inst_42859);
var state_42893__$1 = state_42893;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42893__$1,(20),out,inst_42868);
} else {
if((state_val_42894 === (8))){
var inst_42848 = (state_42893[(12)]);
var inst_42847 = (state_42893[(11)]);
var inst_42850 = (inst_42848 < inst_42847);
var inst_42851 = inst_42850;
var state_42893__$1 = state_42893;
if(cljs.core.truth_(inst_42851)){
var statearr_42928_43812 = state_42893__$1;
(statearr_42928_43812[(1)] = (10));

} else {
var statearr_42929_43814 = state_42893__$1;
(statearr_42929_43814[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__41284__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__41284__auto____0 = (function (){
var statearr_42930 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42930[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__41284__auto__);

(statearr_42930[(1)] = (1));

return statearr_42930;
});
var cljs$core$async$mapcat_STAR__$_state_machine__41284__auto____1 = (function (state_42893){
while(true){
var ret_value__41285__auto__ = (function (){try{while(true){
var result__41286__auto__ = switch__41283__auto__(state_42893);
if(cljs.core.keyword_identical_QMARK_(result__41286__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41286__auto__;
}
break;
}
}catch (e42931){var ex__41287__auto__ = e42931;
var statearr_42932_43820 = state_42893;
(statearr_42932_43820[(2)] = ex__41287__auto__);


if(cljs.core.seq((state_42893[(4)]))){
var statearr_42933_43821 = state_42893;
(statearr_42933_43821[(1)] = cljs.core.first((state_42893[(4)])));

} else {
throw ex__41287__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41285__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43824 = state_42893;
state_42893 = G__43824;
continue;
} else {
return ret_value__41285__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__41284__auto__ = function(state_42893){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__41284__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__41284__auto____1.call(this,state_42893);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__41284__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__41284__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__41284__auto__;
})()
})();
var state__41389__auto__ = (function (){var statearr_42934 = f__41388__auto__();
(statearr_42934[(6)] = c__41387__auto__);

return statearr_42934;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41389__auto__);
}));

return c__41387__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__42936 = arguments.length;
switch (G__42936) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__42938 = arguments.length;
switch (G__42938) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__42940 = arguments.length;
switch (G__42940) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__41387__auto___43839 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41388__auto__ = (function (){var switch__41283__auto__ = (function (state_42964){
var state_val_42965 = (state_42964[(1)]);
if((state_val_42965 === (7))){
var inst_42959 = (state_42964[(2)]);
var state_42964__$1 = state_42964;
var statearr_42966_43840 = state_42964__$1;
(statearr_42966_43840[(2)] = inst_42959);

(statearr_42966_43840[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42965 === (1))){
var inst_42941 = null;
var state_42964__$1 = (function (){var statearr_42967 = state_42964;
(statearr_42967[(7)] = inst_42941);

return statearr_42967;
})();
var statearr_42968_43842 = state_42964__$1;
(statearr_42968_43842[(2)] = null);

(statearr_42968_43842[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42965 === (4))){
var inst_42944 = (state_42964[(8)]);
var inst_42944__$1 = (state_42964[(2)]);
var inst_42945 = (inst_42944__$1 == null);
var inst_42946 = cljs.core.not(inst_42945);
var state_42964__$1 = (function (){var statearr_42969 = state_42964;
(statearr_42969[(8)] = inst_42944__$1);

return statearr_42969;
})();
if(inst_42946){
var statearr_42970_43843 = state_42964__$1;
(statearr_42970_43843[(1)] = (5));

} else {
var statearr_42971_43844 = state_42964__$1;
(statearr_42971_43844[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42965 === (6))){
var state_42964__$1 = state_42964;
var statearr_42972_43847 = state_42964__$1;
(statearr_42972_43847[(2)] = null);

(statearr_42972_43847[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42965 === (3))){
var inst_42961 = (state_42964[(2)]);
var inst_42962 = cljs.core.async.close_BANG_(out);
var state_42964__$1 = (function (){var statearr_42973 = state_42964;
(statearr_42973[(9)] = inst_42961);

return statearr_42973;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_42964__$1,inst_42962);
} else {
if((state_val_42965 === (2))){
var state_42964__$1 = state_42964;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42964__$1,(4),ch);
} else {
if((state_val_42965 === (11))){
var inst_42944 = (state_42964[(8)]);
var inst_42953 = (state_42964[(2)]);
var inst_42941 = inst_42944;
var state_42964__$1 = (function (){var statearr_42974 = state_42964;
(statearr_42974[(10)] = inst_42953);

(statearr_42974[(7)] = inst_42941);

return statearr_42974;
})();
var statearr_42975_43850 = state_42964__$1;
(statearr_42975_43850[(2)] = null);

(statearr_42975_43850[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42965 === (9))){
var inst_42944 = (state_42964[(8)]);
var state_42964__$1 = state_42964;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42964__$1,(11),out,inst_42944);
} else {
if((state_val_42965 === (5))){
var inst_42944 = (state_42964[(8)]);
var inst_42941 = (state_42964[(7)]);
var inst_42948 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_42944,inst_42941);
var state_42964__$1 = state_42964;
if(inst_42948){
var statearr_42977_43854 = state_42964__$1;
(statearr_42977_43854[(1)] = (8));

} else {
var statearr_42978_43855 = state_42964__$1;
(statearr_42978_43855[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42965 === (10))){
var inst_42956 = (state_42964[(2)]);
var state_42964__$1 = state_42964;
var statearr_42979_43856 = state_42964__$1;
(statearr_42979_43856[(2)] = inst_42956);

(statearr_42979_43856[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42965 === (8))){
var inst_42941 = (state_42964[(7)]);
var tmp42976 = inst_42941;
var inst_42941__$1 = tmp42976;
var state_42964__$1 = (function (){var statearr_42980 = state_42964;
(statearr_42980[(7)] = inst_42941__$1);

return statearr_42980;
})();
var statearr_42981_43857 = state_42964__$1;
(statearr_42981_43857[(2)] = null);

(statearr_42981_43857[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41284__auto__ = null;
var cljs$core$async$state_machine__41284__auto____0 = (function (){
var statearr_42982 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_42982[(0)] = cljs$core$async$state_machine__41284__auto__);

(statearr_42982[(1)] = (1));

return statearr_42982;
});
var cljs$core$async$state_machine__41284__auto____1 = (function (state_42964){
while(true){
var ret_value__41285__auto__ = (function (){try{while(true){
var result__41286__auto__ = switch__41283__auto__(state_42964);
if(cljs.core.keyword_identical_QMARK_(result__41286__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41286__auto__;
}
break;
}
}catch (e42983){var ex__41287__auto__ = e42983;
var statearr_42984_43859 = state_42964;
(statearr_42984_43859[(2)] = ex__41287__auto__);


if(cljs.core.seq((state_42964[(4)]))){
var statearr_42985_43860 = state_42964;
(statearr_42985_43860[(1)] = cljs.core.first((state_42964[(4)])));

} else {
throw ex__41287__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41285__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43861 = state_42964;
state_42964 = G__43861;
continue;
} else {
return ret_value__41285__auto__;
}
break;
}
});
cljs$core$async$state_machine__41284__auto__ = function(state_42964){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41284__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41284__auto____1.call(this,state_42964);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41284__auto____0;
cljs$core$async$state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41284__auto____1;
return cljs$core$async$state_machine__41284__auto__;
})()
})();
var state__41389__auto__ = (function (){var statearr_42986 = f__41388__auto__();
(statearr_42986[(6)] = c__41387__auto___43839);

return statearr_42986;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41389__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__42988 = arguments.length;
switch (G__42988) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__41387__auto___43863 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41388__auto__ = (function (){var switch__41283__auto__ = (function (state_43026){
var state_val_43027 = (state_43026[(1)]);
if((state_val_43027 === (7))){
var inst_43022 = (state_43026[(2)]);
var state_43026__$1 = state_43026;
var statearr_43028_43868 = state_43026__$1;
(statearr_43028_43868[(2)] = inst_43022);

(statearr_43028_43868[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43027 === (1))){
var inst_42989 = (new Array(n));
var inst_42990 = inst_42989;
var inst_42991 = (0);
var state_43026__$1 = (function (){var statearr_43029 = state_43026;
(statearr_43029[(7)] = inst_42990);

(statearr_43029[(8)] = inst_42991);

return statearr_43029;
})();
var statearr_43030_43869 = state_43026__$1;
(statearr_43030_43869[(2)] = null);

(statearr_43030_43869[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43027 === (4))){
var inst_42994 = (state_43026[(9)]);
var inst_42994__$1 = (state_43026[(2)]);
var inst_42995 = (inst_42994__$1 == null);
var inst_42996 = cljs.core.not(inst_42995);
var state_43026__$1 = (function (){var statearr_43031 = state_43026;
(statearr_43031[(9)] = inst_42994__$1);

return statearr_43031;
})();
if(inst_42996){
var statearr_43032_43870 = state_43026__$1;
(statearr_43032_43870[(1)] = (5));

} else {
var statearr_43033_43871 = state_43026__$1;
(statearr_43033_43871[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43027 === (15))){
var inst_43016 = (state_43026[(2)]);
var state_43026__$1 = state_43026;
var statearr_43034_43872 = state_43026__$1;
(statearr_43034_43872[(2)] = inst_43016);

(statearr_43034_43872[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43027 === (13))){
var state_43026__$1 = state_43026;
var statearr_43035_43873 = state_43026__$1;
(statearr_43035_43873[(2)] = null);

(statearr_43035_43873[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43027 === (6))){
var inst_42991 = (state_43026[(8)]);
var inst_43012 = (inst_42991 > (0));
var state_43026__$1 = state_43026;
if(cljs.core.truth_(inst_43012)){
var statearr_43036_43874 = state_43026__$1;
(statearr_43036_43874[(1)] = (12));

} else {
var statearr_43037_43875 = state_43026__$1;
(statearr_43037_43875[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43027 === (3))){
var inst_43024 = (state_43026[(2)]);
var state_43026__$1 = state_43026;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43026__$1,inst_43024);
} else {
if((state_val_43027 === (12))){
var inst_42990 = (state_43026[(7)]);
var inst_43014 = cljs.core.vec(inst_42990);
var state_43026__$1 = state_43026;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43026__$1,(15),out,inst_43014);
} else {
if((state_val_43027 === (2))){
var state_43026__$1 = state_43026;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43026__$1,(4),ch);
} else {
if((state_val_43027 === (11))){
var inst_43006 = (state_43026[(2)]);
var inst_43007 = (new Array(n));
var inst_42990 = inst_43007;
var inst_42991 = (0);
var state_43026__$1 = (function (){var statearr_43038 = state_43026;
(statearr_43038[(10)] = inst_43006);

(statearr_43038[(7)] = inst_42990);

(statearr_43038[(8)] = inst_42991);

return statearr_43038;
})();
var statearr_43039_43876 = state_43026__$1;
(statearr_43039_43876[(2)] = null);

(statearr_43039_43876[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43027 === (9))){
var inst_42990 = (state_43026[(7)]);
var inst_43004 = cljs.core.vec(inst_42990);
var state_43026__$1 = state_43026;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43026__$1,(11),out,inst_43004);
} else {
if((state_val_43027 === (5))){
var inst_42990 = (state_43026[(7)]);
var inst_42991 = (state_43026[(8)]);
var inst_42994 = (state_43026[(9)]);
var inst_42999 = (state_43026[(11)]);
var inst_42998 = (inst_42990[inst_42991] = inst_42994);
var inst_42999__$1 = (inst_42991 + (1));
var inst_43000 = (inst_42999__$1 < n);
var state_43026__$1 = (function (){var statearr_43041 = state_43026;
(statearr_43041[(12)] = inst_42998);

(statearr_43041[(11)] = inst_42999__$1);

return statearr_43041;
})();
if(cljs.core.truth_(inst_43000)){
var statearr_43042_43877 = state_43026__$1;
(statearr_43042_43877[(1)] = (8));

} else {
var statearr_43043_43878 = state_43026__$1;
(statearr_43043_43878[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43027 === (14))){
var inst_43019 = (state_43026[(2)]);
var inst_43020 = cljs.core.async.close_BANG_(out);
var state_43026__$1 = (function (){var statearr_43045 = state_43026;
(statearr_43045[(13)] = inst_43019);

return statearr_43045;
})();
var statearr_43046_43879 = state_43026__$1;
(statearr_43046_43879[(2)] = inst_43020);

(statearr_43046_43879[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43027 === (10))){
var inst_43010 = (state_43026[(2)]);
var state_43026__$1 = state_43026;
var statearr_43047_43880 = state_43026__$1;
(statearr_43047_43880[(2)] = inst_43010);

(statearr_43047_43880[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43027 === (8))){
var inst_42990 = (state_43026[(7)]);
var inst_42999 = (state_43026[(11)]);
var tmp43044 = inst_42990;
var inst_42990__$1 = tmp43044;
var inst_42991 = inst_42999;
var state_43026__$1 = (function (){var statearr_43048 = state_43026;
(statearr_43048[(7)] = inst_42990__$1);

(statearr_43048[(8)] = inst_42991);

return statearr_43048;
})();
var statearr_43049_43881 = state_43026__$1;
(statearr_43049_43881[(2)] = null);

(statearr_43049_43881[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41284__auto__ = null;
var cljs$core$async$state_machine__41284__auto____0 = (function (){
var statearr_43051 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43051[(0)] = cljs$core$async$state_machine__41284__auto__);

(statearr_43051[(1)] = (1));

return statearr_43051;
});
var cljs$core$async$state_machine__41284__auto____1 = (function (state_43026){
while(true){
var ret_value__41285__auto__ = (function (){try{while(true){
var result__41286__auto__ = switch__41283__auto__(state_43026);
if(cljs.core.keyword_identical_QMARK_(result__41286__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41286__auto__;
}
break;
}
}catch (e43052){var ex__41287__auto__ = e43052;
var statearr_43053_43882 = state_43026;
(statearr_43053_43882[(2)] = ex__41287__auto__);


if(cljs.core.seq((state_43026[(4)]))){
var statearr_43054_43883 = state_43026;
(statearr_43054_43883[(1)] = cljs.core.first((state_43026[(4)])));

} else {
throw ex__41287__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41285__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43884 = state_43026;
state_43026 = G__43884;
continue;
} else {
return ret_value__41285__auto__;
}
break;
}
});
cljs$core$async$state_machine__41284__auto__ = function(state_43026){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41284__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41284__auto____1.call(this,state_43026);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41284__auto____0;
cljs$core$async$state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41284__auto____1;
return cljs$core$async$state_machine__41284__auto__;
})()
})();
var state__41389__auto__ = (function (){var statearr_43055 = f__41388__auto__();
(statearr_43055[(6)] = c__41387__auto___43863);

return statearr_43055;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41389__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__43057 = arguments.length;
switch (G__43057) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__41387__auto___43886 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41388__auto__ = (function (){var switch__41283__auto__ = (function (state_43104){
var state_val_43105 = (state_43104[(1)]);
if((state_val_43105 === (7))){
var inst_43100 = (state_43104[(2)]);
var state_43104__$1 = state_43104;
var statearr_43107_43887 = state_43104__$1;
(statearr_43107_43887[(2)] = inst_43100);

(statearr_43107_43887[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43105 === (1))){
var inst_43059 = [];
var inst_43060 = inst_43059;
var inst_43061 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_43104__$1 = (function (){var statearr_43109 = state_43104;
(statearr_43109[(7)] = inst_43060);

(statearr_43109[(8)] = inst_43061);

return statearr_43109;
})();
var statearr_43110_43888 = state_43104__$1;
(statearr_43110_43888[(2)] = null);

(statearr_43110_43888[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43105 === (4))){
var inst_43064 = (state_43104[(9)]);
var inst_43064__$1 = (state_43104[(2)]);
var inst_43065 = (inst_43064__$1 == null);
var inst_43066 = cljs.core.not(inst_43065);
var state_43104__$1 = (function (){var statearr_43111 = state_43104;
(statearr_43111[(9)] = inst_43064__$1);

return statearr_43111;
})();
if(inst_43066){
var statearr_43112_43889 = state_43104__$1;
(statearr_43112_43889[(1)] = (5));

} else {
var statearr_43113_43890 = state_43104__$1;
(statearr_43113_43890[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43105 === (15))){
var inst_43060 = (state_43104[(7)]);
var inst_43092 = cljs.core.vec(inst_43060);
var state_43104__$1 = state_43104;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43104__$1,(18),out,inst_43092);
} else {
if((state_val_43105 === (13))){
var inst_43087 = (state_43104[(2)]);
var state_43104__$1 = state_43104;
var statearr_43115_43891 = state_43104__$1;
(statearr_43115_43891[(2)] = inst_43087);

(statearr_43115_43891[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43105 === (6))){
var inst_43060 = (state_43104[(7)]);
var inst_43089 = inst_43060.length;
var inst_43090 = (inst_43089 > (0));
var state_43104__$1 = state_43104;
if(cljs.core.truth_(inst_43090)){
var statearr_43116_43892 = state_43104__$1;
(statearr_43116_43892[(1)] = (15));

} else {
var statearr_43117_43893 = state_43104__$1;
(statearr_43117_43893[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43105 === (17))){
var inst_43097 = (state_43104[(2)]);
var inst_43098 = cljs.core.async.close_BANG_(out);
var state_43104__$1 = (function (){var statearr_43118 = state_43104;
(statearr_43118[(10)] = inst_43097);

return statearr_43118;
})();
var statearr_43119_43894 = state_43104__$1;
(statearr_43119_43894[(2)] = inst_43098);

(statearr_43119_43894[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43105 === (3))){
var inst_43102 = (state_43104[(2)]);
var state_43104__$1 = state_43104;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43104__$1,inst_43102);
} else {
if((state_val_43105 === (12))){
var inst_43060 = (state_43104[(7)]);
var inst_43079 = cljs.core.vec(inst_43060);
var state_43104__$1 = state_43104;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43104__$1,(14),out,inst_43079);
} else {
if((state_val_43105 === (2))){
var state_43104__$1 = state_43104;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43104__$1,(4),ch);
} else {
if((state_val_43105 === (11))){
var inst_43060 = (state_43104[(7)]);
var inst_43064 = (state_43104[(9)]);
var inst_43068 = (state_43104[(11)]);
var inst_43076 = inst_43060.push(inst_43064);
var tmp43120 = inst_43060;
var inst_43060__$1 = tmp43120;
var inst_43061 = inst_43068;
var state_43104__$1 = (function (){var statearr_43122 = state_43104;
(statearr_43122[(12)] = inst_43076);

(statearr_43122[(7)] = inst_43060__$1);

(statearr_43122[(8)] = inst_43061);

return statearr_43122;
})();
var statearr_43123_43896 = state_43104__$1;
(statearr_43123_43896[(2)] = null);

(statearr_43123_43896[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43105 === (9))){
var inst_43061 = (state_43104[(8)]);
var inst_43072 = cljs.core.keyword_identical_QMARK_(inst_43061,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_43104__$1 = state_43104;
var statearr_43124_43897 = state_43104__$1;
(statearr_43124_43897[(2)] = inst_43072);

(statearr_43124_43897[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43105 === (5))){
var inst_43064 = (state_43104[(9)]);
var inst_43068 = (state_43104[(11)]);
var inst_43061 = (state_43104[(8)]);
var inst_43069 = (state_43104[(13)]);
var inst_43068__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_43064) : f.call(null,inst_43064));
var inst_43069__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_43068__$1,inst_43061);
var state_43104__$1 = (function (){var statearr_43125 = state_43104;
(statearr_43125[(11)] = inst_43068__$1);

(statearr_43125[(13)] = inst_43069__$1);

return statearr_43125;
})();
if(inst_43069__$1){
var statearr_43126_43899 = state_43104__$1;
(statearr_43126_43899[(1)] = (8));

} else {
var statearr_43127_43900 = state_43104__$1;
(statearr_43127_43900[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43105 === (14))){
var inst_43064 = (state_43104[(9)]);
var inst_43068 = (state_43104[(11)]);
var inst_43081 = (state_43104[(2)]);
var inst_43083 = [];
var inst_43084 = inst_43083.push(inst_43064);
var inst_43060 = inst_43083;
var inst_43061 = inst_43068;
var state_43104__$1 = (function (){var statearr_43128 = state_43104;
(statearr_43128[(14)] = inst_43081);

(statearr_43128[(15)] = inst_43084);

(statearr_43128[(7)] = inst_43060);

(statearr_43128[(8)] = inst_43061);

return statearr_43128;
})();
var statearr_43129_43901 = state_43104__$1;
(statearr_43129_43901[(2)] = null);

(statearr_43129_43901[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43105 === (16))){
var state_43104__$1 = state_43104;
var statearr_43131_43902 = state_43104__$1;
(statearr_43131_43902[(2)] = null);

(statearr_43131_43902[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43105 === (10))){
var inst_43074 = (state_43104[(2)]);
var state_43104__$1 = state_43104;
if(cljs.core.truth_(inst_43074)){
var statearr_43132_43903 = state_43104__$1;
(statearr_43132_43903[(1)] = (11));

} else {
var statearr_43133_43904 = state_43104__$1;
(statearr_43133_43904[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43105 === (18))){
var inst_43094 = (state_43104[(2)]);
var state_43104__$1 = state_43104;
var statearr_43134_43905 = state_43104__$1;
(statearr_43134_43905[(2)] = inst_43094);

(statearr_43134_43905[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43105 === (8))){
var inst_43069 = (state_43104[(13)]);
var state_43104__$1 = state_43104;
var statearr_43135_43906 = state_43104__$1;
(statearr_43135_43906[(2)] = inst_43069);

(statearr_43135_43906[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41284__auto__ = null;
var cljs$core$async$state_machine__41284__auto____0 = (function (){
var statearr_43136 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43136[(0)] = cljs$core$async$state_machine__41284__auto__);

(statearr_43136[(1)] = (1));

return statearr_43136;
});
var cljs$core$async$state_machine__41284__auto____1 = (function (state_43104){
while(true){
var ret_value__41285__auto__ = (function (){try{while(true){
var result__41286__auto__ = switch__41283__auto__(state_43104);
if(cljs.core.keyword_identical_QMARK_(result__41286__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41286__auto__;
}
break;
}
}catch (e43137){var ex__41287__auto__ = e43137;
var statearr_43138_43907 = state_43104;
(statearr_43138_43907[(2)] = ex__41287__auto__);


if(cljs.core.seq((state_43104[(4)]))){
var statearr_43139_43908 = state_43104;
(statearr_43139_43908[(1)] = cljs.core.first((state_43104[(4)])));

} else {
throw ex__41287__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41285__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43910 = state_43104;
state_43104 = G__43910;
continue;
} else {
return ret_value__41285__auto__;
}
break;
}
});
cljs$core$async$state_machine__41284__auto__ = function(state_43104){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41284__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41284__auto____1.call(this,state_43104);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41284__auto____0;
cljs$core$async$state_machine__41284__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41284__auto____1;
return cljs$core$async$state_machine__41284__auto__;
})()
})();
var state__41389__auto__ = (function (){var statearr_43141 = f__41388__auto__();
(statearr_43141[(6)] = c__41387__auto___43886);

return statearr_43141;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41389__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
