goog.provide('cljs.analyzer.impl.namespaces');
/**
 * Given a libspec return a map of :as-alias alias, if was present. Return the
 * libspec with :as-alias elided. If the libspec was *only* :as-alias do not
 * return it.
 */
cljs.analyzer.impl.namespaces.check_and_remove_as_alias = (function cljs$analyzer$impl$namespaces$check_and_remove_as_alias(libspec){
if((((libspec instanceof cljs.core.Symbol)) || ((libspec instanceof cljs.core.Keyword)))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"libspec","libspec",1228503756),libspec], null);
} else {
var vec__46481 = libspec;
var seq__46482 = cljs.core.seq(vec__46481);
var first__46483 = cljs.core.first(seq__46482);
var seq__46482__$1 = cljs.core.next(seq__46482);
var lib = first__46483;
var spec = seq__46482__$1;
var libspec__$1 = vec__46481;
var vec__46484 = cljs.core.split_with(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"as-alias","as-alias",82482467),null], null), null)),spec);
var pre_spec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46484,(0),null);
var vec__46487 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46484,(1),null);
var seq__46488 = cljs.core.seq(vec__46487);
var first__46489 = cljs.core.first(seq__46488);
var seq__46488__$1 = cljs.core.next(seq__46488);
var _ = first__46489;
var first__46489__$1 = cljs.core.first(seq__46488__$1);
var seq__46488__$2 = cljs.core.next(seq__46488__$1);
var alias = first__46489__$1;
var post_spec = seq__46488__$2;
var post = vec__46487;
if(cljs.core.seq(post)){
var libspec_SINGLEQUOTE_ = cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [lib], null),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(pre_spec,post_spec));
if((alias instanceof cljs.core.Symbol)){
} else {
throw (new Error(["Assert failed: ",[":as-alias must be followed by a symbol, got: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(alias)].join(''),"\n","(symbol? alias)"].join('')));
}

var G__46490 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"as-alias","as-alias",82482467),cljs.core.PersistentArrayMap.createAsIfByAssoc([alias,lib])], null);
if((cljs.core.count(libspec_SINGLEQUOTE_) > (1))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__46490,new cljs.core.Keyword(null,"libspec","libspec",1228503756),libspec_SINGLEQUOTE_);
} else {
return G__46490;
}
} else {
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"libspec","libspec",1228503756),libspec__$1], null);
}
}
});
cljs.analyzer.impl.namespaces.check_as_alias_duplicates = (function cljs$analyzer$impl$namespaces$check_as_alias_duplicates(as_aliases,new_as_aliases){
var seq__46491 = cljs.core.seq(new_as_aliases);
var chunk__46492 = null;
var count__46493 = (0);
var i__46494 = (0);
while(true){
if((i__46494 < count__46493)){
var vec__46501 = chunk__46492.cljs$core$IIndexed$_nth$arity$2(null,i__46494);
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46501,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46501,(1),null);
if((!(cljs.core.contains_QMARK_(as_aliases,alias)))){
} else {
throw (new Error(["Assert failed: ",["Duplicate :as-alias ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(alias),", already in use for lib ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$2(as_aliases,alias))].join(''),"\n","(not (contains? as-aliases alias))"].join('')));
}


var G__46519 = seq__46491;
var G__46520 = chunk__46492;
var G__46521 = count__46493;
var G__46522 = (i__46494 + (1));
seq__46491 = G__46519;
chunk__46492 = G__46520;
count__46493 = G__46521;
i__46494 = G__46522;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__46491);
if(temp__5823__auto__){
var seq__46491__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46491__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__46491__$1);
var G__46523 = cljs.core.chunk_rest(seq__46491__$1);
var G__46524 = c__5525__auto__;
var G__46525 = cljs.core.count(c__5525__auto__);
var G__46526 = (0);
seq__46491 = G__46523;
chunk__46492 = G__46524;
count__46493 = G__46525;
i__46494 = G__46526;
continue;
} else {
var vec__46504 = cljs.core.first(seq__46491__$1);
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46504,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46504,(1),null);
if((!(cljs.core.contains_QMARK_(as_aliases,alias)))){
} else {
throw (new Error(["Assert failed: ",["Duplicate :as-alias ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(alias),", already in use for lib ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$2(as_aliases,alias))].join(''),"\n","(not (contains? as-aliases alias))"].join('')));
}


var G__46527 = cljs.core.next(seq__46491__$1);
var G__46528 = null;
var G__46529 = (0);
var G__46530 = (0);
seq__46491 = G__46527;
chunk__46492 = G__46528;
count__46493 = G__46529;
i__46494 = G__46530;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Given libspecs, elide all :as-alias. Return a map of :libspecs (filtered)
 * and :as-aliases.
 */
cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs = (function cljs$analyzer$impl$namespaces$elide_aliases_from_libspecs(var_args){
var G__46508 = arguments.length;
switch (G__46508) {
case 1:
return cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$1 = (function (libspecs){
return cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$2(libspecs,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$2 = (function (libspecs,as_aliases){
var ret = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798),as_aliases,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.PersistentVector.EMPTY], null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__$1,libspec){
var map__46509 = cljs.analyzer.impl.namespaces.check_and_remove_as_alias(libspec);
var map__46509__$1 = cljs.core.__destructure_map(map__46509);
var as_alias = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46509__$1,new cljs.core.Keyword(null,"as-alias","as-alias",82482467));
var libspec__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46509__$1,new cljs.core.Keyword(null,"libspec","libspec",1228503756));
cljs.analyzer.impl.namespaces.check_as_alias_duplicates(new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798).cljs$core$IFn$_invoke$arity$1(ret__$1),as_alias);

var G__46510 = ret__$1;
var G__46510__$1 = (cljs.core.truth_(libspec__$1)?cljs.core.update.cljs$core$IFn$_invoke$arity$4(G__46510,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.conj,libspec__$1):G__46510);
if(cljs.core.truth_(as_alias)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(G__46510__$1,new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798),cljs.core.merge,as_alias);
} else {
return G__46510__$1;
}
}),ret,libspecs);
}));

(cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$lang$maxFixedArity = 2);

cljs.analyzer.impl.namespaces.elide_aliases_from_ns_specs = (function cljs$analyzer$impl$namespaces$elide_aliases_from_ns_specs(ns_specs){

var ret = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.PersistentVector.EMPTY], null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__46511,p__46512){
var map__46513 = p__46511;
var map__46513__$1 = cljs.core.__destructure_map(map__46513);
var ret__$1 = map__46513__$1;
var as_aliases = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46513__$1,new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798));
var vec__46514 = p__46512;
var seq__46515 = cljs.core.seq(vec__46514);
var first__46516 = cljs.core.first(seq__46515);
var seq__46515__$1 = cljs.core.next(seq__46515);
var spec_key = first__46516;
var libspecs = seq__46515__$1;
if((!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"refer-clojure","refer-clojure",813784440),spec_key)))){
var map__46517 = cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$2(libspecs,as_aliases);
var map__46517__$1 = cljs.core.__destructure_map(map__46517);
var as_aliases__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46517__$1,new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798));
var libspecs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46517__$1,new cljs.core.Keyword(null,"libspecs","libspecs",59807195));
var G__46518 = ret__$1;
var G__46518__$1 = (((!(cljs.core.empty_QMARK_(as_aliases__$1))))?cljs.core.update.cljs$core$IFn$_invoke$arity$4(G__46518,new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798),cljs.core.merge,as_aliases__$1):G__46518);
if((!(cljs.core.empty_QMARK_(libspecs__$1)))){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(G__46518__$1,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.conj,cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(spec_key,libspecs__$1));
} else {
return G__46518__$1;
}
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(ret__$1,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.conj,cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(spec_key,libspecs));
}
}),ret,ns_specs);
});

//# sourceMappingURL=cljs.analyzer.impl.namespaces.js.map
