(ns brainfloj.js-bridge
  (:require [brainfloj.wave-lexicon :as wave-lexicon]
            [brainfloj.state :as state]))

(defn ^:export init []
  (wave-lexicon/initialize-lexicon!))

(defn ^:export match-live-activity [category signatures]
  (state/call-fn! :match-live-activity category signatures))

(defn ^:export start-wave-signature-recording [profile category signature]
  (state/call-fn! :start-wave-signature-recording! profile category signature))

(defn ^:export stop-wave-signature-recording []
  (state/call-fn! :stop-wave-signature-recording!))
