(ns tggreene.easy-system
  (:require
   [aero.core :as aero]
   [clojure.java.io :as io]
   [integrant.core :as ig]))

(defmethod aero/reader 'ig/ref [_ _ value]
  (ig/ref value))

(defn- load-namespaces
  [system-config]
  (ig/load-namespaces system-config))

(defn config
  "Read EDN config, with the given aero options. See Aero docs at
  https://github.com/juxt/aero for details."
  [opts]
  (-> (io/resource "config.edn")
      (aero/read-config opts)))

(defn system-config
  "Construct a new system, configured with the given profile"
  [opts]
  (let [config (config opts)
        system-config (:ig/system config)]
    (load-namespaces system-config)
    (with-meta (ig/prep system-config)
      {:options opts})))
