goog.provide('taoensso.telemere.utils');
/**
 * `:info` -> "INFO",
 *     `5` -> "LEVEL:5", etc.
 */
taoensso.telemere.utils.format_level = taoensso.encore.signals.format_level;

/**
 * `:foo.bar/baz` -> "::baz", etc.
 */
taoensso.telemere.utils.format_id = taoensso.encore.signals.format_id;
/**
 * Alpha, subject to change.
 *   Returns a (fn nano-uid [root?]) that returns a random nano-style uid string like:
 *  "r76-B8LoIPs5lBG1_Uhdy" - 126 bit (21 char)     root         uid
 *  "tMEYoZH0K-"            - 60  bit (10 char) non-root (child) uid
 */
taoensso.telemere.utils.nano_uid_fn = (function taoensso$telemere$utils$nano_uid_fn(var_args){
var G__18283 = arguments.length;
switch (G__18283) {
case 0:
return taoensso.telemere.utils.nano_uid_fn.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.telemere.utils.nano_uid_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(taoensso.telemere.utils.nano_uid_fn.cljs$core$IFn$_invoke$arity$0 = (function (){
return taoensso.telemere.utils.nano_uid_fn.cljs$core$IFn$_invoke$arity$1(null);
}));

(taoensso.telemere.utils.nano_uid_fn.cljs$core$IFn$_invoke$arity$1 = (function (p__18284){
var map__18285 = p__18284;
var map__18285__$1 = cljs.core.__destructure_map(map__18285);
var secure_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18285__$1,new cljs.core.Keyword(null,"secure?","secure?",-368029718));
var root_len = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__18285__$1,new cljs.core.Keyword(null,"root-len","root-len",-204417175),(21));
var child_len = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__18285__$1,new cljs.core.Keyword(null,"child-len","child-len",1548141543),(10));
var root_len__$1 = cljs.core.long$(root_len);
var child_len__$1 = cljs.core.long$(child_len);
return (function taoensso$telemere$utils$nano_uid(root_QMARK_){
if(cljs.core.truth_(root_QMARK_)){
return taoensso.encore.nanoid.cljs$core$IFn$_invoke$arity$2(secure_QMARK_,root_len__$1);
} else {
return taoensso.encore.nanoid.cljs$core$IFn$_invoke$arity$2(secure_QMARK_,child_len__$1);
}
});
}));

(taoensso.telemere.utils.nano_uid_fn.cljs$lang$maxFixedArity = 1);

/**
 * Alpha, subject to change.
 *   Returns a (fn hex-uid [root?]) that returns a random hex-style uid string like:
 *  "05039666eb9dc3206475f44ab9f3d843" - 128 bit (32 char)     root         uid
 *  "721fcef639a51513"                 - 64  bit (16 char) non-root (child) uid
 */
taoensso.telemere.utils.hex_uid_fn = (function taoensso$telemere$utils$hex_uid_fn(var_args){
var G__18288 = arguments.length;
switch (G__18288) {
case 0:
return taoensso.telemere.utils.hex_uid_fn.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.telemere.utils.hex_uid_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(taoensso.telemere.utils.hex_uid_fn.cljs$core$IFn$_invoke$arity$0 = (function (){
return taoensso.telemere.utils.hex_uid_fn.cljs$core$IFn$_invoke$arity$1(null);
}));

(taoensso.telemere.utils.hex_uid_fn.cljs$core$IFn$_invoke$arity$1 = (function (p__18289){
var map__18290 = p__18289;
var map__18290__$1 = cljs.core.__destructure_map(map__18290);
var secure_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18290__$1,new cljs.core.Keyword(null,"secure?","secure?",-368029718));
var root_len = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__18290__$1,new cljs.core.Keyword(null,"root-len","root-len",-204417175),(32));
var child_len = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__18290__$1,new cljs.core.Keyword(null,"child-len","child-len",1548141543),(16));
var root_len__$1 = cljs.core.long$(root_len);
var child_len__$1 = cljs.core.long$(child_len);
var rand_bytes_fn = (cljs.core.truth_(secure_QMARK_)?cljs.core.partial.cljs$core$IFn$_invoke$arity$2(taoensso.encore.rand_bytes,true):cljs.core.partial.cljs$core$IFn$_invoke$arity$2(taoensso.encore.rand_bytes,false));
var hex_uid_root = taoensso.encore.rand_id_fn(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"chars","chars",-1094630317),new cljs.core.Keyword(null,"hex-lowercase","hex-lowercase",1090135664),new cljs.core.Keyword(null,"len","len",1423657078),root_len__$1,new cljs.core.Keyword(null,"rand-bytes-fn","rand-bytes-fn",501267911),rand_bytes_fn], null));
var hex_uid_child = taoensso.encore.rand_id_fn(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"chars","chars",-1094630317),new cljs.core.Keyword(null,"hex-lowercase","hex-lowercase",1090135664),new cljs.core.Keyword(null,"len","len",1423657078),child_len__$1,new cljs.core.Keyword(null,"rand-bytes-fn","rand-bytes-fn",501267911),rand_bytes_fn], null));
return (function taoensso$telemere$utils$hex_uid(root_QMARK_){
if(cljs.core.truth_(root_QMARK_)){
return hex_uid_root();
} else {
return hex_uid_child();
}
});
}));

(taoensso.telemere.utils.hex_uid_fn.cljs$lang$maxFixedArity = 1);

/**
 * Private, don't use.
 *   Returns (fn uid [root?]) for given uid kind.
 */
taoensso.telemere.utils.parse_uid_fn = (function taoensso$telemere$utils$parse_uid_fn(kind){
var G__18291 = kind;
var G__18291__$1 = (((G__18291 instanceof cljs.core.Keyword))?G__18291.fqn:null);
switch (G__18291__$1) {
case "uuid":
return (function (_root_QMARK_){
return taoensso.encore.uuid();
});

break;
case "uuid-str":
return (function (_root_QMARK_){
return taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$0();
});

break;
case "default":
return taoensso.telemere.utils.nano_uid_fn.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"secure?","secure?",-368029718),false], null));

break;
case "nano/insecure":
return taoensso.telemere.utils.nano_uid_fn.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"secure?","secure?",-368029718),false], null));

break;
case "nano/secure":
return taoensso.telemere.utils.nano_uid_fn.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"secure?","secure?",-368029718),true], null));

break;
case "hex/insecure":
return taoensso.telemere.utils.hex_uid_fn.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"secure?","secure?",-368029718),false], null));

break;
case "hex/secure":
return taoensso.telemere.utils.hex_uid_fn.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"secure?","secure?",-368029718),true], null));

break;
default:
var or__5002__auto__ = ((cljs.core.vector_QMARK_(kind))?(function (){var vec__18292 = kind;
var kind__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18292,(0),null);
var root_len = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18292,(1),null);
var child_len = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18292,(2),null);
var G__18295 = kind__$1;
var G__18295__$1 = (((G__18295 instanceof cljs.core.Keyword))?G__18295.fqn:null);
switch (G__18295__$1) {
case "nano/insecure":
return taoensso.telemere.utils.nano_uid_fn.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"secure?","secure?",-368029718),false,new cljs.core.Keyword(null,"root-len","root-len",-204417175),root_len,new cljs.core.Keyword(null,"child-len","child-len",1548141543),child_len], null));

break;
case "nano/secure":
return taoensso.telemere.utils.nano_uid_fn.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"secure?","secure?",-368029718),true,new cljs.core.Keyword(null,"root-len","root-len",-204417175),root_len,new cljs.core.Keyword(null,"child-len","child-len",1548141543),child_len], null));

break;
case "hex/insecure":
return taoensso.telemere.utils.hex_uid_fn.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"secure?","secure?",-368029718),false,new cljs.core.Keyword(null,"root-len","root-len",-204417175),root_len,new cljs.core.Keyword(null,"child-len","child-len",1548141543),child_len], null));

break;
case "hex/secure":
return taoensso.telemere.utils.hex_uid_fn.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"secure?","secure?",-368029718),true,new cljs.core.Keyword(null,"root-len","root-len",-204417175),root_len,new cljs.core.Keyword(null,"child-len","child-len",1548141543),child_len], null));

break;
default:
return null;

}
})():null);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return taoensso.truss.unexpected_arg_BANG__STAR_("taoensso.telemere.utils",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [122,7], null),kind,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"param","param",2013631823),new cljs.core.Symbol(null,"kind","kind",923265724,null),new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Symbol("taoensso.telemere.utils","uid-fn","taoensso.telemere.utils/uid-fn",790130699,null),new cljs.core.Keyword(null,"expected","expected",1583670997),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"default","default",-1987822328),"null",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nano","insecure","nano/insecure",-1399463185),new cljs.core.Symbol(null,"<root-len>","<root-len>",-540063912,null),new cljs.core.Symbol(null,"<child-len>","<child-len>",-1454733286,null)], null),"null",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nano","secure","nano/secure",174489112),new cljs.core.Symbol(null,"<root-len>","<root-len>",-540063912,null),new cljs.core.Symbol(null,"<child-len>","<child-len>",-1454733286,null)], null),"null",new cljs.core.Keyword("nano","insecure","nano/insecure",-1399463185),"null",new cljs.core.Keyword(null,"uuid-str","uuid-str",358395442),"null",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("hex","insecure","hex/insecure",-1411913130),new cljs.core.Symbol(null,"<root-len>","<root-len>",-540063912,null),new cljs.core.Symbol(null,"<child-len>","<child-len>",-1454733286,null)], null),"null",new cljs.core.Keyword("hex","insecure","hex/insecure",-1411913130),"null",new cljs.core.Keyword("nano","secure","nano/secure",174489112),"null",new cljs.core.Keyword(null,"uuid","uuid",-2145095719),"null",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("hex","secure","hex/secure",177509789),new cljs.core.Symbol(null,"<root-len>","<root-len>",-540063912,null),new cljs.core.Symbol(null,"<child-len>","<child-len>",-1454733286,null)], null),"null",new cljs.core.Keyword("hex","secure","hex/secure",177509789),"null"], null), null)], null));
}

}
});
/**
 * Single system newline
 */
taoensso.telemere.utils.newline = "\n";

/**
 * Prints given arg to an edn string readable with `read-edn`.
 */
taoensso.telemere.utils.pr_edn = taoensso.encore.pr_edn;

/**
 * Returns a random UUID string of given length (max 36).
 *   Uses strong randomness when possible. See also `uuid`, `nanoid`, `rand-id-fn`.
 */
taoensso.telemere.utils.uuid_str = taoensso.encore.uuid_str;

/**
 * Returns given Cljs argument as JSON string.
 */
taoensso.telemere.utils.pr_json = taoensso.encore.pr_json;
/**
 * Returns JavaScript console logger to match given signal level:
 *     `:debug` -> `js/console.debug`,
 *     `:error` -> `js/console.error`, etc.
 * 
 *   Defaults to `js.console.log` for unmatched signal levels.
 *   NB: assumes that `js/console` exists, handler constructors should check first!
 */
taoensso.telemere.utils.js_console_logger = (function taoensso$telemere$utils$js_console_logger(level){
var G__18296 = level;
var G__18296__$1 = (((G__18296 instanceof cljs.core.Keyword))?G__18296.fqn:null);
switch (G__18296__$1) {
case "trace":
return console.debug;

break;
case "debug":
return console.debug;

break;
case "info":
return console.info;

break;
case "warn":
return console.warn;

break;
case "error":
return console.error;

break;
case "fatal":
return console.error;

break;
case "report":
return console.info;

break;
default:
return console.log;

}
});
/**
 * Returns true iff given signal has an `:error` value, or a `:kind` or `:level`
 *   that indicates that it's an error.
 */
taoensso.telemere.utils.error_signal_QMARK_ = (function taoensso$telemere$utils$error_signal_QMARK_(signal){
var and__5000__auto__ = signal;
if(cljs.core.truth_(and__5000__auto__)){
return cljs.core.boolean$((function (){var or__5002__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(signal,new cljs.core.Keyword(null,"error","error",-978969032));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
var or__5002__auto____$1 = cljs.core.keyword_identical_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(signal,new cljs.core.Keyword(null,"kind","kind",-717265803)),new cljs.core.Keyword(null,"error","error",-978969032));
if(or__5002__auto____$1){
return or__5002__auto____$1;
} else {
var or__5002__auto____$2 = (function (){var G__18297 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(signal,new cljs.core.Keyword(null,"level","level",1290497552));
var G__18297__$1 = (((G__18297 instanceof cljs.core.Keyword))?G__18297.fqn:null);
switch (G__18297__$1) {
case "error":
case "fatal":
return true;

break;
default:
return false;

}
})();
if(cljs.core.truth_(or__5002__auto____$2)){
return or__5002__auto____$2;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(signal,new cljs.core.Keyword(null,"error?","error?",-460689159));
}
}
}
})());
} else {
return and__5000__auto__;
}
});
/**
 * Private, don't use.
 *   Returns given signal without app-level kvs or `:kvs` key.
 */
taoensso.telemere.utils.remove_signal_kvs = (function taoensso$telemere$utils$remove_signal_kvs(signal){
var temp__5802__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(signal,new cljs.core.Keyword(null,"kvs","kvs",958455492));
if(cljs.core.truth_(temp__5802__auto__)){
var kvs = temp__5802__auto__;
return cljs.core.reduce_kv((function (m,k,_v){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m,k);
}),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(signal,new cljs.core.Keyword(null,"kvs","kvs",958455492)),kvs);
} else {
return signal;
}
});
/**
 * Private, don't use.
 *   Returns given signal with nil-valued keys removed.
 */
taoensso.telemere.utils.remove_signal_nils = (function taoensso$telemere$utils$remove_signal_nils(signal){
if(taoensso.encore.editable_QMARK_(signal)){
return cljs.core.persistent_BANG_(cljs.core.reduce_kv((function (m,k,v){
if((v == null)){
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(m,k);
} else {
return m;
}
}),cljs.core.transient$(signal),signal));
} else {
return cljs.core.persistent_BANG_(cljs.core.reduce_kv((function (m,k,v){
if((v == null)){
return m;
} else {
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),signal));
}
});
/**
 * Private, don't use.
 *   Returns given signal with possible `:msg_` value forced (realized when a delay).
 */
taoensso.telemere.utils.force_signal_msg = (function taoensso$telemere$utils$force_signal_msg(signal){
var temp__5802__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(signal,new cljs.core.Keyword(null,"msg_","msg_",-1925147000));
if(cljs.core.truth_(temp__5802__auto__)){
var msg_ = temp__5802__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(signal,new cljs.core.Keyword(null,"msg_","msg_",-1925147000),cljs.core.force(msg_));
} else {
return signal;
}
});
/**
 * Private, don't use.
 *   Returns given signal with possible `:error` replaced by
 *   [{:keys [type msg data]} ...] cause chain.
 */
taoensso.telemere.utils.expand_signal_error = (function taoensso$telemere$utils$expand_signal_error(signal){
var b2__12658__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(signal,new cljs.core.Keyword(null,"error","error",-978969032));
if(cljs.core.truth_(b2__12658__auto__)){
var error = b2__12658__auto__;
var b2__12658__auto____$1 = taoensso.truss.ex_chain.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"as-map","as-map",633645847),error);
if(cljs.core.truth_(b2__12658__auto____$1)){
var chain = b2__12658__auto____$1;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(signal,new cljs.core.Keyword(null,"error","error",-978969032),chain);
} else {
return signal;
}
} else {
return signal;
}
});
/**
 * Alpha, subject to change.
 *   Returns a (fn format [nanosecs]) that:
 *  - Takes a long nanoseconds (e.g. runtime).
 *  - Returns a human-readable string like:
 *    "1.00m", "4.20s", "340ms", "822μs", etc.
 */
taoensso.telemere.utils.format_nsecs_fn = (function taoensso$telemere$utils$format_nsecs_fn(var_args){
var G__18303 = arguments.length;
switch (G__18303) {
case 0:
return taoensso.telemere.utils.format_nsecs_fn.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.telemere.utils.format_nsecs_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(taoensso.telemere.utils.format_nsecs_fn.cljs$core$IFn$_invoke$arity$0 = (function (){
return taoensso.telemere.utils.format_nsecs_fn.cljs$core$IFn$_invoke$arity$1(null);
}));

(taoensso.telemere.utils.format_nsecs_fn.cljs$core$IFn$_invoke$arity$1 = (function (p__18304){
var map__18305 = p__18304;
var map__18305__$1 = cljs.core.__destructure_map(map__18305);
var _opts = map__18305__$1;
return (function taoensso$telemere$utils$format_nsecs(nanosecs){
return taoensso.encore.format_nsecs(nanosecs);
});
}));

(taoensso.telemere.utils.format_nsecs_fn.cljs$lang$maxFixedArity = 1);

/**
 * Experimental, subject to change without notice.
 * 
 *   Returns a (fn format [instant]) that:
 *  - Takes a platform instant (`java.time.Instant` or `js/Date`).
 *  - Returns a formatted human-readable instant string.
 * 
 *   Options:
 *  `:formatter`
 *    Clj:  `java.time.format.DateTimeFormatter`
 *    Cljs: `goog.i18n.DateTimeFormat`
 * 
 *    Defaults to `ISO8601` formatter (`YYYY-MM-DDTHH:mm:ss.sssZ`),
 *    e.g.: "2011-12-03T10:15:130Z".
 * 
 *  `:zone` (Clj only) `java.time.ZoneOffset` (defaults to UTC).
 *   Note that zone may be ignored by some `DateTimeFormatter`s,
 *   including the default (`DateTimeFormatter/ISO_INSTANT`)!
 */
taoensso.telemere.utils.format_inst_fn = taoensso.encore.format_inst_fn;
/**
 * Alpha, subject to change.
 *   Returns a (fn format [error]) that:
 *  - Takes a platform error (`Throwable` or `js/Error`).
 *  - Returns a human-readable error string.
 */
taoensso.telemere.utils.format_error_fn = (function taoensso$telemere$utils$format_error_fn(var_args){
var G__18307 = arguments.length;
switch (G__18307) {
case 0:
return taoensso.telemere.utils.format_error_fn.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.telemere.utils.format_error_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(taoensso.telemere.utils.format_error_fn.cljs$core$IFn$_invoke$arity$0 = (function (){
return taoensso.telemere.utils.format_error_fn.cljs$core$IFn$_invoke$arity$1(null);
}));

(taoensso.telemere.utils.format_error_fn.cljs$core$IFn$_invoke$arity$1 = (function (p__18308){
var map__18309 = p__18308;
var map__18309__$1 = cljs.core.__destructure_map(map__18309);
var _opts = map__18309__$1;
var nl = "\n";
var nls = taoensso.encore.newlines;
return (function taoensso$telemere$utils$format_error(error){
var temp__5804__auto__ = taoensso.truss.ex_map(error);
if(cljs.core.truth_(temp__5804__auto__)){
var em = temp__5804__auto__;
var sb = taoensso.encore.str_builder.cljs$core$IFn$_invoke$arity$0();
var s_PLUS_ = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(taoensso.encore.sb_append,sb);
var map__18310 = em;
var map__18310__$1 = cljs.core.__destructure_map(map__18310);
var chain = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18310__$1,new cljs.core.Keyword(null,"chain","chain",15631029));
var trace = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18310__$1,new cljs.core.Keyword(null,"trace","trace",-1082747415));
var s_PLUS_cause_18390 = taoensso.encore.sb_appender.cljs$core$IFn$_invoke$arity$2(sb,[nls,"Caused: "].join(''));
s_PLUS_("Root: ");

var seq__18311_18391 = cljs.core.seq(cljs.core.rseq(chain));
var chunk__18312_18393 = null;
var count__18313_18394 = (0);
var i__18314_18395 = (0);
while(true){
if((i__18314_18395 < count__18313_18394)){
var map__18317_18396 = chunk__18312_18393.cljs$core$IIndexed$_nth$arity$2(null,i__18314_18395);
var map__18317_18397__$1 = cljs.core.__destructure_map(map__18317_18396);
var type_18398 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18317_18397__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var msg_18399 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18317_18397__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var data_18400 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18317_18397__$1,new cljs.core.Keyword(null,"data","data",-232669377));
s_PLUS_cause_18390(type_18398," - ",msg_18399);

if(cljs.core.truth_(data_18400)){
s_PLUS_(nl,"data: ",taoensso.encore.pr_edn_STAR_(data_18400));
} else {
}


var G__18401 = seq__18311_18391;
var G__18402 = chunk__18312_18393;
var G__18403 = count__18313_18394;
var G__18404 = (i__18314_18395 + (1));
seq__18311_18391 = G__18401;
chunk__18312_18393 = G__18402;
count__18313_18394 = G__18403;
i__18314_18395 = G__18404;
continue;
} else {
var temp__5804__auto___18405__$1 = cljs.core.seq(seq__18311_18391);
if(temp__5804__auto___18405__$1){
var seq__18311_18406__$1 = temp__5804__auto___18405__$1;
if(cljs.core.chunked_seq_QMARK_(seq__18311_18406__$1)){
var c__5525__auto___18407 = cljs.core.chunk_first(seq__18311_18406__$1);
var G__18408 = cljs.core.chunk_rest(seq__18311_18406__$1);
var G__18409 = c__5525__auto___18407;
var G__18410 = cljs.core.count(c__5525__auto___18407);
var G__18411 = (0);
seq__18311_18391 = G__18408;
chunk__18312_18393 = G__18409;
count__18313_18394 = G__18410;
i__18314_18395 = G__18411;
continue;
} else {
var map__18318_18412 = cljs.core.first(seq__18311_18406__$1);
var map__18318_18413__$1 = cljs.core.__destructure_map(map__18318_18412);
var type_18414 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18318_18413__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var msg_18415 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18318_18413__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var data_18416 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18318_18413__$1,new cljs.core.Keyword(null,"data","data",-232669377));
s_PLUS_cause_18390(type_18414," - ",msg_18415);

if(cljs.core.truth_(data_18416)){
s_PLUS_(nl,"data: ",taoensso.encore.pr_edn_STAR_(data_18416));
} else {
}


var G__18417 = cljs.core.next(seq__18311_18406__$1);
var G__18418 = null;
var G__18419 = (0);
var G__18420 = (0);
seq__18311_18391 = G__18417;
chunk__18312_18393 = G__18418;
count__18313_18394 = G__18419;
i__18314_18395 = G__18420;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(trace)){
s_PLUS_(nl,nl,"Root stack trace:",nl);

s_PLUS_(trace);
} else {
}

return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb);
} else {
return null;
}
});
}));

(taoensso.telemere.utils.format_error_fn.cljs$lang$maxFixedArity = 1);

/**
 * Alpha, subject to change.
 *   Returns a (fn preamble [signal]) that:
 *  - Takes a Telemere signal (map).
 *  - Returns a signal preamble ?string like:
 *    "2024-03-26T11:14:51.806Z INFO EVENT Hostname taoensso.telemere[2,21] ::ev-id msg"
 * 
 *   Options:
 *  `:format-inst-fn` - (fn format [instant]) => string.
 *  `:format-id-fn` --- (fn format [ns id])   => string.
 *  `:format-msg-fn` -- (fn format [msg])     => string.
 */
taoensso.telemere.utils.signal_preamble_fn = (function taoensso$telemere$utils$signal_preamble_fn(var_args){
var G__18320 = arguments.length;
switch (G__18320) {
case 0:
return taoensso.telemere.utils.signal_preamble_fn.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.telemere.utils.signal_preamble_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(taoensso.telemere.utils.signal_preamble_fn.cljs$core$IFn$_invoke$arity$0 = (function (){
return taoensso.telemere.utils.signal_preamble_fn.cljs$core$IFn$_invoke$arity$1(null);
}));

(taoensso.telemere.utils.signal_preamble_fn.cljs$core$IFn$_invoke$arity$1 = (function (p__18321){
var map__18322 = p__18321;
var map__18322__$1 = cljs.core.__destructure_map(map__18322);
var format_inst_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__18322__$1,new cljs.core.Keyword(null,"format-inst-fn","format-inst-fn",518148350),(taoensso.telemere.utils.format_inst_fn.cljs$core$IFn$_invoke$arity$0 ? taoensso.telemere.utils.format_inst_fn.cljs$core$IFn$_invoke$arity$0() : taoensso.telemere.utils.format_inst_fn.call(null)));
var format_id_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__18322__$1,new cljs.core.Keyword(null,"format-id-fn","format-id-fn",513589829),taoensso.telemere.utils.format_id);
var format_msg_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__18322__$1,new cljs.core.Keyword(null,"format-msg-fn","format-msg-fn",-1387049398),cljs.core.identity);
return (function taoensso$telemere$utils$signal_preamble(signal){
var map__18323 = signal;
var map__18323__$1 = cljs.core.__destructure_map(map__18323);
var inst = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18323__$1,new cljs.core.Keyword(null,"inst","inst",645962501));
var level = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18323__$1,new cljs.core.Keyword(null,"level","level",1290497552));
var kind = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18323__$1,new cljs.core.Keyword(null,"kind","kind",-717265803));
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18323__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18323__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var msg_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18323__$1,new cljs.core.Keyword(null,"msg_","msg_",-1925147000));
var sb = taoensso.encore.str_builder.cljs$core$IFn$_invoke$arity$0();
var s_PLUS_spc = taoensso.encore.sb_appender.cljs$core$IFn$_invoke$arity$2(sb," ");
if(cljs.core.truth_(inst)){
var temp__5804__auto___18422 = format_inst_fn;
if(cljs.core.truth_(temp__5804__auto___18422)){
var ff_18423 = temp__5804__auto___18422;
s_PLUS_spc((ff_18423.cljs$core$IFn$_invoke$arity$1 ? ff_18423.cljs$core$IFn$_invoke$arity$1(inst) : ff_18423.call(null,inst)));
} else {
}
} else {
}

if(cljs.core.truth_(level)){
s_PLUS_spc((taoensso.telemere.utils.format_level.cljs$core$IFn$_invoke$arity$1 ? taoensso.telemere.utils.format_level.cljs$core$IFn$_invoke$arity$1(level) : taoensso.telemere.utils.format_level.call(null,level)));
} else {
}

if(cljs.core.truth_(kind)){
s_PLUS_spc((taoensso.encore.signals.upper_qn.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.signals.upper_qn.cljs$core$IFn$_invoke$arity$1(kind) : taoensso.encore.signals.upper_qn.call(null,kind)));
} else {
}

if(cljs.core.truth_(ns)){
s_PLUS_spc(taoensso.encore.signals.format_callsite.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.get.cljs$core$IFn$_invoke$arity$2(signal,new cljs.core.Keyword(null,"coords","coords",-599429112))));
} else {
}

if(cljs.core.truth_(id)){
var temp__5804__auto___18425 = format_id_fn;
if(cljs.core.truth_(temp__5804__auto___18425)){
var ff_18426 = temp__5804__auto___18425;
s_PLUS_spc((ff_18426.cljs$core$IFn$_invoke$arity$2 ? ff_18426.cljs$core$IFn$_invoke$arity$2(ns,id) : ff_18426.call(null,ns,id)));
} else {
}
} else {
}

var b2__12658__auto___18427 = format_msg_fn;
if(cljs.core.truth_(b2__12658__auto___18427)){
var ff_18429 = b2__12658__auto___18427;
var b2__12658__auto___18430__$1 = cljs.core.force(msg_);
if(cljs.core.truth_(b2__12658__auto___18430__$1)){
var msg_18431 = b2__12658__auto___18430__$1;
s_PLUS_spc((ff_18429.cljs$core$IFn$_invoke$arity$1 ? ff_18429.cljs$core$IFn$_invoke$arity$1(msg_18431) : ff_18429.call(null,msg_18431)));
} else {
}
} else {
}

if((taoensso.encore.sb_length(sb) === (0))){
return null;
} else {
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb);
}
});
}));

(taoensso.telemere.utils.signal_preamble_fn.cljs$lang$maxFixedArity = 1);

taoensso.telemere.utils.format_parent = (function taoensso$telemere$utils$format_parent(ns,p__18324){
var map__18325 = p__18324;
var map__18325__$1 = cljs.core.__destructure_map(map__18325);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18325__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var uid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18325__$1,new cljs.core.Keyword(null,"uid","uid",-1447769400));
if(cljs.core.truth_(id)){
if(cljs.core.truth_(uid)){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((taoensso.telemere.utils.format_id.cljs$core$IFn$_invoke$arity$2 ? taoensso.telemere.utils.format_id.cljs$core$IFn$_invoke$arity$2(ns,id) : taoensso.telemere.utils.format_id.call(null,ns,id))),new cljs.core.Keyword(null,"uid","uid",-1447769400),uid], null);
} else {
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((taoensso.telemere.utils.format_id.cljs$core$IFn$_invoke$arity$2 ? taoensso.telemere.utils.format_id.cljs$core$IFn$_invoke$arity$2(ns,id) : taoensso.telemere.utils.format_id.call(null,ns,id)))], null);
}
} else {
if(cljs.core.truth_(uid)){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"uid","uid",-1447769400),uid], null);
} else {
return null;
}
}
});
/**
 * Alpha, subject to change.
 *   Returns a (fn content [signal]) that:
 *  - Takes a Telemere signal (map).
 *  - Returns a human-readable signal content ?string (incl. data, ctx, etc.).
 * 
 *   Options:
 *  `:raw-error?` ------ Retain unformatted error? (default false)
 *  `:incl-keys` ------- Subset of signal keys to retain from those
 *                       otherwise excluded by default: #{:kvs :host :thread}
 *  `:format-nsecs-fn` - (fn [nanosecs]) => string.
 *  `:format-error-fn` - (fn [error])    => string.
 */
taoensso.telemere.utils.signal_content_fn = (function taoensso$telemere$utils$signal_content_fn(var_args){
var G__18327 = arguments.length;
switch (G__18327) {
case 0:
return taoensso.telemere.utils.signal_content_fn.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.telemere.utils.signal_content_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(taoensso.telemere.utils.signal_content_fn.cljs$core$IFn$_invoke$arity$0 = (function (){
return taoensso.telemere.utils.signal_content_fn.cljs$core$IFn$_invoke$arity$1(null);
}));

(taoensso.telemere.utils.signal_content_fn.cljs$core$IFn$_invoke$arity$1 = (function (p__18328){
var map__18329 = p__18328;
var map__18329__$1 = cljs.core.__destructure_map(map__18329);
var raw_error_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18329__$1,new cljs.core.Keyword(null,"raw-error?","raw-error?",-39485940));
var incl_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18329__$1,new cljs.core.Keyword(null,"incl-keys","incl-keys",625658308));
var format_nsecs_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__18329__$1,new cljs.core.Keyword(null,"format-nsecs-fn","format-nsecs-fn",-1487810716),taoensso.telemere.utils.format_nsecs_fn.cljs$core$IFn$_invoke$arity$0());
var format_error_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__18329__$1,new cljs.core.Keyword(null,"format-error-fn","format-error-fn",-560488578),taoensso.telemere.utils.format_error_fn.cljs$core$IFn$_invoke$arity$0());
var nl = taoensso.telemere.utils.newline;
var err_start = [nl,"<<< error <<<",nl].join('');
var err_stop = [nl,">>> error >>>"].join('');
var incl_kvs_QMARK_ = cljs.core.contains_QMARK_(incl_keys,new cljs.core.Keyword(null,"kvs","kvs",958455492));
var incl_host_QMARK_ = cljs.core.contains_QMARK_(incl_keys,new cljs.core.Keyword(null,"host","host",-1558485167));
var incl_thread_QMARK_ = cljs.core.contains_QMARK_(incl_keys,new cljs.core.Keyword(null,"thread","thread",947001524));
return (function() {
var taoensso$telemere$utils$signal_content = null;
var taoensso$telemere$utils$signal_content__1 = (function (signal){
var sb = taoensso.encore.str_builder.cljs$core$IFn$_invoke$arity$0();
var s_PLUS__PLUS_ = taoensso.encore.sb_appender.cljs$core$IFn$_invoke$arity$2(sb,nl);
taoensso$telemere$utils$signal_content.cljs$core$IFn$_invoke$arity$3(signal,s_PLUS__PLUS_,taoensso.encore.pr_edn_STAR_);

if((taoensso.encore.sb_length(sb) === (0))){
return null;
} else {
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb);
}
});
var taoensso$telemere$utils$signal_content__3 = (function (signal,append_fn,val_fn){
var af = append_fn;
var vf = val_fn;
var map__18330_18435 = signal;
var map__18330_18436__$1 = cljs.core.__destructure_map(map__18330_18435);
var ns_18437 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18330_18436__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var uid_18438 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18330_18436__$1,new cljs.core.Keyword(null,"uid","uid",-1447769400));
var parent_18439 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18330_18436__$1,new cljs.core.Keyword(null,"parent","parent",-878878779));
var root_18440 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18330_18436__$1,new cljs.core.Keyword(null,"root","root",-448657453));
var data_18441 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18330_18436__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var kvs_18442 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18330_18436__$1,new cljs.core.Keyword(null,"kvs","kvs",958455492));
var ctx_18443 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18330_18436__$1,new cljs.core.Keyword(null,"ctx","ctx",-493610118));
var sample_18444 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18330_18436__$1,new cljs.core.Keyword(null,"sample","sample",79023601));
if(cljs.core.truth_(sample_18444)){
var G__18331_18446 = " sample: ";
var G__18332_18447 = (vf.cljs$core$IFn$_invoke$arity$1 ? vf.cljs$core$IFn$_invoke$arity$1(sample_18444) : vf.call(null,sample_18444));
(af.cljs$core$IFn$_invoke$arity$2 ? af.cljs$core$IFn$_invoke$arity$2(G__18331_18446,G__18332_18447) : af.call(null,G__18331_18446,G__18332_18447));
} else {
}

if(cljs.core.truth_(uid_18438)){
var G__18333_18448 = "    uid: ";
var G__18334_18449 = (vf.cljs$core$IFn$_invoke$arity$1 ? vf.cljs$core$IFn$_invoke$arity$1(uid_18438) : vf.call(null,uid_18438));
(af.cljs$core$IFn$_invoke$arity$2 ? af.cljs$core$IFn$_invoke$arity$2(G__18333_18448,G__18334_18449) : af.call(null,G__18333_18448,G__18334_18449));
} else {
}

if(cljs.core.truth_((function (){var and__5000__auto__ = parent_18439;
if(cljs.core.truth_(and__5000__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(parent_18439,root_18440);
} else {
return and__5000__auto__;
}
})())){
var G__18335_18450 = " parent: ";
var G__18336_18451 = (function (){var G__18337 = taoensso.telemere.utils.format_parent(ns_18437,parent_18439);
return (vf.cljs$core$IFn$_invoke$arity$1 ? vf.cljs$core$IFn$_invoke$arity$1(G__18337) : vf.call(null,G__18337));
})();
(af.cljs$core$IFn$_invoke$arity$2 ? af.cljs$core$IFn$_invoke$arity$2(G__18335_18450,G__18336_18451) : af.call(null,G__18335_18450,G__18336_18451));
} else {
}

if(cljs.core.truth_(root_18440)){
var G__18338_18452 = "   root: ";
var G__18339_18453 = (function (){var G__18340 = taoensso.telemere.utils.format_parent(ns_18437,root_18440);
return (vf.cljs$core$IFn$_invoke$arity$1 ? vf.cljs$core$IFn$_invoke$arity$1(G__18340) : vf.call(null,G__18340));
})();
(af.cljs$core$IFn$_invoke$arity$2 ? af.cljs$core$IFn$_invoke$arity$2(G__18338_18452,G__18339_18453) : af.call(null,G__18338_18452,G__18339_18453));
} else {
}

if(cljs.core.truth_(taoensso.encore.not_empty_coll(data_18441))){
var G__18341_18454 = "   data: ";
var G__18342_18455 = (vf.cljs$core$IFn$_invoke$arity$1 ? vf.cljs$core$IFn$_invoke$arity$1(data_18441) : vf.call(null,data_18441));
(af.cljs$core$IFn$_invoke$arity$2 ? af.cljs$core$IFn$_invoke$arity$2(G__18341_18454,G__18342_18455) : af.call(null,G__18341_18454,G__18342_18455));
} else {
}

if(cljs.core.truth_(taoensso.encore.not_empty_coll(ctx_18443))){
var G__18343_18456 = "    ctx: ";
var G__18344_18457 = (vf.cljs$core$IFn$_invoke$arity$1 ? vf.cljs$core$IFn$_invoke$arity$1(ctx_18443) : vf.call(null,ctx_18443));
(af.cljs$core$IFn$_invoke$arity$2 ? af.cljs$core$IFn$_invoke$arity$2(G__18343_18456,G__18344_18457) : af.call(null,G__18343_18456,G__18344_18457));
} else {
}

if((cljs.core.truth_(kvs_18442)?incl_kvs_QMARK_:false)){
var G__18345_18458 = "    kvs: ";
var G__18346_18459 = (vf.cljs$core$IFn$_invoke$arity$1 ? vf.cljs$core$IFn$_invoke$arity$1(kvs_18442) : vf.call(null,kvs_18442));
(af.cljs$core$IFn$_invoke$arity$2 ? af.cljs$core$IFn$_invoke$arity$2(G__18345_18458,G__18346_18459) : af.call(null,G__18345_18458,G__18346_18459));
} else {
}

var map__18347 = signal;
var map__18347__$1 = cljs.core.__destructure_map(map__18347);
var run_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18347__$1,new cljs.core.Keyword(null,"run-form","run-form",405647397));
var error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18347__$1,new cljs.core.Keyword(null,"error","error",-978969032));
if(cljs.core.truth_(run_form)){
var map__18348_18460 = signal;
var map__18348_18461__$1 = cljs.core.__destructure_map(map__18348_18460);
var run_val_18462 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18348_18461__$1,new cljs.core.Keyword(null,"run-val","run-val",-304326520));
var run_nsecs_18463 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18348_18461__$1,new cljs.core.Keyword(null,"run-nsecs","run-nsecs",32621724));
var run_time_18464 = (cljs.core.truth_(run_nsecs_18463)?(function (){var temp__5804__auto__ = format_nsecs_fn;
if(cljs.core.truth_(temp__5804__auto__)){
var ff = temp__5804__auto__;
return (ff.cljs$core$IFn$_invoke$arity$1 ? ff.cljs$core$IFn$_invoke$arity$1(run_nsecs_18463) : ff.call(null,run_nsecs_18463));
} else {
return null;
}
})():null);
var run_info_18465 = (cljs.core.truth_(error)?new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"form","form",-1624062471),run_form,new cljs.core.Keyword(null,"time","time",1385887882),run_time_18464,new cljs.core.Keyword(null,"nsecs","nsecs",1510077757),run_nsecs_18463], null):new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"form","form",-1624062471),run_form,new cljs.core.Keyword(null,"time","time",1385887882),run_time_18464,new cljs.core.Keyword(null,"nsecs","nsecs",1510077757),run_nsecs_18463,new cljs.core.Keyword(null,"val","val",128701612),run_val_18462], null));
var G__18349_18467 = "    run: ";
var G__18350_18468 = (vf.cljs$core$IFn$_invoke$arity$1 ? vf.cljs$core$IFn$_invoke$arity$1(run_info_18465) : vf.call(null,run_info_18465));
(af.cljs$core$IFn$_invoke$arity$2 ? af.cljs$core$IFn$_invoke$arity$2(G__18349_18467,G__18350_18468) : af.call(null,G__18349_18467,G__18350_18468));
} else {
}

if(cljs.core.truth_(error)){
if(cljs.core.truth_(raw_error_QMARK_)){
return (af.cljs$core$IFn$_invoke$arity$2 ? af.cljs$core$IFn$_invoke$arity$2("  error: ",error) : af.call(null,"  error: ",error));
} else {
var temp__5804__auto__ = format_error_fn;
if(cljs.core.truth_(temp__5804__auto__)){
var ff = temp__5804__auto__;
var G__18351 = err_start;
var G__18352 = (ff.cljs$core$IFn$_invoke$arity$1 ? ff.cljs$core$IFn$_invoke$arity$1(error) : ff.call(null,error));
var G__18353 = err_stop;
return (af.cljs$core$IFn$_invoke$arity$3 ? af.cljs$core$IFn$_invoke$arity$3(G__18351,G__18352,G__18353) : af.call(null,G__18351,G__18352,G__18353));
} else {
return null;
}
}
} else {
return null;
}
});
taoensso$telemere$utils$signal_content = function(signal,append_fn,val_fn){
switch(arguments.length){
case 1:
return taoensso$telemere$utils$signal_content__1.call(this,signal);
case 3:
return taoensso$telemere$utils$signal_content__3.call(this,signal,append_fn,val_fn);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$telemere$utils$signal_content.cljs$core$IFn$_invoke$arity$1 = taoensso$telemere$utils$signal_content__1;
taoensso$telemere$utils$signal_content.cljs$core$IFn$_invoke$arity$3 = taoensso$telemere$utils$signal_content__3;
return taoensso$telemere$utils$signal_content;
})()
}));

(taoensso.telemere.utils.signal_content_fn.cljs$lang$maxFixedArity = 1);

/**
 * Alpha, subject to change.
 *   Returns a (fn clean [signal]) that:
 *  - Takes a Telemere  signal (map).
 *  - Returns a minimal signal (map) ready for printing, etc.
 * 
 *   Signals are optimized for cheap creation and easy handling, so tend to be
 *   verbose and may contain things like nil values and duplicated content.
 * 
 *   This util efficiently cleans signals of such noise, helping reduce
 *   storage/transmission size, and making key info easier to see.
 * 
 *   Options:
 *  `:incl-nils?` - Include signal's keys with nil values? (default false)
 *  `:incl-kvs?` -- Include signal's app-level root kvs?   (default false)
 *  `:incl-keys` -- Subset of signal keys to retain from those otherwise
 *                  excluded by default: #{:schema :kvs :host :thread}
 */
taoensso.telemere.utils.clean_signal_fn = (function taoensso$telemere$utils$clean_signal_fn(var_args){
var G__18355 = arguments.length;
switch (G__18355) {
case 0:
return taoensso.telemere.utils.clean_signal_fn.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.telemere.utils.clean_signal_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(taoensso.telemere.utils.clean_signal_fn.cljs$core$IFn$_invoke$arity$0 = (function (){
return taoensso.telemere.utils.clean_signal_fn.cljs$core$IFn$_invoke$arity$1(null);
}));

(taoensso.telemere.utils.clean_signal_fn.cljs$core$IFn$_invoke$arity$1 = (function (p__18356){
var map__18357 = p__18356;
var map__18357__$1 = cljs.core.__destructure_map(map__18357);
var opts = map__18357__$1;
var incl_kvs_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18357__$1,new cljs.core.Keyword(null,"incl-kvs?","incl-kvs?",1936239040));
var incl_nils_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18357__$1,new cljs.core.Keyword(null,"incl-nils?","incl-nils?",-1704506526));
var incl_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18357__$1,new cljs.core.Keyword(null,"incl-keys","incl-keys",625658308));
var assoc_BANG__STAR_ = ((cljs.core.not(incl_nils_QMARK_))?(function (m,k,v){
if((v == null)){
return m;
} else {
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
}):cljs.core.assoc_BANG_);
var incl_schema_QMARK_ = cljs.core.contains_QMARK_(incl_keys,new cljs.core.Keyword(null,"schema","schema",-1582001791));
var incl_kvs_key_QMARK_ = cljs.core.contains_QMARK_(incl_keys,new cljs.core.Keyword(null,"kvs","kvs",958455492));
var incl_host_QMARK_ = cljs.core.contains_QMARK_(incl_keys,new cljs.core.Keyword(null,"host","host",-1558485167));
var incl_thread_QMARK_ = cljs.core.contains_QMARK_(incl_keys,new cljs.core.Keyword(null,"thread","thread",947001524));
return (function taoensso$telemere$utils$clean_signal(signal){
if(cljs.core.map_QMARK_(signal)){
return cljs.core.persistent_BANG_(cljs.core.reduce_kv((function (m,k,v){
var G__18362 = k;
var G__18362__$1 = (((G__18362 instanceof cljs.core.Keyword))?G__18362.fqn:null);
switch (G__18362__$1) {
case "data":
case "run-nsecs":
case "ctx":
case "kind":
case "id":
case "root":
case "sample":
case "level":
case "ns":
case "uid":
case "run-val":
case "coords":
case "parent":
case "inst":
case "run-form":
case "end-inst":
return (assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3 ? assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3(m,k,v) : assoc_BANG__STAR_.call(null,m,k,v));

break;
case "error":
var temp__5802__auto__ = taoensso.truss.ex_chain.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"as-map","as-map",633645847),v);
if(cljs.core.truth_(temp__5802__auto__)){
var chain = temp__5802__auto__;
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m,k,chain);
} else {
return m;
}

break;
case "msg_":
var G__18363 = m;
var G__18364 = k;
var G__18365 = cljs.core.force(v);
return (assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3 ? assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3(G__18363,G__18364,G__18365) : assoc_BANG__STAR_.call(null,G__18363,G__18364,G__18365));

break;
case "_otel-context":
return m;

break;
case "schema":
if(incl_schema_QMARK_){
return (assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3 ? assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3(m,k,v) : assoc_BANG__STAR_.call(null,m,k,v));
} else {
return m;
}

break;
case "kvs":
if(incl_kvs_key_QMARK_){
return (assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3 ? assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3(m,k,v) : assoc_BANG__STAR_.call(null,m,k,v));
} else {
return m;
}

break;
case "thread":
if(incl_thread_QMARK_){
return (assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3 ? assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3(m,k,v) : assoc_BANG__STAR_.call(null,m,k,v));
} else {
return m;
}

break;
case "host":
if(incl_host_QMARK_){
return (assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3 ? assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3(m,k,v) : assoc_BANG__STAR_.call(null,m,k,v));
} else {
return m;
}

break;
default:
if(cljs.core.truth_(incl_kvs_QMARK_)){
return (assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3 ? assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3(m,k,v) : assoc_BANG__STAR_.call(null,m,k,v));
} else {
if(cljs.core.contains_QMARK_(incl_keys,k)){
return (assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3 ? assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3(m,k,v) : assoc_BANG__STAR_.call(null,m,k,v));
} else {
return m;
}
}

}
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),signal));
} else {
return null;
}
});
}));

(taoensso.telemere.utils.clean_signal_fn.cljs$lang$maxFixedArity = 1);

/**
 * Alpha, subject to change.
 *   Returns a (fn pr [signal]) that:
 *  - Takes a Telemere signal (map).
 *  - Returns a machine-readable signal string.
 * 
 *   Options:
 *  `:pr-fn` --------- ∈ #{<unary-fn> :edn (default) :json (Cljs only)}
 *  `:clean-fn` ------ (fn [signal]) => clean signal map, see [1]
 *  `:incl-newline?` - Include terminating system newline? (default true)
 * 
 *   Examples:
 * 
 *  ;; To print as edn:
 *  (pr-signal-fn {:pr-fn :edn})
 * 
 *  ;; To print as JSON:
 *  ;; Ref.  <https://github.com/metosin/jsonista> (or any alt JSON lib)
 *  #?(:clj (require '[jsonista.core :as jsonista]))
 *  (pr-signal-fn
 *    {:pr-fn
 *      #?(:cljs :json ; Use js/JSON.stringify
 *         :clj  jsonista/write-value-as-string)})
 * 
 *   [1] `taoensso.telemere.utils/clean-signal-fn`, etc.
 * 
 *   See also `format-signal-fn` for an alternative to `pr-signal-fn`
 *   that produces human-readable output.
 */
taoensso.telemere.utils.pr_signal_fn = (function taoensso$telemere$utils$pr_signal_fn(var_args){
var G__18367 = arguments.length;
switch (G__18367) {
case 0:
return taoensso.telemere.utils.pr_signal_fn.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.telemere.utils.pr_signal_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(taoensso.telemere.utils.pr_signal_fn.cljs$core$IFn$_invoke$arity$0 = (function (){
return taoensso.telemere.utils.pr_signal_fn.cljs$core$IFn$_invoke$arity$1(null);
}));

(taoensso.telemere.utils.pr_signal_fn.cljs$core$IFn$_invoke$arity$1 = (function (p__18368){
var map__18369 = p__18368;
var map__18369__$1 = cljs.core.__destructure_map(map__18369);
var opts = map__18369__$1;
var pr_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__18369__$1,new cljs.core.Keyword(null,"pr-fn","pr-fn",2001500794),new cljs.core.Keyword(null,"edn","edn",1317840885));
var clean_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__18369__$1,new cljs.core.Keyword(null,"clean-fn","clean-fn",-1262646726),taoensso.telemere.utils.clean_signal_fn.cljs$core$IFn$_invoke$arity$0());
var incl_newline_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__18369__$1,new cljs.core.Keyword(null,"incl-newline?","incl-newline?",1384416974),true);
var nl = taoensso.telemere.utils.newline;
var pr_fn__$1 = (function (){var G__18370 = pr_fn;
var G__18370__$1 = (((G__18370 instanceof cljs.core.Keyword))?G__18370.fqn:null);
switch (G__18370__$1) {
case "edn":
return taoensso.telemere.utils.pr_edn;

break;
case "json":
return taoensso.telemere.utils.pr_json;

break;
default:
if(cljs.core.fn_QMARK_(pr_fn)){
return pr_fn;
} else {
return taoensso.truss.unexpected_arg_BANG__STAR_("taoensso.telemere.utils",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [762,16], null),pr_fn,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"param","param",2013631823),new cljs.core.Symbol(null,"pr-fn","pr-fn",-652934975,null),new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Symbol("taoensso.telemere.utils","pr-signal-fn","taoensso.telemere.utils/pr-signal-fn",-829484633,null),new cljs.core.Keyword(null,"expected","expected",1583670997),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Symbol(null,"unary-fn","unary-fn",1332940686,null),"null",new cljs.core.Keyword(null,"edn","edn",1317840885),"null",new cljs.core.Keyword(null,"json","json",1279968570),"null"], null), null)], null));
}

}
})();
return (function taoensso$telemere$utils$pr_signal(signal){
if(cljs.core.map_QMARK_(signal)){
if(cljs.core.truth_(incl_newline_QMARK_)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__18372 = (clean_fn.cljs$core$IFn$_invoke$arity$1 ? clean_fn.cljs$core$IFn$_invoke$arity$1(signal) : clean_fn.call(null,signal));
return (pr_fn__$1.cljs$core$IFn$_invoke$arity$1 ? pr_fn__$1.cljs$core$IFn$_invoke$arity$1(G__18372) : pr_fn__$1.call(null,G__18372));
})()),nl].join('');
} else {
var G__18373 = (clean_fn.cljs$core$IFn$_invoke$arity$1 ? clean_fn.cljs$core$IFn$_invoke$arity$1(signal) : clean_fn.call(null,signal));
return (pr_fn__$1.cljs$core$IFn$_invoke$arity$1 ? pr_fn__$1.cljs$core$IFn$_invoke$arity$1(G__18373) : pr_fn__$1.call(null,G__18373));
}
} else {
return null;
}
});
}));

(taoensso.telemere.utils.pr_signal_fn.cljs$lang$maxFixedArity = 1);

/**
 * Alpha, subject to change.
 *   Returns a (fn format [signal]) that:
 *  - Takes a Telemere signal (map).
 *  - Returns a human-readable signal string.
 * 
 *   Options:
 *  `:incl-newline?` - Include terminating system newline? (default true)
 *  `:preamble-fn` --- (fn [signal]) => signal preamble string, see [1]
 *  `:content-fn` ---- (fn [signal]) => signal content  string, see [2]
 * 
 *   [1] `taoensso.telemere.utils/signal-preamble-fn`, etc.
 *   [2] `taoensso.telemere.utils/signal-content-fn`,  etc.
 * 
 *   See also `pr-signal-fn` for an alternative to `format-signal-fn`
 *   that produces machine-readable output (edn, JSON, etc.).
 */
taoensso.telemere.utils.format_signal_fn = (function taoensso$telemere$utils$format_signal_fn(var_args){
var G__18375 = arguments.length;
switch (G__18375) {
case 0:
return taoensso.telemere.utils.format_signal_fn.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.telemere.utils.format_signal_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(taoensso.telemere.utils.format_signal_fn.cljs$core$IFn$_invoke$arity$0 = (function (){
return taoensso.telemere.utils.format_signal_fn.cljs$core$IFn$_invoke$arity$1(null);
}));

(taoensso.telemere.utils.format_signal_fn.cljs$core$IFn$_invoke$arity$1 = (function (p__18376){
var map__18377 = p__18376;
var map__18377__$1 = cljs.core.__destructure_map(map__18377);
var incl_newline_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__18377__$1,new cljs.core.Keyword(null,"incl-newline?","incl-newline?",1384416974),true);
var preamble_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__18377__$1,new cljs.core.Keyword(null,"preamble-fn","preamble-fn",-900320209),taoensso.telemere.utils.signal_preamble_fn.cljs$core$IFn$_invoke$arity$0());
var content_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__18377__$1,new cljs.core.Keyword(null,"content-fn","content-fn",-1280686114),taoensso.telemere.utils.signal_content_fn.cljs$core$IFn$_invoke$arity$0());
var nl = taoensso.telemere.utils.newline;
return (function taoensso$telemere$utils$format_signal(signal){
var preamble = (cljs.core.truth_(preamble_fn)?(preamble_fn.cljs$core$IFn$_invoke$arity$1 ? preamble_fn.cljs$core$IFn$_invoke$arity$1(signal) : preamble_fn.call(null,signal)):null);
var content = (cljs.core.truth_(content_fn)?(content_fn.cljs$core$IFn$_invoke$arity$1 ? content_fn.cljs$core$IFn$_invoke$arity$1(signal) : content_fn.call(null,signal)):null);
if(cljs.core.truth_((function (){var and__5000__auto__ = preamble;
if(cljs.core.truth_(and__5000__auto__)){
return content;
} else {
return and__5000__auto__;
}
})())){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(preamble),nl,cljs.core.str.cljs$core$IFn$_invoke$arity$1(content),(cljs.core.truth_(incl_newline_QMARK_)?nl:null)].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(preamble),cljs.core.str.cljs$core$IFn$_invoke$arity$1(content),(cljs.core.truth_(incl_newline_QMARK_)?nl:null)].join('');
}
});
}));

(taoensso.telemere.utils.format_signal_fn.cljs$lang$maxFixedArity = 1);


//# sourceMappingURL=taoensso.telemere.utils.js.map
