goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = true;

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_12562 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (shadow.dom._to_dom[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null,this$));
} else {
var m__5349__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_12562(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_12566 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (shadow.dom._to_svg[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null,this$));
} else {
var m__5349__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_12566(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__11724 = coll;
var G__11725 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__11724,G__11725) : shadow.dom.lazy_native_coll_seq.call(null,G__11724,G__11725));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__5002__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__11739 = arguments.length;
switch (G__11739) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__11747 = arguments.length;
switch (G__11747) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__11750 = arguments.length;
switch (G__11750) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__11757 = arguments.length;
switch (G__11757) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__11764 = arguments.length;
switch (G__11764) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__11777 = arguments.length;
switch (G__11777) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__5002__auto__ = (!((typeof document !== 'undefined')));
if(or__5002__auto__){
return or__5002__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e11785){if((e11785 instanceof Object)){
var e = e11785;
return console.log("didnt support attachEvent",el,e);
} else {
throw e11785;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__5002__auto__ = (!((typeof document !== 'undefined')));
if(or__5002__auto__){
return or__5002__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__11795 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__11796 = null;
var count__11797 = (0);
var i__11798 = (0);
while(true){
if((i__11798 < count__11797)){
var el = chunk__11796.cljs$core$IIndexed$_nth$arity$2(null,i__11798);
var handler_12589__$1 = ((function (seq__11795,chunk__11796,count__11797,i__11798,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__11795,chunk__11796,count__11797,i__11798,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_12589__$1);


var G__12592 = seq__11795;
var G__12593 = chunk__11796;
var G__12594 = count__11797;
var G__12595 = (i__11798 + (1));
seq__11795 = G__12592;
chunk__11796 = G__12593;
count__11797 = G__12594;
i__11798 = G__12595;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__11795);
if(temp__5804__auto__){
var seq__11795__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11795__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__11795__$1);
var G__12597 = cljs.core.chunk_rest(seq__11795__$1);
var G__12598 = c__5525__auto__;
var G__12599 = cljs.core.count(c__5525__auto__);
var G__12600 = (0);
seq__11795 = G__12597;
chunk__11796 = G__12598;
count__11797 = G__12599;
i__11798 = G__12600;
continue;
} else {
var el = cljs.core.first(seq__11795__$1);
var handler_12607__$1 = ((function (seq__11795,chunk__11796,count__11797,i__11798,el,seq__11795__$1,temp__5804__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__11795,chunk__11796,count__11797,i__11798,el,seq__11795__$1,temp__5804__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_12607__$1);


var G__12614 = cljs.core.next(seq__11795__$1);
var G__12615 = null;
var G__12616 = (0);
var G__12617 = (0);
seq__11795 = G__12614;
chunk__11796 = G__12615;
count__11797 = G__12616;
i__11798 = G__12617;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__11805 = arguments.length;
switch (G__11805) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__11812 = cljs.core.seq(events);
var chunk__11813 = null;
var count__11814 = (0);
var i__11815 = (0);
while(true){
if((i__11815 < count__11814)){
var vec__11837 = chunk__11813.cljs$core$IIndexed$_nth$arity$2(null,i__11815);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11837,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11837,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__12627 = seq__11812;
var G__12628 = chunk__11813;
var G__12629 = count__11814;
var G__12630 = (i__11815 + (1));
seq__11812 = G__12627;
chunk__11813 = G__12628;
count__11814 = G__12629;
i__11815 = G__12630;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__11812);
if(temp__5804__auto__){
var seq__11812__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11812__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__11812__$1);
var G__12634 = cljs.core.chunk_rest(seq__11812__$1);
var G__12635 = c__5525__auto__;
var G__12636 = cljs.core.count(c__5525__auto__);
var G__12637 = (0);
seq__11812 = G__12634;
chunk__11813 = G__12635;
count__11814 = G__12636;
i__11815 = G__12637;
continue;
} else {
var vec__11840 = cljs.core.first(seq__11812__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11840,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11840,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__12638 = cljs.core.next(seq__11812__$1);
var G__12639 = null;
var G__12640 = (0);
var G__12641 = (0);
seq__11812 = G__12638;
chunk__11813 = G__12639;
count__11814 = G__12640;
i__11815 = G__12641;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__11850 = cljs.core.seq(styles);
var chunk__11851 = null;
var count__11853 = (0);
var i__11854 = (0);
while(true){
if((i__11854 < count__11853)){
var vec__11876 = chunk__11851.cljs$core$IIndexed$_nth$arity$2(null,i__11854);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11876,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11876,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__12643 = seq__11850;
var G__12644 = chunk__11851;
var G__12645 = count__11853;
var G__12646 = (i__11854 + (1));
seq__11850 = G__12643;
chunk__11851 = G__12644;
count__11853 = G__12645;
i__11854 = G__12646;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__11850);
if(temp__5804__auto__){
var seq__11850__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11850__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__11850__$1);
var G__12650 = cljs.core.chunk_rest(seq__11850__$1);
var G__12651 = c__5525__auto__;
var G__12652 = cljs.core.count(c__5525__auto__);
var G__12653 = (0);
seq__11850 = G__12650;
chunk__11851 = G__12651;
count__11853 = G__12652;
i__11854 = G__12653;
continue;
} else {
var vec__11879 = cljs.core.first(seq__11850__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11879,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11879,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__12657 = cljs.core.next(seq__11850__$1);
var G__12658 = null;
var G__12659 = (0);
var G__12660 = (0);
seq__11850 = G__12657;
chunk__11851 = G__12658;
count__11853 = G__12659;
i__11854 = G__12660;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__11884_12661 = key;
var G__11884_12662__$1 = (((G__11884_12661 instanceof cljs.core.Keyword))?G__11884_12661.fqn:null);
switch (G__11884_12662__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_12669 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__5002__auto__ = goog.string.startsWith(ks_12669,"data-");
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return goog.string.startsWith(ks_12669,"aria-");
}
})())){
el.setAttribute(ks_12669,value);
} else {
(el[ks_12669] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__11906){
var map__11907 = p__11906;
var map__11907__$1 = cljs.core.__destructure_map(map__11907);
var props = map__11907__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11907__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__11908 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11908,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11908,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11908,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__11911 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__11911,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__11911;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__11917 = arguments.length;
switch (G__11917) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__11920){
var vec__11921 = p__11920;
var seq__11922 = cljs.core.seq(vec__11921);
var first__11923 = cljs.core.first(seq__11922);
var seq__11922__$1 = cljs.core.next(seq__11922);
var nn = first__11923;
var first__11923__$1 = cljs.core.first(seq__11922__$1);
var seq__11922__$2 = cljs.core.next(seq__11922__$1);
var np = first__11923__$1;
var nc = seq__11922__$2;
var node = vec__11921;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__11925 = nn;
var G__11926 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__11925,G__11926) : create_fn.call(null,G__11925,G__11926));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__11927 = nn;
var G__11928 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__11927,G__11928) : create_fn.call(null,G__11927,G__11928));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__11929 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11929,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11929,(1),null);
var seq__11932_12682 = cljs.core.seq(node_children);
var chunk__11933_12683 = null;
var count__11934_12684 = (0);
var i__11935_12685 = (0);
while(true){
if((i__11935_12685 < count__11934_12684)){
var child_struct_12686 = chunk__11933_12683.cljs$core$IIndexed$_nth$arity$2(null,i__11935_12685);
var children_12687 = shadow.dom.dom_node(child_struct_12686);
if(cljs.core.seq_QMARK_(children_12687)){
var seq__11950_12688 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_12687));
var chunk__11952_12689 = null;
var count__11953_12690 = (0);
var i__11954_12691 = (0);
while(true){
if((i__11954_12691 < count__11953_12690)){
var child_12692 = chunk__11952_12689.cljs$core$IIndexed$_nth$arity$2(null,i__11954_12691);
if(cljs.core.truth_(child_12692)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_12692);


var G__12693 = seq__11950_12688;
var G__12694 = chunk__11952_12689;
var G__12695 = count__11953_12690;
var G__12696 = (i__11954_12691 + (1));
seq__11950_12688 = G__12693;
chunk__11952_12689 = G__12694;
count__11953_12690 = G__12695;
i__11954_12691 = G__12696;
continue;
} else {
var G__12697 = seq__11950_12688;
var G__12698 = chunk__11952_12689;
var G__12699 = count__11953_12690;
var G__12700 = (i__11954_12691 + (1));
seq__11950_12688 = G__12697;
chunk__11952_12689 = G__12698;
count__11953_12690 = G__12699;
i__11954_12691 = G__12700;
continue;
}
} else {
var temp__5804__auto___12701 = cljs.core.seq(seq__11950_12688);
if(temp__5804__auto___12701){
var seq__11950_12702__$1 = temp__5804__auto___12701;
if(cljs.core.chunked_seq_QMARK_(seq__11950_12702__$1)){
var c__5525__auto___12703 = cljs.core.chunk_first(seq__11950_12702__$1);
var G__12704 = cljs.core.chunk_rest(seq__11950_12702__$1);
var G__12705 = c__5525__auto___12703;
var G__12706 = cljs.core.count(c__5525__auto___12703);
var G__12707 = (0);
seq__11950_12688 = G__12704;
chunk__11952_12689 = G__12705;
count__11953_12690 = G__12706;
i__11954_12691 = G__12707;
continue;
} else {
var child_12708 = cljs.core.first(seq__11950_12702__$1);
if(cljs.core.truth_(child_12708)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_12708);


var G__12709 = cljs.core.next(seq__11950_12702__$1);
var G__12710 = null;
var G__12711 = (0);
var G__12712 = (0);
seq__11950_12688 = G__12709;
chunk__11952_12689 = G__12710;
count__11953_12690 = G__12711;
i__11954_12691 = G__12712;
continue;
} else {
var G__12713 = cljs.core.next(seq__11950_12702__$1);
var G__12714 = null;
var G__12715 = (0);
var G__12716 = (0);
seq__11950_12688 = G__12713;
chunk__11952_12689 = G__12714;
count__11953_12690 = G__12715;
i__11954_12691 = G__12716;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_12687);
}


var G__12718 = seq__11932_12682;
var G__12719 = chunk__11933_12683;
var G__12720 = count__11934_12684;
var G__12721 = (i__11935_12685 + (1));
seq__11932_12682 = G__12718;
chunk__11933_12683 = G__12719;
count__11934_12684 = G__12720;
i__11935_12685 = G__12721;
continue;
} else {
var temp__5804__auto___12722 = cljs.core.seq(seq__11932_12682);
if(temp__5804__auto___12722){
var seq__11932_12723__$1 = temp__5804__auto___12722;
if(cljs.core.chunked_seq_QMARK_(seq__11932_12723__$1)){
var c__5525__auto___12724 = cljs.core.chunk_first(seq__11932_12723__$1);
var G__12725 = cljs.core.chunk_rest(seq__11932_12723__$1);
var G__12726 = c__5525__auto___12724;
var G__12727 = cljs.core.count(c__5525__auto___12724);
var G__12728 = (0);
seq__11932_12682 = G__12725;
chunk__11933_12683 = G__12726;
count__11934_12684 = G__12727;
i__11935_12685 = G__12728;
continue;
} else {
var child_struct_12729 = cljs.core.first(seq__11932_12723__$1);
var children_12730 = shadow.dom.dom_node(child_struct_12729);
if(cljs.core.seq_QMARK_(children_12730)){
var seq__11959_12732 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_12730));
var chunk__11961_12733 = null;
var count__11962_12734 = (0);
var i__11963_12735 = (0);
while(true){
if((i__11963_12735 < count__11962_12734)){
var child_12736 = chunk__11961_12733.cljs$core$IIndexed$_nth$arity$2(null,i__11963_12735);
if(cljs.core.truth_(child_12736)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_12736);


var G__12737 = seq__11959_12732;
var G__12738 = chunk__11961_12733;
var G__12739 = count__11962_12734;
var G__12740 = (i__11963_12735 + (1));
seq__11959_12732 = G__12737;
chunk__11961_12733 = G__12738;
count__11962_12734 = G__12739;
i__11963_12735 = G__12740;
continue;
} else {
var G__12741 = seq__11959_12732;
var G__12742 = chunk__11961_12733;
var G__12743 = count__11962_12734;
var G__12744 = (i__11963_12735 + (1));
seq__11959_12732 = G__12741;
chunk__11961_12733 = G__12742;
count__11962_12734 = G__12743;
i__11963_12735 = G__12744;
continue;
}
} else {
var temp__5804__auto___12745__$1 = cljs.core.seq(seq__11959_12732);
if(temp__5804__auto___12745__$1){
var seq__11959_12746__$1 = temp__5804__auto___12745__$1;
if(cljs.core.chunked_seq_QMARK_(seq__11959_12746__$1)){
var c__5525__auto___12747 = cljs.core.chunk_first(seq__11959_12746__$1);
var G__12748 = cljs.core.chunk_rest(seq__11959_12746__$1);
var G__12749 = c__5525__auto___12747;
var G__12750 = cljs.core.count(c__5525__auto___12747);
var G__12751 = (0);
seq__11959_12732 = G__12748;
chunk__11961_12733 = G__12749;
count__11962_12734 = G__12750;
i__11963_12735 = G__12751;
continue;
} else {
var child_12752 = cljs.core.first(seq__11959_12746__$1);
if(cljs.core.truth_(child_12752)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_12752);


var G__12753 = cljs.core.next(seq__11959_12746__$1);
var G__12754 = null;
var G__12755 = (0);
var G__12756 = (0);
seq__11959_12732 = G__12753;
chunk__11961_12733 = G__12754;
count__11962_12734 = G__12755;
i__11963_12735 = G__12756;
continue;
} else {
var G__12757 = cljs.core.next(seq__11959_12746__$1);
var G__12758 = null;
var G__12759 = (0);
var G__12760 = (0);
seq__11959_12732 = G__12757;
chunk__11961_12733 = G__12758;
count__11962_12734 = G__12759;
i__11963_12735 = G__12760;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_12730);
}


var G__12761 = cljs.core.next(seq__11932_12723__$1);
var G__12762 = null;
var G__12763 = (0);
var G__12764 = (0);
seq__11932_12682 = G__12761;
chunk__11933_12683 = G__12762;
count__11934_12684 = G__12763;
i__11935_12685 = G__12764;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__11970 = cljs.core.seq(node);
var chunk__11971 = null;
var count__11972 = (0);
var i__11973 = (0);
while(true){
if((i__11973 < count__11972)){
var n = chunk__11971.cljs$core$IIndexed$_nth$arity$2(null,i__11973);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__12779 = seq__11970;
var G__12780 = chunk__11971;
var G__12781 = count__11972;
var G__12782 = (i__11973 + (1));
seq__11970 = G__12779;
chunk__11971 = G__12780;
count__11972 = G__12781;
i__11973 = G__12782;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__11970);
if(temp__5804__auto__){
var seq__11970__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11970__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__11970__$1);
var G__12783 = cljs.core.chunk_rest(seq__11970__$1);
var G__12784 = c__5525__auto__;
var G__12785 = cljs.core.count(c__5525__auto__);
var G__12786 = (0);
seq__11970 = G__12783;
chunk__11971 = G__12784;
count__11972 = G__12785;
i__11973 = G__12786;
continue;
} else {
var n = cljs.core.first(seq__11970__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__12787 = cljs.core.next(seq__11970__$1);
var G__12788 = null;
var G__12789 = (0);
var G__12790 = (0);
seq__11970 = G__12787;
chunk__11971 = G__12788;
count__11972 = G__12789;
i__11973 = G__12790;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__11975 = arguments.length;
switch (G__11975) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__11978 = arguments.length;
switch (G__11978) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__11986 = arguments.length;
switch (G__11986) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__5002__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__5732__auto__ = [];
var len__5726__auto___12808 = arguments.length;
var i__5727__auto___12809 = (0);
while(true){
if((i__5727__auto___12809 < len__5726__auto___12808)){
args__5732__auto__.push((arguments[i__5727__auto___12809]));

var G__12813 = (i__5727__auto___12809 + (1));
i__5727__auto___12809 = G__12813;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((0) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__5733__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__11988_12814 = cljs.core.seq(nodes);
var chunk__11989_12815 = null;
var count__11990_12816 = (0);
var i__11991_12817 = (0);
while(true){
if((i__11991_12817 < count__11990_12816)){
var node_12818 = chunk__11989_12815.cljs$core$IIndexed$_nth$arity$2(null,i__11991_12817);
fragment.appendChild(shadow.dom._to_dom(node_12818));


var G__12819 = seq__11988_12814;
var G__12820 = chunk__11989_12815;
var G__12821 = count__11990_12816;
var G__12822 = (i__11991_12817 + (1));
seq__11988_12814 = G__12819;
chunk__11989_12815 = G__12820;
count__11990_12816 = G__12821;
i__11991_12817 = G__12822;
continue;
} else {
var temp__5804__auto___12823 = cljs.core.seq(seq__11988_12814);
if(temp__5804__auto___12823){
var seq__11988_12824__$1 = temp__5804__auto___12823;
if(cljs.core.chunked_seq_QMARK_(seq__11988_12824__$1)){
var c__5525__auto___12825 = cljs.core.chunk_first(seq__11988_12824__$1);
var G__12827 = cljs.core.chunk_rest(seq__11988_12824__$1);
var G__12828 = c__5525__auto___12825;
var G__12829 = cljs.core.count(c__5525__auto___12825);
var G__12830 = (0);
seq__11988_12814 = G__12827;
chunk__11989_12815 = G__12828;
count__11990_12816 = G__12829;
i__11991_12817 = G__12830;
continue;
} else {
var node_12832 = cljs.core.first(seq__11988_12824__$1);
fragment.appendChild(shadow.dom._to_dom(node_12832));


var G__12833 = cljs.core.next(seq__11988_12824__$1);
var G__12834 = null;
var G__12835 = (0);
var G__12836 = (0);
seq__11988_12814 = G__12833;
chunk__11989_12815 = G__12834;
count__11990_12816 = G__12835;
i__11991_12817 = G__12836;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq11987){
var self__5712__auto__ = this;
return self__5712__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq11987));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__11993_12841 = cljs.core.seq(scripts);
var chunk__11994_12842 = null;
var count__11995_12843 = (0);
var i__11996_12844 = (0);
while(true){
if((i__11996_12844 < count__11995_12843)){
var vec__12003_12845 = chunk__11994_12842.cljs$core$IIndexed$_nth$arity$2(null,i__11996_12844);
var script_tag_12846 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12003_12845,(0),null);
var script_body_12847 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12003_12845,(1),null);
eval(script_body_12847);


var G__12848 = seq__11993_12841;
var G__12849 = chunk__11994_12842;
var G__12850 = count__11995_12843;
var G__12851 = (i__11996_12844 + (1));
seq__11993_12841 = G__12848;
chunk__11994_12842 = G__12849;
count__11995_12843 = G__12850;
i__11996_12844 = G__12851;
continue;
} else {
var temp__5804__auto___12853 = cljs.core.seq(seq__11993_12841);
if(temp__5804__auto___12853){
var seq__11993_12854__$1 = temp__5804__auto___12853;
if(cljs.core.chunked_seq_QMARK_(seq__11993_12854__$1)){
var c__5525__auto___12856 = cljs.core.chunk_first(seq__11993_12854__$1);
var G__12859 = cljs.core.chunk_rest(seq__11993_12854__$1);
var G__12860 = c__5525__auto___12856;
var G__12861 = cljs.core.count(c__5525__auto___12856);
var G__12862 = (0);
seq__11993_12841 = G__12859;
chunk__11994_12842 = G__12860;
count__11995_12843 = G__12861;
i__11996_12844 = G__12862;
continue;
} else {
var vec__12006_12865 = cljs.core.first(seq__11993_12854__$1);
var script_tag_12866 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12006_12865,(0),null);
var script_body_12867 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12006_12865,(1),null);
eval(script_body_12867);


var G__12871 = cljs.core.next(seq__11993_12854__$1);
var G__12872 = null;
var G__12873 = (0);
var G__12874 = (0);
seq__11993_12841 = G__12871;
chunk__11994_12842 = G__12872;
count__11995_12843 = G__12873;
i__11996_12844 = G__12874;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__12009){
var vec__12010 = p__12009;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12010,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12010,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__12016 = arguments.length;
switch (G__12016) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__12029 = cljs.core.seq(style_keys);
var chunk__12030 = null;
var count__12031 = (0);
var i__12032 = (0);
while(true){
if((i__12032 < count__12031)){
var it = chunk__12030.cljs$core$IIndexed$_nth$arity$2(null,i__12032);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__12889 = seq__12029;
var G__12890 = chunk__12030;
var G__12891 = count__12031;
var G__12892 = (i__12032 + (1));
seq__12029 = G__12889;
chunk__12030 = G__12890;
count__12031 = G__12891;
i__12032 = G__12892;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__12029);
if(temp__5804__auto__){
var seq__12029__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12029__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__12029__$1);
var G__12893 = cljs.core.chunk_rest(seq__12029__$1);
var G__12894 = c__5525__auto__;
var G__12895 = cljs.core.count(c__5525__auto__);
var G__12896 = (0);
seq__12029 = G__12893;
chunk__12030 = G__12894;
count__12031 = G__12895;
i__12032 = G__12896;
continue;
} else {
var it = cljs.core.first(seq__12029__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__12897 = cljs.core.next(seq__12029__$1);
var G__12898 = null;
var G__12899 = (0);
var G__12900 = (0);
seq__12029 = G__12897;
chunk__12030 = G__12898;
count__12031 = G__12899;
i__12032 = G__12900;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5300__auto__,k__5301__auto__){
var self__ = this;
var this__5300__auto____$1 = this;
return this__5300__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5301__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5302__auto__,k12040,else__5303__auto__){
var self__ = this;
var this__5302__auto____$1 = this;
var G__12044 = k12040;
var G__12044__$1 = (((G__12044 instanceof cljs.core.Keyword))?G__12044.fqn:null);
switch (G__12044__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12040,else__5303__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5320__auto__,f__5321__auto__,init__5322__auto__){
var self__ = this;
var this__5320__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5323__auto__,p__12054){
var vec__12055 = p__12054;
var k__5324__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12055,(0),null);
var v__5325__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12055,(1),null);
return (f__5321__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5321__auto__.cljs$core$IFn$_invoke$arity$3(ret__5323__auto__,k__5324__auto__,v__5325__auto__) : f__5321__auto__.call(null,ret__5323__auto__,k__5324__auto__,v__5325__auto__));
}),init__5322__auto__,this__5320__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5315__auto__,writer__5316__auto__,opts__5317__auto__){
var self__ = this;
var this__5315__auto____$1 = this;
var pr_pair__5318__auto__ = (function (keyval__5319__auto__){
return cljs.core.pr_sequential_writer(writer__5316__auto__,cljs.core.pr_writer,""," ","",opts__5317__auto__,keyval__5319__auto__);
});
return cljs.core.pr_sequential_writer(writer__5316__auto__,pr_pair__5318__auto__,"#shadow.dom.Coordinate{",", ","}",opts__5317__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12039){
var self__ = this;
var G__12039__$1 = this;
return (new cljs.core.RecordIter((0),G__12039__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5298__auto__){
var self__ = this;
var this__5298__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5295__auto__){
var self__ = this;
var this__5295__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5304__auto__){
var self__ = this;
var this__5304__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5296__auto__){
var self__ = this;
var this__5296__auto____$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = (function (coll__5297__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__5297__auto__));
})(this__5296__auto____$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12041,other12042){
var self__ = this;
var this12041__$1 = this;
return (((!((other12042 == null)))) && ((((this12041__$1.constructor === other12042.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12041__$1.x,other12042.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12041__$1.y,other12042.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12041__$1.__extmap,other12042.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5310__auto__,k__5311__auto__){
var self__ = this;
var this__5310__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__5311__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5310__auto____$1),self__.__meta),k__5311__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5311__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5307__auto__,k12040){
var self__ = this;
var this__5307__auto____$1 = this;
var G__12081 = k12040;
var G__12081__$1 = (((G__12081 instanceof cljs.core.Keyword))?G__12081.fqn:null);
switch (G__12081__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k12040);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5308__auto__,k__5309__auto__,G__12039){
var self__ = this;
var this__5308__auto____$1 = this;
var pred__12082 = cljs.core.keyword_identical_QMARK_;
var expr__12083 = k__5309__auto__;
if(cljs.core.truth_((pred__12082.cljs$core$IFn$_invoke$arity$2 ? pred__12082.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__12083) : pred__12082.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__12083)))){
return (new shadow.dom.Coordinate(G__12039,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12082.cljs$core$IFn$_invoke$arity$2 ? pred__12082.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__12083) : pred__12082.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__12083)))){
return (new shadow.dom.Coordinate(self__.x,G__12039,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5309__auto__,G__12039),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5313__auto__){
var self__ = this;
var this__5313__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5299__auto__,G__12039){
var self__ = this;
var this__5299__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__12039,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5305__auto__,entry__5306__auto__){
var self__ = this;
var this__5305__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5306__auto__)){
return this__5305__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5306__auto__,(0)),cljs.core._nth(entry__5306__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5305__auto____$1,entry__5306__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__5346__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__5346__auto__,writer__5347__auto__){
return cljs.core._write(writer__5347__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__12043){
var extmap__5342__auto__ = (function (){var G__12103 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12043,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__12043)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12103);
} else {
return G__12103;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__12043),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__12043),null,cljs.core.not_empty(extmap__5342__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5300__auto__,k__5301__auto__){
var self__ = this;
var this__5300__auto____$1 = this;
return this__5300__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5301__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5302__auto__,k12130,else__5303__auto__){
var self__ = this;
var this__5302__auto____$1 = this;
var G__12142 = k12130;
var G__12142__$1 = (((G__12142 instanceof cljs.core.Keyword))?G__12142.fqn:null);
switch (G__12142__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12130,else__5303__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5320__auto__,f__5321__auto__,init__5322__auto__){
var self__ = this;
var this__5320__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5323__auto__,p__12144){
var vec__12145 = p__12144;
var k__5324__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12145,(0),null);
var v__5325__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12145,(1),null);
return (f__5321__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5321__auto__.cljs$core$IFn$_invoke$arity$3(ret__5323__auto__,k__5324__auto__,v__5325__auto__) : f__5321__auto__.call(null,ret__5323__auto__,k__5324__auto__,v__5325__auto__));
}),init__5322__auto__,this__5320__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5315__auto__,writer__5316__auto__,opts__5317__auto__){
var self__ = this;
var this__5315__auto____$1 = this;
var pr_pair__5318__auto__ = (function (keyval__5319__auto__){
return cljs.core.pr_sequential_writer(writer__5316__auto__,cljs.core.pr_writer,""," ","",opts__5317__auto__,keyval__5319__auto__);
});
return cljs.core.pr_sequential_writer(writer__5316__auto__,pr_pair__5318__auto__,"#shadow.dom.Size{",", ","}",opts__5317__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12129){
var self__ = this;
var G__12129__$1 = this;
return (new cljs.core.RecordIter((0),G__12129__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5298__auto__){
var self__ = this;
var this__5298__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5295__auto__){
var self__ = this;
var this__5295__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5304__auto__){
var self__ = this;
var this__5304__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5296__auto__){
var self__ = this;
var this__5296__auto____$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = (function (coll__5297__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__5297__auto__));
})(this__5296__auto____$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12131,other12132){
var self__ = this;
var this12131__$1 = this;
return (((!((other12132 == null)))) && ((((this12131__$1.constructor === other12132.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12131__$1.w,other12132.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12131__$1.h,other12132.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12131__$1.__extmap,other12132.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5310__auto__,k__5311__auto__){
var self__ = this;
var this__5310__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__5311__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5310__auto____$1),self__.__meta),k__5311__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5311__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5307__auto__,k12130){
var self__ = this;
var this__5307__auto____$1 = this;
var G__12166 = k12130;
var G__12166__$1 = (((G__12166 instanceof cljs.core.Keyword))?G__12166.fqn:null);
switch (G__12166__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k12130);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5308__auto__,k__5309__auto__,G__12129){
var self__ = this;
var this__5308__auto____$1 = this;
var pred__12168 = cljs.core.keyword_identical_QMARK_;
var expr__12169 = k__5309__auto__;
if(cljs.core.truth_((pred__12168.cljs$core$IFn$_invoke$arity$2 ? pred__12168.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__12169) : pred__12168.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__12169)))){
return (new shadow.dom.Size(G__12129,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12168.cljs$core$IFn$_invoke$arity$2 ? pred__12168.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__12169) : pred__12168.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__12169)))){
return (new shadow.dom.Size(self__.w,G__12129,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5309__auto__,G__12129),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5313__auto__){
var self__ = this;
var this__5313__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5299__auto__,G__12129){
var self__ = this;
var this__5299__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__12129,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5305__auto__,entry__5306__auto__){
var self__ = this;
var this__5305__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5306__auto__)){
return this__5305__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5306__auto__,(0)),cljs.core._nth(entry__5306__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5305__auto____$1,entry__5306__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__5346__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__5346__auto__,writer__5347__auto__){
return cljs.core._write(writer__5347__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__12133){
var extmap__5342__auto__ = (function (){var G__12189 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12133,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__12133)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12189);
} else {
return G__12189;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__12133),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__12133),null,cljs.core.not_empty(extmap__5342__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__5590__auto__ = opts;
var l__5591__auto__ = a__5590__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__5591__auto__)){
var G__12980 = (i + (1));
var G__12981 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__12980;
ret = G__12981;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__12220){
var vec__12221 = p__12220;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12221,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12221,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__12227 = arguments.length;
switch (G__12227) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5802__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5802__auto__)){
var child = temp__5802__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__12988 = ps;
var G__12989 = (i + (1));
el__$1 = G__12988;
i = G__12989;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__12318 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12318,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12318,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12318,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__12330_12997 = cljs.core.seq(props);
var chunk__12331_12998 = null;
var count__12332_12999 = (0);
var i__12333_13000 = (0);
while(true){
if((i__12333_13000 < count__12332_12999)){
var vec__12373_13002 = chunk__12331_12998.cljs$core$IIndexed$_nth$arity$2(null,i__12333_13000);
var k_13003 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12373_13002,(0),null);
var v_13004 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12373_13002,(1),null);
el.setAttributeNS((function (){var temp__5804__auto__ = cljs.core.namespace(k_13003);
if(cljs.core.truth_(temp__5804__auto__)){
var ns = temp__5804__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_13003),v_13004);


var G__13005 = seq__12330_12997;
var G__13006 = chunk__12331_12998;
var G__13007 = count__12332_12999;
var G__13008 = (i__12333_13000 + (1));
seq__12330_12997 = G__13005;
chunk__12331_12998 = G__13006;
count__12332_12999 = G__13007;
i__12333_13000 = G__13008;
continue;
} else {
var temp__5804__auto___13009 = cljs.core.seq(seq__12330_12997);
if(temp__5804__auto___13009){
var seq__12330_13010__$1 = temp__5804__auto___13009;
if(cljs.core.chunked_seq_QMARK_(seq__12330_13010__$1)){
var c__5525__auto___13011 = cljs.core.chunk_first(seq__12330_13010__$1);
var G__13013 = cljs.core.chunk_rest(seq__12330_13010__$1);
var G__13014 = c__5525__auto___13011;
var G__13015 = cljs.core.count(c__5525__auto___13011);
var G__13016 = (0);
seq__12330_12997 = G__13013;
chunk__12331_12998 = G__13014;
count__12332_12999 = G__13015;
i__12333_13000 = G__13016;
continue;
} else {
var vec__12393_13017 = cljs.core.first(seq__12330_13010__$1);
var k_13018 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12393_13017,(0),null);
var v_13019 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12393_13017,(1),null);
el.setAttributeNS((function (){var temp__5804__auto____$1 = cljs.core.namespace(k_13018);
if(cljs.core.truth_(temp__5804__auto____$1)){
var ns = temp__5804__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_13018),v_13019);


var G__13028 = cljs.core.next(seq__12330_13010__$1);
var G__13029 = null;
var G__13030 = (0);
var G__13031 = (0);
seq__12330_12997 = G__13028;
chunk__12331_12998 = G__13029;
count__12332_12999 = G__13030;
i__12333_13000 = G__13031;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__12423 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12423,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12423,(1),null);
var seq__12426_13033 = cljs.core.seq(node_children);
var chunk__12428_13034 = null;
var count__12429_13035 = (0);
var i__12430_13036 = (0);
while(true){
if((i__12430_13036 < count__12429_13035)){
var child_struct_13037 = chunk__12428_13034.cljs$core$IIndexed$_nth$arity$2(null,i__12430_13036);
if((!((child_struct_13037 == null)))){
if(typeof child_struct_13037 === 'string'){
var text_13038 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_13038),child_struct_13037].join(''));
} else {
var children_13040 = shadow.dom.svg_node(child_struct_13037);
if(cljs.core.seq_QMARK_(children_13040)){
var seq__12509_13041 = cljs.core.seq(children_13040);
var chunk__12511_13042 = null;
var count__12512_13043 = (0);
var i__12513_13044 = (0);
while(true){
if((i__12513_13044 < count__12512_13043)){
var child_13046 = chunk__12511_13042.cljs$core$IIndexed$_nth$arity$2(null,i__12513_13044);
if(cljs.core.truth_(child_13046)){
node.appendChild(child_13046);


var G__13047 = seq__12509_13041;
var G__13048 = chunk__12511_13042;
var G__13049 = count__12512_13043;
var G__13050 = (i__12513_13044 + (1));
seq__12509_13041 = G__13047;
chunk__12511_13042 = G__13048;
count__12512_13043 = G__13049;
i__12513_13044 = G__13050;
continue;
} else {
var G__13052 = seq__12509_13041;
var G__13053 = chunk__12511_13042;
var G__13054 = count__12512_13043;
var G__13055 = (i__12513_13044 + (1));
seq__12509_13041 = G__13052;
chunk__12511_13042 = G__13053;
count__12512_13043 = G__13054;
i__12513_13044 = G__13055;
continue;
}
} else {
var temp__5804__auto___13056 = cljs.core.seq(seq__12509_13041);
if(temp__5804__auto___13056){
var seq__12509_13058__$1 = temp__5804__auto___13056;
if(cljs.core.chunked_seq_QMARK_(seq__12509_13058__$1)){
var c__5525__auto___13059 = cljs.core.chunk_first(seq__12509_13058__$1);
var G__13060 = cljs.core.chunk_rest(seq__12509_13058__$1);
var G__13061 = c__5525__auto___13059;
var G__13062 = cljs.core.count(c__5525__auto___13059);
var G__13063 = (0);
seq__12509_13041 = G__13060;
chunk__12511_13042 = G__13061;
count__12512_13043 = G__13062;
i__12513_13044 = G__13063;
continue;
} else {
var child_13065 = cljs.core.first(seq__12509_13058__$1);
if(cljs.core.truth_(child_13065)){
node.appendChild(child_13065);


var G__13066 = cljs.core.next(seq__12509_13058__$1);
var G__13067 = null;
var G__13068 = (0);
var G__13069 = (0);
seq__12509_13041 = G__13066;
chunk__12511_13042 = G__13067;
count__12512_13043 = G__13068;
i__12513_13044 = G__13069;
continue;
} else {
var G__13070 = cljs.core.next(seq__12509_13058__$1);
var G__13071 = null;
var G__13072 = (0);
var G__13073 = (0);
seq__12509_13041 = G__13070;
chunk__12511_13042 = G__13071;
count__12512_13043 = G__13072;
i__12513_13044 = G__13073;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_13040);
}
}


var G__13074 = seq__12426_13033;
var G__13075 = chunk__12428_13034;
var G__13076 = count__12429_13035;
var G__13077 = (i__12430_13036 + (1));
seq__12426_13033 = G__13074;
chunk__12428_13034 = G__13075;
count__12429_13035 = G__13076;
i__12430_13036 = G__13077;
continue;
} else {
var G__13078 = seq__12426_13033;
var G__13079 = chunk__12428_13034;
var G__13080 = count__12429_13035;
var G__13081 = (i__12430_13036 + (1));
seq__12426_13033 = G__13078;
chunk__12428_13034 = G__13079;
count__12429_13035 = G__13080;
i__12430_13036 = G__13081;
continue;
}
} else {
var temp__5804__auto___13083 = cljs.core.seq(seq__12426_13033);
if(temp__5804__auto___13083){
var seq__12426_13084__$1 = temp__5804__auto___13083;
if(cljs.core.chunked_seq_QMARK_(seq__12426_13084__$1)){
var c__5525__auto___13086 = cljs.core.chunk_first(seq__12426_13084__$1);
var G__13087 = cljs.core.chunk_rest(seq__12426_13084__$1);
var G__13088 = c__5525__auto___13086;
var G__13089 = cljs.core.count(c__5525__auto___13086);
var G__13090 = (0);
seq__12426_13033 = G__13087;
chunk__12428_13034 = G__13088;
count__12429_13035 = G__13089;
i__12430_13036 = G__13090;
continue;
} else {
var child_struct_13091 = cljs.core.first(seq__12426_13084__$1);
if((!((child_struct_13091 == null)))){
if(typeof child_struct_13091 === 'string'){
var text_13092 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_13092),child_struct_13091].join(''));
} else {
var children_13093 = shadow.dom.svg_node(child_struct_13091);
if(cljs.core.seq_QMARK_(children_13093)){
var seq__12529_13094 = cljs.core.seq(children_13093);
var chunk__12531_13095 = null;
var count__12532_13096 = (0);
var i__12533_13097 = (0);
while(true){
if((i__12533_13097 < count__12532_13096)){
var child_13098 = chunk__12531_13095.cljs$core$IIndexed$_nth$arity$2(null,i__12533_13097);
if(cljs.core.truth_(child_13098)){
node.appendChild(child_13098);


var G__13099 = seq__12529_13094;
var G__13100 = chunk__12531_13095;
var G__13101 = count__12532_13096;
var G__13102 = (i__12533_13097 + (1));
seq__12529_13094 = G__13099;
chunk__12531_13095 = G__13100;
count__12532_13096 = G__13101;
i__12533_13097 = G__13102;
continue;
} else {
var G__13103 = seq__12529_13094;
var G__13104 = chunk__12531_13095;
var G__13105 = count__12532_13096;
var G__13106 = (i__12533_13097 + (1));
seq__12529_13094 = G__13103;
chunk__12531_13095 = G__13104;
count__12532_13096 = G__13105;
i__12533_13097 = G__13106;
continue;
}
} else {
var temp__5804__auto___13109__$1 = cljs.core.seq(seq__12529_13094);
if(temp__5804__auto___13109__$1){
var seq__12529_13110__$1 = temp__5804__auto___13109__$1;
if(cljs.core.chunked_seq_QMARK_(seq__12529_13110__$1)){
var c__5525__auto___13111 = cljs.core.chunk_first(seq__12529_13110__$1);
var G__13112 = cljs.core.chunk_rest(seq__12529_13110__$1);
var G__13113 = c__5525__auto___13111;
var G__13114 = cljs.core.count(c__5525__auto___13111);
var G__13115 = (0);
seq__12529_13094 = G__13112;
chunk__12531_13095 = G__13113;
count__12532_13096 = G__13114;
i__12533_13097 = G__13115;
continue;
} else {
var child_13116 = cljs.core.first(seq__12529_13110__$1);
if(cljs.core.truth_(child_13116)){
node.appendChild(child_13116);


var G__13117 = cljs.core.next(seq__12529_13110__$1);
var G__13118 = null;
var G__13119 = (0);
var G__13120 = (0);
seq__12529_13094 = G__13117;
chunk__12531_13095 = G__13118;
count__12532_13096 = G__13119;
i__12533_13097 = G__13120;
continue;
} else {
var G__13121 = cljs.core.next(seq__12529_13110__$1);
var G__13122 = null;
var G__13123 = (0);
var G__13124 = (0);
seq__12529_13094 = G__13121;
chunk__12531_13095 = G__13122;
count__12532_13096 = G__13123;
i__12533_13097 = G__13124;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_13093);
}
}


var G__13125 = cljs.core.next(seq__12426_13084__$1);
var G__13126 = null;
var G__13127 = (0);
var G__13128 = (0);
seq__12426_13033 = G__13125;
chunk__12428_13034 = G__13126;
count__12429_13035 = G__13127;
i__12430_13036 = G__13128;
continue;
} else {
var G__13129 = cljs.core.next(seq__12426_13084__$1);
var G__13130 = null;
var G__13131 = (0);
var G__13132 = (0);
seq__12426_13033 = G__13129;
chunk__12428_13034 = G__13130;
count__12429_13035 = G__13131;
i__12430_13036 = G__13132;
continue;
}
}
} else {
}
}
break;
}

return node;
});
(shadow.dom.SVGElement["string"] = true);

(shadow.dom._to_svg["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

(shadow.dom.SVGElement["null"] = true);

(shadow.dom._to_svg["null"] = (function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__5732__auto__ = [];
var len__5726__auto___13143 = arguments.length;
var i__5727__auto___13144 = (0);
while(true){
if((i__5727__auto___13144 < len__5726__auto___13143)){
args__5732__auto__.push((arguments[i__5727__auto___13144]));

var G__13145 = (i__5727__auto___13144 + (1));
i__5727__auto___13144 = G__13145;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq12549){
var G__12551 = cljs.core.first(seq12549);
var seq12549__$1 = cljs.core.next(seq12549);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12551,seq12549__$1);
}));


//# sourceMappingURL=shadow.dom.js.map
