goog.provide('reagent.dom');
var module$node_modules$react_dom$index=shadow.js.require("module$node_modules$react_dom$index", {});
if((typeof reagent !== 'undefined') && (typeof reagent.dom !== 'undefined') && (typeof reagent.dom.roots !== 'undefined')){
} else {
reagent.dom.roots = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
}
reagent.dom.unmount_comp = (function reagent$dom$unmount_comp(container){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(reagent.dom.roots,cljs.core.dissoc,container);

return module$node_modules$react_dom$index.unmountComponentAtNode(container);
});
reagent.dom.render_comp = (function reagent$dom$render_comp(comp,container,callback){
var _STAR_always_update_STAR__orig_val__22039 = reagent.impl.util._STAR_always_update_STAR_;
var _STAR_always_update_STAR__temp_val__22040 = true;
(reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR__temp_val__22040);

try{return module$node_modules$react_dom$index.render((comp.cljs$core$IFn$_invoke$arity$0 ? comp.cljs$core$IFn$_invoke$arity$0() : comp.call(null)),container,(function (){
var _STAR_always_update_STAR__orig_val__22041 = reagent.impl.util._STAR_always_update_STAR_;
var _STAR_always_update_STAR__temp_val__22042 = false;
(reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR__temp_val__22042);

try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(reagent.dom.roots,cljs.core.assoc,container,comp);

reagent.impl.batching.flush_after_render();

if((!((callback == null)))){
return (callback.cljs$core$IFn$_invoke$arity$0 ? callback.cljs$core$IFn$_invoke$arity$0() : callback.call(null));
} else {
return null;
}
}finally {(reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR__orig_val__22041);
}}));
}finally {(reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR__orig_val__22039);
}});
reagent.dom.re_render_component = (function reagent$dom$re_render_component(comp,container){
return reagent.dom.render_comp(comp,container,null);
});
/**
 * Render a Reagent component into the DOM. The first argument may be
 *   either a vector (using Reagent's Hiccup syntax), or a React element.
 *   The second argument should be a DOM node.
 * 
 *   Optionally takes a callback that is called when the component is in place.
 * 
 *   Returns the mounted component instance.
 */
reagent.dom.render = (function reagent$dom$render(var_args){
var G__22050 = arguments.length;
switch (G__22050) {
case 2:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(reagent.dom.render.cljs$core$IFn$_invoke$arity$2 = (function (comp,container){
return reagent.dom.render.cljs$core$IFn$_invoke$arity$3(comp,container,reagent.impl.template._STAR_current_default_compiler_STAR_);
}));

(reagent.dom.render.cljs$core$IFn$_invoke$arity$3 = (function (comp,container,callback_or_compiler){
reagent.ratom.flush_BANG_();

var vec__22056 = ((cljs.core.map_QMARK_(callback_or_compiler))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compiler","compiler",-267926731).cljs$core$IFn$_invoke$arity$1(callback_or_compiler),new cljs.core.Keyword(null,"callback","callback",-705136228).cljs$core$IFn$_invoke$arity$1(callback_or_compiler)], null):((cljs.core.fn_QMARK_(callback_or_compiler))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [reagent.impl.template._STAR_current_default_compiler_STAR_,callback_or_compiler], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [callback_or_compiler,null], null)
));
var compiler = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22056,(0),null);
var callback = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22056,(1),null);
var f = (function (){
return reagent.impl.protocols.as_element(compiler,((cljs.core.fn_QMARK_(comp))?(comp.cljs$core$IFn$_invoke$arity$0 ? comp.cljs$core$IFn$_invoke$arity$0() : comp.call(null)):comp));
});
return reagent.dom.render_comp(f,container,callback);
}));

(reagent.dom.render.cljs$lang$maxFixedArity = 3);

/**
 * Remove a component from the given DOM node.
 */
reagent.dom.unmount_component_at_node = (function reagent$dom$unmount_component_at_node(container){
return reagent.dom.unmount_comp(container);
});
/**
 * Returns the root DOM node of a mounted component.
 */
reagent.dom.dom_node = (function reagent$dom$dom_node(this$){
return module$node_modules$react_dom$index.findDOMNode(this$);
});
/**
 * Force re-rendering of all mounted Reagent components. This is
 *   probably only useful in a development environment, when you want to
 *   update components in response to some dynamic changes to code.
 * 
 *   Note that force-update-all may not update root components. This
 *   happens if a component 'foo' is mounted with `(render [foo])` (since
 *   functions are passed by value, and not by reference, in
 *   ClojureScript). To get around this you'll have to introduce a layer
 *   of indirection, for example by using `(render [#'foo])` instead.
 */
reagent.dom.force_update_all = (function reagent$dom$force_update_all(){
reagent.ratom.flush_BANG_();

var seq__22059_22104 = cljs.core.seq(cljs.core.deref(reagent.dom.roots));
var chunk__22060_22105 = null;
var count__22061_22106 = (0);
var i__22062_22107 = (0);
while(true){
if((i__22062_22107 < count__22061_22106)){
var vec__22087_22108 = chunk__22060_22105.cljs$core$IIndexed$_nth$arity$2(null,i__22062_22107);
var container_22109 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22087_22108,(0),null);
var comp_22110 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22087_22108,(1),null);
reagent.dom.re_render_component(comp_22110,container_22109);


var G__22111 = seq__22059_22104;
var G__22112 = chunk__22060_22105;
var G__22113 = count__22061_22106;
var G__22114 = (i__22062_22107 + (1));
seq__22059_22104 = G__22111;
chunk__22060_22105 = G__22112;
count__22061_22106 = G__22113;
i__22062_22107 = G__22114;
continue;
} else {
var temp__5804__auto___22115 = cljs.core.seq(seq__22059_22104);
if(temp__5804__auto___22115){
var seq__22059_22116__$1 = temp__5804__auto___22115;
if(cljs.core.chunked_seq_QMARK_(seq__22059_22116__$1)){
var c__5525__auto___22117 = cljs.core.chunk_first(seq__22059_22116__$1);
var G__22118 = cljs.core.chunk_rest(seq__22059_22116__$1);
var G__22119 = c__5525__auto___22117;
var G__22120 = cljs.core.count(c__5525__auto___22117);
var G__22121 = (0);
seq__22059_22104 = G__22118;
chunk__22060_22105 = G__22119;
count__22061_22106 = G__22120;
i__22062_22107 = G__22121;
continue;
} else {
var vec__22094_22122 = cljs.core.first(seq__22059_22116__$1);
var container_22123 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22094_22122,(0),null);
var comp_22124 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22094_22122,(1),null);
reagent.dom.re_render_component(comp_22124,container_22123);


var G__22126 = cljs.core.next(seq__22059_22116__$1);
var G__22127 = null;
var G__22128 = (0);
var G__22129 = (0);
seq__22059_22104 = G__22126;
chunk__22060_22105 = G__22127;
count__22061_22106 = G__22128;
i__22062_22107 = G__22129;
continue;
}
} else {
}
}
break;
}

return reagent.impl.batching.flush_after_render();
});

//# sourceMappingURL=reagent.dom.js.map
