shadow$provide.module$node_modules$cytoscape_navigator$cytoscape_navigator = function(global, require, module, exports) {
  (function() {
    var defaults = {container:!1, viewLiveFramerate:0, dblClickDelay:200, removeCustomContainer:!0, rerenderDelay:500}, debounce = function() {
      function isObject(value) {
        var type = typeof value;
        return !!value && ("object" == type || "function" == type);
      }
      var nativeMax = Math.max, now = Date.now || function() {
        return (new Date()).getTime();
      };
      return function(func, wait, options) {
        function complete(isCalled, id) {
          id && clearTimeout(id);
          maxTimeoutId = timeoutId = trailingCall = void 0;
          isCalled && (lastCalled = now(), result = func.apply(thisArg, args), timeoutId || maxTimeoutId || (args = thisArg = void 0));
        }
        function delayed() {
          var remaining = wait - (now() - stamp);
          0 >= remaining || remaining > wait ? complete(trailingCall, maxTimeoutId) : timeoutId = setTimeout(delayed, remaining);
        }
        function maxDelayed() {
          complete(trailing, timeoutId);
        }
        function debounced() {
          args = arguments;
          stamp = now();
          thisArg = this;
          trailingCall = trailing && (timeoutId || !leading);
          if (!1 === maxWait) {
            var leadingCall = leading && !timeoutId;
          } else {
            maxTimeoutId || leading || (lastCalled = stamp);
            var remaining = maxWait - (stamp - lastCalled), isCalled = 0 >= remaining || remaining > maxWait;
            isCalled ? (maxTimeoutId && (maxTimeoutId = clearTimeout(maxTimeoutId)), lastCalled = stamp, result = func.apply(thisArg, args)) : maxTimeoutId || (maxTimeoutId = setTimeout(maxDelayed, remaining));
          }
          isCalled && timeoutId ? timeoutId = clearTimeout(timeoutId) : timeoutId || wait === maxWait || (timeoutId = setTimeout(delayed, wait));
          leadingCall && (isCalled = !0, result = func.apply(thisArg, args));
          !isCalled || timeoutId || maxTimeoutId || (args = thisArg = void 0);
          return result;
        }
        var args, maxTimeoutId, result, stamp, thisArg, timeoutId, trailingCall, lastCalled = 0, maxWait = !1, trailing = !0;
        if ("function" != typeof func) {
          throw new TypeError("Expected a function");
        }
        wait = 0 > wait ? 0 : +wait || 0;
        if (!0 === options) {
          var leading = !0;
          trailing = !1;
        } else {
          isObject(options) && (leading = !!options.leading, maxWait = "maxWait" in options && nativeMax(+options.maxWait || 0, wait), trailing = "trailing" in options ? !!options.trailing : trailing);
        }
        debounced.cancel = function() {
          timeoutId && clearTimeout(timeoutId);
          maxTimeoutId && clearTimeout(maxTimeoutId);
          lastCalled = 0;
          maxTimeoutId = timeoutId = trailingCall = void 0;
        };
        return debounced;
      };
    }(), throttle = function(func, wait, options) {
      var leading = !0, trailing = !0;
      !1 === options ? leading = !1 : "object" === typeof options && (leading = "leading" in options ? options.leading : leading, trailing = "trailing" in options ? options.trailing : trailing);
      options = options || {};
      options.leading = leading;
      options.maxWait = wait;
      options.trailing = trailing;
      return debounce(func, wait, options);
    }, Navigator = function(element, options) {
      this._init(element, options);
    }, extend = function() {
      for (var i = 1; i < arguments.length; i++) {
        for (var key in arguments[i]) {
          arguments[i].hasOwnProperty(key) && (arguments[0][key] = arguments[i][key]);
        }
      }
      return arguments[0];
    };
    Navigator.prototype = {constructor:Navigator, bb:function() {
      var bb = this.cy.elements().boundingBox();
      return 0 === bb.w || 0 === bb.h ? {x1:0, x2:Infinity, y1:0, y2:Infinity, w:Infinity, h:Infinity} : bb;
    }, _addCyListener:function(events, handler) {
      this._cyListeners.push({events, handler});
      this.cy.on(events, handler);
    }, _removeCyListeners:function() {
      var cy = this.cy;
      this._cyListeners.forEach(function(l) {
        cy.off(l.events, l.handler);
      });
      cy.offRender(this._onRenderHandler);
    }, _init:function(cy, options) {
      this._cyListeners = [];
      this.$element = cy.container();
      this.options = extend({}, defaults, options);
      this.cy = cy;
      this.boundingBox = this.bb();
      this.width = this.$element.getBoundingClientRect().width;
      this.height = this.$element.getBoundingClientRect().height;
      this._initPanel();
      this._initThumbnail();
      this._initView();
      this._initOverlay();
    }, destroy:function() {
      this._removeEventsHandling();
      this.options.container && !this.options.removeCustomContainer ? this.$panel.innerHTML = "" : this.$panel.parentElement.removeChild(this.$panel);
    }, _initPanel:function() {
      var options = this.options;
      options.container && "string" === typeof options.container && 0 < options.container.length ? -1 !== options.container.indexOf("#") ? this.$panel = document.getElementById(options.container.replace("#", "")) : this.$panel = document.getElementsByClassName(options.container.replace(".", ""))[0] : (this.$panel = document.createElement("div"), this.$panel.className = "cytoscape-navigator", document.body.appendChild(this.$panel));
      this._setupPanel();
      this._addCyListener("resize", this.resize.bind(this));
    }, _setupPanel:function() {
      this.panelWidth = this.$panel.getBoundingClientRect().width;
      this.panelHeight = this.$panel.getBoundingClientRect().height;
    }, _initThumbnail:function() {
      this.$thumbnail = document.createElement("img");
      this.$thumbnail.setAttribute("alt", "Graph navigator");
      this.$panel.appendChild(this.$thumbnail);
      this._setupThumbnailSizes();
      this._setupThumbnail();
    }, _setupThumbnail:function() {
      this._updateThumbnailImage();
    }, _setupThumbnailSizes:function() {
      this.boundingBox = this.bb();
      this.thumbnailZoom = Math.min(this.panelHeight / this.boundingBox.h, this.panelWidth / this.boundingBox.w);
      this.thumbnailPan = {x:(this.panelWidth - this.thumbnailZoom * (this.boundingBox.x1 + this.boundingBox.x2)) / 2, y:(this.panelHeight - this.thumbnailZoom * (this.boundingBox.y1 + this.boundingBox.y2)) / 2};
    }, _checkThumbnailSizesAndUpdate:function() {
      var _zoom = this.thumbnailZoom, _pan_x = this.thumbnailPan.x, _pan_y = this.thumbnailPan.y;
      this._setupThumbnailSizes();
      _zoom != this.thumbnailZoom || _pan_x != this.thumbnailPan.x || _pan_y != this.thumbnailPan.y ? (this._setupThumbnail(), this._setupView()) : this._updateThumbnailImage();
    }, _initView:function() {
      this.$view = document.createElement("div");
      this.$view.className = "cytoscape-navigatorView";
      this.$panel.appendChild(this.$view);
      this.viewBorderTop = parseInt(this.$view.style["border-top-width"], 10) || 0;
      this.viewBorderRight = parseInt(this.$view.style["border-right-width"], 10) || 0;
      this.viewBorderBottom = parseInt(this.$view.style["border-bottom-width"], 10) || 0;
      this.viewBorderLeft = parseInt(this.$view.style["border-left-width"], 10) || 0;
      this.viewBorderHorizontal = this.viewBorderLeft + this.viewBorderRight;
      this.viewBorderVertical = this.viewBorderTop + this.viewBorderBottom;
      this._setupView();
      this._addCyListener("zoom pan", this._setupView.bind(this));
    }, _setupView:function() {
      if (!this.viewLocked) {
        var cyZoom = this.cy.zoom(), cyPan = this.cy.pan();
        this.viewW = this.width / cyZoom * this.thumbnailZoom;
        this.viewX = -cyPan.x * this.viewW / this.width + this.thumbnailPan.x - this.viewBorderLeft;
        this.viewH = this.height / cyZoom * this.thumbnailZoom;
        this.viewY = -cyPan.y * this.viewH / this.height + this.thumbnailPan.y - this.viewBorderTop;
        this.$view.style.width = this.viewW + "px";
        this.$view.style.height = this.viewH + "px";
        this.$view.style.position = "absolute";
        this.$view.style.left = this.viewX + "px";
        this.$view.style.top = this.viewY + "px";
      }
    }, _initOverlay:function() {
      this.$overlay = document.createElement("div");
      this.$overlay.className = "cytoscape-navigatorOverlay";
      this.$panel.appendChild(this.$overlay);
      this.overlayHookPointY = this.overlayHookPointX = 0;
      this._initEventsHandling();
    }, resize:function() {
      this.width = this.$element.getBoundingClientRect().width;
      this.height = this.$element.getBoundingClientRect().height;
      this._thumbnailSetup = !1;
      this._setupPanel();
      this._checkThumbnailSizesAndUpdate();
      this._setupView();
    }, _initEventsHandling:function() {
      for (var that = this, eventsLocal = ["mousedown", "mousewheel", "DOMMouseScroll", "touchstart"], eventsGlobal = ["mouseup", "mouseout", "mousemove", "touchmove", "touchend"], overlayListener = function(ev) {
        "touchstart" == ev.type && (Object.defineProperty(ev, "offsetX", {value:that.viewX + that.viewW / 2, writable:!0}), Object.defineProperty(ev, "offsetY", {value:that.viewY + that.viewH / 2, writable:!0}));
        if (void 0 === ev.offsetX || void 0 === ev.offsetY) {
          var rect = ev.target.getBoundingClientRect(), JSCompiler_object_inline_top_0 = rect.top + window.scrollY;
          Object.defineProperty(ev, "offsetX", {value:ev.pageX - (rect.left + window.scrollX), writable:!0});
          Object.defineProperty(ev, "offsetY", {value:ev.pageY - JSCompiler_object_inline_top_0, writable:!0});
        }
        "mousedown" == ev.type || "touchstart" == ev.type ? that._eventMoveStart(ev) : ("mousewheel" == ev.type || "DOMMouseScroll" == ev.type) && that._eventZoom(ev);
        return !1;
      }, globalListener = function(ev) {
        if (that.overlayInMovement) {
          "touchend" == ev.type ? (Object.defineProperty(ev, "offsetX", {value:that.viewX + that.viewW / 2, writable:!0}), Object.defineProperty(ev, "offsetY", {value:that.viewY + that.viewH / 2, writable:!0})) : "touchmove" == ev.type && (Object.defineProperty(ev, "pageX", {value:ev.originalEvent.touches[0].pageX, writable:!0}), Object.defineProperty(ev, "pageY", {value:ev.originalEvent.touches[0].pageY, writable:!0}));
          if (void 0 === ev.offsetX || void 0 === ev.offsetY) {
            var rect = ev.target.getBoundingClientRect();
            rect = {top:rect.top + window.scrollY, left:rect.left + window.scrollX};
            Object.defineProperty(ev, "offsetX", {value:ev.pageX - rect.left, writable:!0});
            Object.defineProperty(ev, "offsetY", {value:ev.pageY - rect.top, writable:!0});
          }
          if (ev.target !== that.$overlay) {
            rect = ev.target.getBoundingClientRect();
            var rect2 = that.$overlay.getBoundingClientRect();
            rect = {top:rect.top + window.scrollY, left:rect.left + window.scrollX};
            rect2 = {top:rect2.top + window.scrollY, left:rect2.left + window.scrollX};
            if (rect && rect2) {
              Object.defineProperty(ev, "offsetX", {value:ev.offsetX - rect2.left + rect.left, writable:!0}), Object.defineProperty(ev, "offsetY", {value:ev.offsetY - rect2.top + rect.top, writable:!0});
            } else {
              return !1;
            }
          }
          "mousemove" == ev.type || "touchmove" == ev.type ? that._eventMove(ev) : ("mouseup" == ev.type || "touchend" == ev.type) && that._eventMoveEnd(ev);
          return !1;
        }
      }, i = 0; i < eventsLocal.length; i++) {
        this.$overlay.addEventListener(eventsLocal[i], overlayListener, !1);
      }
      for (i = 0; i < eventsGlobal.length; i++) {
        window.addEventListener(eventsGlobal[i], globalListener, !1);
      }
      this._removeEventsHandling = function() {
        for (var i = 0; i < eventsLocal.length; i++) {
          this.$overlay.removeEventListener(eventsLocal[i], overlayListener);
        }
        for (i = 0; i < eventsGlobal.length; i++) {
          window.removeEventListener(eventsGlobal[i], globalListener);
        }
      };
    }, _eventMoveStart:function(ev) {
      var now = (new Date()).getTime();
      this.overlayLastMoveStartTime && this.overlayLastMoveStartTime + this.options.dblClickDelay > now ? (this.overlayLastMoveStartTime = 0, this.overlayInMovement = !0, this.overlayHookPointX = this.viewW / 2, this.overlayHookPointY = this.viewH / 2, !1 !== this.options.viewLiveFramerate ? this._eventMove({offsetX:this.panelWidth / 2, offsetY:this.panelHeight / 2}) : this._eventMoveEnd({offsetX:this.panelWidth / 2, offsetY:this.panelHeight / 2}), this.overlayInMovement = !1) : (this.overlayLastMoveStartTime = 
      now, this.viewLocked = this.overlayInMovement = !0, ev.offsetX >= this.viewX && ev.offsetX <= this.viewX + this.viewW && ev.offsetY >= this.viewY && ev.offsetY <= this.viewY + this.viewH ? (this.overlayHookPointX = ev.offsetX - this.viewX, this.overlayHookPointY = ev.offsetY - this.viewY) : (this.overlayHookPointX = this.viewW / 2, this.overlayHookPointY = this.viewH / 2, this._eventMove(ev)));
    }, _eventMove:function(ev) {
      var that = this;
      this._checkMousePosition(ev);
      this.overlayInMovement && (this.viewX = ev.offsetX - this.overlayHookPointX, this.viewY = ev.offsetY - this.overlayHookPointY, this.$view.style.left = this.viewX + "px", this.$view.style.top = this.viewY + "px", !1 !== this.options.viewLiveFramerate && (0 == this.options.viewLiveFramerate ? this._moveCy() : this.overlayTimeout || (this.overlayTimeout = setTimeout(function() {
        that._moveCy();
        that.overlayTimeout = !1;
      }, 1000 / this.options.viewLiveFramerate))));
    }, _checkMousePosition:function(ev) {
      ev.offsetX > this.viewX && ev.offsetX < this.viewX + this.viewBorderHorizontal + this.viewW && ev.offsetY > this.viewY && ev.offsetY < this.viewY + this.viewBorderVertical + this.viewH ? this.$panel.classList.add("mouseover-view") : this.$panel.classList.remove("mouseover-view");
    }, _eventMoveEnd:function(ev) {
      this.viewLocked = !1;
      this.$panel.classList.remove("mouseover-view");
      this.overlayInMovement && (this._eventMove(ev), !1 === this.options.viewLiveFramerate && this._moveCy(), this.overlayInMovement = !1);
    }, _eventZoom:function(ev) {
      var ev2 = extend({}, ev.originalEvent);
      ev2 = Math.pow(10, ev.wheelDeltaY / 1000 || ev.wheelDelta / 1000 || ev.detail / -32 || ev2.wheelDeltaY / 1000 || ev2.wheelDelta / 1000 || ev2.detail / -32);
      ev = {left:ev.offsetX, top:ev.offsetY};
      this.cy.zoomingEnabled() && this._zoomCy(ev2, ev);
    }, _updateThumbnailImage:function() {
      var that = this;
      this._thumbnailUpdating || (this._thumbnailUpdating = !0, this._onRenderHandler = throttle(function() {
        that._checkThumbnailSizesAndUpdate();
        that._setupView();
        var $img = that.$thumbnail, w = that.panelWidth, h = that.panelHeight, bb = that.boundingBox, zoom = Math.min(w / bb.w, h / bb.h), png = that.cy.png({full:!0, scale:zoom, maxHeight:h, maxWidth:w});
        0 > png.indexOf("image/png") ? $img.removeAttribute("src") : $img.setAttribute("src", png);
        w = (w - zoom * bb.w) / 2;
        h = (h - zoom * bb.h) / 2;
        $img.style.position = "absolute";
        $img.style.left = w + "px";
        $img.style.top = h + "px";
      }, that.options.rerenderDelay), this.cy.onRender(this._onRenderHandler));
    }, _moveCy:function() {
      this.cy.pan({x:-(this.viewX + this.viewBorderLeft - this.thumbnailPan.x) * this.width / this.viewW, y:-(this.viewY + this.viewBorderLeft - this.thumbnailPan.y) * this.height / this.viewH});
    }, _zoomCy:function(zoomRate, zoomCenterRaw) {
      zoomCenterRaw = {x:this.width / 2, y:this.height / 2};
      this.cy.zoom({level:this.cy.zoom() * zoomRate, renderedPosition:zoomCenterRaw});
    }};
    var register = function(cytoscape) {
      cytoscape && cytoscape("core", "navigator", function(options) {
        return new Navigator(this, options);
      });
    };
    "undefined" !== typeof module && module.exports ? module.exports = function(cytoscape) {
      register(cytoscape);
    } : "undefined" !== typeof define && define.amd && define("cytoscape-navigator", function() {
      return register;
    });
    "undefined" !== typeof cytoscape && register(cytoscape);
  })();
};

//# sourceMappingURL=module$node_modules$cytoscape_navigator$cytoscape_navigator.js.map
