/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.store.pubsub;

import com.corundumstudio.socketio.handler.AuthorizeHandler;
import com.corundumstudio.socketio.handler.ClientHead;
import com.corundumstudio.socketio.namespace.Namespace;
import com.corundumstudio.socketio.namespace.NamespacesHub;
import com.corundumstudio.socketio.protocol.JsonSupport;
import com.corundumstudio.socketio.store.StoreFactory;
import com.corundumstudio.socketio.store.pubsub.BulkJoinLeaveMessage;
import com.corundumstudio.socketio.store.pubsub.ConnectMessage;
import com.corundumstudio.socketio.store.pubsub.DisconnectMessage;
import com.corundumstudio.socketio.store.pubsub.DispatchMessage;
import com.corundumstudio.socketio.store.pubsub.JoinLeaveMessage;
import com.corundumstudio.socketio.store.pubsub.PubSubListener;
import com.corundumstudio.socketio.store.pubsub.PubSubStore;
import com.corundumstudio.socketio.store.pubsub.PubSubType;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseStoreFactory
implements StoreFactory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Long nodeId = (long)(Math.random() * 1000000.0);

    protected Long getNodeId() {
        return this.nodeId;
    }

    @Override
    public void init(final NamespacesHub namespacesHub, final AuthorizeHandler authorizeHandler, JsonSupport jsonSupport) {
        this.pubSubStore().subscribe(PubSubType.DISCONNECT, new PubSubListener<DisconnectMessage>(){

            @Override
            public void onMessage(DisconnectMessage msg) {
                BaseStoreFactory.this.log.debug("{} sessionId: {}", (Object)PubSubType.DISCONNECT, (Object)msg.getSessionId());
            }
        }, DisconnectMessage.class);
        this.pubSubStore().subscribe(PubSubType.CONNECT, new PubSubListener<ConnectMessage>(){
            final /* synthetic */ BaseStoreFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onMessage(ConnectMessage msg) {
                authorizeHandler.connect(msg.getSessionId());
                this.this$0.log.debug("{} sessionId: {}", (Object)PubSubType.CONNECT, (Object)msg.getSessionId());
            }
        }, ConnectMessage.class);
        this.pubSubStore().subscribe(PubSubType.DISPATCH, new PubSubListener<DispatchMessage>(){
            final /* synthetic */ BaseStoreFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onMessage(DispatchMessage msg) {
                String name = msg.getRoom();
                Namespace n = namespacesHub.get(msg.getNamespace());
                if (n != null) {
                    n.dispatch(name, msg.getPacket());
                }
                this.this$0.log.debug("{} packet: {}", (Object)PubSubType.DISPATCH, (Object)msg.getPacket());
            }
        }, DispatchMessage.class);
        this.pubSubStore().subscribe(PubSubType.JOIN, new PubSubListener<JoinLeaveMessage>(){
            final /* synthetic */ BaseStoreFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onMessage(JoinLeaveMessage msg) {
                String name = msg.getRoom();
                Namespace n = namespacesHub.get(msg.getNamespace());
                if (n != null) {
                    n.join(name, msg.getSessionId());
                }
                this.this$0.log.debug("{} sessionId: {}", (Object)PubSubType.JOIN, (Object)msg.getSessionId());
            }
        }, JoinLeaveMessage.class);
        this.pubSubStore().subscribe(PubSubType.BULK_JOIN, new PubSubListener<BulkJoinLeaveMessage>(){
            final /* synthetic */ BaseStoreFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onMessage(BulkJoinLeaveMessage msg) {
                Set<String> rooms = msg.getRooms();
                for (String room : rooms) {
                    Namespace n = namespacesHub.get(msg.getNamespace());
                    if (n == null) continue;
                    n.join(room, msg.getSessionId());
                }
                this.this$0.log.debug("{} sessionId: {}", (Object)PubSubType.BULK_JOIN, (Object)msg.getSessionId());
            }
        }, BulkJoinLeaveMessage.class);
        this.pubSubStore().subscribe(PubSubType.LEAVE, new PubSubListener<JoinLeaveMessage>(){
            final /* synthetic */ BaseStoreFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onMessage(JoinLeaveMessage msg) {
                String name = msg.getRoom();
                Namespace n = namespacesHub.get(msg.getNamespace());
                if (n != null) {
                    n.leave(name, msg.getSessionId());
                }
                this.this$0.log.debug("{} sessionId: {}", (Object)PubSubType.LEAVE, (Object)msg.getSessionId());
            }
        }, JoinLeaveMessage.class);
        this.pubSubStore().subscribe(PubSubType.BULK_LEAVE, new PubSubListener<BulkJoinLeaveMessage>(){
            final /* synthetic */ BaseStoreFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onMessage(BulkJoinLeaveMessage msg) {
                Set<String> rooms = msg.getRooms();
                for (String room : rooms) {
                    Namespace n = namespacesHub.get(msg.getNamespace());
                    if (n == null) continue;
                    n.leave(room, msg.getSessionId());
                }
                this.this$0.log.debug("{} sessionId: {}", (Object)PubSubType.BULK_LEAVE, (Object)msg.getSessionId());
            }
        }, BulkJoinLeaveMessage.class);
    }

    @Override
    public abstract PubSubStore pubSubStore();

    @Override
    public void onDisconnect(ClientHead client) {
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (distributed session store, distributed publish/subscribe)";
    }
}

