/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.store;

import com.corundumstudio.socketio.store.pubsub.PubSubListener;
import com.corundumstudio.socketio.store.pubsub.PubSubMessage;
import com.corundumstudio.socketio.store.pubsub.PubSubStore;
import com.corundumstudio.socketio.store.pubsub.PubSubType;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import io.netty.util.internal.PlatformDependent;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;

public class HazelcastPubSubStore
implements PubSubStore {
    private final HazelcastInstance hazelcastPub;
    private final HazelcastInstance hazelcastSub;
    private final Long nodeId;
    private final ConcurrentMap<String, Queue<String>> map = PlatformDependent.newConcurrentHashMap();

    public HazelcastPubSubStore(HazelcastInstance hazelcastPub, HazelcastInstance hazelcastSub, Long nodeId) {
        this.hazelcastPub = hazelcastPub;
        this.hazelcastSub = hazelcastSub;
        this.nodeId = nodeId;
    }

    @Override
    public void publish(PubSubType type, PubSubMessage msg) {
        msg.setNodeId(this.nodeId);
        this.hazelcastPub.getTopic(type.toString()).publish((Object)msg);
    }

    @Override
    public <T extends PubSubMessage> void subscribe(PubSubType type, final PubSubListener<T> listener, Class<T> clazz) {
        Queue oldList;
        String name = type.toString();
        ITopic topic = this.hazelcastSub.getTopic(name);
        String regId = topic.addMessageListener(new MessageListener<T>(){
            final /* synthetic */ HazelcastPubSubStore this$0;
            {
                this.this$0 = this$0;
            }

            public void onMessage(Message<T> message) {
                PubSubMessage msg = (PubSubMessage)message.getMessageObject();
                if (!this.this$0.nodeId.equals(msg.getNodeId())) {
                    listener.onMessage((PubSubMessage)message.getMessageObject());
                }
            }
        });
        Queue<String> list = (ConcurrentLinkedQueue<String>)this.map.get(name);
        if (list == null && (oldList = (Queue)this.map.putIfAbsent(name, list = new ConcurrentLinkedQueue<String>())) != null) {
            list = oldList;
        }
        list.add(regId);
    }

    @Override
    public void unsubscribe(PubSubType type) {
        String name = type.toString();
        Queue regIds = (Queue)this.map.remove(name);
        ITopic topic = this.hazelcastSub.getTopic(name);
        for (String id : regIds) {
            topic.removeMessageListener(id);
        }
    }

    @Override
    public void shutdown() {
    }
}

