/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.scheduler;

import com.corundumstudio.socketio.scheduler.CancelableScheduler;
import com.corundumstudio.socketio.scheduler.SchedulerKey;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.internal.PlatformDependent;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class HashedWheelScheduler
implements CancelableScheduler {
    private final Map<SchedulerKey, Timeout> scheduledFutures = PlatformDependent.newConcurrentHashMap();
    private final HashedWheelTimer executorService;
    private volatile ChannelHandlerContext ctx;

    public HashedWheelScheduler() {
        this.executorService = new HashedWheelTimer();
    }

    public HashedWheelScheduler(ThreadFactory threadFactory) {
        this.executorService = new HashedWheelTimer(threadFactory);
    }

    @Override
    public void update(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public void cancel(SchedulerKey key) {
        Timeout timeout = this.scheduledFutures.remove(key);
        if (timeout != null) {
            timeout.cancel();
        }
    }

    @Override
    public void schedule(final Runnable runnable, long delay, TimeUnit unit) {
        this.executorService.newTimeout(new TimerTask(){
            final /* synthetic */ HashedWheelScheduler this$0;
            {
                this.this$0 = this$0;
            }

            public void run(Timeout timeout) throws Exception {
                runnable.run();
            }
        }, delay, unit);
    }

    @Override
    public void scheduleCallback(final SchedulerKey key, final Runnable runnable, long delay, TimeUnit unit) {
        Timeout timeout = this.executorService.newTimeout(new TimerTask(){
            final /* synthetic */ HashedWheelScheduler this$0;
            {
                this.this$0 = this$0;
            }

            public void run(Timeout timeout) throws Exception {
                this.this$0.ctx.executor().execute(new Runnable(){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        try {
                            runnable.run();
                        }
                        finally {
                            this.this$1.this$0.scheduledFutures.remove(key);
                        }
                    }
                });
            }
        }, delay, unit);
        if (!timeout.isExpired()) {
            this.scheduledFutures.put(key, timeout);
        }
    }

    @Override
    public void schedule(final SchedulerKey key, final Runnable runnable, long delay, TimeUnit unit) {
        Timeout timeout = this.executorService.newTimeout(new TimerTask(){
            final /* synthetic */ HashedWheelScheduler this$0;
            {
                this.this$0 = this$0;
            }

            public void run(Timeout timeout) throws Exception {
                try {
                    runnable.run();
                }
                finally {
                    this.this$0.scheduledFutures.remove(key);
                }
            }
        }, delay, unit);
        if (!timeout.isExpired()) {
            this.scheduledFutures.put(key, timeout);
        }
    }

    @Override
    public void shutdown() {
        this.executorService.stop();
    }
}

