/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio;

import com.corundumstudio.socketio.AckCallback;
import com.corundumstudio.socketio.SocketIOClient;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class BroadcastAckCallback<T> {
    final AtomicBoolean loopFinished = new AtomicBoolean();
    final AtomicInteger counter = new AtomicInteger();
    final AtomicBoolean successExecuted = new AtomicBoolean();
    final Class<T> resultClass;
    final int timeout;

    public BroadcastAckCallback(Class<T> resultClass, int timeout) {
        this.resultClass = resultClass;
        this.timeout = timeout;
    }

    public BroadcastAckCallback(Class<T> resultClass) {
        this(resultClass, -1);
    }

    final AckCallback<T> createClientCallback(final SocketIOClient client) {
        this.counter.getAndIncrement();
        return new AckCallback<T>(this, this.resultClass, this.timeout){
            final /* synthetic */ BroadcastAckCallback this$0;
            {
                this.this$0 = this$0;
                super(resultClass, timeout);
            }

            @Override
            public void onSuccess(T result) {
                this.this$0.counter.getAndDecrement();
                this.this$0.onClientSuccess(client, result);
                this.this$0.executeSuccess();
            }

            @Override
            public void onTimeout() {
                this.this$0.onClientTimeout(client);
            }
        };
    }

    protected void onClientTimeout(SocketIOClient client) {
    }

    protected void onClientSuccess(SocketIOClient client, T result) {
    }

    protected void onAllSuccess() {
    }

    private void executeSuccess() {
        if (this.loopFinished.get() && this.counter.get() == 0 && this.successExecuted.compareAndSet(false, true)) {
            this.onAllSuccess();
        }
    }

    void loopFinished() {
        this.loopFinished.set(true);
        this.executeSuccess();
    }
}

