(ns ^:no-doc clj.generate.defn
  (:require [clj.generate.file :as gen-file]
            [clj.generate.ns :as gen-ns]
            [clj.new.templates :as tmpl]
            [clojure.java.io :as io]
            [clojure.string :as str]))

(defn generate
  "Append the specified function to the specified namespace.
  Create the namespace if necessary. The fn-name should be
  fully-qualified: my.ns/my-func"
  [prefix fn-name]
  (let [[ns-name the-fn] (str/split fn-name #"/")
        path (tmpl/name-to-path ns-name)
        ext "clj"
        ns-file (io/file (str prefix "/" path "." ext))]
    (when-not (.exists ns-file)
      (gen-ns/generate prefix ns-name))
    (gen-file/generate prefix ns-name
      (str "\n(defn " the-fn
           "\n  \"Generated by clj\""
           "\n  [args]"
           "\n  (println \"WRITEME\"))\n")
      ext
      true)))
