<img src="https://github.com/polyfy/polylith/blob/master/images/logo.png" width="30%" alt="Polylith" id="logo">

The Polylith documentation can be found here:

- The [high-level documentation](https://polylith.gitbook.io/polylith)
- The [Polylith Tool documentation](https://github.com/polyfy/polylith)
- The [RealWorld example app documentation](https://github.com/furkan3ayraktar/clojure-polylith-realworld-example-app)

You can also get in touch with the Polylith Team on [Slack](https://clojurians.slack.com/archives/C013B7MQHJQ).

# {{name}}

{{description}}

## Installation

Download from https://{{scm-domain}}/{{scm-user}}/{{artifact}}

## Usage

FIXME: explanation

Get info about the workspace:

    $ clojure -M:poly info

In addition to the `development` project which you will use with a REPL
for developing against the whole workspace, there are two projects:

* `{{name}}` -- a command-line application, aliased as `app`
* `{{name}}-lib` -- a simple library, aliased as `lib`

Run all the workspace's tests, including the development tests:

    $ clojure -M:poly test :all :dev

This runs all of the tests in the workspace, including the example
generative test in the {{name}} `app` project.

> Normally, you would run just tests for components that have changed: `clojure -M:poly test` (optionally with `:project` to all run project-specific tests).

To develop against this workspace, start a REPL in your favorite way, using the `:dev` and `:test` aliases.

Build a deployable artifact for the {{name}} command-line application project:

    $ ( cd projects/{{name}} && clojure -T:build uber )

Run that uberjar:

    $ java -jar projects/{{name}}/target/{{name}}-{{version}}.jar
    Hello, World!
    $ java -jar projects/{{name}}/target/{{name}}-{{version}}.jar Lisa
    Hello, Lisa!

Build a deployable library artifact for the {{name}}-lib project:

    $ ( cd projects/{{name}}-lib && clojure -T:build jar )

This will produce a generated `pom.xml` file in the project's `target` folder and
synchronize the dependencies with that project's `deps.edn` file.

It will have the coordinates `{{group}}/{{artifact}}` (and a version of `"{{version}}"` initially).

You can install that JAR file locally:

    $ ( cd projects/{{name}}-lib && clojure -T:build deploy :installer :local )

You can also deploy that JAR file to Clojars:

    $ ( cd projects/{{name}}-lib && clojure -T:build deploy )

You can then depend on the library in other projects (adjust the `:mvn/version` as necessary):

    $ clj -Sdeps '{:deps { {{group}}/{{artifact}} {:mvn/version "{{version}}"} }}'
    Clojure 1.10.3
    user=> (require '[{{namespace}}.greeter.interface :as greet])
    nil
    user=> (greet/greeting {:person "REPL"})
    "Hello, REPL!"


## Options

FIXME: listing of options this app accepts.

## Examples

...

### Bugs

...

### Any Other Sections
### That You Think
### Might be Useful

## License

Copyright © {{year}} {{developer}}

_EPLv1.0 is just the default for projects generated by `clj-new`: you are not_
_required to open source this project, nor are you required to use EPLv1.0!_
_Feel free to remove or change the `LICENSE` file and remove or update this_
_section of the `README.md` file!_

Distributed under the Eclipse Public License version 1.0.
