(ns ribelo.doxa-page.examples.transactions
  (:require
   [reagent.core :as r]
   [re-frame.core :as rf]
   [ribelo.doxa :as dx]))

(defn random-person [id]
  (println :id id)
  {:person/id id
   :name (rand-nth ["Ivan" "Petr" "Ivan" "Oleg" "Lucy"])
   :age (rand-int 100)
   :aka (vec (take (inc (rand-int 2)) ["Tupen", "Devil", "Goofy" "Donald" "Micky"]))
   :child [(when-let [id (rand-int id)] {:person/id id})]})

(rf/reg-event-fx
  ::put-person
  (fn [{:keys [db]} _]
    (let [id (or (dx/pick db :person-id [:app/id :transactions]) 0)
          person (random-person id)]
      {:commit [[:dx/put person]
                [:dx/update [:app/id :transactions] :person-id (fnil inc 0)]]})))

(rf/reg-event-fx
  ::merge-person
  (fn [{:keys [db]} _]
    (let [id (or (dx/pick db :person-id [:app/id :transactions]) 0)
          person (random-person id)]
      {:commit [[:dx/merge person]
                [:dx/update [:app/id :transactions] :person-id (fnil inc 0)]]})))

(rf/reg-event-fx
  ::clear-people
  (fn [{:keys [db]} _]
    (let [id (or (dx/pick db :person-id [:app/id :transactions]) 0)
          person (random-person id)]
      {:commit [[:dx/merge person]
                [:dx/update [:app/id :transactions] :person-id (fnil inc 0)]]})))

(dx/commit {[:app/id :transactions] {:person-id 0}} [:dx/update [:app/id :transactions] :person-id (fnil inc 0)])

(rf/reg-sub
  ::people
  (fn [db _]
    (dx/table db :person/id)))

(defn db-view []
  (let [table @(rf/subscribe [::people])]
    [:div
     (doall
       (for [[ref m] table]
         [:div {:class [:flex :flex-row]}
          [:div "{"]
          [:div {:class [:w-24]}
           (str ref)]
          [:div {:class [:flex]}
           [:div "{"]
           [:div {:class [:flex-col]}
            (doall
              (for [[k v] m]
                [:div {:class [:flex :flex-row]}
                 [:div {:class [:w-24]}
                  (str k)]
                 [:div
                  (str v)]]))]
           [:div {:class [:self-end]}
            "}"]]
          [:div {:class [:self-end]}
           "}"]]))]))

(defn view []
  [:div {:class [:flex :flex-col :grow :m-12]}
   [:div {:class [:flex :flex-row :justify-center :mb-12]}
    [:div {:class [:bg-nord-2 :hover:bg-nord-3 :text-nord-5 :px-2 :mx-4 :cursor-pointer]
           :on-click #(rf/dispatch [::put-person])}
     "put random person"]
    [:div {:class [:bg-nord-2 :hover:bg-nord-3 :text-nord-5 :px-2 :mx-4 :cursor-pointer]}
     "merge random person"]
    [:div {:class [:bg-nord-2 :hover:bg-nord-3 :text-nord-5 :px-2 :mx-4 :cursor-pointer]}
     "delete random person"]]
   [db-view]])
