# What is polarizer-umb?

This is a small JMS/ActiveMQ helper library specifically designed for an ActiveMQ broker using a TLS cert for authentication and 
encryption.

## What can I use it for?

The polarizer-vertx project makes use of this in its UMB (Unified Message Bus) verticle.  It uses this library's asynchronous mode
to listen for objects, by bridging the MessageListener with an rxjava Observable.

## Why did I make it?

- Because not every QE team uses python
- Because having a Jenkins plugin that listens for messages to kick off a job based on JMS message is not the only use case
  - Allows (for example) tests kicked off by travis, semaphore, or anything else non-Jenkins

While the redhat-ci-jenkins plugin is definitely useful, it's also not flexible.  Ideally, a higher level library
should have been created and the jenkins plugin would have been written to use this.  In other words, the plugin would
have just been another client making use of the library.  Had this strategy been followed, other teams with other 
requirements (for example, not testing on jenkins or with other workflows) could have made use of it too. 

Currently, if another application wants to make use of this library, they would need to follow the directions for setting up their
own TLS cert and getting the appropriate permissions.  This is not needed if they only wish to make use of listening for messages on 
the UMB that are published from the following queue Destination:


## Configuration and Requirements

The JMS broker we are using requires client side TLS authentication.  If you have a Broker that requires this, you need to set up
the broker-config.yml file:

```yaml

brokers:
  ci:
    url: "failover:(ssl://your.broker1:12345,ssl://your.broker2:12345)"
    user: foo
    password: blah
    messages:
      timeout: 300000
      maxMsgs: 2
    tls:
      keystore-path: "/path/to/your/keystore.jks"  # Path to the .jks keystore
      truststore-path: "/path/to/your/truststore.jks"       # Path to the .jks truststore
      keystorekey-pw: "pw-of-pvtkey-tokeystore"             # Password of the private key (from the .p12 file)
      keystore-pw: "pw-of-keystore"                         # Password of the keystore file (jks)
      truststore-pw: "pw-of-truststore"                     # Password of the truststore file
  metrics:
    url: "another.server.com:65432"
    user: "foo"
    password: "bar"
    messages:
      timeout: 1000
      maxMsgs: 1
defaultBroker: ci
```

Here, the brokers are keyed by name (eg, 'ci' and 'metrics').  If your broker requires client side TLS, then you can use the tls 
section to store the required keystores and truststores (sorry, no PEM or CRT formats).

The messages section has a timeout and maxMsgs.  These are used to specify max times if you are using the CIBusListener's listen() 
methods.  The listen() methods are essentially blocking loops that will wait that long for messages to arrive before timing out.
The maxMsgs is the number of messages to receive before exiting the loop.

## How to build it

```
./gradlew clean
./gradlew build
./gradlew install  # Optional, but useful for local builds
./gradlew uploadArchives  # When ready to release a new SNAPSHOT
```

Currently, non SNAPSHOT builds will not work until a way is found to sign the POM file generated by the build.  The 
maven central repository has a hard requirement that all artifacts must be signed with a GPG key.  The build.gradle will
sign everything _except_ the POM file, preventing a release.

However, this requirement is not in place for SNAPSHOT builds.  A SNAPSHOT release is made so long as in the version
it has SNAPSHOT in the version string.

# Notes on UMB

This document is a set of notes about JMS in general and of the Unified Messaging Bus specifically.

## What is a Messaging service?

Many enterprise applications require the use of a messaging service so that different different parts of the enterprise
application can communicate with each other. Having a message service brings several advantages

- Decouples the sender from the receiver
- Messages can be sent asynchronously
- Messages can be persisted

A Message Client can either be a producer or consumer (or both) of messages. A Message is just some form of data, so it
could for example be a JSON string, a binary blob, or even a java object. When a Message *Producer* has a message ready,
it will send it to a *Destination*. A Message *Consumer* likewise, will look to a destination in order to listen to any
messages.

this decouples Producers from Consumers.  Neither of them need to know anything about the other.  The only thing that
either of them need to know is:

- The destination name
- The format of the message

An analogy would be a magazine.  The message producers are like authors writing articles in the magazine, and the
consumers are people who want to read the content of this magazine.  The magazine itself is the destination, and the
format of the message is a string (in English).

There are two ways for message consumers to get messages they want. The first is to listen (subscribe) to the
Destination where messages are being sent. However, it is quite possible that many many messages are all being sent to
the same Destination. There needs to be a way to filter for only messages that you are interested in. This is what JMS
selectors do. By looking at some information inside the Message itself, it is possible to filter for messages a client
wants. JMS selectors are often compared to be something like a mini-querying language.

Messages can be sent either in a point-to-point style or a publish/subscribe style. We will not really cover the point
to point style and instead focus on pub-sub (as it is often called). Some messaging servers can use TLS to enforce that
clients using the message bus have access to it.

For more detailed reference, please read the [JMS Overview][-jms-overview]

### Terminology


**Broker**
  The server that the Messaging Clients talk to

**Destination**
  Sort of like a named address, where messages can be sent and picked up

**Topic**
  A kind of Destination usually used in pub-sub messaging

**Queue**
  Another kind of a Destination normally used in point-to-point messaging

**Selector**
  A string representing a query to filter messages based on criteria


## What is the Unified Messaging Bus (UMB)?

The Unified Messaging Bus is an internal messaging service that uses ActiveMQ as the JMS provider. Clients that wish to
make use of the UMB needs to authenticate itself to the UMB broker. Part of this document will go over what is required
for teams who need to use the UMB, whether they are sending messages for other clients to make use of, or if they need
their own application to listen for messages sent to destinations on the UMB .

### Who uses the UMB?

The redhat CI jenkins plugin does. So does the XUnit and TestCase Importer services for Polarion. If you are using the
redhat CI jenkins plugin, the plugin will do most of the work for you. It will take the xunit it was supplied, make the
import request and then listen for a reply on the message bus if it was successful. All of this work is captured by the
plugin.

This plugin can also trigger based on Brew messages. When a package is built on brew and put in stage (or production), a
message will be sent by Brew on the UMB. The redhat-ci-plugin can listen for these brew messages, and can trigger a job
that you specify (based on a JMS selector).

More and more teams are switching over to use the UMB.  Currently the cimetrics team 

### Do I need to use the UMB?

If you have an application that either needs to talk to another application which is listening on the UMB, you might
need to. Similarly, if you have an application that needs to listen for a mesage that another application sends to a
Destination on the UMB, then you will probably want to read the rest of this document.

Otherwise, feel free to stop reading :)

## What if I am not using java?

ActiveMQ uses the JMS API, but it can speak over several different "on-the-wire" protocols.  By this, I mean how the
data is actually framed and sent over a physical connection.  This means that you can use a different language that
speaks this same protocol.

## What you will need for the UMB

There are several JMS concepts that you will need to understand to make use of the Unified Messaging Bus.  

### JMS Destination

In JMS terminology, a destination is like an address for where messages can be sent and picked up.  There are
two general kinds of Destinations:

**Queue**
  Meant for one-on-one communication

**Topic**

### JMS Topic vs Queue

What is the difference?  First you need to understand that messaging systems like JMS provide two general forms of passing
messages along:  point-to-point (PTP) and publish-subscribe (pub-sub)

In PTP message passing, one or more producers sends messages into a queue.  One consumer then creates a subscription to this
queue and pulls off messages.  While it is technically possible for multiple consumers to subscribe to the same queue, this
probably is not a good idea, since each consumer will get different messages.  The one exception to this is a multithreaded
context where you have two consumers pulling messages off as fast as they can.

In pub-sub, one or more producers sends messages to a topic (which is sort of like a bulletin board).  One or more consumers
can then subscribe to this topic, and each consumer will get all the same messages.

Why are there two different kinds of message passing?  Queues are good if you have only one consumer that needs access to
some messages being produced.  Queues have the additional advantage that they can be load balanced and spread across multiple
threads better (including in clustered cases).  It is not good however when different consumers all need to have access to the
message(s) produced.  This is what pub-sub is good at.  However, it is not good at load-balancing.  This is why there exists
in ActiveMQ VirtualDestinations.

VirtualDestinations have the benefits of both PTP and pub-sub.


The UMB makes note that both Hierarchy and Consumers are queues, while VirtualTopics are topics. In Java this makes a
difference, since you may need to call either

```
  Session session = connection.createSession(false, Session.AUTO_ACKNOWLEDGE);
  Topic dest = session.createTopic("VirtualTopic.rhsm.qe.>");
```

or

```
  Session session = connection.createSession(false, Session.AUTO_ACKNOWLEDGE);
  Queue dest = session.createQueue("Consumer.client-polarize..VirtualTopic.rhsm.qe");
```

### A word about ActiveMQ Wildcards

**TODO**  The UMB naming conventions make a lot of use of ActiveMQ's wildcards, so we should talk about them

Reference: [ActiveMQ Wildcards][-wildcards]


#### Virtual Topics

**TODO**  Discuss what Virtual Topics are and what they solve

References

- [Mojo doc on Virtual Topics][-virt-topics]
- [ActiveMQ doc on Virtual Destinations][-virt-destinations]


### Messaging permissions

When you request permission for access to the UMB, you will be given a default set of permissions.  You can request to change
these when you create your servicenow ticket, but that may take extra time and/or permission.  These are your default
permissions:


| Hierarchy                                             | Type  | Permissions | Examples                                       |
|-------------------------------------------------------|-------|-------------|------------------------------------------------|
| HIERARCHY_NAME.>	                                    | queue |  read/write |	qe.ci                                          | 
| VirtualTopic.HIERARCHY_NAME.>	                        | topic |  write      | VirtualTopic.qe.ci                             |
| Consumer.CLIENT_NAME.\*.VirtualTopic.HIERARCHY_NAME.> | queue |  read       |	Consumer.client-polarize.\*.VirtualTopic.qe.ci |

Note that there are no global permissions.  You only have read/write access to the namespace you were given when you requested
access for your client application name in your servicenow ticket.

What does the above table mean?  If you have an application that needs to publish messages to the UMB, then you need a
VirtualTopic.HIERARCHY, and if you have a consumer that needs to subscribe to messages from a publisher, it needs to be on from
the Consumer namespace.

For example, let's say we have the following information:

- client name:  client-polarize
- Hiearchy: rhsm.qe.polarize
- sends messages to:  VirtualTopic.rhsm.qe.polarize
- listens for messages from:
  - XUnit Importer: **TODO: Find out what this is from source code in ci-ops-tools**
  - TestCase Importer: **TODO: same as above** 


## References


Other useful references:

- [Unified Message Bus Index][-umb-index]

[-umb-index]: https://mojo.redhat.com/docs/DOC-1072237
[-jms-overview]: https://docs.oracle.com/javaee/7/tutorial/jms-concepts002.htm
[-virt-topics]: https://mojo.redhat.com/docs/DOC-1072549
[-virt-destinations]: http://activemq.apache.org/virtual-destinations.html
[-wildcards]: https://activemq.apache.org/wildcards.html

