/*
 * Decompiled with CFR 0.152.
 */
package org.I0Itec.zkclient.util;

import java.util.List;
import org.I0Itec.zkclient.ZkClient;

public class ZkPathUtil {
    public static String toString(ZkClient zkClient) {
        return ZkPathUtil.toString(zkClient, "/", PathFilter.ALL);
    }

    public static String toString(ZkClient zkClient, String startPath, PathFilter pathFilter) {
        boolean level = true;
        StringBuilder builder = new StringBuilder("+ (" + startPath + ")");
        builder.append("\n");
        ZkPathUtil.addChildrenToStringBuilder(zkClient, pathFilter, 1, builder, startPath);
        return builder.toString();
    }

    private static void addChildrenToStringBuilder(ZkClient zkClient, PathFilter pathFilter, int level, StringBuilder builder, String startPath) {
        List<String> children2 = zkClient.getChildren(startPath);
        for (String node : children2) {
            String nestedPath = startPath.endsWith("/") ? startPath + node : startPath + "/" + node;
            if (pathFilter.showChilds(nestedPath)) {
                builder.append(ZkPathUtil.getSpaces(level - 1) + "'-" + "+" + node + "\n");
                ZkPathUtil.addChildrenToStringBuilder(zkClient, pathFilter, level + 1, builder, nestedPath);
                continue;
            }
            builder.append(ZkPathUtil.getSpaces(level - 1) + "'-" + "-" + node + " (contents hidden)\n");
        }
    }

    private static String getSpaces(int level) {
        String s = "";
        for (int i = 0; i < level; ++i) {
            s = s + "  ";
        }
        return s;
    }

    public static interface PathFilter {
        public static final PathFilter ALL = new PathFilter(){

            @Override
            public boolean showChilds(String path) {
                return true;
            }
        };

        public boolean showChilds(String var1);
    }
}

