/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.Cluster;
import kafka.consumer.TopicCount;
import kafka.consumer.TopicCount$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZKGroupDirs;
import kafka.utils.ZkUtils$;
import kafka.utils.ZkUtils$$anonfun$getConsumersPerTopic$1$;
import kafka.utils.ZkUtils$$anonfun$getPartitionsForTopics$1$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.TraitSetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ZkUtils$
implements Logging {
    public static final ZkUtils$ MODULE$;
    private final String ConsumersPath;
    private final String BrokerIdsPath;
    private final String BrokerTopicsPath;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    public volatile int bitmap$0;

    static {
        new ZkUtils$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ZkUtils$ zkUtils$ = this;
        synchronized (zkUtils$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    @TraitSetter
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public String ConsumersPath() {
        return this.ConsumersPath;
    }

    public String BrokerIdsPath() {
        return this.BrokerIdsPath;
    }

    public String BrokerTopicsPath() {
        return this.BrokerTopicsPath;
    }

    public void makeSurePersistentPathExists(ZkClient client, String path) {
        if (!client.exists(path)) {
            client.createPersistent(path, true);
        }
    }

    private void createParentPath(ZkClient client, String path) {
        String parentDir = path.substring(0, path.lastIndexOf(47));
        if (parentDir.length() != 0) {
            client.createPersistent(parentDir, true);
        }
    }

    private void createEphemeralPath(ZkClient client, String path, String data2) {
        try {
            client.createEphemeral(path, data2);
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(client, path);
            client.createEphemeral(path, data2);
        }
    }

    public void createEphemeralPathExpectConflict(ZkClient client, String path$1, String data$1) {
        ObjectRef storedData$1;
        ZkNodeExistsException zkNodeExistsException2;
        block6: {
            try {
                this.createEphemeralPath(client, path$1, data$1);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            catch (ZkNodeExistsException zkNodeExistsException2) {
                storedData$1 = new ObjectRef(null);
                try {
                    storedData$1.elem = this.readData(client, path$1);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                catch (ZkNoNodeException zkNoNodeException) {
                    // empty catch block
                }
                if ((String)storedData$1.elem == null) break block6;
                String string2 = (String)storedData$1.elem;
                String string3 = data$1;
                if (string2 != null ? !string2.equals(string3) : string3 != null) break block6;
                this.info((Function0<String>)((Object)new Serializable(path$1, data$1){
                    public static final long serialVersionUID;
                    private final String path$1;
                    private final String data$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)this.path$1).append((Object)" exists with value ").append((Object)this.data$1).append((Object)" during connection loss; this is ok").toString();
                    }
                    {
                        this.path$1 = string2;
                        this.data$1 = string3;
                    }
                }));
            }
            return;
        }
        this.info((Function0<String>)((Object)new Serializable(path$1, data$1, storedData$1){
            public static final long serialVersionUID;
            private final String path$1;
            private final String data$1;
            private final ObjectRef storedData$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"conflict in ").append((Object)this.path$1).append((Object)" data: ").append((Object)this.data$1).append((Object)" stored data: ").append((Object)((String)this.storedData$1.elem)).toString();
            }
            {
                this.path$1 = string2;
                this.data$1 = string3;
                this.storedData$1 = objectRef;
            }
        }));
        throw zkNodeExistsException2;
    }

    public void updatePersistentPath(ZkClient client, String path, String data2) {
        try {
            client.writeData(path, data2);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(client, path);
            try {
                client.createPersistent(path, data2);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            catch (ZkNodeExistsException zkNodeExistsException) {
                client.writeData(path, data2);
            }
        }
    }

    public void updateEphemeralPath(ZkClient client, String path, String data2) {
        try {
            client.writeData(path, data2);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(client, path);
            client.createEphemeral(path, data2);
        }
    }

    public void deletePath(ZkClient client, String path$2) {
        try {
            client.delete(path$2);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.info((Function0<String>)((Object)new Serializable(path$2){
                public static final long serialVersionUID;
                private final String path$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)this.path$2).append((Object)" deleted during connection loss; this is ok").toString();
                }
                {
                    this.path$2 = string2;
                }
            }));
        }
    }

    public void deletePathRecursive(ZkClient client, String path$3) {
        try {
            client.deleteRecursive(path$3);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.info((Function0<String>)((Object)new Serializable(path$3){
                public static final long serialVersionUID;
                private final String path$3;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)this.path$3).append((Object)" deleted during connection loss; this is ok").toString();
                }
                {
                    this.path$3 = string2;
                }
            }));
        }
    }

    public String readData(ZkClient client, String path) {
        return (String)client.readData(path);
    }

    public String readDataMaybeNull(ZkClient client, String path) {
        return (String)client.readData(path, true);
    }

    public Seq<String> getChildren(ZkClient client, String path) {
        return JavaConversions$.MODULE$.asScalaBuffer(client.getChildren(path));
    }

    public Seq<String> getChildrenParentMayNotExist(ZkClient client, String path) {
        java.util.List<String> ret = null;
        try {
            ret = client.getChildren(path);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            return Nil$.MODULE$;
        }
        return JavaConversions$.MODULE$.asScalaBuffer(ret);
    }

    public boolean pathExists(ZkClient client, String path) {
        return client.exists(path);
    }

    public String getLastPart(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    /*
     * WARNING - void declaration
     */
    public Cluster getCluster(ZkClient zkClient$1) {
        void var2_2;
        Cluster cluster$1 = new Cluster();
        Seq<String> nodes = this.getChildrenParentMayNotExist(zkClient$1, this.BrokerIdsPath());
        nodes.foreach(new Serializable(zkClient$1, cluster$1){
            public static final long serialVersionUID;
            private final ZkClient zkClient$1;
            private final Cluster cluster$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Option<Broker> apply(String node) {
                String brokerZKString = ZkUtils$.MODULE$.readData(this.zkClient$1, new StringBuilder().append((Object)ZkUtils$.MODULE$.BrokerIdsPath()).append((Object)"/").append((Object)node).toString());
                return this.cluster$1.add(Broker$.MODULE$.createBroker(Predef$.MODULE$.augmentString(node).toInt(), brokerZKString));
            }
            {
                this.zkClient$1 = zkClient;
                this.cluster$1 = cluster;
            }
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.mutable.Map<String, List<String>> getPartitionsForTopics(ZkClient zkClient$3, Iterator<String> topics) {
        void var3_3;
        HashMap ret$1 = new HashMap();
        topics.foreach(new Serializable(zkClient$3, ret$1){
            public static final long serialVersionUID;
            public final ZkClient zkClient$3;
            private final HashMap ret$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final HashMap<String, List<String>> apply(String topic$1) {
                ObjectRef partList$1 = new ObjectRef(Nil$.MODULE$);
                Seq<String> brokers = ZkUtils$.MODULE$.getChildrenParentMayNotExist(this.zkClient$3, new StringBuilder().append((Object)ZkUtils$.MODULE$.BrokerTopicsPath()).append((Object)"/").append((Object)topic$1).toString());
                brokers.foreach(new Serializable(this, topic$1, partList$1){
                    public static final long serialVersionUID;
                    private final anonfun.getPartitionsForTopics.1 $outer;
                    private final String topic$1;
                    public final ObjectRef partList$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(String broker$1) {
                        int nParts = Predef$.MODULE$.augmentString(ZkUtils$.MODULE$.readData(this.$outer.zkClient$3, new StringBuilder().append((Object)ZkUtils$.MODULE$.BrokerTopicsPath()).append((Object)"/").append((Object)this.topic$1).append((Object)"/").append((Object)broker$1).toString())).toInt();
                        Predef$.MODULE$.intWrapper(0).until(nParts).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(this, broker$1){
                            public static final long serialVersionUID;
                            private final anonfun$getPartitionsForTopics$1$$anonfun$apply$2 $outer;
                            private final String broker$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final void apply(int part) {
                                this.apply$mcVI$sp(part);
                            }

                            public void apply$mcVI$sp(int v1) {
                                this.$outer.partList$1.elem = ((List)this.$outer.partList$1.elem).$colon$colon(new StringBuilder().append((Object)this.broker$1).append((Object)"-").append(BoxesRunTime.boxToInteger(v1)).toString());
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.broker$1 = string2;
                            }
                        }));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.topic$1 = string2;
                        this.partList$1 = objectRef;
                    }
                });
                partList$1.elem = (List)((List)partList$1.elem).sortWith(new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(String s, String t) {
                        return Predef$.MODULE$.augmentString(s).$less(t);
                    }
                });
                return this.ret$1.$plus$eq(Predef$.MODULE$.any2ArrowAssoc(topic$1).$minus$greater((List)partList$1.elem));
            }
            {
                this.zkClient$3 = zkClient;
                this.ret$1 = hashMap;
            }
        });
        return var3_3;
    }

    public void setupPartition(ZkClient zkClient, int brokerId, String host, int port, String topic, int nParts) {
        String brokerIdPath = new StringBuilder().append((Object)this.BrokerIdsPath()).append((Object)"/").append(BoxesRunTime.boxToInteger(brokerId)).toString();
        Broker broker = new Broker(brokerId, ((Object)BoxesRunTime.boxToInteger(brokerId)).toString(), host, port);
        this.createEphemeralPathExpectConflict(zkClient, brokerIdPath, broker.getZKString());
        String brokerPartTopicPath = new StringBuilder().append((Object)this.BrokerTopicsPath()).append((Object)"/").append((Object)topic).append((Object)"/").append(BoxesRunTime.boxToInteger(brokerId)).toString();
        this.createEphemeralPathExpectConflict(zkClient, brokerPartTopicPath, ((Object)BoxesRunTime.boxToInteger(nParts)).toString());
    }

    public void deletePartition(ZkClient zkClient, int brokerId, String topic) {
        String brokerIdPath = new StringBuilder().append((Object)this.BrokerIdsPath()).append((Object)"/").append(BoxesRunTime.boxToInteger(brokerId)).toString();
        zkClient.delete(brokerIdPath);
        String brokerPartTopicPath = new StringBuilder().append((Object)this.BrokerTopicsPath()).append((Object)"/").append((Object)topic).append((Object)"/").append(BoxesRunTime.boxToInteger(brokerId)).toString();
        zkClient.delete(brokerPartTopicPath);
    }

    public Seq<String> getConsumersInGroup(ZkClient zkClient, String group) {
        ZKGroupDirs dirs = new ZKGroupDirs(group);
        return this.getChildren(zkClient, dirs.consumerRegistryDir());
    }

    public Map<String, TopicCount> getConsumerTopicMaps(ZkClient zkClient$4, String group) {
        ZKGroupDirs dirs$1 = new ZKGroupDirs(group);
        Seq<String> consumersInGroup = this.getConsumersInGroup(zkClient$4, group);
        Seq topicCountMaps = consumersInGroup.map(new Serializable(zkClient$4, dirs$1){
            public static final long serialVersionUID;
            private final ZkClient zkClient$4;
            private final ZKGroupDirs dirs$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final TopicCount apply(String consumerId) {
                return TopicCount$.MODULE$.constructTopicCount(consumerId, ZkUtils$.MODULE$.readData(this.zkClient$4, new StringBuilder().append((Object)this.dirs$1.consumerRegistryDir()).append((Object)"/").append((Object)consumerId).toString()), this.zkClient$4);
            }
            {
                this.zkClient$4 = zkClient;
                this.dirs$1 = zKGroupDirs;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return ((TraversableOnce)consumersInGroup.zip(topicCountMaps, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public scala.collection.mutable.Map<String, List<String>> getConsumersPerTopic(ZkClient zkClient$2, String group$1) {
        ZKGroupDirs dirs = new ZKGroupDirs(group$1);
        Seq<String> consumers = this.getChildrenParentMayNotExist(zkClient$2, dirs.consumerRegistryDir());
        HashMap<String, List<String>> consumersPerTopicMap$1 = new HashMap<String, List<String>>();
        consumers.foreach(new Serializable(zkClient$2, group$1, consumersPerTopicMap$1){
            public static final long serialVersionUID;
            private final ZkClient zkClient$2;
            private final String group$1;
            public final HashMap consumersPerTopicMap$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String consumer) {
                TopicCount topicCount = TopicCount$.MODULE$.constructTopicCount(this.group$1, consumer, this.zkClient$2);
                ((IterableLike)topicCount.getConsumerThreadIdsPerTopic().filter((Function1<String, Object>)((Object)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(Tuple2<String, Set<String>> tuple2) {
                        Tuple2<String, Set<String>> tuple22 = tuple2;
                        return tuple22 != null;
                    }
                }))).foreach(new Serializable(this){
                    public static final long serialVersionUID;
                    private final anonfun.getConsumersPerTopic.1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(Tuple2<String, Set<String>> tuple2) {
                        Tuple2<String, Set<String>> tuple22 = tuple2;
                        if (tuple22 != null) {
                            String string2;
                            String topic$2 = string2 = tuple22._1();
                            ((IterableLike)tuple22._2()).foreach(new Serializable(this, topic$2){
                                public static final long serialVersionUID;
                                private final anonfun$getConsumersPerTopic$1$$anonfun$apply$5 $outer;
                                private final String topic$2;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final Option<List<String>> apply(String consumerThreadId) {
                                    Option<GenTraversable<String>> option;
                                    Option<B> option2 = this.$outer.kafka$utils$ZkUtils$$anonfun$$anonfun$$$outer().consumersPerTopicMap$1.get(this.topic$2);
                                    if (option2 instanceof Some) {
                                        String string2 = consumerThreadId;
                                        option = this.$outer.kafka$utils$ZkUtils$$anonfun$$anonfun$$$outer().consumersPerTopicMap$1.put(this.topic$2, ((List)((Some)option2).x()).$colon$colon(string2));
                                    } else {
                                        option = this.$outer.kafka$utils$ZkUtils$$anonfun$$anonfun$$$outer().consumersPerTopicMap$1.put(this.topic$2, List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{consumerThreadId})));
                                    }
                                    return option;
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.topic$2 = string2;
                                }
                            });
                            return;
                        }
                        throw new MatchError(tuple22);
                    }

                    public anonfun.getConsumersPerTopic.1 kafka$utils$ZkUtils$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.zkClient$2 = zkClient;
                this.group$1 = string2;
                this.consumersPerTopicMap$1 = hashMap;
            }
        });
        ((HashMap)consumersPerTopicMap$1.filter((Function1<String, Object>)((Object)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<String, List<String>> tuple2) {
                Tuple2<String, List<String>> tuple22 = tuple2;
                return tuple22 != null;
            }
        }))).foreach(new Serializable(consumersPerTopicMap$1){
            public static final long serialVersionUID;
            private final HashMap consumersPerTopicMap$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Option<List<String>> apply(Tuple2<String, List<String>> tuple2) {
                Tuple2<String, List<String>> tuple22 = tuple2;
                if (tuple22 != null) {
                    return this.consumersPerTopicMap$1.put(tuple22._1(), ((SeqLike)tuple22._2()).sortWith(new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final boolean apply(String s, String t) {
                            return Predef$.MODULE$.augmentString(s).$less(t);
                        }
                    }));
                }
                throw new MatchError(tuple22);
            }
            {
                this.consumersPerTopicMap$1 = hashMap;
            }
        });
        return consumersPerTopicMap$1;
    }

    private ZkUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.ConsumersPath = "/consumers";
        this.BrokerIdsPath = "/brokers/ids";
        this.BrokerTopicsPath = "/brokers/topics";
    }
}

