/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Properties;
import java.util.zip.CRC32;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.message.CompressionCodec;
import kafka.message.CompressionCodec$;
import kafka.message.NoCompressionCodec$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import kafka.utils.ZKStringSerializer$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcII$sp;
import scala.Tuple2$mcJJ$sp;
import scala.collection.GenTraversable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.TraitSetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class Utils$
implements Logging {
    public static final Utils$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    public volatile int bitmap$0;

    static {
        new Utils$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        Utils$ utils$ = this;
        synchronized (utils$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    @TraitSetter
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public Runnable runnable(Function0<BoxedUnit> fun$2) {
        return new Runnable(fun$2){
            private final Function0 fun$2;

            public void run() {
                this.fun$2.apply$mcV$sp();
            }
            {
                this.fun$2 = function0;
            }
        };
    }

    public Runnable loggedRunnable(Function0<BoxedUnit> fun$1) {
        return new Runnable(fun$1){
            private final Function0 fun$1;

            public void run() {
                try {
                    this.fun$1.apply$mcV$sp();
                }
                catch (Throwable throwable) {
                    Utils$.MODULE$.error((Function0<String>)((Object)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return "error in loggedRunnable";
                        }
                    }), (Function0<Throwable>)((Object)new Serializable(this, throwable){
                        public static final long serialVersionUID;
                        private final Throwable t$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final Throwable apply() {
                            return this.t$1;
                        }
                        {
                            this.t$1 = throwable;
                        }
                    }));
                }
            }
            {
                this.fun$1 = function0;
            }
        };
    }

    public Thread daemonThread(String name, Runnable runnable) {
        return this.newThread(name, runnable, true);
    }

    public Thread daemonThread(String name, Function0<BoxedUnit> fun) {
        return this.daemonThread(name, this.runnable(fun));
    }

    public Thread newThread(String name, Runnable runnable, boolean daemon) {
        Thread thread = new Thread(runnable, name);
        thread.setDaemon(daemon);
        return thread;
    }

    public byte[] readBytes(ByteBuffer buffer, int offset, int size2) {
        byte[] bytes = new byte[size2];
        for (int i = 0; i < size2; ++i) {
            bytes[i] = buffer.get(offset + i);
        }
        return bytes;
    }

    public String readShortString(ByteBuffer buffer, String encoding) {
        short size2 = buffer.getShort();
        if (size2 < 0) {
            return null;
        }
        byte[] bytes = new byte[size2];
        buffer.get(bytes);
        return new String(bytes, encoding);
    }

    public void writeShortString(ByteBuffer buffer, String string2, String encoding) {
        if (string2 == null) {
            buffer.putShort((short)-1);
        } else {
            if (string2.length() > Short.MAX_VALUE) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"String exceeds the maximum size of ").append(BoxesRunTime.boxToShort((short)Short.MAX_VALUE)).append((Object)".").toString());
            }
            buffer.putShort((short)string2.length());
            buffer.put(string2.getBytes(encoding));
        }
    }

    /*
     * WARNING - void declaration
     */
    public Properties loadProps(String filename) {
        void var3_3;
        FileInputStream propStream = new FileInputStream(filename);
        Properties props = new Properties();
        props.load(propStream);
        return var3_3;
    }

    public int getInt(Properties props, String name) {
        if (props.containsKey(name)) {
            return this.getInt(props, name, -1);
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Missing required property '").append((Object)name).append((Object)"'").toString());
    }

    public int getInt(Properties props, String name, int n) {
        return this.getIntInRange(props, name, n, new Tuple2$mcII$sp(Integer.MIN_VALUE, Integer.MAX_VALUE));
    }

    public int getIntInRange(Properties props, String name, int n, Tuple2<Object, Object> range2) {
        int v;
        int n2 = v = props.containsKey(name) ? Predef$.MODULE$.augmentString(props.getProperty(name)).toInt() : n;
        if (v < range2._1$mcI$sp() || v > range2._2$mcI$sp()) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)name).append((Object)" has value ").append(BoxesRunTime.boxToInteger(v)).append((Object)" which is not in the range ").append(range2).append((Object)".").toString());
        }
        return v;
    }

    public long getLong(Properties props, String name) {
        if (props.containsKey(name)) {
            return this.getLong(props, name, -1L);
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Missing required property '").append((Object)name).append((Object)"'").toString());
    }

    public long getLong(Properties props, String name, long l) {
        return this.getLongInRange(props, name, l, new Tuple2$mcJJ$sp(Long.MIN_VALUE, Long.MAX_VALUE));
    }

    public long getLongInRange(Properties props, String name, long l, Tuple2<Object, Object> range2) {
        long v;
        long l2 = v = props.containsKey(name) ? Predef$.MODULE$.augmentString(props.getProperty(name)).toLong() : l;
        if (v < range2._1$mcJ$sp() || v > range2._2$mcJ$sp()) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)name).append((Object)" has value ").append(BoxesRunTime.boxToLong(v)).append((Object)" which is not in the range ").append(range2).append((Object)".").toString());
        }
        return v;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getBoolean(Properties props, String name, boolean bl) {
        if (props.containsKey(name)) {
            String string2 = props.getProperty(name);
            if ("true" == null) {
                if (string2 == null) return true;
            } else if ("true".equals(string2)) {
                return true;
            }
            String string3 = props.getProperty(name);
            if ("false" != null) {
                if (!"false".equals(string3)) throw new IllegalArgumentException(new StringBuilder().append((Object)"Unacceptable value for property '").append((Object)name).append((Object)"', boolean values must be either 'true' or 'false").toString());
                return false;
            }
            if (string3 == null) return false;
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Unacceptable value for property '").append((Object)name).append((Object)"', boolean values must be either 'true' or 'false").toString());
        }
        boolean bl2 = bl;
        return bl2;
    }

    public String getString(Properties props, String name, String string2) {
        return props.containsKey(name) ? props.getProperty(name) : string2;
    }

    public String getString(Properties props, String name) {
        if (props.containsKey(name)) {
            return props.getProperty(name);
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Missing required property '").append((Object)name).append((Object)"'").toString());
    }

    public Properties getProps(Properties props, String name) {
        if (props.containsKey(name)) {
            String propString = props.getProperty(name);
            String[] propValues$1 = propString.split(",");
            Properties properties$1 = new Properties();
            Predef$.MODULE$.intWrapper(0).until(propValues$1.length).foreach(new Serializable(propValues$1, properties$1){
                public static final long serialVersionUID;
                private final String[] propValues$1;
                private final Properties properties$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Object apply(int i) {
                    String[] prop = this.propValues$1[i].split("=");
                    if (prop.length != 2) {
                        throw new IllegalArgumentException(new StringBuilder().append((Object)"Illegal format of specifying properties '").append((Object)this.propValues$1[i]).append((Object)"'").toString());
                    }
                    return this.properties$1.put(prop[0], prop[1]);
                }
                {
                    this.propValues$1 = stringArray;
                    this.properties$1 = properties;
                }
            });
            return properties$1;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Missing required property '").append((Object)name).append((Object)"'").toString());
    }

    public Properties getProps(Properties props, String name, Properties properties) {
        Properties properties2;
        if (props.containsKey(name)) {
            String propString = props.getProperty(name);
            String[] propValues$2 = propString.split(",");
            if (propValues$2.length < 1) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Illegal format of specifying properties '").append((Object)propString).append((Object)"'").toString());
            }
            Properties properties$2 = new Properties();
            Predef$.MODULE$.intWrapper(0).until(propValues$2.length).foreach(new Serializable(propValues$2, properties$2){
                public static final long serialVersionUID;
                private final String[] propValues$2;
                private final Properties properties$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Object apply(int i) {
                    String[] prop = this.propValues$2[i].split("=");
                    if (prop.length != 2) {
                        throw new IllegalArgumentException(new StringBuilder().append((Object)"Illegal format of specifying properties '").append((Object)this.propValues$2[i]).append((Object)"'").toString());
                    }
                    return this.properties$2.put(prop[0], prop[1]);
                }
                {
                    this.propValues$2 = stringArray;
                    this.properties$2 = properties;
                }
            });
            properties2 = properties$2;
        } else {
            properties2 = properties;
        }
        return properties2;
    }

    public FileChannel openChannel(File file, boolean mutable) {
        return mutable ? new RandomAccessFile(file, "rw").getChannel() : new FileInputStream(file).getChannel();
    }

    public void swallow(Function2<Object, Throwable, BoxedUnit> log2, Function0<BoxedUnit> action) {
        try {
            action.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            log2.apply(throwable.getMessage(), throwable);
        }
    }

    public boolean equal(ByteBuffer b1$1, ByteBuffer b2$1) {
        Object object = new Object();
        boolean exceptionResult1 = false;
        try {
            if (b1$1.position() != b2$1.position()) {
                return false;
            }
            if (b1$1.remaining() != b2$1.remaining()) {
                return false;
            }
            Predef$.MODULE$.intWrapper(0).until(b1$1.remaining()).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(b1$1, b2$1, object){
                public static final long serialVersionUID;
                private final ByteBuffer b1$1;
                private final ByteBuffer b2$1;
                private final Object nonLocalReturnKey1$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int v1) {
                    if (this.b1$1.get(v1) != this.b2$1.get(v1)) {
                        throw new NonLocalReturnControl<Boolean>(this.nonLocalReturnKey1$1, BoxesRunTime.boxToBoolean(false));
                    }
                }
                {
                    this.b1$1 = byteBuffer;
                    this.b2$1 = byteBuffer2;
                    this.nonLocalReturnKey1$1 = object;
                }
            }));
            return true;
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                exceptionResult1 = BoxesRunTime.unboxToBoolean(nonLocalReturnControl.value());
                return exceptionResult1;
            }
            throw nonLocalReturnControl;
        }
    }

    public String toString(ByteBuffer buffer, String encoding) {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return new String(bytes, encoding);
    }

    public void croak(String message) {
        System.err.println(message);
        System.exit(1);
    }

    public void rm(String file) {
        this.rm(new File(file));
    }

    public void rm(File file) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                Predef$.MODULE$.refArrayOps((Object[])files).foreach(new Serializable(){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(File f2) {
                        Utils$.MODULE$.rm(f2);
                    }
                });
            }
            file.delete();
        } else {
            file.delete();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean registerMBean(Object mbean, String name$1) {
        void var3_3;
        boolean exceptionResult2 = false;
        try {
            Boolean bl;
            MBeanServer mbs;
            MBeanServer mBeanServer = mbs = ManagementFactory.getPlatformMBeanServer();
            synchronized (mBeanServer) {
                ObjectName objName = new ObjectName(name$1);
                if (mbs.isRegistered(objName)) {
                    mbs.unregisterMBean(objName);
                }
                mbs.registerMBean(mbean, objName);
                bl = BoxesRunTime.boxToBoolean(true);
            }
            exceptionResult2 = BoxesRunTime.unboxToBoolean(bl);
            return (boolean)var3_3;
        }
        catch (Exception exception) {
            this.error((Function0<String>)((Object)new Serializable(name$1){
                public static final long serialVersionUID;
                private final String name$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Failed to register Mbean ").append((Object)this.name$1).toString();
                }
                {
                    this.name$1 = string2;
                }
            }), (Function0<Throwable>)((Object)new Serializable(exception){
                public static final long serialVersionUID;
                private final Exception e$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Exception apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = exception;
                }
            }));
            return (boolean)var3_3;
        }
    }

    public void unregisterMBean(String name) {
        MBeanServer mbs;
        MBeanServer mBeanServer = mbs = ManagementFactory.getPlatformMBeanServer();
        synchronized (mBeanServer) {
            BoxedUnit boxedUnit;
            ObjectName objName = new ObjectName(name);
            if (mbs.isRegistered(objName)) {
                mbs.unregisterMBean(objName);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public long getUnsignedInt(ByteBuffer buffer) {
        return (long)buffer.getInt() & 0xFFFFFFFFL;
    }

    public long getUnsignedInt(ByteBuffer buffer, int index2) {
        return (long)buffer.getInt(index2) & 0xFFFFFFFFL;
    }

    public void putUnsignedInt(ByteBuffer buffer, long value2) {
        buffer.putInt((int)(value2 & 0xFFFFFFFFL));
    }

    public void putUnsignedInt(ByteBuffer buffer, int index2, long value2) {
        buffer.putInt(index2, (int)(value2 & 0xFFFFFFFFL));
    }

    public long crc32(byte[] bytes) {
        return this.crc32(bytes, 0, bytes.length);
    }

    public long crc32(byte[] bytes, int offset, int size2) {
        CRC32 crc = new CRC32();
        crc.update(bytes, offset, size2);
        return crc.getValue();
    }

    public int hashcode(Seq<Object> as) {
        if (as == null) {
            return 0;
        }
        int h = 1;
        int i = 0;
        while (i < as.length()) {
            if (as.apply(i) == null) continue;
            h = 31 * h + as.apply(i).hashCode();
            ++i;
        }
        return h;
    }

    /*
     * WARNING - void declaration
     */
    public <K, V> Map<K, List<V>> groupby(Iterable<V> vals, Function1<V, K> f$1) {
        void var3_3;
        HashMap m$1 = new HashMap();
        vals.foreach(new Serializable(f$1, m$1){
            public static final long serialVersionUID;
            private final Function1 f$1;
            private final HashMap m$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Option<List<V>> apply(V v) {
                Option<B> option;
                block5: {
                    Option<GenTraversable<Object>> option2;
                    block4: {
                        R k;
                        block2: {
                            block3: {
                                k = this.f$1.apply(v);
                                option = this.m$1.get(k);
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                List list2 = (List)some.x();
                                if (list2 == null) break block3;
                                V v2 = v;
                                option2 = this.m$1.put(k, list2.$colon$colon(v2));
                                break block4;
                            }
                            throw new MatchError(option);
                        }
                        None$ none$ = None$.MODULE$;
                        Option<B> option3 = option;
                        if (none$ != null ? !none$.equals(option3) : option3 != null) break block5;
                        option2 = this.m$1.put(k, List$.MODULE$.apply(Predef$.MODULE$.genericWrapArray(new Object[]{v})));
                    }
                    return option2;
                }
                throw new MatchError(option);
            }
            {
                this.f$1 = function1;
                this.m$1 = hashMap;
            }
        });
        return var3_3;
    }

    public int read(ReadableByteChannel channel, ByteBuffer buffer) {
        int n = channel.read(buffer);
        if (n == -1) {
            throw new EOFException("Received -1 when reading from channel, socket has likely been closed.");
        }
        if (BoxesRunTime.boxToInteger(n) instanceof Integer) {
            return n;
        }
        throw new MatchError(BoxesRunTime.boxToInteger(n));
    }

    public <V> V notNull(V v) {
        if (v == null) {
            throw new IllegalArgumentException("Value cannot be null.");
        }
        return v;
    }

    public Tuple2<String, Object> getHostPort(String hostport) {
        String[] splits = hostport.split(":");
        return new Tuple2<String, Object>(splits[0], BoxesRunTime.boxToInteger(Predef$.MODULE$.augmentString(splits[1]).toInt()));
    }

    public Tuple2<String, Object> getTopicPartition(String topicPartition) {
        int index2 = topicPartition.lastIndexOf(45);
        return new Tuple2<String, Object>(topicPartition.substring(0, index2), BoxesRunTime.boxToInteger(Predef$.MODULE$.augmentString(topicPartition.substring(index2 + 1)).toInt()));
    }

    public String stackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    private <K, V> Map<K, V> getCSVMap(String allCSVals, String exceptionMsg$1, String successMsg$1) {
        HashMap map$1 = new HashMap();
        if ("".equals(allCSVals)) {
            return map$1;
        }
        String[] csVals$1 = allCSVals.split(",");
        Predef$.MODULE$.intWrapper(0).until(csVals$1.length).foreach(new Serializable(exceptionMsg$1, successMsg$1, map$1, csVals$1){
            public static final long serialVersionUID;
            public final String exceptionMsg$1;
            public final String successMsg$1;
            private final HashMap map$1;
            public final String[] csVals$1;

            static {
                long l = serialVersionUID = 0L;
            }

            /*
             * WARNING - void declaration
             */
            public final Object apply(int i$1) {
                void var2_2;
                Object exceptionResult3 = null;
                try {
                    String[] tempSplit$1 = this.csVals$1[i$1].split(":");
                    Utils$.MODULE$.info((Function0<String>)((Object)new Serializable(this, tempSplit$1){
                        public static final long serialVersionUID;
                        private final anonfun.getCSVMap.1 $outer;
                        private final String[] tempSplit$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return new StringBuilder().append((Object)this.$outer.successMsg$1).append((Object)this.tempSplit$1[0]).append((Object)" : ").append(BoxesRunTime.boxToInteger(Integer.parseInt(this.tempSplit$1[1].trim()))).toString();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.tempSplit$1 = stringArray;
                        }
                    }));
                    exceptionResult3 = this.map$1.$plus$eq(Predef$.MODULE$.any2ArrowAssoc(tempSplit$1[0]).$minus$greater(BoxesRunTime.boxToInteger(Integer.parseInt(tempSplit$1[1].trim()))));
                }
                catch (Throwable throwable) {
                    Utils$.MODULE$.error((Function0<String>)((Object)new Serializable(this, i$1){
                        public static final long serialVersionUID;
                        private final anonfun.getCSVMap.1 $outer;
                        private final int i$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return new StringBuilder().append((Object)this.$outer.exceptionMsg$1).append((Object)": ").append((Object)this.$outer.csVals$1[this.i$1]).toString();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.i$1 = n;
                        }
                    }));
                    exceptionResult3 = BoxedUnit.UNIT;
                }
                return var2_2;
            }
            {
                this.exceptionMsg$1 = string2;
                this.successMsg$1 = string3;
                this.map$1 = hashMap;
                this.csVals$1 = stringArray;
            }
        });
        return map$1;
    }

    public Seq<String> getCSVList(String csvList) {
        return csvList == null ? (WrappedArray<Object>)Seq$.MODULE$.empty() : Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])csvList.split(",")).filter(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String v) {
                return !v.equals("");
            }
        }));
    }

    public Map<String, Object> getTopicRentionHours(String retentionHours) {
        String exceptionMsg = "Malformed token for topic.log.retention.hours in server.properties: ";
        String successMsg = "The retention hour for ";
        return this.getCSVMap(retentionHours, exceptionMsg, successMsg);
    }

    public Map<String, Object> getTopicFlushIntervals(String allIntervals) {
        String exceptionMsg = "Malformed token for topic.flush.Intervals.ms in server.properties: ";
        String successMsg = "The flush interval for ";
        return this.getCSVMap(allIntervals, exceptionMsg, successMsg);
    }

    public Map<String, Object> getTopicPartitions(String allPartitions) {
        String exceptionMsg = "Malformed token for topic.partition.counts in server.properties: ";
        String successMsg = "The number of partitions for topic  ";
        return this.getCSVMap(allPartitions, exceptionMsg, successMsg);
    }

    public Map<String, Object> getConsumerTopicMap(String consumerTopicString) {
        String exceptionMsg = "Malformed token for embeddedconsumer.topics in consumer.properties: ";
        String successMsg = "The number of consumer thread for topic  ";
        return this.getCSVMap(consumerTopicString, exceptionMsg, successMsg);
    }

    public <T> T getObject(String className) {
        T t;
        String string2 = className;
        if (string2 == null) {
            t = null;
        } else {
            Class<?> clazz = Class.forName(className);
            Class<?> clazzT = clazz;
            Constructor<?>[] constructors = clazzT.getConstructors();
            Predef$.MODULE$.require(constructors.length == 1);
            t = ((Constructor)Predef$.MODULE$.refArrayOps((Object[])constructors).head()).newInstance(new Object[0]);
        }
        return t;
    }

    public boolean propertyExists(String prop) {
        return prop == null ? false : prop.compareTo("") != 0;
    }

    public CompressionCodec getCompressionCodec(Properties props, String codec) {
        String codecValueString = props.getProperty(codec);
        return codecValueString == null ? NoCompressionCodec$.MODULE$ : CompressionCodec$.MODULE$.getCompressionCodec(Predef$.MODULE$.augmentString(codecValueString).toInt());
    }

    public void tryCleanupZookeeper(String zkUrl, String groupId) {
        try {
            String dir = new StringBuilder().append((Object)"/consumers/").append((Object)groupId).toString();
            this.logger().info(new StringBuilder().append((Object)"Cleaning up temporary zookeeper data under ").append((Object)dir).append((Object)".").toString());
            ZkClient zk = new ZkClient(zkUrl, 30000, 30000, ZKStringSerializer$.MODULE$);
            zk.deleteRecursive(dir);
            zk.close();
        }
        catch (Throwable throwable) {}
    }

    public void checkRequiredArgs(OptionParser parser$1, OptionSet options$1, Seq<OptionSpec<?>> required) {
        required.foreach(new Serializable(parser$1, options$1){
            public static final long serialVersionUID;
            private final OptionParser parser$1;
            private final OptionSet options$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(OptionSpec<?> arg$1) {
                if (!this.options$1.has(arg$1)) {
                    Utils$.MODULE$.error((Function0<String>)((Object)new Serializable(this, arg$1){
                        public static final long serialVersionUID;
                        private final OptionSpec arg$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return new StringBuilder().append((Object)"Missing required argument \"").append(this.arg$1).append((Object)"\"").toString();
                        }
                        {
                            this.arg$1 = optionSpec;
                        }
                    }));
                    this.parser$1.printHelpOn((OutputStream)System.err);
                    System.exit(1);
                }
            }
            {
                this.parser$1 = optionParser;
                this.options$1 = optionSet;
            }
        });
    }

    public <T> Iterator<T> circularIterator(Iterable<T> coll$1) {
        Stream stream = package$.MODULE$.Stream().continually(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 1;
            }
        }).flatMap(new Serializable(coll$1){
            public static final long serialVersionUID;
            private final Iterable coll$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Iterable<T> apply(int forever) {
                return this.coll$1.map(new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final T apply(T t) {
                        return t;
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
            {
                this.coll$1 = iterable;
            }
        }, Stream$.MODULE$.canBuildFrom());
        return stream.iterator();
    }

    private Utils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

