/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import kafka.api.OffsetRequest$;
import kafka.cluster.Broker;
import kafka.cluster.Cluster;
import kafka.cluster.Partition;
import kafka.cluster.Partition$;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.SimpleConsumer;
import kafka.utils.Utils$;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class UpdateOffsetsInZK$
implements ScalaObject {
    public static final UpdateOffsetsInZK$ MODULE$;
    private final String Earliest;
    private final String Latest;

    static {
        new UpdateOffsetsInZK$();
    }

    public String Earliest() {
        return this.Earliest;
    }

    public String Latest() {
        return this.Latest;
    }

    public void main(String[] args) {
        if (args.length < 3) {
            this.usage();
        }
        ConsumerConfig config = new ConsumerConfig(Utils$.MODULE$.loadProps(args[1]));
        ZkClient zkClient = new ZkClient(config.zkConnect(), config.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), ZKStringSerializer$.MODULE$);
        String string2 = args[0];
        String string3 = this.Earliest();
        String string4 = string2;
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            this.getAndSetOffsets(zkClient, OffsetRequest$.MODULE$.EarliestTime(), config, args[2]);
        } else {
            String string5 = this.Latest();
            String string6 = string2;
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                this.getAndSetOffsets(zkClient, OffsetRequest$.MODULE$.LatestTime(), config, args[2]);
            } else {
                this.usage();
            }
        }
    }

    private void getAndSetOffsets(ZkClient zkClient$1, long offsetOption$1, ConsumerConfig config$1, String topic$1) {
        Cluster cluster$1 = ZkUtils$.MODULE$.getCluster(zkClient$1);
        Map<String, List<String>> partitionsPerTopicMap = ZkUtils$.MODULE$.getPartitionsForTopics(zkClient$1, List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic$1})).iterator());
        List partitions = Nil$.MODULE$;
        Option option = partitionsPerTopicMap.get(topic$1);
        if (option instanceof Some) {
            partitions = (List)((SeqLike)((Some)option).x()).sortWith(new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(String s, String t) {
                    return Predef$.MODULE$.augmentString(s).$less(t);
                }
            });
            IntRef numParts$1 = new IntRef(0);
            partitions.foreach(new Serializable(zkClient$1, offsetOption$1, config$1, topic$1, cluster$1, numParts$1){
                public static final long serialVersionUID;
                private final ZkClient zkClient$1;
                private final long offsetOption$1;
                private final ConsumerConfig config$1;
                private final String topic$1;
                private final Cluster cluster$1;
                private final IntRef numParts$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(String partString) {
                    Partition part = Partition$.MODULE$.parse(partString);
                    Option<Broker> option = this.cluster$1.getBroker(part.brokerId());
                    if (option instanceof Some) {
                        Broker broker = (Broker)((Some)option).x();
                        SimpleConsumer consumer = new SimpleConsumer(broker.host(), broker.port(), 10000, 102400);
                        long[] offsets = consumer.getOffsetsBefore(this.topic$1, part.partId(), this.offsetOption$1, 1);
                        ZKGroupTopicDirs topicDirs = new ZKGroupTopicDirs(this.config$1.groupId(), this.topic$1);
                        Predef$.MODULE$.println(new StringBuilder().append((Object)"updating partition ").append((Object)part.name()).append((Object)" with new offset: ").append(BoxesRunTime.boxToLong(offsets[0])).toString());
                        ZkUtils$.MODULE$.updatePersistentPath(this.zkClient$1, new StringBuilder().append((Object)topicDirs.consumerOffsetDir()).append((Object)"/").append((Object)part.name()).toString(), ((Object)BoxesRunTime.boxToLong(offsets[0])).toString());
                        ++this.numParts$1.elem;
                        return;
                    }
                    None$ none$ = None$.MODULE$;
                    Option<Broker> option2 = option;
                    if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                        throw new IllegalStateException(new StringBuilder().append((Object)"Broker ").append(BoxesRunTime.boxToInteger(part.brokerId())).append((Object)" is unavailable. Cannot issue ").append((Object)"getOffsetsBefore request").toString());
                    }
                    throw new MatchError(option);
                }
                {
                    this.zkClient$1 = zkClient;
                    this.offsetOption$1 = l;
                    this.config$1 = consumerConfig;
                    this.topic$1 = string2;
                    this.cluster$1 = cluster;
                    this.numParts$1 = intRef;
                }
            });
            Predef$.MODULE$.println(new StringBuilder().append((Object)"updated the offset for ").append(BoxesRunTime.boxToInteger(numParts$1.elem)).append((Object)" partitions").toString());
            return;
        }
        throw new RuntimeException(new StringBuilder().append((Object)"Can't find topic ").append((Object)topic$1).toString());
    }

    private void usage() {
        Predef$.MODULE$.println(new StringBuilder().append((Object)"USAGE: ").append((Object)this.getClass().getName()).append((Object)" [earliest | latest] consumer.properties topic").toString());
        System.exit(1);
    }

    private UpdateOffsetsInZK$() {
        MODULE$ = this;
        this.Earliest = "earliest";
        this.Latest = "latest";
    }
}

