/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kafka.utils.SnapshotStats$;
import kafka.utils.SystemTime$;
import kafka.utils.Time;
import scala.ScalaObject;
import scala.math.package$;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u00055e\u0001B\u0001\u0003\u0001\u001d\u0011Qb\u00158baNDw\u000e^*uCR\u001c(BA\u0002\u0005\u0003\u0015)H/\u001b7t\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!\u0001\u0002CA\u0005\u000f\u001b\u0005Q!BA\u0006\r\u0003\u0011a\u0017M\\4\u000b\u00035\tAA[1wC&\u0011qB\u0003\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t/\u0001\u0011)\u0019!C\u00051\u0005\tRn\u001c8ji>\u0014H)\u001e:bi&|gNT:\u0016\u0003e\u0001\"!\u0005\u000e\n\u0005m\u0011\"\u0001\u0002'p]\u001eD\u0001\"\b\u0001\u0003\u0002\u0003\u0006I!G\u0001\u0013[>t\u0017\u000e^8s\tV\u0014\u0018\r^5p]:\u001b\b\u0005C\u0003 \u0001\u0011\u0005\u0001%\u0001\u0004=S:LGO\u0010\u000b\u0003C\r\u0002\"A\t\u0001\u000e\u0003\tAqa\u0006\u0010\u0011\u0002\u0003\u0007\u0011\u0004C\u0004&\u0001\t\u0007I\u0011\u0002\u0014\u0002\tQLW.Z\u000b\u0002OA\u0011!\u0005K\u0005\u0003S\t\u0011A\u0001V5nK\"11\u0006\u0001Q\u0001\n\u001d\nQ\u0001^5nK\u0002Bq!\f\u0001C\u0002\u0013%a&\u0001\u0005d_6\u0004H.\u001a;f+\u0005y\u0003c\u0001\u00198s5\t\u0011G\u0003\u00023g\u00051\u0011\r^8nS\u000eT!\u0001N\u001b\u0002\u0015\r|gnY;se\u0016tGO\u0003\u00027\u0019\u0005!Q\u000f^5m\u0013\tA\u0014GA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f!\tQ4(D\u0001\u0001\r\u0011a\u0004\u0001A\u001f\u0003\u000bM#\u0018\r^:\u0014\u0007mB\u0001\u0003C\u0003 w\u0011\u0005q\bF\u0001:\u0011\u001d\t5H1A\u0005\u0002a\tQa\u001d;beRDaaQ\u001e!\u0002\u0013I\u0012AB:uCJ$\b\u0005C\u0004Fw\u0001\u0007I\u0011\u0001$\u0002\u0007\u0015tG-F\u0001H!\t\u0001\u0004*\u0003\u0002Jc\tQ\u0011\t^8nS\u000eduN\\4\t\u000f-[\u0004\u0019!C\u0001\u0019\u00069QM\u001c3`I\u0015\fHCA'Q!\t\tb*\u0003\u0002P%\t!QK\\5u\u0011\u001d\t&*!AA\u0002\u001d\u000b1\u0001\u001f\u00132\u0011\u0019\u00196\b)Q\u0005\u000f\u0006!QM\u001c3!\u0011\u001d)6\b1A\u0005\u0002Y\u000b1B\\;n%\u0016\fX/Z:ugV\tq\u000b\u0005\u0002\u00121&\u0011\u0011L\u0005\u0002\u0004\u0013:$\bbB.<\u0001\u0004%\t\u0001X\u0001\u0010]Vl'+Z9vKN$8o\u0018\u0013fcR\u0011Q*\u0018\u0005\b#j\u000b\t\u00111\u0001X\u0011\u0019y6\b)Q\u0005/\u0006aa.^7SKF,Xm\u001d;tA!9\u0011m\u000fa\u0001\n\u0003A\u0012A\u0005;pi\u0006d'+Z9vKN$X*\u001a;sS\u000eDqaY\u001eA\u0002\u0013\u0005A-\u0001\fu_R\fGNU3rk\u0016\u001cH/T3ue&\u001cw\fJ3r)\tiU\rC\u0004RE\u0006\u0005\t\u0019A\r\t\r\u001d\\\u0004\u0015)\u0003\u001a\u0003M!x\u000e^1m%\u0016\fX/Z:u\u001b\u0016$(/[2!\u0011\u001dI7\b1A\u0005\u0002a\t\u0001#\\1y%\u0016\fX/Z:u\u001b\u0016$(/[2\t\u000f-\\\u0004\u0019!C\u0001Y\u0006!R.\u0019=SKF,Xm\u001d;NKR\u0014\u0018nY0%KF$\"!T7\t\u000fES\u0017\u0011!a\u00013!1qn\u000fQ!\ne\t\u0011#\\1y%\u0016\fX/Z:u\u001b\u0016$(/[2!\u0011\u001d\t8\b1A\u0005\u0002a\t\u0011\u0002^8uC2$\u0015\r^1\t\u000fM\\\u0004\u0019!C\u0001i\u0006iAo\u001c;bY\u0012\u000bG/Y0%KF$\"!T;\t\u000fE\u0013\u0018\u0011!a\u00013!1qo\u000fQ!\ne\t!\u0002^8uC2$\u0015\r^1!\u0011\u001dI8H1A\u0005\ni\fA\u0001\\8dWV\t\u0001\u0002\u0003\u0004}w\u0001\u0006I\u0001C\u0001\u0006Y>\u001c7\u000e\t\u0005\u0006}n\"\ta`\u0001\bC\u0012$G)\u0019;b)\ri\u0015\u0011\u0001\u0005\u0007\u0003\u0007i\b\u0019A\r\u0002\t\u0011\fG/\u0019\u0005\b\u0003\u000fYD\u0011AA\u0005\u0003\r\tG\r\u001a\u000b\u0004\u001b\u0006-\u0001bBA\u0007\u0003\u000b\u0001\r!G\u0001\ne\u0016\fX/Z:u\u001dNDq!!\u0005<\t\u0003\t\u0019\"A\bekJ\fG/[8o'\u0016\u001cwN\u001c3t+\t\t)\u0002E\u0002\u0012\u0003/I1!!\u0007\u0013\u0005\u0019!u.\u001e2mK\"9\u0011QD\u001e\u0005\u0002\u0005M\u0011A\u00033ve\u0006$\u0018n\u001c8Ng\"9\u0011\u0011\u0005\u0001!\u0002\u0013y\u0013!C2p[BdW\r^3!\u0011!\t)\u0003\u0001b\u0001\n\u0013q\u0013aB2veJ,g\u000e\u001e\u0005\b\u0003S\u0001\u0001\u0015!\u00030\u0003!\u0019WO\u001d:f]R\u0004\u0003\u0002CA\u0017\u0001\t\u0007I\u0011\u0002$\u0002\u000bQ|G/\u00197\t\u000f\u0005E\u0002\u0001)A\u0005\u000f\u00061Ao\u001c;bY\u0002B\u0001\"!\u000e\u0001\u0005\u0004%IAR\u0001\u0015]Vl7)^7vY\u0006$X\r\u001a*fcV,7\u000f^:\t\u000f\u0005e\u0002\u0001)A\u0005\u000f\u0006)b.^7Dk6,H.\u0019;fIJ+\u0017/^3tiN\u0004\u0003bBA\u001f\u0001\u0011\u0005\u0011qH\u0001\u0014e\u0016\u001cwN\u001d3SKF,Xm\u001d;NKR\u0014\u0018n\u0019\u000b\u0004\u001b\u0006\u0005\u0003bBA\u0007\u0003w\u0001\r!\u0007\u0005\b\u0003\u000b\u0002A\u0011AA$\u0003Y\u0011XmY8sIRC'o\\;hQB,H/T3ue&\u001cGcA'\u0002J!9\u00111AA\"\u0001\u0004I\u0002bBA'\u0001\u0011\u0005\u0011qJ\u0001\u000fO\u0016$h*^7SKF,Xm\u001d;t)\u0005I\u0002bBA*\u0001\u0011\u0005\u00111C\u0001\u0015O\u0016$(+Z9vKN$8\u000fU3s'\u0016\u001cwN\u001c3\t\u000f\u0005]\u0003\u0001\"\u0001\u0002\u0014\u0005iq-\u001a;UQJ|Wo\u001a5qkRDq!a\u0017\u0001\t\u0003\t\u0019\"\u0001\u0007hKR\feoZ'fiJL7\r\u0003\u0004\u0002`\u0001!\t\u0001G\u0001\u000fO\u0016$Hk\u001c;bY6+GO]5d\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003'\tAbZ3u\u001b\u0006DX*\u001a;sS\u000e<\u0011\"a\u001a\u0003\u0003\u0003E)!!\u001b\u0002\u001bMs\u0017\r]:i_R\u001cF/\u0019;t!\r\u0011\u00131\u000e\u0004\t\u0003\t\t\t\u0011#\u0002\u0002nM!\u00111\u000e\u0005\u0011\u0011\u001dy\u00121\u000eC\u0001\u0003c\"\"!!\u001b\t\u0015\u0005U\u00141NI\u0001\n\u0003\t9(\u0001\bj]&$H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005e$fA\r\u0002|-\u0012\u0011Q\u0010\t\u0005\u0003\u007f\nI)\u0004\u0002\u0002\u0002*!\u00111QAC\u0003%)hn\u00195fG.,GMC\u0002\u0002\bJ\t!\"\u00198o_R\fG/[8o\u0013\u0011\tY)!!\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class SnapshotStats
implements ScalaObject {
    private final long monitorDurationNs;
    private final Time kafka$utils$SnapshotStats$$time;
    private final AtomicReference<Stats> complete;
    private final AtomicReference<Stats> current;
    private final AtomicLong total;
    private final AtomicLong numCumulatedRequests;

    public static final long init$default$1() {
        return SnapshotStats$.MODULE$.init$default$1();
    }

    private long monitorDurationNs() {
        return this.monitorDurationNs;
    }

    public final Time kafka$utils$SnapshotStats$$time() {
        return this.kafka$utils$SnapshotStats$$time;
    }

    private AtomicReference<Stats> complete() {
        return this.complete;
    }

    private AtomicReference<Stats> current() {
        return this.current;
    }

    private AtomicLong total() {
        return this.total;
    }

    private AtomicLong numCumulatedRequests() {
        return this.numCumulatedRequests;
    }

    public void recordRequestMetric(long requestNs) {
        boolean swapped;
        Stats stats = this.current().get();
        stats.add(requestNs);
        this.total().getAndAdd(requestNs);
        this.numCumulatedRequests().getAndAdd(1L);
        long ageNs = this.kafka$utils$SnapshotStats$$time().nanoseconds() - stats.start();
        if (ageNs >= this.monitorDurationNs() && (swapped = this.current().compareAndSet(stats, new Stats(this)))) {
            this.complete().set(stats);
            stats.end().set(this.kafka$utils$SnapshotStats$$time().nanoseconds());
        }
    }

    public void recordThroughputMetric(long data2) {
        boolean swapped;
        Stats stats = this.current().get();
        stats.addData(data2);
        long ageNs = this.kafka$utils$SnapshotStats$$time().nanoseconds() - stats.start();
        if (ageNs >= this.monitorDurationNs() && (swapped = this.current().compareAndSet(stats, new Stats(this)))) {
            this.complete().set(stats);
            stats.end().set(this.kafka$utils$SnapshotStats$$time().nanoseconds());
        }
    }

    public long getNumRequests() {
        return this.numCumulatedRequests().get();
    }

    public double getRequestsPerSecond() {
        Stats stats = this.complete().get();
        return (double)stats.numRequests() / stats.durationSeconds();
    }

    public double getThroughput() {
        Stats stats = this.complete().get();
        return (double)stats.totalData() / stats.durationSeconds();
    }

    public double getAvgMetric() {
        Stats stats = this.complete().get();
        return stats.numRequests() == 0 ? 0.0 : (double)(stats.totalRequestMetric() / (long)stats.numRequests());
    }

    public long getTotalMetric() {
        return this.total().get();
    }

    public double getMaxMetric() {
        return this.complete().get().maxRequestMetric();
    }

    public SnapshotStats(long monitorDurationNs) {
        this.monitorDurationNs = monitorDurationNs;
        this.kafka$utils$SnapshotStats$$time = SystemTime$.MODULE$;
        this.complete = new AtomicReference<Stats>(new Stats(this));
        this.current = new AtomicReference<Stats>(new Stats(this));
        this.total = new AtomicLong(0L);
        this.numCumulatedRequests = new AtomicLong(0L);
    }

    public class Stats
    implements ScalaObject {
        private final long start;
        private AtomicLong end;
        private int numRequests;
        private long totalRequestMetric;
        private long maxRequestMetric;
        private long totalData;
        private final Object lock;
        public final SnapshotStats $outer;

        public long start() {
            return this.start;
        }

        public AtomicLong end() {
            return this.end;
        }

        public void end_$eq(AtomicLong atomicLong) {
            this.end = atomicLong;
        }

        public int numRequests() {
            return this.numRequests;
        }

        public void numRequests_$eq(int n) {
            this.numRequests = n;
        }

        public long totalRequestMetric() {
            return this.totalRequestMetric;
        }

        public void totalRequestMetric_$eq(long l) {
            this.totalRequestMetric = l;
        }

        public long maxRequestMetric() {
            return this.maxRequestMetric;
        }

        public void maxRequestMetric_$eq(long l) {
            this.maxRequestMetric = l;
        }

        public long totalData() {
            return this.totalData;
        }

        public void totalData_$eq(long l) {
            this.totalData = l;
        }

        private Object lock() {
            return this.lock;
        }

        public void addData(long data2) {
            Object object = this.lock();
            synchronized (object) {
                this.totalData_$eq(this.totalData() + data2);
                return;
            }
        }

        public void add(long requestNs) {
            Object object = this.lock();
            synchronized (object) {
                this.numRequests_$eq(this.numRequests() + 1);
                this.totalRequestMetric_$eq(this.totalRequestMetric() + requestNs);
                this.maxRequestMetric_$eq(package$.MODULE$.max(this.maxRequestMetric(), requestNs));
                return;
            }
        }

        public double durationSeconds() {
            return (double)(this.end().get() - this.start()) / 1.0E9;
        }

        public double durationMs() {
            return (double)(this.end().get() - this.start()) / 1000000.0;
        }

        public SnapshotStats kafka$utils$SnapshotStats$Stats$$$outer() {
            return this.$outer;
        }

        public Stats(SnapshotStats $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.start = $outer.kafka$utils$SnapshotStats$$time().nanoseconds();
            this.end = new AtomicLong(-1L);
            this.numRequests = 0;
            this.totalRequestMetric = 0L;
            this.maxRequestMetric = 0L;
            this.totalData = 0L;
            this.lock = new Object();
        }
    }
}

