/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import scala.ScalaObject;
import scala.math.package$;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001i3A!\u0001\u0002\u0001\u000f\tYA)\u001a7bs\u0016$\u0017\n^3n\u0015\t\u0019A!A\u0003vi&d7OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001)\"\u0001\u0003\u0013\u0014\t\u0001I\u0011#\u0007\t\u0003\u0015=i\u0011a\u0003\u0006\u0003\u00195\tA\u0001\\1oO*\ta\"\u0001\u0003kCZ\f\u0017B\u0001\t\f\u0005\u0019y%M[3diB\u0011!cF\u0007\u0002')\u0011A#F\u0001\u000bG>t7-\u001e:sK:$(B\u0001\f\u000e\u0003\u0011)H/\u001b7\n\u0005a\u0019\"a\u0002#fY\u0006LX\r\u001a\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0003\u0005!\u0001\t\u0015\r\u0011\"\u0001\"\u0003\u0011IG/Z7\u0016\u0003\t\u0002\"a\t\u0013\r\u0001\u0011)Q\u0005\u0001b\u0001M\t\tA+\u0005\u0002(UA\u0011!\u0004K\u0005\u0003Sm\u0011qAT8uQ&tw\r\u0005\u0002\u001bW%\u0011Af\u0007\u0002\u0004\u0003:L\b\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\u0002\u000b%$X-\u001c\u0011\t\u0011A\u0002!\u0011!Q\u0001\nE\nQ\u0001Z3mCf\u0004\"A\u0007\u001a\n\u0005MZ\"\u0001\u0002'p]\u001eD\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IAN\u0001\u0005k:LG\u000f\u0005\u0002\u0013o%\u0011\u0001h\u0005\u0002\t)&lW-\u00168ji\")!\b\u0001C\u0001w\u00051A(\u001b8jiz\"B\u0001\u0010 @\u0001B\u0019Q\b\u0001\u0012\u000e\u0003\tAQ\u0001I\u001dA\u0002\tBQ\u0001M\u001dA\u0002EBQ!N\u001dA\u0002YBqA\u0011\u0001C\u0002\u0013\u00051)A\u0004eK2\f\u00170T:\u0016\u0003EBa!\u0012\u0001!\u0002\u0013\t\u0014\u0001\u00033fY\u0006LXj\u001d\u0011\t\u000f\u001d\u0003!\u0019!C\u0001\u0007\u0006I1M]3bi\u0016$Wj\u001d\u0005\u0007\u0013\u0002\u0001\u000b\u0011B\u0019\u0002\u0015\r\u0014X-\u0019;fI6\u001b\b\u0005C\u0003;\u0001\u0011\u00051\nF\u0002=\u00196CQ\u0001\t&A\u0002\tBQA\u0011&A\u0002EBQa\u0014\u0001\u0005\u0002A\u000b\u0001bZ3u\t\u0016d\u0017-\u001f\u000b\u0003cECQ!\u000e(A\u0002YBQa\u0015\u0001\u0005\u0002Q\u000b\u0011bY8na\u0006\u0014X\rV8\u0015\u0005UC\u0006C\u0001\u000eW\u0013\t96DA\u0002J]RDQ!\u0017*A\u0002E\t\u0011\u0001\u001a")
public class DelayedItem<T>
implements Delayed,
ScalaObject {
    private final T item;
    private final long delayMs;
    private final long createdMs;

    public T item() {
        return this.item;
    }

    public long delayMs() {
        return this.delayMs;
    }

    public long createdMs() {
        return this.createdMs;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        long ellapsedMs = System.currentTimeMillis() - this.createdMs();
        return unit.convert(package$.MODULE$.max(this.delayMs() - ellapsedMs, 0L), unit);
    }

    @Override
    public int compareTo(Delayed d) {
        long yourEnd;
        DelayedItem delayed = (DelayedItem)d;
        long myEnd = this.createdMs() + this.delayMs();
        return myEnd < (yourEnd = delayed.createdMs() - delayed.delayMs()) ? -1 : (myEnd > yourEnd ? 1 : 0);
    }

    public DelayedItem(T item, long delay2, TimeUnit unit) {
        this.item = item;
        this.delayMs = unit.toMillis(delay2);
        this.createdMs = System.currentTimeMillis();
    }

    public DelayedItem(T item, long delayMs) {
        this(item, delayMs, TimeUnit.MILLISECONDS);
    }
}

