/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.OutputStream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.tools.VerifyConsumerRebalance$;
import kafka.tools.VerifyConsumerRebalance$$anonfun$validateRebalancingOperation$2$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class VerifyConsumerRebalance$
implements Logging {
    public static final VerifyConsumerRebalance$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    public volatile int bitmap$0;

    static {
        new VerifyConsumerRebalance$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        VerifyConsumerRebalance$ verifyConsumerRebalance$ = this;
        synchronized (verifyConsumerRebalance$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public void main(String[] args) {
        OptionParser parser$1 = new OptionParser();
        ArgumentAcceptingOptionSpec zkConnectOpt = parser$1.accepts("zk.connect", "ZooKeeper connect string.").withRequiredArg().defaultsTo((Object)"localhost:2181", (Object[])new String[0]).ofType(String.class);
        ArgumentAcceptingOptionSpec groupOpt = parser$1.accepts("group", "Consumer group.").withRequiredArg().ofType(String.class);
        parser$1.accepts("help", "Print this message.");
        OptionSet options$1 = parser$1.parse(args);
        if (options$1.has("help")) {
            parser$1.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{groupOpt})).foreach(new Serializable(parser$1, options$1){
            public static final long serialVersionUID;
            private final OptionParser parser$1;
            private final OptionSet options$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(ArgumentAcceptingOptionSpec<String> opt2) {
                if (!this.options$1.has(opt2)) {
                    System.err.println(Predef$.MODULE$.augmentString("Missing required argument: %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{opt2})));
                    this.parser$1.printHelpOn((OutputStream)System.err);
                    System.exit(1);
                }
            }
            {
                this.parser$1 = optionParser;
                this.options$1 = optionSet;
            }
        });
        String zkConnect$1 = (String)options$1.valueOf((OptionSpec)zkConnectOpt);
        String group$1 = (String)options$1.valueOf((OptionSpec)groupOpt);
        ZkClient zkClient = null;
        try {
            zkClient = new ZkClient(zkConnect$1, 30000, 30000, ZKStringSerializer$.MODULE$);
            this.debug((Function0<String>)((Object)new Serializable(zkConnect$1, group$1){
                public static final long serialVersionUID;
                private final String zkConnect$1;
                private final String group$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("zkConnect = %s; group = %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.zkConnect$1, this.group$1}));
                }
                {
                    this.zkConnect$1 = string2;
                    this.group$1 = string3;
                }
            }));
            try {
                if (this.validateRebalancingOperation(zkClient, group$1)) {
                    Predef$.MODULE$.println("Rebalance operation successful !");
                }
                Predef$.MODULE$.println("Rebalance operation failed !");
            }
            catch (Throwable throwable) {
                this.error((Function0<String>)((Object)new Serializable(){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return "Error while verifying current rebalancing operation";
                    }
                }), (Function0<Throwable>)((Object)new Serializable(throwable){
                    public static final long serialVersionUID;
                    private final Throwable e2$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Throwable apply() {
                        return this.e2$1;
                    }
                    {
                        this.e2$1 = throwable;
                    }
                }));
            }
            return;
        }
        finally {
            if (zkClient != null) {
                zkClient.close();
            }
        }
    }

    private boolean validateRebalancingOperation(ZkClient zkClient$1, String group$2) {
        this.info((Function0<String>)((Object)new Serializable(group$2){
            public static final long serialVersionUID;
            private final String group$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Verifying rebalancing operation for consumer group ").append((Object)this.group$2).toString();
            }
            {
                this.group$2 = string2;
            }
        }));
        BooleanRef rebalanceSucceeded$1 = new BooleanRef(true);
        Map<String, List<String>> consumersPerTopicMap$1 = ZkUtils$.MODULE$.getConsumersPerTopic(zkClient$1, group$2);
        Map<String, List<String>> partitionsPerTopicMap = ZkUtils$.MODULE$.getPartitionsForTopics(zkClient$1, consumersPerTopicMap$1.keys().iterator());
        partitionsPerTopicMap.foreach(new Serializable(zkClient$1, group$2, rebalanceSucceeded$1, consumersPerTopicMap$1){
            public static final long serialVersionUID;
            public final ZkClient zkClient$1;
            public final String group$2;
            public final BooleanRef rebalanceSucceeded$1;
            public final Map consumersPerTopicMap$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<String, List<String>> partitionsForTopic) {
                String topic$1 = partitionsForTopic._1();
                List<String> partitions$1 = partitionsForTopic._2();
                ZKGroupTopicDirs topicDirs$1 = new ZKGroupTopicDirs(this.group$2, topic$1);
                VerifyConsumerRebalance$.MODULE$.info((Function0<String>)((Object)new Serializable(this, topic$1, partitions$1){
                    public static final long serialVersionUID;
                    private final String topic$1;
                    private final List partitions$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Alive partitions for topic %s are %s ").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$1, this.partitions$1.toString()}));
                    }
                    {
                        this.topic$1 = string2;
                        this.partitions$1 = list2;
                    }
                }));
                VerifyConsumerRebalance$.MODULE$.info((Function0<String>)((Object)new Serializable(this, topic$1){
                    public static final long serialVersionUID;
                    private final anonfun.validateRebalancingOperation.2 $outer;
                    private final String topic$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Alive consumers for topic %s => %s ").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$1, this.$outer.consumersPerTopicMap$1.get(this.topic$1)}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.topic$1 = string2;
                    }
                }));
                Seq<String> partitionsWithOwners$1 = ZkUtils$.MODULE$.getChildrenParentMayNotExist(this.zkClient$1, topicDirs$1.consumerOwnerDir());
                if (partitionsWithOwners$1.size() == 0) {
                    VerifyConsumerRebalance$.MODULE$.error((Function0<String>)((Object)new Serializable(this, topic$1){
                        public static final long serialVersionUID;
                        private final String topic$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return new StringBuilder().append((Object)"No owners for any partitions for topic ").append((Object)this.topic$1).toString();
                        }
                        {
                            this.topic$1 = string2;
                        }
                    }));
                    this.rebalanceSucceeded$1.elem = false;
                }
                VerifyConsumerRebalance$.MODULE$.debug((Function0<String>)((Object)new Serializable(this, topicDirs$1, partitionsWithOwners$1){
                    public static final long serialVersionUID;
                    private final ZKGroupTopicDirs topicDirs$1;
                    private final Seq partitionsWithOwners$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Children of ").append((Object)this.topicDirs$1.consumerOwnerDir()).append((Object)" = ").append((Object)this.partitionsWithOwners$1.toString()).toString();
                    }
                    {
                        this.topicDirs$1 = zKGroupTopicDirs;
                        this.partitionsWithOwners$1 = seq2;
                    }
                }));
                Option<B> consumerIdsForTopic$1 = this.consumersPerTopicMap$1.get(topic$1);
                partitions$1.foreach(new Serializable(this, topic$1, topicDirs$1, partitionsWithOwners$1, consumerIdsForTopic$1){
                    public static final long serialVersionUID;
                    private final anonfun.validateRebalancingOperation.2 $outer;
                    public final String topic$1;
                    private final ZKGroupTopicDirs topicDirs$1;
                    private final Seq partitionsWithOwners$1;
                    private final Option consumerIdsForTopic$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(String partition$1) {
                        Option option;
                        block9: {
                            block7: {
                                block8: {
                                    String partitionOwner$1;
                                    block6: {
                                        String partitionOwnerPath;
                                        if (!this.partitionsWithOwners$1.exists(new Serializable(this, partition$1){
                                            public static final long serialVersionUID;
                                            private final String partition$1;

                                            static {
                                                long l = serialVersionUID = 0L;
                                            }

                                            public final boolean apply(String p) {
                                                return p.equals(this.partition$1);
                                            }
                                            {
                                                this.partition$1 = string2;
                                            }
                                        })) {
                                            VerifyConsumerRebalance$.MODULE$.error((Function0<String>)((Object)new Serializable(this, partition$1){
                                                public static final long serialVersionUID;
                                                private final anonfun$validateRebalancingOperation$2$$anonfun$apply$5 $outer;
                                                private final String partition$1;

                                                static {
                                                    long l = serialVersionUID = 0L;
                                                }

                                                public final String apply() {
                                                    return Predef$.MODULE$.augmentString("No owner for topic %s partition %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.topic$1, this.partition$1}));
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw new NullPointerException();
                                                    }
                                                    this.$outer = $outer;
                                                    this.partition$1 = string2;
                                                }
                                            }));
                                            this.$outer.rebalanceSucceeded$1.elem = false;
                                        }
                                        if ((partitionOwner$1 = ZkUtils$.MODULE$.readDataMaybeNull(this.$outer.zkClient$1, partitionOwnerPath = new StringBuilder().append((Object)this.topicDirs$1.consumerOwnerDir()).append((Object)"/").append((Object)partition$1).toString())) != null) break block6;
                                        VerifyConsumerRebalance$.MODULE$.error((Function0<String>)((Object)new Serializable(this, partition$1){
                                            public static final long serialVersionUID;
                                            private final anonfun$validateRebalancingOperation$2$$anonfun$apply$5 $outer;
                                            private final String partition$1;

                                            static {
                                                long l = serialVersionUID = 0L;
                                            }

                                            public final String apply() {
                                                return Predef$.MODULE$.augmentString("No owner for topic %s partition %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.topic$1, this.partition$1}));
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw new NullPointerException();
                                                }
                                                this.$outer = $outer;
                                                this.partition$1 = string2;
                                            }
                                        }));
                                        this.$outer.rebalanceSucceeded$1.elem = false;
                                        break block7;
                                    }
                                    option = this.consumerIdsForTopic$1;
                                    if (!(option instanceof Some)) break block8;
                                    if (((SeqLike)((Some)option).x()).contains(partitionOwner$1)) {
                                        VerifyConsumerRebalance$.MODULE$.info((Function0<String>)((Object)new Serializable(this, partition$1, partitionOwner$1){
                                            public static final long serialVersionUID;
                                            private final anonfun$validateRebalancingOperation$2$$anonfun$apply$5 $outer;
                                            private final String partition$1;
                                            private final String partitionOwner$1;

                                            static {
                                                long l = serialVersionUID = 0L;
                                            }

                                            public final String apply() {
                                                return Predef$.MODULE$.augmentString("Owner of topic %s partition %s is %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.topic$1, this.partition$1, this.partitionOwner$1}));
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw new NullPointerException();
                                                }
                                                this.$outer = $outer;
                                                this.partition$1 = string2;
                                                this.partitionOwner$1 = string3;
                                            }
                                        }));
                                    } else {
                                        VerifyConsumerRebalance$.MODULE$.error((Function0<String>)((Object)new Serializable(this, partition$1, partitionOwner$1){
                                            public static final long serialVersionUID;
                                            private final anonfun$validateRebalancingOperation$2$$anonfun$apply$5 $outer;
                                            private final String partition$1;
                                            private final String partitionOwner$1;

                                            static {
                                                long l = serialVersionUID = 0L;
                                            }

                                            public final String apply() {
                                                return new StringBuilder().append((Object)"Owner %s for topic %s partition %s is not a valid member of consumer ").append((Object)Predef$.MODULE$.augmentString("group %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.partitionOwner$1, this.$outer.topic$1, this.partition$1, this.$outer.kafka$tools$VerifyConsumerRebalance$$anonfun$$anonfun$$$outer().group$2}))).toString();
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw new NullPointerException();
                                                }
                                                this.$outer = $outer;
                                                this.partition$1 = string2;
                                                this.partitionOwner$1 = string3;
                                            }
                                        }));
                                        this.$outer.rebalanceSucceeded$1.elem = false;
                                    }
                                    break block7;
                                }
                                None$ none$ = None$.MODULE$;
                                Option option2 = option;
                                if (none$ != null ? !none$.equals(option2) : option2 != null) break block9;
                                VerifyConsumerRebalance$.MODULE$.error((Function0<String>)((Object)new Serializable(this){
                                    public static final long serialVersionUID;
                                    private final anonfun$validateRebalancingOperation$2$$anonfun$apply$5 $outer;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final String apply() {
                                        return new StringBuilder().append((Object)"No consumer ids registered for topic ").append((Object)this.$outer.topic$1).toString();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                    }
                                }));
                                this.$outer.rebalanceSucceeded$1.elem = false;
                            }
                            return;
                        }
                        throw new MatchError(option);
                    }

                    public anonfun.validateRebalancingOperation.2 kafka$tools$VerifyConsumerRebalance$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.topic$1 = string2;
                        this.topicDirs$1 = zKGroupTopicDirs;
                        this.partitionsWithOwners$1 = seq2;
                        this.consumerIdsForTopic$1 = option;
                    }
                });
            }
            {
                this.zkClient$1 = zkClient;
                this.group$2 = string2;
                this.rebalanceSucceeded$1 = booleanRef;
                this.consumersPerTopicMap$1 = map2;
            }
        });
        return rebalanceSucceeded$1.elem;
    }

    private VerifyConsumerRebalance$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

