/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.OutputStream;
import java.net.URI;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.api.FetchRequest;
import kafka.api.MultiFetchResponse;
import kafka.consumer.SimpleConsumer;
import kafka.message.ByteBufferMessageSet;
import kafka.message.MessageAndOffset;
import kafka.tools.SimpleConsumerShell$;
import kafka.tools.SimpleConsumerShell$$anon$1$;
import kafka.tools.SimpleConsumerShell$$anon$1$$anonfun$run$1$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class SimpleConsumerShell$
implements Logging {
    public static final SimpleConsumerShell$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    public volatile int bitmap$0;

    static {
        new SimpleConsumerShell$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        SimpleConsumerShell$ simpleConsumerShell$ = this;
        synchronized (simpleConsumerShell$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public void main(String[] args) {
        OptionParser parser$1 = new OptionParser();
        ArgumentAcceptingOptionSpec urlOpt = parser$1.accepts("server", "REQUIRED: The hostname of the server to connect to.").withRequiredArg().describedAs("kafka://hostname:port").ofType(String.class);
        ArgumentAcceptingOptionSpec topicOpt = parser$1.accepts("topic", "REQUIRED: The topic to consume from.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec partitionOpt = parser$1.accepts("partition", "The partition to consume from.").withRequiredArg().describedAs("partition").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec offsetOpt = parser$1.accepts("offset", "The offset to start consuming from.").withRequiredArg().describedAs("offset").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(0L), (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec fetchsizeOpt = parser$1.accepts("fetchsize", "The fetch size of each request.").withRequiredArg().describedAs("fetchsize").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1000000), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec printOffsetOpt = parser$1.accepts("print-offsets", "Print the offsets returned by the iterator").withOptionalArg().describedAs("print offsets").ofType(Boolean.class).defaultsTo((Object)Predef$.MODULE$.boolean2Boolean(false), (Object[])new Boolean[0]);
        ArgumentAcceptingOptionSpec printMessageOpt = parser$1.accepts("print-messages", "Print the messages returned by the iterator").withOptionalArg().describedAs("print messages").ofType(Boolean.class).defaultsTo((Object)Predef$.MODULE$.boolean2Boolean(false), (Object[])new Boolean[0]);
        OptionSet options$1 = parser$1.parse(args);
        List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{urlOpt, topicOpt})).foreach(new Serializable(parser$1, options$1){
            public static final long serialVersionUID;
            private final OptionParser parser$1;
            private final OptionSet options$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(ArgumentAcceptingOptionSpec<String> arg$1) {
                if (!this.options$1.has(arg$1)) {
                    SimpleConsumerShell$.MODULE$.error((Function0<String>)((Object)new Serializable(this, arg$1){
                        public static final long serialVersionUID;
                        private final ArgumentAcceptingOptionSpec arg$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return new StringBuilder().append((Object)"Missing required argument \"").append(this.arg$1).append((Object)"\"").toString();
                        }
                        {
                            this.arg$1 = argumentAcceptingOptionSpec;
                        }
                    }));
                    this.parser$1.printHelpOn((OutputStream)System.err);
                    System.exit(1);
                }
            }
            {
                this.parser$1 = optionParser;
                this.options$1 = optionSet;
            }
        });
        URI url = new URI((String)options$1.valueOf((OptionSpec)urlOpt));
        String topic$1 = (String)options$1.valueOf((OptionSpec)topicOpt);
        int partition$1 = (Integer)options$1.valueOf((OptionSpec)partitionOpt);
        long startingOffset$1 = (Long)options$1.valueOf((OptionSpec)offsetOpt);
        int fetchsize$1 = (Integer)options$1.valueOf((OptionSpec)fetchsizeOpt);
        boolean printOffsets$1 = options$1.has((OptionSpec)printOffsetOpt);
        boolean printMessages$1 = options$1.has((OptionSpec)printMessageOpt);
        this.info((Function0<String>)((Object)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Starting consumer...";
            }
        }));
        SimpleConsumer consumer$1 = new SimpleConsumer(url.getHost(), url.getPort(), 10000, 65536);
        Thread thread = Utils$.MODULE$.newThread("kafka-consumer", new Runnable(topic$1, partition$1, startingOffset$1, fetchsize$1, printOffsets$1, printMessages$1, consumer$1){
            private final String topic$1;
            private final int partition$1;
            private final long startingOffset$1;
            private final int fetchsize$1;
            public final boolean printOffsets$1;
            public final boolean printMessages$1;
            private final SimpleConsumer consumer$1;

            public void run() {
                LongRef offset$1 = new LongRef(this.startingOffset$1);
                while (true) {
                    FetchRequest fetchRequest = new FetchRequest(this.topic$1, this.partition$1, offset$1.elem, this.fetchsize$1);
                    MultiFetchResponse messageSets = this.consumer$1.multifetch(Predef$.MODULE$.wrapRefArray((Object[])new FetchRequest[]{fetchRequest}));
                    messageSets.foreach(new Serializable(this, offset$1){
                        public static final long serialVersionUID;
                        private final anon.1 $outer;
                        public final LongRef offset$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply(ByteBufferMessageSet messages$1) {
                            SimpleConsumerShell$.MODULE$.debug((Function0<String>)((Object)new Serializable(this, messages$1){
                                public static final long serialVersionUID;
                                private final anon$1$$anonfun$run$1 $outer;
                                private final ByteBufferMessageSet messages$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return new StringBuilder().append((Object)"multi fetched ").append(BoxesRunTime.boxToLong(this.messages$1.sizeInBytes())).append((Object)" bytes from offset ").append(BoxesRunTime.boxToLong(this.$outer.offset$1.elem)).toString();
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.messages$1 = byteBufferMessageSet;
                                }
                            }));
                            IntRef consumed$1 = new IntRef(0);
                            messages$1.foreach(new Serializable(this, consumed$1){
                                public static final long serialVersionUID;
                                private final anon$1$$anonfun$run$1 $outer;
                                private final IntRef consumed$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final void apply(MessageAndOffset messageAndOffset$1) {
                                    if (this.$outer.kafka$tools$SimpleConsumerShell$$anon$$anonfun$$$outer().printMessages$1) {
                                        SimpleConsumerShell$.MODULE$.info((Function0<String>)((Object)new Serializable(this, messageAndOffset$1){
                                            public static final long serialVersionUID;
                                            private final MessageAndOffset messageAndOffset$1;

                                            static {
                                                long l = serialVersionUID = 0L;
                                            }

                                            public final String apply() {
                                                return new StringBuilder().append((Object)"consumed: ").append((Object)Utils$.MODULE$.toString(this.messageAndOffset$1.message().payload(), "UTF-8")).toString();
                                            }
                                            {
                                                this.messageAndOffset$1 = messageAndOffset;
                                            }
                                        }));
                                    }
                                    this.$outer.offset$1.elem = messageAndOffset$1.offset();
                                    if (this.$outer.kafka$tools$SimpleConsumerShell$$anon$$anonfun$$$outer().printOffsets$1) {
                                        SimpleConsumerShell$.MODULE$.info((Function0<String>)((Object)new Serializable(this){
                                            public static final long serialVersionUID;
                                            private final anon$1$$anonfun$run$1$$anonfun$apply$3 $outer;

                                            static {
                                                long l = serialVersionUID = 0L;
                                            }

                                            public final String apply() {
                                                return new StringBuilder().append((Object)"next offset = ").append(BoxesRunTime.boxToLong(this.$outer.kafka$tools$SimpleConsumerShell$$anon$$anonfun$$anonfun$$$outer().offset$1.elem)).toString();
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw new NullPointerException();
                                                }
                                                this.$outer = $outer;
                                            }
                                        }));
                                    }
                                    ++this.consumed$1.elem;
                                }

                                public anon$1$$anonfun$run$1 kafka$tools$SimpleConsumerShell$$anon$$anonfun$$anonfun$$$outer() {
                                    return this.$outer;
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.consumed$1 = intRef;
                                }
                            });
                        }

                        public anon.1 kafka$tools$SimpleConsumerShell$$anon$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.offset$1 = longRef;
                        }
                    });
                }
            }
            {
                this.topic$1 = string2;
                this.partition$1 = n;
                this.startingOffset$1 = l;
                this.fetchsize$1 = n2;
                this.printOffsets$1 = bl;
                this.printMessages$1 = bl2;
                this.consumer$1 = simpleConsumer;
            }
        }, false);
        thread.start();
        thread.join();
    }

    private SimpleConsumerShell$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

