/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.producer.Producer;
import kafka.producer.ProducerConfig;
import kafka.producer.ProducerData;
import kafka.utils.Utils$;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class ProducerShell$
implements ScalaObject {
    public static final ProducerShell$ MODULE$;

    static {
        new ProducerShell$();
    }

    public void main(String[] args) {
        OptionParser parser$1 = new OptionParser();
        ArgumentAcceptingOptionSpec producerPropsOpt = parser$1.accepts("props", "REQUIRED: Properties file with the producer properties.").withRequiredArg().describedAs("properties").ofType(String.class);
        ArgumentAcceptingOptionSpec topicOpt = parser$1.accepts("topic", "REQUIRED: The topic to produce to.").withRequiredArg().describedAs("topic").ofType(String.class);
        OptionSet options$1 = parser$1.parse(args);
        List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{producerPropsOpt, topicOpt})).foreach(new Serializable(parser$1, options$1){
            public static final long serialVersionUID;
            private final OptionParser parser$1;
            private final OptionSet options$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(ArgumentAcceptingOptionSpec<String> arg) {
                if (!this.options$1.has(arg)) {
                    System.err.println(new StringBuilder().append((Object)"Missing required argument \"").append(arg).append((Object)"\"").toString());
                    this.parser$1.printHelpOn((OutputStream)System.err);
                    System.exit(1);
                }
            }
            {
                this.parser$1 = optionParser;
                this.options$1 = optionSet;
            }
        });
        String propsFile = (String)options$1.valueOf((OptionSpec)producerPropsOpt);
        ProducerConfig producerConfig = new ProducerConfig(Utils$.MODULE$.loadProps(propsFile));
        String topic = (String)options$1.valueOf((OptionSpec)topicOpt);
        Producer producer = new Producer(producerConfig);
        BufferedReader input2 = new BufferedReader(new InputStreamReader(System.in));
        boolean done = false;
        while (true) {
            if (done) {
                producer.close();
                return;
            }
            String line = input2.readLine();
            if (line == null) {
                done = true;
                continue;
            }
            String message = line.trim();
            producer.send(Predef$.MODULE$.wrapRefArray((Object[])new ProducerData[]{new ProducerData(topic, message)}));
            Predef$.MODULE$.println(Predef$.MODULE$.augmentString("Sent: %s (%d bytes)").format(Predef$.MODULE$.genericWrapArray(new Object[]{line, BoxesRunTime.boxToInteger(message.getBytes().length)})));
        }
    }

    private ProducerShell$() {
        MODULE$ = this;
    }
}

