/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.OutputStream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.consumer.Blacklist;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.KafkaStream;
import kafka.consumer.TopicFilter;
import kafka.consumer.Whitelist;
import kafka.consumer.ZookeeperConsumerConnector;
import kafka.message.Message;
import kafka.producer.Producer;
import kafka.producer.ProducerConfig;
import kafka.tools.MirrorMaker;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.runtime.Null$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class MirrorMaker$
implements Logging {
    public static final MirrorMaker$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    public volatile int bitmap$0;

    static {
        new MirrorMaker$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        MirrorMaker$ mirrorMaker$ = this;
        synchronized (mirrorMaker$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public void main(String[] args) {
        this.info((Function0<String>)((Object)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Starting mirror maker";
            }
        }));
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec consumerConfigOpt = parser.accepts("consumer.config", "Consumer config to consume from a source cluster. You may specify multiple of these.").withRequiredArg().describedAs("config file").ofType(String.class);
        ArgumentAcceptingOptionSpec producerConfigOpt$1 = parser.accepts("producer.config", "Embedded producer config.").withRequiredArg().describedAs("config file").ofType(String.class);
        ArgumentAcceptingOptionSpec numProducersOpt = parser.accepts("num.producers", "Number of producer instances").withRequiredArg().describedAs("Number of producers").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec numStreamsOpt = parser.accepts("num.streams", "Number of consumption streams.").withRequiredArg().describedAs("Number of threads").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec whitelistOpt = parser.accepts("whitelist", "Whitelist of topics to mirror.").withRequiredArg().describedAs("Java regex (String)").ofType(String.class);
        ArgumentAcceptingOptionSpec blacklistOpt = parser.accepts("blacklist", "Blacklist of topics to mirror.").withRequiredArg().describedAs("Java regex (String)").ofType(String.class);
        OptionSpecBuilder helpOpt = parser.accepts("help", "Print this message.");
        OptionSet options$1 = parser.parse(args);
        if (options$1.has((OptionSpec)helpOpt)) {
            parser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        Utils$.MODULE$.checkRequiredArgs(parser, options$1, Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{consumerConfigOpt, producerConfigOpt$1}));
        if (List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{whitelistOpt, blacklistOpt})).count(new Serializable(options$1){
            public static final long serialVersionUID;
            private final OptionSet options$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(OptionSpec<?> optionSpec) {
                return this.options$1.has(optionSpec);
            }
            {
                this.options$1 = optionSet;
            }
        }) != 1) {
            Predef$.MODULE$.println("Exactly one of whitelist or blacklist is required.");
            System.exit(1);
        }
        Integer numStreams$1 = (Integer)options$1.valueOf((OptionSpec)numStreamsOpt);
        IndexedSeq producers$1 = Predef$.MODULE$.intWrapper(1).to((Integer)options$1.valueOf((OptionSpec)numProducersOpt)).map(new Serializable(producerConfigOpt$1, options$1){
            public static final long serialVersionUID;
            private final ArgumentAcceptingOptionSpec producerConfigOpt$1;
            private final OptionSet options$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Producer<Null$, Message> apply(int x$1) {
                ProducerConfig config = new ProducerConfig(Utils$.MODULE$.loadProps((String)this.options$1.valueOf((OptionSpec)this.producerConfigOpt$1)));
                return new Producer<Null$, Message>(config);
            }
            {
                this.producerConfigOpt$1 = argumentAcceptingOptionSpec;
                this.options$1 = optionSet;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        List connectors$1 = ((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(options$1.valuesOf((OptionSpec)consumerConfigOpt)).toList().map(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final ConsumerConfig apply(String cfg) {
                return new ConsumerConfig(Utils$.MODULE$.loadProps(cfg.toString()));
            }
        }, List$.MODULE$.canBuildFrom())).map(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final ZookeeperConsumerConnector apply(ConsumerConfig consumerConfig) {
                return new ZookeeperConsumerConnector(consumerConfig);
            }
        }, List$.MODULE$.canBuildFrom());
        Runtime.getRuntime().addShutdownHook(new Thread(producers$1, connectors$1){
            private final IndexedSeq producers$1;
            private final List connectors$1;

            public void run() {
                this.connectors$1.foreach(new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(ZookeeperConsumerConnector zookeeperConsumerConnector) {
                        zookeeperConsumerConnector.shutdown();
                    }
                });
                this.producers$1.foreach(new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(Producer<Null$, Message> producer) {
                        producer.close();
                    }
                });
            }
            {
                this.producers$1 = indexedSeq;
                this.connectors$1 = list2;
            }
        });
        TopicFilter filterSpec$1 = options$1.has((OptionSpec)whitelistOpt) ? new Whitelist((String)options$1.valueOf((OptionSpec)whitelistOpt)) : new Blacklist((String)options$1.valueOf((OptionSpec)blacklistOpt));
        List streams2 = connectors$1.map(new Serializable(numStreams$1, filterSpec$1){
            public static final long serialVersionUID;
            private final Integer numStreams$1;
            private final TopicFilter filterSpec$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Seq<KafkaStream<Message>> apply(ZookeeperConsumerConnector zookeeperConsumerConnector) {
                return zookeeperConsumerConnector.createMessageStreamsByFilter(this.filterSpec$1, this.numStreams$1, zookeeperConsumerConnector.createMessageStreamsByFilter$default$3());
            }
            {
                this.numStreams$1 = n;
                this.filterSpec$1 = topicFilter;
            }
        }, List$.MODULE$.canBuildFrom());
        List threads = ((TraversableLike)((IterableLike)streams2.flatten(Predef$.MODULE$.conforms())).zipWithIndex(List$.MODULE$.canBuildFrom())).map(new Serializable(producers$1){
            public static final long serialVersionUID;
            private final IndexedSeq producers$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final MirrorMaker.MirrorMakerThread apply(Tuple2<KafkaStream<Message>, Object> streamAndIndex) {
                return new MirrorMaker.MirrorMakerThread(streamAndIndex._1(), this.producers$1, streamAndIndex._2$mcI$sp());
            }
            {
                this.producers$1 = indexedSeq;
            }
        }, List$.MODULE$.canBuildFrom());
        threads.foreach(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(MirrorMaker.MirrorMakerThread mirrorMakerThread) {
                mirrorMakerThread.start();
            }
        });
        threads.foreach(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(MirrorMaker.MirrorMakerThread mirrorMakerThread) {
                mirrorMakerThread.awaitShutdown();
            }
        });
    }

    private MirrorMaker$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

