/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.tools.JmxTool$;
import scala.Array$;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$String$;
import scala.math.package$;
import scala.reflect.ClassManifest$;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JmxTool$
implements ScalaObject {
    public static final JmxTool$ MODULE$;

    static {
        new JmxTool$();
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec objectNameOpt = parser.accepts("object-name", "A JMX object name to use as a query. This can contain wild cards, and this option can be given multiple times to specify more than one query. If no objects are specified all objects will be queried.").withRequiredArg().describedAs("name").ofType(String.class);
        ArgumentAcceptingOptionSpec reportingIntervalOpt = parser.accepts("reporting-interval", "Interval in MS with which to poll jmx stats.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(5000), (Object[])new Integer[0]);
        OptionSpecBuilder helpOpt = parser.accepts("help", "Print usage information.");
        ArgumentAcceptingOptionSpec dateFormatOpt = parser.accepts("date-format", "The date format to use for formatting the time field. See java.text.SimpleDateFormat for options.").withRequiredArg().describedAs("format").ofType(String.class).defaultsTo((Object)"yyyy-MM-dd HH:mm:ss.SSS", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec jmxServiceUrlOpt = parser.accepts("jmx-url", "The url to connect to to poll JMX data. See Oracle javadoc for JMXServiceURL for details.").withRequiredArg().describedAs("service-url").ofType(String.class).defaultsTo((Object)"service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (Object[])new String[0]);
        OptionSet options = parser.parse(args);
        if (options.has((OptionSpec)helpOpt)) {
            parser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        JMXServiceURL url = new JMXServiceURL((String)options.valueOf((OptionSpec)jmxServiceUrlOpt));
        int interval = (Integer)options.valueOf((OptionSpec)reportingIntervalOpt);
        SimpleDateFormat dateFormat = new SimpleDateFormat((String)options.valueOf((OptionSpec)dateFormatOpt));
        JMXConnector jmxc = JMXConnectorFactory.connect(url, null);
        MBeanServerConnection mbsc$1 = jmxc.getMBeanServerConnection();
        GenTraversable queries = options.has((OptionSpec)objectNameOpt) ? (Iterable)JavaConversions$.MODULE$.asScalaBuffer(options.valuesOf((OptionSpec)objectNameOpt)).map(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final ObjectName apply(String string2) {
                return new ObjectName(string2);
            }
        }, Buffer$.MODULE$.canBuildFrom()) : List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray(new Null$[]{null}));
        Iterable names = (Iterable)((GenericTraversableTemplate)queries.map(new Serializable(mbsc$1){
            public static final long serialVersionUID;
            private final MBeanServerConnection mbsc$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Set<ObjectName> apply(ObjectName name) {
                return JavaConversions$.MODULE$.asSet(this.mbsc$1.queryNames(name, null));
            }
            {
                this.mbsc$1 = mBeanServerConnection;
            }
        }, Iterable$.MODULE$.canBuildFrom())).flatten(Predef$.MODULE$.conforms());
        Iterable attributes = names.map(new Serializable(mbsc$1){
            public static final long serialVersionUID;
            private final MBeanServerConnection mbsc$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<ObjectName, String[]> apply(ObjectName name) {
                return new Tuple2<ObjectName, Object>(name, Predef$.MODULE$.refArrayOps((Object[])this.mbsc$1.getMBeanInfo(name).getAttributes()).map(new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply(MBeanAttributeInfo mBeanAttributeInfo) {
                        return mBeanAttributeInfo.getName();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(String.class))));
            }
            {
                this.mbsc$1 = mBeanServerConnection;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        List keys = ((List)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"time"}))).$plus$plus(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.queryAttributes(mbsc$1, names).keys().toArray(ClassManifest$.MODULE$.classType(String.class))).sorted(Ordering$String$.MODULE$)), List$.MODULE$.canBuildFrom());
        Predef$.MODULE$.println(((TraversableOnce)keys.map(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(String string2) {
                return new StringBuilder().append((Object)"\"").append((Object)string2).append((Object)"\"").toString();
            }
        }, List$.MODULE$.canBuildFrom())).mkString(", "));
        while (true) {
            long start = System.currentTimeMillis();
            HashMap<String, Object> attributes$2 = this.queryAttributes(mbsc$1, names);
            attributes$2.update("time", dateFormat.format(new Date()));
            Predef$.MODULE$.println(((TraversableOnce)keys.map(new Serializable(attributes$2){
                public static final long serialVersionUID;
                private final HashMap attributes$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Object apply(String string2) {
                    return this.attributes$2.apply(string2);
                }
                {
                    this.attributes$2 = hashMap;
                }
            }, List$.MODULE$.canBuildFrom())).mkString(", "));
            long sleep = package$.MODULE$.max(0L, (long)interval - (System.currentTimeMillis() - start));
            Thread.sleep(sleep);
        }
    }

    public HashMap<String, Object> queryAttributes(MBeanServerConnection mbsc$2, Iterable<ObjectName> names) {
        ObjectRef attributes$1 = new ObjectRef(new HashMap());
        names.foreach(new Serializable(mbsc$2, attributes$1){
            public static final long serialVersionUID;
            private final MBeanServerConnection mbsc$2;
            public final ObjectRef attributes$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(ObjectName name$1) {
                MBeanInfo mbean = this.mbsc$2.getMBeanInfo(name$1);
                JavaConversions$.MODULE$.asScalaBuffer(this.mbsc$2.getAttributes(name$1, (String[])Predef$.MODULE$.refArrayOps((Object[])mbean.getAttributes()).map(new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply(MBeanAttributeInfo mBeanAttributeInfo) {
                        return mBeanAttributeInfo.getName();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(String.class))))).foreach(new Serializable(this, name$1){
                    public static final long serialVersionUID;
                    private final anonfun.queryAttributes.1 $outer;
                    private final ObjectName name$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(Object attrObj) {
                        Attribute attr = (Attribute)attrObj;
                        ((HashMap)this.$outer.attributes$1.elem).update(new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd(this.name$1).$plus(":")).append((Object)attr.getName()).toString(), attr.getValue());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.name$1 = objectName;
                    }
                });
            }
            {
                this.mbsc$2 = mBeanServerConnection;
                this.attributes$1 = objectRef;
            }
        });
        return (HashMap)attributes$1.elem;
    }

    private JmxTool$() {
        MODULE$ = this;
    }
}

