/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.OutputStream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.consumer.Consumer$;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerConnector;
import kafka.consumer.KafkaStream;
import kafka.serializer.StringDecoder;
import kafka.tools.ConsumerShell$;
import kafka.tools.ZKConsumerThread;
import kafka.utils.Utils$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class ConsumerShell$
implements ScalaObject {
    public static final ConsumerShell$ MODULE$;

    static {
        new ConsumerShell$();
    }

    public void main(String[] args) {
        OptionParser parser$1 = new OptionParser();
        ArgumentAcceptingOptionSpec topicOpt = parser$1.accepts("topic", "REQUIRED: The topic to consume from.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec consumerPropsOpt = parser$1.accepts("props", "REQUIRED: Properties file with the consumer properties.").withRequiredArg().describedAs("properties").ofType(String.class);
        ArgumentAcceptingOptionSpec partitionsOpt = parser$1.accepts("partitions", "Number of partitions to consume from.").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        OptionSet options$1 = parser$1.parse(args);
        List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{topicOpt, consumerPropsOpt})).foreach(new Serializable(parser$1, options$1){
            public static final long serialVersionUID;
            private final OptionParser parser$1;
            private final OptionSet options$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(ArgumentAcceptingOptionSpec<String> arg) {
                if (!this.options$1.has(arg)) {
                    System.err.println(new StringBuilder().append((Object)"Missing required argument \"").append(arg).append((Object)"\"").toString());
                    this.parser$1.printHelpOn((OutputStream)System.err);
                    System.exit(1);
                }
            }
            {
                this.parser$1 = optionParser;
                this.options$1 = optionSet;
            }
        });
        int partitions = (Integer)options$1.valueOf((OptionSpec)partitionsOpt);
        String propsFile = (String)options$1.valueOf((OptionSpec)consumerPropsOpt);
        String topic = (String)options$1.valueOf((OptionSpec)topicOpt);
        Predef$.MODULE$.println("Starting consumer...");
        ConsumerConfig consumerConfig = new ConsumerConfig(Utils$.MODULE$.loadProps(propsFile));
        ConsumerConnector consumerConnector$1 = Consumer$.MODULE$.create(consumerConfig);
        Map<String, List<KafkaStream<String>>> topicMessageStreams = consumerConnector$1.createMessageStreams((Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc(topic).$minus$greater(BoxesRunTime.boxToInteger(partitions))})), new StringDecoder());
        ObjectRef threadList$1 = new ObjectRef(Nil$.MODULE$);
        ((IterableLike)topicMessageStreams.filter((Function1<String, Object>)((Object)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<String, List<KafkaStream<String>>> tuple2) {
                Tuple2<String, List<KafkaStream<String>>> tuple22 = tuple2;
                return tuple22 != null;
            }
        }))).foreach(new Serializable(threadList$1){
            public static final long serialVersionUID;
            public final ObjectRef threadList$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<String, List<KafkaStream<String>>> tuple2) {
                Tuple2<String, List<KafkaStream<String>>> tuple22 = tuple2;
                if (tuple22 != null) {
                    ((LinearSeqOptimized)tuple22._2()).foreach(new Serializable(this){
                        public static final long serialVersionUID;
                        private final anonfun.main.3 $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply(KafkaStream<String> stream) {
                            this.$outer.threadList$1.elem = ((List)this.$outer.threadList$1.elem).$colon$colon(new ZKConsumerThread(stream));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    return;
                }
                throw new MatchError(tuple22);
            }
            {
                this.threadList$1 = objectRef;
            }
        });
        ((List)threadList$1.elem).foreach(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(ZKConsumerThread thread) {
                thread.start();
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(consumerConnector$1, threadList$1){
            private final ConsumerConnector consumerConnector$1;
            private final ObjectRef threadList$1;

            public void run() {
                this.consumerConnector$1.shutdown();
                ((List)this.threadList$1.elem).foreach(new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(ZKConsumerThread zKConsumerThread) {
                        zKConsumerThread.shutdown();
                    }
                });
                Predef$.MODULE$.println("consumer threads shutted down");
            }
            {
                this.consumerConnector$1 = consumerConnector;
                this.threadList$1 = objectRef;
            }
        });
    }

    private ConsumerShell$() {
        MODULE$ = this;
    }
}

