/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.OutputStream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.consumer.SimpleConsumer;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering$String$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ConsumerOffsetChecker$
implements Logging {
    public static final ConsumerOffsetChecker$ MODULE$;
    private final Map<String, Option<SimpleConsumer>> consumerMap;
    private final Regex BidPidPattern;
    private final Regex BrokerIpPattern;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    public volatile int bitmap$0;

    static {
        new ConsumerOffsetChecker$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ConsumerOffsetChecker$ consumerOffsetChecker$ = this;
        synchronized (consumerOffsetChecker$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private Map<String, Option<SimpleConsumer>> consumerMap() {
        return this.consumerMap;
    }

    private Regex BidPidPattern() {
        return this.BidPidPattern;
    }

    private Regex BrokerIpPattern() {
        return this.BrokerIpPattern;
    }

    public final Option<SimpleConsumer> kafka$tools$ConsumerOffsetChecker$$getConsumer(ZkClient zkClient, String bid) {
        Option option;
        List<String> list2;
        String brokerInfo$1;
        String string2 = brokerInfo$1 = ZkUtils$.MODULE$.readDataMaybeNull(zkClient, Predef$.MODULE$.augmentString("/brokers/ids/%s").format(Predef$.MODULE$.genericWrapArray(new Object[]{bid})));
        Option<List<String>> option2 = this.BrokerIpPattern().unapplySeq(string2);
        if (!option2.isEmpty() && ((list2 = option2.get()) == null ? false : list2.lengthCompare(2) == 0)) {
            option = new Some<SimpleConsumer>(new SimpleConsumer((String)list2.apply(0), Predef$.MODULE$.augmentString((String)list2.apply(1)).toInt(), 10000, 100000));
        } else {
            this.error((Function0<String>)((Object)new Serializable(brokerInfo$1){
                public static final long serialVersionUID;
                private final String brokerInfo$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Could not parse broker info %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.brokerInfo$1}));
                }
                {
                    this.brokerInfo$1 = string2;
                }
            }));
            option = None$.MODULE$;
        }
        None$ consumer = option;
        return consumer;
    }

    public final void kafka$tools$ConsumerOffsetChecker$$processPartition(ZkClient zkClient$1, String group, String topic, String bidPid$1) {
        List<String> list2;
        long offset = Predef$.MODULE$.augmentString(ZkUtils$.MODULE$.readData(zkClient$1, Predef$.MODULE$.augmentString("/consumers/%s/offsets/%s/%s").format(Predef$.MODULE$.genericWrapArray(new Object[]{group, topic, bidPid$1})))).toLong();
        String owner = ZkUtils$.MODULE$.readDataMaybeNull(zkClient$1, Predef$.MODULE$.augmentString("/consumers/%s/owners/%s/%s").format(Predef$.MODULE$.genericWrapArray(new Object[]{group, topic, bidPid$1})));
        Predef$.MODULE$.println(Predef$.MODULE$.augmentString("%s,%s,%s (Group,Topic,BrokerId-PartitionId)").format(Predef$.MODULE$.genericWrapArray(new Object[]{group, topic, bidPid$1})));
        Predef$.MODULE$.println(Predef$.MODULE$.augmentString("%20s%s").format(Predef$.MODULE$.genericWrapArray(new Object[]{"Owner = ", owner})));
        Predef$.MODULE$.println(Predef$.MODULE$.augmentString("%20s%d").format(Predef$.MODULE$.genericWrapArray(new Object[]{"Consumer offset = ", BoxesRunTime.boxToLong(offset)})));
        Predef$.MODULE$.println(Predef$.MODULE$.augmentString("%20s%,d (%,.2fG)").format(Predef$.MODULE$.genericWrapArray(new Object[]{"= ", BoxesRunTime.boxToLong(offset), BoxesRunTime.boxToDouble((double)offset / package$.MODULE$.pow(1024.0, 3.0))})));
        String string2 = bidPid$1;
        Option<List<String>> option = this.BidPidPattern().unapplySeq(string2);
        if (!option.isEmpty() && ((list2 = option.get()) == null ? false : list2.lengthCompare(2) == 0)) {
            String string3 = (String)list2.apply(0);
            String string4 = (String)list2.apply(1);
            String bid$1 = string3;
            String pid = string4;
            Option consumerOpt = (Option)this.consumerMap().getOrElseUpdate(bid$1, (Function0<Option<SimpleConsumer>>)((Object)new Serializable(zkClient$1, bid$1){
                public static final long serialVersionUID;
                private final ZkClient zkClient$1;
                private final String bid$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Option<SimpleConsumer> apply() {
                    return ConsumerOffsetChecker$.MODULE$.kafka$tools$ConsumerOffsetChecker$$getConsumer(this.zkClient$1, this.bid$1);
                }
                {
                    this.zkClient$1 = zkClient;
                    this.bid$1 = string2;
                }
            }));
            Option option2 = consumerOpt;
            if (option2 instanceof Some) {
                SimpleConsumer simpleConsumer;
                Some some = (Some)option2;
                SimpleConsumer consumer = simpleConsumer = (SimpleConsumer)some.x();
                long logSize = BoxesRunTime.unboxToLong(Predef$.MODULE$.longArrayOps(consumer.getOffsetsBefore(topic, Predef$.MODULE$.augmentString(pid).toInt(), -1L, 1)).last());
                Predef$.MODULE$.println(Predef$.MODULE$.augmentString("%20s%d").format(Predef$.MODULE$.genericWrapArray(new Object[]{"Log size = ", BoxesRunTime.boxToLong(logSize)})));
                Predef$.MODULE$.println(Predef$.MODULE$.augmentString("%20s%,d (%,.2fG)").format(Predef$.MODULE$.genericWrapArray(new Object[]{"= ", BoxesRunTime.boxToLong(logSize), BoxesRunTime.boxToDouble((double)logSize / package$.MODULE$.pow(1024.0, 3.0))})));
                long lag = logSize - offset;
                Predef$.MODULE$.println(Predef$.MODULE$.augmentString("%20s%d").format(Predef$.MODULE$.genericWrapArray(new Object[]{"Consumer lag = ", BoxesRunTime.boxToLong(lag)})));
                Predef$.MODULE$.println(Predef$.MODULE$.augmentString("%20s%,d (%,.2fG)").format(Predef$.MODULE$.genericWrapArray(new Object[]{"= ", BoxesRunTime.boxToLong(lag), BoxesRunTime.boxToDouble((double)lag / package$.MODULE$.pow(1024.0, 3.0))})));
                Predef$.MODULE$.println();
            } else {
                None$ none$ = None$.MODULE$;
                Option option3 = option2;
                if (none$ == null ? option3 != null : !none$.equals(option3)) {
                    throw new MatchError(option2);
                }
            }
        } else {
            this.error((Function0<String>)((Object)new Serializable(bidPid$1){
                public static final long serialVersionUID;
                private final String bidPid$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Could not parse broker/partition pair %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.bidPid$1}));
                }
                {
                    this.bidPid$1 = string2;
                }
            }));
        }
    }

    public final void kafka$tools$ConsumerOffsetChecker$$processTopic(ZkClient zkClient$2, String group$1, String topic$1) {
        List bidsPids = ZkUtils$.MODULE$.getChildrenParentMayNotExist(zkClient$2, Predef$.MODULE$.augmentString("/consumers/%s/offsets/%s").format(Predef$.MODULE$.genericWrapArray(new Object[]{group$1, topic$1}))).toList();
        ((LinearSeqOptimized)bidsPids.sorted(Ordering$String$.MODULE$)).foreach(new Serializable(zkClient$2, group$1, topic$1){
            public static final long serialVersionUID;
            private final ZkClient zkClient$2;
            private final String group$1;
            private final String topic$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String bidPid) {
                ConsumerOffsetChecker$.MODULE$.kafka$tools$ConsumerOffsetChecker$$processPartition(this.zkClient$2, this.group$1, this.topic$1, bidPid);
            }
            {
                this.zkClient$2 = zkClient;
                this.group$1 = string2;
                this.topic$1 = string3;
            }
        });
    }

    private void printBrokerInfo() {
        Predef$.MODULE$.println("BROKER INFO");
        ((IterableLike)this.consumerMap().filter((Function1<String, Object>)((Object)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<String, Option<SimpleConsumer>> tuple2) {
                Tuple2<String, Option<SimpleConsumer>> tuple22 = tuple2;
                return tuple22 != null;
            }
        }))).foreach(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<String, Option<SimpleConsumer>> tuple2) {
                Tuple2<String, Option<SimpleConsumer>> tuple22;
                block2: {
                    Option<SimpleConsumer> option;
                    block5: {
                        block4: {
                            block3: {
                                SimpleConsumer simpleConsumer;
                                tuple22 = tuple2;
                                if (tuple22 == null) break block2;
                                Option<SimpleConsumer> option2 = tuple22._2();
                                Option<SimpleConsumer> consumerOpt = option2;
                                option = consumerOpt;
                                if (!(option instanceof Some)) break block3;
                                Some some = (Some)option;
                                SimpleConsumer consumer = simpleConsumer = (SimpleConsumer)some.x();
                                Predef$.MODULE$.println(Predef$.MODULE$.augmentString("%s -> %s:%d").format(Predef$.MODULE$.genericWrapArray(new Object[]{tuple22._1(), consumer.host(), BoxesRunTime.boxToInteger(consumer.port())})));
                                break block4;
                            }
                            None$ none$ = None$.MODULE$;
                            Option<SimpleConsumer> option3 = option;
                            if (none$ != null ? !none$.equals(option3) : option3 != null) break block5;
                        }
                        return;
                    }
                    throw new MatchError(option);
                }
                throw new MatchError(tuple22);
            }
        });
    }

    public void main(String[] args) {
        Option option;
        block8: {
            OptionParser parser$1 = new OptionParser();
            ArgumentAcceptingOptionSpec zkConnectOpt = parser$1.accepts("zkconnect", "ZooKeeper connect string.").withRequiredArg().defaultsTo((Object)"localhost:2181", (Object[])new String[0]).ofType(String.class);
            ArgumentAcceptingOptionSpec topicsOpt = parser$1.accepts("topic", "Comma-separated list of consumer topics (all topics if absent).").withRequiredArg().ofType(String.class);
            ArgumentAcceptingOptionSpec groupOpt = parser$1.accepts("group", "Consumer group.").withRequiredArg().ofType(String.class);
            parser$1.accepts("help", "Print this message.");
            OptionSet options$1 = parser$1.parse(args);
            if (options$1.has("help")) {
                parser$1.printHelpOn((OutputStream)System.out);
                System.exit(0);
            }
            List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{groupOpt})).foreach(new Serializable(parser$1, options$1){
                public static final long serialVersionUID;
                private final OptionParser parser$1;
                private final OptionSet options$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(ArgumentAcceptingOptionSpec<String> opt2) {
                    if (!this.options$1.has(opt2)) {
                        System.err.println(Predef$.MODULE$.augmentString("Missing required argument: %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{opt2})));
                        this.parser$1.printHelpOn((OutputStream)System.err);
                        System.exit(1);
                    }
                }
                {
                    this.parser$1 = optionParser;
                    this.options$1 = optionSet;
                }
            });
            String zkConnect$1 = (String)options$1.valueOf((OptionSpec)zkConnectOpt);
            String group$2 = (String)options$1.valueOf((OptionSpec)groupOpt);
            Option topics = options$1.has((OptionSpec)topicsOpt) ? new Some<Object>(options$1.valueOf((OptionSpec)topicsOpt)) : None$.MODULE$;
            ObjectRef zkClient$3 = new ObjectRef(null);
            try {
                List list2;
                zkClient$3.elem = new ZkClient(zkConnect$1, 30000, 30000, ZKStringSerializer$.MODULE$);
                option = topics;
                if (option instanceof Some) {
                    list2 = Predef$.MODULE$.refArrayOps((Object[])((String)((Some)option).x()).split(",")).view().toList();
                } else {
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block8;
                    list2 = ZkUtils$.MODULE$.getChildren((ZkClient)zkClient$3.elem, Predef$.MODULE$.augmentString("/consumers/%s/offsets").format(Predef$.MODULE$.genericWrapArray(new Object[]{group$2}))).toList();
                }
                List topicList$1 = list2;
                this.debug((Function0<String>)((Object)new Serializable(zkConnect$1, group$2, topicList$1){
                    public static final long serialVersionUID;
                    private final String zkConnect$1;
                    private final String group$2;
                    private final List topicList$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("zkConnect = %s; topics = %s; group = %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.zkConnect$1, this.topicList$1.toString(), this.group$2}));
                    }
                    {
                        this.zkConnect$1 = string2;
                        this.group$2 = string3;
                        this.topicList$1 = list2;
                    }
                }));
                ((LinearSeqOptimized)topicList$1.sorted(Ordering$String$.MODULE$)).foreach(new Serializable(group$2, zkClient$3){
                    public static final long serialVersionUID;
                    private final String group$2;
                    private final ObjectRef zkClient$3;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(String topic) {
                        ConsumerOffsetChecker$.MODULE$.kafka$tools$ConsumerOffsetChecker$$processTopic((ZkClient)this.zkClient$3.elem, this.group$2, topic);
                    }
                    {
                        this.group$2 = string2;
                        this.zkClient$3 = objectRef;
                    }
                });
                this.printBrokerInfo();
                this.consumerMap().values().foreach(new Serializable(){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(Option<SimpleConsumer> consumerOpt) {
                        Option<SimpleConsumer> option;
                        block4: {
                            block3: {
                                block2: {
                                    option = consumerOpt;
                                    if (!(option instanceof Some)) break block2;
                                    ((SimpleConsumer)((Some)option).x()).close();
                                    break block3;
                                }
                                None$ none$ = None$.MODULE$;
                                Option<SimpleConsumer> option2 = option;
                                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                            }
                            return;
                        }
                        throw new MatchError(option);
                    }
                });
            }
            catch (Throwable throwable) {
                this.consumerMap().values().foreach(new /* invalid duplicate definition of identical inner class */);
                if ((ZkClient)zkClient$3.elem != null) {
                    ((ZkClient)zkClient$3.elem).close();
                }
                throw throwable;
            }
            if ((ZkClient)zkClient$3.elem != null) {
                ((ZkClient)zkClient$3.elem).close();
            }
            return;
        }
        throw new MatchError(option);
    }

    private ConsumerOffsetChecker$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.consumerMap = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
        this.BidPidPattern = Predef$.MODULE$.augmentString("(\\d+)-(\\d+)").r();
        this.BrokerIpPattern = Predef$.MODULE$.augmentString(".*:(\\d+\\.\\d+\\.\\d+\\.\\d+):(\\d+$)").r();
    }
}

