/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.SocketChannel;
import kafka.common.ErrorMapping$;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.network.Send;
import kafka.network.Send$class;
import kafka.network.Transmission$class;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001y4Q!\u0001\u0002\u0001\u0005\u0019\u0011a\"T3tg\u0006<WmU3u'\u0016tGM\u0003\u0002\u0004\t\u000511/\u001a:wKJT\u0011!B\u0001\u0006W\u000647.Y\n\u0005\u0001\u001dyQ\u0003\u0005\u0002\t\u001b5\t\u0011B\u0003\u0002\u000b\u0017\u0005!A.\u00198h\u0015\u0005a\u0011\u0001\u00026bm\u0006L!AD\u0005\u0003\r=\u0013'.Z2u!\t\u00012#D\u0001\u0012\u0015\t\u0011B!A\u0004oKR<xN]6\n\u0005Q\t\"\u0001B*f]\u0012\u0004\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u00111bU2bY\u0006|%M[3di\"AA\u0004\u0001BC\u0002\u0013\u0005a$\u0001\u0005nKN\u001c\u0018mZ3t\u0007\u0001)\u0012a\b\t\u0003A\rj\u0011!\t\u0006\u0003E\u0011\tq!\\3tg\u0006<W-\u0003\u0002%C\tQQ*Z:tC\u001e,7+\u001a;\t\u0011\u0019\u0002!\u0011!Q\u0001\n}\t\u0011\"\\3tg\u0006<Wm\u001d\u0011\t\u0011!\u0002!Q1A\u0005\u0002%\n\u0011\"\u001a:s_J\u001cu\u000eZ3\u0016\u0003)\u0002\"AF\u0016\n\u00051:\"aA%oi\"Aa\u0006\u0001B\u0001B\u0003%!&\u0001\u0006feJ|'oQ8eK\u0002BQ\u0001\r\u0001\u0005\u0002E\na\u0001P5oSRtDc\u0001\u001a5kA\u00111\u0007A\u0007\u0002\u0005!)Ad\fa\u0001?!)\u0001f\fa\u0001U!9q\u0007\u0001a\u0001\n\u0013A\u0014\u0001B:f]R,\u0012!\u000f\t\u0003-iJ!aO\f\u0003\t1{gn\u001a\u0005\b{\u0001\u0001\r\u0011\"\u0003?\u0003!\u0019XM\u001c;`I\u0015\fHCA C!\t1\u0002)\u0003\u0002B/\t!QK\\5u\u0011\u001d\u0019E(!AA\u0002e\n1\u0001\u001f\u00132\u0011\u0019)\u0005\u0001)Q\u0005s\u0005)1/\u001a8uA!9q\t\u0001a\u0001\n\u0013A\u0014\u0001B:ju\u0016Dq!\u0013\u0001A\u0002\u0013%!*\u0001\u0005tSj,w\fJ3r)\ty4\nC\u0004D\u0011\u0006\u0005\t\u0019A\u001d\t\r5\u0003\u0001\u0015)\u0003:\u0003\u0015\u0019\u0018N_3!\u0011\u001dy\u0005A1A\u0005\nA\u000ba\u0001[3bI\u0016\u0014X#A)\u0011\u0005I+V\"A*\u000b\u0005Q[\u0011a\u00018j_&\u0011ak\u0015\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\bB\u0002-\u0001A\u0003%\u0011+A\u0004iK\u0006$WM\u001d\u0011\t\u000fi\u0003\u0001\u0019!C\u00017\u0006A1m\\7qY\u0016$X-F\u0001]!\t1R,\u0003\u0002_/\t9!i\\8mK\u0006t\u0007b\u00021\u0001\u0001\u0004%\t!Y\u0001\rG>l\u0007\u000f\\3uK~#S-\u001d\u000b\u0003\u007f\tDqaQ0\u0002\u0002\u0003\u0007A\f\u0003\u0004e\u0001\u0001\u0006K\u0001X\u0001\nG>l\u0007\u000f\\3uK\u0002BQ\u0001\r\u0001\u0005\u0002\u0019$\"AM4\t\u000bq)\u0007\u0019A\u0010\t\u000bA\u0002A\u0011A5\u0015\u0003IBQa\u001b\u0001\u0005\u00021\fqa\u001e:ji\u0016$v\u000e\u0006\u0002+[\")aN\u001ba\u0001_\u000691\r[1o]\u0016d\u0007C\u00019t\u001b\u0005\t(B\u0001:T\u0003!\u0019\u0007.\u00198oK2\u001c\u0018B\u0001;r\u0005Q9\u0015\r\u001e5fe&twMQ=uK\u000eC\u0017M\u001c8fY\")a\u000f\u0001C\u0001S\u0005A1/\u001a8e'&TX\r\u000b\u0002\u0001qB\u0011\u0011\u0010`\u0007\u0002u*\u00111\u0010B\u0001\u0006kRLGn]\u0005\u0003{j\u0014QB\\8oi\"\u0014X-\u00193tC\u001a,\u0007")
public class MessageSetSend
implements Send {
    private final MessageSet messages;
    private final int errorCode;
    private long sent;
    private long size;
    private final ByteBuffer header;
    private boolean complete;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    public volatile int bitmap$0;

    @Override
    public int writeCompletely(GatheringByteChannel channel) {
        return Send$class.writeCompletely(this, channel);
    }

    @Override
    public void expectIncomplete() {
        Transmission$class.expectIncomplete(this);
    }

    @Override
    public void expectComplete() {
        Transmission$class.expectComplete(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        MessageSetSend messageSetSend = this;
        synchronized (messageSetSend) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public MessageSet messages() {
        return this.messages;
    }

    public int errorCode() {
        return this.errorCode;
    }

    private long sent() {
        return this.sent;
    }

    private void sent_$eq(long l) {
        this.sent = l;
    }

    private long size() {
        return this.size;
    }

    private void size_$eq(long l) {
        this.size = l;
    }

    private ByteBuffer header() {
        return this.header;
    }

    @Override
    public boolean complete() {
        return this.complete;
    }

    public void complete_$eq(boolean bl) {
        this.complete = bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int writeTo(GatheringByteChannel channel) {
        void var2_2;
        this.expectIncomplete();
        int written = 0;
        if (this.header().hasRemaining()) {
            written += channel.write(this.header());
        }
        if (!this.header().hasRemaining()) {
            long fileBytesSent = this.messages().writeTo(channel, this.sent(), this.size() - this.sent());
            written += (int)fileBytesSent;
            this.sent_$eq(this.sent() + fileBytesSent);
        }
        if (this.logger().isTraceEnabled() && channel instanceof SocketChannel) {
            SocketChannel socketChannel = (SocketChannel)channel;
            this.logger().trace(new StringBuilder().append(this.sent()).append((Object)" bytes written to ").append(socketChannel.socket().getRemoteSocketAddress()).append((Object)" expecting to send ").append(BoxesRunTime.boxToLong(this.size())).append((Object)" bytes").toString());
        }
        if (this.sent() >= this.size()) {
            this.complete_$eq(true);
        }
        return (int)var2_2;
    }

    public int sendSize() {
        return (int)this.size() + this.header().capacity();
    }

    public MessageSetSend(MessageSet messages, int errorCode) {
        this.messages = messages;
        this.errorCode = errorCode;
        Logging$class.$init$(this);
        Transmission$class.$init$(this);
        Send$class.$init$(this);
        this.sent = 0L;
        this.size = messages.sizeInBytes();
        this.header = ByteBuffer.allocate(6);
        this.header().putInt((int)this.size() + 2);
        this.header().putShort((short)errorCode);
        this.header().rewind();
        this.complete = false;
    }

    public MessageSetSend(MessageSet messages) {
        this(messages, ErrorMapping$.MODULE$.NoError());
    }

    public MessageSetSend() {
        this(MessageSet$.MODULE$.Empty());
    }
}

