/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.net.InetAddress;
import kafka.cluster.Broker;
import kafka.log.LogManager;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.IZkStateListener;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.log4j.Logger;
import org.apache.zookeeper.Watcher;
import scala.Function0;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001B\u0001\u0003\u0001\u001d\u0011abS1gW\u0006Tvn\\&fKB,'O\u0003\u0002\u0004\t\u000511/\u001a:wKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001\u0002\u0005\f\u0011\u0005%qQ\"\u0001\u0006\u000b\u0005-a\u0011\u0001\u00027b]\u001eT\u0011!D\u0001\u0005U\u00064\u0018-\u0003\u0002\u0010\u0015\t1qJ\u00196fGR\u0004\"!\u0005\u000b\u000e\u0003IQ!a\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005U\u0011\"a\u0002'pO\u001eLgn\u001a\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001f\u0003\u0019\u0019wN\u001c4jOB\u0011q\u0004I\u0007\u0002\u0005%\u0011\u0011E\u0001\u0002\f\u0017\u000647.Y\"p]\u001aLw\r\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u0003)awnZ'b]\u0006<WM\u001d\t\u0003K!j\u0011A\n\u0006\u0003O\u0011\t1\u0001\\8h\u0013\tIcE\u0001\u0006M_\u001el\u0015M\\1hKJDQa\u000b\u0001\u0005\u00021\na\u0001P5oSRtDcA\u0017/_A\u0011q\u0004\u0001\u0005\u0006;)\u0002\rA\b\u0005\u0006G)\u0002\r\u0001\n\u0005\bc\u0001\u0011\r\u0011\"\u00013\u00031\u0011'o\\6fe&#\u0007+\u0019;i+\u0005\u0019\u0004CA\u00055\u0013\t)$B\u0001\u0004TiJLgn\u001a\u0005\u0007o\u0001\u0001\u000b\u0011B\u001a\u0002\u001b\t\u0014xn[3s\u0013\u0012\u0004\u0016\r\u001e5!\u0011\u001dI\u0004\u00011A\u0005\u0002i\n\u0001B_6DY&,g\u000e^\u000b\u0002wA\u0011AhQ\u0007\u0002{)\u0011ahP\u0001\tu.\u001cG.[3oi*\u0011\u0001)Q\u0001\u0007\u0013BJE/Z2\u000b\u0003\t\u000b1a\u001c:h\u0013\t!UH\u0001\u0005[W\u000ec\u0017.\u001a8u\u0011\u001d1\u0005\u00011A\u0005\u0002\u001d\u000bAB_6DY&,g\u000e^0%KF$\"\u0001S&\u0011\u0005]I\u0015B\u0001&\u0019\u0005\u0011)f.\u001b;\t\u000f1+\u0015\u0011!a\u0001w\u0005\u0019\u0001\u0010J\u0019\t\r9\u0003\u0001\u0015)\u0003<\u0003%Q8n\u00117jK:$\b\u0005C\u0004Q\u0001\u0001\u0007I\u0011A)\u0002\rQ|\u0007/[2t+\u0005\u0011\u0006cA*\\=:\u0011A+\u0017\b\u0003+bk\u0011A\u0016\u0006\u0003/\u001a\ta\u0001\u0010:p_Rt\u0014\"A\r\n\u0005iC\u0012a\u00029bG.\fw-Z\u0005\u00039v\u0013A\u0001T5ti*\u0011!\f\u0007\t\u0003?\nt!a\u00061\n\u0005\u0005D\u0012A\u0002)sK\u0012,g-\u0003\u00026G*\u0011\u0011\r\u0007\u0005\bK\u0002\u0001\r\u0011\"\u0001g\u0003)!x\u000e]5dg~#S-\u001d\u000b\u0003\u0011\u001eDq\u0001\u00143\u0002\u0002\u0003\u0007!\u000b\u0003\u0004j\u0001\u0001\u0006KAU\u0001\bi>\u0004\u0018nY:!\u0011\u001dY\u0007A1A\u0005\u00021\fA\u0001\\8dWV\t\u0001\u0002\u0003\u0004o\u0001\u0001\u0006I\u0001C\u0001\u0006Y>\u001c7\u000e\t\u0005\u0006a\u0002!\t!]\u0001\bgR\f'\u000f^;q)\u0005A\u0005\"B:\u0001\t\u0003\t\u0018A\u0005:fO&\u001cH/\u001a:Ce>\\WM]%o5.DQ!\u001e\u0001\u0005\u0002Y\f\u0011C]3hSN$XM\u001d+pa&\u001c\u0017J\u001c.l)\tAu\u000fC\u0003yi\u0002\u0007a,A\u0003u_BL7\rC\u0003{\u0001\u0011\u000510A\rsK\u001eL7\u000f^3s)>\u0004\u0018nY%o5.Le\u000e^3s]\u0006dGC\u0001%}\u0011\u0015A\u0018\u00101\u0001_\r\u0011q\b\u0001A@\u0003+M+7o]5p]\u0016C\b/\u001b:f\u0019&\u001cH/\u001a8feN)Q\u0010CA\u0001-A\u0019A(a\u0001\n\u0007\u0005\u0015QH\u0001\tJ5.\u001cF/\u0019;f\u0019&\u001cH/\u001a8fe\"11& C\u0001\u0003\u0013!\"!a\u0003\u0011\u0007\u00055Q0D\u0001\u0001\u0011\u001d\t\t\" C\u0001\u0003'\t!\u0003[1oI2,7\u000b^1uK\u000eC\u0017M\\4fIR\u0019\u0001*!\u0006\t\u0011\u0005]\u0011q\u0002a\u0001\u00033\tQa\u001d;bi\u0016\u0004B!a\u0007\u0002>9!\u0011QDA\u001c\u001d\u0011\ty\"!\r\u000f\t\u0005\u0005\u00121\u0006\b\u0005\u0003G\t9CD\u0002V\u0003KI\u0011AQ\u0005\u0004\u0003S\t\u0015AB1qC\u000eDW-\u0003\u0003\u0002.\u0005=\u0012!\u0003>p_.,W\r]3s\u0015\r\tI#Q\u0005\u0005\u0003g\t)$A\u0004XCR\u001c\u0007.\u001a:\u000b\t\u00055\u0012qF\u0005\u0005\u0003s\tY$A\u0003Fm\u0016tGO\u0003\u0003\u00024\u0005U\u0012\u0002BA \u0003\u0003\u00121bS3fa\u0016\u00148\u000b^1uK*!\u0011\u0011HA\u001eQ\u0019\ty!!\u0012\u0002LA\u0019q#a\u0012\n\u0007\u0005%\u0003D\u0001\u0004uQJ|wo]\u0012\u0003\u0003\u001b\u00022aUA(\u0013\r\t\t&\u0018\u0002\n\u000bb\u001cW\r\u001d;j_:Da!!\u0016~\t\u0003\t\u0018\u0001\u00055b]\u0012dWMT3x'\u0016\u001c8/[8oQ\u0019\t\u0019&!\u0012\u0002L!1\u00111\f\u0001\u0005\u0002E\fQa\u00197pg\u0016\u0004")
public class KafkaZooKeeper
implements Logging {
    public final KafkaConfig kafka$server$KafkaZooKeeper$$config;
    private final LogManager logManager;
    private final String brokerIdPath;
    private ZkClient zkClient;
    private List<String> topics;
    private final Object lock;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        KafkaZooKeeper kafkaZooKeeper = this;
        synchronized (kafkaZooKeeper) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public String brokerIdPath() {
        return this.brokerIdPath;
    }

    public ZkClient zkClient() {
        return this.zkClient;
    }

    public void zkClient_$eq(ZkClient zkClient) {
        this.zkClient = zkClient;
    }

    public List<String> topics() {
        return this.topics;
    }

    public void topics_$eq(List<String> list2) {
        this.topics = list2;
    }

    public Object lock() {
        return this.lock;
    }

    public void startup() {
        this.info((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final KafkaZooKeeper $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"connecting to ZK: ").append((Object)this.$outer.kafka$server$KafkaZooKeeper$$config.zkConnect()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.zkClient_$eq(new ZkClient(this.kafka$server$KafkaZooKeeper$$config.zkConnect(), this.kafka$server$KafkaZooKeeper$$config.zkSessionTimeoutMs(), this.kafka$server$KafkaZooKeeper$$config.zkConnectionTimeoutMs(), ZKStringSerializer$.MODULE$));
        this.zkClient().subscribeStateChanges(new SessionExpireListener(this));
    }

    public void registerBrokerInZk() {
        this.info((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final KafkaZooKeeper $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Registering broker ").append((Object)this.$outer.brokerIdPath()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        String hostName = this.kafka$server$KafkaZooKeeper$$config.hostName() == null ? InetAddress.getLocalHost().getHostAddress() : this.kafka$server$KafkaZooKeeper$$config.hostName();
        String creatorId = new StringBuilder().append((Object)hostName).append((Object)"-").append(BoxesRunTime.boxToLong(System.currentTimeMillis())).toString();
        Broker broker$1 = new Broker(this.kafka$server$KafkaZooKeeper$$config.brokerId(), creatorId, hostName, this.kafka$server$KafkaZooKeeper$$config.port());
        try {
            ZkUtils$.MODULE$.createEphemeralPathExpectConflict(this.zkClient(), this.brokerIdPath(), broker$1.getZKString());
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            throw new RuntimeException(new StringBuilder().append((Object)"A broker is already registered on the path ").append((Object)this.brokerIdPath()).append((Object)". This probably ").append((Object)"indicates that you either have configured a brokerid that is already in use, or ").append((Object)"else you have shutdown this broker and restarted it faster than the zookeeper ").append((Object)"timeout so it appears to be re-registering.").toString());
        }
        this.info((Function0<String>)((Object)new Serializable(this, broker$1){
            public static final long serialVersionUID;
            private final KafkaZooKeeper $outer;
            private final Broker broker$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Registering broker ").append((Object)this.$outer.brokerIdPath()).append((Object)" succeeded with ").append(this.broker$1).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.broker$1 = broker;
            }
        }));
    }

    public void registerTopicInZk(String topic) {
        this.registerTopicInZkInternal(topic);
        Object object = this.lock();
        synchronized (object) {
            this.topics_$eq(this.topics().$colon$colon(topic));
            return;
        }
    }

    public void registerTopicInZkInternal(String topic) {
        String brokerTopicPath$1 = new StringBuilder().append((Object)ZkUtils$.MODULE$.BrokerTopicsPath()).append((Object)"/").append((Object)topic).append((Object)"/").append(BoxesRunTime.boxToInteger(this.kafka$server$KafkaZooKeeper$$config.brokerId())).toString();
        int numParts$1 = BoxesRunTime.unboxToInt(this.logManager.getTopicPartitionsMap().getOrElse(topic, new Serializable(this){
            public static final long serialVersionUID;
            private final KafkaZooKeeper $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.$outer.kafka$server$KafkaZooKeeper$$config.numPartitions();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.info((Function0<String>)((Object)new Serializable(this, brokerTopicPath$1, numParts$1){
            public static final long serialVersionUID;
            private final String brokerTopicPath$1;
            private final int numParts$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Begin registering broker topic ").append((Object)this.brokerTopicPath$1).append((Object)" with ").append((Object)((Object)BoxesRunTime.boxToInteger(this.numParts$1)).toString()).append((Object)" partitions").toString();
            }
            {
                this.brokerTopicPath$1 = string2;
                this.numParts$1 = n;
            }
        }));
        ZkUtils$.MODULE$.createEphemeralPathExpectConflict(this.zkClient(), brokerTopicPath$1, ((Object)BoxesRunTime.boxToInteger(numParts$1)).toString());
        this.info((Function0<String>)((Object)new Serializable(this, brokerTopicPath$1){
            public static final long serialVersionUID;
            private final String brokerTopicPath$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"End registering broker topic ").append((Object)this.brokerTopicPath$1).toString();
            }
            {
                this.brokerTopicPath$1 = string2;
            }
        }));
    }

    public void close() {
        if (this.zkClient() != null) {
            this.info((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Closing zookeeper client...";
                }
            }));
            this.zkClient().close();
        }
    }

    public KafkaZooKeeper(KafkaConfig config, LogManager logManager) {
        this.kafka$server$KafkaZooKeeper$$config = config;
        this.logManager = logManager;
        Logging$class.$init$(this);
        this.brokerIdPath = new StringBuilder().append((Object)ZkUtils$.MODULE$.BrokerIdsPath()).append((Object)"/").append(BoxesRunTime.boxToInteger(config.brokerId())).toString();
        this.zkClient = null;
        this.topics = Nil$.MODULE$;
        this.lock = new Object();
    }

    public class SessionExpireListener
    implements IZkStateListener,
    ScalaObject {
        public final KafkaZooKeeper $outer;

        public void handleStateChanged(Watcher.Event.KeeperState state) throws Exception {
        }

        public void handleNewSession() throws Exception {
            this.kafka$server$KafkaZooKeeper$SessionExpireListener$$$outer().info((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID;
                private final SessionExpireListener $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"re-registering broker info in ZK for broker ").append(BoxesRunTime.boxToInteger(this.$outer.kafka$server$KafkaZooKeeper$SessionExpireListener$$$outer().kafka$server$KafkaZooKeeper$$config.brokerId())).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }));
            this.kafka$server$KafkaZooKeeper$SessionExpireListener$$$outer().registerBrokerInZk();
            Object object = this.kafka$server$KafkaZooKeeper$SessionExpireListener$$$outer().lock();
            synchronized (object) {
                this.kafka$server$KafkaZooKeeper$SessionExpireListener$$$outer().info((Function0<String>)((Object)new Serializable(this){
                    public static final long serialVersionUID;
                    private final SessionExpireListener $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"re-registering broker topics in ZK for broker ").append(BoxesRunTime.boxToInteger(this.$outer.kafka$server$KafkaZooKeeper$SessionExpireListener$$$outer().kafka$server$KafkaZooKeeper$$config.brokerId())).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
                this.kafka$server$KafkaZooKeeper$SessionExpireListener$$$outer().topics().foreach(new Serializable(this){
                    public static final long serialVersionUID;
                    private final SessionExpireListener $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(String topic) {
                        this.$outer.kafka$server$KafkaZooKeeper$SessionExpireListener$$$outer().registerTopicInZkInternal(topic);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                this.kafka$server$KafkaZooKeeper$SessionExpireListener$$$outer().info((Function0<String>)((Object)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return "done re-registering broker";
                    }
                }));
                return;
            }
        }

        public KafkaZooKeeper kafka$server$KafkaZooKeeper$SessionExpireListener$$$outer() {
            return this.$outer;
        }

        public SessionExpireListener(KafkaZooKeeper $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }
    }
}

