/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.log.LogManager;
import kafka.network.Receive;
import kafka.network.Send;
import kafka.network.SocketServer;
import kafka.network.SocketServerStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRequestHandlers;
import kafka.utils.KafkaScheduler;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Mx4jLoader$;
import kafka.utils.SystemTime$;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001B\u0001\u0003\u0001\u001d\u00111bS1gW\u0006\u001cVM\u001d<fe*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001\u0011A1\u0002CA\u0005\u000f\u001b\u0005Q!BA\u0006\r\u0003\u0011a\u0017M\\4\u000b\u00035\tAA[1wC&\u0011qB\u0003\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005E!R\"\u0001\n\u000b\u0005M!\u0011!B;uS2\u001c\u0018BA\u000b\u0013\u0005\u001daunZ4j]\u001e\u0004\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u00111bU2bY\u0006|%M[3di\"AQ\u0004\u0001BC\u0002\u0013\u0005a$\u0001\u0004d_:4\u0017nZ\u000b\u0002?A\u0011\u0001%I\u0007\u0002\u0005%\u0011!E\u0001\u0002\f\u0017\u000647.Y\"p]\u001aLw\r\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003 \u0003\u001d\u0019wN\u001c4jO\u0002BQA\n\u0001\u0005\u0002\u001d\na\u0001P5oSRtDC\u0001\u0015*!\t\u0001\u0003\u0001C\u0003\u001eK\u0001\u0007q\u0004C\u0004,\u0001\t\u0007I\u0011\u0001\u0017\u0002'\rcU)\u0011(`'\"+F\u000bR(X\u001d~3\u0015\nT#\u0016\u00035\u0002\"!\u0003\u0018\n\u0005=R!AB*ue&tw\r\u0003\u00042\u0001\u0001\u0006I!L\u0001\u0015\u00072+\u0015IT0T\u0011V#FiT,O?\u001aKE*\u0012\u0011\t\u000fM\u0002\u0001\u0019!C\u0005i\u0005q\u0011n]*ikR$\u0018N\\4E_^tW#A\u001b\u0011\u0005YjT\"A\u001c\u000b\u0005aJ\u0014AB1u_6L7M\u0003\u0002;w\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005qb\u0011\u0001B;uS2L!AP\u001c\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0011\u001d\u0001\u0005\u00011A\u0005\n\u0005\u000b!#[:TQV$H/\u001b8h\t><hn\u0018\u0013fcR\u0011!)\u0012\t\u0003/\rK!\u0001\u0012\r\u0003\tUs\u0017\u000e\u001e\u0005\b\r~\n\t\u00111\u00016\u0003\rAH%\r\u0005\u0007\u0011\u0002\u0001\u000b\u0015B\u001b\u0002\u001f%\u001c8\u000b[;ui&tw\rR8x]\u0002BqA\u0013\u0001A\u0002\u0013%1*A\u0007tQV$Hm\\<o\u0019\u0006$8\r[\u000b\u0002\u0019B\u0011QJT\u0007\u0002s%\u0011q*\u000f\u0002\u000f\u0007>,h\u000e\u001e#po:d\u0015\r^2i\u0011\u001d\t\u0006\u00011A\u0005\nI\u000b\u0011c\u001d5vi\u0012|wO\u001c'bi\u000eDw\fJ3r)\t\u00115\u000bC\u0004G!\u0006\u0005\t\u0019\u0001'\t\rU\u0003\u0001\u0015)\u0003M\u00039\u0019\b.\u001e;e_^tG*\u0019;dQ\u0002Bqa\u0016\u0001C\u0002\u0013%A&\u0001\bti\u0006$8/\u0014\"fC:t\u0015-\\3\t\re\u0003\u0001\u0015!\u0003.\u0003=\u0019H/\u0019;t\u001b\n+\u0017M\u001c(b[\u0016\u0004\u0003bB.\u0001\u0001\u0004%\t\u0001X\u0001\rg>\u001c7.\u001a;TKJ4XM]\u000b\u0002;B\u0011a,Y\u0007\u0002?*\u0011\u0001\rB\u0001\b]\u0016$xo\u001c:l\u0013\t\u0011wL\u0001\u0007T_\u000e\\W\r^*feZ,'\u000fC\u0004e\u0001\u0001\u0007I\u0011A3\u0002!M|7m[3u'\u0016\u0014h/\u001a:`I\u0015\fHC\u0001\"g\u0011\u001d15-!AA\u0002uCa\u0001\u001b\u0001!B\u0013i\u0016!D:pG.,GoU3sm\u0016\u0014\b\u0005C\u0004k\u0001\t\u0007I\u0011A6\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014X#\u00017\u0011\u0005Ei\u0017B\u00018\u0013\u00059Y\u0015MZ6b'\u000eDW\rZ;mKJDa\u0001\u001d\u0001!\u0002\u0013a\u0017AC:dQ\u0016$W\u000f\\3sA!9!\u000f\u0001a\u0001\n\u0013\u0019\u0018A\u00037pO6\u000bg.Y4feV\tA\u000f\u0005\u0002vq6\taO\u0003\u0002x\t\u0005\u0019An\\4\n\u0005e4(A\u0003'pO6\u000bg.Y4fe\"91\u0010\u0001a\u0001\n\u0013a\u0018A\u00047pO6\u000bg.Y4fe~#S-\u001d\u000b\u0003\u0005vDqA\u0012>\u0002\u0002\u0003\u0007A\u000f\u0003\u0004\u0000\u0001\u0001\u0006K\u0001^\u0001\fY><W*\u00198bO\u0016\u0014\b\u0005C\u0004\u0002\u0004\u0001!\t!!\u0002\u0002\u000fM$\u0018M\u001d;vaR\t!\tC\u0004\u0002\n\u0001!\t!!\u0002\u0002\u0011MDW\u000f\u001e3po:Dq!!\u0004\u0001\t\u0003\t)!A\u0007bo\u0006LGo\u00155vi\u0012|wO\u001c\u0005\b\u0003#\u0001A\u0011AA\n\u000359W\r\u001e'pO6\u000bg.Y4feR\tA\u000fC\u0004\u0002\u0018\u0001!\t!!\u0007\u0002\u0011\u001d,Go\u0015;biN$\"!a\u0007\u0011\u0007y\u000bi\"C\u0002\u0002 }\u0013\u0011cU8dW\u0016$8+\u001a:wKJ\u001cF/\u0019;t\u0001")
public class KafkaServer
implements Logging {
    private final KafkaConfig config;
    private final String CLEAN_SHUTDOWN_FILE;
    private AtomicBoolean isShuttingDown;
    private CountDownLatch shutdownLatch;
    private final String statsMBeanName;
    private SocketServer socketServer;
    private final KafkaScheduler scheduler;
    private LogManager logManager;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        KafkaServer kafkaServer = this;
        synchronized (kafkaServer) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public KafkaConfig config() {
        return this.config;
    }

    public String CLEAN_SHUTDOWN_FILE() {
        return this.CLEAN_SHUTDOWN_FILE;
    }

    private AtomicBoolean isShuttingDown() {
        return this.isShuttingDown;
    }

    private void isShuttingDown_$eq(AtomicBoolean atomicBoolean) {
        this.isShuttingDown = atomicBoolean;
    }

    private CountDownLatch shutdownLatch() {
        return this.shutdownLatch;
    }

    private void shutdownLatch_$eq(CountDownLatch countDownLatch) {
        this.shutdownLatch = countDownLatch;
    }

    private String statsMBeanName() {
        return this.statsMBeanName;
    }

    public SocketServer socketServer() {
        return this.socketServer;
    }

    public void socketServer_$eq(SocketServer socketServer) {
        this.socketServer = socketServer;
    }

    public KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private LogManager logManager() {
        return this.logManager;
    }

    private void logManager_$eq(LogManager logManager) {
        this.logManager = logManager;
    }

    public void startup() {
        Serializable serializable2;
        this.info((Function0<String>)((Object)new scala.Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Starting Kafka server...";
            }
        }));
        this.isShuttingDown_$eq(new AtomicBoolean(false));
        this.shutdownLatch_$eq(new CountDownLatch(1));
        boolean needRecovery = true;
        File cleanShutDownFile = new File(new File(this.config().logDir()), this.CLEAN_SHUTDOWN_FILE());
        if (cleanShutDownFile.exists()) {
            needRecovery = false;
            serializable2 = BoxesRunTime.boxToBoolean(cleanShutDownFile.delete());
        } else {
            serializable2 = BoxedUnit.UNIT;
        }
        this.logManager_$eq(new LogManager(this.config(), this.scheduler(), SystemTime$.MODULE$, 60000L * (long)this.config().logCleanupIntervalMinutes(), 3600000L * (long)this.config().logRetentionHours(), needRecovery));
        KafkaRequestHandlers handlers$1 = new KafkaRequestHandlers(this.logManager());
        this.socketServer_$eq(new SocketServer(this.config().port(), this.config().numThreads(), this.config().monitoringPeriodSecs(), (Function2<Object, Receive, Function1<Receive, Option<Send>>>)((Object)new scala.Serializable(this, handlers$1){
            public static final long serialVersionUID;
            private final KafkaRequestHandlers handlers$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Function1<Receive, Option<Send>> apply(short s, Receive receive2) {
                return this.handlers$1.handlerFor(s, receive2);
            }
            {
                this.handlers$1 = kafkaRequestHandlers;
            }
        }), this.config().socketSendBuffer(), this.config().socketReceiveBuffer(), this.config().maxSocketRequestSize()));
        Utils$.MODULE$.registerMBean(this.socketServer().stats(), this.statsMBeanName());
        this.socketServer().startup();
        Mx4jLoader$.MODULE$.maybeLoad();
        this.logManager().startup();
        this.info((Function0<String>)((Object)new scala.Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Kafka server started.";
            }
        }));
    }

    public void shutdown() {
        boolean canShutdown = this.isShuttingDown().compareAndSet(false, true);
        if (canShutdown) {
            this.info((Function0<String>)((Object)new scala.Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Shutting down Kafka server";
                }
            }));
            this.scheduler().shutdown();
            if (this.socketServer() != null) {
                this.socketServer().shutdown();
            }
            Utils$.MODULE$.unregisterMBean(this.statsMBeanName());
            if (this.logManager() != null) {
                this.logManager().close();
            }
            File cleanShutDownFile = new File(new File(this.config().logDir()), this.CLEAN_SHUTDOWN_FILE());
            cleanShutDownFile.createNewFile();
            this.shutdownLatch().countDown();
            this.info((Function0<String>)((Object)new scala.Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Kafka server shut down completed";
                }
            }));
        }
    }

    public void awaitShutdown() {
        this.shutdownLatch().await();
    }

    public LogManager getLogManager() {
        return this.logManager();
    }

    public SocketServerStats getStats() {
        return this.socketServer().stats();
    }

    public KafkaServer(KafkaConfig config) {
        this.config = config;
        Logging$class.$init$(this);
        this.CLEAN_SHUTDOWN_FILE = ".kafka_cleanshutdown";
        this.isShuttingDown = new AtomicBoolean(false);
        this.shutdownLatch = new CountDownLatch(1);
        this.statsMBeanName = "kafka:type=kafka.SocketServerStats";
        this.socketServer = null;
        this.scheduler = new KafkaScheduler(1, "kafka-logcleaner-", false);
        this.logManager = null;
    }
}

