/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.api.FetchRequest;
import kafka.api.FetchRequest$;
import kafka.api.MultiFetchRequest;
import kafka.api.MultiFetchRequest$;
import kafka.api.MultiProducerRequest;
import kafka.api.MultiProducerRequest$;
import kafka.api.OffsetArraySend;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.api.ProducerRequest;
import kafka.api.ProducerRequest$;
import kafka.api.RequestKeys$;
import kafka.common.ErrorMapping$;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet$;
import kafka.network.Receive;
import kafka.network.Send;
import kafka.server.BrokerTopicStat$;
import kafka.server.MessageSetSend;
import kafka.server.MultiMessageSetSend;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.SystemTime$;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005ua!B\u0001\u0003\u0001\u00111!\u0001F&bM.\f'+Z9vKN$\b*\u00198eY\u0016\u00148O\u0003\u0002\u0004\t\u000511/\u001a:wKJT\u0011!B\u0001\u0006W\u000647.Y\n\u0005\u0001\u001dyQ\u0003\u0005\u0002\t\u001b5\t\u0011B\u0003\u0002\u000b\u0017\u0005!A.\u00198h\u0015\u0005a\u0011\u0001\u00026bm\u0006L!AD\u0005\u0003\r=\u0013'.Z2u!\t\u00012#D\u0001\u0012\u0015\t\u0011B!A\u0003vi&d7/\u0003\u0002\u0015#\t9Aj\\4hS:<\u0007C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"aC*dC2\fwJ\u00196fGRD\u0001\u0002\b\u0001\u0003\u0006\u0004%\tAH\u0001\u000bY><W*\u00198bO\u0016\u00148\u0001A\u000b\u0002?A\u0011\u0001eI\u0007\u0002C)\u0011!\u0005B\u0001\u0004Y><\u0017B\u0001\u0013\"\u0005)aunZ'b]\u0006<WM\u001d\u0005\tM\u0001\u0011\t\u0011)A\u0005?\u0005YAn\\4NC:\fw-\u001a:!\u0011\u0015A\u0003\u0001\"\u0001*\u0003\u0019a\u0014N\\5u}Q\u0011!\u0006\f\t\u0003W\u0001i\u0011A\u0001\u0005\u00069\u001d\u0002\ra\b\u0005\b]\u0001\u0011\r\u0011\"\u00030\u00035\u0011X-];fgRdunZ4feV\t\u0001\u0007\u0005\u00022q5\t!G\u0003\u00024i\u0005)An\\45U*\u0011QGN\u0001\u0007CB\f7\r[3\u000b\u0003]\n1a\u001c:h\u0013\tI$G\u0001\u0004M_\u001e<WM\u001d\u0005\u0007w\u0001\u0001\u000b\u0011\u0002\u0019\u0002\u001dI,\u0017/^3ti2{wmZ3sA!)Q\b\u0001C\u0001}\u0005Q\u0001.\u00198eY\u0016\u0014hi\u001c:\u0015\u0007}Je\n\u0005\u0002A\r:\u0011\u0011\tR\u0007\u0002\u0005*\u00111\tB\u0001\b]\u0016$xo\u001c:l\u0013\t)%)A\u0004IC:$G.\u001a:\n\u0005\u001dC%a\u0002%b]\u0012dWM\u001d\u0006\u0003\u000b\nCQA\u0013\u001fA\u0002-\u000bQB]3rk\u0016\u001cH\u000fV=qK&#\u0007C\u0001\fM\u0013\tiuCA\u0003TQ>\u0014H\u000fC\u0003Py\u0001\u0007\u0001+A\u0004sKF,Xm\u001d;\u0011\u0005\u0005\u000b\u0016B\u0001*C\u0005\u001d\u0011VmY3jm\u0016DQ\u0001\u0016\u0001\u0005\u0002U\u000bQ\u0003[1oI2,\u0007K]8ek\u000e,'OU3rk\u0016\u001cH\u000f\u0006\u0002W9B\u0019acV-\n\u0005a;\"AB(qi&|g\u000e\u0005\u0002B5&\u00111L\u0011\u0002\u0005'\u0016tG\rC\u0003^'\u0002\u0007\u0001+A\u0004sK\u000e,\u0017N^3\t\u000b}\u0003A\u0011\u00011\u00025!\fg\u000e\u001a7f\u001bVdG/\u001b)s_\u0012,8-\u001a:SKF,Xm\u001d;\u0015\u0005Y\u000b\u0007\"B/_\u0001\u0004\u0001\u0006\"\u0002+\u0001\t\u0013\u0019Gc\u00013h]B\u0011a#Z\u0005\u0003M^\u0011A\u0001T8oO\")qJ\u0019a\u0001QB\u0011\u0011\u000e\\\u0007\u0002U*\u00111\u000eB\u0001\u0004CBL\u0017BA7k\u0005=\u0001&o\u001c3vG\u0016\u0014(+Z9vKN$\b\"B8c\u0001\u0004\u0001\u0018A\u0005:fcV,7\u000f\u001e%b]\u0012dWM\u001d(b[\u0016\u0004\"!\u001d;\u000f\u0005Y\u0011\u0018BA:\u0018\u0003\u0019\u0001&/\u001a3fM&\u0011QO\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005M<\u0002\"\u0002=\u0001\t\u0003I\u0018A\u00055b]\u0012dWMR3uG\"\u0014V-];fgR$\"A\u0016>\t\u000b=;\b\u0019\u0001)\t\u000bq\u0004A\u0011A?\u0002/!\fg\u000e\u001a7f\u001bVdG/\u001b$fi\u000eD'+Z9vKN$HC\u0001,\u007f\u0011\u0015y5\u00101\u0001Q\u0011\u001d\t\t\u0001\u0001C\u0005\u0003\u0007\taB]3bI6+7o]1hKN+G\u000f\u0006\u0003\u0002\u0006\u0005-\u0001cA\u0016\u0002\b%\u0019\u0011\u0011\u0002\u0002\u0003\u001d5+7o]1hKN+GoU3oI\"9\u0011QB@A\u0002\u0005=\u0011\u0001\u00044fi\u000eD'+Z9vKN$\bcA5\u0002\u0012%\u0019\u00111\u00036\u0003\u0019\u0019+Go\u00195SKF,Xm\u001d;\t\u000f\u0005]\u0001\u0001\"\u0001\u0002\u001a\u0005\u0019\u0002.\u00198eY\u0016|eMZ:fiJ+\u0017/^3tiR\u0019a+a\u0007\t\r=\u000b)\u00021\u0001Q\u0001")
public class KafkaRequestHandlers
implements Logging {
    private final LogManager logManager;
    private final Logger kafka$server$KafkaRequestHandlers$$requestLogger;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        KafkaRequestHandlers kafkaRequestHandlers = this;
        synchronized (kafkaRequestHandlers) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public final Logger kafka$server$KafkaRequestHandlers$$requestLogger() {
        return this.kafka$server$KafkaRequestHandlers$$requestLogger;
    }

    public Function1<Receive, Option<Send>> handlerFor(short requestTypeId, Receive request) {
        block7: {
            scala.Serializable serializable2;
            block3: {
                short s;
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                s = requestTypeId;
                                if (!BoxesRunTime.equals(BoxesRunTime.boxToShort(RequestKeys$.MODULE$.Produce()), BoxesRunTime.boxToShort(s))) break block2;
                                serializable2 = new scala.Serializable(this){
                                    public static final long serialVersionUID;
                                    private final KafkaRequestHandlers $outer;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final Option<Send> apply(Receive receive2) {
                                        return this.$outer.handleProducerRequest(receive2);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                    }
                                };
                                break block3;
                            }
                            if (!BoxesRunTime.equals(BoxesRunTime.boxToShort(RequestKeys$.MODULE$.Fetch()), BoxesRunTime.boxToShort(s))) break block4;
                            serializable2 = new scala.Serializable(this){
                                public static final long serialVersionUID;
                                private final KafkaRequestHandlers $outer;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final Option<Send> apply(Receive receive2) {
                                    return this.$outer.handleFetchRequest(receive2);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            };
                            break block3;
                        }
                        if (!BoxesRunTime.equals(BoxesRunTime.boxToShort(RequestKeys$.MODULE$.MultiFetch()), BoxesRunTime.boxToShort(s))) break block5;
                        serializable2 = new scala.Serializable(this){
                            public static final long serialVersionUID;
                            private final KafkaRequestHandlers $outer;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final Option<Send> apply(Receive receive2) {
                                return this.$outer.handleMultiFetchRequest(receive2);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        };
                        break block3;
                    }
                    if (!BoxesRunTime.equals(BoxesRunTime.boxToShort(RequestKeys$.MODULE$.MultiProduce()), BoxesRunTime.boxToShort(s))) break block6;
                    serializable2 = new scala.Serializable(this){
                        public static final long serialVersionUID;
                        private final KafkaRequestHandlers $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final Option<Send> apply(Receive receive2) {
                            return this.$outer.handleMultiProducerRequest(receive2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    };
                    break block3;
                }
                if (!BoxesRunTime.equals(BoxesRunTime.boxToShort(RequestKeys$.MODULE$.Offsets()), BoxesRunTime.boxToShort(s))) break block7;
                serializable2 = new scala.Serializable(this){
                    public static final long serialVersionUID;
                    private final KafkaRequestHandlers $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Option<Send> apply(Receive receive2) {
                        return this.$outer.handleOffsetRequest(receive2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                };
            }
            return serializable2;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)"No mapping found for handler id ").append(BoxesRunTime.boxToShort(requestTypeId)).toString());
    }

    public Option<Send> handleProducerRequest(Receive receive2) {
        long sTime$1 = SystemTime$.MODULE$.milliseconds();
        ProducerRequest request = ProducerRequest$.MODULE$.readFrom(receive2.buffer());
        if (this.kafka$server$KafkaRequestHandlers$$requestLogger().isTraceEnabled()) {
            this.kafka$server$KafkaRequestHandlers$$requestLogger().trace(new StringBuilder().append((Object)"Producer request ").append((Object)request.toString()).toString());
        }
        this.kafka$server$KafkaRequestHandlers$$handleProducerRequest(request, "ProduceRequest");
        this.debug((Function0<String>)((Object)new scala.Serializable(this, sTime$1){
            public static final long serialVersionUID;
            private final long sTime$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"kafka produce time ").append(BoxesRunTime.boxToLong(SystemTime$.MODULE$.milliseconds() - this.sTime$1)).append((Object)" ms").toString();
            }
            {
                this.sTime$1 = l;
            }
        }));
        return None$.MODULE$;
    }

    public Option<Send> handleMultiProducerRequest(Receive receive2) {
        MultiProducerRequest request = MultiProducerRequest$.MODULE$.readFrom(receive2.buffer());
        if (this.kafka$server$KafkaRequestHandlers$$requestLogger().isTraceEnabled()) {
            this.kafka$server$KafkaRequestHandlers$$requestLogger().trace(new StringBuilder().append((Object)"Multiproducer request ").append((Object)request.toString()).toString());
        }
        Predef$.MODULE$.refArrayOps((Object[])request.produces()).map(new scala.Serializable(this){
            public static final long serialVersionUID;
            private final KafkaRequestHandlers $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final long apply(ProducerRequest producerRequest) {
                return this.$outer.kafka$server$KafkaRequestHandlers$$handleProducerRequest(producerRequest, "MultiProducerRequest");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(Manifest$.MODULE$.Long()));
        return None$.MODULE$;
    }

    public final long kafka$server$KafkaRequestHandlers$$handleProducerRequest(ProducerRequest request$1, String requestHandlerName$1) {
        int partition$1 = request$1.getTranslatedPartition((Function1<String, Object>)((Object)new scala.Serializable(this){
            public static final long serialVersionUID;
            private final KafkaRequestHandlers $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(String string2) {
                return this.$outer.logManager().chooseRandomPartition(string2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        long exceptionResult1 = 0L;
        try {
            this.logManager().getOrCreateLog(request$1.topic(), partition$1).append(request$1.messages());
            this.trace((Function0<String>)((Object)new scala.Serializable(this, request$1){
                public static final long serialVersionUID;
                private final ProducerRequest request$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append(this.request$1.messages().sizeInBytes()).append((Object)" bytes written to logs.").toString();
                }
                {
                    this.request$1 = producerRequest;
                }
            }));
            request$1.messages().foreach(new scala.Serializable(this){
                public static final long serialVersionUID;
                private final KafkaRequestHandlers $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(MessageAndOffset m$1) {
                    this.$outer.trace((Function0<String>)((Object)new scala.Serializable(this, m$1){
                        public static final long serialVersionUID;
                        private final MessageAndOffset m$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("wrote message %s to disk").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.m$1.message().checksum())}));
                        }
                        {
                            this.m$1 = messageAndOffset;
                        }
                    }));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            BrokerTopicStat$.MODULE$.getBrokerTopicStat(request$1.topic()).recordBytesIn(request$1.messages().sizeInBytes());
            exceptionResult1 = BrokerTopicStat$.MODULE$.getBrokerAllTopicStat().recordBytesIn(request$1.messages().sizeInBytes());
            return exceptionResult1;
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)((Object)new scala.Serializable(this, request$1, requestHandlerName$1, partition$1){
                public static final long serialVersionUID;
                private final ProducerRequest request$1;
                private final String requestHandlerName$1;
                private final int partition$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Error processing ").append((Object)this.requestHandlerName$1).append((Object)" on ").append((Object)this.request$1.topic()).append((Object)":").append(BoxesRunTime.boxToInteger(this.partition$1)).toString();
                }
                {
                    this.request$1 = producerRequest;
                    this.requestHandlerName$1 = string2;
                    this.partition$1 = n;
                }
            }), (Function0<Throwable>)((Object)new scala.Serializable(this, throwable){
                public static final long serialVersionUID;
                private final Throwable e$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Throwable apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = throwable;
                }
            }));
            BrokerTopicStat$.MODULE$.getBrokerTopicStat(request$1.topic()).recordFailedProduceRequest();
            BrokerTopicStat$.MODULE$.getBrokerAllTopicStat().recordFailedProduceRequest();
            throw throwable;
        }
    }

    public Option<Send> handleFetchRequest(Receive request) {
        FetchRequest fetchRequest = FetchRequest$.MODULE$.readFrom(request.buffer());
        if (this.kafka$server$KafkaRequestHandlers$$requestLogger().isTraceEnabled()) {
            this.kafka$server$KafkaRequestHandlers$$requestLogger().trace(new StringBuilder().append((Object)"Fetch request ").append((Object)fetchRequest.toString()).toString());
        }
        return new Some<Send>(this.kafka$server$KafkaRequestHandlers$$readMessageSet(fetchRequest));
    }

    public Option<Send> handleMultiFetchRequest(Receive request) {
        MultiFetchRequest multiFetchRequest = MultiFetchRequest$.MODULE$.readFrom(request.buffer());
        if (this.kafka$server$KafkaRequestHandlers$$requestLogger().isTraceEnabled()) {
            this.kafka$server$KafkaRequestHandlers$$requestLogger().trace("Multifetch request");
        }
        Predef$.MODULE$.refArrayOps((Object[])multiFetchRequest.fetches()).foreach(new scala.Serializable(this){
            public static final long serialVersionUID;
            private final KafkaRequestHandlers $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(FetchRequest req) {
                this.$outer.kafka$server$KafkaRequestHandlers$$requestLogger().trace(req.toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        List<MessageSetSend> responses = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])multiFetchRequest.fetches()).map(new scala.Serializable(this){
            public static final long serialVersionUID;
            private final KafkaRequestHandlers $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final MessageSetSend apply(FetchRequest fetch) {
                return this.$outer.kafka$server$KafkaRequestHandlers$$readMessageSet(fetch);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(MessageSetSend.class)))).toList();
        return new Some<Send>(new MultiMessageSetSend(responses));
    }

    /*
     * WARNING - void declaration
     */
    public final MessageSetSend kafka$server$KafkaRequestHandlers$$readMessageSet(FetchRequest fetchRequest$1) {
        void var2_2;
        MessageSetSend response = null;
        BoxedUnit exceptionResult2 = null;
        try {
            Serializable serializable2;
            this.trace((Function0<String>)((Object)new scala.Serializable(this, fetchRequest$1){
                public static final long serialVersionUID;
                private final FetchRequest fetchRequest$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Fetching log segment for topic, partition, offset, maxSize = ").append(this.fetchRequest$1).toString();
                }
                {
                    this.fetchRequest$1 = fetchRequest;
                }
            }));
            Log log2 = this.logManager().getLog(fetchRequest$1.topic(), fetchRequest$1.partition());
            if (log2 == null) {
                response = new MessageSetSend();
                serializable2 = BoxedUnit.UNIT;
            } else {
                response = new MessageSetSend(log2.read(fetchRequest$1.offset(), fetchRequest$1.maxSize()));
                BrokerTopicStat$.MODULE$.getBrokerTopicStat(fetchRequest$1.topic()).recordBytesOut(response.messages().sizeInBytes());
                serializable2 = BoxesRunTime.boxToLong(BrokerTopicStat$.MODULE$.getBrokerAllTopicStat().recordBytesOut(response.messages().sizeInBytes()));
            }
            exceptionResult2 = serializable2;
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)((Object)new scala.Serializable(this, fetchRequest$1){
                public static final long serialVersionUID;
                private final FetchRequest fetchRequest$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"error when processing request ").append(this.fetchRequest$1).toString();
                }
                {
                    this.fetchRequest$1 = fetchRequest;
                }
            }), (Function0<Throwable>)((Object)new scala.Serializable(this, throwable){
                public static final long serialVersionUID;
                private final Throwable e$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Throwable apply() {
                    return this.e$2;
                }
                {
                    this.e$2 = throwable;
                }
            }));
            BrokerTopicStat$.MODULE$.getBrokerTopicStat(fetchRequest$1.topic()).recordFailedFetchRequest();
            BrokerTopicStat$.MODULE$.getBrokerAllTopicStat().recordFailedFetchRequest();
            response = new MessageSetSend(MessageSet$.MODULE$.Empty(), ErrorMapping$.MODULE$.codeFor(throwable.getClass()));
            exceptionResult2 = BoxedUnit.UNIT;
        }
        return var2_2;
    }

    public Option<Send> handleOffsetRequest(Receive request) {
        OffsetRequest offsetRequest = OffsetRequest$.MODULE$.readFrom(request.buffer());
        if (this.kafka$server$KafkaRequestHandlers$$requestLogger().isTraceEnabled()) {
            this.kafka$server$KafkaRequestHandlers$$requestLogger().trace(new StringBuilder().append((Object)"Offset request ").append((Object)offsetRequest.toString()).toString());
        }
        long[] offsets = this.logManager().getOffsets(offsetRequest);
        OffsetArraySend response = new OffsetArraySend(offsets);
        return new Some<Send>(response);
    }

    public KafkaRequestHandlers(LogManager logManager) {
        this.logManager = logManager;
        Logging$class.$init$(this);
        this.kafka$server$KafkaRequestHandlers$$requestLogger = Logger.getLogger("kafka.request.logger");
    }
}

