/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import kafka.message.Message$;
import kafka.utils.Utils$;
import kafka.utils.ZKConfig;
import scala.ScalaObject;
import scala.Tuple2$mcII$sp;
import scala.collection.Map;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u0001\u0003\u0001\u001d\u00111bS1gW\u0006\u001cuN\u001c4jO*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q!a\u0003\u0003\u0002\u000bU$\u0018\u000e\\:\n\u00055Q!\u0001\u0003.L\u0007>tg-[4\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t+\u0001\u0011\t\u0011)A\u0005-\u0005)\u0001O]8qgB\u0011q\u0003H\u0007\u00021)\u0011\u0011DG\u0001\u0005kRLGNC\u0001\u001c\u0003\u0011Q\u0017M^1\n\u0005uA\"A\u0003)s_B,'\u000f^5fg\")q\u0004\u0001C\u0001A\u00051A(\u001b8jiz\"\"!I\u0012\u0011\u0005\t\u0002Q\"\u0001\u0002\t\u000bUq\u0002\u0019\u0001\f\t\u000f\u0015\u0002!\u0019!C\u0001M\u0005!\u0001o\u001c:u+\u00059\u0003CA\b)\u0013\tI\u0003CA\u0002J]RDaa\u000b\u0001!\u0002\u00139\u0013!\u00029peR\u0004\u0003bB\u0017\u0001\u0005\u0004%\tAL\u0001\tQ>\u001cHOT1nKV\tq\u0006\u0005\u00021g9\u0011q\"M\u0005\u0003eA\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001b6\u0005\u0019\u0019FO]5oO*\u0011!\u0007\u0005\u0005\u0007o\u0001\u0001\u000b\u0011B\u0018\u0002\u0013!|7\u000f\u001e(b[\u0016\u0004\u0003bB\u001d\u0001\u0005\u0004%\tAJ\u0001\tEJ|7.\u001a:JI\"11\b\u0001Q\u0001\n\u001d\n\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\t\u000fu\u0002!\u0019!C\u0001M\u0005\u00012o\\2lKR\u001cVM\u001c3Ck\u001a4WM\u001d\u0005\u0007\u007f\u0001\u0001\u000b\u0011B\u0014\u0002#M|7m[3u'\u0016tGMQ;gM\u0016\u0014\b\u0005C\u0004B\u0001\t\u0007I\u0011\u0001\u0014\u0002'M|7m[3u%\u0016\u001cW-\u001b<f\u0005V4g-\u001a:\t\r\r\u0003\u0001\u0015!\u0003(\u0003Q\u0019xnY6fiJ+7-Z5wK\n+hMZ3sA!9Q\t\u0001b\u0001\n\u00031\u0013\u0001F7bqN{7m[3u%\u0016\fX/Z:u'&TX\r\u0003\u0004H\u0001\u0001\u0006IaJ\u0001\u0016[\u0006D8k\\2lKR\u0014V-];fgR\u001c\u0016N_3!\u0011\u001dI\u0005A1A\u0005\u0002\u0019\n!B\\;n)\"\u0014X-\u00193t\u0011\u0019Y\u0005\u0001)A\u0005O\u0005Ya.^7UQJ,\u0017\rZ:!\u0011\u001di\u0005A1A\u0005\u0002\u0019\nA#\\8oSR|'/\u001b8h!\u0016\u0014\u0018n\u001c3TK\u000e\u001c\bBB(\u0001A\u0003%q%A\u000bn_:LGo\u001c:j]\u001e\u0004VM]5pIN+7m\u001d\u0011\t\u000fE\u0003!\u0019!C\u0001M\u0005ia.^7QCJ$\u0018\u000e^5p]NDaa\u0015\u0001!\u0002\u00139\u0013A\u00048v[B\u000b'\u000f^5uS>t7\u000f\t\u0005\b+\u0002\u0011\r\u0011\"\u0001/\u0003\u0019awn\u001a#je\"1q\u000b\u0001Q\u0001\n=\nq\u0001\\8h\t&\u0014\b\u0005C\u0004Z\u0001\t\u0007I\u0011\u0001\u0014\u0002\u00171|wMR5mKNK'0\u001a\u0005\u00077\u0002\u0001\u000b\u0011B\u0014\u0002\u00191|wMR5mKNK'0\u001a\u0011\t\u000fu\u0003!\u0019!C\u0001M\u0005ia\r\\;tQ&sG/\u001a:wC2Daa\u0018\u0001!\u0002\u00139\u0013A\u00044mkND\u0017J\u001c;feZ\fG\u000e\t\u0005\bC\u0002\u0011\r\u0011\"\u0001'\u0003Eawn\u001a*fi\u0016tG/[8o\u0011>,(o\u001d\u0005\u0007G\u0002\u0001\u000b\u0011B\u0014\u0002%1|wMU3uK:$\u0018n\u001c8I_V\u00148\u000f\t\u0005\bK\u0002\u0011\r\u0011\"\u0001g\u0003Aawn\u001a*fi\u0016tG/[8o'&TX-F\u0001h!\ty\u0001.\u0003\u0002j!\t!Aj\u001c8h\u0011\u0019Y\u0007\u0001)A\u0005O\u0006\tBn\\4SKR,g\u000e^5p]NK'0\u001a\u0011\t\u000f5\u0004!\u0019!C\u0001]\u0006!Bn\\4SKR,g\u000e^5p]\"{WO]:NCB,\u0012a\u001c\t\u0005aN|s%D\u0001r\u0015\t\u0011\b#\u0001\u0006d_2dWm\u0019;j_:L!\u0001^9\u0003\u00075\u000b\u0007\u000f\u0003\u0004w\u0001\u0001\u0006Ia\\\u0001\u0016Y><'+\u001a;f]RLwN\u001c%pkJ\u001cX*\u00199!\u0011\u001dA\bA1A\u0005\u0002\u0019\n\u0011\u0004\\8h\u00072,\u0017M\\;q\u0013:$XM\u001d<bY6Kg.\u001e;fg\"1!\u0010\u0001Q\u0001\n\u001d\n!\u0004\\8h\u00072,\u0017M\\;q\u0013:$XM\u001d<bY6Kg.\u001e;fg\u0002Bq\u0001 \u0001C\u0002\u0013\u0005Q0A\bf]\u0006\u0014G.\u001a.p_.,W\r]3s+\u0005q\bCA\b\u0000\u0013\r\t\t\u0001\u0005\u0002\b\u0005>|G.Z1o\u0011\u001d\t)\u0001\u0001Q\u0001\ny\f\u0001#\u001a8bE2,'l\\8lK\u0016\u0004XM\u001d\u0011\t\u0011\u0005%\u0001A1A\u0005\u00029\f\u0001C\u001a7vg\"Le\u000e^3sm\u0006dW*\u00199\t\u000f\u00055\u0001\u0001)A\u0005_\u0006\tb\r\\;tQ&sG/\u001a:wC2l\u0015\r\u001d\u0011\t\u0011\u0005E\u0001A1A\u0005\u0002\u0019\n\u0001D\u001a7vg\"\u001c6\r[3ek2,'\u000f\u00165sK\u0006$'+\u0019;f\u0011\u001d\t)\u0002\u0001Q\u0001\n\u001d\n\u0011D\u001a7vg\"\u001c6\r[3ek2,'\u000f\u00165sK\u0006$'+\u0019;fA!A\u0011\u0011\u0004\u0001C\u0002\u0013\u0005a%\u0001\feK\u001a\fW\u000f\u001c;GYV\u001c\b.\u00138uKJ4\u0018\r\\'t\u0011\u001d\ti\u0002\u0001Q\u0001\n\u001d\nq\u0003Z3gCVdGO\u00127vg\"Le\u000e^3sm\u0006dWj\u001d\u0011\t\u0011\u0005\u0005\u0002A1A\u0005\u00029\f!\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gn]'ba\"9\u0011Q\u0005\u0001!\u0002\u0013y\u0017a\u0005;pa&\u001c\u0007+\u0019:uSRLwN\\:NCB\u0004\u0003")
public class KafkaConfig
extends ZKConfig
implements ScalaObject {
    private final int port;
    private final String hostName;
    private final int brokerId;
    private final int socketSendBuffer;
    private final int socketReceiveBuffer;
    private final int maxSocketRequestSize;
    private final int numThreads;
    private final int monitoringPeriodSecs;
    private final int numPartitions;
    private final String logDir;
    private final int logFileSize;
    private final int flushInterval;
    private final int logRetentionHours;
    private final long logRetentionSize;
    private final Map<String, Object> logRetentionHoursMap;
    private final int logCleanupIntervalMinutes;
    private final boolean enableZookeeper;
    private final Map<String, Object> flushIntervalMap;
    private final int flushSchedulerThreadRate;
    private final int defaultFlushIntervalMs;
    private final Map<String, Object> topicPartitionsMap;

    public int port() {
        return this.port;
    }

    public String hostName() {
        return this.hostName;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public int socketSendBuffer() {
        return this.socketSendBuffer;
    }

    public int socketReceiveBuffer() {
        return this.socketReceiveBuffer;
    }

    public int maxSocketRequestSize() {
        return this.maxSocketRequestSize;
    }

    public int numThreads() {
        return this.numThreads;
    }

    public int monitoringPeriodSecs() {
        return this.monitoringPeriodSecs;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public String logDir() {
        return this.logDir;
    }

    public int logFileSize() {
        return this.logFileSize;
    }

    public int flushInterval() {
        return this.flushInterval;
    }

    public int logRetentionHours() {
        return this.logRetentionHours;
    }

    public long logRetentionSize() {
        return this.logRetentionSize;
    }

    public Map<String, Object> logRetentionHoursMap() {
        return this.logRetentionHoursMap;
    }

    public int logCleanupIntervalMinutes() {
        return this.logCleanupIntervalMinutes;
    }

    public boolean enableZookeeper() {
        return this.enableZookeeper;
    }

    public Map<String, Object> flushIntervalMap() {
        return this.flushIntervalMap;
    }

    public int flushSchedulerThreadRate() {
        return this.flushSchedulerThreadRate;
    }

    public int defaultFlushIntervalMs() {
        return this.defaultFlushIntervalMs;
    }

    public Map<String, Object> topicPartitionsMap() {
        return this.topicPartitionsMap;
    }

    public KafkaConfig(Properties props) {
        super(props);
        this.port = Utils$.MODULE$.getInt(props, "port", 6667);
        this.hostName = Utils$.MODULE$.getString(props, "hostname", null);
        this.brokerId = Utils$.MODULE$.getInt(props, "brokerid");
        this.socketSendBuffer = Utils$.MODULE$.getInt(props, "socket.send.buffer", 102400);
        this.socketReceiveBuffer = Utils$.MODULE$.getInt(props, "socket.receive.buffer", 102400);
        this.maxSocketRequestSize = Utils$.MODULE$.getIntInRange(props, "max.socket.request.bytes", 0x6400000, new Tuple2$mcII$sp(1, Integer.MAX_VALUE));
        this.numThreads = Utils$.MODULE$.getIntInRange(props, "num.threads", Runtime.getRuntime().availableProcessors(), new Tuple2$mcII$sp(1, Integer.MAX_VALUE));
        this.monitoringPeriodSecs = Utils$.MODULE$.getIntInRange(props, "monitoring.period.secs", 600, new Tuple2$mcII$sp(1, Integer.MAX_VALUE));
        this.numPartitions = Utils$.MODULE$.getIntInRange(props, "num.partitions", 1, new Tuple2$mcII$sp(1, Integer.MAX_VALUE));
        this.logDir = Utils$.MODULE$.getString(props, "log.dir");
        this.logFileSize = Utils$.MODULE$.getIntInRange(props, "log.file.size", 0x40000000, new Tuple2$mcII$sp(Message$.MODULE$.MinHeaderSize(), Integer.MAX_VALUE));
        this.flushInterval = Utils$.MODULE$.getIntInRange(props, "log.flush.interval", 500, new Tuple2$mcII$sp(1, Integer.MAX_VALUE));
        this.logRetentionHours = Utils$.MODULE$.getIntInRange(props, "log.retention.hours", 168, new Tuple2$mcII$sp(1, Integer.MAX_VALUE));
        this.logRetentionSize = Utils$.MODULE$.getLong(props, "log.retention.size", -1L);
        this.logRetentionHoursMap = Utils$.MODULE$.getTopicRentionHours(Utils$.MODULE$.getString(props, "topic.log.retention.hours", ""));
        this.logCleanupIntervalMinutes = Utils$.MODULE$.getIntInRange(props, "log.cleanup.interval.mins", 10, new Tuple2$mcII$sp(1, Integer.MAX_VALUE));
        this.enableZookeeper = Utils$.MODULE$.getBoolean(props, "enable.zookeeper", true);
        this.flushIntervalMap = Utils$.MODULE$.getTopicFlushIntervals(Utils$.MODULE$.getString(props, "topic.flush.intervals.ms", ""));
        this.flushSchedulerThreadRate = Utils$.MODULE$.getInt(props, "log.default.flush.scheduler.interval.ms", 3000);
        this.defaultFlushIntervalMs = Utils$.MODULE$.getInt(props, "log.default.flush.interval.ms", this.flushSchedulerThreadRate());
        this.topicPartitionsMap = Utils$.MODULE$.getTopicPartitions(Utils$.MODULE$.getString(props, "topic.partition.count.map", ""));
    }
}

