/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer.async;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kafka.producer.SyncProducer;
import kafka.producer.async.CallbackHandler;
import kafka.producer.async.EventHandler;
import kafka.producer.async.IllegalQueueStateException;
import kafka.producer.async.QueueItem;
import kafka.serializer.Encoder;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.SystemTime$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Stream;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005ed!B\u0001\u0003\u0001\tA!A\u0005)s_\u0012,8-\u001a:TK:$G\u000b\u001b:fC\u0012T!a\u0001\u0003\u0002\u000b\u0005\u001c\u0018P\\2\u000b\u0005\u00151\u0011\u0001\u00039s_\u0012,8-\u001a:\u000b\u0003\u001d\tQa[1gW\u0006,\"!\u0003\u001f\u0014\t\u0001Q!\u0003\u0007\t\u0003\u0017Ai\u0011\u0001\u0004\u0006\u0003\u001b9\tA\u0001\\1oO*\tq\"\u0001\u0003kCZ\f\u0017BA\t\r\u0005\u0019!\u0006N]3bIB\u00111CF\u0007\u0002))\u0011QCB\u0001\u0006kRLGn]\u0005\u0003/Q\u0011q\u0001T8hO&tw\r\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"DA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\u0002C\u0010\u0001\u0005\u000b\u0007I\u0011A\u0011\u0002\u0015QD'/Z1e\u001d\u0006lWm\u0001\u0001\u0016\u0003\t\u0002\"a\t\u0014\u000f\u0005e!\u0013BA\u0013\u001b\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0005\u000b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0015R\u0002\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\u0002\u0017QD'/Z1e\u001d\u0006lW\r\t\u0005\tY\u0001\u0011)\u0019!C\u0001[\u0005)\u0011/^3vKV\ta\u0006E\u00020iYj\u0011\u0001\r\u0006\u0003cI\n!bY8oGV\u0014(/\u001a8u\u0015\t\u0019d\"\u0001\u0003vi&d\u0017BA\u001b1\u00055\u0011En\\2lS:<\u0017+^3vKB\u0019q\u0007\u000f\u001e\u000e\u0003\tI!!\u000f\u0002\u0003\u0013E+X-^3Ji\u0016l\u0007CA\u001e=\u0019\u0001!Q!\u0010\u0001C\u0002y\u0012\u0011\u0001V\t\u0003\u007f\t\u0003\"!\u0007!\n\u0005\u0005S\"a\u0002(pi\"Lgn\u001a\t\u00033\rK!\u0001\u0012\u000e\u0003\u0007\u0005s\u0017\u0010\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003/\u0003\u0019\tX/Z;fA!A\u0001\n\u0001BC\u0002\u0013\u0005\u0011*\u0001\u0006tKJL\u0017\r\\5{KJ,\u0012A\u0013\t\u0004\u00176ST\"\u0001'\u000b\u0005!3\u0011B\u0001(M\u0005\u001d)enY8eKJD\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006IAS\u0001\fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0005\u0003\u0005S\u0001\t\u0015\r\u0011\"\u0001T\u0003I)h\u000eZ3sYfLgn\u001a)s_\u0012,8-\u001a:\u0016\u0003Q\u0003\"!\u0016,\u000e\u0003\u0011I!a\u0016\u0003\u0003\u0019MKhn\u0019)s_\u0012,8-\u001a:\t\u0011e\u0003!\u0011!Q\u0001\nQ\u000b1#\u001e8eKJd\u00170\u001b8h!J|G-^2fe\u0002B\u0001b\u0017\u0001\u0003\u0006\u0004%\t\u0001X\u0001\bQ\u0006tG\r\\3s+\u0005i\u0006cA\u001c_u%\u0011qL\u0001\u0002\r\u000bZ,g\u000e\u001e%b]\u0012dWM\u001d\u0005\tC\u0002\u0011\t\u0011)A\u0005;\u0006A\u0001.\u00198eY\u0016\u0014\b\u0005\u0003\u0005d\u0001\t\u0015\r\u0011\"\u0001e\u0003)\u0019'm\u001b%b]\u0012dWM]\u000b\u0002KB\u0019qG\u001a\u001e\n\u0005\u001d\u0014!aD\"bY2\u0014\u0017mY6IC:$G.\u001a:\t\u0011%\u0004!\u0011!Q\u0001\n\u0015\f1b\u00192l\u0011\u0006tG\r\\3sA!A1\u000e\u0001BC\u0002\u0013\u0005A.A\u0005rk\u0016,X\rV5nKV\tQ\u000e\u0005\u0002\u001a]&\u0011qN\u0007\u0002\u0005\u0019>tw\r\u0003\u0005r\u0001\t\u0005\t\u0015!\u0003n\u0003)\tX/Z;f)&lW\r\t\u0005\tg\u0002\u0011)\u0019!C\u0001i\u0006I!-\u0019;dQNK'0Z\u000b\u0002kB\u0011\u0011D^\u0005\u0003oj\u00111!\u00138u\u0011!I\bA!A!\u0002\u0013)\u0018A\u00032bi\u000eD7+\u001b>fA!A1\u0010\u0001BC\u0002\u0013\u0005A0A\btQV$Hm\\<o\u0007>lW.\u00198e+\u0005\u0011\u0005\u0002\u0003@\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\u0002!MDW\u000f\u001e3po:\u001cu.\\7b]\u0012\u0004\u0003bBA\u0001\u0001\u0011\u0005\u00111A\u0001\u0007y%t\u0017\u000e\u001e \u0015)\u0005\u0015\u0011qAA\u0005\u0003\u0017\ti!a\u0004\u0002\u0012\u0005M\u0011QCA\f!\r9\u0004A\u000f\u0005\u0006?}\u0004\rA\t\u0005\u0006Y}\u0004\rA\f\u0005\u0006\u0011~\u0004\rA\u0013\u0005\u0006%~\u0004\r\u0001\u0016\u0005\u00067~\u0004\r!\u0018\u0005\u0006G~\u0004\r!\u001a\u0005\u0006W~\u0004\r!\u001c\u0005\u0006g~\u0004\r!\u001e\u0005\u0006w~\u0004\rA\u0011\u0005\n\u00037\u0001!\u0019!C\u0005\u0003;\tQb\u001d5vi\u0012|wO\u001c'bi\u000eDWCAA\u0010!\ry\u0013\u0011E\u0005\u0004\u0003G\u0001$AD\"pk:$Hi\\<o\u0019\u0006$8\r\u001b\u0005\t\u0003O\u0001\u0001\u0015!\u0003\u0002 \u0005q1\u000f[;uI><h\u000eT1uG\"\u0004\u0003bBA\u0016\u0001\u0011\u0005\u0013QF\u0001\u0004eVtGCAA\u0018!\rI\u0012\u0011G\u0005\u0004\u0003gQ\"\u0001B+oSRDq!a\u000e\u0001\t\u0003\tI$A\u0007bo\u0006LGo\u00155vi\u0012|wO\\\u000b\u0003\u0003_Aq!!\u0010\u0001\t\u0003\tI$\u0001\u0005tQV$Hm\\<o\u0011\u001d\t\t\u0005\u0001C\u0005\u0003\u0007\nQ\u0002\u001d:pG\u0016\u001c8/\u0012<f]R\u001cHCAA#!\u0015\t9%a\u00167\u001d\u0011\tI%a\u0015\u000f\t\u0005-\u0013\u0011K\u0007\u0003\u0003\u001bR1!a\u0014!\u0003\u0019a$o\\8u}%\t1$C\u0002\u0002Vi\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002Z\u0005m#aA*fc*\u0019\u0011Q\u000b\u000e\t\u000f\u0005}\u0003\u0001\"\u0001\u0002b\u0005YAO]=U_\"\u000bg\u000e\u001a7f)\u0011\ty#a\u0019\t\u0011\u0005\u0015\u0014Q\fa\u0001\u0003\u000b\na!\u001a<f]R\u001c\bbBA5\u0001\u0011%\u00111N\u0001\nY><WI^3oiN$b!a\f\u0002n\u0005E\u0004bBA8\u0003O\u0002\rAI\u0001\u0004i\u0006<\u0007\u0002CA3\u0003O\u0002\r!a\u001d\u0011\u000b\u0005\u001d\u0013Q\u000f\u001c\n\t\u0005]\u00141\f\u0002\t\u0013R,'/\u00192mK\u0002")
public class ProducerSendThread<T>
extends Thread
implements Logging,
ScalaObject {
    private final String threadName;
    private final BlockingQueue<QueueItem<T>> queue;
    private final Encoder<T> serializer;
    private final SyncProducer underlyingProducer;
    private final EventHandler<T> handler;
    private final CallbackHandler<T> cbkHandler;
    private final long queueTime;
    private final int batchSize;
    private final Object shutdownCommand;
    private final CountDownLatch shutdownLatch;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ProducerSendThread producerSendThread = this;
        synchronized (producerSendThread) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public String threadName() {
        return this.threadName;
    }

    public BlockingQueue<QueueItem<T>> queue() {
        return this.queue;
    }

    public Encoder<T> serializer() {
        return this.serializer;
    }

    public SyncProducer underlyingProducer() {
        return this.underlyingProducer;
    }

    public EventHandler<T> handler() {
        return this.handler;
    }

    public CallbackHandler<T> cbkHandler() {
        return this.cbkHandler;
    }

    public long queueTime() {
        return this.queueTime;
    }

    public int batchSize() {
        return this.batchSize;
    }

    public Object shutdownCommand() {
        return this.shutdownCommand;
    }

    private CountDownLatch shutdownLatch() {
        return this.shutdownLatch;
    }

    @Override
    public void run() {
        try {
            Seq<QueueItem<T>> remainingEvents$1 = this.processEvents();
            this.debug((Function0<String>)((Object)new Serializable(this, remainingEvents$1){
                public static final long serialVersionUID;
                private final Seq remainingEvents$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Remaining events = ").append(BoxesRunTime.boxToInteger(this.remainingEvents$1.size())).toString();
                }
                {
                    this.remainingEvents$1 = producerSendThread;
                }
            }));
            if (remainingEvents$1.size() > 0) {
                this.debug((Function0<String>)((Object)new Serializable(this, remainingEvents$1){
                    public static final long serialVersionUID;
                    private final Seq remainingEvents$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Dispatching last batch of %d events to the event handler").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.remainingEvents$1.size())}));
                    }
                    {
                        this.remainingEvents$1 = producerSendThread;
                    }
                }));
                this.tryToHandle(remainingEvents$1);
            }
            this.shutdownLatch().countDown();
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Error in sending events: ";
                }
            }), (Function0<Throwable>)((Object)new Serializable(this, throwable){
                public static final long serialVersionUID;
                private final Throwable e$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Throwable apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = producerSendThread;
                }
            }));
        }
        return;
        {
            finally {
                this.shutdownLatch().countDown();
            }
        }
    }

    public void awaitShutdown() {
        this.shutdownLatch().await();
    }

    public void shutdown() {
        this.handler().close();
        this.info((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Shutdown thread complete";
            }
        }));
    }

    private Seq<QueueItem<T>> processEvents() {
        LongRef lastSend$1 = new LongRef(SystemTime$.MODULE$.milliseconds());
        ObjectRef events$2 = new ObjectRef(new ListBuffer());
        BooleanRef full$1 = new BooleanRef(false);
        ((Stream)scala.package$.MODULE$.Stream().continually(new Serializable(this, lastSend$1){
            public static final long serialVersionUID;
            private final ProducerSendThread $outer;
            private final LongRef lastSend$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final QueueItem<T> apply() {
                return this.$outer.queue().poll(package$.MODULE$.max(0L, this.lastSend$1.elem + this.$outer.queueTime() - SystemTime$.MODULE$.milliseconds()), TimeUnit.MILLISECONDS);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.lastSend$1 = producerSendThread;
            }
        }).takeWhile((Function1)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final ProducerSendThread $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(QueueItem<T> item) {
                return item == null ? true : !BoxesRunTime.equals(item.getData(), this.$outer.shutdownCommand());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }))).foreach(new Serializable(this, lastSend$1, events$2, full$1){
            public static final long serialVersionUID;
            private final ProducerSendThread $outer;
            private final LongRef lastSend$1;
            private final ObjectRef events$2;
            private final BooleanRef full$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(QueueItem<T> currentQueueItem$1) {
                Object object;
                boolean expired;
                long elapsed$1 = SystemTime$.MODULE$.milliseconds() - this.lastSend$1.elem;
                boolean bl = expired = currentQueueItem$1 == null;
                if (currentQueueItem$1 != null) {
                    this.$outer.trace((Function0<String>)((Object)new Serializable(this, currentQueueItem$1){
                        public static final long serialVersionUID;
                        private final QueueItem currentQueueItem$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Dequeued item for topic %s and partition %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.currentQueueItem$1.getTopic(), BoxesRunTime.boxToInteger(this.currentQueueItem$1.getPartition())}));
                        }
                        {
                            this.currentQueueItem$1 = var2_2;
                        }
                    }));
                }
                if (this.$outer.cbkHandler() == null) {
                    object = currentQueueItem$1 == null ? BoxedUnit.UNIT : ((ListBuffer)this.events$2.elem).$plus$eq(currentQueueItem$1);
                } else {
                    this.events$2.elem = (ListBuffer)((ListBuffer)this.events$2.elem).$plus$plus(this.$outer.cbkHandler().afterDequeuingExistingData(currentQueueItem$1));
                    object = BoxedUnit.UNIT;
                }
                boolean bl2 = this.full$1.elem = ((ListBuffer)this.events$2.elem).size() >= this.$outer.batchSize();
                if (this.full$1.elem || expired) {
                    if (expired) {
                        this.$outer.debug((Function0<String>)((Object)new Serializable(this, elapsed$1){
                            public static final long serialVersionUID;
                            private final long elapsed$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return new StringBuilder().append(this.elapsed$1).append((Object)" ms elapsed. Queue time reached. Sending..").toString();
                            }
                            {
                                this.elapsed$1 = l;
                            }
                        }));
                    }
                    if (this.full$1.elem) {
                        this.$outer.debug((Function0<String>)((Object)new Serializable(this){
                            public static final long serialVersionUID;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return "Batch full. Sending..";
                            }
                        }));
                    }
                    this.$outer.tryToHandle((ListBuffer)this.events$2.elem);
                    this.lastSend$1.elem = SystemTime$.MODULE$.milliseconds();
                    this.events$2.elem = new ListBuffer<A>();
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.lastSend$1 = producerSendThread;
                this.events$2 = var3_3;
                this.full$1 = var4_4;
            }
        });
        if (this.queue().size() > 0) {
            throw new IllegalQueueStateException(Predef$.MODULE$.augmentString("Invalid queue state! After queue shutdown, %d remaining items in the queue").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.queue().size())})));
        }
        if (this.cbkHandler() != null) {
            this.info((Function0<String>)((Object)new Serializable(this, events$2){
                public static final long serialVersionUID;
                private final ObjectRef events$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Invoking the callback handler before handling the last batch of %d events").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(((ListBuffer)this.events$2.elem).size())}));
                }
                {
                    this.events$2 = producerSendThread;
                }
            }));
            scala.collection.mutable.Seq<QueueItem<T>> addedEvents = this.cbkHandler().lastBatchBeforeClose();
            this.logEvents("last batch before close", addedEvents);
            events$2.elem = (ListBuffer)((ListBuffer)events$2.elem).$plus$plus(addedEvents);
        }
        return (ListBuffer)events$2.elem;
    }

    public void tryToHandle(Seq<QueueItem<T>> events$1) {
        try {
            this.debug((Function0<String>)((Object)new Serializable(this, events$1){
                public static final long serialVersionUID;
                private final Seq events$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Handling ").append(BoxesRunTime.boxToInteger(this.events$1.size())).append((Object)" events").toString();
                }
                {
                    this.events$1 = producerSendThread;
                }
            }));
            if (events$1.size() > 0) {
                this.handler().handle(events$1, this.underlyingProducer(), this.serializer());
            }
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)((Object)new Serializable(this, events$1){
                public static final long serialVersionUID;
                private final Seq events$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Error in handling batch of ").append(BoxesRunTime.boxToInteger(this.events$1.size())).append((Object)" events").toString();
                }
                {
                    this.events$1 = producerSendThread;
                }
            }), (Function0<Throwable>)((Object)new Serializable(this, throwable){
                public static final long serialVersionUID;
                private final Throwable e$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Throwable apply() {
                    return this.e$2;
                }
                {
                    this.e$2 = producerSendThread;
                }
            }));
        }
    }

    private void logEvents(String tag$1, Iterable<QueueItem<T>> events2) {
        if (this.logger().isTraceEnabled()) {
            this.trace((Function0<String>)((Object)new Serializable(this, tag$1){
                public static final long serialVersionUID;
                private final String tag$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"events for ").append((Object)this.tag$1).append((Object)":").toString();
                }
                {
                    this.tag$1 = producerSendThread;
                }
            }));
            events2.foreach(new Serializable(this){
                public static final long serialVersionUID;
                private final ProducerSendThread $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(QueueItem<T> event$1) {
                    this.$outer.trace((Function0<String>)((Object)new Serializable(this, event$1){
                        public static final long serialVersionUID;
                        private final QueueItem event$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return this.event$1.getData().toString();
                        }
                        {
                            this.event$1 = var2_2;
                        }
                    }));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
    }

    public ProducerSendThread(String threadName, BlockingQueue<QueueItem<T>> queue, Encoder<T> serializer, SyncProducer underlyingProducer, EventHandler<T> handler, CallbackHandler<T> cbkHandler, long queueTime, int batchSize, Object shutdownCommand) {
        this.threadName = threadName;
        this.queue = queue;
        this.serializer = serializer;
        this.underlyingProducer = underlyingProducer;
        this.handler = handler;
        this.cbkHandler = cbkHandler;
        this.queueTime = queueTime;
        this.batchSize = batchSize;
        this.shutdownCommand = shutdownCommand;
        super(threadName);
        Logging$class.$init$(this);
        this.shutdownLatch = new CountDownLatch(1);
    }
}

