/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer.async;

import java.util.Properties;
import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.ProducerRequest$;
import kafka.producer.ProducerConfig;
import kafka.producer.SyncProducer;
import kafka.producer.async.AsyncProducer$;
import kafka.producer.async.AsyncProducerConfig;
import kafka.producer.async.AsyncProducerInterruptedException;
import kafka.producer.async.AsyncProducerQueueSizeStats;
import kafka.producer.async.AsyncProducerStats$;
import kafka.producer.async.CallbackHandler;
import kafka.producer.async.DefaultEventHandler;
import kafka.producer.async.EventHandler;
import kafka.producer.async.ProducerSendThread;
import kafka.producer.async.QueueClosedException;
import kafka.producer.async.QueueFullException;
import kafka.producer.async.QueueItem;
import kafka.serializer.Encoder;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function2;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\rx!B\u0001\u0003\u0011\u000bI\u0011!D!ts:\u001c\u0007K]8ek\u000e,'O\u0003\u0002\u0004\t\u0005)\u0011m]=oG*\u0011QAB\u0001\taJ|G-^2fe*\tq!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005)YQ\"\u0001\u0002\u0007\u000b1\u0011\u0001RA\u0007\u0003\u001b\u0005\u001b\u0018P\\2Qe>$WoY3s'\rYaB\u0006\t\u0003\u001fQi\u0011\u0001\u0005\u0006\u0003#I\tA\u0001\\1oO*\t1#\u0001\u0003kCZ\f\u0017BA\u000b\u0011\u0005\u0019y%M[3diB\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\tY1kY1mC>\u0013'.Z2u\u0011\u0015i2\u0002\"\u0001\u001f\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0002C\u0004!\u0017\t\u0007I\u0011A\u0011\u0002\u0011MCW\u000f\u001e3po:,\u0012A\u0004\u0005\u0007G-\u0001\u000b\u0011\u0002\b\u0002\u0013MCW\u000f\u001e3po:\u0004\u0003bB\u0013\f\u0005\u0004%\tAJ\u0001\u0007%\u0006tGm\\7\u0016\u0003\u001d\u0002\"\u0001K\u0016\u000e\u0003%R!A\u000b\n\u0002\tU$\u0018\u000e\\\u0005\u0003Y%\u0012aAU1oI>l\u0007B\u0002\u0018\fA\u0003%q%A\u0004SC:$w.\u001c\u0011\t\u000fAZ!\u0019!C\u0001c\u0005\t\u0002K]8ek\u000e,'/\u0014\"fC:t\u0015-\\3\u0016\u0003I\u0002\"aD\u001a\n\u0005Q\u0002\"AB*ue&tw\r\u0003\u00047\u0017\u0001\u0006IAM\u0001\u0013!J|G-^2fe6\u0013U-\u00198OC6,\u0007\u0005C\u00049\u0017\t\u0007I\u0011A\u0019\u00025A\u0013x\u000eZ;dKJ\fV/Z;f'&TX-\u0014\"fC:t\u0015-\\3\t\riZ\u0001\u0015!\u00033\u0003m\u0001&o\u001c3vG\u0016\u0014\u0018+^3vKNK'0Z'CK\u0006tg*Y7fA!9AhCI\u0001\n\u0003i\u0014AD5oSR$C-\u001a4bk2$H\u0005N\u000b\u0003}1+\u0012a\u0010\u0016\u0003\u0001\u000e\u0003\"aF!\n\u0005\tC\"\u0001\u0002(vY2\\\u0013\u0001\u0012\t\u0003\u000b*k\u0011A\u0012\u0006\u0003\u000f\"\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005%C\u0012AC1o]>$\u0018\r^5p]&\u00111J\u0012\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,G!B'<\u0005\u0004q%!\u0001+\u0012\u0005=\u0013\u0006CA\fQ\u0013\t\t\u0006DA\u0004O_RD\u0017N\\4\u0011\u0005]\u0019\u0016B\u0001+\u0019\u0005\r\te.\u001f\u0005\b-.\t\n\u0011\"\u0001X\u00039Ig.\u001b;%I\u00164\u0017-\u001e7uIU*\"\u0001W/\u0016\u0003eS#AW\"\u0011\u0005!Z\u0016B\u0001/*\u0005)\u0001&o\u001c9feRLWm\u001d\u0003\u0006\u001bV\u0013\rA\u0014\u0005\b?.\t\n\u0011\"\u0001a\u00039Ig.\u001b;%I\u00164\u0017-\u001e7uIY*\"AP1\u0005\u000b5s&\u0019\u0001(\t\u000f\r\\\u0011\u0013!C\u0001I\u0006q\u0011N\\5uI\u0011,g-Y;mi\u0012:TC\u0001-f\t\u0015i%M1\u0001O\r\u0015a!\u0001\u0001\u0004h+\rA\u0017QA\n\u0005M:Ig\u0003\u0005\u0002k[6\t1N\u0003\u0002m\r\u0005)Q\u000f^5mg&\u0011an\u001b\u0002\b\u0019><w-\u001b8h\u0011!\u0001hM!A!\u0002\u0013\t\u0018AB2p]\u001aLw\r\u0005\u0002\u000be&\u00111O\u0001\u0002\u0014\u0003NLhn\u0019)s_\u0012,8-\u001a:D_:4\u0017n\u001a\u0005\t\u000b\u0019\u0014\t\u0011)A\u0005kB\u0011ao^\u0007\u0002\t%\u0011\u0001\u0010\u0002\u0002\r'ft7\r\u0015:pIV\u001cWM\u001d\u0005\tu\u001a\u0014\t\u0011)A\u0005w\u0006Q1/\u001a:jC2L'0\u001a:\u0011\tqt\u0018\u0011A\u0007\u0002{*\u0011!PB\u0005\u0003\u007fv\u0014q!\u00128d_\u0012,'\u000f\u0005\u0003\u0002\u0004\u0005\u0015A\u0002\u0001\u0003\u0006\u001b\u001a\u0014\rA\u0014\u0005\u000b\u0003\u00131'\u0011!Q\u0001\n\u0005-\u0011\u0001D3wK:$\b*\u00198eY\u0016\u0014\b#\u0002\u0006\u0002\u000e\u0005\u0005\u0011bAA\b\u0005\taQI^3oi\"\u000bg\u000e\u001a7fe\"I\u00111\u00034\u0003\u0002\u0003\u0006IAW\u0001\u0012KZ,g\u000e\u001e%b]\u0012dWM\u001d)s_B\u001c\bBCA\fM\n\u0005\t\u0015!\u0003\u0002\u001a\u0005Q1MY6IC:$G.\u001a:\u0011\u000b)\tY\"!\u0001\n\u0007\u0005u!AA\bDC2d'-Y2l\u0011\u0006tG\r\\3s\u0011%\t\tC\u001aB\u0001B\u0003%!,A\bdE.D\u0015M\u001c3mKJ\u0004&o\u001c9t\u0011\u0019ib\r\"\u0001\u0002&Q\u0001\u0012qEA\u0015\u0003W\ti#a\f\u00022\u0005M\u0012Q\u0007\t\u0005\u0015\u0019\f\t\u0001\u0003\u0004q\u0003G\u0001\r!\u001d\u0005\u0007\u000b\u0005\r\u0002\u0019A;\t\ri\f\u0019\u00031\u0001|\u0011)\tI!a\t\u0011\u0002\u0003\u0007\u00111\u0002\u0005\n\u0003'\t\u0019\u0003%AA\u0002iC!\"a\u0006\u0002$A\u0005\t\u0019AA\r\u0011%\t\t#a\t\u0011\u0002\u0003\u0007!\fC\u0005\u0002:\u0019\u0014\r\u0011\"\u0003\u0002<\u000511\r\\8tK\u0012,\"!!\u0010\u0011\t\u0005}\u0012\u0011J\u0007\u0003\u0003\u0003RA!a\u0011\u0002F\u00051\u0011\r^8nS\u000eT1!a\u0012*\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003\u0017\n\tEA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\u001c\u0005\t\u0003\u001f2\u0007\u0015!\u0003\u0002>\u000591\r\\8tK\u0012\u0004\u0003\"CA*M\n\u0007I\u0011BA+\u0003\u0015\tX/Z;f+\t\t9\u0006\u0005\u0004\u0002Z\u0005m\u0013qL\u0007\u0003\u0003\u000bJA!!\u0018\u0002F\t\u0019B*\u001b8lK\u0012\u0014En\\2lS:<\u0017+^3vKB)!\"!\u0019\u0002\u0002%\u0019\u00111\r\u0002\u0003\u0013E+X-^3Ji\u0016l\u0007\u0002CA4M\u0002\u0006I!a\u0016\u0002\rE,X-^3!\u0011%\tYG\u001ab\u0001\n\u0013\ti'A\bbgft7\r\u0015:pIV\u001cWM]%E+\t\ty\u0007E\u0002\u0018\u0003cJ1!a\u001d\u0019\u0005\rIe\u000e\u001e\u0005\t\u0003o2\u0007\u0015!\u0003\u0002p\u0005\u0001\u0012m]=oGB\u0013x\u000eZ;dKJLE\t\t\u0005\n\u0003w2'\u0019!C\u0005\u0003{\n!b]3oIRC'/Z1e+\t\ty\bE\u0003\u000b\u0003\u0003\u000b\t!C\u0002\u0002\u0004\n\u0011!\u0003\u0015:pIV\u001cWM]*f]\u0012$\u0006N]3bI\"A\u0011q\u00114!\u0002\u0013\ty(A\u0006tK:$G\u000b\u001b:fC\u0012\u0004\u0003BB\u000fg\t\u0003\tY\t\u0006\u0003\u0002(\u00055\u0005B\u00029\u0002\n\u0002\u0007\u0011\u000fC\u0004\u0002\u0012\u001a$\t!a%\u0002\u000bM$\u0018M\u001d;\u0016\u0005\u0005U\u0005cA\f\u0002\u0018&\u0019\u0011\u0011\u0014\r\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003;3G\u0011AAP\u0003\u0011\u0019XM\u001c3\u0015\r\u0005U\u0015\u0011UAY\u0011!\t\u0019+a'A\u0002\u0005\u0015\u0016!\u0002;pa&\u001c\u0007\u0003BAT\u0003[s1aFAU\u0013\r\tY\u000bG\u0001\u0007!J,G-\u001a4\n\u0007Q\nyKC\u0002\u0002,bA\u0001\"a-\u0002\u001c\u0002\u0007\u0011\u0011A\u0001\u0006KZ,g\u000e\u001e\u0005\b\u0003;3G\u0011AA\\)!\t)*!/\u0002<\u0006u\u0006\u0002CAR\u0003k\u0003\r!!*\t\u0011\u0005M\u0016Q\u0017a\u0001\u0003\u0003A\u0001\"a0\u00026\u0002\u0007\u0011qN\u0001\na\u0006\u0014H/\u001b;j_:Dq!a1g\t\u0003\t\u0019*A\u0003dY>\u001cX\rC\u0004\u0002H\u001a$\t!!3\u0002\u001dM,G\u000fT8hO\u0016\u0014H*\u001a<fYR!\u0011QSAf\u0011!\ti-!2A\u0002\u0005=\u0017!\u00027fm\u0016d\u0007\u0003BAi\u0003?l!!a5\u000b\t\u0005U\u0017q[\u0001\u0006Y><GG\u001b\u0006\u0005\u00033\fY.\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003;\f1a\u001c:h\u0013\u0011\t\t/a5\u0003\u000b1+g/\u001a7")
public class AsyncProducer<T>
implements Logging,
ScalaObject {
    private final AsyncProducerConfig config;
    private final SyncProducer producer;
    private final CallbackHandler<T> cbkHandler;
    private final AtomicBoolean closed;
    private final LinkedBlockingQueue<QueueItem<T>> kafka$producer$async$AsyncProducer$$queue;
    private final int kafka$producer$async$AsyncProducer$$asyncProducerID;
    private final ProducerSendThread<T> sendThread;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    public volatile int bitmap$0;

    public static final Properties init$default$7() {
        return AsyncProducer$.MODULE$.init$default$7();
    }

    public static final Null$ init$default$6() {
        return AsyncProducer$.MODULE$.init$default$6();
    }

    public static final Properties init$default$5() {
        return AsyncProducer$.MODULE$.init$default$5();
    }

    public static final Null$ init$default$4() {
        return AsyncProducer$.MODULE$.init$default$4();
    }

    public static final String ProducerQueueSizeMBeanName() {
        return AsyncProducer$.MODULE$.ProducerQueueSizeMBeanName();
    }

    public static final String ProducerMBeanName() {
        return AsyncProducer$.MODULE$.ProducerMBeanName();
    }

    public static final Random Random() {
        return AsyncProducer$.MODULE$.Random();
    }

    public static final Object Shutdown() {
        return AsyncProducer$.MODULE$.Shutdown();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        AsyncProducer asyncProducer = this;
        synchronized (asyncProducer) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private AtomicBoolean closed() {
        return this.closed;
    }

    public final LinkedBlockingQueue<QueueItem<T>> kafka$producer$async$AsyncProducer$$queue() {
        return this.kafka$producer$async$AsyncProducer$$queue;
    }

    public final int kafka$producer$async$AsyncProducer$$asyncProducerID() {
        return this.kafka$producer$async$AsyncProducer$$asyncProducerID;
    }

    private ProducerSendThread<T> sendThread() {
        return this.sendThread;
    }

    public void start() {
        this.sendThread().start();
    }

    public void send(String topic, T event) {
        this.send(topic, event, ProducerRequest$.MODULE$.RandomPartition());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send(String topic, T event, int partition2) {
        boolean bl;
        int n;
        AsyncProducerStats$.MODULE$.recordEvent();
        if (this.closed().get()) {
            throw new QueueClosedException("Attempt to add event to a closed queue.");
        }
        QueueItem<T> data2 = new QueueItem<T>(event, topic, partition2);
        if (this.cbkHandler != null) {
            data2 = this.cbkHandler.beforeEnqueue(data2);
        }
        if ((n = this.config.enqueueTimeoutMs()) == 0) {
            bl = this.kafka$producer$async$AsyncProducer$$queue().offer(data2);
        } else {
            boolean exceptionResult1 = false;
            try {
                boolean bl2;
                boolean bl3;
                boolean bl4 = bl3 = this.config.enqueueTimeoutMs() < 0;
                if (bl3) {
                    this.kafka$producer$async$AsyncProducer$$queue().put(data2);
                    bl2 = true;
                } else {
                    bl2 = this.kafka$producer$async$AsyncProducer$$queue().offer(data2, this.config.enqueueTimeoutMs(), TimeUnit.MILLISECONDS);
                }
                bl = exceptionResult1 = bl2;
            }
            catch (InterruptedException interruptedException) {
                String msg$1 = Predef$.MODULE$.augmentString("%s interrupted during enqueue of event %s.").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.getClass().getSimpleName(), event.toString()}));
                this.error((Function0<String>)((Object)new Serializable(this, msg$1){
                    public static final long serialVersionUID;
                    private final String msg$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return this.msg$1;
                    }
                    {
                        this.msg$1 = asyncProducer;
                    }
                }));
                throw new AsyncProducerInterruptedException(msg$1);
            }
        }
        boolean added = bl;
        if (this.cbkHandler != null) {
            this.cbkHandler.afterEnqueue(data2, added);
        }
        if (!added) {
            AsyncProducerStats$.MODULE$.recordDroppedEvents();
            this.logger().error(new StringBuilder().append((Object)"Event queue is full of unsent messages, could not send event: ").append((Object)event.toString()).toString());
            throw new QueueFullException(new StringBuilder().append((Object)"Event queue is full of unsent messages, could not send event: ").append((Object)event.toString()).toString());
        }
        if (this.logger().isTraceEnabled()) {
            this.logger().trace(new StringBuilder().append((Object)"Added event to send queue for topic: ").append((Object)topic).append((Object)", partition: ").append(BoxesRunTime.boxToInteger(partition2)).append((Object)":").append((Object)event.toString()).toString());
            this.logger().trace(new StringBuilder().append((Object)"Remaining queue size: ").append(BoxesRunTime.boxToInteger(this.kafka$producer$async$AsyncProducer$$queue().remainingCapacity())).toString());
        }
    }

    public void close() {
        if (this.cbkHandler != null) {
            this.cbkHandler.close();
            this.logger().info("Closed the callback handler");
        }
        this.closed().set(true);
        this.kafka$producer$async$AsyncProducer$$queue().put(new QueueItem<Object>(AsyncProducer$.MODULE$.Shutdown(), null, -1));
        if (this.logger().isDebugEnabled()) {
            this.logger().debug("Added shutdown command to the queue");
        }
        this.sendThread().shutdown();
        this.sendThread().awaitShutdown();
        this.producer.close();
        this.logger().info("Closed AsyncProducer");
    }

    public void setLoggerLevel(Level level) {
        this.logger().setLevel(level);
    }

    public AsyncProducer(AsyncProducerConfig config, SyncProducer producer, Encoder<T> serializer, EventHandler<T> eventHandler, Properties eventHandlerProps, CallbackHandler<T> cbkHandler, Properties cbkHandlerProps) {
        this.config = config;
        this.producer = producer;
        this.cbkHandler = cbkHandler;
        Logging$class.$init$(this);
        this.closed = new AtomicBoolean(false);
        this.kafka$producer$async$AsyncProducer$$queue = new LinkedBlockingQueue(config.queueSize());
        if (eventHandler != null) {
            eventHandler.init(eventHandlerProps);
        }
        if (cbkHandler != null) {
            cbkHandler.init(cbkHandlerProps);
        }
        this.kafka$producer$async$AsyncProducer$$asyncProducerID = AsyncProducer$.MODULE$.Random().nextInt();
        this.sendThread = new ProducerSendThread<T>(new StringBuilder().append((Object)"ProducerSendThread-").append(BoxesRunTime.boxToInteger(this.kafka$producer$async$AsyncProducer$$asyncProducerID())).toString(), this.kafka$producer$async$AsyncProducer$$queue(), serializer, producer, eventHandler == null ? new DefaultEventHandler<T>(new ProducerConfig(config.props()), cbkHandler) : eventHandler, cbkHandler, config.queueTime(), config.batchSize(), AsyncProducer$.MODULE$.Shutdown());
        this.sendThread().setDaemon(false);
        Utils$.MODULE$.swallow((Function2<Object, Throwable, BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final AsyncProducer $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Object object, Throwable throwable) {
                this.$outer.logger().warn(object, throwable);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }), (Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final AsyncProducer $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Utils$.MODULE$.registerMBean(new AsyncProducerQueueSizeStats<T>(this.$outer.kafka$producer$async$AsyncProducer$$queue()), new StringBuilder().append((Object)AsyncProducer$.MODULE$.ProducerQueueSizeMBeanName()).append((Object)"-").append(BoxesRunTime.boxToInteger(this.$outer.kafka$producer$async$AsyncProducer$$asyncProducerID())).toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
    }

    public AsyncProducer(AsyncProducerConfig config) {
        this(config, new SyncProducer(config), (Encoder)Utils$.MODULE$.getObject(config.serializerClass()), (EventHandler)Utils$.MODULE$.getObject(config.eventHandler()), config.eventHandlerProps(), (CallbackHandler)Utils$.MODULE$.getObject(config.cbkHandler()), config.cbkHandlerProps());
    }
}

