/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.util.Properties;
import kafka.common.InvalidConfigException;
import kafka.message.CompressionCodec;
import kafka.producer.SyncProducerConfigShared;
import kafka.producer.SyncProducerConfigShared$class;
import kafka.producer.async.AsyncProducerConfigShared;
import kafka.producer.async.AsyncProducerConfigShared$class;
import kafka.utils.Utils$;
import kafka.utils.ZKConfig;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u00194A!\u0001\u0002\u0001\u000f\tq\u0001K]8ek\u000e,'oQ8oM&<'BA\u0002\u0005\u0003!\u0001(o\u001c3vG\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M)\u0001\u0001\u0003\b\u00151A\u0011\u0011\u0002D\u0007\u0002\u0015)\u00111\u0002B\u0001\u0006kRLGn]\u0005\u0003\u001b)\u0011\u0001BW&D_:4\u0017n\u001a\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\t\tQ!Y:z]\u000eL!a\u0005\t\u00033\u0005\u001b\u0018P\\2Qe>$WoY3s\u0007>tg-[4TQ\u0006\u0014X\r\u001a\t\u0003+Yi\u0011AA\u0005\u0003/\t\u0011\u0001dU=oGB\u0013x\u000eZ;dKJ\u001cuN\u001c4jONC\u0017M]3e!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011}\u0001!Q1A\u0005\u0002\u0001\nQ\u0001\u001d:paN,\u0012!\t\t\u0003E\u001dj\u0011a\t\u0006\u0003I\u0015\nA!\u001e;jY*\ta%\u0001\u0003kCZ\f\u0017B\u0001\u0015$\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\tU\u0001\u0011\t\u0011)A\u0005C\u00051\u0001O]8qg\u0002BQ\u0001\f\u0001\u0005\u00025\na\u0001P5oSRtDC\u0001\u00180!\t)\u0002\u0001C\u0003 W\u0001\u0007\u0011\u0005C\u00042\u0001\t\u0007I\u0011\u0001\u001a\u0002\u0015\t\u0014xn[3s\u0019&\u001cH/F\u00014!\t!tG\u0004\u0002\u001ak%\u0011aGG\u0001\u0007!J,G-\u001a4\n\u0005aJ$AB*ue&twM\u0003\u000275!11\b\u0001Q\u0001\nM\n1B\u0019:pW\u0016\u0014H*[:uA!9Q\b\u0001b\u0001\n\u0003q\u0014A\u00038v[J+GO]5fgV\tq\b\u0005\u0002\u001a\u0001&\u0011\u0011I\u0007\u0002\u0004\u0013:$\bBB\"\u0001A\u0003%q(A\u0006ok6\u0014V\r\u001e:jKN\u0004\u0003bB#\u0001\u0005\u0004%\tAM\u0001\u0011a\u0006\u0014H/\u001b;j_:,'o\u00117bgNDaa\u0012\u0001!\u0002\u0013\u0019\u0014!\u00059beRLG/[8oKJ\u001cE.Y:tA!9\u0011\n\u0001b\u0001\n\u0003\u0011\u0014\u0001\u00049s_\u0012,8-\u001a:UsB,\u0007BB&\u0001A\u0003%1'A\u0007qe>$WoY3s)f\u0004X\r\t\u0005\b\u001b\u0002\u0011\r\u0011\"\u0001O\u0003A\u0019w.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7-F\u0001P!\t\u00016+D\u0001R\u0015\t\u0011F!A\u0004nKN\u001c\u0018mZ3\n\u0005Q\u000b&\u0001E\"p[B\u0014Xm]:j_:\u001cu\u000eZ3d\u0011\u00191\u0006\u0001)A\u0005\u001f\u0006\t2m\\7qe\u0016\u001c8/[8o\u0007>$Wm\u0019\u0011\t\u000fa\u0003!\u0019!C\u00013\u0006\u00012m\\7qe\u0016\u001c8/\u001a3U_BL7m]\u000b\u00025B\u00191LX\u001a\u000e\u0003qS!!\u0018\u000e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002`9\n\u00191+Z9\t\r\u0005\u0004\u0001\u0015!\u0003[\u0003E\u0019w.\u001c9sKN\u001cX\r\u001a+pa&\u001c7\u000f\t\u0005\bG\u0002\u0011\r\u0011\"\u0001?\u00035Q8NU3bIJ+GO]5fg\"1Q\r\u0001Q\u0001\n}\naB_6SK\u0006$'+\u001a;sS\u0016\u001c\b\u0005")
public class ProducerConfig
extends ZKConfig
implements AsyncProducerConfigShared,
SyncProducerConfigShared {
    private final Properties props;
    private final String brokerList;
    private final int numRetries;
    private final String partitionerClass;
    private final String producerType;
    private final CompressionCodec compressionCodec;
    private final Seq<String> compressedTopics;
    private final int zkReadRetries;
    private final int bufferSize;
    private final int connectTimeoutMs;
    private final int socketTimeoutMs;
    private final int reconnectInterval;
    private int reconnectTimeInterval;
    private final int maxMessageSize;
    private final int queueTime;
    private final int queueSize;
    private final int enqueueTimeoutMs;
    private final int batchSize;
    private final String serializerClass;
    private final String cbkHandler;
    private final Properties cbkHandlerProps;
    private final String eventHandler;
    private final Properties eventHandlerProps;

    @Override
    public int bufferSize() {
        return this.bufferSize;
    }

    @Override
    public int connectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    @Override
    public int socketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    @Override
    public int reconnectInterval() {
        return this.reconnectInterval;
    }

    @Override
    public int reconnectTimeInterval() {
        return this.reconnectTimeInterval;
    }

    @Override
    public void reconnectTimeInterval_$eq(int n) {
        this.reconnectTimeInterval = n;
    }

    @Override
    public int maxMessageSize() {
        return this.maxMessageSize;
    }

    @Override
    public void kafka$producer$SyncProducerConfigShared$_setter_$bufferSize_$eq(int n) {
        this.bufferSize = n;
    }

    @Override
    public void kafka$producer$SyncProducerConfigShared$_setter_$connectTimeoutMs_$eq(int n) {
        this.connectTimeoutMs = n;
    }

    @Override
    public void kafka$producer$SyncProducerConfigShared$_setter_$socketTimeoutMs_$eq(int n) {
        this.socketTimeoutMs = n;
    }

    @Override
    public void kafka$producer$SyncProducerConfigShared$_setter_$reconnectInterval_$eq(int n) {
        this.reconnectInterval = n;
    }

    @Override
    public void kafka$producer$SyncProducerConfigShared$_setter_$maxMessageSize_$eq(int n) {
        this.maxMessageSize = n;
    }

    @Override
    public int queueTime() {
        return this.queueTime;
    }

    @Override
    public int queueSize() {
        return this.queueSize;
    }

    @Override
    public int enqueueTimeoutMs() {
        return this.enqueueTimeoutMs;
    }

    @Override
    public int batchSize() {
        return this.batchSize;
    }

    @Override
    public String serializerClass() {
        return this.serializerClass;
    }

    @Override
    public String cbkHandler() {
        return this.cbkHandler;
    }

    @Override
    public Properties cbkHandlerProps() {
        return this.cbkHandlerProps;
    }

    @Override
    public String eventHandler() {
        return this.eventHandler;
    }

    @Override
    public Properties eventHandlerProps() {
        return this.eventHandlerProps;
    }

    @Override
    public void kafka$producer$async$AsyncProducerConfigShared$_setter_$queueTime_$eq(int n) {
        this.queueTime = n;
    }

    @Override
    public void kafka$producer$async$AsyncProducerConfigShared$_setter_$queueSize_$eq(int n) {
        this.queueSize = n;
    }

    @Override
    public void kafka$producer$async$AsyncProducerConfigShared$_setter_$enqueueTimeoutMs_$eq(int n) {
        this.enqueueTimeoutMs = n;
    }

    @Override
    public void kafka$producer$async$AsyncProducerConfigShared$_setter_$batchSize_$eq(int n) {
        this.batchSize = n;
    }

    @Override
    public void kafka$producer$async$AsyncProducerConfigShared$_setter_$serializerClass_$eq(String string2) {
        this.serializerClass = string2;
    }

    @Override
    public void kafka$producer$async$AsyncProducerConfigShared$_setter_$cbkHandler_$eq(String string2) {
        this.cbkHandler = string2;
    }

    @Override
    public void kafka$producer$async$AsyncProducerConfigShared$_setter_$cbkHandlerProps_$eq(Properties properties) {
        this.cbkHandlerProps = properties;
    }

    @Override
    public void kafka$producer$async$AsyncProducerConfigShared$_setter_$eventHandler_$eq(String string2) {
        this.eventHandler = string2;
    }

    @Override
    public void kafka$producer$async$AsyncProducerConfigShared$_setter_$eventHandlerProps_$eq(Properties properties) {
        this.eventHandlerProps = properties;
    }

    @Override
    public Properties props() {
        return this.props;
    }

    public String brokerList() {
        return this.brokerList;
    }

    public int numRetries() {
        return this.numRetries;
    }

    public String partitionerClass() {
        return this.partitionerClass;
    }

    public String producerType() {
        return this.producerType;
    }

    public CompressionCodec compressionCodec() {
        return this.compressionCodec;
    }

    public Seq<String> compressedTopics() {
        return this.compressedTopics;
    }

    public int zkReadRetries() {
        return this.zkReadRetries;
    }

    public ProducerConfig(Properties props) {
        this.props = props;
        super(props);
        AsyncProducerConfigShared$class.$init$(this);
        SyncProducerConfigShared$class.$init$(this);
        this.brokerList = Utils$.MODULE$.getString(props, "broker.list", null);
        if (Utils$.MODULE$.propertyExists(this.brokerList())) {
            if (Utils$.MODULE$.getString(props, "partitioner.class", null) != null) {
                throw new InvalidConfigException("partitioner.class cannot be used when broker.list is set");
            }
        }
        this.numRetries = Utils$.MODULE$.getInt(props, "num.retries", 0);
        if (Utils$.MODULE$.propertyExists(this.brokerList()) && Utils$.MODULE$.propertyExists(this.zkConnect())) {
            throw new InvalidConfigException("only one of broker.list and zk.connect can be specified");
        }
        if (Utils$.MODULE$.propertyExists(this.zkConnect()) || Utils$.MODULE$.propertyExists(this.brokerList())) {
            this.partitionerClass = Utils$.MODULE$.getString(props, "partitioner.class", "kafka.producer.DefaultPartitioner");
            this.producerType = Utils$.MODULE$.getString(props, "producer.type", "sync");
            this.compressionCodec = Utils$.MODULE$.getCompressionCodec(props, "compression.codec");
            this.compressedTopics = Utils$.MODULE$.getCSVList(Utils$.MODULE$.getString(props, "compressed.topics", null));
            this.zkReadRetries = Utils$.MODULE$.getInt(props, "zk.read.num.retries", 3);
            return;
        }
        throw new InvalidConfigException("At least one of zk.connect or broker.list must be specified");
    }
}

