/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.ProducerRequest$;
import kafka.cluster.Broker;
import kafka.cluster.Partition;
import kafka.common.InvalidPartitionException;
import kafka.common.NoBrokersForPartitionException;
import kafka.producer.BrokerPartitionInfo;
import kafka.producer.ConfigBrokerPartitionInfo;
import kafka.producer.DefaultPartitioner;
import kafka.producer.Partitioner;
import kafka.producer.ProducerConfig;
import kafka.producer.ProducerData;
import kafka.producer.ProducerPool;
import kafka.producer.ZKBrokerPartitionInfo;
import kafka.producer.async.CallbackHandler;
import kafka.producer.async.EventHandler;
import kafka.serializer.Encoder;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import kafka.utils.ZKConfig;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Mf\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0002\u0015:pIV\u001cWM\u001d\u0006\u0003\u0007\u0011\t\u0001\u0002\u001d:pIV\u001cWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u0001Qc\u0001\u0005+sM!\u0001!C\t\u0018!\tQq\"D\u0001\f\u0015\taQ\"\u0001\u0003mC:<'\"\u0001\b\u0002\t)\fg/Y\u0005\u0003!-\u0011aa\u00142kK\u000e$\bC\u0001\n\u0016\u001b\u0005\u0019\"B\u0001\u000b\u0005\u0003\u0015)H/\u001b7t\u0013\t12CA\u0004M_\u001e<\u0017N\\4\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t=\u0001\u0011\t\u0011)A\u0005?\u000511m\u001c8gS\u001e\u0004\"\u0001I\u0011\u000e\u0003\tI!A\t\u0002\u0003\u001dA\u0013x\u000eZ;dKJ\u001cuN\u001c4jO\"AA\u0005\u0001B\u0001B\u0003%Q%A\u0006qCJ$\u0018\u000e^5p]\u0016\u0014\bc\u0001\u0011'Q%\u0011qE\u0001\u0002\f!\u0006\u0014H/\u001b;j_:,'\u000f\u0005\u0002*U1\u0001A!B\u0016\u0001\u0005\u0004a#!A&\u0012\u00055\u0002\u0004C\u0001\r/\u0013\ty\u0013DA\u0004O_RD\u0017N\\4\u0011\u0005a\t\u0014B\u0001\u001a\u001a\u0005\r\te.\u001f\u0005\ti\u0001\u0011\t\u0011)A\u0005k\u0005a\u0001O]8ek\u000e,'\u000fU8pYB\u0019\u0001E\u000e\u001d\n\u0005]\u0012!\u0001\u0004)s_\u0012,8-\u001a:Q_>d\u0007CA\u0015:\t\u0015Q\u0004A1\u0001-\u0005\u00051\u0006\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\u0002)A|\u0007/\u001e7bi\u0016\u0004&o\u001c3vG\u0016\u0014\bk\\8m!\tAb(\u0003\u0002@3\t9!i\\8mK\u0006t\u0007\u0002C!\u0001\u0005\u0003\u0007I\u0011\u0002\"\u0002'\t\u0014xn[3s!\u0006\u0014H/\u001b;j_:LeNZ8\u0016\u0003\r\u0003\"\u0001\t#\n\u0005\u0015\u0013!a\u0005\"s_.,'\u000fU1si&$\u0018n\u001c8J]\u001a|\u0007\u0002C$\u0001\u0005\u0003\u0007I\u0011\u0002%\u0002/\t\u0014xn[3s!\u0006\u0014H/\u001b;j_:LeNZ8`I\u0015\fHCA%M!\tA\"*\u0003\u0002L3\t!QK\\5u\u0011\u001die)!AA\u0002\r\u000b1\u0001\u001f\u00132\u0011!y\u0005A!A!B\u0013\u0019\u0015\u0001\u00062s_.,'\u000fU1si&$\u0018n\u001c8J]\u001a|\u0007\u0005C\u0003R\u0001\u0011\u0005!+\u0001\u0004=S:LGO\u0010\u000b\u0007'R+fk\u0016-\u0011\t\u0001\u0002\u0001\u0006\u000f\u0005\u0006=A\u0003\ra\b\u0005\u0006IA\u0003\r!\n\u0005\u0006iA\u0003\r!\u000e\u0005\u0006yA\u0003\r!\u0010\u0005\u0006\u0003B\u0003\ra\u0011\u0005\b5\u0002\u0011\r\u0011\"\u0003\\\u0003-A\u0017m]*ikR$wn\u001e8\u0016\u0003q\u0003\"!\u00183\u000e\u0003yS!a\u00181\u0002\r\u0005$x.\\5d\u0015\t\t'-\u0001\u0006d_:\u001cWO\u001d:f]RT!aY\u0007\u0002\tU$\u0018\u000e\\\u0005\u0003Kz\u0013Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0007BB4\u0001A\u0003%A,\u0001\u0007iCN\u001c\u0006.\u001e;e_^t\u0007\u0005C\u0004j\u0001\t\u0007I\u0011\u00026\u0002\rI\fg\u000eZ8n+\u0005Y\u0007C\u00017n\u001b\u0005\u0011\u0017B\u00018c\u0005\u0019\u0011\u0016M\u001c3p[\"1\u0001\u000f\u0001Q\u0001\n-\fqA]1oI>l\u0007\u0005C\u0004s\u0001\t\u0007I\u0011B:\u0002\u0013i\\WI\\1cY\u0016$W#A\u001f\t\rU\u0004\u0001\u0015!\u0003>\u0003)Q8.\u00128bE2,G\r\t\u0005\u0006#\u0002!\ta\u001e\u000b\u0003'bDQA\b<A\u0002}AQ!\u0015\u0001\u0005\u0002i$\u0012bU>}\u0003\u0013\tI\"a\t\t\u000byI\b\u0019A\u0010\t\u000buL\b\u0019\u0001@\u0002\u000f\u0015t7m\u001c3feB!q0!\u00029\u001b\t\t\tAC\u0002\u0002\u0004\u0011\t!b]3sS\u0006d\u0017N_3s\u0013\u0011\t9!!\u0001\u0003\u000f\u0015s7m\u001c3fe\"9\u00111B=A\u0002\u00055\u0011\u0001D3wK:$\b*\u00198eY\u0016\u0014\b#BA\b\u0003+ATBAA\t\u0015\r\t\u0019BA\u0001\u0006CNLhnY\u0005\u0005\u0003/\t\tB\u0001\u0007Fm\u0016tG\u000fS1oI2,'\u000fC\u0004\u0002\u001ce\u0004\r!!\b\u0002\u0015\r\u00147\u000eS1oI2,'\u000fE\u0003\u0002\u0010\u0005}\u0001(\u0003\u0003\u0002\"\u0005E!aD\"bY2\u0014\u0017mY6IC:$G.\u001a:\t\u000b\u0011J\b\u0019A\u0013\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002*\u0005!1/\u001a8e)\rI\u00151\u0006\u0005\t\u0003[\t)\u00031\u0001\u00020\u0005a\u0001O]8ek\u000e,'\u000fR1uCB)\u0001$!\r\u00026%\u0019\u00111G\r\u0003\u0015q\u0012X\r]3bi\u0016$g\bE\u0003!\u0003oA\u0003(C\u0002\u0002:\t\u0011A\u0002\u0015:pIV\u001cWM\u001d#bi\u0006Dq!!\u0010\u0001\t\u0013\ty$\u0001\u0004{WN+g\u000e\u001a\u000b\u0004\u0013\u0006\u0005\u0003\u0002CA\u0017\u0003w\u0001\r!a\f\t\u000f\u0005\u0015\u0003\u0001\"\u0003\u0002H\u0005Q1m\u001c8gS\u001e\u001cVM\u001c3\u0015\u0007%\u000bI\u0005\u0003\u0005\u0002.\u0005\r\u0003\u0019AA\u0018\u0011\u001d\ti\u0005\u0001C\u0005\u0003\u001f\n\u0001dZ3u!\u0006\u0014H/\u001b;j_:d\u0015n\u001d;G_J$v\u000e]5d)\u0011\t\t&!\u001e\u0011\r\u0005M\u00131MA5\u001d\u0011\t)&a\u0018\u000f\t\u0005]\u0013QL\u0007\u0003\u00033R1!a\u0017\u0007\u0003\u0019a$o\\8u}%\t!$C\u0002\u0002be\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002f\u0005\u001d$aA*fc*\u0019\u0011\u0011M\r\u0011\t\u0005-\u0014\u0011O\u0007\u0003\u0003[R1!a\u001c\u0005\u0003\u001d\u0019G.^:uKJLA!a\u001d\u0002n\tI\u0001+\u0019:uSRLwN\u001c\u0005\t\u0003o\nY\u00051\u0001\u00026\u0005\u0011\u0001\u000f\u001a\u0005\b\u0003w\u0002A\u0011BA?\u000319W\r\u001e)beRLG/[8o)\u0019\ty(!\"\u0002\nB\u0019\u0001$!!\n\u0007\u0005\r\u0015DA\u0002J]RDq!a\"\u0002z\u0001\u0007\u0001&A\u0002lKfD\u0001\"a#\u0002z\u0001\u0007\u0011qP\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\t\u000f\u0005=\u0005\u0001\"\u0003\u0002\u0012\u0006Y\u0001O]8ek\u000e,'o\u00112l)\u001dI\u00151SAL\u0003SC\u0001\"!&\u0002\u000e\u0002\u0007\u0011qP\u0001\u0004E&$\u0007\u0002CAM\u0003\u001b\u0003\r!a'\u0002\t!|7\u000f\u001e\t\u0005\u0003;\u000b\u0019KD\u0002\u0019\u0003?K1!!)\u001a\u0003\u0019\u0001&/\u001a3fM&!\u0011QUAT\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011U\r\t\u0011\u0005-\u0016Q\u0012a\u0001\u0003\u007f\nA\u0001]8si\"9\u0011q\u0016\u0001\u0005\u0002\u0005E\u0016!B2m_N,G#A%")
public class Producer<K, V>
implements Logging,
ScalaObject {
    public final ProducerConfig kafka$producer$Producer$$config;
    private final Partitioner<K> partitioner;
    public final ProducerPool<V> kafka$producer$Producer$$producerPool;
    private final boolean populateProducerPool;
    private BrokerPartitionInfo kafka$producer$Producer$$brokerPartitionInfo;
    private final AtomicBoolean hasShutdown;
    private final Random kafka$producer$Producer$$random;
    private final boolean zkEnabled;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        Producer producer = this;
        synchronized (producer) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public final BrokerPartitionInfo kafka$producer$Producer$$brokerPartitionInfo() {
        return this.kafka$producer$Producer$$brokerPartitionInfo;
    }

    private void kafka$producer$Producer$$brokerPartitionInfo_$eq(BrokerPartitionInfo brokerPartitionInfo) {
        this.kafka$producer$Producer$$brokerPartitionInfo = brokerPartitionInfo;
    }

    private AtomicBoolean hasShutdown() {
        return this.hasShutdown;
    }

    public final Random kafka$producer$Producer$$random() {
        return this.kafka$producer$Producer$$random;
    }

    private boolean zkEnabled() {
        return this.zkEnabled;
    }

    public void send(Seq<ProducerData<K, V>> producerData) {
        boolean bl;
        block4: {
            block3: {
                block2: {
                    bl = this.zkEnabled();
                    if (!bl) break block2;
                    this.zkSend(producerData);
                    break block3;
                }
                if (bl) break block4;
                this.configSend(producerData);
            }
            return;
        }
        throw new MatchError(BoxesRunTime.boxToBoolean(bl));
    }

    private void zkSend(Seq<ProducerData<K, V>> producerData) {
        Seq producerPoolRequests = producerData.map(new Serializable(this){
            public static final long serialVersionUID;
            private final Producer $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final ProducerPool.ProducerPoolData<V> apply(ProducerData<K, V> pd) {
                ObjectRef brokerIdPartition$1 = new ObjectRef(None$.MODULE$);
                Option brokerInfoOpt = None$.MODULE$;
                IntRef numRetries$1 = new IntRef(0);
                while (numRetries$1.elem <= this.$outer.kafka$producer$Producer$$config.zkReadRetries() && ((Option)brokerInfoOpt).isEmpty()) {
                    if (numRetries$1.elem > 0) {
                        this.$outer.info((Function0<String>)((Object)new Serializable(this, numRetries$1){
                            public static final long serialVersionUID;
                            private final IntRef numRetries$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return new StringBuilder().append((Object)"Try #").append(BoxesRunTime.boxToInteger(this.numRetries$1.elem)).append((Object)" ZK producer cache is stale. Refreshing it by reading from ZK again").toString();
                            }
                            {
                                this.numRetries$1 = var2_2;
                            }
                        }));
                        this.$outer.kafka$producer$Producer$$brokerPartitionInfo().updateInfo();
                    }
                    Seq<Partition> topicPartitionsList = this.$outer.kafka$producer$Producer$$getPartitionListForTopic(pd);
                    int totalNumPartitions = topicPartitionsList.length();
                    int partitionId = this.$outer.kafka$producer$Producer$$getPartition(pd.getKey(), totalNumPartitions);
                    brokerIdPartition$1.elem = new Some<A>(topicPartitionsList.apply(partitionId));
                    brokerInfoOpt = this.$outer.kafka$producer$Producer$$brokerPartitionInfo().getBrokerInfo(((Partition)((Option)brokerIdPartition$1.elem).get()).brokerId());
                    ++numRetries$1.elem;
                }
                None$ none$ = brokerInfoOpt;
                if (none$ instanceof Some) {
                    Broker broker;
                    Some some = (Some)((Object)none$);
                    Broker brokerInfo$1 = broker = (Broker)some.x();
                    this.$outer.debug((Function0<String>)((Object)new Serializable(this){
                        public static final long serialVersionUID;
                        private final ObjectRef brokerIdPartition$1;
                        private final Broker brokerInfo$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return new StringBuilder().append((Object)"Sending message to broker ").append((Object)this.brokerInfo$1.host()).append((Object)":").append(BoxesRunTime.boxToInteger(this.brokerInfo$1.port())).append((Object)" on partition ").append(BoxesRunTime.boxToInteger(((Partition)((Option)this.brokerIdPartition$1.elem).get()).partId())).toString();
                        }
                        {
                            this.brokerIdPartition$1 = objectRef;
                            this.brokerInfo$1 = broker;
                        }
                    }));
                    return this.$outer.kafka$producer$Producer$$producerPool.getProducerPoolData(pd.getTopic(), new Partition(((Partition)((Option)brokerIdPartition$1.elem).get()).brokerId(), ((Partition)((Option)brokerIdPartition$1.elem).get()).partId()), pd.getData());
                }
                None$ none$2 = None$.MODULE$;
                None$ none$3 = none$;
                if (!(none$2 != null ? !none$2.equals(none$3) : none$3 != null)) {
                    throw new NoBrokersForPartitionException(new StringBuilder().append((Object)"Invalid Zookeeper state. Failed to get partition for topic: ").append((Object)pd.getTopic()).append((Object)" and key: ").append(pd.getKey()).toString());
                }
                throw new MatchError(none$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.kafka$producer$Producer$$producerPool.send(producerPoolRequests);
    }

    private void configSend(Seq<ProducerData<K, V>> producerData) {
        Seq producerPoolRequests = producerData.map(new Serializable(this){
            public static final long serialVersionUID;
            private final Producer $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final ProducerPool.ProducerPoolData<V> apply(ProducerData<K, V> pd) {
                Seq<Partition> topicPartitionsList = this.$outer.kafka$producer$Producer$$getPartitionListForTopic(pd);
                int totalNumPartitions = topicPartitionsList.length();
                int randomBrokerId = this.$outer.kafka$producer$Producer$$random().nextInt(totalNumPartitions);
                Partition brokerIdPartition$2 = (Partition)topicPartitionsList.apply(randomBrokerId);
                Broker brokerInfo$2 = this.$outer.kafka$producer$Producer$$brokerPartitionInfo().getBrokerInfo(brokerIdPartition$2.brokerId()).get();
                this.$outer.debug((Function0<String>)((Object)new Serializable(this, brokerInfo$2){
                    public static final long serialVersionUID;
                    private final Broker brokerInfo$2;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Sending message to broker ").append((Object)this.brokerInfo$2.host()).append((Object)":").append(BoxesRunTime.boxToInteger(this.brokerInfo$2.port())).append((Object)" on a randomly chosen partition").toString();
                    }
                    {
                        this.brokerInfo$2 = var2_2;
                    }
                }));
                int partition2 = ProducerRequest$.MODULE$.RandomPartition();
                this.$outer.debug((Function0<String>)((Object)new Serializable(this){
                    public static final long serialVersionUID;
                    private final Partition brokerIdPartition$2;
                    private final Broker brokerInfo$2;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Sending message to broker ").append((Object)this.brokerInfo$2.host()).append((Object)":").append(BoxesRunTime.boxToInteger(this.brokerInfo$2.port())).append((Object)" on a partition ").append(BoxesRunTime.boxToInteger(this.brokerIdPartition$2.partId())).toString();
                    }
                    {
                        this.brokerIdPartition$2 = partition2;
                        this.brokerInfo$2 = broker;
                    }
                }));
                return this.$outer.kafka$producer$Producer$$producerPool.getProducerPoolData(pd.getTopic(), new Partition(brokerIdPartition$2.brokerId(), partition2), pd.getData());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.kafka$producer$Producer$$producerPool.send(producerPoolRequests);
    }

    /*
     * WARNING - void declaration
     */
    public final Seq<Partition> kafka$producer$Producer$$getPartitionListForTopic(ProducerData<K, V> pd$1) {
        void var2_2;
        this.debug((Function0<String>)((Object)new Serializable(this, pd$1){
            public static final long serialVersionUID;
            private final ProducerData pd$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Getting the number of broker partitions registered for topic: ").append((Object)this.pd$1.getTopic()).toString();
            }
            {
                this.pd$1 = producer;
            }
        }));
        Seq topicPartitionsList$1 = this.kafka$producer$Producer$$brokerPartitionInfo().getBrokerPartitionInfo(pd$1.getTopic()).toSeq();
        this.debug((Function0<String>)((Object)new Serializable(this, pd$1, topicPartitionsList$1){
            public static final long serialVersionUID;
            private final ProducerData pd$1;
            private final Seq topicPartitionsList$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Broker partitions registered for topic: ").append((Object)this.pd$1.getTopic()).append((Object)" = ").append(this.topicPartitionsList$1).toString();
            }
            {
                this.pd$1 = producer;
                this.topicPartitionsList$1 = var3_3;
            }
        }));
        int totalNumPartitions = topicPartitionsList$1.length();
        if (totalNumPartitions == 0) {
            throw new NoBrokersForPartitionException(new StringBuilder().append((Object)"Partition = ").append(pd$1.getKey()).toString());
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final int kafka$producer$Producer$$getPartition(K key, int numPartitions) {
        void var3_3;
        int partition2;
        if (numPartitions <= 0) {
            throw new InvalidPartitionException(new StringBuilder().append((Object)"Invalid number of partitions: ").append(BoxesRunTime.boxToInteger(numPartitions)).append((Object)"\n Valid values are > 0").toString());
        }
        int n = partition2 = key == null ? this.kafka$producer$Producer$$random().nextInt(numPartitions) : this.partitioner.partition(key, numPartitions);
        if (partition2 < 0 || partition2 >= numPartitions) {
            throw new InvalidPartitionException(new StringBuilder().append((Object)"Invalid partition id : ").append(BoxesRunTime.boxToInteger(partition2)).append((Object)"\n Valid values are in the range inclusive [0, ").append(BoxesRunTime.boxToInteger(numPartitions - 1)).append((Object)"]").toString());
        }
        return (int)var3_3;
    }

    public final void kafka$producer$Producer$$producerCbk(int bid, String host, int port) {
        if (this.populateProducerPool) {
            this.kafka$producer$Producer$$producerPool.addProducer(new Broker(bid, host, host, port));
        } else {
            this.debug((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Skipping the callback since populateProducerPool = false";
                }
            }));
        }
    }

    public void close() {
        boolean canShutdown = this.hasShutdown().compareAndSet(false, true);
        if (canShutdown) {
            this.kafka$producer$Producer$$producerPool.close();
            this.kafka$producer$Producer$$brokerPartitionInfo().close();
        }
    }

    public Producer(ProducerConfig config, Partitioner<K> partitioner, ProducerPool<V> producerPool, boolean populateProducerPool, BrokerPartitionInfo brokerPartitionInfo) {
        this.kafka$producer$Producer$$config = config;
        this.partitioner = partitioner;
        this.kafka$producer$Producer$$producerPool = producerPool;
        this.populateProducerPool = populateProducerPool;
        this.kafka$producer$Producer$$brokerPartitionInfo = brokerPartitionInfo;
        Logging$class.$init$(this);
        this.hasShutdown = new AtomicBoolean(false);
        this.kafka$producer$Producer$$random = new Random();
        this.zkEnabled = Utils$.MODULE$.propertyExists(config.zkConnect());
        if (this.kafka$producer$Producer$$brokerPartitionInfo() == null) {
            boolean bl = this.zkEnabled();
            if (bl) {
                Properties zkProps = new Properties();
                zkProps.put("zk.connect", config.zkConnect());
                zkProps.put("zk.sessiontimeout.ms", ((Object)BoxesRunTime.boxToInteger(config.zkSessionTimeoutMs())).toString());
                zkProps.put("zk.connectiontimeout.ms", ((Object)BoxesRunTime.boxToInteger(config.zkConnectionTimeoutMs())).toString());
                zkProps.put("zk.synctime.ms", ((Object)BoxesRunTime.boxToInteger(config.zkSyncTimeMs())).toString());
                this.kafka$producer$Producer$$brokerPartitionInfo_$eq(new ZKBrokerPartitionInfo(new ZKConfig(zkProps), (Function3<Object, String, Object, BoxedUnit>)((Object)new Serializable(this){
                    public static final long serialVersionUID;
                    private final Producer $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(int n, String string2, int n2) {
                        this.$outer.kafka$producer$Producer$$producerCbk(n, string2, n2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                })));
            } else if (!bl) {
                this.kafka$producer$Producer$$brokerPartitionInfo_$eq(new ConfigBrokerPartitionInfo(config));
            } else {
                throw new MatchError(BoxesRunTime.boxToBoolean(bl));
            }
        }
        if (populateProducerPool) {
            Map<Object, Broker> allBrokers = this.kafka$producer$Producer$$brokerPartitionInfo().getAllBrokerInfo();
            allBrokers.foreach(new Serializable(this){
                public static final long serialVersionUID;
                private final Producer $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Tuple2<Object, Broker> b) {
                    this.$outer.kafka$producer$Producer$$producerPool.addProducer(new Broker(b._1$mcI$sp(), b._2().host(), b._2().host(), b._2().port()));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
    }

    public Producer(ProducerConfig config) {
        this(config, (Partitioner)Utils$.MODULE$.getObject(config.partitionerClass()), new ProducerPool(config, (Encoder)Utils$.MODULE$.getObject(config.serializerClass())), true, null);
    }

    public Producer(ProducerConfig config, Encoder<V> encoder2, EventHandler<V> eventHandler, CallbackHandler<V> cbkHandler, Partitioner<K> partitioner) {
        this(config, partitioner == null ? new DefaultPartitioner() : partitioner, new ProducerPool<V>(config, encoder2, eventHandler, cbkHandler), true, null);
    }
}

