/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.io.OutputStream;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.message.DefaultCompressionCodec$;
import kafka.producer.ConsoleProducer;
import kafka.producer.Producer;
import kafka.producer.ProducerConfig;
import kafka.producer.ProducerData;
import kafka.serializer.StringEncoder;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConsoleProducer$
implements ScalaObject {
    public static final ConsoleProducer$ MODULE$;

    static {
        new ConsoleProducer$();
    }

    public void main(String[] args) {
        OptionParser parser$1 = new OptionParser();
        ArgumentAcceptingOptionSpec topicOpt = parser$1.accepts("topic", "REQUIRED: The topic id to produce messages to.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec zkConnectOpt = parser$1.accepts("zookeeper", "REQUIRED: The zookeeper connection string for the kafka zookeeper instance in the form HOST:PORT[/CHROOT].").withRequiredArg().describedAs("connection_string").ofType(String.class);
        OptionSpecBuilder syncOpt = parser$1.accepts("sync", "If set message send requests to the brokers are synchronously, one at a time as they arrive.");
        OptionSpecBuilder compressOpt = parser$1.accepts("compress", "If set, messages batches are sent compressed");
        ArgumentAcceptingOptionSpec batchSizeOpt = parser$1.accepts("batch-size", "Number of messages to send in a single batch if they are not being sent synchronously.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(200), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec sendTimeoutOpt = parser$1.accepts("timeout", "If set and the producer is running in asynchronous mode, this gives the maximum amount of time a message will queue awaiting suffient batch size. The value is given in ms.").withRequiredArg().describedAs("timeout_ms").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(1000L), (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec messageEncoderOpt = parser$1.accepts("message-encoder", "The class name of the message encoder implementation to use.").withRequiredArg().describedAs("encoder_class").ofType(String.class).defaultsTo((Object)StringEncoder.class.getName(), (Object[])new String[0]);
        ArgumentAcceptingOptionSpec messageReaderOpt = parser$1.accepts("line-reader", "The class name of the class to use for reading lines from standard in. By default each line is read as a seperate message.").withRequiredArg().describedAs("reader_class").ofType(String.class).defaultsTo((Object)ConsoleProducer.LineMessageReader.class.getName(), (Object[])new String[0]);
        ArgumentAcceptingOptionSpec propertyOpt = parser$1.accepts("property", "A mechanism to pass user-defined properties in the form key=value to the message reader. This allows custom configuration for a user-defined message reader.").withRequiredArg().describedAs("prop").ofType(String.class);
        OptionSet options$1 = parser$1.parse(args);
        List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{topicOpt, zkConnectOpt})).foreach(new Serializable(parser$1, options$1){
            public static final long serialVersionUID;
            private final OptionParser parser$1;
            private final OptionSet options$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(ArgumentAcceptingOptionSpec<String> arg) {
                if (!this.options$1.has(arg)) {
                    System.err.println(new StringBuilder().append((Object)"Missing required argument \"").append(arg).append((Object)"\"").toString());
                    this.parser$1.printHelpOn((OutputStream)System.err);
                    System.exit(1);
                }
            }
            {
                this.parser$1 = optionParser;
                this.options$1 = optionSet;
            }
        });
        String topic = (String)options$1.valueOf((OptionSpec)topicOpt);
        String zkConnect = (String)options$1.valueOf((OptionSpec)zkConnectOpt);
        boolean sync = options$1.has((OptionSpec)syncOpt);
        boolean compress2 = options$1.has((OptionSpec)compressOpt);
        Integer batchSize = (Integer)options$1.valueOf((OptionSpec)batchSizeOpt);
        Long sendTimeout = (Long)options$1.valueOf((OptionSpec)sendTimeoutOpt);
        String encoderClass = (String)options$1.valueOf((OptionSpec)messageEncoderOpt);
        String readerClass = (String)options$1.valueOf((OptionSpec)messageReaderOpt);
        Properties cmdLineProps = this.parseLineReaderArgs(JavaConversions$.MODULE$.asScalaBuffer(options$1.valuesOf((OptionSpec)propertyOpt)));
        Properties props = new Properties();
        props.put("zk.connect", zkConnect);
        props.put("compression.codec", ((Object)BoxesRunTime.boxToInteger(DefaultCompressionCodec$.MODULE$.codec())).toString());
        props.put("producer.type", sync ? "sync" : "async");
        Object object = options$1.has((OptionSpec)batchSizeOpt) ? props.put("batch.size", batchSize.toString()) : BoxedUnit.UNIT;
        props.put("queue.time", sendTimeout.toString());
        props.put("serializer.class", encoderClass);
        ConsoleProducer.MessageReader reader = (ConsoleProducer.MessageReader)Class.forName(readerClass).newInstance();
        reader.init(System.in, cmdLineProps);
        Producer producer$1 = new Producer(new ProducerConfig(props));
        Runtime.getRuntime().addShutdownHook(new Thread(producer$1){
            private final Producer producer$1;

            public void run() {
                this.producer$1.close();
            }
            {
                this.producer$1 = producer;
            }
        });
        Object message = null;
        do {
            if ((message = reader.readMessage()) == null) continue;
            producer$1.send(Predef$.MODULE$.wrapRefArray((Object[])new ProducerData[]{new ProducerData(topic, message)}));
        } while (message != null);
    }

    /*
     * WARNING - void declaration
     */
    public Properties parseLineReaderArgs(Iterable<String> args) {
        void var3_3;
        Iterable splits = (Iterable)((TraversableLike)((TraversableLike)args.map(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String[] apply(String string2) {
                return string2.split("=");
            }
        }, Iterable$.MODULE$.canBuildFrom())).filterNot(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String[] stringArray) {
                return stringArray == null;
            }
        })).filterNot(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String[] stringArray) {
                return stringArray.length == 0;
            }
        });
        if (!splits.forall(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String[] stringArray) {
                return stringArray.length == 2;
            }
        })) {
            System.err.println(new StringBuilder().append((Object)"Invalid line reader properties: ").append((Object)args.mkString(" ")).toString());
            System.exit(1);
        }
        Properties props$1 = new Properties();
        splits.foreach(new Serializable(props$1){
            public static final long serialVersionUID;
            private final Properties props$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply(String[] a) {
                return this.props$1.put(a[0], a[1]);
            }
            {
                this.props$1 = properties;
            }
        });
        return var3_3;
    }

    private ConsoleProducer$() {
        MODULE$ = this;
    }
}

