/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import kafka.network.InvalidRequestException;
import kafka.network.Receive;
import kafka.network.Receive$class;
import kafka.network.Transmission$class;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u00154Q!\u0001\u0002\u0001\t\u0019\u0011\u0001DQ8v]\u0012,GMQ=uK\n+hMZ3s%\u0016\u001cW-\u001b<f\u0015\t\u0019A!A\u0004oKR<xN]6\u000b\u0003\u0015\tQa[1gW\u0006\u001cB\u0001A\u0004\u0010'A\u0011\u0001\"D\u0007\u0002\u0013)\u0011!bC\u0001\u0005Y\u0006twMC\u0001\r\u0003\u0011Q\u0017M^1\n\u00059I!AB(cU\u0016\u001cG\u000f\u0005\u0002\u0011#5\t!!\u0003\u0002\u0013\u0005\t9!+Z2fSZ,\u0007C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"aC*dC2\fwJ\u00196fGRD\u0001B\u0007\u0001\u0003\u0006\u0004%\t\u0001H\u0001\b[\u0006D8+\u001b>f\u0007\u0001)\u0012!\b\t\u0003)yI!aH\u000b\u0003\u0007%sG\u000f\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003\u001e\u0003!i\u0017\r_*ju\u0016\u0004\u0003\"B\u0012\u0001\t\u0003!\u0013A\u0002\u001fj]&$h\b\u0006\u0002&MA\u0011\u0001\u0003\u0001\u0005\u00065\t\u0002\r!\b\u0005\bQ\u0001\u0011\r\u0011\"\u0003*\u0003)\u0019\u0018N_3Ck\u001a4WM]\u000b\u0002UA\u00111FL\u0007\u0002Y)\u0011QfC\u0001\u0004]&|\u0017BA\u0018-\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u0007c\u0001\u0001\u000b\u0011\u0002\u0016\u0002\u0017ML'0\u001a\"vM\u001a,'\u000f\t\u0005\bg\u0001\u0001\r\u0011\"\u0003*\u00035\u0019wN\u001c;f]R\u0014UO\u001a4fe\"9Q\u0007\u0001a\u0001\n\u00131\u0014!E2p]R,g\u000e\u001e\"vM\u001a,'o\u0018\u0013fcR\u0011qG\u000f\t\u0003)aJ!!O\u000b\u0003\tUs\u0017\u000e\u001e\u0005\bwQ\n\t\u00111\u0001+\u0003\rAH%\r\u0005\u0007{\u0001\u0001\u000b\u0015\u0002\u0016\u0002\u001d\r|g\u000e^3oi\n+hMZ3sA!)1\u0005\u0001C\u0001\u007fQ\tQ\u0005C\u0004B\u0001\u0001\u0007I\u0011\u0001\"\u0002\u0011\r|W\u000e\u001d7fi\u0016,\u0012a\u0011\t\u0003)\u0011K!!R\u000b\u0003\u000f\t{w\u000e\\3b]\"9q\t\u0001a\u0001\n\u0003A\u0015\u0001D2p[BdW\r^3`I\u0015\fHCA\u001cJ\u0011\u001dYd)!AA\u0002\rCaa\u0013\u0001!B\u0013\u0019\u0015!C2p[BdW\r^3!\u0011\u0015i\u0005\u0001\"\u0001*\u0003\u0019\u0011WO\u001a4fe\")q\n\u0001C\u0001!\u0006A!/Z1e\rJ|W\u000e\u0006\u0002\u001e#\")!K\u0014a\u0001'\u000691\r[1o]\u0016d\u0007C\u0001+X\u001b\u0005)&B\u0001,-\u0003!\u0019\u0007.\u00198oK2\u001c\u0018B\u0001-V\u0005M\u0011V-\u00193bE2,')\u001f;f\u0007\"\fgN\\3m\u0011\u0015Q\u0006\u0001\"\u0003\\\u0003I\u0011\u0017\u0010^3Ck\u001a4WM]!mY>\u001c\u0017\r^3\u0015\u0005)b\u0006\"B/Z\u0001\u0004i\u0012\u0001B:ju\u0016D#\u0001A0\u0011\u0005\u0001\u001cW\"A1\u000b\u0005\t$\u0011!B;uS2\u001c\u0018B\u00013b\u00055qwN\u001c;ie\u0016\fGm]1gK\u0002")
public class BoundedByteBufferReceive
implements Receive {
    private final int maxSize;
    private final ByteBuffer sizeBuffer;
    private ByteBuffer contentBuffer;
    private boolean complete;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    public volatile int bitmap$0;

    @Override
    public int readCompletely(ReadableByteChannel channel) {
        return Receive$class.readCompletely(this, channel);
    }

    @Override
    public void expectIncomplete() {
        Transmission$class.expectIncomplete(this);
    }

    @Override
    public void expectComplete() {
        Transmission$class.expectComplete(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        BoundedByteBufferReceive boundedByteBufferReceive = this;
        synchronized (boundedByteBufferReceive) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int maxSize() {
        return this.maxSize;
    }

    private ByteBuffer sizeBuffer() {
        return this.sizeBuffer;
    }

    private ByteBuffer contentBuffer() {
        return this.contentBuffer;
    }

    private void contentBuffer_$eq(ByteBuffer byteBuffer) {
        this.contentBuffer = byteBuffer;
    }

    @Override
    public boolean complete() {
        return this.complete;
    }

    public void complete_$eq(boolean bl) {
        this.complete = bl;
    }

    @Override
    public ByteBuffer buffer() {
        this.expectComplete();
        return this.contentBuffer();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readFrom(ReadableByteChannel channel) {
        void var2_2;
        this.expectIncomplete();
        int read2 = 0;
        if (this.sizeBuffer().remaining() > 0) {
            read2 += Utils$.MODULE$.read(channel, this.sizeBuffer());
        }
        if (this.contentBuffer() == null && !this.sizeBuffer().hasRemaining()) {
            this.sizeBuffer().rewind();
            int size2 = this.sizeBuffer().getInt();
            if (size2 <= 0) {
                throw new InvalidRequestException(Predef$.MODULE$.augmentString("%d is not a valid request size.").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(size2)})));
            }
            if (size2 > this.maxSize()) {
                throw new InvalidRequestException(Predef$.MODULE$.augmentString("Request of length %d is not valid, it is larger than the maximum size of %d bytes.").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(size2), BoxesRunTime.boxToInteger(this.maxSize())})));
            }
            this.contentBuffer_$eq(this.byteBufferAllocate(size2));
        }
        if (this.contentBuffer() != null) {
            read2 = Utils$.MODULE$.read(channel, this.contentBuffer());
            if (!this.contentBuffer().hasRemaining()) {
                this.contentBuffer().rewind();
                this.complete_$eq(true);
            }
        }
        return (int)var2_2;
    }

    private ByteBuffer byteBufferAllocate(int size2) {
        ByteBuffer buffer = null;
        try {
            buffer = ByteBuffer.allocate(size2);
            return buffer;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.logger().error(new StringBuilder().append((Object)"OOME with size ").append(BoxesRunTime.boxToInteger(size2)).toString(), outOfMemoryError);
            throw outOfMemoryError;
        }
    }

    public BoundedByteBufferReceive(int maxSize) {
        this.maxSize = maxSize;
        Logging$class.$init$(this);
        Transmission$class.$init$(this);
        Receive$class.$init$(this);
        this.sizeBuffer = ByteBuffer.allocate(4);
        this.contentBuffer = null;
        this.complete = false;
    }

    public BoundedByteBufferReceive() {
        this(Integer.MAX_VALUE);
    }
}

