/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.nio.ByteBuffer;
import kafka.message.CompressionCodec;
import kafka.message.CompressionCodec$;
import kafka.message.Message$;
import kafka.message.NoCompressionCodec$;
import kafka.utils.Utils$;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ut!B\u0001\u0003\u0011\u000b9\u0011aB'fgN\fw-\u001a\u0006\u0003\u0007\u0011\tq!\\3tg\u0006<WMC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"\u0001C\u0005\u000e\u0003\t1QA\u0003\u0002\t\u0006-\u0011q!T3tg\u0006<WmE\u0002\n\u0019Q\u0001\"!\u0004\n\u000e\u00039Q!a\u0004\t\u0002\t1\fgn\u001a\u0006\u0002#\u0005!!.\u0019<b\u0013\t\u0019bB\u0001\u0004PE*,7\r\u001e\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000fC\u0003\u001c\u0013\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002\u000f!9a$\u0003b\u0001\n\u0003y\u0012!D'bO&\u001cg+\u001a:tS>t\u0017'F\u0001!!\t)\u0012%\u0003\u0002#-\t!!)\u001f;f\u0011\u0019!\u0013\u0002)A\u0005A\u0005qQ*Y4jGZ+'o]5p]F\u0002\u0003b\u0002\u0014\n\u0005\u0004%\taH\u0001\u000e\u001b\u0006<\u0017n\u0019,feNLwN\u001c\u001a\t\r!J\u0001\u0015!\u0003!\u00039i\u0015mZ5d-\u0016\u00148/[8oe\u0001BqAK\u0005C\u0002\u0013\u0005q$A\tDkJ\u0014XM\u001c;NC\u001eL7MV1mk\u0016Da\u0001L\u0005!\u0002\u0013\u0001\u0013AE\"veJ,g\u000e^'bO&\u001cg+\u00197vK\u0002BqAL\u0005C\u0002\u0013\u0005q&A\u0006NC\u001eL7m\u00144gg\u0016$X#\u0001\u0019\u0011\u0005U\t\u0014B\u0001\u001a\u0017\u0005\rIe\u000e\u001e\u0005\u0007i%\u0001\u000b\u0011\u0002\u0019\u0002\u00195\u000bw-[2PM\u001a\u001cX\r\u001e\u0011\t\u000fYJ!\u0019!C\u0001_\u0005YQ*Y4jG2+gn\u001a;i\u0011\u0019A\u0014\u0002)A\u0005a\u0005aQ*Y4jG2+gn\u001a;iA!9!(\u0003b\u0001\n\u0003y\u0013aD!uiJL'-\u001e;f\u001f\u001a47/\u001a;\t\rqJ\u0001\u0015!\u00031\u0003A\tE\u000f\u001e:jEV$Xm\u00144gg\u0016$\b\u0005C\u0004?\u0013\t\u0007I\u0011A\u0018\u0002\u001f\u0005#HO]5ckR,G*\u001a8hi\"Da\u0001Q\u0005!\u0002\u0013\u0001\u0014\u0001E!uiJL'-\u001e;f\u0019\u0016tw\r\u001e5!\u0011\u001d\u0011\u0015B1A\u0005\u0002=\n1cQ8naJ,7o]5p]\u000e{G-Z'bg.Da\u0001R\u0005!\u0002\u0013\u0001\u0014\u0001F\"p[B\u0014Xm]:j_:\u001cu\u000eZ3NCN\\\u0007\u0005C\u0004G\u0013\t\u0007I\u0011A\u0018\u0002\u001b9{7i\\7qe\u0016\u001c8/[8o\u0011\u0019A\u0015\u0002)A\u0005a\u0005qaj\\\"p[B\u0014Xm]:j_:\u0004\u0003\"\u0002&\n\t\u0003Y\u0015!C2sG>3gm]3u)\t\u0001D\nC\u0003N\u0013\u0002\u0007\u0001%A\u0003nC\u001eL7\rC\u0004P\u0013\t\u0007I\u0011A\u0018\u0002\u0013\r\u00138\rT3oORD\u0007BB)\nA\u0003%\u0001'\u0001\u0006De\u000edUM\\4uQ\u0002BQaU\u0005\u0005\u0002Q\u000bQ\u0002]1zY>\fGm\u00144gg\u0016$HC\u0001\u0019V\u0011\u0015i%\u000b1\u0001!\u0011\u00159\u0016\u0002\"\u0001Y\u0003)AW-\u00193feNK'0\u001a\u000b\u0003aeCQ!\u0014,A\u0002\u0001BqaW\u0005C\u0002\u0013\u0005q&A\u0007NS:DU-\u00193feNK'0\u001a\u0005\u0007;&\u0001\u000b\u0011\u0002\u0019\u0002\u001d5Kg\u000eS3bI\u0016\u00148+\u001b>fA\u0019!!B\u0001\u0001`'\rqF\u0002\u0006\u0005\tCz\u0013)\u0019!C\u0001E\u00061!-\u001e4gKJ,\u0012a\u0019\t\u0003I\u001el\u0011!\u001a\u0006\u0003MB\t1A\\5p\u0013\tAWM\u0001\u0006CsR,')\u001e4gKJD\u0001B\u001b0\u0003\u0002\u0003\u0006IaY\u0001\bEV4g-\u001a:!\u0011\u0015Yb\f\"\u0001m)\tig\u000e\u0005\u0002\t=\")\u0011m\u001ba\u0001G\")1D\u0018C\u0005aR!Q.\u001d<|\u0011\u0015\u0011x\u000e1\u0001t\u0003!\u0019\u0007.Z2lgVl\u0007CA\u000bu\u0013\t)hC\u0001\u0003M_:<\u0007\"B<p\u0001\u0004A\u0018!\u00022zi\u0016\u001c\bcA\u000bzA%\u0011!P\u0006\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0006y>\u0004\r!`\u0001\u0011G>l\u0007O]3tg&|gnQ8eK\u000e\u0004\"\u0001\u0003@\n\u0005}\u0014!\u0001E\"p[B\u0014Xm]:j_:\u001cu\u000eZ3d\u0011\u0019Yb\f\"\u0001\u0002\u0004Q)Q.!\u0002\u0002\b!1!/!\u0001A\u0002MDaa^A\u0001\u0001\u0004A\bBB\u000e_\t\u0003\tY\u0001F\u0003n\u0003\u001b\ty\u0001\u0003\u0004x\u0003\u0013\u0001\r\u0001\u001f\u0005\u0007y\u0006%\u0001\u0019A?\t\rmqF\u0011AA\n)\ri\u0017Q\u0003\u0005\u0007o\u0006E\u0001\u0019\u0001=\t\r\u0005ea\f\"\u00010\u0003\u0011\u0019\u0018N_3\t\r\u0005ua\f\"\u00010\u0003-\u0001\u0018-\u001f7pC\u0012\u001c\u0016N_3\t\u000b5sF\u0011A\u0010\t\r\u0005\rb\f\"\u0001 \u0003)\tG\u000f\u001e:jEV$Xm\u001d\u0005\u0007yz#\t!a\n\u0016\u0003uDaA\u001d0\u0005\u0002\u0005-R#A:\t\r\u0005=b\f\"\u0001c\u0003\u001d\u0001\u0018-\u001f7pC\u0012Dq!a\r_\t\u0003\t)$A\u0004jgZ\u000bG.\u001b3\u0016\u0005\u0005]\u0002cA\u000b\u0002:%\u0019\u00111\b\f\u0003\u000f\t{w\u000e\\3b]\"1\u0011q\b0\u0005\u0002=\nab]3sS\u0006d\u0017N_3e'&TX\rC\u0004\u0002Dy#\t!!\u0012\u0002\u0017M,'/[1mSj,Gk\u001c\u000b\u0004G\u0006\u001d\u0003bBA%\u0003\u0003\u0002\raY\u0001\ng\u0016\u0014()\u001e4gKJDq!!\u0014_\t\u0003\ny%\u0001\u0005u_N#(/\u001b8h)\t\t\t\u0006\u0005\u0003\u0002T\u0005ecbA\u000b\u0002V%\u0019\u0011q\u000b\f\u0002\rA\u0013X\rZ3g\u0013\u0011\tY&!\u0018\u0003\rM#(/\u001b8h\u0015\r\t9F\u0006\u0005\b\u0003CrF\u0011IA2\u0003\u0019)\u0017/^1mgR!\u0011qGA3\u0011!\t9'a\u0018A\u0002\u0005%\u0014aA1osB\u0019Q#a\u001b\n\u0007\u00055dCA\u0002B]fDq!!\u001d_\t\u0003\n\u0019(\u0001\u0005iCND7i\u001c3f)\u0005\u0001\u0004")
public class Message
implements ScalaObject {
    private final ByteBuffer buffer;

    public static final int MinHeaderSize() {
        return Message$.MODULE$.MinHeaderSize();
    }

    public static final int headerSize(byte by2) {
        return Message$.MODULE$.headerSize(by2);
    }

    public static final int payloadOffset(byte by2) {
        return Message$.MODULE$.payloadOffset(by2);
    }

    public static final int CrcLength() {
        return Message$.MODULE$.CrcLength();
    }

    public static final int crcOffset(byte by2) {
        return Message$.MODULE$.crcOffset(by2);
    }

    public static final int NoCompression() {
        return Message$.MODULE$.NoCompression();
    }

    public static final int CompressionCodeMask() {
        return Message$.MODULE$.CompressionCodeMask();
    }

    public static final int AttributeLength() {
        return Message$.MODULE$.AttributeLength();
    }

    public static final int AttributeOffset() {
        return Message$.MODULE$.AttributeOffset();
    }

    public static final int MagicLength() {
        return Message$.MODULE$.MagicLength();
    }

    public static final int MagicOffset() {
        return Message$.MODULE$.MagicOffset();
    }

    public static final byte CurrentMagicValue() {
        return Message$.MODULE$.CurrentMagicValue();
    }

    public static final byte MagicVersion2() {
        return Message$.MODULE$.MagicVersion2();
    }

    public static final byte MagicVersion1() {
        return Message$.MODULE$.MagicVersion1();
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    public int size() {
        return this.buffer().limit();
    }

    public int payloadSize() {
        return this.size() - Message$.MODULE$.headerSize(this.magic());
    }

    public byte magic() {
        return this.buffer().get(Message$.MODULE$.MagicOffset());
    }

    public byte attributes() {
        return this.buffer().get(Message$.MODULE$.AttributeOffset());
    }

    public CompressionCodec compressionCodec() {
        CompressionCodec compressionCodec;
        byte by2 = this.magic();
        switch (by2) {
            default: {
                throw new RuntimeException(new StringBuilder().append((Object)"Invalid magic byte ").append(BoxesRunTime.boxToByte(this.magic())).toString());
            }
            case 0: {
                compressionCodec = NoCompressionCodec$.MODULE$;
                break;
            }
            case 1: {
                compressionCodec = CompressionCodec$.MODULE$.getCompressionCodec(this.buffer().get(Message$.MODULE$.AttributeOffset()) & Message$.MODULE$.CompressionCodeMask());
            }
        }
        return compressionCodec;
    }

    public long checksum() {
        return Utils$.MODULE$.getUnsignedInt(this.buffer(), Message$.MODULE$.crcOffset(this.magic()));
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuffer payload() {
        void var1_1;
        ByteBuffer payload = this.buffer().duplicate();
        payload.position(Message$.MODULE$.headerSize(this.magic()));
        payload = payload.slice();
        payload.limit(this.payloadSize());
        payload.rewind();
        return var1_1;
    }

    public boolean isValid() {
        return this.checksum() == Utils$.MODULE$.crc32(this.buffer().array(), this.buffer().position() + this.buffer().arrayOffset() + Message$.MODULE$.payloadOffset(this.magic()), this.payloadSize());
    }

    public int serializedSize() {
        return 4 + this.buffer().limit();
    }

    public ByteBuffer serializeTo(ByteBuffer serBuffer) {
        serBuffer.putInt(this.buffer().limit());
        return serBuffer.put(this.buffer().duplicate());
    }

    public String toString() {
        return Predef$.MODULE$.augmentString("message(magic = %d, attributes = %d, crc = %d, payload = %s)").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToByte(this.magic()), BoxesRunTime.boxToByte(this.attributes()), BoxesRunTime.boxToLong(this.checksum()), this.payload()}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object any) {
        Message message;
        Object object = any;
        if (!(object instanceof Message)) return false;
        Message that = message = (Message)object;
        if (this.size() != that.size()) return false;
        if (this.attributes() != that.attributes()) return false;
        if (this.checksum() != that.checksum()) return false;
        ByteBuffer byteBuffer = this.payload();
        ByteBuffer byteBuffer2 = that.payload();
        if (byteBuffer == null) {
            if (byteBuffer2 != null) {
                return false;
            }
        } else if (!((Object)byteBuffer).equals(byteBuffer2)) return false;
        if (this.magic() != that.magic()) return false;
        return true;
    }

    public int hashCode() {
        return this.buffer().hashCode();
    }

    public Message(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    private Message(long checksum, byte[] bytes, CompressionCodec compressionCodec) {
        this(ByteBuffer.allocate(Message$.MODULE$.headerSize(Message$.MODULE$.CurrentMagicValue()) + bytes.length));
        this.buffer().put(Message$.MODULE$.CurrentMagicValue());
        byte attributes = 0;
        if (compressionCodec.codec() > 0) {
            attributes = (byte)(attributes | Message$.MODULE$.CompressionCodeMask() & compressionCodec.codec());
        }
        this.buffer().put(attributes);
        Utils$.MODULE$.putUnsignedInt(this.buffer(), checksum);
        this.buffer().put(bytes);
        this.buffer().rewind();
    }

    public Message(long checksum, byte[] bytes) {
        this(checksum, bytes, NoCompressionCodec$.MODULE$);
    }

    public Message(byte[] bytes, CompressionCodec compressionCodec) {
        this(Utils$.MODULE$.crc32(bytes), bytes, compressionCodec);
    }

    public Message(byte[] bytes) {
        this(bytes, NoCompressionCodec$.MODULE$);
    }
}

